/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers;

import com.intellij.ide.startup.importSettings.models.BundledLookAndFeel;
import com.intellij.ide.startup.importSettings.models.ILookAndFeel;
import com.intellij.ide.startup.importSettings.models.PluginLookAndFeel;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.models.SettingsPreferencesKind;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.PartialImportPerformer;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ide.ui.laf.darcula.DarculaInstaller;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.StartupUiUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\tH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/LookAndFeelImportPerformer;", "Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/PartialImportPerformer;", "<init>", "()V", "willPerform", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "collectAllRequiredPlugins", "", "Lcom/intellij/openapi/extensions/PluginId;", "patchSettingsAfterPluginInstallation", "pluginIds", "", "perform", "", "project", "Lcom/intellij/openapi/project/Project;", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "performEdt", "intellij.ide.startup.importSettings"})
public final class LookAndFeelImportPerformer
implements PartialImportPerformer {
    @Override
    public boolean willPerform(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings.getPreferences().get(SettingsPreferencesKind.Laf) && settings.getLaf() != null;
    }

    @Override
    @NotNull
    public Set<PluginId> collectAllRequiredPlugins(@NotNull Settings settings) {
        PluginLookAndFeel pluginLookAndFeel;
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        ILookAndFeel iLookAndFeel = settings.getLaf();
        PluginLookAndFeel pluginLookAndFeel2 = pluginLookAndFeel = iLookAndFeel instanceof PluginLookAndFeel ? (PluginLookAndFeel)iLookAndFeel : null;
        if (pluginLookAndFeel != null) {
            PluginLookAndFeel it = pluginLookAndFeel;
            boolean bl = false;
            return SetsKt.setOf((Object)PluginId.Companion.getId(it.getPluginId()));
        }
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Settings patchSettingsAfterPluginInstallation(@NotNull Settings settings, @NotNull Set<String> pluginIds) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
            ILookAndFeel iLookAndFeel = settings.getLaf();
            PluginLookAndFeel pluginLookAndFeel = iLookAndFeel instanceof PluginLookAndFeel ? (PluginLookAndFeel)iLookAndFeel : null;
            if (pluginLookAndFeel == null) break block2;
            PluginLookAndFeel it = pluginLookAndFeel;
            boolean bl = false;
            if (pluginIds.contains(it.getPluginId())) {
                settings.setLaf(BundledLookAndFeel.Companion.fromManager(it.getTransferableId(), it.getInstalledName()));
            } else {
                settings.setLaf(it.getFallback());
            }
        }
        return settings;
    }

    @Override
    public void perform(@Nullable Project project, @NotNull Settings settings, @NotNull ProgressIndicator pi) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
    }

    @Override
    public void performEdt(@Nullable Project project, @NotNull Settings settings) {
        block3: {
            LafManager lafManager;
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            ILookAndFeel iLookAndFeel = settings.getLaf();
            BundledLookAndFeel bundledLookAndFeel = iLookAndFeel instanceof BundledLookAndFeel ? (BundledLookAndFeel)iLookAndFeel : null;
            if (bundledLookAndFeel == null) break block3;
            BundledLookAndFeel it = bundledLookAndFeel;
            boolean bl = false;
            UIThemeLookAndFeelInfo laf = it.getLafInfo();
            boolean wasDark = StartupUiUtil.INSTANCE.isDarkTheme();
            LafManager $this$performEdt_u24lambda_u240_u240 = lafManager = LafManager.getInstance();
            boolean bl2 = false;
            $this$performEdt_u24lambda_u240_u240.setCurrentLookAndFeel(laf, false);
            $this$performEdt_u24lambda_u240_u240.updateUI();
            $this$performEdt_u24lambda_u240_u240.repaintUI();
            boolean isDark = StartupUiUtil.INSTANCE.isDarkTheme();
            if (isDark) {
                DarculaInstaller.install();
            } else if (wasDark) {
                DarculaInstaller.uninstall();
            }
            JBColor.setDark((boolean)isDark);
            IconLoader.setUseDarkIcons((boolean)isDark);
            LafManager.getInstance().updateUI();
            UISettings.Companion.getInstance().fireUISettingsChanged();
        }
    }
}

