/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\t\u001a\u00020\u0005H&J/\u0010\n\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H&J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0017H&J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH&J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u001dH$R\u0012\u0010\u0006\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/AbstractMavenRedundantParentInspection;", "Lcom/intellij/codeInspection/XmlSuppressableInspectionTool;", "<init>", "()V", "getGroupDisplayName", "", "elementName", "getElementName", "()Ljava/lang/String;", "getShortName", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "getXmlTag", "Lcom/intellij/psi/xml/XmlTag;", "projectModel", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "getSelfValue", "getParentValue", "project", "Lcom/intellij/openapi/project/Project;", "supportedForFile", "Lcom/intellij/psi/xml/XmlFile;", "intellij.maven"})
public abstract class AbstractMavenRedundantParentInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    protected abstract String getElementName();

    @NotNull
    public abstract String getShortName();

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        DomFileElement model;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (file2 instanceof XmlFile && file2.isPhysical() && (model = DomManager.getDomManager((Project)file2.getProject()).getFileElement((XmlFile)file2, MavenDomProjectModel.class)) != null) {
            DomElement domElement = model.getRootElement();
            Intrinsics.checkNotNullExpressionValue((Object)domElement, (String)"getRootElement(...)");
            MavenDomProjectModel projectModel = (MavenDomProjectModel)domElement;
            if (!this.supportedForFile((XmlFile)file2)) {
                return null;
            }
            String selfValue = this.getSelfValue(projectModel);
            if (selfValue != null && !(((CharSequence)selfValue).length() == 0)) {
                Project project = ((XmlFile)file2).getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                String parentValue = this.getParentValue(projectModel, project);
                if (Intrinsics.areEqual((Object)selfValue, (Object)parentValue)) {
                    XmlTag xmlTag = this.getXmlTag(projectModel);
                    if (xmlTag == null) {
                        return null;
                    }
                    XmlTag xmlTag2 = xmlTag;
                    LocalQuickFix fix2 = new LocalQuickFix(this){
                        final /* synthetic */ AbstractMavenRedundantParentInspection this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public String getFamilyName() {
                            Object[] objectArray = new Object[]{this.this$0.getElementName()};
                            String string = MavenDomBundle.message("inspection.redundant.element.fix", objectArray);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            return string;
                        }

                        public void applyFix(Project project, ProblemDescriptor descriptor2) {
                            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                            descriptor2.getPsiElement().delete();
                        }
                    };
                    ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[1];
                    Object[] objectArray = new Object[]{this.getElementName()};
                    problemDescriptorArray[0] = manager.createProblemDescriptor((PsiElement)xmlTag2, MavenDomBundle.message("inspection.redundant.element.fix.description", objectArray), fix2, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                    return problemDescriptorArray;
                }
            }
        }
        return null;
    }

    @Nullable
    public abstract XmlTag getXmlTag(@NotNull MavenDomProjectModel var1);

    @Nullable
    public abstract String getSelfValue(@NotNull MavenDomProjectModel var1);

    @Nullable
    public abstract String getParentValue(@NotNull MavenDomProjectModel var1, @NotNull Project var2);

    protected abstract boolean supportedForFile(@NotNull XmlFile var1);
}

