/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.TypedHandlerUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;

final class LtGtTypingUtils {
    private static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{KtTokens.SEMICOLON, KtTokens.LBRACE, KtTokens.RBRACE});

    private LtGtTypingUtils() {
    }

    static void handleKotlinAutoCloseLT(Editor editor) {
        TypedHandlerUtil.handleAfterGenericLT((Editor)editor, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static boolean handleKotlinGTInsert(Editor editor) {
        return TypedHandlerUtil.handleGenericGT((Editor)editor, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static void handleKotlinLTDeletion(Editor editor, int offset) {
        TypedHandlerUtil.handleGenericLTDeletion((Editor)editor, (int)offset, (IElementType)KtTokens.LT, (IElementType)KtTokens.GT, (TokenSet)INVALID_INSIDE_REFERENCE);
    }

    static boolean shouldAutoCloseAngleBracket(int offset, Editor editor) {
        return LtGtTypingUtils.isAfterClassIdentifier(offset, editor) || LtGtTypingUtils.isAfterToken(offset, editor, (KtToken)KtTokens.FUN_KEYWORD);
    }

    private static boolean isAfterClassIdentifier(int offset, Editor editor) {
        HighlighterIterator iterator = editor.getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getStart() > 0) {
            iterator.retreat();
        }
        return TypedHandlerUtil.isClassLikeIdentifier((int)offset, (Editor)editor, (HighlighterIterator)iterator, (IElementType)KtTokens.IDENTIFIER);
    }

    static boolean isAfterToken(int offset, Editor editor, KtToken tokenType) {
        HighlighterIterator iterator = editor.getHighlighter().createIterator(offset);
        if (iterator.atEnd()) {
            return false;
        }
        if (iterator.getStart() > 0) {
            iterator.retreat();
        }
        if (iterator.getTokenType() == KtTokens.WHITE_SPACE && iterator.getStart() > 0) {
            iterator.retreat();
        }
        return iterator.getTokenType() == tokenType;
    }
}

