/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.api;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.impl.ColumnNameGenerator;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.DataColumnInternalKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\r\u001a\u00020\b2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u00030\tj\u0002`\nJ)\u0010\r\u001a\u00020\b\"\u0006\b\u0000\u0010\u000f\u0018\u00012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u00112\b\b\u0002\u0010\u0012\u001a\u00020\bH\u0086\bJ\u001a\u0010\u0013\u001a\u000e\u0012\u0002\b\u0003\u0018\u00010\tj\u0004\u0018\u0001`\n2\u0006\u0010\u0014\u001a\u00020\bJ\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\f\u0012\n\u0012\u0002\b\u00030\tj\u0002`\n0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/dataframe/api/DynamicDataFrameBuilder;", "", "checkDuplicateValues", "", "<init>", "(Z)V", "cols", "", "", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "generator", "Lorg/jetbrains/kotlinx/dataframe/impl/ColumnNameGenerator;", "add", "col", "T", "values", "", "name", "get", "column", "toDataFrame", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "core"})
@SourceDebugExtension(value={"SMAP\nconstructors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 constructors.kt\norg/jetbrains/kotlinx/dataframe/api/DynamicDataFrameBuilder\n+ 2 typeConversions.kt\norg/jetbrains/kotlinx/dataframe/api/TypeConversionsKt\n*L\n1#1,573:1\n329#2,5:574\n*S KotlinDebug\n*F\n+ 1 constructors.kt\norg/jetbrains/kotlinx/dataframe/api/DynamicDataFrameBuilder\n*L\n537#1:574,5\n*E\n"})
public final class DynamicDataFrameBuilder {
    private final boolean checkDuplicateValues;
    @NotNull
    private Map<String, DataColumn<?>> cols;
    @NotNull
    private final ColumnNameGenerator generator;

    public DynamicDataFrameBuilder(boolean checkDuplicateValues) {
        this.checkDuplicateValues = checkDuplicateValues;
        this.cols = new LinkedHashMap();
        this.generator = new ColumnNameGenerator(null, 1, null);
    }

    public /* synthetic */ DynamicDataFrameBuilder(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    @NotNull
    public final String add(@NotNull DataColumn<?> col) {
        Intrinsics.checkNotNullParameter(col, (String)"col");
        String originalName = col.name();
        if (this.checkDuplicateValues && this.generator.contains(originalName) && Intrinsics.areEqual(this.cols.get(originalName), col)) {
            return originalName;
        }
        String uniqueName = ((CharSequence)originalName).length() == 0 ? this.generator.addUnique("untitled") : this.generator.addUnique(originalName);
        DataColumn<?> renamed = !Intrinsics.areEqual((Object)uniqueName, (Object)originalName) ? col.rename(uniqueName) : col;
        this.cols.put(uniqueName, renamed);
        return uniqueName;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> String add(Iterable<? extends T> values, String name) {
        DataColumn dataColumn;
        void $this$toColumn$iv;
        void name$iv;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean $i$f$add = false;
        Iterable<? extends T> iterable = values;
        String string = name;
        Infer infer$iv = Infer.Type;
        boolean $i$f$toColumn = false;
        if (infer$iv == Infer.Type) {
            dataColumn = DataColumn.Companion.createByInference$default(DataColumn.Companion, (String)name$iv, UtilsKt.asList($this$toColumn$iv), null, null, 12, null);
        } else {
            List list = UtilsKt.asList($this$toColumn$iv);
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            dataColumn = DataColumn.Companion.createByType((String)name$iv, list, null, infer$iv);
        }
        return this.add(DataColumnInternalKt.forceResolve(dataColumn));
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ String add$default(DynamicDataFrameBuilder $this, Iterable values, String name, int n, Object object) {
        DataColumn dataColumn;
        void $this$toColumn$iv;
        void name$iv;
        if ((n & 2) != 0) {
            name = "";
        }
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean $i$f$add = false;
        object = values;
        String string = name;
        Infer infer$iv = Infer.Type;
        boolean $i$f$toColumn = false;
        if (infer$iv == Infer.Type) {
            dataColumn = DataColumn.Companion.createByInference$default(DataColumn.Companion, (String)name$iv, UtilsKt.asList($this$toColumn$iv), null, null, 12, null);
        } else {
            List list = UtilsKt.asList($this$toColumn$iv);
            Intrinsics.reifiedOperationMarker((int)6, (String)"T");
            dataColumn = DataColumn.Companion.createByType((String)name$iv, list, null, infer$iv);
        }
        return $this.add(DataColumnInternalKt.forceResolve(dataColumn));
    }

    @Nullable
    public final DataColumn<?> get(@NotNull String column2) {
        Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
        return this.cols.get(column2);
    }

    @NotNull
    public final DataFrame<?> toDataFrame() {
        return ToDataFrameKt.toDataFrameAnyColumn((Iterable)this.cols.values());
    }

    public DynamicDataFrameBuilder() {
        this(false, 1, null);
    }
}

