/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.core.git.renderers;

import com.intellij.settingsSync.core.git.record.ChangeRecord;
import com.intellij.settingsSync.core.git.renderers.SettingsHistoryCellRenderer;
import com.intellij.settingsSync.core.git.table.SettingsHistoryTable;
import com.intellij.settingsSync.core.git.table.SettingsHistoryTableRow;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/settingsSync/core/git/renderers/SettingsHistoryTitleCellRenderer;", "Lcom/intellij/settingsSync/core/git/renderers/SettingsHistoryCellRenderer;", "<init>", "()V", "expandedIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "collapsedIcon", "customizeHistoryCellRenderer", "", "table", "Lcom/intellij/settingsSync/core/git/table/SettingsHistoryTable;", "row", "Lcom/intellij/settingsSync/core/git/table/SettingsHistoryTableRow;", "selected", "", "hasFocus", "rowIndex", "", "intellij.settingsSync.core"})
public final class SettingsHistoryTitleCellRenderer
extends SettingsHistoryCellRenderer {
    @NotNull
    private final Icon expandedIcon;
    @NotNull
    private final Icon collapsedIcon;

    public SettingsHistoryTitleCellRenderer() {
        Icon icon = UIUtil.getTreeExpandedIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getTreeExpandedIcon(...)");
        this.expandedIcon = icon;
        Icon icon2 = UIUtil.getTreeCollapsedIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"getTreeCollapsedIcon(...)");
        this.collapsedIcon = icon2;
    }

    @Override
    public void customizeHistoryCellRenderer(@NotNull SettingsHistoryTable table, @NotNull SettingsHistoryTableRow row, boolean selected, boolean hasFocus, int rowIndex) {
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        if (this.isExpanded(table, row)) {
            this.setIcon(this.expandedIcon);
        } else {
            this.setIcon(this.collapsedIcon);
        }
        this.setIconTextGap(4);
        SimpleTextAttributes titleTextAttributes = null;
        SimpleTextAttributes timeTextAttributes = null;
        if (this.isGreyedOut(table, rowIndex)) {
            this.setIconOpacity(Float.valueOf(0.6f));
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.GRAYED_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"GRAYED_ATTRIBUTES");
            titleTextAttributes = simpleTextAttributes;
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"GRAYED_SMALL_ATTRIBUTES");
            timeTextAttributes = simpleTextAttributes2;
        } else {
            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
            titleTextAttributes = simpleTextAttributes;
            SimpleTextAttributes simpleTextAttributes3 = SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes3, (String)"GRAY_SMALL_ATTRIBUTES");
            timeTextAttributes = simpleTextAttributes3;
        }
        this.appendWithClipping(row.getRecord().getTitle(), titleTextAttributes, SimpleColoredComponent.DefaultFragmentTextClipper.INSTANCE);
        this.append("  ");
        this.appendWithClipping(row.getRecord().getTime(), timeTextAttributes, SimpleColoredComponent.DefaultFragmentTextClipper.INSTANCE);
        if (row.getRecord().getRestored() != null) {
            this.append("  ");
            this.appendWithClipping(row.getRecord().getRestored(), timeTextAttributes, SimpleColoredComponent.DefaultFragmentTextClipper.INSTANCE);
        }
        this.putClientProperty(ExpandableItemsHandler.RENDERER_DISABLED, true);
        int cellWidth = table.getColumnModel().getColumn(1).getWidth();
        if (cellWidth < this.computePreferredSize((boolean)false).width) {
            ChangeRecord record = row.getRecord();
            this.addTooltipTextFragment(new SettingsHistoryCellRenderer.TooltipTextFragment(record.getTitle(), false, false));
            if (record.getRestored() != null) {
                this.addNewLineToTooltip();
                this.addTooltipTextFragment(new SettingsHistoryCellRenderer.TooltipTextFragment(record.getRestored(), true, true));
            }
            this.addNewLineToTooltip();
            this.addTooltipTextFragment(new SettingsHistoryCellRenderer.TooltipTextFragment(record.getTime(), true, true));
            this.setToolTipText(this.buildTooltip());
        }
    }
}

