/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2023 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __ls10_dev_nvldl_ip_h__
#define __ls10_dev_nvldl_ip_h__
/* This file is autogenerated.  Do not edit */
#define NV_NVLDL_TOP               0x00001FFF:0x00000000 /* RW--D */
#define NV_NVLDL_TX                0x000027FF:0x00002000 /* RW--D */
#define NV_NVLDL_RX                0x000037FF:0x00003000 /* RW--D */
#define NV_NVLDL_TOP_LINK_STATE                               0x00000000      /* R--4R */
#define NV_NVLDL_TOP_LINK_STATE_STATE                         7:0             /* R-XVF */
#define NV_NVLDL_TOP_LINK_STATE_STATE_INIT                    0x00000000      /* R---V */
#define NV_NVLDL_TOP_LINK_STATE_STATE_HWPCFG                  0x0000000c      /* R---V */
#define NV_NVLDL_TOP_LINK_STATE_STATE_HWCFG                   0x00000001      /* R---V */
#define NV_NVLDL_TOP_LINK_STATE_STATE_SWCFG                   0x00000002      /* R---V */
#define NV_NVLDL_TOP_LINK_STATE_STATE_ACTIVE                  0x00000003      /* R---V */
#define NV_NVLDL_TOP_LINK_STATE_STATE_FAULT                   0x00000004      /* R---V */
#define NV_NVLDL_TOP_LINK_STATE_STATE_SLEEP                   0x00000005      /* R---V */
#define NV_NVLDL_TOP_LINK_STATE_STATE_RCVY_AC                 0x00000008      /* R---V */
#define NV_NVLDL_TOP_LINK_STATE_STATE_RCVY_RX                 0x0000000a      /* R---V */
#define NV_NVLDL_TOP_LINK_STATE_STATE_TRAIN                   0x0000000b      /* R---V */
#define NV_NVLDL_TOP_LINK_STATE_STATE_TEST                    0x0000000d      /* R---V */
#define NV_NVLDL_TOP_LINK_STATE_AN0_BUSY                      12:12           /* R-XVF */
#define NV_NVLDL_TOP_LINK_STATE_TL_BUSY                       13:13           /* R-XVF */
#define NV_NVLDL_TOP_LINK_STATE_DBG_SUBSTATE                  31:16           /* R-XVF */
#define NV_NVLDL_TOP_INTR                                     0x00000050      /* RW-4R */
#define NV_NVLDL_TOP_INTR_TX_REPLAY                           0:0             /* RWEVF */
#define NV_NVLDL_TOP_INTR_TX_REPLAY_INIT                      0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_TX_RECOVERY_SHORT                   1:1             /* RWEVF */
#define NV_NVLDL_TOP_INTR_TX_RECOVERY_SHORT_INIT              0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_TX_FAULT_RAM                        4:4             /* RWEVF */
#define NV_NVLDL_TOP_INTR_TX_FAULT_RAM_INIT                   0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_TX_FAULT_INTERFACE                  5:5             /* RWEVF */
#define NV_NVLDL_TOP_INTR_TX_FAULT_INTERFACE_INIT             0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_TX_FAULT_SUBLINK_CHANGE             8:8             /* RWEVF */
#define NV_NVLDL_TOP_INTR_TX_FAULT_SUBLINK_CHANGE_INIT        0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_TX_PL_ERROR                         9:9             /* RWEVF */
#define NV_NVLDL_TOP_INTR_TX_PL_ERROR_INIT                    0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_PHY_A                               12:12           /* RWEVF */
#define NV_NVLDL_TOP_INTR_PHY_A_INIT                          0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_PHY_B                               13:13           /* RWEVF */
#define NV_NVLDL_TOP_INTR_PHY_B_INIT                          0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_RX_FAULT_SUBLINK_CHANGE             16:16           /* RWEVF */
#define NV_NVLDL_TOP_INTR_RX_FAULT_SUBLINK_CHANGE_INIT        0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_RX_PL_ERROR                         17:17           /* RWEVF */
#define NV_NVLDL_TOP_INTR_RX_PL_ERROR_INIT                    0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_RX_FAULT_DL_PROTOCOL                20:20           /* RWEVF */
#define NV_NVLDL_TOP_INTR_RX_FAULT_DL_PROTOCOL_INIT           0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_RX_SHORT_ERROR_RATE                 21:21           /* RWEVF */
#define NV_NVLDL_TOP_INTR_RX_SHORT_ERROR_RATE_INIT            0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_RX_LONG_ERROR_RATE                  22:22           /* RWEVF */
#define NV_NVLDL_TOP_INTR_RX_LONG_ERROR_RATE_INIT             0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_RX_ILA_TRIGGER                      23:23           /* RWEVF */
#define NV_NVLDL_TOP_INTR_RX_ILA_TRIGGER_INIT                 0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_RX_CRC_COUNTER                      24:24           /* RWEVF */
#define NV_NVLDL_TOP_INTR_RX_CRC_COUNTER_INIT                 0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_LTSSM_FAULT_DOWN                    27:27           /* RWEVF */
#define NV_NVLDL_TOP_INTR_LTSSM_FAULT_DOWN_INIT               0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_LTSSM_FAULT_UP                      28:28           /* RWEVF */
#define NV_NVLDL_TOP_INTR_LTSSM_FAULT_UP_INIT                 0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_LTSSM_PROTOCOL                      29:29           /* RWEVF */
#define NV_NVLDL_TOP_INTR_LTSSM_PROTOCOL_INIT                 0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_MINION_REQUEST                      30:30           /* RWEVF */
#define NV_NVLDL_TOP_INTR_MINION_REQUEST_INIT                 0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2                                 0x00000054      /* RW-4R */
#define NV_NVLDL_TOP_INTR_SW2_TX_REPLAY                       0:0             /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_TX_REPLAY_INIT                  0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_TX_RECOVERY_SHORT               1:1             /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_TX_RECOVERY_SHORT_INIT          0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_TX_FAULT_RAM                    4:4             /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_TX_FAULT_RAM_INIT               0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_TX_FAULT_INTERFACE              5:5             /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_TX_FAULT_INTERFACE_INIT         0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_TX_FAULT_SUBLINK_CHANGE         8:8             /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_TX_FAULT_SUBLINK_CHANGE_INIT    0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_TX_PL_ERROR                     9:9             /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_TX_PL_ERROR_INIT                0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_PHY_A                           12:12           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_PHY_A_INIT                      0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_PHY_B                           13:13           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_PHY_B_INIT                      0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_RX_FAULT_SUBLINK_CHANGE         16:16           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_RX_FAULT_SUBLINK_CHANGE_INIT    0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_RX_PL_ERROR                     17:17           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_RX_PL_ERROR_INIT                0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_RX_FAULT_DL_PROTOCOL            20:20           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_RX_FAULT_DL_PROTOCOL_INIT       0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_RX_SHORT_ERROR_RATE             21:21           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_RX_SHORT_ERROR_RATE_INIT        0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_RX_LONG_ERROR_RATE              22:22           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_RX_LONG_ERROR_RATE_INIT         0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_RX_ILA_TRIGGER                  23:23           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_RX_ILA_TRIGGER_INIT             0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_RX_CRC_COUNTER                  24:24           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_RX_CRC_COUNTER_INIT             0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_LTSSM_FAULT_DOWN                27:27           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_LTSSM_FAULT_DOWN_INIT           0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_LTSSM_FAULT_UP                  28:28           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_LTSSM_FAULT_UP_INIT             0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_LTSSM_PROTOCOL                  29:29           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_LTSSM_PROTOCOL_INIT             0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_SW2_MINION_REQUEST                  30:30           /* RWEVF */
#define NV_NVLDL_TOP_INTR_SW2_MINION_REQUEST_INIT             0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN                            0x00000058      /* RW-4R */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_REPLAY                  0:0             /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_REPLAY_DISABLE          0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_RECOVERY_SHORT          1:1             /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_RECOVERY_SHORT_DISABLE  0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_RECOVERY_SHORT_ENABLE   0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_FAULT_RAM               4:4             /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_FAULT_RAM_DISABLE       0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_FAULT_RAM_ENABLE        0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_FAULT_INTERFACE         5:5             /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_FAULT_INTERFACE_DISABLE 0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_FAULT_INTERFACE_ENABLE  0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_FAULT_SUBLINK_CHANGE    8:8             /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_FAULT_SUBLINK_CHANGE_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_FAULT_SUBLINK_CHANGE_ENABLE 0x00000001  /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_PL_ERROR                9:9             /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_PL_ERROR_DISABLE        0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_TX_PL_ERROR_ENABLE         0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_PHY_A                      12:12           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_PHY_A_DISABLE              0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_PHY_A_ENABLE               0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_PHY_B                      13:13           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_PHY_B_DISABLE              0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_PHY_B_ENABLE               0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_FAULT_SUBLINK_CHANGE    16:16           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_FAULT_SUBLINK_CHANGE_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_FAULT_SUBLINK_CHANGE_ENABLE 0x00000001  /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_PL_ERROR                17:17           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_PL_ERROR_DISABLE        0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_PL_ERROR_ENABLE         0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_FAULT_DL_PROTOCOL       20:20           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_FAULT_DL_PROTOCOL_DISABLE 0x00000000    /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_FAULT_DL_PROTOCOL_ENABLE 0x00000001     /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_SHORT_ERROR_RATE        21:21           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_SHORT_ERROR_RATE_DISABLE 0x00000000     /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_SHORT_ERROR_RATE_ENABLE 0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_LONG_ERROR_RATE         22:22           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_LONG_ERROR_RATE_DISABLE 0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_LONG_ERROR_RATE_ENABLE  0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_ILA_TRIGGER             23:23           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_ILA_TRIGGER_DISABLE     0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_ILA_TRIGGER_ENABLE      0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_CRC_COUNTER             24:24           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_CRC_COUNTER_DISABLE     0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_RX_CRC_COUNTER_ENABLE      0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_LTSSM_FAULT_DOWN           27:27           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_LTSSM_FAULT_DOWN_DISABLE   0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_LTSSM_FAULT_DOWN_ENABLE    0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_LTSSM_FAULT_UP             28:28           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_LTSSM_FAULT_UP_DISABLE     0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_LTSSM_FAULT_UP_ENABLE      0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_LTSSM_PROTOCOL             29:29           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_LTSSM_PROTOCOL_DISABLE     0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_LTSSM_PROTOCOL_ENABLE      0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_STALL_EN_MINION_REQUEST             30:30           /* RWEVF */
#define NV_NVLDL_TOP_INTR_STALL_EN_MINION_REQUEST_DISABLE     0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_STALL_EN_MINION_REQUEST_ENABLE      0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN                         0x0000005c      /* RW-4R */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_REPLAY               0:0             /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_REPLAY_DISABLE       0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_RECOVERY_SHORT       1:1             /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_RECOVERY_SHORT_DISABLE 0x00000000    /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_RECOVERY_SHORT_ENABLE 0x00000001     /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_FAULT_RAM            4:4             /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_FAULT_RAM_DISABLE    0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_FAULT_RAM_ENABLE     0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_FAULT_INTERFACE      5:5             /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_FAULT_INTERFACE_DISABLE 0x00000000   /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_FAULT_INTERFACE_ENABLE 0x00000001    /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_FAULT_SUBLINK_CHANGE 8:8             /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_FAULT_SUBLINK_CHANGE_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_FAULT_SUBLINK_CHANGE_ENABLE 0x00000001 /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_PL_ERROR             9:9             /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_PL_ERROR_DISABLE     0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_TX_PL_ERROR_ENABLE      0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_PHY_A                   12:12           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_PHY_A_DISABLE           0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_PHY_A_ENABLE            0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_PHY_B                   13:13           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_PHY_B_DISABLE           0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_PHY_B_ENABLE            0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_FAULT_SUBLINK_CHANGE 16:16           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_FAULT_SUBLINK_CHANGE_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_FAULT_SUBLINK_CHANGE_ENABLE 0x00000001 /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_PL_ERROR             17:17           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_PL_ERROR_DISABLE     0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_PL_ERROR_ENABLE      0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_FAULT_DL_PROTOCOL    20:20           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_FAULT_DL_PROTOCOL_DISABLE 0x00000000 /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_FAULT_DL_PROTOCOL_ENABLE 0x00000001  /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_SHORT_ERROR_RATE     21:21           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_SHORT_ERROR_RATE_DISABLE 0x00000000  /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_SHORT_ERROR_RATE_ENABLE 0x00000001   /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_LONG_ERROR_RATE      22:22           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_LONG_ERROR_RATE_DISABLE 0x00000000   /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_LONG_ERROR_RATE_ENABLE 0x00000001    /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_ILA_TRIGGER          23:23           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_ILA_TRIGGER_DISABLE  0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_ILA_TRIGGER_ENABLE   0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_CRC_COUNTER          24:24           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_CRC_COUNTER_DISABLE  0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_RX_CRC_COUNTER_ENABLE   0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_LTSSM_FAULT_DOWN        27:27           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_LTSSM_FAULT_DOWN_DISABLE 0x00000000     /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_LTSSM_FAULT_DOWN_ENABLE 0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_LTSSM_FAULT_UP          28:28           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_LTSSM_FAULT_UP_DISABLE  0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_LTSSM_FAULT_UP_ENABLE   0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_LTSSM_PROTOCOL          29:29           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_LTSSM_PROTOCOL_DISABLE  0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_LTSSM_PROTOCOL_ENABLE   0x00000001      /* RW--V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_MINION_REQUEST          30:30           /* RWEVF */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_MINION_REQUEST_DISABLE  0x00000000      /* RWE-V */
#define NV_NVLDL_TOP_INTR_NONSTALL_EN_MINION_REQUEST_ENABLE   0x00000001      /* RW--V */
#define NV_NVLDL_TOP_ERROR_COUNT_CTRL                         0x00000080      /* RW-4R */
#define NV_NVLDL_TOP_ERROR_COUNT_CTRL_CLEAR_RECOVERY          2:2             /* -WXVF */
#define NV_NVLDL_TOP_ERROR_COUNT_CTRL_CLEAR_RECOVERY_CLEAR    0x00000001      /* -W--V */
#define NV_NVLDL_TOP_ERROR_COUNT_CTRL_MASK_SEL                21:16           /* RWEVF */
#define NV_NVLDL_TOP_ERROR_COUNT_CTRL_MASK_SEL_SAFEMODE       0x00000001      /* RW--V */
#define NV_NVLDL_TOP_ERROR_COUNT_CTRL_MASK_SEL_STEADYHS       0x00000002      /* RWE-V */
#define NV_NVLDL_TOP_ERROR_COUNT_CTRL_MASK_SEL_EARLYINITHS    0x00000004      /* RW--V */
#define NV_NVLDL_TOP_ERROR_COUNT_CTRL_MASK_SEL_EARLYL1HS      0x00000008      /* RW--V */
#define NV_NVLDL_TOP_ERROR_COUNT_CTRL_MASK_SEL_EARLYRCVYHS    0x00000010      /* RW--V */
#define NV_NVLDL_TOP_ERROR_COUNT_CTRL_MASK_SEL_RSVD20         0x00000020      /* RW--V */
#define NV_NVLDL_TOP_ERROR_COUNT_CTRL_MASK_DELAY              27:24           /* RWEUF */
#define NV_NVLDL_TOP_ERROR_COUNT_CTRL_MASK_DELAY_INIT         0x00000001      /* RWE-V */
#define NV_NVLDL_TX_SLSM_STATUS_TX                            0x00002024      /* R--4R */
#define NV_NVLDL_TX_SLSM_STATUS_TX_SUBSTATE                   3:0             /* R-XVF */
#define NV_NVLDL_TX_SLSM_STATUS_TX_SUBSTATE_STABLE            0x00000000      /* R---V */
#define NV_NVLDL_TX_SLSM_STATUS_TX_PRIMARY_STATE              7:4             /* R-XVF */
#define NV_NVLDL_TX_SLSM_STATUS_TX_PRIMARY_STATE_HS           0x00000000      /* R---V */
#define NV_NVLDL_TX_SLSM_STATUS_TX_PRIMARY_STATE_TRAIN        0x00000005      /* R---V */
#define NV_NVLDL_TX_SLSM_STATUS_TX_PRIMARY_STATE_SAFE         0x00000006      /* R---V */
#define NV_NVLDL_TX_SLSM_STATUS_TX_PRIMARY_STATE_OFF          0x00000007      /* R---V */
#define NV_NVLDL_TX_SLSM_STATUS_TX_PRIMARY_STATE_TEST         0x00000008      /* R---V */
#define NV_NVLDL_TX_SLSM_STATUS_TX_PRIMARY_STATE_UNKNOWN      0x0000000d      /* R---V */
#define NV_NVLDL_TX_ERROR_COUNT_CTRL                          0x00002280      /* -W-4R */
#define NV_NVLDL_TX_ERROR_COUNT_CTRL_CLEAR_R4_RETRY           0:0             /* -WXVF */
#define NV_NVLDL_TX_ERROR_COUNT_CTRL_CLEAR_R4_RETRY_CLEAR     0x00000001      /* -W--V */
#define NV_NVLDL_TX_ERROR_COUNT_CTRL_CLEAR_REPLAY             8:8             /* -WXVF */
#define NV_NVLDL_TX_ERROR_COUNT_CTRL_CLEAR_REPLAY_CLEAR       0x00000001      /* -W--V */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_0                0x00002e00      /* RW-4R */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_0__PRIV_LEVEL_MASK 0x00002ff4 /*       */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_0_COM_SYMBOL_0   31:0            /* RWEUF */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_0_COM_SYMBOL_0_INIT 0x00000000   /* RWE-V */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_1                0x00002e04      /* RW-4R */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_1__PRIV_LEVEL_MASK 0x00002ff4 /*       */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_1_COM_SYMBOL_1   31:0            /* RWEUF */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_1_COM_SYMBOL_1_INIT 0x00000000   /* RWE-V */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_2                0x00002e08      /* RW-4R */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_2__PRIV_LEVEL_MASK 0x00002ff4 /*       */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_2_SKIP_SYMBOL_0  31:0            /* RWEUF */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_2_SKIP_SYMBOL_0_INIT 0x00000000  /* RWE-V */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_3                0x00002e0c      /* RW-4R */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_3__PRIV_LEVEL_MASK 0x00002ff4 /*       */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_3_SKIP_SYMBOL_1  31:0            /* RWEUF */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_3_SKIP_SYMBOL_1_INIT 0x00000000  /* RWE-V */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_4                0x00002e10      /* RW-4R */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_4__PRIV_LEVEL_MASK 0x00002ff4 /*       */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_4_MASK_COM_OUT   0:0             /* RWEUF */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_4_MASK_COM_OUT_INIT 0x00000001   /* RWE-V */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_4_MASK_SKIP_OUT  1:1             /* RWEUF */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_4_MASK_SKIP_OUT_INIT 0x00000001  /* RWE-V */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_4_SEND_DATA_OUT  2:2             /* RWEUF */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_4_SEND_DATA_OUT_INIT 0x00000001  /* RWE-V */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_4_RESET_WORD_CNT_OUT 11:3        /* RWEUF */
#define NV_NVLDL_TXIOBIST_SKIPCOMINSERTERGEN_4_RESET_WORD_CNT_OUT_INIT 0x00000100 /* RWE-V */
#define NV_NVLDL_TXIOBIST_CONFIG                              0x00002e14      /* RW-4R */
#define NV_NVLDL_TXIOBIST_CONFIG__PRIV_LEVEL_MASK             0x00002ff0    /*       */
#define NV_NVLDL_TXIOBIST_CONFIG_STARTTEST                    0:0             /* RWEUF */
#define NV_NVLDL_TXIOBIST_CONFIG_STARTTEST_INIT               0x00000000      /* RWE-V */
#define NV_NVLDL_TXIOBIST_CONFIG_CFGCLKGATEEN                 1:1             /* RWEUF */
#define NV_NVLDL_TXIOBIST_CONFIG_CFGCLKGATEEN_INIT            0x00000000      /* RWE-V */
#define NV_NVLDL_TXIOBIST_CONFIG_DPG_PRBSSEEDLD               2:2             /* RWEUF */
#define NV_NVLDL_TXIOBIST_CONFIG_DPG_PRBSSEEDLD_INIT          0x00000000      /* RWE-V */
#define NV_NVLDL_TXIOBIST_CONFIG_PRBSALT                      3:3             /* RWEUF */
#define NV_NVLDL_TXIOBIST_CONFIG_PRBSALT_NRZ                  0x00000000      /* RWE-V */
#define NV_NVLDL_TXIOBIST_CONFIG_PRBSALT_PAM4                 0x00000001      /* RW--V */
#define NV_NVLDL_TXIOBIST_CONFIGREG                           0x00002e18      /* RW-4R */
#define NV_NVLDL_TXIOBIST_CONFIGREG__PRIV_LEVEL_MASK          0x00002ff0 /*       */
#define NV_NVLDL_TXIOBIST_CONFIGREG_TX_BIST_EN_IN             2:2             /* RWEUF */
#define NV_NVLDL_TXIOBIST_CONFIGREG_TX_BIST_EN_IN_INIT        0x00000000      /* RWE-V */
#define NV_NVLDL_TXIOBIST_CONFIGREG_DISABLE_WIRED_ENABLE_IN   3:3             /* RWEUF */
#define NV_NVLDL_TXIOBIST_CONFIGREG_DISABLE_WIRED_ENABLE_IN_INIT 0x00000000   /* RWE-V */
#define NV_NVLDL_TXIOBIST_CONFIGREG_IO_BIST_MODE_IN           17:17           /* RWEUF */
#define NV_NVLDL_TXIOBIST_CONFIGREG_IO_BIST_MODE_IN_INIT      0x00000000      /* RWE-V */
#define NV_NVLDL_RX_SLSM_STATUS_RX                            0x00003014      /* R--4R */
#define NV_NVLDL_RX_SLSM_STATUS_RX_SUBSTATE                   3:0             /* R-EVF */
#define NV_NVLDL_RX_SLSM_STATUS_RX_SUBSTATE_STABLE            0x00000000      /* R-E-V */
#define NV_NVLDL_RX_SLSM_STATUS_RX_PRIMARY_STATE              7:4             /* R-XVF */
#define NV_NVLDL_RX_SLSM_STATUS_RX_PRIMARY_STATE_HS           0x00000000      /* R---V */
#define NV_NVLDL_RX_SLSM_STATUS_RX_PRIMARY_STATE_TRAIN        0x00000005      /* R---V */
#define NV_NVLDL_RX_SLSM_STATUS_RX_PRIMARY_STATE_SAFE         0x00000006      /* R---V */
#define NV_NVLDL_RX_SLSM_STATUS_RX_PRIMARY_STATE_OFF          0x00000007      /* R---V */
#define NV_NVLDL_RX_SLSM_STATUS_RX_PRIMARY_STATE_TEST         0x00000008      /* R---V */
#define NV_NVLDL_RX_SLSM_STATUS_RX_PRIMARY_STATE_UNKNOWN      0x0000000d      /* R---V */
#define NV_NVLDL_RX_SLSM_STATUS_RX_PRIMARY_STATE_FAULT        0x0000000e      /* R---V */
#define NV_NVLDL_RX_SLSM_STATUS_RX_UNEXPECTED_REMOTE_STATE_CNT 15:8           /* R-EVF */
#define NV_NVLDL_RX_SLSM_STATUS_RX_UNEXPECTED_REMOTE_STATE_CNT_INIT 0x00000000 /* R-E-V */
#define NV_NVLDL_RX_SLSM_STATUS_RX_FENCE_STATUS               31:31           /* R-EVF */
#define NV_NVLDL_RX_SLSM_STATUS_RX_FENCE_STATUS_OFF           0x00000000      /* R-E-V */
#define NV_NVLDL_RX_SLSM_STATUS_RX_FENCE_STATUS_ON            0x00000001      /* R---V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL                           0x00003028      /* RW-4R */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_CONST_DET_ERR             1:1             /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_CONST_DET_ERR_OFF         0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_CONST_DET_ERR_ON          0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_OFF2SAFE_LINK_DET_ERR     2:2             /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_OFF2SAFE_LINK_DET_ERR_OFF 0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_OFF2SAFE_LINK_DET_ERR_ON  0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SAFE_FINISH_ERR           3:3             /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SAFE_FINISH_ERR_OFF       0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SAFE_FINISH_ERR_ON        0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SCRAM_LOCK_ERR            4:4             /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SCRAM_LOCK_ERR_OFF        0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SCRAM_LOCK_ERR_ON         0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SYM_LOCK_ERR              5:5             /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SYM_LOCK_ERR_OFF          0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SYM_LOCK_ERR_ON           0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SYM_ALIGN_END_ERR         6:6             /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SYM_ALIGN_END_ERR_OFF     0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SYM_ALIGN_END_ERR_ON      0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_FIFO_SKEW_ERR             7:7             /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_FIFO_SKEW_ERR_OFF         0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_FIFO_SKEW_ERR_ON          0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_TRAIN2SAFE_LINK_DET_ERR   8:8             /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_TRAIN2SAFE_LINK_DET_ERR_OFF 0x00000000    /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_TRAIN2SAFE_LINK_DET_ERR_ON 0x00000001     /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_HS2SAFE_LINK_DET_ERR      9:9             /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_HS2SAFE_LINK_DET_ERR_OFF  0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_HS2SAFE_LINK_DET_ERR_ON   0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_FENCE_ERR                 10:10           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_FENCE_ERR_OFF             0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_FENCE_ERR_ON              0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_FAULT2SAFE_LINK_DET_ERR   11:11           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_FAULT2SAFE_LINK_DET_ERR_OFF 0x00000000    /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_FAULT2SAFE_LINK_DET_ERR_ON 0x00000001     /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_FAULT2SAFE_SAFE_DET_ERR   12:12           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_FAULT2SAFE_SAFE_DET_ERR_OFF 0x00000000    /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_FAULT2SAFE_SAFE_DET_ERR_ON 0x00000001     /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SAFE_RETRY_ERR            13:13           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SAFE_RETRY_ERR_OFF        0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_SAFE_RETRY_ERR_ON         0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_RC_DEADLINE_ERR           15:15           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_RC_DEADLINE_ERR_OFF       0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_RC_DEADLINE_ERR_ON        0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_IOBIST_ECC_ALIGN_DONE_ERR 16:16           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_IOBIST_ECC_ALIGN_DONE_ERR_OFF 0x00000000  /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_IOBIST_ECC_ALIGN_DONE_ERR_ON 0x00000001   /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_O2S_SD_NO_LD_ERR          18:18           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_O2S_SD_NO_LD_ERR_OFF      0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_O2S_SD_NO_LD_ERR_ON       0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_H2S_SD_NO_LD_ERR          19:19           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_H2S_SD_NO_LD_ERR_OFF      0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_H2S_SD_NO_LD_ERR_ON       0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_O2S_STROBE_NO_SD_ERR      21:21           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_O2S_STROBE_NO_SD_ERR_OFF  0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_O2S_STROBE_NO_SD_ERR_ON   0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_H2S_STROBE_NO_SD_ERR      22:22           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_H2S_STROBE_NO_SD_ERR_OFF  0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_H2S_STROBE_NO_SD_ERR_ON   0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_HS2SAFE_SAFE_DET_ERR      24:24           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_HS2SAFE_SAFE_DET_ERR_OFF  0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_HS2SAFE_SAFE_DET_ERR_ON   0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_TRAIN2SAFE_SAFE_DET_ERR   25:25           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_TRAIN2SAFE_SAFE_DET_ERR_OFF 0x00000000    /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_TRAIN2SAFE_SAFE_DET_ERR_ON 0x00000001     /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_S2S_SAFE_DET_ERR          26:26           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_S2S_SAFE_DET_ERR_OFF      0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_S2S_SAFE_DET_ERR_ON       0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_OFF2SAFE_SAFE_DET_ERR     27:27           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_OFF2SAFE_SAFE_DET_ERR_OFF 0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_OFF2SAFE_SAFE_DET_ERR_ON  0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_L2_FENCE_ERR              29:29           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_L2_FENCE_ERR_OFF          0x00000000      /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_L2_FENCE_ERR_ON           0x00000001      /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_IOBIST_ECC_SCRAM_LOCK_ERR 30:30           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_IOBIST_ECC_SCRAM_LOCK_ERR_OFF 0x00000000  /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_IOBIST_ECC_SCRAM_LOCK_ERR_ON 0x00000001   /* RW--V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_IOBIST_ECC_ALIGN_LOCK_ERR 31:31           /* RWEVF */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_IOBIST_ECC_ALIGN_LOCK_ERR_OFF 0x00000000  /* RWE-V */
#define NV_NVLDL_RX_RXSLSM_ERR_CNTL_IOBIST_ECC_ALIGN_LOCK_ERR_ON 0x00000001   /* RW--V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL                          0x00003280      /* RW-4R */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_FLIT_CRC           0:0             /* -WEVF */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_FLIT_CRC_INIT      0x00000000      /* -WE-V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_FLIT_CRC_CLEAR     0x00000001      /* -W--V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_LANE_CRC           1:1             /* -WEVF */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_LANE_CRC_INIT      0x00000000      /* -WE-V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_LANE_CRC_CLEAR     0x00000001      /* -W--V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_RATES              2:2             /* -WEVF */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_RATES_INIT         0x00000000      /* -WE-V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_RATES_CLEAR        0x00000001      /* -W--V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_REPLAY             3:3             /* -WEVF */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_REPLAY_INIT        0x00000000      /* -WE-V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_REPLAY_CLEAR       0x00000001      /* -W--V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_ECC_COUNTS         4:4             /* -WEVF */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_ECC_COUNTS_INIT    0x00000000      /* -WE-V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_CLEAR_ECC_COUNTS_CLEAR   0x00000001      /* -W--V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_SHORT_RATE               8:8             /* RWEVF */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_SHORT_RATE_ENABLE        0x00000001      /* RWE-V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_SHORT_RATE_DISABLE       0x00000000      /* RW--V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_LONG_RATE                9:9             /* RWEVF */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_LONG_RATE_ENABLE         0x00000001      /* RWE-V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_LONG_RATE_DISABLE        0x00000000      /* RW--V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_RATE_COUNT_MODE          10:10           /* RWEVF */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_RATE_COUNT_MODE_FLIT     0x00000000      /* RWE-V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_RATE_COUNT_MODE_SEQUENCE 0x00000001      /* RW--V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_FLIT_COUNT_MODE          11:11           /* RWEVF */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_FLIT_COUNT_MODE_FLIT     0x00000000      /* RW--V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_FLIT_COUNT_MODE_SEQUENCE 0x00000001      /* RWE-V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_RATE_COUNT_SRC           13:12           /* RWEVF */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_RATE_COUNT_SRC_FLITCRC   0x00000000      /* RWE-V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_RATE_COUNT_SRC_ECCFAIL   0x00000001      /* RW--V */
#define NV_NVLDL_RX_ERROR_COUNT_CTRL_RATE_COUNT_SRC_ECCCORR   0x00000002      /* RW--V */
#define NV_NVLDL_RX_ERROR_RATE_CTRL                           0x00003284      /* RW-4R */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_SHORT_THRESHOLD_MAN       2:0             /* RWEUF */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_SHORT_THRESHOLD_MAN_INIT  0x00000001      /* RWE-V */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_SHORT_THRESHOLD_EXP       3:3             /* RWEUF */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_SHORT_THRESHOLD_EXP_INIT  0x00000000      /* RWE-V */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_SHORT_TIMESCALE_MAN       6:4             /* RWEUF */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_SHORT_TIMESCALE_MAN_INIT  0x00000000      /* RWE-V */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_SHORT_TIMESCALE_EXP       11:8            /* RWEUF */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_SHORT_TIMESCALE_EXP_INIT  0x00000006      /* RWE-V */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_LONG_THRESHOLD_MAN        18:16           /* RWEUF */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_LONG_THRESHOLD_MAN_INIT   0x00000001      /* RWE-V */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_LONG_THRESHOLD_EXP        19:19           /* RWEUF */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_LONG_THRESHOLD_EXP_INIT   0x00000000      /* RWE-V */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_LONG_TIMESCALE_MAN        22:20           /* RWEUF */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_LONG_TIMESCALE_MAN_INIT   0x00000000      /* RWE-V */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_LONG_TIMESCALE_EXP        28:24           /* RWEUF */
#define NV_NVLDL_RX_ERROR_RATE_CTRL_LONG_TIMESCALE_EXP_INIT   0x00000006      /* RWE-V */
#endif // __ls10_dev_nvldl_ip_h__
