/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.backend.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItem;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/platform/navbar/backend/impl/OrderEntryNavBarItem;", "Lcom/intellij/platform/navbar/backend/impl/DefaultNavBarItem;", "Lcom/intellij/openapi/roots/OrderEntry;", "data", "<init>", "(Lcom/intellij/openapi/roots/OrderEntry;)V", "getIcon", "Ljavax/swing/Icon;", "intellij.platform.navbar.backend"})
@SourceDebugExtension(value={"SMAP\nDefaultNavBarItem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultNavBarItem.kt\ncom/intellij/platform/navbar/backend/impl/OrderEntryNavBarItem\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1#2:253\n*E\n"})
public final class OrderEntryNavBarItem
extends DefaultNavBarItem<OrderEntry> {
    public OrderEntryNavBarItem(@NotNull OrderEntry data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(data);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Icon getIcon() {
        Icon icon;
        OrderEntry orderEntry = (OrderEntry)this.getData();
        if (orderEntry instanceof JdkOrderEntry) {
            Sdk sdk = ((JdkOrderEntry)this.getData()).getJdk();
            SdkTypeId sdkTypeId = sdk != null ? sdk.getSdkType() : null;
            if (!(sdkTypeId instanceof SdkType)) return null;
            SdkType sdkType = (SdkType)sdkTypeId;
            if (sdkType == null) return null;
            icon = sdkType.getIcon();
            return icon;
        } else if (orderEntry instanceof LibraryOrderEntry) {
            icon = AllIcons.Nodes.PpLibFolder;
            return icon;
        } else if (orderEntry instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)this.getData()).getModule();
            Module module2 = module;
            if (module == null) return null;
            Module it = module2;
            boolean bl = false;
            ModuleType moduleType = ModuleType.get((Module)it);
            module2 = moduleType;
            if (moduleType == null) return null;
            icon = module2.getIcon();
            return icon;
        } else {
            icon = super.getIcon();
        }
        return icon;
    }
}

