/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OctalEscapeInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OctalEscapeInspection.$$$reportNull$$$0(0);
        }
        return new OctalEscapeVisitor(holder);
    }

    static String buildReplacementText(RegExpChar aChar) {
        int value = aChar.getValue();
        String hex = Integer.toHexString(value);
        return (hex.length() == 1 ? "\\x0" : "\\x") + hex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/OctalEscapeInspection", "buildVisitor"));
    }

    private static class OctalEscapeVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        OctalEscapeVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar ch) {
            if (ch.getType() != RegExpChar.Type.OCT) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)ch, RegExpBundle.message("inspection.warning.octal.escape.code.ref.code.in.regexp", new Object[0]), new LocalQuickFix[]{new ReplaceWithHexEscapeFix(OctalEscapeInspection.buildReplacementText(ch))});
        }
    }

    private static class ReplaceWithHexEscapeFix
    extends PsiUpdateModCommandQuickFix {
        private final String myHex;

        ReplaceWithHexEscapeFix(String hex) {
            this.myHex = hex;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myHex});
            if (string == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = RegExpBundle.message("inspection.quick.fix.replace.with.hexadecimal.escape", new Object[0]);
            if (string == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithHexEscapeFix.$$$reportNull$$$0(4);
            }
            if (!(element instanceof RegExpChar)) {
                return;
            }
            RegExpChar regExpChar = (RegExpChar)element;
            RegExpReplacementUtil.replaceInContext(element, OctalEscapeInspection.buildReplacementText(regExpChar));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/lang/regexp/inspection/OctalEscapeInspection$ReplaceWithHexEscapeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/lang/regexp/inspection/OctalEscapeInspection$ReplaceWithHexEscapeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

