/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MemberFinder;

public class LambdaExpression {
    public ProgramClass referencedClass;
    public int bootstrapMethodIndex;
    public BootstrapMethodInfo bootstrapMethodInfo;
    public String factoryMethodDescriptor;
    public String[] interfaces;
    public String[] bridgeMethodDescriptors;
    public String interfaceMethod;
    public String interfaceMethodDescriptor;
    public int invokedReferenceKind;
    public String invokedClassName;
    public String invokedMethodName;
    public String invokedMethodDesc;
    public Clazz referencedInvokedClass;
    public Method referencedInvokedMethod;
    public ProgramClass lambdaClass;
    private static final String LAMBDA_METHOD_PREFIX = "lambda$";

    public LambdaExpression(ProgramClass referencedClass, int bootstrapMethodIndex, BootstrapMethodInfo bootstrapMethodInfo, String factoryMethodDescriptor, String[] interfaces, String[] bridgeMethodDescriptors, String interfaceMethod, String interfaceMethodDescriptor, int invokedReferenceKind, String invokedClassName, String invokedMethodName, String invokedMethodDesc, Clazz referencedInvokedClass, Method referencedInvokedMethod) {
        this.referencedClass = referencedClass;
        this.bootstrapMethodIndex = bootstrapMethodIndex;
        this.bootstrapMethodInfo = bootstrapMethodInfo;
        this.factoryMethodDescriptor = factoryMethodDescriptor;
        this.interfaces = interfaces;
        this.bridgeMethodDescriptors = bridgeMethodDescriptors;
        this.interfaceMethod = interfaceMethod;
        this.interfaceMethodDescriptor = interfaceMethodDescriptor;
        this.invokedReferenceKind = invokedReferenceKind;
        this.invokedClassName = invokedClassName;
        this.invokedMethodName = invokedMethodName;
        this.invokedMethodDesc = invokedMethodDesc;
        this.referencedInvokedClass = referencedInvokedClass;
        this.referencedInvokedMethod = referencedInvokedMethod;
    }

    public String getLambdaClassName() {
        return String.format("%s$$Lambda$%d", this.referencedClass.getName(), this.bootstrapMethodIndex);
    }

    public String getConstructorDescriptor() {
        if (this.isStateless()) {
            return "()V";
        }
        int endIndex = this.factoryMethodDescriptor.indexOf(41);
        return this.factoryMethodDescriptor.substring(0, endIndex + 1) + 'V';
    }

    public boolean isSerializable() {
        for (String interfaceName : this.interfaces) {
            if (!"java/io/Serializable".equals(interfaceName)) continue;
            return true;
        }
        return false;
    }

    public boolean isMethodReference() {
        return !LambdaExpression.isLambdaMethod(this.invokedMethodName);
    }

    public boolean isStateless() {
        return ClassUtil.internalMethodParameterCount(this.factoryMethodDescriptor) == 0;
    }

    public boolean invokesStaticInterfaceMethod() {
        return this.invokedReferenceKind == 6 && this.referencedInvokedClass != null && (this.referencedInvokedClass.getAccessFlags() & 0x200) != 0;
    }

    boolean referencesPrivateSyntheticInterfaceMethod() {
        return (this.referencedInvokedClass.getAccessFlags() & 0x200) != 0 && (this.referencedInvokedMethod.getAccessFlags() & 0x1002) != 0;
    }

    public boolean needsAccessorMethod() {
        return this.referencedInvokedClass != null && new MemberFinder().findMethod(this.lambdaClass, this.referencedInvokedClass, this.invokedMethodName, this.invokedMethodDesc) == null;
    }

    public boolean referencesPrivateConstructor() {
        return this.invokedReferenceKind == 8 && "<init>".equals(this.invokedMethodName) && (this.referencedInvokedMethod.getAccessFlags() & 2) != 0;
    }

    private static boolean isLambdaMethod(String methodName) {
        return methodName.startsWith(LAMBDA_METHOD_PREFIX);
    }
}

