/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.jfr;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.file.Paths;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardEmitterMBean;
import jdk.jfr.Configuration;
import jdk.jfr.EventType;
import jdk.jfr.FlightRecorder;
import jdk.jfr.FlightRecorderListener;
import jdk.jfr.FlightRecorderPermission;
import jdk.jfr.Recording;
import jdk.jfr.RecordingState;
import jdk.jfr.internal.management.ManagementSupport;
import jdk.management.jfr.ConfigurationInfo;
import jdk.management.jfr.EventTypeInfo;
import jdk.management.jfr.FlightRecorderMXBean;
import jdk.management.jfr.MBeanUtils;
import jdk.management.jfr.RecordingInfo;
import jdk.management.jfr.StreamManager;

final class FlightRecorderMXBeanImpl
extends StandardEmitterMBean
implements FlightRecorderMXBean,
NotificationEmitter {
    private static final String ATTRIBUTE_RECORDINGS = "Recordings";
    private static final String OPTION_MAX_SIZE = "maxSize";
    private static final String OPTION_MAX_AGE = "maxAge";
    private static final String OPTION_NAME = "name";
    private static final String OPTION_DISK = "disk";
    private static final String OPTION_DUMP_ON_EXIT = "dumpOnExit";
    private static final String OPTION_DURATION = "duration";
    private static final List<String> OPTIONS = Arrays.asList("dumpOnExit", "duration", "name", "maxAge", "maxSize", "disk");
    private final StreamManager streamHandler = new StreamManager();
    private final Map<Long, Object> changes = new ConcurrentHashMap<Long, Object>();
    private final AtomicLong sequenceNumber = new AtomicLong();
    private final List<MXBeanListener> listeners = new CopyOnWriteArrayList<MXBeanListener>();
    private FlightRecorder recorder;

    FlightRecorderMXBeanImpl() {
        super(FlightRecorderMXBean.class, true, (NotificationEmitter)new NotificationBroadcasterSupport(FlightRecorderMXBeanImpl.createNotificationInfo()));
    }

    @Override
    public void startRecording(long l) {
        MBeanUtils.checkControl();
        this.getExistingRecording(l).start();
    }

    @Override
    public boolean stopRecording(long l) {
        MBeanUtils.checkControl();
        return this.getExistingRecording(l).stop();
    }

    @Override
    public void closeRecording(long l) {
        MBeanUtils.checkControl();
        this.getExistingRecording(l).close();
    }

    @Override
    public long openStream(long l, Map<String, String> map) throws IOException {
        MBeanUtils.checkControl();
        if (!FlightRecorder.isInitialized()) {
            throw new IllegalArgumentException("No recording available with id " + l);
        }
        HashMap hashMap = map == null ? new HashMap() : new HashMap<String, String>(map);
        Instant instant = MBeanUtils.parseTimestamp((String)hashMap.get("startTime"), Instant.MIN);
        Instant instant2 = MBeanUtils.parseTimestamp((String)hashMap.get("endTime"), Instant.MAX);
        int n = MBeanUtils.parseBlockSize((String)hashMap.get("blockSize"), 50000);
        InputStream inputStream = this.getExistingRecording(l).getStream(instant, instant2);
        if (inputStream == null) {
            throw new IOException("No recording data available");
        }
        return this.streamHandler.create(inputStream, n).getId();
    }

    @Override
    public void closeStream(long l) throws IOException {
        MBeanUtils.checkControl();
        this.streamHandler.getStream(l).close();
    }

    @Override
    public byte[] readStream(long l) throws IOException {
        MBeanUtils.checkMonitor();
        return this.streamHandler.getStream(l).read();
    }

    @Override
    public List<RecordingInfo> getRecordings() {
        MBeanUtils.checkMonitor();
        if (!FlightRecorder.isInitialized()) {
            return Collections.emptyList();
        }
        return MBeanUtils.transformList(this.getRecorder().getRecordings(), RecordingInfo::new);
    }

    @Override
    public List<ConfigurationInfo> getConfigurations() {
        MBeanUtils.checkMonitor();
        return MBeanUtils.transformList(Configuration.getConfigurations(), ConfigurationInfo::new);
    }

    @Override
    public List<EventTypeInfo> getEventTypes() {
        MBeanUtils.checkMonitor();
        List<EventType> list = AccessController.doPrivileged(new PrivilegedAction<List<EventType>>(){

            @Override
            public List<EventType> run() {
                return ManagementSupport.getEventTypes();
            }
        }, null, new FlightRecorderPermission("accessFlightRecorder"));
        return MBeanUtils.transformList(list, EventTypeInfo::new);
    }

    @Override
    public Map<String, String> getRecordingSettings(long l) throws IllegalArgumentException {
        MBeanUtils.checkMonitor();
        return this.getExistingRecording(l).getSettings();
    }

    @Override
    public void setRecordingSettings(long l, Map<String, String> map) throws IllegalArgumentException {
        Objects.requireNonNull(map);
        MBeanUtils.checkControl();
        this.getExistingRecording(l).setSettings(map);
    }

    @Override
    public long newRecording() {
        MBeanUtils.checkControl();
        this.getRecorder();
        return AccessController.doPrivileged(new PrivilegedAction<Recording>(){

            @Override
            public Recording run() {
                return new Recording();
            }
        }, null, new FlightRecorderPermission("accessFlightRecorder")).getId();
    }

    @Override
    public long takeSnapshot() {
        MBeanUtils.checkControl();
        return this.getRecorder().takeSnapshot().getId();
    }

    @Override
    public void setConfiguration(long l, String string) throws IllegalArgumentException {
        Objects.requireNonNull(string);
        MBeanUtils.checkControl();
        try {
            Configuration configuration = Configuration.create(new StringReader(string));
            this.getExistingRecording(l).setSettings(configuration.getSettings());
        }
        catch (IOException | ParseException exception) {
            throw new IllegalArgumentException("Could not parse configuration", exception);
        }
    }

    @Override
    public void setPredefinedConfiguration(long l, String string) throws IllegalArgumentException {
        Objects.requireNonNull(string);
        MBeanUtils.checkControl();
        Recording recording = this.getExistingRecording(l);
        for (Configuration configuration : Configuration.getConfigurations()) {
            if (!configuration.getName().equals(string)) continue;
            recording.setSettings(configuration.getSettings());
            return;
        }
        throw new IllegalArgumentException("Could not find configuration with name " + string);
    }

    @Override
    public void copyTo(long l, String string) throws IOException {
        Objects.requireNonNull(string);
        MBeanUtils.checkControl();
        this.getExistingRecording(l).dump(Paths.get(string, new String[0]));
    }

    @Override
    public void setRecordingOptions(long l2, Map<String, String> map) throws IllegalArgumentException {
        Objects.requireNonNull(map);
        MBeanUtils.checkControl();
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        for (Map.Entry entry : hashMap.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!(k instanceof String)) {
                throw new IllegalArgumentException("Option key must not be null, or other type than " + String.class);
            }
            if (!OPTIONS.contains(k)) {
                throw new IllegalArgumentException("Unknown recording option: " + k + ". Valid options are " + OPTIONS + ".");
            }
            if (v == null || v instanceof String) continue;
            throw new IllegalArgumentException("Incorrect value for option " + k + ". Values must be of type " + String.class + " .");
        }
        Recording recording = this.getExistingRecording(l2);
        FlightRecorderMXBeanImpl.validateOption(hashMap, OPTION_DUMP_ON_EXIT, MBeanUtils::booleanValue);
        FlightRecorderMXBeanImpl.validateOption(hashMap, OPTION_DISK, MBeanUtils::booleanValue);
        FlightRecorderMXBeanImpl.validateOption(hashMap, OPTION_NAME, Function.identity());
        FlightRecorderMXBeanImpl.validateOption(hashMap, OPTION_MAX_AGE, MBeanUtils::duration);
        FlightRecorderMXBeanImpl.validateOption(hashMap, OPTION_MAX_SIZE, MBeanUtils::size);
        FlightRecorderMXBeanImpl.validateOption(hashMap, OPTION_DURATION, MBeanUtils::duration);
        FlightRecorderMXBeanImpl.setOption(hashMap, OPTION_DUMP_ON_EXIT, "false", MBeanUtils::booleanValue, bl -> recording.setDumpOnExit((boolean)bl));
        FlightRecorderMXBeanImpl.setOption(hashMap, OPTION_DISK, "true", MBeanUtils::booleanValue, bl -> recording.setToDisk((boolean)bl));
        FlightRecorderMXBeanImpl.setOption(hashMap, OPTION_NAME, String.valueOf(recording.getId()), Function.identity(), string -> recording.setName((String)string));
        FlightRecorderMXBeanImpl.setOption(hashMap, OPTION_MAX_AGE, null, MBeanUtils::duration, duration -> recording.setMaxAge((Duration)duration));
        FlightRecorderMXBeanImpl.setOption(hashMap, OPTION_MAX_SIZE, "0", MBeanUtils::size, l -> recording.setMaxSize((long)l));
        FlightRecorderMXBeanImpl.setOption(hashMap, OPTION_DURATION, null, MBeanUtils::duration, duration -> recording.setDuration((Duration)duration));
    }

    @Override
    public Map<String, String> getRecordingOptions(long l) throws IllegalArgumentException {
        MBeanUtils.checkMonitor();
        Recording recording = this.getExistingRecording(l);
        HashMap<String, String> hashMap = new HashMap<String, String>(10);
        hashMap.put(OPTION_DUMP_ON_EXIT, String.valueOf(recording.getDumpOnExit()));
        hashMap.put(OPTION_DISK, String.valueOf(recording.isToDisk()));
        hashMap.put(OPTION_NAME, String.valueOf(recording.getName()));
        hashMap.put(OPTION_MAX_AGE, ManagementSupport.formatTimespan(recording.getMaxAge(), " "));
        Long l2 = recording.getMaxSize();
        hashMap.put(OPTION_MAX_SIZE, String.valueOf(l2 == null ? "0" : l2.toString()));
        hashMap.put(OPTION_DURATION, ManagementSupport.formatTimespan(recording.getDuration(), " "));
        return hashMap;
    }

    @Override
    public long cloneRecording(long l, boolean bl) throws IllegalStateException, SecurityException {
        MBeanUtils.checkControl();
        return this.getRecording(l).copy(bl).getId();
    }

    @Override
    public ObjectName getObjectName() {
        return MBeanUtils.createObjectName();
    }

    private Recording getExistingRecording(long l) {
        Recording recording;
        if (FlightRecorder.isInitialized() && (recording = this.getRecording(l)) != null) {
            return recording;
        }
        throw new IllegalArgumentException("No recording available with id " + l);
    }

    private Recording getRecording(long l) {
        List<Recording> list = this.getRecorder().getRecordings();
        return list.stream().filter(recording -> recording.getId() == l).findFirst().orElse(null);
    }

    private static <T, U> void setOption(Map<String, String> map, String string, String string2, Function<String, U> function, Consumer<U> consumer) {
        if (!map.containsKey(string)) {
            return;
        }
        String string3 = map.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        try {
            consumer.accept(function.apply(string3));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Not a valid value for option '" + string + "'. " + illegalArgumentException.getMessage());
        }
    }

    private static <T, U> void validateOption(Map<String, String> map, String string, Function<String, U> function) {
        try {
            String string2 = map.get(string);
            if (string2 == null) {
                return;
            }
            function.apply(string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Not a valid value for option '" + string + "'. " + illegalArgumentException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlightRecorder getRecorder() throws SecurityException {
        StreamManager streamManager = this.streamHandler;
        synchronized (streamManager) {
            if (this.recorder == null) {
                this.recorder = AccessController.doPrivileged(new PrivilegedAction<FlightRecorder>(){

                    @Override
                    public FlightRecorder run() {
                        return FlightRecorder.getFlightRecorder();
                    }
                }, null, new FlightRecorderPermission("accessFlightRecorder"));
            }
            return this.recorder;
        }
    }

    private static MBeanNotificationInfo[] createNotificationInfo() {
        String[] stringArray = new String[]{"jmx.attribute.change"};
        String string = AttributeChangeNotification.class.getName();
        String string2 = "Notifies if the RecordingState has changed for one of the recordings, for example if a recording starts or stops";
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(stringArray, string, string2);
        return new MBeanNotificationInfo[]{mBeanNotificationInfo};
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
        final MXBeanListener mXBeanListener = new MXBeanListener(notificationListener, notificationFilter, object);
        this.listeners.add(mXBeanListener);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                FlightRecorder.addListener(mXBeanListener);
                return null;
            }
        }, null, new FlightRecorderPermission("accessFlightRecorder"));
        super.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        this.removeListeners(mXBeanListener -> notificationListener == ((MXBeanListener)mXBeanListener).listener);
        super.removeNotificationListener(notificationListener);
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws ListenerNotFoundException {
        this.removeListeners(mXBeanListener -> notificationListener == ((MXBeanListener)mXBeanListener).listener && notificationFilter == ((MXBeanListener)mXBeanListener).filter && object == ((MXBeanListener)mXBeanListener).handback);
        super.removeNotificationListener(notificationListener, notificationFilter, object);
    }

    private void removeListeners(Predicate<MXBeanListener> predicate) {
        ArrayList<MXBeanListener> arrayList = new ArrayList<MXBeanListener>(this.listeners.size());
        for (MXBeanListener mXBeanListener : this.listeners) {
            if (!predicate.test(mXBeanListener)) continue;
            arrayList.add(mXBeanListener);
            FlightRecorder.removeListener(mXBeanListener);
        }
        this.listeners.removeAll(arrayList);
    }

    private Notification createNotication(Recording recording) {
        try {
            Long l = recording.getId();
            Object object = this.changes.get(recording.getId());
            Object object2 = this.getAttribute(ATTRIBUTE_RECORDINGS);
            if (recording.getState() != RecordingState.CLOSED) {
                this.changes.put(l, object2);
            } else {
                this.changes.remove(l);
            }
            return new AttributeChangeNotification(this.getObjectName(), this.sequenceNumber.incrementAndGet(), System.currentTimeMillis(), "Recording " + recording.getName() + " is " + (Object)((Object)recording.getState()), ATTRIBUTE_RECORDINGS, object2.getClass().getName(), object, object2);
        }
        catch (AttributeNotFoundException | MBeanException | ReflectionException jMException) {
            throw new RuntimeException("Could not create notifcation for FlightRecorderMXBean. " + jMException.getMessage(), jMException);
        }
    }

    final class MXBeanListener
    implements FlightRecorderListener {
        private final NotificationListener listener;
        private final NotificationFilter filter;
        private final Object handback;
        private final AccessControlContext context = AccessController.getContext();

        public MXBeanListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) {
            this.listener = notificationListener;
            this.filter = notificationFilter;
            this.handback = object;
        }

        @Override
        public void recordingStateChanged(final Recording recording) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    FlightRecorderMXBeanImpl.this.sendNotification(FlightRecorderMXBeanImpl.this.createNotication(recording));
                    return null;
                }
            }, this.context);
        }
    }
}

