import { DataStore } from "../datastore/DataStore";
import { MatrixUser } from "matrix-appservice-bridge";
import { IrcClientConfig } from "../models/IrcClientConfig";
import { IrcServer } from "./IrcServer";
export declare class IdentGenerator {
    private readonly dataStore;
    private static readonly MAX_REAL_NAME_LENGTH;
    static readonly MAX_USER_NAME_LENGTH = 10;
    private static readonly USER_NAME_DELIMITER;
    private static readonly MAX_USER_NAME_SUFFIX;
    private queue;
    constructor(dataStore: DataStore);
    static switchAroundMxid(user: MatrixUser): string;
    /**
     * Get the IRC name info for this user.
     * @param {IrcClientConfig} clientConfig IRC client configuration info.
     * @param {MatrixUser} matrixUser Optional. The matrix user.
     * @return {Promise} Resolves to {
     *   username: 'username_to_use',
     *   realname: 'realname_to_use'
     * }
     */
    getIrcNames(ircClientConfig: IrcClientConfig, server: IrcServer, matrixUser?: MatrixUser): Promise<{
        username: string;
        realname: string;
    }>;
    inspect(): string;
    private process;
    /**
     * Generate a new IRC username for the given Matrix user on the given server.
     * @param {string} domain The IRC server domain
     * @param {string} userId The matrix user being bridged
     * @return {Promise} resolves to the username {string}.
     */
    private generateIdentUsername;
    /**
     * Get the next available suffix for a given complete username.
     * This function will find the correct suffix for a user in as fewest
     * DB calls as possible.
     * @param uname The IRC username
     * @param domain The IRC domain.
     */
    private getSuffixForUsername;
    static sanitiseUsername(username: string, replacementChar?: string): string;
    private static sanitiseRealname;
    private static modifyUsername;
}
