/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.rest.AbstractADSearchAction;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.transport.SearchAnomalyResultAction;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestRequest;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.client.node.NodeClient;

public class RestSearchAnomalyResultAction
extends AbstractADSearchAction<AnomalyResult> {
    private static final String LEGACY_URL_PATH = "/_opendistro/_anomaly_detection/detectors/results/_search";
    private static final String URL_PATH = "/_plugins/_anomaly_detection/detectors/results/_search";
    public static final String SEARCH_ANOMALY_RESULT_ACTION = "search_anomaly_result";

    public RestSearchAnomalyResultAction() {
        super((List<String>)ImmutableList.of((Object)String.format(Locale.ROOT, "%s/{%s}", URL_PATH, "resultIndex")), (List<Pair<String, String>>)ImmutableList.of((Object)Pair.of((Object)URL_PATH, (Object)LEGACY_URL_PATH)), ".opendistro-anomaly-results*", AnomalyResult.class, SearchAnomalyResultAction.INSTANCE);
    }

    public String getName() {
        return SEARCH_ANOMALY_RESULT_ACTION;
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ADEnabledSetting.isADEnabled()) {
            throw new IllegalStateException("AD functionality is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        String resultIndex = Strings.trimToNull((String)request.param("resultIndex"));
        boolean onlyQueryCustomResultIndex = request.paramAsBoolean("only_query_custom_result_index", false);
        if (resultIndex == null && onlyQueryCustomResultIndex) {
            throw new IllegalStateException("No custom result index set.");
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.parseXContent(request.contentOrSourceParamParser());
        searchSourceBuilder.fetchSource(RestHandlerUtils.getSourceContext(request, searchSourceBuilder));
        searchSourceBuilder.seqNoAndPrimaryTerm(Boolean.valueOf(true)).version(Boolean.valueOf(true));
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(new String[]{this.index});
        if (resultIndex != null) {
            if (onlyQueryCustomResultIndex) {
                searchRequest.indices(new String[]{resultIndex});
            } else {
                searchRequest.indices(new String[]{this.index, resultIndex});
            }
        }
        return channel -> client.execute(this.actionType, (ActionRequest)searchRequest, this.search((RestChannel)channel));
    }
}

