"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.slurpFile = exports.fileIntercept = exports.filePromisesHash = void 0;
const fs_1 = require("fs");
const { readFile } = fs_1.promises;
exports.filePromisesHash = {};
exports.fileIntercept = {};
const slurpFile = (path, options) => {
    if (exports.fileIntercept[path] !== undefined) {
        return exports.fileIntercept[path];
    }
    if (!exports.filePromisesHash[path] || options?.ignoreCache) {
        exports.filePromisesHash[path] = readFile(path, "utf8");
    }
    return exports.filePromisesHash[path];
};
exports.slurpFile = slurpFile;
