﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sts/STS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace STS {
namespace Model {

/**
 * <p>The identifiers for the temporary security credentials that the operation
 * returns.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sts-2011-06-15/AssumedRoleUser">AWS
 * API Reference</a></p>
 */
class AssumedRoleUser {
 public:
  AWS_STS_API AssumedRoleUser() = default;
  AWS_STS_API AssumedRoleUser(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_STS_API AssumedRoleUser& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_STS_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_STS_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>A unique identifier that contains the role ID and the role session name of
   * the role that is being assumed. The role ID is generated by Amazon Web Services
   * when the role is created.</p>
   */
  inline const Aws::String& GetAssumedRoleId() const { return m_assumedRoleId; }
  inline bool AssumedRoleIdHasBeenSet() const { return m_assumedRoleIdHasBeenSet; }
  template <typename AssumedRoleIdT = Aws::String>
  void SetAssumedRoleId(AssumedRoleIdT&& value) {
    m_assumedRoleIdHasBeenSet = true;
    m_assumedRoleId = std::forward<AssumedRoleIdT>(value);
  }
  template <typename AssumedRoleIdT = Aws::String>
  AssumedRoleUser& WithAssumedRoleId(AssumedRoleIdT&& value) {
    SetAssumedRoleId(std::forward<AssumedRoleIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the temporary security credentials that are returned from the
   * <a>AssumeRole</a> action. For more information about ARNs and how to use them in
   * policies, see <a
   * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html">IAM
   * Identifiers</a> in the <i>IAM User Guide</i>.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  AssumedRoleUser& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_assumedRoleId;
  bool m_assumedRoleIdHasBeenSet = false;

  Aws::String m_arn;
  bool m_arnHasBeenSet = false;
};

}  // namespace Model
}  // namespace STS
}  // namespace Aws
