# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AzureAsyncOperationResults(msrest.serialization.Model):
    """The results of Azure-AsyncOperation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the management group.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :vartype id: str
    :ivar type: The type of the resource.  For example, Microsoft.Management/managementGroups.
    :vartype type: str
    :ivar name: The name of the management group. For example,
     00000000-0000-0000-0000-000000000000.
    :vartype name: str
    :ivar status: The current status of the asynchronous operation performed . For example,
     Running, Succeeded, Failed.
    :vartype status: str
    :param tenant_id: The AAD Tenant ID associated with the management group. For example,
     00000000-0000-0000-0000-000000000000.
    :type tenant_id: str
    :param display_name: The friendly name of the management group.
    :type display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureAsyncOperationResults, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.status = None
        self.tenant_id = kwargs.get('tenant_id', None)
        self.display_name = kwargs.get('display_name', None)


class CheckNameAvailabilityRequest(msrest.serialization.Model):
    """Management group name availability check parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: the name to check for availability.
    :type name: str
    :ivar type: fully qualified resource type which includes provider namespace. Default value:
     "Microsoft.Management/managementGroups".
    :vartype type: str
    """

    _validation = {
        'type': {'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.Management/managementGroups"

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """Describes the result of the request to check management group name availability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Required. True indicates name is valid and available. False indicates the
     name is invalid, unavailable, or both.
    :vartype name_available: bool
    :ivar reason: Required if nameAvailable == false. Invalid indicates the name provided does not
     match the resource provider's naming requirements (incorrect length, unsupported characters,
     etc.) AlreadyExists indicates that the name is already in use and is therefore unavailable.
     Possible values include: "Invalid", "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.managementgroups.models.Reason
    :ivar message: Required if nameAvailable == false. Localized. If reason == invalid, provide the
     user with the reason why the given name is invalid, and provide the resource naming
     requirements so that the user can select a valid name. If reason == AlreadyExists, explain that
     is already in use, and direct them to select a different name.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class CreateManagementGroupChildInfo(msrest.serialization.Model):
    """The child information of a management group used during creation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The fully qualified resource type which includes provider namespace (e.g.
     Microsoft.Management/managementGroups). Possible values include:
     "Microsoft.Management/managementGroups", "/subscriptions".
    :vartype type: str or ~azure.mgmt.managementgroups.models.ManagementGroupChildType
    :ivar id: The fully qualified ID for the child resource (management group or subscription).
     For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :vartype id: str
    :ivar name: The name of the child entity.
    :vartype name: str
    :ivar display_name: The friendly name of the child resource.
    :vartype display_name: str
    :ivar children: The list of children.
    :vartype children: list[~azure.mgmt.managementgroups.models.CreateManagementGroupChildInfo]
    """

    _validation = {
        'type': {'readonly': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'children': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'children': {'key': 'children', 'type': '[CreateManagementGroupChildInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateManagementGroupChildInfo, self).__init__(**kwargs)
        self.type = None
        self.id = None
        self.name = None
        self.display_name = None
        self.children = None


class CreateManagementGroupDetails(msrest.serialization.Model):
    """The details of a management group used during creation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: The version number of the object.
    :vartype version: int
    :ivar updated_time: The date and time when this object was last updated.
    :vartype updated_time: ~datetime.datetime
    :ivar updated_by: The identity of the principal or process that updated the object.
    :vartype updated_by: str
    :param parent: (Optional) The ID of the parent management group used during creation.
    :type parent: ~azure.mgmt.managementgroups.models.CreateParentGroupInfo
    """

    _validation = {
        'version': {'readonly': True},
        'updated_time': {'readonly': True},
        'updated_by': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'int'},
        'updated_time': {'key': 'updatedTime', 'type': 'iso-8601'},
        'updated_by': {'key': 'updatedBy', 'type': 'str'},
        'parent': {'key': 'parent', 'type': 'CreateParentGroupInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateManagementGroupDetails, self).__init__(**kwargs)
        self.version = None
        self.updated_time = None
        self.updated_by = None
        self.parent = kwargs.get('parent', None)


class CreateManagementGroupRequest(msrest.serialization.Model):
    """Management group creation parameters.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the management group.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :vartype id: str
    :ivar type: The type of the resource.  For example, Microsoft.Management/managementGroups.
    :vartype type: str
    :param name: The name of the management group. For example,
     00000000-0000-0000-0000-000000000000.
    :type name: str
    :ivar tenant_id: The AAD Tenant ID associated with the management group. For example,
     00000000-0000-0000-0000-000000000000.
    :vartype tenant_id: str
    :param display_name: The friendly name of the management group. If no value is passed then this
     field will be set to the groupId.
    :type display_name: str
    :param details: The details of a management group used during creation.
    :type details: ~azure.mgmt.managementgroups.models.CreateManagementGroupDetails
    :ivar children: The list of children.
    :vartype children: list[~azure.mgmt.managementgroups.models.CreateManagementGroupChildInfo]
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'tenant_id': {'readonly': True},
        'children': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'details': {'key': 'properties.details', 'type': 'CreateManagementGroupDetails'},
        'children': {'key': 'properties.children', 'type': '[CreateManagementGroupChildInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateManagementGroupRequest, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = kwargs.get('name', None)
        self.tenant_id = None
        self.display_name = kwargs.get('display_name', None)
        self.details = kwargs.get('details', None)
        self.children = None


class CreateOrUpdateSettingsRequest(msrest.serialization.Model):
    """Parameters for creating or updating Management Group settings.

    :param require_authorization_for_group_creation: Indicates whether RBAC access is required upon
     group creation under the root Management Group. If set to true, user will require
     Microsoft.Management/managementGroups/write action on the root Management Group scope in order
     to create new Groups directly under the root. This will prevent new users from creating new
     Management Groups, unless they are given access.
    :type require_authorization_for_group_creation: bool
    :param default_management_group: Settings that sets the default Management Group under which
     new subscriptions get added in this tenant. For example,
     /providers/Microsoft.Management/managementGroups/defaultGroup.
    :type default_management_group: str
    """

    _attribute_map = {
        'require_authorization_for_group_creation': {'key': 'properties.requireAuthorizationForGroupCreation', 'type': 'bool'},
        'default_management_group': {'key': 'properties.defaultManagementGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateOrUpdateSettingsRequest, self).__init__(**kwargs)
        self.require_authorization_for_group_creation = kwargs.get('require_authorization_for_group_creation', None)
        self.default_management_group = kwargs.get('default_management_group', None)


class CreateParentGroupInfo(msrest.serialization.Model):
    """(Optional) The ID of the parent management group used during creation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: The fully qualified ID for the parent management group.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :type id: str
    :ivar name: The name of the parent management group.
    :vartype name: str
    :ivar display_name: The friendly name of the parent management group.
    :vartype display_name: str
    """

    _validation = {
        'name': {'readonly': True},
        'display_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CreateParentGroupInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.display_name = None


class DescendantInfo(msrest.serialization.Model):
    """The descendant.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the descendant.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000 or
     /subscriptions/0000000-0000-0000-0000-000000000000.
    :vartype id: str
    :ivar type: The type of the resource. For example, Microsoft.Management/managementGroups or
     /subscriptions.
    :vartype type: str
    :ivar name: The name of the descendant. For example, 00000000-0000-0000-0000-000000000000.
    :vartype name: str
    :param display_name: The friendly name of the management group.
    :type display_name: str
    :param parent: The ID of the parent management group.
    :type parent: ~azure.mgmt.managementgroups.models.DescendantParentGroupInfo
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'parent': {'key': 'properties.parent', 'type': 'DescendantParentGroupInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DescendantInfo, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.display_name = kwargs.get('display_name', None)
        self.parent = kwargs.get('parent', None)


class DescendantListResult(msrest.serialization.Model):
    """Describes the result of the request to view descendants.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of descendants.
    :type value: list[~azure.mgmt.managementgroups.models.DescendantInfo]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DescendantInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DescendantListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class DescendantParentGroupInfo(msrest.serialization.Model):
    """The ID of the parent management group.

    :param id: The fully qualified ID for the parent management group.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DescendantParentGroupInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class EntityHierarchyItem(msrest.serialization.Model):
    """The management group details for the hierarchy view.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the management group.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :vartype id: str
    :ivar type: The type of the resource.  For example, Microsoft.Management/managementGroups.
    :vartype type: str
    :ivar name: The name of the management group. For example,
     00000000-0000-0000-0000-000000000000.
    :vartype name: str
    :param display_name: The friendly name of the management group.
    :type display_name: str
    :param permissions: The users specific permissions to this item. Possible values include:
     "noaccess", "view", "edit", "delete".
    :type permissions: str or ~azure.mgmt.managementgroups.models.Permissions
    :param children: The list of children.
    :type children: list[~azure.mgmt.managementgroups.models.EntityHierarchyItem]
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'permissions': {'key': 'properties.permissions', 'type': 'str'},
        'children': {'key': 'properties.children', 'type': '[EntityHierarchyItem]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntityHierarchyItem, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.display_name = kwargs.get('display_name', None)
        self.permissions = kwargs.get('permissions', None)
        self.children = kwargs.get('children', None)


class EntityInfo(msrest.serialization.Model):
    """The entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the entity.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :vartype id: str
    :ivar type: The type of the resource. For example, Microsoft.Management/managementGroups.
    :vartype type: str
    :ivar name: The name of the entity. For example, 00000000-0000-0000-0000-000000000000.
    :vartype name: str
    :param tenant_id: The AAD Tenant ID associated with the entity. For example,
     00000000-0000-0000-0000-000000000000.
    :type tenant_id: str
    :param display_name: The friendly name of the management group.
    :type display_name: str
    :param parent: (Optional) The ID of the parent management group.
    :type parent: ~azure.mgmt.managementgroups.models.EntityParentGroupInfo
    :param permissions: The users specific permissions to this item. Possible values include:
     "noaccess", "view", "edit", "delete".
    :type permissions: str or ~azure.mgmt.managementgroups.models.Permissions
    :param inherited_permissions: The users specific permissions to this item. Possible values
     include: "noaccess", "view", "edit", "delete".
    :type inherited_permissions: str or ~azure.mgmt.managementgroups.models.Permissions
    :param number_of_descendants: Number of Descendants.
    :type number_of_descendants: int
    :param number_of_children: Number of children is the number of Groups and Subscriptions that
     are exactly one level underneath the current Group.
    :type number_of_children: int
    :param number_of_child_groups: Number of children is the number of Groups that are exactly one
     level underneath the current Group.
    :type number_of_child_groups: int
    :param parent_display_name_chain: The parent display name chain from the root group to the
     immediate parent.
    :type parent_display_name_chain: list[str]
    :param parent_name_chain: The parent name chain from the root group to the immediate parent.
    :type parent_name_chain: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'parent': {'key': 'properties.parent', 'type': 'EntityParentGroupInfo'},
        'permissions': {'key': 'properties.permissions', 'type': 'str'},
        'inherited_permissions': {'key': 'properties.inheritedPermissions', 'type': 'str'},
        'number_of_descendants': {'key': 'properties.numberOfDescendants', 'type': 'int'},
        'number_of_children': {'key': 'properties.numberOfChildren', 'type': 'int'},
        'number_of_child_groups': {'key': 'properties.numberOfChildGroups', 'type': 'int'},
        'parent_display_name_chain': {'key': 'properties.parentDisplayNameChain', 'type': '[str]'},
        'parent_name_chain': {'key': 'properties.parentNameChain', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntityInfo, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.tenant_id = kwargs.get('tenant_id', None)
        self.display_name = kwargs.get('display_name', None)
        self.parent = kwargs.get('parent', None)
        self.permissions = kwargs.get('permissions', None)
        self.inherited_permissions = kwargs.get('inherited_permissions', None)
        self.number_of_descendants = kwargs.get('number_of_descendants', None)
        self.number_of_children = kwargs.get('number_of_children', None)
        self.number_of_child_groups = kwargs.get('number_of_child_groups', None)
        self.parent_display_name_chain = kwargs.get('parent_display_name_chain', None)
        self.parent_name_chain = kwargs.get('parent_name_chain', None)


class EntityListResult(msrest.serialization.Model):
    """Describes the result of the request to view entities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of entities.
    :type value: list[~azure.mgmt.managementgroups.models.EntityInfo]
    :ivar count: Total count of records that match the filter.
    :vartype count: int
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'count': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EntityInfo]'},
        'count': {'key': 'count', 'type': 'int'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntityListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.count = None
        self.next_link = None


class EntityParentGroupInfo(msrest.serialization.Model):
    """(Optional) The ID of the parent management group.

    :param id: The fully qualified ID for the parent management group.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EntityParentGroupInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class ErrorDetails(msrest.serialization.Model):
    """The details of the error.

    :param code: One of a server-defined set of error codes.
    :type code: str
    :param message: A human-readable representation of the error.
    :type message: str
    :param details: A human-readable representation of the error's details.
    :type details: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class ErrorResponse(msrest.serialization.Model):
    """The error object.

    :param error: The details of the error.
    :type error: ~azure.mgmt.managementgroups.models.ErrorDetails
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class HierarchySettings(msrest.serialization.Model):
    """Settings defined at the Management Group scope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the settings object.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000/settings/default.
    :vartype id: str
    :ivar type: The type of the resource.  For example,
     Microsoft.Management/managementGroups/settings.
    :vartype type: str
    :ivar name: The name of the object. In this case, default.
    :vartype name: str
    :param tenant_id: The AAD Tenant ID associated with the hierarchy settings. For example,
     00000000-0000-0000-0000-000000000000.
    :type tenant_id: str
    :param require_authorization_for_group_creation: Indicates whether RBAC access is required upon
     group creation under the root Management Group. If set to true, user will require
     Microsoft.Management/managementGroups/write action on the root Management Group scope in order
     to create new Groups directly under the root. This will prevent new users from creating new
     Management Groups, unless they are given access.
    :type require_authorization_for_group_creation: bool
    :param default_management_group: Settings that sets the default Management Group under which
     new subscriptions get added in this tenant. For example,
     /providers/Microsoft.Management/managementGroups/defaultGroup.
    :type default_management_group: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'require_authorization_for_group_creation': {'key': 'properties.requireAuthorizationForGroupCreation', 'type': 'bool'},
        'default_management_group': {'key': 'properties.defaultManagementGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HierarchySettings, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.tenant_id = kwargs.get('tenant_id', None)
        self.require_authorization_for_group_creation = kwargs.get('require_authorization_for_group_creation', None)
        self.default_management_group = kwargs.get('default_management_group', None)


class HierarchySettingsInfo(msrest.serialization.Model):
    """The hierarchy settings resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the settings object.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000/settings/default.
    :vartype id: str
    :ivar type: The type of the resource.  For example,
     Microsoft.Management/managementGroups/settings.
    :vartype type: str
    :ivar name: The name of the object. In this case, default.
    :vartype name: str
    :param tenant_id: The AAD Tenant ID associated with the hierarchy settings. For example,
     00000000-0000-0000-0000-000000000000.
    :type tenant_id: str
    :param require_authorization_for_group_creation: Indicates whether RBAC access is required upon
     group creation under the root Management Group. If set to true, user will require
     Microsoft.Management/managementGroups/write action on the root Management Group scope in order
     to create new Groups directly under the root. This will prevent new users from creating new
     Management Groups, unless they are given access.
    :type require_authorization_for_group_creation: bool
    :param default_management_group: Settings that sets the default Management Group under which
     new subscriptions get added in this tenant. For example,
     /providers/Microsoft.Management/managementGroups/defaultGroup.
    :type default_management_group: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'require_authorization_for_group_creation': {'key': 'properties.requireAuthorizationForGroupCreation', 'type': 'bool'},
        'default_management_group': {'key': 'properties.defaultManagementGroup', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HierarchySettingsInfo, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.tenant_id = kwargs.get('tenant_id', None)
        self.require_authorization_for_group_creation = kwargs.get('require_authorization_for_group_creation', None)
        self.default_management_group = kwargs.get('default_management_group', None)


class HierarchySettingsList(msrest.serialization.Model):
    """Lists all hierarchy settings.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of hierarchy settings.
    :type value: list[~azure.mgmt.managementgroups.models.HierarchySettingsInfo]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[HierarchySettingsInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HierarchySettingsList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ListSubscriptionUnderManagementGroup(msrest.serialization.Model):
    """The details of all subscriptions under management group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of subscriptions.
    :type value: list[~azure.mgmt.managementgroups.models.SubscriptionUnderManagementGroup]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubscriptionUnderManagementGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListSubscriptionUnderManagementGroup, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ManagementGroup(msrest.serialization.Model):
    """The management group details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the management group.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :vartype id: str
    :ivar type: The type of the resource.  For example, Microsoft.Management/managementGroups.
    :vartype type: str
    :ivar name: The name of the management group. For example,
     00000000-0000-0000-0000-000000000000.
    :vartype name: str
    :param tenant_id: The AAD Tenant ID associated with the management group. For example,
     00000000-0000-0000-0000-000000000000.
    :type tenant_id: str
    :param display_name: The friendly name of the management group.
    :type display_name: str
    :param details: The details of a management group.
    :type details: ~azure.mgmt.managementgroups.models.ManagementGroupDetails
    :param children: The list of children.
    :type children: list[~azure.mgmt.managementgroups.models.ManagementGroupChildInfo]
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'details': {'key': 'properties.details', 'type': 'ManagementGroupDetails'},
        'children': {'key': 'properties.children', 'type': '[ManagementGroupChildInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementGroup, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.tenant_id = kwargs.get('tenant_id', None)
        self.display_name = kwargs.get('display_name', None)
        self.details = kwargs.get('details', None)
        self.children = kwargs.get('children', None)


class ManagementGroupChildInfo(msrest.serialization.Model):
    """The child information of a management group.

    :param type: The fully qualified resource type which includes provider namespace (e.g.
     Microsoft.Management/managementGroups). Possible values include:
     "Microsoft.Management/managementGroups", "/subscriptions".
    :type type: str or ~azure.mgmt.managementgroups.models.ManagementGroupChildType
    :param id: The fully qualified ID for the child resource (management group or subscription).
     For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :type id: str
    :param name: The name of the child entity.
    :type name: str
    :param display_name: The friendly name of the child resource.
    :type display_name: str
    :param children: The list of children.
    :type children: list[~azure.mgmt.managementgroups.models.ManagementGroupChildInfo]
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'children': {'key': 'children', 'type': '[ManagementGroupChildInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementGroupChildInfo, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.children = kwargs.get('children', None)


class ManagementGroupDetails(msrest.serialization.Model):
    """The details of a management group.

    :param version: The version number of the object.
    :type version: int
    :param updated_time: The date and time when this object was last updated.
    :type updated_time: ~datetime.datetime
    :param updated_by: The identity of the principal or process that updated the object.
    :type updated_by: str
    :param parent: (Optional) The ID of the parent management group.
    :type parent: ~azure.mgmt.managementgroups.models.ParentGroupInfo
    :param path: The path from the root to the current group.
    :type path: list[~azure.mgmt.managementgroups.models.ManagementGroupPathElement]
    :param management_group_ancestors: The ancestors of the management group.
    :type management_group_ancestors: list[str]
    :param management_group_ancestors_chain: The ancestors of the management group displayed in
     reversed order, from immediate parent to the root.
    :type management_group_ancestors_chain:
     list[~azure.mgmt.managementgroups.models.ManagementGroupPathElement]
    """

    _attribute_map = {
        'version': {'key': 'version', 'type': 'int'},
        'updated_time': {'key': 'updatedTime', 'type': 'iso-8601'},
        'updated_by': {'key': 'updatedBy', 'type': 'str'},
        'parent': {'key': 'parent', 'type': 'ParentGroupInfo'},
        'path': {'key': 'path', 'type': '[ManagementGroupPathElement]'},
        'management_group_ancestors': {'key': 'managementGroupAncestors', 'type': '[str]'},
        'management_group_ancestors_chain': {'key': 'managementGroupAncestorsChain', 'type': '[ManagementGroupPathElement]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementGroupDetails, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.updated_time = kwargs.get('updated_time', None)
        self.updated_by = kwargs.get('updated_by', None)
        self.parent = kwargs.get('parent', None)
        self.path = kwargs.get('path', None)
        self.management_group_ancestors = kwargs.get('management_group_ancestors', None)
        self.management_group_ancestors_chain = kwargs.get('management_group_ancestors_chain', None)


class ManagementGroupInfo(msrest.serialization.Model):
    """The management group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the management group.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :vartype id: str
    :ivar type: The type of the resource. For example, Microsoft.Management/managementGroups.
    :vartype type: str
    :ivar name: The name of the management group. For example,
     00000000-0000-0000-0000-000000000000.
    :vartype name: str
    :param tenant_id: The AAD Tenant ID associated with the management group. For example,
     00000000-0000-0000-0000-000000000000.
    :type tenant_id: str
    :param display_name: The friendly name of the management group.
    :type display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementGroupInfo, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.tenant_id = kwargs.get('tenant_id', None)
        self.display_name = kwargs.get('display_name', None)


class ManagementGroupListResult(msrest.serialization.Model):
    """Describes the result of the request to list management groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param value: The list of management groups.
    :type value: list[~azure.mgmt.managementgroups.models.ManagementGroupInfo]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagementGroupInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementGroupListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = None


class ManagementGroupPathElement(msrest.serialization.Model):
    """A path element of a management group ancestors.

    :param name: The name of the group.
    :type name: str
    :param display_name: The friendly name of the group.
    :type display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementGroupPathElement, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)


class Operation(msrest.serialization.Model):
    """Operation supported by the Microsoft.Management resource provider.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.managementgroups.models.OperationDisplayProperties
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplayProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)


class OperationDisplayProperties(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The name of the provider.
    :vartype provider: str
    :ivar resource: The resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation that can be performed.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplayProperties, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """Describes the result of the request to list Microsoft.Management operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the Microsoft.Management resource provider.
    :vartype value: list[~azure.mgmt.managementgroups.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class OperationResults(msrest.serialization.Model):
    """The results of an asynchronous operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the management group.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :vartype id: str
    :ivar type: The type of the resource.  For example, Microsoft.Management/managementGroups.
    :vartype type: str
    :ivar name: The name of the management group. For example,
     00000000-0000-0000-0000-000000000000.
    :vartype name: str
    :param tenant_id: The AAD Tenant ID associated with the management group. For example,
     00000000-0000-0000-0000-000000000000.
    :type tenant_id: str
    :param display_name: The friendly name of the management group.
    :type display_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationResults, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.tenant_id = kwargs.get('tenant_id', None)
        self.display_name = kwargs.get('display_name', None)


class ParentGroupInfo(msrest.serialization.Model):
    """(Optional) The ID of the parent management group.

    :param id: The fully qualified ID for the parent management group.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :type id: str
    :param name: The name of the parent management group.
    :type name: str
    :param display_name: The friendly name of the parent management group.
    :type display_name: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ParentGroupInfo, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)


class PatchManagementGroupRequest(msrest.serialization.Model):
    """Management group patch parameters.

    :param display_name: The friendly name of the management group.
    :type display_name: str
    :param parent_group_id: (Optional) The fully qualified ID for the parent management group.  For
     example, /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000.
    :type parent_group_id: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'parent_group_id': {'key': 'parentGroupId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PatchManagementGroupRequest, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.parent_group_id = kwargs.get('parent_group_id', None)


class SubscriptionUnderManagementGroup(msrest.serialization.Model):
    """The details of subscription under management group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the subscription.  For example,
     /providers/Microsoft.Management/managementGroups/0000000-0000-0000-0000-000000000000/subscriptions/0000000-0000-0000-0000-000000000001.
    :vartype id: str
    :ivar type: The type of the resource.  For example,
     Microsoft.Management/managementGroups/subscriptions.
    :vartype type: str
    :ivar name: The stringified id of the subscription. For example,
     00000000-0000-0000-0000-000000000000.
    :vartype name: str
    :param tenant: The AAD Tenant ID associated with the subscription. For example,
     00000000-0000-0000-0000-000000000000.
    :type tenant: str
    :param display_name: The friendly name of the subscription.
    :type display_name: str
    :param parent: The ID of the parent management group.
    :type parent: ~azure.mgmt.managementgroups.models.DescendantParentGroupInfo
    :param state: The state of the subscription.
    :type state: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tenant': {'key': 'properties.tenant', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'parent': {'key': 'properties.parent', 'type': 'DescendantParentGroupInfo'},
        'state': {'key': 'properties.state', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionUnderManagementGroup, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.tenant = kwargs.get('tenant', None)
        self.display_name = kwargs.get('display_name', None)
        self.parent = kwargs.get('parent', None)
        self.state = kwargs.get('state', None)


class TenantBackfillStatusResult(msrest.serialization.Model):
    """The tenant backfill status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tenant_id: The AAD Tenant ID associated with the management group. For example,
     00000000-0000-0000-0000-000000000000.
    :vartype tenant_id: str
    :ivar status: The status of the Tenant Backfill. Possible values include: "NotStarted",
     "NotStartedButGroupsExist", "Started", "Failed", "Cancelled", "Completed".
    :vartype status: str or ~azure.mgmt.managementgroups.models.Status
    """

    _validation = {
        'tenant_id': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TenantBackfillStatusResult, self).__init__(**kwargs)
        self.tenant_id = None
        self.status = None
