/*
 * Decompiled with CFR 0.152.
 */
package coil3.decode;

import coil3.decode.ImageSource;
import coil3.util.FileSystemsKt;
import coil3.util.UtilsKt;
import java.io.Closeable;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0002\u001a\u00020\u0003H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcoil3/decode/SourceImageSource;", "Lcoil3/decode/ImageSource;", "source", "Lokio/BufferedSource;", "fileSystem", "Lokio/FileSystem;", "metadata", "Lcoil3/decode/ImageSource$Metadata;", "<init>", "(Lokio/BufferedSource;Lokio/FileSystem;Lcoil3/decode/ImageSource$Metadata;)V", "getFileSystem", "()Lokio/FileSystem;", "getMetadata", "()Lcoil3/decode/ImageSource$Metadata;", "lock", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "isClosed", "", "file", "Lokio/Path;", "sourceOrNull", "fileOrNull", "close", "", "assertNotClosed", "coil-core"})
@SourceDebugExtension(value={"SMAP\nImageSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageSource.kt\ncoil3/decode/SourceImageSource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 FileSystem.kt\nokio/FileSystem\n+ 4 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,188:1\n1#2:189\n84#3:190\n191#3:191\n95#3:192\n96#3:197\n58#4,4:193\n66#4,10:198\n62#4,18:208\n*S KotlinDebug\n*F\n+ 1 ImageSource.kt\ncoil3/decode/SourceImageSource\n*L\n166#1:190\n166#1:191\n166#1:192\n166#1:197\n166#1:193,4\n166#1:198,10\n166#1:208,18\n*E\n"})
public final class SourceImageSource
implements ImageSource {
    @NotNull
    private final FileSystem fileSystem;
    @Nullable
    private final ImageSource.Metadata metadata;
    @NotNull
    private final Object lock;
    private boolean isClosed;
    @Nullable
    private BufferedSource source;
    @Nullable
    private Path file;

    public SourceImageSource(@NotNull BufferedSource source2, @NotNull FileSystem fileSystem2, @Nullable ImageSource.Metadata metadata) {
        this.fileSystem = fileSystem2;
        this.metadata = metadata;
        this.lock = new Object();
        this.source = source2;
    }

    @Override
    @NotNull
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    @Nullable
    public ImageSource.Metadata getMetadata() {
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public BufferedSource source() {
        Object object = this.lock;
        synchronized (object) {
            BufferedSource bufferedSource;
            block4: {
                boolean bl = false;
                this.assertNotClosed();
                BufferedSource bufferedSource2 = this.source;
                if (bufferedSource2 == null) break block4;
                BufferedSource it = bufferedSource2;
                boolean bl2 = false;
                BufferedSource bufferedSource3 = it;
                return bufferedSource3;
            }
            FileSystem fileSystem2 = this.getFileSystem();
            Path path = this.file;
            Intrinsics.checkNotNull((Object)path);
            BufferedSource it = bufferedSource = Okio.buffer(fileSystem2.source(path));
            boolean bl = false;
            this.source = it;
            BufferedSource bufferedSource4 = bufferedSource;
            return bufferedSource4;
        }
    }

    @Override
    @NotNull
    public BufferedSource sourceOrNull() {
        return this.source();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public Path file() {
        Object object = this.lock;
        synchronized (object) {
            Path path;
            Long l;
            Throwable thrown$iv$iv;
            boolean bl;
            Path tempFile;
            block18: {
                boolean bl2 = false;
                this.assertNotClosed();
                Path path2 = this.file;
                if (path2 != null) {
                    Path it = path2;
                    boolean bl22 = false;
                    return it;
                }
                tempFile = FileSystemsKt.createTempFile(this.getFileSystem());
                FileSystem $this$iv = this.getFileSystem();
                boolean mustCreate$iv = false;
                bl = false;
                Closeable $this$use$iv$iv = Okio.buffer($this$iv.sink(tempFile, mustCreate$iv));
                boolean $i$f$use = false;
                thrown$iv$iv = null;
                try {
                    BufferedSink it$iv = (BufferedSink)$this$use$iv$iv;
                    boolean bl3 = false;
                    BufferedSink $this$file_u24lambda_u246_u24lambda_u244 = it$iv;
                    boolean bl4 = false;
                    BufferedSource bufferedSource = this.source;
                    Intrinsics.checkNotNull((Object)bufferedSource);
                    l = $this$file_u24lambda_u246_u24lambda_u244.writeAll(bufferedSource);
                }
                catch (Throwable t$iv$iv) {
                    try {
                        thrown$iv$iv = t$iv$iv;
                        l = null;
                        break block18;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        block19: {
                            try {
                                Closeable closeable = $this$use$iv$iv;
                                if (closeable != null) {
                                    closeable.close();
                                }
                            }
                            catch (Throwable t$iv$iv2) {
                                if (thrown$iv$iv == null) {
                                    thrown$iv$iv = t$iv$iv2;
                                    break block19;
                                }
                                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)t$iv$iv2);
                            }
                        }
                    }
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable t$iv$iv) {
                    thrown$iv$iv = t$iv$iv;
                }
            }
            Long result$iv$iv = l;
            Throwable throwable = thrown$iv$iv;
            if (throwable != null) {
                throw throwable;
            }
            this.source = null;
            Path it = path = tempFile;
            bl = false;
            this.file = it;
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Path fileOrNull() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.assertNotClosed();
            Path path = this.file;
            return path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            this.isClosed = true;
            BufferedSource bufferedSource = this.source;
            if (bufferedSource != null) {
                UtilsKt.closeQuietly(bufferedSource);
            }
            Path path = this.file;
            if (path != null) {
                Path path2 = path;
                FileSystem fileSystem2 = this.getFileSystem();
                Path p0 = path2;
                boolean bl2 = false;
                fileSystem2.delete(p0);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void assertNotClosed() {
        if (!(!this.isClosed)) {
            boolean bl = false;
            String string = "closed";
            throw new IllegalStateException(string.toString());
        }
    }
}

