/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J/\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/idea/maven/dom/inspections/MavenNoRootDefinedInspection;", "Lcom/intellij/util/xml/highlighting/BasicDomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "<init>", "()V", "getGroupDisplayName", "", "getDefaultLevel", "Lcom/intellij/codeHighlighting/HighlightDisplayLevel;", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "fixAddRootTag", "Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenNoRootDefinedInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenNoRootDefinedInspection.kt\norg/jetbrains/idea/maven/dom/inspections/MavenNoRootDefinedInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,87:1\n669#2,11:88\n1563#2:106\n1634#2,3:107\n5388#3,7:99\n37#4,2:110\n*S KotlinDebug\n*F\n+ 1 MavenNoRootDefinedInspection.kt\norg/jetbrains/idea/maven/dom/inspections/MavenNoRootDefinedInspection\n*L\n37#1:88,11\n55#1:106\n55#1:107,3\n46#1:99,7\n60#1:110,2\n*E\n"})
public final class MavenNoRootDefinedInspection
extends BasicDomElementsInspection<MavenDomProjectModel> {
    @NotNull
    private final LocalQuickFix fixAddRootTag = new LocalQuickFix(){

        public String getName() {
            String string = MavenDomBundle.message("inspection.absence.dir.fix.add.root", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public String getFamilyName() {
            String string = MavenDomBundle.message("inspection.absence.root.dir.description", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(Project project, ProblemDescriptor descriptor2) {
            block0: {
                XmlTag projectTag;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
                XmlTag xmlTag = projectTag = this.findRootTag(descriptor2.getPsiElement());
                if (xmlTag == null) break block0;
                xmlTag.setAttribute("root", "true");
            }
        }

        public final XmlTag findRootTag(PsiElement psiElement) {
            if (psiElement == null) {
                return null;
            }
            if (psiElement instanceof XmlTag) {
                return (XmlTag)psiElement;
            }
            return this.findRootTag(psiElement.getParent());
        }
    };

    public MavenNoRootDefinedInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = MavenDomBundle.message("inspection.group", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        return HighlightDisplayLevel.WARNING;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (file2 instanceof XmlFile && file2.isPhysical()) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            ArrayList<PsiElement> list$iv;
            Path path;
            Path single$iv;
            block15: {
                MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstanceIfCreated(((XmlFile)file2).getProject());
                if (mavenProjectsManager == null) {
                    return null;
                }
                MavenProjectsManager projectManager = mavenProjectsManager;
                List<MavenProject> list = projectManager.getRootProjects();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getRootProjects(...)");
                Iterable $this$singleOrNull$iv = list;
                boolean $i$f$singleOrNull = false;
                single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    MavenProject it = (MavenProject)element$iv;
                    boolean bl = false;
                    if (!((XmlFile)file2).getVirtualFile().equals((Object)it.getFile())) continue;
                    if (found$iv) {
                        path = null;
                        break block15;
                    }
                    single$iv = (Path)element$iv;
                    found$iv = true;
                }
                path = !found$iv ? null : single$iv;
            }
            MavenProject mavenProject = (MavenProject)((Object)path);
            if (mavenProject == null) {
                return null;
            }
            MavenProject rootMavenProject = mavenProject;
            DomFileElement domFileElement = DomManager.getDomManager((Project)file2.getProject()).getFileElement((XmlFile)file2, MavenDomProjectModel.class);
            if (domFileElement == null) {
                return null;
            }
            DomFileElement model = domFileElement;
            MavenDomProjectModel mavenDomProjectModel = (MavenDomProjectModel)model.getRootElement();
            if (mavenDomProjectModel == null) {
                return null;
            }
            MavenDomProjectModel rootElement = mavenDomProjectModel;
            PsiElement[] psiElementArray = model.getRootTag();
            if (psiElementArray != null && (psiElementArray = psiElementArray.getChildren()) != null) {
                PsiElement[] $this$takeWhile$iv = psiElementArray;
                boolean $i$f$takeWhile = false;
                list$iv = new ArrayList<PsiElement>();
                int n = $this$takeWhile$iv.length;
                for (int j = 0; j < n; ++j) {
                    PsiElement item$iv;
                    PsiElement it = item$iv = $this$takeWhile$iv[j];
                    boolean bl = false;
                    if (!(it instanceof XmlTag) && !(it instanceof XmlText)) {
                        list$iv.add(item$iv);
                        continue;
                    }
                    break;
                }
            } else {
                return null;
            }
            List psiToShowError = list$iv;
            Path path2 = rootMavenProject.getFile().getParent().toNioPath().resolve(".mvn");
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
            single$iv = path2;
            LinkOption[] found$iv = new LinkOption[]{};
            if (Files.isDirectory(single$iv, Arrays.copyOf(found$iv, found$iv.length))) {
                return null;
            }
            if (Intrinsics.areEqual((Object)rootElement.getModelVersion().getStringValue(), (Object)"4.0.0")) {
                return null;
            }
            Object object = model.getRootTag();
            boolean bl = object != null && (object = object.getAttributeValue("root")) != null ? Boolean.parseBoolean((String)object) : false;
            if (bl) {
                return null;
            }
            Iterable $this$map$iv = psiToShowError;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PsiElement psiElement = (PsiElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{this.fixAddRootTag};
                collection.add(manager.createProblemDescriptor((PsiElement)it, MavenDomBundle.message("inspection.absence.root.dir.description", new Object[0]), localQuickFixArray, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, false));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new ProblemDescriptor[0]);
        }
        return null;
    }
}

