/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util.timer;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.util.timer.TimerTask;
import org.apache.kafka.server.util.timer.TimerTaskEntry;

class TimerTaskList
implements Delayed {
    private final Time time;
    private final AtomicInteger taskCounter;
    private final AtomicLong expiration;
    private final TimerTaskEntry root;

    TimerTaskList(AtomicInteger taskCounter) {
        this(taskCounter, Time.SYSTEM);
    }

    TimerTaskList(AtomicInteger taskCounter, Time time) {
        this.time = time;
        this.taskCounter = taskCounter;
        this.expiration = new AtomicLong(-1L);
        this.root.next = this.root = new TimerTaskEntry(null, -1L);
        this.root.prev = this.root;
    }

    public boolean setExpiration(long expirationMs) {
        return this.expiration.getAndSet(expirationMs) != expirationMs;
    }

    public long getExpiration() {
        return this.expiration.get();
    }

    public synchronized void foreach(Consumer<TimerTask> f) {
        TimerTaskEntry entry = this.root.next;
        while (entry != this.root) {
            TimerTaskEntry nextEntry = entry.next;
            if (!entry.cancelled()) {
                f.accept(entry.timerTask);
            }
            entry = nextEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TimerTaskEntry timerTaskEntry) {
        boolean done = false;
        while (!done) {
            timerTaskEntry.remove();
            TimerTaskList timerTaskList = this;
            synchronized (timerTaskList) {
                TimerTaskEntry timerTaskEntry2 = timerTaskEntry;
                synchronized (timerTaskEntry2) {
                    if (timerTaskEntry.list == null) {
                        TimerTaskEntry tail = this.root.prev;
                        timerTaskEntry.next = this.root;
                        timerTaskEntry.prev = tail;
                        timerTaskEntry.list = this;
                        tail.next = timerTaskEntry;
                        this.root.prev = timerTaskEntry;
                        this.taskCounter.incrementAndGet();
                        done = true;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(TimerTaskEntry timerTaskEntry) {
        TimerTaskEntry timerTaskEntry2 = timerTaskEntry;
        synchronized (timerTaskEntry2) {
            if (timerTaskEntry.list == this) {
                timerTaskEntry.next.prev = timerTaskEntry.prev;
                timerTaskEntry.prev.next = timerTaskEntry.next;
                timerTaskEntry.next = null;
                timerTaskEntry.prev = null;
                timerTaskEntry.list = null;
                this.taskCounter.decrementAndGet();
            }
        }
    }

    public synchronized void flush(Consumer<TimerTaskEntry> f) {
        TimerTaskEntry head = this.root.next;
        while (head != this.root) {
            this.remove(head);
            f.accept(head);
            head = this.root.next;
        }
        this.expiration.set(-1L);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(Math.max(this.getExpiration() - this.time.hiResClockMs(), 0L), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        TimerTaskList other = (TimerTaskList)o;
        return Long.compare(this.getExpiration(), other.getExpiration());
    }
}

