/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.jaxrs;

import io.smallrye.openapi.jaxrs.JaxRsAnnotationScanner;
import io.smallrye.openapi.jaxrs.JaxRsConstants;
import io.smallrye.openapi.jaxrs.JaxRsParameter;
import io.smallrye.openapi.jaxrs.RestEasyConstants;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.scanner.ResourceParameters;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AbstractParameterProcessor;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.scanner.spi.FrameworkParameter;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class JaxRsParameterProcessor
extends AbstractParameterProcessor {
    static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile("\\{[ \\t]*(\\w[\\w\\.-]*)[ \\t]*:[ \\t]*((?:[^{}]|\\{[^{}]+\\})+)\\}");

    private JaxRsParameterProcessor(AnnotationScannerContext scannerContext, String contextPath, Function<AnnotationInstance, Parameter> reader, ClassInfo resourceClass, MethodInfo resourceMethod) {
        super(scannerContext, contextPath, reader, resourceClass, resourceMethod);
    }

    public static ResourceParameters process(AnnotationScannerContext context, String contextPath, ClassInfo resourceClass, MethodInfo resourceMethod, Function<AnnotationInstance, Parameter> reader) {
        JaxRsParameterProcessor processor = new JaxRsParameterProcessor(context, contextPath, reader, resourceClass, resourceMethod);
        return processor.process();
    }

    protected void processPathParameters(ClassInfo resourceClass, MethodInfo resourceMethod, ResourceParameters parameters) {
        ClassInfo resourceMethodClass = resourceMethod.declaringClass();
        this.readParametersInherited(resourceMethodClass, null, false);
        if (!resourceClass.equals(resourceMethodClass)) {
            this.readParameters(resourceClass, null, true);
        }
        parameters.setPathItemParameters(this.getParameters(resourceMethod));
    }

    protected Pattern getTemplateParameterPattern() {
        return TEMPLATE_PARAM_PATTERN;
    }

    protected FrameworkParameter getMatrixParameter() {
        return JaxRsParameter.MATRIX_PARAM.parameter;
    }

    protected AbstractParameterProcessor.ParameterContext getUnannotatedPathParameter(MethodInfo resourceMethod, String name) {
        List methodParameters = resourceMethod.parameterTypes();
        int m = methodParameters.size();
        for (int i = 0; i < m; ++i) {
            List annotations;
            if (!name.equals(resourceMethod.parameterName(i)) || JaxRsAnnotationScanner.containsJaxrsAnnotations(annotations = this.scannerContext.annotations().getMethodParameterAnnotations(resourceMethod, (int)((short)i)))) continue;
            MethodParameterInfo target = annotations.isEmpty() ? MethodParameterInfo.create((MethodInfo)resourceMethod, (short)((short)i)) : ((AnnotationInstance)annotations.get(0)).target();
            Type arg = (Type)methodParameters.get(i);
            return new AbstractParameterProcessor.ParameterContext(name, JaxRsParameter.RESTEASY_REACTIVE_PATH_PARAM.parameter, (AnnotationTarget)target, arg);
        }
        return null;
    }

    protected String getDefaultFormMediaType() {
        return "application/x-www-form-urlencoded";
    }

    protected void addEncoding(Map<String, Encoding> encodings, String paramName, AnnotationTarget paramTarget) {
        if (paramTarget == null) {
            return;
        }
        AnnotationInstance type = this.scannerContext.annotations().getAnnotation(paramTarget, RestEasyConstants.PART_TYPES);
        if (type != null) {
            Encoding encoding = OASFactory.createEncoding();
            encoding.setContentType(type.value().asString());
            encodings.put(paramName, encoding);
        }
    }

    protected void readAnnotatedType(AnnotationInstance annotation, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        DotName name = annotation.name();
        if (this.isReadableParameterAnnotation(name)) {
            this.readParameterAnnotation(annotation, overriddenParametersOnly);
        } else {
            FrameworkParameter frameworkParam = JaxRsParameter.forName(name);
            if (frameworkParam != null) {
                this.readJaxRsParameter(annotation, frameworkParam, beanParamAnnotation, overriddenParametersOnly);
            }
        }
    }

    private void readJaxRsParameter(AnnotationInstance annotation, FrameworkParameter frameworkParam, AnnotationInstance beanParamAnnotation, boolean overriddenParametersOnly) {
        AnnotationTarget target = annotation.target();
        Type targetType = this.getType(target);
        if (frameworkParam.style == Parameter.Style.FORM) {
            this.formParams.put(JaxRsParameterProcessor.paramName((AnnotationInstance)annotation), annotation);
            this.readFrameworkParameter(annotation, frameworkParam, overriddenParametersOnly);
        } else if (frameworkParam.style == Parameter.Style.MATRIX) {
            List pathSegments = beanParamAnnotation != null ? this.lastPathSegmentsOf(beanParamAnnotation.target()) : this.lastPathSegmentsOf(target);
            boolean isPathSegmentsEmpty = pathSegments == null || pathSegments.isEmpty();
            String pathSegment = !isPathSegmentsEmpty ? (String)pathSegments.get(0) : null;
            this.matrixParams.computeIfAbsent(pathSegment, k -> new HashMap()).put(JaxRsParameterProcessor.paramName((AnnotationInstance)annotation), annotation);
        } else if (frameworkParam.location == Parameter.In.PATH && targetType != null && JaxRsConstants.PATH_SEGMENT.contains(targetType.name())) {
            String pathSegment = (String)this.scannerContext.annotations().value(annotation);
            this.matrixParams.computeIfAbsent(pathSegment, k -> new HashMap());
        } else if (frameworkParam.location != null) {
            this.readFrameworkParameter(annotation, frameworkParam, overriddenParametersOnly);
        } else if (target != null) {
            ClassInfo beanParam;
            this.setMediaType(frameworkParam);
            targetType = TypeUtil.unwrapType((Type)targetType);
            if (targetType != null && (beanParam = this.index.getClassByName(targetType.name())) != null) {
                this.scannerContext.getResolverStack().push(TypeResolver.forClass((AnnotationScannerContext)this.scannerContext, (ClassInfo)beanParam, (Type)targetType));
                this.readParametersInherited(beanParam, annotation, overriddenParametersOnly);
                this.scannerContext.getResolverStack().pop();
            }
        }
    }

    protected Set<DotName> getDefaultAnnotationNames() {
        return JaxRsConstants.DEFAULT_VALUE;
    }

    protected String getDefaultAnnotationProperty() {
        return "value";
    }

    protected List<String> pathsOf(AnnotationTarget target) {
        AnnotationInstance path = null;
        String pathValue = null;
        switch (target.kind()) {
            case CLASS: {
                path = this.scannerContext.annotations().getAnnotation(target, JaxRsConstants.PATH);
                pathValue = (String)this.scannerContext.getConfig().getScanResourceClasses().get(target.asClass().name().toString());
                break;
            }
            case METHOD: {
                path = this.pathOf(target.asMethod());
                break;
            }
        }
        if (pathValue == null && path != null) {
            pathValue = path.value().asString();
        }
        if (pathValue != null) {
            if (pathValue.startsWith("/")) {
                pathValue = pathValue.substring(1);
            }
            if (pathValue.endsWith("/")) {
                pathValue = pathValue.substring(0, pathValue.length() - 1);
            }
            return List.of(pathValue);
        }
        return List.of("");
    }

    AnnotationInstance pathOf(MethodInfo method) {
        return this.scannerContext.getAugmentedIndex().ancestry(method).entrySet().stream().map(Map.Entry::getValue).filter(Objects::nonNull).map(m -> this.scannerContext.annotations().getAnnotation((AnnotationTarget)m, JaxRsConstants.PATH)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isSubResourceLocator(MethodInfo method) {
        switch (method.returnType().kind()) {
            case CLASS: 
            case PARAMETERIZED_TYPE: 
            case TYPE_VARIABLE: {
                if (!this.scannerContext.annotations().hasAnnotation((AnnotationTarget)method, JaxRsConstants.PATH)) return false;
                if (!method.annotations().stream().map(AnnotationInstance::name).noneMatch(JaxRsConstants.HTTP_METHODS::contains)) return false;
                return true;
            }
        }
        return false;
    }

    protected boolean isResourceMethod(MethodInfo method) {
        return this.scannerContext.getAugmentedIndex().ancestry(method).entrySet().stream().map(Map.Entry::getValue).filter(Objects::nonNull).flatMap(m -> m.annotations().stream()).map(AnnotationInstance::name).anyMatch(JaxRsConstants.HTTP_METHODS::contains);
    }

    protected boolean isParameter(DotName annotationName) {
        if (JaxRsParameter.isParameter(annotationName)) {
            return true;
        }
        if (Names.PARAMETER.equals((Object)annotationName)) {
            return true;
        }
        return Names.PARAMETERS.equals((Object)annotationName);
    }
}

