/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.internal;

import jakarta.persistence.criteria.Expression;
import jakarta.persistence.metamodel.EntityType;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Date;
import java.util.Objects;
import org.hibernate.AssertionFailure;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MappedSuperclassDomainType;
import org.hibernate.metamodel.model.domain.internal.EntityDiscriminatorSqmPathSource;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.BinaryArithmeticOperator;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.UnaryArithmeticOperator;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.domain.SqmDomainType;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmPluralValuedSimplePath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmLiteralNull;
import org.hibernate.query.sqm.tuple.TupleType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.BasicType;
import org.hibernate.type.BindingContext;
import org.hibernate.type.ConvertedBasicType;
import org.hibernate.type.QueryParameterJavaObjectType;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.JavaTypeHelper;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class TypecheckUtil {
    public static boolean areTypesComparable(SqmBindableType<?> lhsType, SqmBindableType<?> rhsType, BindingContext bindingContext) {
        EntityDiscriminatorSqmPathSource discriminatorSource;
        if (lhsType == null || rhsType == null || lhsType == rhsType) {
            return true;
        }
        if (JavaTypeHelper.isUnknown(lhsType.getExpressibleJavaType()) || JavaTypeHelper.isUnknown(rhsType.getExpressibleJavaType())) {
            return true;
        }
        if (lhsType instanceof QueryParameterJavaObjectType || rhsType instanceof QueryParameterJavaObjectType) {
            return true;
        }
        if (lhsType instanceof SqmCriteriaNodeBuilder.MultiValueParameterType || rhsType instanceof SqmCriteriaNodeBuilder.MultiValueParameterType) {
            return true;
        }
        SqmDomainType lhsDomainType = lhsType.getSqmType();
        SqmDomainType rhsDomainType = rhsType.getSqmType();
        EmbeddableDomainType<?> lhsEmbeddable = TypecheckUtil.getEmbeddableType(lhsDomainType);
        EmbeddableDomainType<?> rhsEmbeddable = TypecheckUtil.getEmbeddableType(rhsDomainType);
        if (lhsEmbeddable != null && rhsEmbeddable != null) {
            return TypecheckUtil.areEmbeddableTypesComparable(lhsEmbeddable, rhsEmbeddable);
        }
        if (lhsDomainType instanceof TupleType) {
            TupleType lhsTuple = (TupleType)((Object)lhsDomainType);
            if (rhsDomainType instanceof TupleType) {
                TupleType rhsTuple = (TupleType)((Object)rhsDomainType);
                return TypecheckUtil.areTupleTypesComparable(bindingContext, lhsTuple, rhsTuple);
            }
        }
        if (lhsEmbeddable != null && rhsDomainType instanceof TupleType || rhsEmbeddable != null && lhsDomainType instanceof TupleType) {
            return true;
        }
        if (lhsDomainType instanceof EntityType) {
            EntityType lhsEntity = (EntityType)lhsDomainType;
            if (rhsDomainType instanceof EntityType) {
                EntityType rhsEntity = (EntityType)rhsDomainType;
                return TypecheckUtil.areEntityTypesComparable(lhsEntity, rhsEntity, bindingContext);
            }
        }
        if (lhsDomainType instanceof EntityDiscriminatorSqmPathSource) {
            discriminatorSource = (EntityDiscriminatorSqmPathSource)lhsDomainType;
            return TypecheckUtil.isDiscriminatorTypeComparable(discriminatorSource, rhsDomainType, bindingContext);
        }
        if (rhsDomainType instanceof EntityDiscriminatorSqmPathSource) {
            discriminatorSource = (EntityDiscriminatorSqmPathSource)rhsDomainType;
            return TypecheckUtil.isDiscriminatorTypeComparable(discriminatorSource, lhsDomainType, bindingContext);
        }
        if (lhsDomainType instanceof JdbcMapping) {
            JdbcMapping rhsMapping;
            JdbcMapping lhsMapping = (JdbcMapping)((Object)lhsDomainType);
            if (rhsDomainType instanceof JdbcMapping && TypecheckUtil.areJdbcMappingsComparable(lhsMapping, rhsMapping = (JdbcMapping)((Object)rhsDomainType), bindingContext)) {
                return true;
            }
        }
        if ((TypecheckUtil.isConvertedType(lhsType) || TypecheckUtil.isConvertedType(rhsType)) && TypecheckUtil.sameJavaType(lhsType, rhsType)) {
            return true;
        }
        return lhsType.getRelationalJavaType() == rhsType.getRelationalJavaType();
    }

    private static boolean areJdbcMappingsComparable(JdbcMapping lhsJdbcMapping, JdbcMapping rhsJdbcMapping, BindingContext bindingContext) {
        if (TypecheckUtil.areJdbcTypesComparable(lhsJdbcMapping.getJdbcType(), rhsJdbcMapping.getJdbcType())) {
            return true;
        }
        if (lhsJdbcMapping.getValueConverter() != null || rhsJdbcMapping.getValueConverter() != null) {
            JdbcMapping lhsDomainMapping = TypecheckUtil.getDomainJdbcType(lhsJdbcMapping, bindingContext);
            JdbcMapping rhsDomainMapping = TypecheckUtil.getDomainJdbcType(rhsJdbcMapping, bindingContext);
            return lhsDomainMapping != null && rhsDomainMapping != null && TypecheckUtil.areJdbcTypesComparable(lhsDomainMapping.getJdbcType(), rhsDomainMapping.getJdbcType());
        }
        return false;
    }

    private static boolean areJdbcTypesComparable(JdbcType lhsJdbcType, JdbcType rhsJdbcType) {
        return lhsJdbcType.getJdbcTypeCode() == rhsJdbcType.getJdbcTypeCode() || lhsJdbcType.isStringLike() && rhsJdbcType.isStringLike() || lhsJdbcType.isTemporal() && rhsJdbcType.isTemporal() || lhsJdbcType.isNumber() && rhsJdbcType.isNumber();
    }

    private static JdbcMapping getDomainJdbcType(JdbcMapping jdbcMapping, BindingContext bindingContext) {
        BasicType basicType;
        BasicValueConverter<?, ?> valueConverter = jdbcMapping.getValueConverter();
        if (valueConverter != null && (basicType = bindingContext.getTypeConfiguration().getBasicTypeForJavaType(valueConverter.getDomainJavaType().getJavaType())) != null) {
            return basicType.getJdbcMapping();
        }
        return jdbcMapping;
    }

    private static EmbeddableDomainType<?> getEmbeddableType(DomainType<?> expressible) {
        EmbeddableDomainType embeddableDomainType;
        return expressible instanceof EmbeddableDomainType ? (embeddableDomainType = (EmbeddableDomainType)expressible) : null;
    }

    private static boolean areEmbeddableTypesComparable(EmbeddableDomainType<?> lhsType, EmbeddableDomainType<?> rhsType) {
        return rhsType.getJavaType() == lhsType.getJavaType() || lhsType.isPolymorphic() && TypecheckUtil.getRootEmbeddableType(lhsType) == TypecheckUtil.getRootEmbeddableType(rhsType);
    }

    private static ManagedDomainType<?> getRootEmbeddableType(EmbeddableDomainType<?> embeddableType) {
        ManagedDomainType<Object> rootType = embeddableType;
        while (rootType.getSuperType() != null) {
            rootType = rootType.getSuperType();
        }
        return rootType;
    }

    private static boolean areTupleTypesComparable(BindingContext bindingContext, TupleType<?> lhsTuple, TupleType<?> rhsTuple) {
        if (rhsTuple.componentCount() != lhsTuple.componentCount()) {
            return false;
        }
        for (int i = 0; i < lhsTuple.componentCount(); ++i) {
            if (TypecheckUtil.areTypesComparable(lhsTuple.get(i), rhsTuple.get(i), bindingContext)) continue;
            return false;
        }
        return true;
    }

    private static boolean areEntityTypesComparable(EntityType<?> lhsType, EntityType<?> rhsType, BindingContext bindingContext) {
        EntityPersister lhsEntity = TypecheckUtil.getEntityDescriptor(bindingContext, lhsType.getName());
        EntityPersister rhsEntity = TypecheckUtil.getEntityDescriptor(bindingContext, rhsType.getName());
        return lhsEntity.getRootEntityName().equals(rhsEntity.getRootEntityName());
    }

    private static boolean isDiscriminatorTypeComparable(EntityDiscriminatorSqmPathSource<?> lhsDiscriminator, DomainType<?> rhsType, BindingContext bindingContext) {
        String entityName = lhsDiscriminator.getEntityDomainType().getHibernateEntityName();
        EntityPersister lhsEntity = bindingContext.getMappingMetamodel().getEntityDescriptor(entityName);
        if (rhsType instanceof EntityType) {
            EntityType entityType = (EntityType)rhsType;
            String rhsEntityName = entityType.getName();
            EntityPersister rhsEntity = TypecheckUtil.getEntityDescriptor(bindingContext, rhsEntityName);
            return lhsEntity.getRootEntityName().equals(rhsEntity.getRootEntityName());
        }
        if (rhsType instanceof EntityDiscriminatorSqmPathSource) {
            EntityDiscriminatorSqmPathSource discriminator = (EntityDiscriminatorSqmPathSource)rhsType;
            String rhsEntityName = discriminator.getEntityDomainType().getHibernateEntityName();
            EntityPersister rhsEntity = bindingContext.getMappingMetamodel().getEntityDescriptor(rhsEntityName);
            return rhsEntity.getRootEntityName().equals(lhsEntity.getRootEntityName());
        }
        if (rhsType instanceof SqmBindableType) {
            SqmBindableType rhsExpressible = (SqmBindableType)((Object)rhsType);
            SqmBindableType discriminatorType = (SqmBindableType)((Object)lhsDiscriminator.getEntityMapping().getDiscriminatorMapping().getMappedType());
            return TypecheckUtil.areTypesComparable(discriminatorType, rhsExpressible, bindingContext);
        }
        throw new AssertionFailure("Not a SqmExpressible");
    }

    private static boolean isTypeAssignable(SqmBindableType<?> targetType, SqmBindableType<?> expressionType, BindingContext bindingContext) {
        if (targetType == null || expressionType == null || targetType == expressionType) {
            return true;
        }
        if (JavaTypeHelper.isUnknown(targetType.getExpressibleJavaType()) || JavaTypeHelper.isUnknown(expressionType.getExpressibleJavaType())) {
            return true;
        }
        if (targetType instanceof EntityType) {
            EntityType targetEntity = (EntityType)targetType;
            if (expressionType instanceof EntityType) {
                EntityType expressionEntity = (EntityType)expressionType;
                return TypecheckUtil.isEntityTypeAssignable(targetEntity, expressionEntity, bindingContext);
            }
        }
        if (targetType instanceof MappedSuperclassDomainType) {
            MappedSuperclassDomainType expressionMappedSuperclass = (MappedSuperclassDomainType)((Object)targetType);
            if (expressionType instanceof EntityType) {
                EntityType expressionEntity = (EntityType)expressionType;
                return TypecheckUtil.isMappedSuperclassTypeAssignable(expressionMappedSuperclass, expressionEntity, bindingContext);
            }
        }
        SqmDomainType lhsDomainType = targetType.getSqmType();
        SqmDomainType rhsDomainType = expressionType.getSqmType();
        if (lhsDomainType instanceof JdbcMapping) {
            JdbcMapping lhsMapping = (JdbcMapping)((Object)lhsDomainType);
            if (rhsDomainType instanceof JdbcMapping) {
                JdbcMapping rhsMapping = (JdbcMapping)((Object)rhsDomainType);
                JdbcType lhsJdbcType = lhsMapping.getJdbcType();
                JdbcType rhsJdbcType = rhsMapping.getJdbcType();
                if (lhsJdbcType.getJdbcTypeCode() == rhsJdbcType.getJdbcTypeCode() || lhsJdbcType.isStringLike() && rhsJdbcType.isStringLike() || lhsJdbcType.isInteger() && rhsJdbcType.isInteger() || lhsJdbcType.isFloat() && rhsJdbcType.isNumber() || lhsJdbcType.isDecimal() && rhsJdbcType.isNumber()) {
                    return true;
                }
            }
        }
        if ((TypecheckUtil.isConvertedType(targetType) || TypecheckUtil.isConvertedType(expressionType)) && TypecheckUtil.sameJavaType(targetType, expressionType)) {
            return true;
        }
        return targetType.getRelationalJavaType() == expressionType.getRelationalJavaType();
    }

    private static boolean sameJavaType(SqmBindableType<?> leftType, SqmBindableType<?> rightType) {
        return TypecheckUtil.canonicalize(leftType.getJavaType()) == TypecheckUtil.canonicalize(rightType.getJavaType());
    }

    private static boolean isConvertedType(SqmExpressible<?> type) {
        return type.getSqmType() instanceof ConvertedBasicType;
    }

    private static Class<?> canonicalize(Class<?> lhs) {
        return switch (lhs.getCanonicalName()) {
            case "boolean" -> Boolean.class;
            case "byte" -> Byte.class;
            case "short" -> Short.class;
            case "int" -> Integer.class;
            case "long" -> Long.class;
            case "float" -> Float.class;
            case "double" -> Double.class;
            case "char" -> Character.class;
            default -> lhs;
        };
    }

    private static boolean isMappedSuperclassTypeAssignable(MappedSuperclassDomainType<?> lhsType, EntityType<?> rhsType, BindingContext bindingContext) {
        for (ManagedDomainType candidate : lhsType.getSubTypes()) {
            MappedSuperclassDomainType candidateMappedSuperclass;
            EntityType candidateEntityType;
            if (candidate instanceof EntityType && TypecheckUtil.isEntityTypeAssignable(candidateEntityType = (EntityType)candidate, rhsType, bindingContext)) {
                return true;
            }
            if (!(candidate instanceof MappedSuperclassDomainType) || !TypecheckUtil.isMappedSuperclassTypeAssignable(candidateMappedSuperclass = (MappedSuperclassDomainType)candidate, rhsType, bindingContext)) continue;
            return true;
        }
        return false;
    }

    private static boolean isEntityTypeAssignable(EntityType<?> lhsType, EntityType<?> rhsType, BindingContext bindingContext) {
        EntityPersister lhsEntity = TypecheckUtil.getEntityDescriptor(bindingContext, lhsType.getName());
        EntityPersister rhsEntity = TypecheckUtil.getEntityDescriptor(bindingContext, rhsType.getName());
        return lhsEntity.isSubclassEntityName(rhsEntity.getEntityName());
    }

    private static EntityPersister getEntityDescriptor(BindingContext bindingContext, String name) {
        return bindingContext.getMappingMetamodel().getEntityDescriptor(bindingContext.getJpaMetamodel().qualifyImportableName(name));
    }

    public static void assertComparable(Expression<?> x, Expression<?> y, BindingContext bindingContext) {
        SqmExpression left = (SqmExpression)x;
        SqmExpression right = (SqmExpression)y;
        Integer leftTupleLength = left.getTupleLength();
        Integer rightTupleLength = right.getTupleLength();
        if (leftTupleLength != null && rightTupleLength != null && leftTupleLength.intValue() != rightTupleLength.intValue()) {
            throw new SemanticException("Cannot compare tuples of different lengths");
        }
        if (left instanceof SqmPluralValuedSimplePath || right instanceof SqmPluralValuedSimplePath) {
            throw new SemanticException("Multivalued paths are only allowed for the 'member of' operator");
        }
        if (!(left instanceof SqmLiteralNull) && !(right instanceof SqmLiteralNull)) {
            SqmBindableType leftType = left.getExpressible();
            SqmBindableType rightType = right.getExpressible();
            if (leftType != null && rightType != null && left.isEnum() && right.isEnum()) {
                if (!Objects.equals(leftType.getTypeName(), rightType.getTypeName())) {
                    String.format("Cannot compare left expression of enumerated type '%s' with right expression of enumerated type '%s'", leftType.getTypeName(), rightType.getTypeName());
                }
            } else if (!TypecheckUtil.areTypesComparable(leftType, rightType, bindingContext)) {
                throw new SemanticException(String.format("Cannot compare left expression of type '%s' with right expression of type '%s'", leftType.getTypeName(), rightType.getTypeName()));
            }
        }
    }

    public static void assertAssignable(String hqlString, SqmPath<?> targetPath, SqmTypedNode<?> expression, BindingContext bindingContext) {
        if (!(expression instanceof SqmLiteralNull)) {
            SqmBindableType<?> targetType = targetPath.getNodeType();
            SqmBindableType<?> expressionType = expression.getNodeType();
            if (targetType != null && expressionType != null && targetPath.isEnum()) {
                if (!Objects.equals(targetType.getTypeName(), expressionType.getTypeName())) {
                    String.format("Cannot compare left expression of enumerated type '%s' with right expression of enumerated type '%s'", targetType.getTypeName(), expressionType.getTypeName());
                }
            } else if (!TypecheckUtil.isTypeAssignable(targetType, expressionType, bindingContext)) {
                throw new SemanticException(String.format("Cannot assign expression of type '%s' to target path '%s' of type '%s'", expressionType.getTypeName(), targetPath.toHqlString(), targetType.getTypeName()), hqlString, null);
            }
        }
    }

    public static void assertOperable(SqmExpression<?> left, SqmExpression<?> right, BinaryArithmeticOperator op) {
        block18: {
            SqmBindableType rightNodeType;
            SqmBindableType leftNodeType;
            block21: {
                Class<?> rightJavaType;
                Class<?> leftJavaType;
                block20: {
                    block19: {
                        leftNodeType = left.getExpressible();
                        rightNodeType = right.getExpressible();
                        if (leftNodeType == null || rightNodeType == null) break block18;
                        leftJavaType = leftNodeType.getRelationalJavaType().getJavaTypeClass();
                        rightJavaType = rightNodeType.getRelationalJavaType().getJavaTypeClass();
                        if (!Number.class.isAssignableFrom(leftJavaType)) break block19;
                        switch (op) {
                            case MULTIPLY: {
                                if (!Number.class.isAssignableFrom(rightJavaType) && !TemporalAmount.class.isAssignableFrom(rightJavaType)) {
                                    throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + rightNodeType.getTypeName() + "' which is not a numeric type (it is not an instance of 'java.lang.Number' or 'java.time.TemporalAmount')");
                                }
                                break block18;
                            }
                            default: {
                                if (!Number.class.isAssignableFrom(rightJavaType)) {
                                    throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + rightNodeType.getTypeName() + "' which is not a numeric type (it is not an instance of 'java.lang.Number')");
                                }
                                break block18;
                            }
                        }
                    }
                    if (!TemporalAmount.class.isAssignableFrom(leftJavaType)) break block20;
                    switch (op) {
                        case ADD: 
                        case SUBTRACT: {
                            if (!TemporalAmount.class.isAssignableFrom(rightJavaType)) {
                                throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + rightNodeType.getTypeName() + "' which is not a temporal amount (it is not an instance of 'java.time.TemporalAmount')");
                            }
                            break block18;
                        }
                        default: {
                            throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + leftNodeType.getTypeName() + "' which is not a numeric type (it is not an instance of 'java.lang.Number')");
                        }
                    }
                }
                if (!Temporal.class.isAssignableFrom(leftJavaType) && !Date.class.isAssignableFrom(leftJavaType)) break block21;
                switch (op) {
                    case ADD: {
                        if (!TemporalAmount.class.isAssignableFrom(rightJavaType)) {
                            throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + rightNodeType.getTypeName() + "' which is not a temporal amount (it is not an instance of 'java.time.TemporalAmount')");
                        }
                        break block18;
                    }
                    case SUBTRACT: {
                        if (!(Temporal.class.isAssignableFrom(rightJavaType) || Date.class.isAssignableFrom(rightJavaType) || TemporalAmount.class.isAssignableFrom(rightJavaType))) {
                            throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + rightNodeType.getTypeName() + "' which is not a temporal amount (it is not an instance of 'java.time.TemporalAmount')");
                        }
                        break block18;
                    }
                    default: {
                        throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + leftNodeType.getTypeName() + "' which is not a numeric type (it is not an instance of 'java.lang.Number')");
                    }
                }
            }
            if (TypecheckUtil.isNumberArray(leftNodeType)) {
                if (!TypecheckUtil.isNumberArray(rightNodeType)) {
                    throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + rightNodeType.getTypeName() + "' which is not a numeric array type (it is not an instance of 'java.lang.Number[]')");
                }
            } else {
                throw new SemanticException("Operand of " + op.getOperatorSqlText() + " is of type '" + leftNodeType.getTypeName() + "' which is not a numeric type (it is not an instance of 'java.lang.Number', 'java.time.Temporal', or 'java.time.TemporalAmount')");
            }
        }
    }

    public static boolean isNumberArray(SqmExpressible<?> expressible) {
        SqmDomainType<?> domainType;
        if (expressible != null && (domainType = expressible.getSqmType()) != null) {
            BasicPluralType basicPluralType;
            return domainType instanceof BasicPluralType && Number.class.isAssignableFrom((basicPluralType = (BasicPluralType)domainType).getElementType().getJavaType());
        }
        return false;
    }

    public static void assertString(SqmExpression<?> expression) {
        JdbcMapping jdbcMapping;
        SqmDomainType sqmDomainType;
        SqmBindableType<?> nodeType = expression.getNodeType();
        if (!(nodeType == null || (sqmDomainType = nodeType.getSqmType()) instanceof JdbcMapping && (jdbcMapping = (JdbcMapping)((Object)sqmDomainType)).getJdbcType().isStringLike())) {
            throw new SemanticException("Operand of 'like' is of type '" + nodeType.getTypeName() + "' which is not a string (its JDBC type code is not string-like)");
        }
    }

    public static void assertDuration(SqmExpression<?> expression) {
        JdbcMapping jdbcMapping;
        SqmDomainType sqmDomainType;
        SqmBindableType<?> nodeType = expression.getNodeType();
        if (!(nodeType == null || (sqmDomainType = nodeType.getSqmType()) instanceof JdbcMapping && (jdbcMapping = (JdbcMapping)((Object)sqmDomainType)).getJdbcType().isDuration())) {
            throw new SemanticException("Operand of 'by' is of type '" + nodeType.getTypeName() + "' which is not a duration (its JDBC type code is not duration-like)");
        }
    }

    public static void assertNumeric(SqmExpression<?> expression, UnaryArithmeticOperator op) {
        JdbcMapping jdbcMapping;
        SqmDomainType sqmDomainType;
        SqmBindableType nodeType = expression.getExpressible();
        if (!(nodeType == null || (sqmDomainType = nodeType.getSqmType()) instanceof JdbcMapping && (jdbcMapping = (JdbcMapping)((Object)sqmDomainType)).getJdbcType().isNumber())) {
            throw new SemanticException("Operand of " + op.getOperatorChar() + " is of type '" + nodeType.getTypeName() + "' which is not a numeric type (its JDBC type code is not numeric)");
        }
    }
}

