/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.io.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContextFactory;
import org.locationtech.spatial4j.io.jackson.ShapeDeserializer;
import org.locationtech.spatial4j.shape.Shape;

public class GeometryDeserializer
extends JsonDeserializer<Geometry> {
    static final JtsSpatialContext JTS;
    final ShapeDeserializer dser = new ShapeDeserializer(JTS);

    public Geometry deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        Shape shape = this.dser.deserialize(jp, ctxt);
        if (shape != null) {
            return JTS.getShapeFactory().getGeometryFrom(shape);
        }
        return null;
    }

    static {
        JtsSpatialContextFactory factory = new JtsSpatialContextFactory();
        factory.geo = false;
        factory.useJtsLineString = true;
        factory.useJtsMulti = true;
        factory.useJtsPoint = true;
        JTS = new JtsSpatialContext(factory);
    }
}

