# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2011 Kristian Høgsberg
# Copyright © 2010-2011 Intel Corporation
# Copyright © 2012-2013 Collabora, Ltd.
#
# Permission is hereby granted, free of charge, to any person
# obtaining a copy of this software and associated documentation files
# (the "Software"), to deal in the Software without restriction,
# including without limitation the rights to use, copy, modify, merge,
# publish, distribute, sublicense, and/or sell copies of the Software,
# and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice (including the
# next paragraph) shall be included in all copies or substantial
# portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
# BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
# ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from .wl_registry import WlRegistry


class WlFixes(Interface):
    """Wayland protocol fixes

    This global fixes problems with other core-protocol interfaces that cannot
    be fixed in these interfaces themselves.
    """

    name = "wl_fixes"
    version = 1


class WlFixesProxy(Proxy[WlFixes]):
    interface = WlFixes

    @WlFixes.request()
    def destroy(self) -> None:
        """Destroys this object
        """
        self._marshal(0)
        self._destroy()

    @WlFixes.request(
        Argument(ArgumentType.Object, interface=WlRegistry),
    )
    def destroy_registry(self, registry: WlRegistry) -> None:
        """Destroy a :class:`~pywayland.protocol.wayland.WlRegistry`

        This request destroys a :class:`~pywayland.protocol.wayland.WlRegistry`
        object.

        The client should no longer use the
        :class:`~pywayland.protocol.wayland.WlRegistry` after making this
        request.

        The compositor will emit a :func:`WlDisplay.delete_id()
        <pywayland.protocol.wayland.WlDisplay.delete_id>` event with the object
        ID of the registry and will no longer emit any events on the registry.
        The client should re-use the object ID once it receives the
        :func:`WlDisplay.delete_id()
        <pywayland.protocol.wayland.WlDisplay.delete_id>` event.

        :param registry:
            the registry to destroy
        :type registry:
            :class:`~pywayland.protocol.wayland.WlRegistry`
        """
        self._marshal(1, registry)


class WlFixesResource(Resource):
    interface = WlFixes


class WlFixesGlobal(Global):
    interface = WlFixes


WlFixes._gen_c()
WlFixes.proxy_class = WlFixesProxy
WlFixes.resource_class = WlFixesResource
WlFixes.global_class = WlFixesGlobal
