/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.bitvectors;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.hnsw.RandomVectorScorerSupplier;

public class FlatBitVectorsScorer
implements FlatVectorsScorer {
    public RandomVectorScorerSupplier getRandomVectorScorerSupplier(VectorSimilarityFunction similarityFunction, RandomAccessVectorValues vectorValues) throws IOException {
        assert (vectorValues instanceof RandomAccessVectorValues.Bytes);
        if (vectorValues instanceof RandomAccessVectorValues.Bytes) {
            return new BitRandomVectorScorerSupplier((RandomAccessVectorValues.Bytes)vectorValues);
        }
        throw new IllegalArgumentException("vectorValues must be an instance of RandomAccessVectorValues.Bytes");
    }

    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, RandomAccessVectorValues vectorValues, float[] target) throws IOException {
        throw new IllegalArgumentException("bit vectors do not support float[] targets");
    }

    public RandomVectorScorer getRandomVectorScorer(VectorSimilarityFunction similarityFunction, RandomAccessVectorValues vectorValues, byte[] target) throws IOException {
        assert (vectorValues instanceof RandomAccessVectorValues.Bytes);
        if (vectorValues instanceof RandomAccessVectorValues.Bytes) {
            return new BitRandomVectorScorer((RandomAccessVectorValues.Bytes)vectorValues, target);
        }
        throw new IllegalArgumentException("vectorValues must be an instance of RandomAccessVectorValues.Bytes");
    }

    public String toString() {
        return "FlatBitVectorsScorer()";
    }

    static class BitRandomVectorScorerSupplier
    implements RandomVectorScorerSupplier {
        protected final RandomAccessVectorValues.Bytes vectorValues;
        protected final RandomAccessVectorValues.Bytes vectorValues1;
        protected final RandomAccessVectorValues.Bytes vectorValues2;

        public BitRandomVectorScorerSupplier(RandomAccessVectorValues.Bytes vectorValues) throws IOException {
            this.vectorValues = vectorValues;
            this.vectorValues1 = vectorValues.copy();
            this.vectorValues2 = vectorValues.copy();
        }

        public RandomVectorScorer scorer(int ord) throws IOException {
            byte[] query = this.vectorValues1.vectorValue(ord);
            return new BitRandomVectorScorer(this.vectorValues2, query);
        }

        public RandomVectorScorerSupplier copy() throws IOException {
            return new BitRandomVectorScorerSupplier(this.vectorValues.copy());
        }
    }

    static class BitRandomVectorScorer
    implements RandomVectorScorer {
        private final RandomAccessVectorValues.Bytes vectorValues;
        private final int bitDimensions;
        private final byte[] query;

        BitRandomVectorScorer(RandomAccessVectorValues.Bytes vectorValues, byte[] query) {
            this.query = query;
            this.bitDimensions = vectorValues.dimension() * 8;
            this.vectorValues = vectorValues;
        }

        public float score(int node) throws IOException {
            return (float)(this.bitDimensions - VectorUtil.xorBitCount((byte[])this.query, (byte[])this.vectorValues.vectorValue(node))) / (float)this.bitDimensions;
        }

        public int maxOrd() {
            return this.vectorValues.size();
        }

        public int ordToDoc(int ord) {
            return this.vectorValues.ordToDoc(ord);
        }

        public Bits getAcceptOrds(Bits acceptDocs) {
            return this.vectorValues.getAcceptOrds(acceptDocs);
        }
    }
}

