/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.PrintWriter;

public class ServletWriter
implements AutoCloseable {
    private static final int TAB_WIDTH = 2;
    private static final String SPACES = "                              ";
    private int indent = 0;
    private int virtual_indent = 0;
    private final PrintWriter writer;
    private int javaLine = 1;

    public ServletWriter(PrintWriter printWriter) {
        this.writer = printWriter;
    }

    @Override
    public void close() {
        this.writer.close();
    }

    public int getJavaLine() {
        return this.javaLine;
    }

    public void pushIndent() {
        this.virtual_indent += 2;
        if (this.virtual_indent >= 0 && this.virtual_indent <= SPACES.length()) {
            this.indent = this.virtual_indent;
        }
    }

    public void popIndent() {
        this.virtual_indent -= 2;
        if (this.virtual_indent >= 0 && this.virtual_indent <= SPACES.length()) {
            this.indent = this.virtual_indent;
        }
    }

    public void println(String string) {
        ++this.javaLine;
        this.writer.println(string);
    }

    public void println() {
        ++this.javaLine;
        this.writer.println("");
    }

    public void printin() {
        this.writer.print(SPACES.substring(0, this.indent));
    }

    public void printin(String string) {
        this.writer.print(SPACES.substring(0, this.indent));
        this.writer.print(string);
    }

    public void printil(String string) {
        ++this.javaLine;
        this.writer.print(SPACES.substring(0, this.indent));
        this.writer.println(string);
    }

    public void print(char c) {
        this.writer.print(c);
    }

    public void print(int n) {
        this.writer.print(n);
    }

    public void print(String string) {
        this.writer.print(string);
    }

    public void printMultiLn(String string) {
        int n = 0;
        while ((n = string.indexOf(10, n)) > -1) {
            ++this.javaLine;
            ++n;
        }
        this.writer.print(string);
    }
}

