// Boost.Geometry (aka GGL, Generic Geometry Library)

// Copyright (c) 2008-2012 Barend Gehrels, Amsterdam, the Netherlands.

// This file was modified by Oracle on 2017, 2018, 2020.
// Modifications copyright (c) 2017-2020, Oracle and/or its affiliates.
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)


#ifndef BOOST_GEOMETRY_PROJECTIONS_EPGS_HPP
#define BOOST_GEOMETRY_PROJECTIONS_EPGS_HPP


#include <boost/geometry/srs/projections/code.hpp>


namespace boost { namespace geometry { namespace projections
{


#ifndef DOXYGEN_NO_DETAIL
namespace detail
{

    inline srs::dpar::parameters<> epsg_to_parameters(int code)
    {
        using namespace srs::dpar;

        static const code_element arr[] = {
            {2000, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-62)(k,0.9995000000000001)(x_0,400000)(y_0,0)(ellps_clrk80)(units_m)(no_defs)},
            {2001, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-62)(k,0.9995000000000001)(x_0,400000)(y_0,0)(ellps_clrk80)(units_m)(no_defs)},
            {2002, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-62)(k,0.9995000000000001)(x_0,400000)(y_0,0)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(725,685,536,0,0,0,0))(units_m)(no_defs)},
            {2003, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-62)(k,0.9995000000000001)(x_0,400000)(y_0,0)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(72,213.7,93,0,0,0,0))(units_m)(no_defs)},
            {2004, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-62)(k,0.9995000000000001)(x_0,400000)(y_0,0)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(174,359,365,0,0,0,0))(units_m)(no_defs)},
            {2005, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-62)(k,0.9995000000000001)(x_0,400000)(y_0,0)(ellps_clrk80)(units_m)(no_defs)},
            {2006, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-62)(k,0.9995000000000001)(x_0,400000)(y_0,0)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-149,128,296,0,0,0,0))(units_m)(no_defs)},
            {2007, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-62)(k,0.9995000000000001)(x_0,400000)(y_0,0)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(195.671,332.517,274.607,0,0,0,0))(units_m)(no_defs)},
            {2008, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-55.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2009, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-58.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2010, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-61.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2011, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-64.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2012, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-67.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2013, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-70.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2014, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-73.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2015, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-76.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2016, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-79.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2017, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-73.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2018, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-76.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2019, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-79.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2020, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-82.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2021, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-81)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2022, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-84)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2023, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-87)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2024, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-90)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2025, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-93)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2026, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-96)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2027, srs::dpar::parameters<>(proj_utm)(zone,15)(ellps_clrk66)(units_m)(no_defs)},
            {2028, srs::dpar::parameters<>(proj_utm)(zone,16)(ellps_clrk66)(units_m)(no_defs)},
            {2029, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_clrk66)(units_m)(no_defs)},
            {2030, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_clrk66)(units_m)(no_defs)},
            {2031, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_clrk66)(units_m)(no_defs)},
            {2032, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_clrk66)(units_m)(no_defs)},
            {2033, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_clrk66)(units_m)(no_defs)},
            {2034, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_clrk66)(units_m)(no_defs)},
            {2035, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_clrk66)(units_m)(no_defs)},
            {2036, srs::dpar::parameters<>(proj_sterea)(lat_0,46.5)(lon_0,-66.5)(k,0.999912)(x_0,2500000)(y_0,7500000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2037, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2038, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2039, srs::dpar::parameters<>(proj_tmerc)(lat_0,31.73439361111111)(lon_0,35.20451694444445)(k,1.0000067)(x_0,219529.584)(y_0,626907.39)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-48,55,52,0,0,0,0))(units_m)(no_defs)},
            {2040, srs::dpar::parameters<>(proj_utm)(zone,30)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-125,53,467,0,0,0,0))(units_m)(no_defs)},
            {2041, srs::dpar::parameters<>(proj_utm)(zone,30)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-124.76,53,466.79,0,0,0,0))(units_m)(no_defs)},
            {2042, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-125,53,467,0,0,0,0))(units_m)(no_defs)},
            {2043, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-124.76,53,466.79,0,0,0,0))(units_m)(no_defs)},
            {2044, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,18500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(-17.51,-108.32,-62.39,0,0,0,0))(units_m)(no_defs)},
            {2045, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,19500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(-17.51,-108.32,-62.39,0,0,0,0))(units_m)(no_defs)},
            //{2046},
            //{2047},
            //{2048},
            //{2049},
            //{2050},
            //{2051},
            //{2052},
            //{2053},
            //{2054},
            //{2055},
            {2056, srs::dpar::parameters<>(proj_somerc)(lat_0,46.95240555555556)(lon_0,7.439583333333333)(k_0,1)(x_0,2600000)(y_0,1200000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(674.374,15.056,405.346,0,0,0,0))(units_m)(no_defs)},
            {2057, srs::dpar::parameters<>(proj_omerc)(lat_0,27.51882880555555)(lonc,52.60353916666667)(alpha,0.5716611944444444)(k,0.999895934)(x_0,658377.437)(y_0,3044969.194)(ellps_intl)(towgs84,srs::detail::towgs84<>(-133.63,-157.5,-158.62,0,0,0,0))(units_m)(no_defs)},
            {2058, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_intl)(units_m)(no_defs)},
            {2059, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_intl)(units_m)(no_defs)},
            {2060, srs::dpar::parameters<>(proj_utm)(zone,40)(ellps_intl)(units_m)(no_defs)},
            {2061, srs::dpar::parameters<>(proj_utm)(zone,41)(ellps_intl)(units_m)(no_defs)},
            {2062, srs::dpar::parameters<>(proj_lcc)(lat_1,40)(lat_0,40)(lon_0,0)(k_0,0.9988085293)(x_0,600000)(y_0,600000)(a,6378298.3)(b,6356657.142669561)(pm_madrid)(units_m)(no_defs)},
            {2063, srs::dpar::parameters<>(proj_utm)(zone,28)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-23,259,-9,0,0,0,0))(units_m)(no_defs)},
            {2064, srs::dpar::parameters<>(proj_utm)(zone,29)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-23,259,-9,0,0,0,0))(units_m)(no_defs)},
            {2065, srs::dpar::parameters<>(proj_krovak)(lat_0,49.5)(lon_0,42.5)(alpha,30.28813972222222)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {2066, srs::dpar::parameters<>(proj_cass)(lat_0,11.25217861111111)(lon_0,-60.68600888888889)(x_0,37718.66159325)(y_0,36209.91512952)(a,6378293.645208759)(b,6356617.987679838)(to_meter,0.201166195164)(no_defs)},
            {2067, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_intl)(units_m)(no_defs)},
            {2068, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9)(k,0.9999)(x_0,200000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2069, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,11)(k,0.9999)(x_0,200000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2070, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,13)(k,0.9999)(x_0,200000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2071, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,0.9999)(x_0,200000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2072, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,17)(k,0.9999)(x_0,200000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2073, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,19)(k,0.9999)(x_0,200000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2074, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,0.9999)(x_0,200000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2075, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,23)(k,0.9999)(x_0,200000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2076, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,25)(k,0.9999)(x_0,200000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2077, srs::dpar::parameters<>(proj_utm)(zone,32)(ellps_intl)(units_m)(no_defs)},
            {2078, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_intl)(units_m)(no_defs)},
            {2079, srs::dpar::parameters<>(proj_utm)(zone,34)(ellps_intl)(units_m)(no_defs)},
            {2080, srs::dpar::parameters<>(proj_utm)(zone,35)(ellps_intl)(units_m)(no_defs)},
            {2081, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-69)(k,1)(x_0,2500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2082, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-69)(k,1)(x_0,2500000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(27.5,14,186.4,0,0,0,0))(units_m)(no_defs)},
            {2083, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-69)(k,1)(x_0,2500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2084, srs::dpar::parameters<>(proj_utm)(zone,19)(south)(ellps_intl)(units_m)(no_defs)},
            {2085, srs::dpar::parameters<>(proj_lcc)(lat_1,22.35)(lat_0,22.35)(lon_0,-81)(k_0,0.99993602)(x_0,500000)(y_0,280296.016)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {2086, srs::dpar::parameters<>(proj_lcc)(lat_1,20.71666666666667)(lat_0,20.71666666666667)(lon_0,-76.83333333333333)(k_0,0.99994848)(x_0,500000)(y_0,229126.939)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {2087, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,12)(k,0.9996)(x_0,500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2088, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,11)(k,0.9996)(x_0,500000)(y_0,0)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {2089, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2090, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2091, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,8500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(-76,-138,67,0,0,0,0))(units_m)(no_defs)},
            {2092, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,51)(k,1)(x_0,9500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(-76,-138,67,0,0,0,0))(units_m)(no_defs)},
            {2093, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,106)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(-17.51,-108.32,-62.39,0,0,0,0))(units_m)(no_defs)},
            {2094, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,106)(k,0.9996)(x_0,500000)(y_0,0)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {2095, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_intl)(towgs84,srs::detail::towgs84<>(-173,253,27,0,0,0,0))(units_m)(no_defs)},
            {2096, srs::dpar::parameters<>(proj_tmerc)(lat_0,38)(lon_0,129)(k,1)(x_0,200000)(y_0,500000)(ellps_bessel)(units_m)(no_defs)},
            {2097, srs::dpar::parameters<>(proj_tmerc)(lat_0,38)(lon_0,127)(k,1)(x_0,200000)(y_0,500000)(ellps_bessel)(units_m)(no_defs)},
            {2098, srs::dpar::parameters<>(proj_tmerc)(lat_0,38)(lon_0,125)(k,1)(x_0,200000)(y_0,500000)(ellps_bessel)(units_m)(no_defs)},
            {2099, srs::dpar::parameters<>(proj_cass)(lat_0,25.38236111111111)(lon_0,50.76138888888889)(x_0,100000)(y_0,100000)(ellps_helmert)(units_m)(no_defs)},
            {2100, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,0.9996)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-199.87,74.79,246.62,0,0,0,0))(units_m)(no_defs)},
            {2101, srs::dpar::parameters<>(proj_lcc)(lat_1,10.16666666666667)(lat_0,10.16666666666667)(lon_0,-71.60561777777777)(k_0,1)(x_0,0)(y_0,-52684.972)(ellps_intl)(units_m)(no_defs)},
            {2102, srs::dpar::parameters<>(proj_lcc)(lat_1,10.16666666666667)(lat_0,10.16666666666667)(lon_0,-71.60561777777777)(k_0,1)(x_0,200000)(y_0,147315.028)(ellps_intl)(units_m)(no_defs)},
            {2103, srs::dpar::parameters<>(proj_lcc)(lat_1,10.16666666666667)(lat_0,10.16666666666667)(lon_0,-71.60561777777777)(k_0,1)(x_0,500000)(y_0,447315.028)(ellps_intl)(units_m)(no_defs)},
            {2104, srs::dpar::parameters<>(proj_lcc)(lat_1,10.16666666666667)(lat_0,10.16666666666667)(lon_0,-71.60561777777777)(k_0,1)(x_0,-17044)(y_0,-23139.97)(ellps_intl)(units_m)(no_defs)},
            {2105, srs::dpar::parameters<>(proj_tmerc)(lat_0,-36.87972222222222)(lon_0,174.7641666666667)(k,0.9999)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2106, srs::dpar::parameters<>(proj_tmerc)(lat_0,-37.76111111111111)(lon_0,176.4661111111111)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2107, srs::dpar::parameters<>(proj_tmerc)(lat_0,-38.62444444444444)(lon_0,177.8855555555556)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2108, srs::dpar::parameters<>(proj_tmerc)(lat_0,-39.65083333333333)(lon_0,176.6736111111111)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2109, srs::dpar::parameters<>(proj_tmerc)(lat_0,-39.13555555555556)(lon_0,174.2277777777778)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2110, srs::dpar::parameters<>(proj_tmerc)(lat_0,-39.51222222222222)(lon_0,175.64)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2111, srs::dpar::parameters<>(proj_tmerc)(lat_0,-40.24194444444444)(lon_0,175.4880555555555)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2112, srs::dpar::parameters<>(proj_tmerc)(lat_0,-40.92527777777777)(lon_0,175.6472222222222)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2113, srs::dpar::parameters<>(proj_tmerc)(lat_0,-41.3011111111111)(lon_0,174.7763888888889)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2114, srs::dpar::parameters<>(proj_tmerc)(lat_0,-40.71472222222223)(lon_0,172.6719444444444)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2115, srs::dpar::parameters<>(proj_tmerc)(lat_0,-41.27444444444444)(lon_0,173.2991666666667)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2116, srs::dpar::parameters<>(proj_tmerc)(lat_0,-41.28972222222222)(lon_0,172.1088888888889)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2117, srs::dpar::parameters<>(proj_tmerc)(lat_0,-41.81055555555555)(lon_0,171.5811111111111)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2118, srs::dpar::parameters<>(proj_tmerc)(lat_0,-42.33361111111111)(lon_0,171.5497222222222)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2119, srs::dpar::parameters<>(proj_tmerc)(lat_0,-42.68888888888888)(lon_0,173.01)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2120, srs::dpar::parameters<>(proj_tmerc)(lat_0,-41.54444444444444)(lon_0,173.8019444444444)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2121, srs::dpar::parameters<>(proj_tmerc)(lat_0,-42.88611111111111)(lon_0,170.9797222222222)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2122, srs::dpar::parameters<>(proj_tmerc)(lat_0,-43.11)(lon_0,170.2608333333333)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2123, srs::dpar::parameters<>(proj_tmerc)(lat_0,-43.97777777777778)(lon_0,168.6061111111111)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2124, srs::dpar::parameters<>(proj_tmerc)(lat_0,-43.59055555555556)(lon_0,172.7269444444445)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2125, srs::dpar::parameters<>(proj_tmerc)(lat_0,-43.74861111111111)(lon_0,171.3605555555555)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2126, srs::dpar::parameters<>(proj_tmerc)(lat_0,-44.40194444444445)(lon_0,171.0572222222222)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2127, srs::dpar::parameters<>(proj_tmerc)(lat_0,-44.735)(lon_0,169.4675)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2128, srs::dpar::parameters<>(proj_tmerc)(lat_0,-45.13277777777778)(lon_0,168.3986111111111)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2129, srs::dpar::parameters<>(proj_tmerc)(lat_0,-45.56361111111111)(lon_0,167.7386111111111)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2130, srs::dpar::parameters<>(proj_tmerc)(lat_0,-45.81611111111111)(lon_0,170.6283333333333)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2131, srs::dpar::parameters<>(proj_tmerc)(lat_0,-45.86138888888889)(lon_0,170.2825)(k,0.99996)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2132, srs::dpar::parameters<>(proj_tmerc)(lat_0,-46.6)(lon_0,168.3427777777778)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2133, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2134, srs::dpar::parameters<>(proj_utm)(zone,59)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2135, srs::dpar::parameters<>(proj_utm)(zone,60)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2136, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.666666666666667)(lon_0,-1)(k,0.99975)(x_0,274319.7391633579)(y_0,0)(a,6378300)(b,6356751.689189189)(towgs84,srs::detail::towgs84<>(-199,32,322,0,0,0,0))(to_meter,0.3047997101815088)(no_defs)},
            {2137, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-1)(k,0.9996)(x_0,500000)(y_0,0)(a,6378300)(b,6356751.689189189)(towgs84,srs::detail::towgs84<>(-199,32,322,0,0,0,0))(units_m)(no_defs)},
            {2138, srs::dpar::parameters<>(proj_lcc)(lat_1,60)(lat_2,46)(lat_0,44)(lon_0,-68.5)(x_0,0)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {2139, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-55.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2140, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-58.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2141, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-61.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2142, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-64.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2143, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-67.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2144, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-70.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2145, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-73.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2146, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-76.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2147, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-79.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2148, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2149, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2150, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2151, srs::dpar::parameters<>(proj_utm)(zone,13)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2152, srs::dpar::parameters<>(proj_utm)(zone,12)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2153, srs::dpar::parameters<>(proj_utm)(zone,11)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2154, srs::dpar::parameters<>(proj_lcc)(lat_1,49)(lat_2,44)(lat_0,46.5)(lon_0,3)(x_0,700000)(y_0,6600000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2155, srs::dpar::parameters<>(proj_lcc)(lat_1,-14.26666666666667)(lat_0,-14.26666666666667)(lon_0,170)(k_0,1)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-115,118,426,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {2156, srs::dpar::parameters<>(proj_utm)(zone,59)(south)(ellps_grs80)(units_m)(no_defs)},
            {2157, srs::dpar::parameters<>(proj_tmerc)(lat_0,53.5)(lon_0,-8)(k,0.99982)(x_0,600000)(y_0,750000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2158, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2159, srs::dpar::parameters<>(proj_tmerc)(lat_0,6.666666666666667)(lon_0,-12)(k,1)(x_0,152399.8550907544)(y_0,0)(a,6378300)(b,6356751.689189189)(to_meter,0.3047997101815088)(no_defs)},
            {2160, srs::dpar::parameters<>(proj_tmerc)(lat_0,6.666666666666667)(lon_0,-12)(k,1)(x_0,243839.7681452071)(y_0,182879.8261089053)(a,6378300)(b,6356751.689189189)(to_meter,0.3047997101815088)(no_defs)},
            {2161, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-88,4,101,0,0,0,0))(units_m)(no_defs)},
            {2162, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-88,4,101,0,0,0,0))(units_m)(no_defs)},
            {2163, srs::dpar::parameters<>(proj_laea)(lat_0,45)(lon_0,-100)(x_0,0)(y_0,0)(r,6370997)(units_m)(no_defs)},
            {2164, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-5)(k,0.9996)(x_0,500000)(y_0,0)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-125,53,467,0,0,0,0))(units_m)(no_defs)},
            {2165, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-5)(k,0.9996)(x_0,500000)(y_0,0)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-124.76,53,466.79,0,0,0,0))(units_m)(no_defs)},
            {2166, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9)(k,1)(x_0,3500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1))(units_m)(no_defs)},
            {2167, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,12)(k,1)(x_0,4500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1))(units_m)(no_defs)},
            {2168, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,5500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1))(units_m)(no_defs)},
            {2169, srs::dpar::parameters<>(proj_tmerc)(lat_0,49.83333333333334)(lon_0,6.166666666666667)(k,1)(x_0,80000)(y_0,100000)(ellps_intl)(towgs84,srs::detail::towgs84<>(-193,13.7,-39.3,-0.41,-2.933,2.688,0.43))(units_m)(no_defs)},
            {2170, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,0.9999)(x_0,500000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {2171, srs::dpar::parameters<>(proj_sterea)(lat_0,50.625)(lon_0,21.08333333333333)(k,0.9998)(x_0,4637000)(y_0,5647000)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {2172, srs::dpar::parameters<>(proj_sterea)(lat_0,53.00194444444445)(lon_0,21.50277777777778)(k,0.9998)(x_0,4603000)(y_0,5806000)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {2173, srs::dpar::parameters<>(proj_sterea)(lat_0,53.58333333333334)(lon_0,17.00833333333333)(k,0.9998)(x_0,3501000)(y_0,5999000)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {2174, srs::dpar::parameters<>(proj_sterea)(lat_0,51.67083333333333)(lon_0,16.67222222222222)(k,0.9998)(x_0,3703000)(y_0,5627000)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {2175, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18.95833333333333)(k,0.999983)(x_0,237000)(y_0,-4700000)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {2176, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,0.999923)(x_0,5500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2177, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18)(k,0.999923)(x_0,6500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2178, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,0.999923)(x_0,7500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2179, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,0.999923)(x_0,8500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2180, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,19)(k,0.9993)(x_0,500000)(y_0,-5300000)(ellps_grs80)(units_m)(no_defs)},
            {2188, srs::dpar::parameters<>(proj_utm)(zone,25)(ellps_intl)(units_m)(no_defs)},
            {2189, srs::dpar::parameters<>(proj_utm)(zone,26)(ellps_intl)(towgs84,srs::detail::towgs84<>(-104,167,-38,0,0,0,0))(units_m)(no_defs)},
            {2190, srs::dpar::parameters<>(proj_utm)(zone,26)(ellps_intl)(towgs84,srs::detail::towgs84<>(-203,141,53,0,0,0,0))(units_m)(no_defs)},
            {2191, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_intl)(units_m)(no_defs)},
            {2192, srs::dpar::parameters<>(proj_lcc)(lat_1,46.8)(lat_0,46.8)(lon_0,2.337229166666667)(k_0,0.99987742)(x_0,600000)(y_0,2200000)(ellps_intl)(units_m)(no_defs)},
            {2193, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,173)(k,0.9996)(x_0,1600000)(y_0,10000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2194, srs::dpar::parameters<>(proj_lcc)(lat_1,-14.26666666666667)(lat_0,-14.26666666666667)(lon_0,-170)(k_0,1)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-115,118,426,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {2195, srs::dpar::parameters<>(proj_utm)(zone,2)(south)(ellps_grs80)(units_m)(no_defs)},
            {2196, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9.5)(k,0.99995)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2197, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,12)(k,0.99995)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2198, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,900000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2199, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,4500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2200, srs::dpar::parameters<>(proj_sterea)(lat_0,46.5)(lon_0,-66.5)(k,0.999912)(x_0,300000)(y_0,800000)(a,6378135)(b,6356750.304921594)(units_m)(no_defs)},
            {2201, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2202, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2203, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2204, srs::dpar::parameters<>(proj_lcc)(lat_1,35.25)(lat_2,36.41666666666666)(lat_0,34.66666666666666)(lon_0,-86)(x_0,609601.2192024384)(y_0,30480.06096012192)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {2205, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,38.96666666666667)(lat_0,37.5)(lon_0,-84.25)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {2206, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,9500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2207, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,30)(k,1)(x_0,10500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2208, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,11500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2209, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,36)(k,1)(x_0,12500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2210, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,39)(k,1)(x_0,13500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2211, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,42)(k,1)(x_0,14500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2212, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,15500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2213, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,30)(k,0.9996)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2214, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,10.5)(k,0.999)(x_0,1000000)(y_0,1000000)(ellps_intl)(towgs84,srs::detail::towgs84<>(-206.1,-174.7,-87.7,0,0,0,0))(units_m)(no_defs)},
            {2215, srs::dpar::parameters<>(proj_utm)(zone,32)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-70.9,-151.8,-41.4,0,0,0,0))(units_m)(no_defs)},
            {2216, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_intl)(units_m)(no_defs)},
            {2217, srs::dpar::parameters<>(proj_utm)(zone,23)(ellps_intl)(units_m)(no_defs)},
            //{2218},
            {2219, srs::dpar::parameters<>(proj_utm)(zone,19)(a,6378135)(b,6356750.304921594)(units_m)(no_defs)},
            {2220, srs::dpar::parameters<>(proj_utm)(zone,20)(a,6378135)(b,6356750.304921594)(units_m)(no_defs)},
            //{2221},
            {2222, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-110.1666666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2223, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-111.9166666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2224, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-113.75)(k,0.999933333)(x_0,213360)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2225, srs::dpar::parameters<>(proj_lcc)(lat_1,41.66666666666666)(lat_2,40)(lat_0,39.33333333333334)(lon_0,-122)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2226, srs::dpar::parameters<>(proj_lcc)(lat_1,39.83333333333334)(lat_2,38.33333333333334)(lat_0,37.66666666666666)(lon_0,-122)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2227, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.06666666666667)(lat_0,36.5)(lon_0,-120.5)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2228, srs::dpar::parameters<>(proj_lcc)(lat_1,37.25)(lat_2,36)(lat_0,35.33333333333334)(lon_0,-119)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2229, srs::dpar::parameters<>(proj_lcc)(lat_1,35.46666666666667)(lat_2,34.03333333333333)(lat_0,33.5)(lon_0,-118)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2230, srs::dpar::parameters<>(proj_lcc)(lat_1,33.88333333333333)(lat_2,32.78333333333333)(lat_0,32.16666666666666)(lon_0,-116.25)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2231, srs::dpar::parameters<>(proj_lcc)(lat_1,40.78333333333333)(lat_2,39.71666666666667)(lat_0,39.33333333333334)(lon_0,-105.5)(x_0,914401.8288036576)(y_0,304800.6096012192)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2232, srs::dpar::parameters<>(proj_lcc)(lat_1,39.75)(lat_2,38.45)(lat_0,37.83333333333334)(lon_0,-105.5)(x_0,914401.8288036576)(y_0,304800.6096012192)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2233, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.23333333333333)(lat_0,36.66666666666666)(lon_0,-105.5)(x_0,914401.8288036576)(y_0,304800.6096012192)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2234, srs::dpar::parameters<>(proj_lcc)(lat_1,41.86666666666667)(lat_2,41.2)(lat_0,40.83333333333334)(lon_0,-72.75)(x_0,304800.6096012192)(y_0,152400.3048006096)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2235, srs::dpar::parameters<>(proj_tmerc)(lat_0,38)(lon_0,-75.41666666666667)(k,0.999995)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2236, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-81)(k,0.999941177)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2237, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-82)(k,0.999941177)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2238, srs::dpar::parameters<>(proj_lcc)(lat_1,30.75)(lat_2,29.58333333333333)(lat_0,29)(lon_0,-84.5)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2239, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-82.16666666666667)(k,0.9999)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2240, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-84.16666666666667)(k,0.9999)(x_0,699999.9998983998)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2241, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-112.1666666666667)(k,0.9999473679999999)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2242, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-114)(k,0.9999473679999999)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2243, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-115.75)(k,0.999933333)(x_0,800000.0001016001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2244, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-85.66666666666667)(k,0.999966667)(x_0,99999.99989839978)(y_0,249364.9987299975)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2245, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-87.08333333333333)(k,0.999966667)(x_0,900000)(y_0,249364.9987299975)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2246, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,38.96666666666667)(lat_0,37.5)(lon_0,-84.25)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2247, srs::dpar::parameters<>(proj_lcc)(lat_1,37.93333333333333)(lat_2,36.73333333333333)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,500000.0001016001)(y_0,500000.0001016001)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2248, srs::dpar::parameters<>(proj_lcc)(lat_1,39.45)(lat_2,38.3)(lat_0,37.66666666666666)(lon_0,-77)(x_0,399999.9998983998)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2249, srs::dpar::parameters<>(proj_lcc)(lat_1,42.68333333333333)(lat_2,41.71666666666667)(lat_0,41)(lon_0,-71.5)(x_0,200000.0001016002)(y_0,750000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2250, srs::dpar::parameters<>(proj_lcc)(lat_1,41.48333333333333)(lat_2,41.28333333333333)(lat_0,41)(lon_0,-70.5)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2251, srs::dpar::parameters<>(proj_lcc)(lat_1,47.08333333333334)(lat_2,45.48333333333333)(lat_0,44.78333333333333)(lon_0,-87)(x_0,7999999.999968001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2252, srs::dpar::parameters<>(proj_lcc)(lat_1,45.7)(lat_2,44.18333333333333)(lat_0,43.31666666666667)(lon_0,-84.36666666666666)(x_0,5999999.999976001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2253, srs::dpar::parameters<>(proj_lcc)(lat_1,43.66666666666666)(lat_2,42.1)(lat_0,41.5)(lon_0,-84.36666666666666)(x_0,3999999.999984)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2254, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-88.83333333333333)(k,0.99995)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2255, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-90.33333333333333)(k,0.99995)(x_0,699999.9998983998)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2256, srs::dpar::parameters<>(proj_lcc)(lat_1,49)(lat_2,45)(lat_0,44.25)(lon_0,-109.5)(x_0,599999.9999976)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2257, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-104.3333333333333)(k,0.999909091)(x_0,165000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2258, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-106.25)(k,0.9999)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2259, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-107.8333333333333)(k,0.999916667)(x_0,830000.0001016001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2260, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2261, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-76.58333333333333)(k,0.9999375)(x_0,249999.9998983998)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2262, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-78.58333333333333)(k,0.9999375)(x_0,350000.0001016001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2263, srs::dpar::parameters<>(proj_lcc)(lat_1,41.03333333333333)(lat_2,40.66666666666666)(lat_0,40.16666666666666)(lon_0,-74)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2264, srs::dpar::parameters<>(proj_lcc)(lat_1,36.16666666666666)(lat_2,34.33333333333334)(lat_0,33.75)(lon_0,-79)(x_0,609601.2192024384)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2265, srs::dpar::parameters<>(proj_lcc)(lat_1,48.73333333333333)(lat_2,47.43333333333333)(lat_0,47)(lon_0,-100.5)(x_0,599999.9999976)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2266, srs::dpar::parameters<>(proj_lcc)(lat_1,47.48333333333333)(lat_2,46.18333333333333)(lat_0,45.66666666666666)(lon_0,-100.5)(x_0,599999.9999976)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2267, srs::dpar::parameters<>(proj_lcc)(lat_1,36.76666666666667)(lat_2,35.56666666666667)(lat_0,35)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2268, srs::dpar::parameters<>(proj_lcc)(lat_1,35.23333333333333)(lat_2,33.93333333333333)(lat_0,33.33333333333334)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2269, srs::dpar::parameters<>(proj_lcc)(lat_1,46)(lat_2,44.33333333333334)(lat_0,43.66666666666666)(lon_0,-120.5)(x_0,2500000.0001424)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2270, srs::dpar::parameters<>(proj_lcc)(lat_1,44)(lat_2,42.33333333333334)(lat_0,41.66666666666666)(lon_0,-120.5)(x_0,1500000.0001464)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2271, srs::dpar::parameters<>(proj_lcc)(lat_1,41.95)(lat_2,40.88333333333333)(lat_0,40.16666666666666)(lon_0,-77.75)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2272, srs::dpar::parameters<>(proj_lcc)(lat_1,40.96666666666667)(lat_2,39.93333333333333)(lat_0,39.33333333333334)(lon_0,-77.75)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2273, srs::dpar::parameters<>(proj_lcc)(lat_1,34.83333333333334)(lat_2,32.5)(lat_0,31.83333333333333)(lon_0,-81)(x_0,609600)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2274, srs::dpar::parameters<>(proj_lcc)(lat_1,36.41666666666666)(lat_2,35.25)(lat_0,34.33333333333334)(lon_0,-86)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2275, srs::dpar::parameters<>(proj_lcc)(lat_1,36.18333333333333)(lat_2,34.65)(lat_0,34)(lon_0,-101.5)(x_0,200000.0001016002)(y_0,999999.9998983998)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2276, srs::dpar::parameters<>(proj_lcc)(lat_1,33.96666666666667)(lat_2,32.13333333333333)(lat_0,31.66666666666667)(lon_0,-98.5)(x_0,600000)(y_0,2000000.0001016)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2277, srs::dpar::parameters<>(proj_lcc)(lat_1,31.88333333333333)(lat_2,30.11666666666667)(lat_0,29.66666666666667)(lon_0,-100.3333333333333)(x_0,699999.9998983998)(y_0,3000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2278, srs::dpar::parameters<>(proj_lcc)(lat_1,30.28333333333333)(lat_2,28.38333333333333)(lat_0,27.83333333333333)(lon_0,-99)(x_0,600000)(y_0,3999999.9998984)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2279, srs::dpar::parameters<>(proj_lcc)(lat_1,27.83333333333333)(lat_2,26.16666666666667)(lat_0,25.66666666666667)(lon_0,-98.5)(x_0,300000.0000000001)(y_0,5000000.0001016)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2280, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.71666666666667)(lat_0,40.33333333333334)(lon_0,-111.5)(x_0,500000.0001504)(y_0,999999.9999960001)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2281, srs::dpar::parameters<>(proj_lcc)(lat_1,40.65)(lat_2,39.01666666666667)(lat_0,38.33333333333334)(lon_0,-111.5)(x_0,500000.0001504)(y_0,1999999.999992)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2282, srs::dpar::parameters<>(proj_lcc)(lat_1,38.35)(lat_2,37.21666666666667)(lat_0,36.66666666666666)(lon_0,-111.5)(x_0,500000.0001504)(y_0,2999999.999988)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2283, srs::dpar::parameters<>(proj_lcc)(lat_1,39.2)(lat_2,38.03333333333333)(lat_0,37.66666666666666)(lon_0,-78.5)(x_0,3500000.0001016)(y_0,2000000.0001016)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2284, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,36.76666666666667)(lat_0,36.33333333333334)(lon_0,-78.5)(x_0,3500000.0001016)(y_0,999999.9998983998)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2285, srs::dpar::parameters<>(proj_lcc)(lat_1,48.73333333333333)(lat_2,47.5)(lat_0,47)(lon_0,-120.8333333333333)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2286, srs::dpar::parameters<>(proj_lcc)(lat_1,47.33333333333334)(lat_2,45.83333333333334)(lat_0,45.33333333333334)(lon_0,-120.5)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2287, srs::dpar::parameters<>(proj_lcc)(lat_1,46.76666666666667)(lat_2,45.56666666666667)(lat_0,45.16666666666666)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2288, srs::dpar::parameters<>(proj_lcc)(lat_1,45.5)(lat_2,44.25)(lat_0,43.83333333333334)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2289, srs::dpar::parameters<>(proj_lcc)(lat_1,44.06666666666667)(lat_2,42.73333333333333)(lat_0,42)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2290, srs::dpar::parameters<>(proj_sterea)(lat_0,47.25)(lon_0,-63)(k,0.999912)(x_0,700000)(y_0,400000)(a,6378135)(b,6356750.304921594)(units_m)(no_defs)},
            {2291, srs::dpar::parameters<>(proj_sterea)(lat_0,47.25)(lon_0,-63)(k,0.999912)(x_0,400000)(y_0,800000)(a,6378135)(b,6356750.304921594)(units_m)(no_defs)},
            {2292, srs::dpar::parameters<>(proj_sterea)(lat_0,47.25)(lon_0,-63)(k,0.999912)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2294, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-61.5)(k,0.9999)(x_0,4500000)(y_0,0)(a,6378135)(b,6356750.304921594)(units_m)(no_defs)},
            {2295, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-64.5)(k,0.9999)(x_0,5500000)(y_0,0)(a,6378135)(b,6356750.304921594)(units_m)(no_defs)},
            //{2296},
            //{2297},
            //{2298},
            //{2299},
            //{2300},
            //{2301},
            //{2302},
            //{2303},
            //{2304},
            //{2305},
            //{2306},
            //{2307},
            {2308, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,109)(k,0.9996)(x_0,500000)(y_0,10000000)(ellps_bessel)(units_m)(no_defs)},
            {2309, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,116)(k,0.9996)(x_0,500000)(y_0,10000000)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {2310, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,132)(k,0.9996)(x_0,500000)(y_0,10000000)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {2311, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,6)(k,0.9996)(x_0,500000)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {2312, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_clrk80)(units_m)(no_defs)},
            {2313, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_clrk80)(units_m)(no_defs)},
            {2314, srs::dpar::parameters<>(proj_cass)(lat_0,10.44166666666667)(lon_0,-61.33333333333334)(x_0,86501.46392052001)(y_0,65379.0134283)(a,6378293.645208759)(b,6356617.987679838)(to_meter,0.3047972654)(no_defs)},
            {2315, srs::dpar::parameters<>(proj_utm)(zone,19)(south)(ellps_intl)(units_m)(no_defs)},
            {2316, srs::dpar::parameters<>(proj_utm)(zone,20)(south)(ellps_intl)(units_m)(no_defs)},
            {2317, srs::dpar::parameters<>(proj_lcc)(lat_1,9)(lat_2,3)(lat_0,6)(lon_0,-66)(x_0,1000000)(y_0,1000000)(ellps_intl)(units_m)(no_defs)},
            {2318, srs::dpar::parameters<>(proj_lcc)(lat_1,17)(lat_2,33)(lat_0,25.08951)(lon_0,48)(x_0,0)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2319, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2320, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,30)(k,1)(x_0,500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2321, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2322, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,36)(k,1)(x_0,500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2323, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,39)(k,1)(x_0,500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2324, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,42)(k,1)(x_0,500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2325, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2326, srs::dpar::parameters<>(proj_tmerc)(lat_0,22.31213333333334)(lon_0,114.1785555555556)(k,1)(x_0,836694.05)(y_0,819069.8)(ellps_intl)(towgs84,srs::detail::towgs84<>(-162.619,-276.959,-161.764,0.067753,-2.24365,-1.15883,-1.09425))(units_m)(no_defs)},
            {2327, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,13500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2328, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,14500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2329, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,15500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2330, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,16500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2331, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,17500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2332, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,18500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2333, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,19500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2334, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,20500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2335, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,21500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2336, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,22500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2337, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,23500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2338, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2339, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2340, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2341, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2342, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2343, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2344, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2345, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2346, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2347, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2348, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2349, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,25500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2350, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,78)(k,1)(x_0,26500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2351, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,27500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2352, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,84)(k,1)(x_0,28500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2353, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,29500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2354, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,90)(k,1)(x_0,30500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2355, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,31500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2356, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,96)(k,1)(x_0,32500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2357, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,33500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2358, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,102)(k,1)(x_0,34500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2359, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,35500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2360, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,108)(k,1)(x_0,36500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2361, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,37500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2362, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,114)(k,1)(x_0,38500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2363, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,39500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2364, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,120)(k,1)(x_0,40500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2365, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,41500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2366, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,126)(k,1)(x_0,42500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2367, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,43500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2368, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,132)(k,1)(x_0,44500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2369, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,45500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2370, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2371, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,78)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2372, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2373, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,84)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2374, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2375, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,90)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2376, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2377, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,96)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2378, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2379, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,102)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2380, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2381, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,108)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2382, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2383, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,114)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2384, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2385, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,120)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2386, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2387, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,126)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2388, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2389, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,132)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2390, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,500000)(y_0,0)(a,6378140)(b,6356755.288157528)(units_m)(no_defs)},
            {2391, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,1500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2392, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,1)(x_0,2500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2393, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,3500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2394, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,30)(k,1)(x_0,4500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {2395, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,8500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(-76,-138,67,0,0,0,0))(units_m)(no_defs)},
            {2396, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,51)(k,1)(x_0,9500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(-76,-138,67,0,0,0,0))(units_m)(no_defs)},
            {2397, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9)(k,1)(x_0,3500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1))(units_m)(no_defs)},
            {2398, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,12)(k,1)(x_0,4500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1))(units_m)(no_defs)},
            {2399, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,5500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1))(units_m)(no_defs)},
            {2400, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15.80827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {2401, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,25500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2402, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,78)(k,1)(x_0,26500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2403, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,27500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2404, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,84)(k,1)(x_0,28500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2405, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,29500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2406, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,90)(k,1)(x_0,30500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2407, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,31500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2408, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,96)(k,1)(x_0,32500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2409, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,33500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2410, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,102)(k,1)(x_0,34500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2411, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,35500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2412, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,108)(k,1)(x_0,36500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2413, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,37500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2414, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,114)(k,1)(x_0,38500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2415, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,39500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2416, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,120)(k,1)(x_0,40500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2417, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,41500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2418, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,126)(k,1)(x_0,42500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2419, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,43500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2420, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,132)(k,1)(x_0,44500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2421, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,45500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2422, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2423, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,78)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2424, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2425, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,84)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2426, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2427, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,90)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2428, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2429, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,96)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2430, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2431, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,102)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2432, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2433, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,108)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2434, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2435, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,114)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2436, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2437, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,120)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2438, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2439, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,126)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2440, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2441, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,132)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2442, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2443, srs::dpar::parameters<>(proj_tmerc)(lat_0,33)(lon_0,129.5)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2444, srs::dpar::parameters<>(proj_tmerc)(lat_0,33)(lon_0,131)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2445, srs::dpar::parameters<>(proj_tmerc)(lat_0,36)(lon_0,132.1666666666667)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2446, srs::dpar::parameters<>(proj_tmerc)(lat_0,33)(lon_0,133.5)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2447, srs::dpar::parameters<>(proj_tmerc)(lat_0,36)(lon_0,134.3333333333333)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2448, srs::dpar::parameters<>(proj_tmerc)(lat_0,36)(lon_0,136)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2449, srs::dpar::parameters<>(proj_tmerc)(lat_0,36)(lon_0,137.1666666666667)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2450, srs::dpar::parameters<>(proj_tmerc)(lat_0,36)(lon_0,138.5)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2451, srs::dpar::parameters<>(proj_tmerc)(lat_0,36)(lon_0,139.8333333333333)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2452, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,140.8333333333333)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2453, srs::dpar::parameters<>(proj_tmerc)(lat_0,44)(lon_0,140.25)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2454, srs::dpar::parameters<>(proj_tmerc)(lat_0,44)(lon_0,142.25)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2455, srs::dpar::parameters<>(proj_tmerc)(lat_0,44)(lon_0,144.25)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2456, srs::dpar::parameters<>(proj_tmerc)(lat_0,26)(lon_0,142)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2457, srs::dpar::parameters<>(proj_tmerc)(lat_0,26)(lon_0,127.5)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2458, srs::dpar::parameters<>(proj_tmerc)(lat_0,26)(lon_0,124)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2459, srs::dpar::parameters<>(proj_tmerc)(lat_0,26)(lon_0,131)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2460, srs::dpar::parameters<>(proj_tmerc)(lat_0,20)(lon_0,136)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2461, srs::dpar::parameters<>(proj_tmerc)(lat_0,26)(lon_0,154)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2462, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,4500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2463, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2464, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2465, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2466, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,39)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2467, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2468, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,51)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2469, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,57)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2470, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,63)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2471, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,69)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2472, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2473, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2474, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2475, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2476, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2477, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2478, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2479, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2480, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2481, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2482, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2483, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,141)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2484, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,147)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2485, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,153)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2486, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,159)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2487, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,165)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2488, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,171)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2489, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,177)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2490, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-177)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2491, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-171)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2492, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2493, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2494, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2495, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2496, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2497, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,39)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2498, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2499, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,51)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2500, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,57)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2501, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,63)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2502, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,69)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2503, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2504, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2505, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2506, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2507, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2508, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2509, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2510, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2511, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2512, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2513, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2514, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,141)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2515, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,147)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2516, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,153)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2517, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,159)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2518, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,165)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2519, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,171)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2520, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,177)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2521, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-177)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2522, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-171)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2523, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,7500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2524, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,1)(x_0,8500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2525, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,9500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2526, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,30)(k,1)(x_0,10500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2527, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,11500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2528, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,36)(k,1)(x_0,12500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2529, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,39)(k,1)(x_0,13500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2530, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,42)(k,1)(x_0,14500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2531, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,15500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2532, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,48)(k,1)(x_0,16500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2533, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,51)(k,1)(x_0,17500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2534, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,54)(k,1)(x_0,18500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2535, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,57)(k,1)(x_0,19500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2536, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,60)(k,1)(x_0,20500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2537, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,63)(k,1)(x_0,21500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2538, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,66)(k,1)(x_0,22500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2539, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,69)(k,1)(x_0,23500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2540, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,72)(k,1)(x_0,24500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2541, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,25500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2542, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,78)(k,1)(x_0,26500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2543, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,27500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2544, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,84)(k,1)(x_0,28500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2545, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,29500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2546, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,90)(k,1)(x_0,30500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2547, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,31500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2548, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,96)(k,1)(x_0,32500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2549, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,33500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2550, srs::dpar::parameters<>(proj_utm)(zone,50)(south)(ellps_bessel)(towgs84,srs::detail::towgs84<>(-404.78,685.68,45.47,0,0,0,0))(units_m)(no_defs)},
            {2551, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,102)(k,1)(x_0,34500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2552, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,35500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2553, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,108)(k,1)(x_0,36500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2554, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,37500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2555, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,114)(k,1)(x_0,38500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2556, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,39500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2557, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,120)(k,1)(x_0,40500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2558, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,41500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2559, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,126)(k,1)(x_0,42500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2560, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,43500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2561, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,132)(k,1)(x_0,44500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2562, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,45500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2563, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,138)(k,1)(x_0,46500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2564, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,141)(k,1)(x_0,47500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2565, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,144)(k,1)(x_0,48500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2566, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,147)(k,1)(x_0,49500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2567, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,150)(k,1)(x_0,50500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2568, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,153)(k,1)(x_0,51500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2569, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,156)(k,1)(x_0,52500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2570, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,159)(k,1)(x_0,53500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2571, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,162)(k,1)(x_0,54500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2572, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,165)(k,1)(x_0,55500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2573, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,168)(k,1)(x_0,56500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2574, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,171)(k,1)(x_0,57500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2575, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,174)(k,1)(x_0,58500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2576, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,177)(k,1)(x_0,59500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2577, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,180)(k,1)(x_0,60000000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2578, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-177)(k,1)(x_0,61500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2579, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-174)(k,1)(x_0,62500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2580, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-171)(k,1)(x_0,63500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2581, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-168)(k,1)(x_0,64500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2582, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2583, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2584, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2585, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,30)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2586, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2587, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,36)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2588, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,39)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2589, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,42)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2590, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2591, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,48)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2592, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,51)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2593, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,54)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2594, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,57)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2595, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,60)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2596, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,63)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2597, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,66)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2598, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,69)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2599, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,72)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2600, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,0.9998)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2601, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2602, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,78)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2603, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2604, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,84)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2605, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2606, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,90)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2607, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2608, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,96)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2609, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2610, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,102)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2611, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2612, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,108)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2613, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2614, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,114)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2615, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2616, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,120)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2617, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2618, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,126)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2619, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2620, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,132)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2621, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2622, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,138)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2623, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,141)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2624, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,144)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2625, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,147)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2626, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,150)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2627, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,153)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2628, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,156)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2629, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,159)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2630, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,162)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2631, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,165)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2632, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,168)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2633, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,171)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2634, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,174)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2635, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,177)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2636, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,180)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2637, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-177)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2638, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-174)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2639, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-171)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2640, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-168)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2641, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,7500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2642, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,1)(x_0,8500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2643, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,9500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2644, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,30)(k,1)(x_0,10500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2645, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,11500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2646, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,36)(k,1)(x_0,12500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2647, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,39)(k,1)(x_0,13500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2648, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,42)(k,1)(x_0,14500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2649, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,15500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2650, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,48)(k,1)(x_0,16500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2651, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,51)(k,1)(x_0,17500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2652, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,54)(k,1)(x_0,18500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2653, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,57)(k,1)(x_0,19500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2654, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,60)(k,1)(x_0,20500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2655, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,63)(k,1)(x_0,21500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2656, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,66)(k,1)(x_0,22500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2657, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,69)(k,1)(x_0,23500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2658, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,72)(k,1)(x_0,24500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2659, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,25500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2660, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,78)(k,1)(x_0,26500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2661, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,27500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2662, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,84)(k,1)(x_0,28500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2663, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,29500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2664, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,90)(k,1)(x_0,30500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2665, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,31500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2666, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,96)(k,1)(x_0,32500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2667, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,33500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2668, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,102)(k,1)(x_0,34500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2669, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,35500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2670, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,108)(k,1)(x_0,36500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2671, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,37500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2672, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,114)(k,1)(x_0,38500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2673, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,39500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2674, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,120)(k,1)(x_0,40500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2675, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,41500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2676, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,126)(k,1)(x_0,42500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2677, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,43500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2678, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,132)(k,1)(x_0,44500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2679, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,45500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2680, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,138)(k,1)(x_0,46500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2681, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,141)(k,1)(x_0,47500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2682, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,144)(k,1)(x_0,48500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2683, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,147)(k,1)(x_0,49500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2684, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,150)(k,1)(x_0,50500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2685, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,153)(k,1)(x_0,51500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2686, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,156)(k,1)(x_0,52500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2687, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,159)(k,1)(x_0,53500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2688, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,162)(k,1)(x_0,54500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2689, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,165)(k,1)(x_0,55500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2690, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,168)(k,1)(x_0,56500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2691, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,171)(k,1)(x_0,57500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2692, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,174)(k,1)(x_0,58500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2693, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,177)(k,1)(x_0,59500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2694, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,180)(k,1)(x_0,60000000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2695, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-177)(k,1)(x_0,61500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2696, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-174)(k,1)(x_0,62500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2697, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-171)(k,1)(x_0,63500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2698, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-168)(k,1)(x_0,64500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2699, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2700, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2701, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2702, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,30)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2703, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2704, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,36)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2705, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,39)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2706, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,42)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2707, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2708, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,48)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2709, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,51)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2710, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,54)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2711, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,57)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2712, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,60)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2713, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,63)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2714, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,66)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2715, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,69)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2716, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,72)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2717, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2718, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,78)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2719, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2720, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,84)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2721, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2722, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,90)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2723, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2724, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,96)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2725, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2726, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,102)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2727, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2728, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,108)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2729, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2730, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,114)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2731, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2732, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,120)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2733, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2734, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,126)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2735, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2736, srs::dpar::parameters<>(proj_utm)(zone,36)(south)(ellps_clrk66)(units_m)(no_defs)},
            {2737, srs::dpar::parameters<>(proj_utm)(zone,37)(south)(ellps_clrk66)(units_m)(no_defs)},
            {2738, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,132)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2739, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2740, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,138)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2741, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,141)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2742, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,144)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2743, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,147)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2744, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,150)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2745, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,153)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2746, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,156)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2747, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,159)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2748, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,162)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2749, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,165)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2750, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,168)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2751, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,171)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2752, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,174)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2753, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,177)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2754, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,180)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2755, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-177)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2756, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-174)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2757, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-171)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2758, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-168)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2759, srs::dpar::parameters<>(proj_tmerc)(lat_0,30.5)(lon_0,-85.83333333333333)(k,0.99996)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2760, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-87.5)(k,0.999933333)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2761, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-110.1666666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2762, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-111.9166666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2763, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-113.75)(k,0.999933333)(x_0,213360)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2764, srs::dpar::parameters<>(proj_lcc)(lat_1,36.23333333333333)(lat_2,34.93333333333333)(lat_0,34.33333333333334)(lon_0,-92)(x_0,400000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2765, srs::dpar::parameters<>(proj_lcc)(lat_1,34.76666666666667)(lat_2,33.3)(lat_0,32.66666666666666)(lon_0,-92)(x_0,400000)(y_0,400000)(ellps_grs80)(units_m)(no_defs)},
            {2766, srs::dpar::parameters<>(proj_lcc)(lat_1,41.66666666666666)(lat_2,40)(lat_0,39.33333333333334)(lon_0,-122)(x_0,2000000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {2767, srs::dpar::parameters<>(proj_lcc)(lat_1,39.83333333333334)(lat_2,38.33333333333334)(lat_0,37.66666666666666)(lon_0,-122)(x_0,2000000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {2768, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.06666666666667)(lat_0,36.5)(lon_0,-120.5)(x_0,2000000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {2769, srs::dpar::parameters<>(proj_lcc)(lat_1,37.25)(lat_2,36)(lat_0,35.33333333333334)(lon_0,-119)(x_0,2000000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {2770, srs::dpar::parameters<>(proj_lcc)(lat_1,35.46666666666667)(lat_2,34.03333333333333)(lat_0,33.5)(lon_0,-118)(x_0,2000000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {2771, srs::dpar::parameters<>(proj_lcc)(lat_1,33.88333333333333)(lat_2,32.78333333333333)(lat_0,32.16666666666666)(lon_0,-116.25)(x_0,2000000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {2772, srs::dpar::parameters<>(proj_lcc)(lat_1,40.78333333333333)(lat_2,39.71666666666667)(lat_0,39.33333333333334)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(units_m)(no_defs)},
            {2773, srs::dpar::parameters<>(proj_lcc)(lat_1,39.75)(lat_2,38.45)(lat_0,37.83333333333334)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(units_m)(no_defs)},
            {2774, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.23333333333333)(lat_0,36.66666666666666)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(units_m)(no_defs)},
            {2775, srs::dpar::parameters<>(proj_lcc)(lat_1,41.86666666666667)(lat_2,41.2)(lat_0,40.83333333333334)(lon_0,-72.75)(x_0,304800.6096)(y_0,152400.3048)(ellps_grs80)(units_m)(no_defs)},
            {2776, srs::dpar::parameters<>(proj_tmerc)(lat_0,38)(lon_0,-75.41666666666667)(k,0.999995)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2777, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-81)(k,0.999941177)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2778, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-82)(k,0.999941177)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2779, srs::dpar::parameters<>(proj_lcc)(lat_1,30.75)(lat_2,29.58333333333333)(lat_0,29)(lon_0,-84.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2780, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-82.16666666666667)(k,0.9999)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2781, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-84.16666666666667)(k,0.9999)(x_0,700000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2782, srs::dpar::parameters<>(proj_tmerc)(lat_0,18.83333333333333)(lon_0,-155.5)(k,0.999966667)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2783, srs::dpar::parameters<>(proj_tmerc)(lat_0,20.33333333333333)(lon_0,-156.6666666666667)(k,0.999966667)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2784, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.16666666666667)(lon_0,-158)(k,0.99999)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2785, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.83333333333333)(lon_0,-159.5)(k,0.99999)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2786, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.66666666666667)(lon_0,-160.1666666666667)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2787, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-112.1666666666667)(k,0.9999473679999999)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2788, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-114)(k,0.9999473679999999)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2789, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-115.75)(k,0.999933333)(x_0,800000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2790, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-88.33333333333333)(k,0.9999749999999999)(x_0,300000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2791, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-90.16666666666667)(k,0.999941177)(x_0,700000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2792, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-85.66666666666667)(k,0.999966667)(x_0,100000)(y_0,250000)(ellps_grs80)(units_m)(no_defs)},
            {2793, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-87.08333333333333)(k,0.999966667)(x_0,900000)(y_0,250000)(ellps_grs80)(units_m)(no_defs)},
            {2794, srs::dpar::parameters<>(proj_lcc)(lat_1,43.26666666666667)(lat_2,42.06666666666667)(lat_0,41.5)(lon_0,-93.5)(x_0,1500000)(y_0,1000000)(ellps_grs80)(units_m)(no_defs)},
            {2795, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.61666666666667)(lat_0,40)(lon_0,-93.5)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2796, srs::dpar::parameters<>(proj_lcc)(lat_1,39.78333333333333)(lat_2,38.71666666666667)(lat_0,38.33333333333334)(lon_0,-98)(x_0,400000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2797, srs::dpar::parameters<>(proj_lcc)(lat_1,38.56666666666667)(lat_2,37.26666666666667)(lat_0,36.66666666666666)(lon_0,-98.5)(x_0,400000)(y_0,400000)(ellps_grs80)(units_m)(no_defs)},
            {2798, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,38.96666666666667)(lat_0,37.5)(lon_0,-84.25)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2799, srs::dpar::parameters<>(proj_lcc)(lat_1,37.93333333333333)(lat_2,36.73333333333333)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,500000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {2800, srs::dpar::parameters<>(proj_lcc)(lat_1,32.66666666666666)(lat_2,31.16666666666667)(lat_0,30.5)(lon_0,-92.5)(x_0,1000000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2801, srs::dpar::parameters<>(proj_lcc)(lat_1,30.7)(lat_2,29.3)(lat_0,28.5)(lon_0,-91.33333333333333)(x_0,1000000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2802, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.66666666666666)(lon_0,-68.5)(k,0.9999)(x_0,300000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2803, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.16666666666667)(k,0.999966667)(x_0,900000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2804, srs::dpar::parameters<>(proj_lcc)(lat_1,39.45)(lat_2,38.3)(lat_0,37.66666666666666)(lon_0,-77)(x_0,400000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2805, srs::dpar::parameters<>(proj_lcc)(lat_1,42.68333333333333)(lat_2,41.71666666666667)(lat_0,41)(lon_0,-71.5)(x_0,200000)(y_0,750000)(ellps_grs80)(units_m)(no_defs)},
            {2806, srs::dpar::parameters<>(proj_lcc)(lat_1,41.48333333333333)(lat_2,41.28333333333333)(lat_0,41)(lon_0,-70.5)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2807, srs::dpar::parameters<>(proj_lcc)(lat_1,47.08333333333334)(lat_2,45.48333333333333)(lat_0,44.78333333333333)(lon_0,-87)(x_0,8000000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2808, srs::dpar::parameters<>(proj_lcc)(lat_1,45.7)(lat_2,44.18333333333333)(lat_0,43.31666666666667)(lon_0,-84.36666666666666)(x_0,6000000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2809, srs::dpar::parameters<>(proj_lcc)(lat_1,43.66666666666666)(lat_2,42.1)(lat_0,41.5)(lon_0,-84.36666666666666)(x_0,4000000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2810, srs::dpar::parameters<>(proj_lcc)(lat_1,48.63333333333333)(lat_2,47.03333333333333)(lat_0,46.5)(lon_0,-93.09999999999999)(x_0,800000)(y_0,100000)(ellps_grs80)(units_m)(no_defs)},
            {2811, srs::dpar::parameters<>(proj_lcc)(lat_1,47.05)(lat_2,45.61666666666667)(lat_0,45)(lon_0,-94.25)(x_0,800000)(y_0,100000)(ellps_grs80)(units_m)(no_defs)},
            {2812, srs::dpar::parameters<>(proj_lcc)(lat_1,45.21666666666667)(lat_2,43.78333333333333)(lat_0,43)(lon_0,-94)(x_0,800000)(y_0,100000)(ellps_grs80)(units_m)(no_defs)},
            {2813, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-88.83333333333333)(k,0.99995)(x_0,300000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2814, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-90.33333333333333)(k,0.99995)(x_0,700000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2815, srs::dpar::parameters<>(proj_tmerc)(lat_0,35.83333333333334)(lon_0,-90.5)(k,0.999933333)(x_0,250000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2816, srs::dpar::parameters<>(proj_tmerc)(lat_0,35.83333333333334)(lon_0,-92.5)(k,0.999933333)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2817, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.16666666666666)(lon_0,-94.5)(k,0.999941177)(x_0,850000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2818, srs::dpar::parameters<>(proj_lcc)(lat_1,49)(lat_2,45)(lat_0,44.25)(lon_0,-109.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2819, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,40)(lat_0,39.83333333333334)(lon_0,-100)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2820, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-115.5833333333333)(k,0.9999)(x_0,200000)(y_0,8000000)(ellps_grs80)(units_m)(no_defs)},
            {2821, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-116.6666666666667)(k,0.9999)(x_0,500000)(y_0,6000000)(ellps_grs80)(units_m)(no_defs)},
            {2822, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-118.5833333333333)(k,0.9999)(x_0,800000)(y_0,4000000)(ellps_grs80)(units_m)(no_defs)},
            {2823, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-71.66666666666667)(k,0.999966667)(x_0,300000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2824, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2825, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-104.3333333333333)(k,0.999909091)(x_0,165000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2826, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-106.25)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2827, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-107.8333333333333)(k,0.999916667)(x_0,830000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2828, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2829, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-76.58333333333333)(k,0.9999375)(x_0,250000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2830, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-78.58333333333333)(k,0.9999375)(x_0,350000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2831, srs::dpar::parameters<>(proj_lcc)(lat_1,41.03333333333333)(lat_2,40.66666666666666)(lat_0,40.16666666666666)(lon_0,-74)(x_0,300000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2832, srs::dpar::parameters<>(proj_lcc)(lat_1,48.73333333333333)(lat_2,47.43333333333333)(lat_0,47)(lon_0,-100.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2833, srs::dpar::parameters<>(proj_lcc)(lat_1,47.48333333333333)(lat_2,46.18333333333333)(lat_0,45.66666666666666)(lon_0,-100.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2834, srs::dpar::parameters<>(proj_lcc)(lat_1,41.7)(lat_2,40.43333333333333)(lat_0,39.66666666666666)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2835, srs::dpar::parameters<>(proj_lcc)(lat_1,40.03333333333333)(lat_2,38.73333333333333)(lat_0,38)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2836, srs::dpar::parameters<>(proj_lcc)(lat_1,36.76666666666667)(lat_2,35.56666666666667)(lat_0,35)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2837, srs::dpar::parameters<>(proj_lcc)(lat_1,35.23333333333333)(lat_2,33.93333333333333)(lat_0,33.33333333333334)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2838, srs::dpar::parameters<>(proj_lcc)(lat_1,46)(lat_2,44.33333333333334)(lat_0,43.66666666666666)(lon_0,-120.5)(x_0,2500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2839, srs::dpar::parameters<>(proj_lcc)(lat_1,44)(lat_2,42.33333333333334)(lat_0,41.66666666666666)(lon_0,-120.5)(x_0,1500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2840, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.08333333333334)(lon_0,-71.5)(k,0.99999375)(x_0,100000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2841, srs::dpar::parameters<>(proj_lcc)(lat_1,45.68333333333333)(lat_2,44.41666666666666)(lat_0,43.83333333333334)(lon_0,-100)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2842, srs::dpar::parameters<>(proj_lcc)(lat_1,44.4)(lat_2,42.83333333333334)(lat_0,42.33333333333334)(lon_0,-100.3333333333333)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2843, srs::dpar::parameters<>(proj_lcc)(lat_1,36.41666666666666)(lat_2,35.25)(lat_0,34.33333333333334)(lon_0,-86)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2844, srs::dpar::parameters<>(proj_lcc)(lat_1,36.18333333333333)(lat_2,34.65)(lat_0,34)(lon_0,-101.5)(x_0,200000)(y_0,1000000)(ellps_grs80)(units_m)(no_defs)},
            {2845, srs::dpar::parameters<>(proj_lcc)(lat_1,33.96666666666667)(lat_2,32.13333333333333)(lat_0,31.66666666666667)(lon_0,-98.5)(x_0,600000)(y_0,2000000)(ellps_grs80)(units_m)(no_defs)},
            {2846, srs::dpar::parameters<>(proj_lcc)(lat_1,31.88333333333333)(lat_2,30.11666666666667)(lat_0,29.66666666666667)(lon_0,-100.3333333333333)(x_0,700000)(y_0,3000000)(ellps_grs80)(units_m)(no_defs)},
            {2847, srs::dpar::parameters<>(proj_lcc)(lat_1,30.28333333333333)(lat_2,28.38333333333333)(lat_0,27.83333333333333)(lon_0,-99)(x_0,600000)(y_0,4000000)(ellps_grs80)(units_m)(no_defs)},
            {2848, srs::dpar::parameters<>(proj_lcc)(lat_1,27.83333333333333)(lat_2,26.16666666666667)(lat_0,25.66666666666667)(lon_0,-98.5)(x_0,300000)(y_0,5000000)(ellps_grs80)(units_m)(no_defs)},
            {2849, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.71666666666667)(lat_0,40.33333333333334)(lon_0,-111.5)(x_0,500000)(y_0,1000000)(ellps_grs80)(units_m)(no_defs)},
            {2850, srs::dpar::parameters<>(proj_lcc)(lat_1,40.65)(lat_2,39.01666666666667)(lat_0,38.33333333333334)(lon_0,-111.5)(x_0,500000)(y_0,2000000)(ellps_grs80)(units_m)(no_defs)},
            {2851, srs::dpar::parameters<>(proj_lcc)(lat_1,38.35)(lat_2,37.21666666666667)(lat_0,36.66666666666666)(lon_0,-111.5)(x_0,500000)(y_0,3000000)(ellps_grs80)(units_m)(no_defs)},
            {2852, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-72.5)(k,0.999964286)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2853, srs::dpar::parameters<>(proj_lcc)(lat_1,39.2)(lat_2,38.03333333333333)(lat_0,37.66666666666666)(lon_0,-78.5)(x_0,3500000)(y_0,2000000)(ellps_grs80)(units_m)(no_defs)},
            {2854, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,36.76666666666667)(lat_0,36.33333333333334)(lon_0,-78.5)(x_0,3500000)(y_0,1000000)(ellps_grs80)(units_m)(no_defs)},
            {2855, srs::dpar::parameters<>(proj_lcc)(lat_1,48.73333333333333)(lat_2,47.5)(lat_0,47)(lon_0,-120.8333333333333)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2856, srs::dpar::parameters<>(proj_lcc)(lat_1,47.33333333333334)(lat_2,45.83333333333334)(lat_0,45.33333333333334)(lon_0,-120.5)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2857, srs::dpar::parameters<>(proj_lcc)(lat_1,40.25)(lat_2,39)(lat_0,38.5)(lon_0,-79.5)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2858, srs::dpar::parameters<>(proj_lcc)(lat_1,38.88333333333333)(lat_2,37.48333333333333)(lat_0,37)(lon_0,-81)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2859, srs::dpar::parameters<>(proj_lcc)(lat_1,46.76666666666667)(lat_2,45.56666666666667)(lat_0,45.16666666666666)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2860, srs::dpar::parameters<>(proj_lcc)(lat_1,45.5)(lat_2,44.25)(lat_0,43.83333333333334)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2861, srs::dpar::parameters<>(proj_lcc)(lat_1,44.06666666666667)(lat_2,42.73333333333333)(lat_0,42)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2862, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-105.1666666666667)(k,0.9999375)(x_0,200000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2863, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-107.3333333333333)(k,0.9999375)(x_0,400000)(y_0,100000)(ellps_grs80)(units_m)(no_defs)},
            {2864, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-108.75)(k,0.9999375)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2865, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-110.0833333333333)(k,0.9999375)(x_0,800000)(y_0,100000)(ellps_grs80)(units_m)(no_defs)},
            {2866, srs::dpar::parameters<>(proj_lcc)(lat_1,18.43333333333333)(lat_2,18.03333333333333)(lat_0,17.83333333333333)(lon_0,-66.43333333333334)(x_0,200000)(y_0,200000)(ellps_grs80)(units_m)(no_defs)},
            {2867, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-110.1666666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2868, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-111.9166666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2869, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-113.75)(k,0.999933333)(x_0,213360)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2870, srs::dpar::parameters<>(proj_lcc)(lat_1,41.66666666666666)(lat_2,40)(lat_0,39.33333333333334)(lon_0,-122)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2871, srs::dpar::parameters<>(proj_lcc)(lat_1,39.83333333333334)(lat_2,38.33333333333334)(lat_0,37.66666666666666)(lon_0,-122)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2872, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.06666666666667)(lat_0,36.5)(lon_0,-120.5)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2873, srs::dpar::parameters<>(proj_lcc)(lat_1,37.25)(lat_2,36)(lat_0,35.33333333333334)(lon_0,-119)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2874, srs::dpar::parameters<>(proj_lcc)(lat_1,35.46666666666667)(lat_2,34.03333333333333)(lat_0,33.5)(lon_0,-118)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2875, srs::dpar::parameters<>(proj_lcc)(lat_1,33.88333333333333)(lat_2,32.78333333333333)(lat_0,32.16666666666666)(lon_0,-116.25)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2876, srs::dpar::parameters<>(proj_lcc)(lat_1,40.78333333333333)(lat_2,39.71666666666667)(lat_0,39.33333333333334)(lon_0,-105.5)(x_0,914401.8288036576)(y_0,304800.6096012192)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2877, srs::dpar::parameters<>(proj_lcc)(lat_1,39.75)(lat_2,38.45)(lat_0,37.83333333333334)(lon_0,-105.5)(x_0,914401.8288036576)(y_0,304800.6096012192)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2878, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.23333333333333)(lat_0,36.66666666666666)(lon_0,-105.5)(x_0,914401.8288036576)(y_0,304800.6096012192)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2879, srs::dpar::parameters<>(proj_lcc)(lat_1,41.86666666666667)(lat_2,41.2)(lat_0,40.83333333333334)(lon_0,-72.75)(x_0,304800.6096012192)(y_0,152400.3048006096)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2880, srs::dpar::parameters<>(proj_tmerc)(lat_0,38)(lon_0,-75.41666666666667)(k,0.999995)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2881, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-81)(k,0.999941177)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2882, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-82)(k,0.999941177)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2883, srs::dpar::parameters<>(proj_lcc)(lat_1,30.75)(lat_2,29.58333333333333)(lat_0,29)(lon_0,-84.5)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2884, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-82.16666666666667)(k,0.9999)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2885, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-84.16666666666667)(k,0.9999)(x_0,699999.9998983998)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2886, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-112.1666666666667)(k,0.9999473679999999)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2887, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-114)(k,0.9999473679999999)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2888, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-115.75)(k,0.999933333)(x_0,800000.0001016001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2889, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-85.66666666666667)(k,0.999966667)(x_0,99999.99989839978)(y_0,249364.9987299975)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2890, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-87.08333333333333)(k,0.999966667)(x_0,900000)(y_0,249364.9987299975)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2891, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,38.96666666666667)(lat_0,37.5)(lon_0,-84.25)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2892, srs::dpar::parameters<>(proj_lcc)(lat_1,37.93333333333333)(lat_2,36.73333333333333)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,500000.0001016001)(y_0,500000.0001016001)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2893, srs::dpar::parameters<>(proj_lcc)(lat_1,39.45)(lat_2,38.3)(lat_0,37.66666666666666)(lon_0,-77)(x_0,399999.9998983998)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2894, srs::dpar::parameters<>(proj_lcc)(lat_1,42.68333333333333)(lat_2,41.71666666666667)(lat_0,41)(lon_0,-71.5)(x_0,200000.0001016002)(y_0,750000)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2895, srs::dpar::parameters<>(proj_lcc)(lat_1,41.48333333333333)(lat_2,41.28333333333333)(lat_0,41)(lon_0,-70.5)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2896, srs::dpar::parameters<>(proj_lcc)(lat_1,47.08333333333334)(lat_2,45.48333333333333)(lat_0,44.78333333333333)(lon_0,-87)(x_0,7999999.999968001)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2897, srs::dpar::parameters<>(proj_lcc)(lat_1,45.7)(lat_2,44.18333333333333)(lat_0,43.31666666666667)(lon_0,-84.36666666666666)(x_0,5999999.999976001)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2898, srs::dpar::parameters<>(proj_lcc)(lat_1,43.66666666666666)(lat_2,42.1)(lat_0,41.5)(lon_0,-84.36666666666666)(x_0,3999999.999984)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2899, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-88.83333333333333)(k,0.99995)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2900, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-90.33333333333333)(k,0.99995)(x_0,699999.9998983998)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2901, srs::dpar::parameters<>(proj_lcc)(lat_1,49)(lat_2,45)(lat_0,44.25)(lon_0,-109.5)(x_0,599999.9999976)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2902, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-104.3333333333333)(k,0.999909091)(x_0,165000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2903, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-106.25)(k,0.9999)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2904, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-107.8333333333333)(k,0.999916667)(x_0,830000.0001016001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2905, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2906, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-76.58333333333333)(k,0.9999375)(x_0,249999.9998983998)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2907, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-78.58333333333333)(k,0.9999375)(x_0,350000.0001016001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2908, srs::dpar::parameters<>(proj_lcc)(lat_1,41.03333333333333)(lat_2,40.66666666666666)(lat_0,40.16666666666666)(lon_0,-74)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2909, srs::dpar::parameters<>(proj_lcc)(lat_1,48.73333333333333)(lat_2,47.43333333333333)(lat_0,47)(lon_0,-100.5)(x_0,599999.9999976)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2910, srs::dpar::parameters<>(proj_lcc)(lat_1,47.48333333333333)(lat_2,46.18333333333333)(lat_0,45.66666666666666)(lon_0,-100.5)(x_0,599999.9999976)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2911, srs::dpar::parameters<>(proj_lcc)(lat_1,36.76666666666667)(lat_2,35.56666666666667)(lat_0,35)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2912, srs::dpar::parameters<>(proj_lcc)(lat_1,35.23333333333333)(lat_2,33.93333333333333)(lat_0,33.33333333333334)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2913, srs::dpar::parameters<>(proj_lcc)(lat_1,46)(lat_2,44.33333333333334)(lat_0,43.66666666666666)(lon_0,-120.5)(x_0,2500000.0001424)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2914, srs::dpar::parameters<>(proj_lcc)(lat_1,44)(lat_2,42.33333333333334)(lat_0,41.66666666666666)(lon_0,-120.5)(x_0,1500000.0001464)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2915, srs::dpar::parameters<>(proj_lcc)(lat_1,36.41666666666666)(lat_2,35.25)(lat_0,34.33333333333334)(lon_0,-86)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2916, srs::dpar::parameters<>(proj_lcc)(lat_1,36.18333333333333)(lat_2,34.65)(lat_0,34)(lon_0,-101.5)(x_0,200000.0001016002)(y_0,999999.9998983998)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2917, srs::dpar::parameters<>(proj_lcc)(lat_1,33.96666666666667)(lat_2,32.13333333333333)(lat_0,31.66666666666667)(lon_0,-98.5)(x_0,600000)(y_0,2000000.0001016)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2918, srs::dpar::parameters<>(proj_lcc)(lat_1,31.88333333333333)(lat_2,30.11666666666667)(lat_0,29.66666666666667)(lon_0,-100.3333333333333)(x_0,699999.9998983998)(y_0,3000000)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2919, srs::dpar::parameters<>(proj_lcc)(lat_1,30.28333333333333)(lat_2,28.38333333333333)(lat_0,27.83333333333333)(lon_0,-99)(x_0,600000)(y_0,3999999.9998984)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2920, srs::dpar::parameters<>(proj_lcc)(lat_1,27.83333333333333)(lat_2,26.16666666666667)(lat_0,25.66666666666667)(lon_0,-98.5)(x_0,300000.0000000001)(y_0,5000000.0001016)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2921, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.71666666666667)(lat_0,40.33333333333334)(lon_0,-111.5)(x_0,500000.0001504)(y_0,999999.9999960001)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2922, srs::dpar::parameters<>(proj_lcc)(lat_1,40.65)(lat_2,39.01666666666667)(lat_0,38.33333333333334)(lon_0,-111.5)(x_0,500000.0001504)(y_0,1999999.999992)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2923, srs::dpar::parameters<>(proj_lcc)(lat_1,38.35)(lat_2,37.21666666666667)(lat_0,36.66666666666666)(lon_0,-111.5)(x_0,500000.0001504)(y_0,2999999.999988)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2924, srs::dpar::parameters<>(proj_lcc)(lat_1,39.2)(lat_2,38.03333333333333)(lat_0,37.66666666666666)(lon_0,-78.5)(x_0,3500000.0001016)(y_0,2000000.0001016)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2925, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,36.76666666666667)(lat_0,36.33333333333334)(lon_0,-78.5)(x_0,3500000.0001016)(y_0,999999.9998983998)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2926, srs::dpar::parameters<>(proj_lcc)(lat_1,48.73333333333333)(lat_2,47.5)(lat_0,47)(lon_0,-120.8333333333333)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2927, srs::dpar::parameters<>(proj_lcc)(lat_1,47.33333333333334)(lat_2,45.83333333333334)(lat_0,45.33333333333334)(lon_0,-120.5)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2928, srs::dpar::parameters<>(proj_lcc)(lat_1,46.76666666666667)(lat_2,45.56666666666667)(lat_0,45.16666666666666)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2929, srs::dpar::parameters<>(proj_lcc)(lat_1,45.5)(lat_2,44.25)(lat_0,43.83333333333334)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2930, srs::dpar::parameters<>(proj_lcc)(lat_1,44.06666666666667)(lat_2,42.73333333333333)(lat_0,42)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2931, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,13)(k,0.9996)(x_0,500000)(y_0,0)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-106,-87,188,0,0,0,0))(units_m)(no_defs)},
            {2932, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.45)(lon_0,51.21666666666667)(k,0.99999)(x_0,200000)(y_0,300000)(ellps_intl)(towgs84,srs::detail::towgs84<>(-119.425,-303.659,-11.0006,1.1643,0.174458,1.09626,3.65706))(units_m)(no_defs)},
            {2933, srs::dpar::parameters<>(proj_utm)(zone,50)(south)(ellps_bessel)(units_m)(no_defs)},
            {2934, srs::dpar::parameters<>(proj_merc)(lon_0,110)(k,0.997)(x_0,3900000)(y_0,900000)(ellps_bessel)(pm_jakarta)(units_m)(no_defs)},
            {2935, srs::dpar::parameters<>(proj_tmerc)(lat_0,0.1166666666666667)(lon_0,41.53333333333333)(k,1)(x_0,1300000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2936, srs::dpar::parameters<>(proj_tmerc)(lat_0,0.1166666666666667)(lon_0,44.53333333333333)(k,1)(x_0,2300000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2937, srs::dpar::parameters<>(proj_tmerc)(lat_0,0.1166666666666667)(lon_0,47.53333333333333)(k,1)(x_0,3300000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2938, srs::dpar::parameters<>(proj_tmerc)(lat_0,0.1166666666666667)(lon_0,50.53333333333333)(k,1)(x_0,4300000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2939, srs::dpar::parameters<>(proj_tmerc)(lat_0,0.1333333333333333)(lon_0,50.76666666666667)(k,1)(x_0,2300000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2940, srs::dpar::parameters<>(proj_tmerc)(lat_0,0.1333333333333333)(lon_0,53.76666666666667)(k,1)(x_0,3300000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2941, srs::dpar::parameters<>(proj_tmerc)(lat_0,0.1333333333333333)(lon_0,56.76666666666667)(k,1)(x_0,4300000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {2942, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_intl)(towgs84,srs::detail::towgs84<>(-499,-249,314,0,0,0,0))(units_m)(no_defs)},
            {2943, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_intl)(units_m)(no_defs)},
            {2944, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-55.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2945, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-58.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2946, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-61.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2947, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-64.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2948, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-67.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2949, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-70.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2950, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-73.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2951, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-76.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2952, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-79.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2953, srs::dpar::parameters<>(proj_sterea)(lat_0,46.5)(lon_0,-66.5)(k,0.999912)(x_0,2500000)(y_0,7500000)(ellps_grs80)(units_m)(no_defs)},
            {2954, srs::dpar::parameters<>(proj_sterea)(lat_0,47.25)(lon_0,-63)(k,0.999912)(x_0,400000)(y_0,800000)(ellps_grs80)(units_m)(no_defs)},
            {2955, srs::dpar::parameters<>(proj_utm)(zone,11)(ellps_grs80)(units_m)(no_defs)},
            {2956, srs::dpar::parameters<>(proj_utm)(zone,12)(ellps_grs80)(units_m)(no_defs)},
            {2957, srs::dpar::parameters<>(proj_utm)(zone,13)(ellps_grs80)(units_m)(no_defs)},
            {2958, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_grs80)(units_m)(no_defs)},
            {2959, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_grs80)(units_m)(no_defs)},
            {2960, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_grs80)(units_m)(no_defs)},
            {2961, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_grs80)(units_m)(no_defs)},
            {2962, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_grs80)(units_m)(no_defs)},
            //{2963},
            {2964, srs::dpar::parameters<>(proj_aea)(lat_1,55)(lat_2,65)(lat_0,50)(lon_0,-154)(x_0,0)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {2965, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-85.66666666666667)(k,0.999966667)(x_0,99999.99989839978)(y_0,249999.9998983998)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2966, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-87.08333333333333)(k,0.999966667)(x_0,900000)(y_0,249999.9998983998)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {2967, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-85.66666666666667)(k,0.999966667)(x_0,99999.99989839978)(y_0,249999.9998983998)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2968, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-87.08333333333333)(k,0.999966667)(x_0,900000)(y_0,249999.9998983998)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {2969, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_intl)(towgs84,srs::detail::towgs84<>(137,248,-430,0,0,0,0))(units_m)(no_defs)},
            {2970, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_intl)(units_m)(no_defs)},
            {2971, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_intl)(towgs84,srs::detail::towgs84<>(-186,230,110,0,0,0,0))(units_m)(no_defs)},
            {2972, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_grs80)(towgs84,srs::detail::towgs84<>(2,2,-2,0,0,0,0))(units_m)(no_defs)},
            {2973, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_intl)(units_m)(no_defs)},
            {2975, srs::dpar::parameters<>(proj_utm)(zone,40)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2976, srs::dpar::parameters<>(proj_utm)(zone,6)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(162,117,154,0,0,0,0))(units_m)(no_defs)},
            {2977, srs::dpar::parameters<>(proj_utm)(zone,5)(south)(ellps_intl)(units_m)(no_defs)},
            {2978, srs::dpar::parameters<>(proj_utm)(zone,7)(south)(ellps_intl)(units_m)(no_defs)},
            {2979, srs::dpar::parameters<>(proj_utm)(zone,42)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(145,-187,103,0,0,0,0))(units_m)(no_defs)},
            {2980, srs::dpar::parameters<>(proj_utm)(zone,38)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-382,-59,-262,0,0,0,0))(units_m)(no_defs)},
            {2981, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_intl)(units_m)(no_defs)},
            {2982, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_intl)(units_m)(no_defs)},
            {2983, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,4.4798))(units_m)(no_defs)},
            {2984, srs::dpar::parameters<>(proj_lcc)(lat_1,-20.66666666666667)(lat_2,-22.33333333333333)(lat_0,-21.5)(lon_0,166)(x_0,400000)(y_0,300000)(ellps_intl)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            //{2985},
            //{2986},
            {2987, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(30,430,368,0,0,0,0))(units_m)(no_defs)},
            {2988, srs::dpar::parameters<>(proj_utm)(zone,1)(south)(ellps_intl)(units_m)(no_defs)},
            {2989, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {2990, srs::dpar::parameters<>(proj_tmerc)(lat_0,-21.11666666666667)(lon_0,55.53333333333333)(k,1)(x_0,50000)(y_0,160000)(ellps_intl)(units_m)(no_defs)},
            {2991, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,45.5)(lat_0,41.75)(lon_0,-120.5)(x_0,400000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {2992, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,45.5)(lat_0,41.75)(lon_0,-120.5)(x_0,399999.9999984)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048)(no_defs)},
            {2993, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,45.5)(lat_0,41.75)(lon_0,-120.5)(x_0,400000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {2994, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,45.5)(lat_0,41.75)(lon_0,-120.5)(x_0,399999.9999984)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {2995, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_intl)(units_m)(no_defs)},
            {2996, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_intl)(units_m)(no_defs)},
            {2997, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7))(units_m)(no_defs)},
            {2998, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_intl)(units_m)(no_defs)},
            {2999, srs::dpar::parameters<>(proj_utm)(zone,38)(south)(ellps_intl)(units_m)(no_defs)},
            {3000, srs::dpar::parameters<>(proj_merc)(lon_0,110)(k,0.997)(x_0,3900000)(y_0,900000)(ellps_bessel)(units_m)(no_defs)},
            {3001, srs::dpar::parameters<>(proj_merc)(lon_0,110)(k,0.997)(x_0,3900000)(y_0,900000)(ellps_bessel)(units_m)(no_defs)},
            {3002, srs::dpar::parameters<>(proj_merc)(lon_0,110)(k,0.997)(x_0,3900000)(y_0,900000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(-587.8,519.75,145.76,0,0,0,0))(units_m)(no_defs)},
            {3003, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9)(k,0.9996)(x_0,1500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {3004, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,0.9996)(x_0,2520000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {3005, srs::dpar::parameters<>(proj_aea)(lat_1,50)(lat_2,58.5)(lat_0,45)(lon_0,-126)(x_0,1000000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3006, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3007, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,12)(k,1)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3008, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,13.5)(k,1)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3009, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3010, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,16.5)(k,1)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3011, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18)(k,1)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3012, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,14.25)(k,1)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3013, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15.75)(k,1)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3014, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,17.25)(k,1)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3015, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18.75)(k,1)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3016, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,20.25)(k,1)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3017, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21.75)(k,1)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3018, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,23.25)(k,1)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3019, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,11.30827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3020, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,13.55827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3021, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15.80827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3022, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18.05827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3023, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,20.30827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3024, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,22.55827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3025, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,11.30827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3026, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,13.55827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3027, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15.80827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3028, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18.05827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3029, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,20.30827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3030, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,22.55827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3031, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-71)(lon_0,0)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3032, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-71)(lon_0,70)(k,1)(x_0,6000000)(y_0,6000000)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3033, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.5)(lat_2,-74.5)(lat_0,-50)(lon_0,70)(x_0,6000000)(y_0,6000000)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3034, srs::dpar::parameters<>(proj_lcc)(lat_1,35)(lat_2,65)(lat_0,52)(lon_0,10)(x_0,4000000)(y_0,2800000)(ellps_grs80)(units_m)(no_defs)},
            {3035, srs::dpar::parameters<>(proj_laea)(lat_0,52)(lon_0,10)(x_0,4321000)(y_0,3210000)(ellps_grs80)(units_m)(no_defs)},
            {3036, srs::dpar::parameters<>(proj_utm)(zone,36)(south)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,-0,-0,-0,0))(units_m)(no_defs)},
            {3037, srs::dpar::parameters<>(proj_utm)(zone,37)(south)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,-0,-0,-0,0))(units_m)(no_defs)},
            {3038, srs::dpar::parameters<>(proj_utm)(zone,26)(ellps_grs80)(units_m)(no_defs)},
            {3039, srs::dpar::parameters<>(proj_utm)(zone,27)(ellps_grs80)(units_m)(no_defs)},
            {3040, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_grs80)(units_m)(no_defs)},
            {3041, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_grs80)(units_m)(no_defs)},
            {3042, srs::dpar::parameters<>(proj_utm)(zone,30)(ellps_grs80)(units_m)(no_defs)},
            {3043, srs::dpar::parameters<>(proj_utm)(zone,31)(ellps_grs80)(units_m)(no_defs)},
            {3044, srs::dpar::parameters<>(proj_utm)(zone,32)(ellps_grs80)(units_m)(no_defs)},
            {3045, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_grs80)(units_m)(no_defs)},
            {3046, srs::dpar::parameters<>(proj_utm)(zone,34)(ellps_grs80)(units_m)(no_defs)},
            {3047, srs::dpar::parameters<>(proj_utm)(zone,35)(ellps_grs80)(units_m)(no_defs)},
            {3048, srs::dpar::parameters<>(proj_utm)(zone,36)(ellps_grs80)(units_m)(no_defs)},
            {3049, srs::dpar::parameters<>(proj_utm)(zone,37)(ellps_grs80)(units_m)(no_defs)},
            {3050, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_grs80)(units_m)(no_defs)},
            {3051, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_grs80)(units_m)(no_defs)},
            //{3052},
            //{3053},
            {3054, srs::dpar::parameters<>(proj_utm)(zone,26)(ellps_intl)(towgs84,srs::detail::towgs84<>(-73,46,-86,0,0,0,0))(units_m)(no_defs)},
            {3055, srs::dpar::parameters<>(proj_utm)(zone,27)(ellps_intl)(towgs84,srs::detail::towgs84<>(-73,46,-86,0,0,0,0))(units_m)(no_defs)},
            {3056, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_intl)(towgs84,srs::detail::towgs84<>(-73,46,-86,0,0,0,0))(units_m)(no_defs)},
            {3057, srs::dpar::parameters<>(proj_lcc)(lat_1,64.25)(lat_2,65.75)(lat_0,65)(lon_0,-19)(x_0,500000)(y_0,500000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3058, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-8.5)(k,1)(x_0,50000)(y_0,-7800000)(ellps_intl)(towgs84,srs::detail::towgs84<>(982.609,552.753,-540.873,32.3934,-153.257,-96.2266,16.805))(units_m)(no_defs)},
            {3059, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,0.9996)(x_0,500000)(y_0,-6000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3060, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_intl)(units_m)(no_defs)},
            {3061, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_intl)(units_m)(no_defs)},
            {3062, srs::dpar::parameters<>(proj_utm)(zone,26)(ellps_intl)(units_m)(no_defs)},
            {3063, srs::dpar::parameters<>(proj_utm)(zone,26)(ellps_intl)(units_m)(no_defs)},
            {3064, srs::dpar::parameters<>(proj_utm)(zone,32)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3065, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3066, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,37)(k,0.9998)(x_0,500000)(y_0,-3000000)(ellps_intl)(units_m)(no_defs)},
            {3067, srs::dpar::parameters<>(proj_utm)(zone,35)(ellps_grs80)(units_m)(no_defs)},
            {3068, srs::dpar::parameters<>(proj_cass)(lat_0,52.41864827777778)(lon_0,13.62720366666667)(x_0,40000)(y_0,10000)(ellps_bessel)(srs::dpar::datum_potsdam)(units_m)(no_defs)},
            {3069, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-90)(k,0.9996)(x_0,500000)(y_0,-4500000)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {3070, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-90)(k,0.9996)(x_0,520000)(y_0,-4480000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3071, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-90)(k,0.9996)(x_0,520000)(y_0,-4480000)(ellps_grs80)(units_m)(no_defs)},
            {3072, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.83333333333334)(lon_0,-67.875)(k,0.99998)(x_0,700000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3073, srs::dpar::parameters<>(proj_tmerc)(lat_0,43)(lon_0,-69.125)(k,0.99998)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3074, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.375)(k,0.99998)(x_0,300000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3075, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.83333333333334)(lon_0,-67.875)(k,0.99998)(x_0,700000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3076, srs::dpar::parameters<>(proj_tmerc)(lat_0,43)(lon_0,-69.125)(k,0.99998)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3077, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.375)(k,0.99998)(x_0,300000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3078, srs::dpar::parameters<>(proj_omerc)(lat_0,45.30916666666666)(lonc,-86)(alpha,337.25556)(k,0.9996)(x_0,2546731.496)(y_0,-4354009.816)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3079, srs::dpar::parameters<>(proj_omerc)(lat_0,45.30916666666666)(lonc,-86)(alpha,337.25556)(k,0.9996)(x_0,2546731.496)(y_0,-4354009.816)(ellps_grs80)(units_m)(no_defs)},
            {3080, srs::dpar::parameters<>(proj_lcc)(lat_1,27.41666666666667)(lat_2,34.91666666666666)(lat_0,31.16666666666667)(lon_0,-100)(x_0,914400)(y_0,914400)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048)(no_defs)},
            {3081, srs::dpar::parameters<>(proj_lcc)(lat_1,27.41666666666667)(lat_2,34.91666666666666)(lat_0,31.16666666666667)(lon_0,-100)(x_0,1000000)(y_0,1000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3082, srs::dpar::parameters<>(proj_lcc)(lat_1,27.5)(lat_2,35)(lat_0,18)(lon_0,-100)(x_0,1500000)(y_0,5000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3083, srs::dpar::parameters<>(proj_aea)(lat_1,27.5)(lat_2,35)(lat_0,18)(lon_0,-100)(x_0,1500000)(y_0,6000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3084, srs::dpar::parameters<>(proj_lcc)(lat_1,27.5)(lat_2,35)(lat_0,18)(lon_0,-100)(x_0,1500000)(y_0,5000000)(ellps_grs80)(units_m)(no_defs)},
            {3085, srs::dpar::parameters<>(proj_aea)(lat_1,27.5)(lat_2,35)(lat_0,18)(lon_0,-100)(x_0,1500000)(y_0,6000000)(ellps_grs80)(units_m)(no_defs)},
            {3086, srs::dpar::parameters<>(proj_aea)(lat_1,24)(lat_2,31.5)(lat_0,24)(lon_0,-84)(x_0,400000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3087, srs::dpar::parameters<>(proj_aea)(lat_1,24)(lat_2,31.5)(lat_0,24)(lon_0,-84)(x_0,400000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3088, srs::dpar::parameters<>(proj_lcc)(lat_1,37.08333333333334)(lat_2,38.66666666666666)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,1500000)(y_0,1000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3089, srs::dpar::parameters<>(proj_lcc)(lat_1,37.08333333333334)(lat_2,38.66666666666666)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,1500000)(y_0,999999.9998983998)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3090, srs::dpar::parameters<>(proj_lcc)(lat_1,37.08333333333334)(lat_2,38.66666666666666)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,1500000)(y_0,1000000)(ellps_grs80)(units_m)(no_defs)},
            {3091, srs::dpar::parameters<>(proj_lcc)(lat_1,37.08333333333334)(lat_2,38.66666666666666)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,1500000)(y_0,999999.9998983998)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3092, srs::dpar::parameters<>(proj_utm)(zone,51)(ellps_bessel)(units_m)(no_defs)},
            {3093, srs::dpar::parameters<>(proj_utm)(zone,52)(ellps_bessel)(units_m)(no_defs)},
            {3094, srs::dpar::parameters<>(proj_utm)(zone,53)(ellps_bessel)(units_m)(no_defs)},
            {3095, srs::dpar::parameters<>(proj_utm)(zone,54)(ellps_bessel)(units_m)(no_defs)},
            {3096, srs::dpar::parameters<>(proj_utm)(zone,55)(ellps_bessel)(units_m)(no_defs)},
            {3097, srs::dpar::parameters<>(proj_utm)(zone,51)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3098, srs::dpar::parameters<>(proj_utm)(zone,52)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3099, srs::dpar::parameters<>(proj_utm)(zone,53)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3100, srs::dpar::parameters<>(proj_utm)(zone,54)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3101, srs::dpar::parameters<>(proj_utm)(zone,55)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3102, srs::dpar::parameters<>(proj_lcc)(lat_1,-14.26666666666667)(lat_0,-14.26666666666667)(lon_0,-170)(k_0,1)(x_0,152400.3048006096)(y_0,95169.31165862332)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-115,118,426,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3103, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_clrk80)(units_m)(no_defs)},
            {3104, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_clrk80)(units_m)(no_defs)},
            {3105, srs::dpar::parameters<>(proj_utm)(zone,30)(ellps_clrk80)(units_m)(no_defs)},
            {3106, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,90)(k,0.9996)(x_0,500000)(y_0,0)(a,6377276.345)(b,6356075.41314024)(units_m)(no_defs)},
            {3107, srs::dpar::parameters<>(proj_lcc)(lat_1,-28)(lat_2,-36)(lat_0,-32)(lon_0,135)(x_0,1000000)(y_0,2000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3108, srs::dpar::parameters<>(proj_tmerc)(lat_0,49.5)(lon_0,-2.416666666666667)(k,0.999997)(x_0,47000)(y_0,50000)(ellps_grs80)(units_m)(no_defs)},
            {3109, srs::dpar::parameters<>(proj_tmerc)(lat_0,49.225)(lon_0,-2.135)(k,0.9999999000000001)(x_0,40000)(y_0,70000)(ellps_grs80)(units_m)(no_defs)},
            {3110, srs::dpar::parameters<>(proj_lcc)(lat_1,-36)(lat_2,-38)(lat_0,-37)(lon_0,145)(x_0,2500000)(y_0,4500000)(ellps_aust_sa)(units_m)(no_defs)},
            {3111, srs::dpar::parameters<>(proj_lcc)(lat_1,-36)(lat_2,-38)(lat_0,-37)(lon_0,145)(x_0,2500000)(y_0,2500000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3112, srs::dpar::parameters<>(proj_lcc)(lat_1,-18)(lat_2,-36)(lat_0,0)(lon_0,134)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3113, srs::dpar::parameters<>(proj_tmerc)(lat_0,-28)(lon_0,153)(k,0.99999)(x_0,50000)(y_0,100000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3114, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.596200416666666)(lon_0,-80.07750791666666)(k,1)(x_0,1000000)(y_0,1000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3115, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.596200416666666)(lon_0,-77.07750791666666)(k,1)(x_0,1000000)(y_0,1000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3116, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.596200416666666)(lon_0,-74.07750791666666)(k,1)(x_0,1000000)(y_0,1000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3117, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.596200416666666)(lon_0,-71.07750791666666)(k,1)(x_0,1000000)(y_0,1000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3118, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.596200416666666)(lon_0,-68.07750791666666)(k,1)(x_0,1000000)(y_0,1000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3119, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,10.5)(k,0.999)(x_0,1000000)(y_0,1000000)(ellps_intl)(towgs84,srs::detail::towgs84<>(-206.1,-174.7,-87.7,0,0,0,0))(units_m)(no_defs)},
            {3120, srs::dpar::parameters<>(proj_sterea)(lat_0,50.625)(lon_0,21.08333333333333)(k,0.9998)(x_0,4637000)(y_0,5467000)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {3121, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,0.99995)(x_0,500000)(y_0,0)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06))(units_m)(no_defs)},
            {3122, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,119)(k,0.99995)(x_0,500000)(y_0,0)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06))(units_m)(no_defs)},
            {3123, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,121)(k,0.99995)(x_0,500000)(y_0,0)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06))(units_m)(no_defs)},
            {3124, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,0.99995)(x_0,500000)(y_0,0)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06))(units_m)(no_defs)},
            {3125, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,125)(k,0.99995)(x_0,500000)(y_0,0)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06))(units_m)(no_defs)},
            {3126, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,19)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3127, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,20)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3128, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3129, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,22)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3130, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,23)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3131, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3132, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,25)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3133, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,26)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3134, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3135, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,28)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3136, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,29)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3137, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,30)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3138, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,31)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            //{3139},
            {3140, srs::dpar::parameters<>(proj_cass)(lat_0,-18)(lon_0,178)(x_0,109435.392)(y_0,141622.272)(a,6378306.3696)(b,6356571.996)(towgs84,srs::detail::towgs84<>(51,391,-36,0,0,0,0))(to_meter,0.201168)(no_defs)},
            {3141, srs::dpar::parameters<>(proj_utm)(zone,60)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(265.025,384.929,-194.046,0,0,0,0))(units_m)(no_defs)},
            {3142, srs::dpar::parameters<>(proj_utm)(zone,1)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(265.025,384.929,-194.046,0,0,0,0))(units_m)(no_defs)},
            {3143, srs::dpar::parameters<>(proj_tmerc)(lat_0,-17)(lon_0,178.75)(k,0.99985)(x_0,2000000)(y_0,4000000)(ellps_wgs72)(units_m)(no_defs)},
            //{3144},
            //{3145},
            {3146, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18)(k,1)(x_0,6500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {3147, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {3148, srs::dpar::parameters<>(proj_utm)(zone,48)(a,6377276.345)(b,6356075.41314024)(units_m)(no_defs)},
            {3149, srs::dpar::parameters<>(proj_utm)(zone,49)(a,6377276.345)(b,6356075.41314024)(units_m)(no_defs)},
            {3150, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18)(k,1)(x_0,6500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {3151, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {3152, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18.05779)(k,0.99999425)(x_0,100178.1808)(y_0,-6500614.7836)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3153, srs::dpar::parameters<>(proj_aea)(lat_1,50)(lat_2,58.5)(lat_0,45)(lon_0,-126)(x_0,1000000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3154, srs::dpar::parameters<>(proj_utm)(zone,7)(ellps_grs80)(units_m)(no_defs)},
            {3155, srs::dpar::parameters<>(proj_utm)(zone,8)(ellps_grs80)(units_m)(no_defs)},
            {3156, srs::dpar::parameters<>(proj_utm)(zone,9)(ellps_grs80)(units_m)(no_defs)},
            {3157, srs::dpar::parameters<>(proj_utm)(zone,10)(ellps_grs80)(units_m)(no_defs)},
            {3158, srs::dpar::parameters<>(proj_utm)(zone,14)(ellps_grs80)(units_m)(no_defs)},
            {3159, srs::dpar::parameters<>(proj_utm)(zone,15)(ellps_grs80)(units_m)(no_defs)},
            {3160, srs::dpar::parameters<>(proj_utm)(zone,16)(ellps_grs80)(units_m)(no_defs)},
            {3161, srs::dpar::parameters<>(proj_lcc)(lat_1,44.5)(lat_2,53.5)(lat_0,0)(lon_0,-85)(x_0,930000)(y_0,6430000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3162, srs::dpar::parameters<>(proj_lcc)(lat_1,44.5)(lat_2,53.5)(lat_0,0)(lon_0,-85)(x_0,930000)(y_0,6430000)(ellps_grs80)(units_m)(no_defs)},
            {3163, srs::dpar::parameters<>(proj_lcc)(lat_1,-20.66666666666667)(lat_2,-22.33333333333333)(lat_0,-21.5)(lon_0,166)(x_0,400000)(y_0,300000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3164, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(-56.263,16.136,-22.856,0,0,0,0))(units_m)(no_defs)},
            {3165, srs::dpar::parameters<>(proj_lcc)(lat_1,-22.24469175)(lat_2,-22.29469175)(lat_0,-22.26969175)(lon_0,166.44242575)(x_0,0.66)(y_0,1.02)(ellps_intl)(units_m)(no_defs)},
            {3166, srs::dpar::parameters<>(proj_lcc)(lat_1,-22.24472222222222)(lat_2,-22.29472222222222)(lat_0,-22.26972222222222)(lon_0,166.4425)(x_0,8.313000000000001)(y_0,-2.354)(ellps_intl)(units_m)(no_defs)},
            {3167, srs::dpar::parameters<>(proj_omerc)(lat_0,4)(lonc,102.25)(alpha,323.0257905)(k,0.99984)(x_0,40000)(y_0,0)(a,6377295.664)(b,6356094.667915204)(to_meter,20.116756)(no_defs)},
            {3168, srs::dpar::parameters<>(proj_omerc)(lat_0,4)(lonc,102.25)(alpha,323.0257905)(k,0.99984)(x_0,804670.24)(y_0,0)(a,6377295.664)(b,6356094.667915204)(units_m)(no_defs)},
            {3169, srs::dpar::parameters<>(proj_utm)(zone,57)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3170, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3171, srs::dpar::parameters<>(proj_utm)(zone,59)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3172, srs::dpar::parameters<>(proj_utm)(zone,59)(south)(ellps_intl)(units_m)(no_defs)},
            //{3173},
            {3174, srs::dpar::parameters<>(proj_aea)(lat_1,42.122774)(lat_2,49.01518)(lat_0,45.568977)(lon_0,-84.455955)(x_0,1000000)(y_0,1000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3175, srs::dpar::parameters<>(proj_aea)(lat_1,42.122774)(lat_2,49.01518)(lat_0,45.568977)(lon_0,-83.248627)(x_0,1000000)(y_0,1000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3176, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,106)(k,0.9996)(x_0,500000)(y_0,0)(a,6377276.345)(b,6356075.41314024)(units_m)(no_defs)},
            {3177, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,17)(k,0.9965000000000001)(x_0,1000000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3178, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3179, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3180, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3181, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3182, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3183, srs::dpar::parameters<>(proj_utm)(zone,23)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3184, srs::dpar::parameters<>(proj_utm)(zone,24)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3185, srs::dpar::parameters<>(proj_utm)(zone,25)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3186, srs::dpar::parameters<>(proj_utm)(zone,26)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3187, srs::dpar::parameters<>(proj_utm)(zone,27)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3188, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3189, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3190, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9)(k,0.99995)(x_0,200000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3191, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,11)(k,0.99995)(x_0,200000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3192, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,13)(k,0.99995)(x_0,200000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3193, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,0.99995)(x_0,200000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3194, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,17)(k,0.99995)(x_0,200000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3195, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,19)(k,0.99995)(x_0,200000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3196, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,0.99995)(x_0,200000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3197, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,23)(k,0.99995)(x_0,200000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3198, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,25)(k,0.99995)(x_0,200000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3199, srs::dpar::parameters<>(proj_utm)(zone,32)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3200, srs::dpar::parameters<>(proj_lcc)(lat_1,32.5)(lat_0,32.5)(lon_0,45)(k_0,0.9987864078000001)(x_0,1500000)(y_0,1166200)(ellps_clrk80)(units_m)(no_defs)},
            {3201, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3202, srs::dpar::parameters<>(proj_utm)(zone,34)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3203, srs::dpar::parameters<>(proj_utm)(zone,35)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(units_m)(no_defs)},
            {3204, srs::dpar::parameters<>(proj_lcc)(lat_1,-60.66666666666666)(lat_2,-63.33333333333334)(lat_0,-90)(lon_0,-66)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3205, srs::dpar::parameters<>(proj_lcc)(lat_1,-60.66666666666666)(lat_2,-63.33333333333334)(lat_0,-90)(lon_0,-54)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3206, srs::dpar::parameters<>(proj_lcc)(lat_1,-60.66666666666666)(lat_2,-63.33333333333334)(lat_0,-90)(lon_0,-42)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3207, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,-174)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3208, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,-66)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3209, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,-54)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3210, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,42)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3211, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,54)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3212, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,66)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3213, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,78)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3214, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,90)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3215, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,102)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3216, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,114)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3217, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,126)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3218, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,138)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3219, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,150)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3220, srs::dpar::parameters<>(proj_lcc)(lat_1,-64.66666666666667)(lat_2,-67.33333333333333)(lat_0,-90)(lon_0,162)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3221, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,-102)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3222, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,-90)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3223, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,-78)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3224, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,-66)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3225, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,-18)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3226, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,-6)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3227, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,6)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3228, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,18)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3229, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,30)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3230, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,42)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3231, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,54)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3232, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,66)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3233, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,78)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3234, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,90)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3235, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,102)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3236, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,114)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3237, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,126)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3238, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,138)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3239, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,150)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3240, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,162)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3241, srs::dpar::parameters<>(proj_lcc)(lat_1,-68.66666666666667)(lat_2,-71.33333333333333)(lat_0,-90)(lon_0,174)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3242, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,-153)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3243, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,-135)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3244, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,-117)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3245, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,-99)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3246, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,-81)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3247, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,-63)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3248, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,-27)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3249, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,-9)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3250, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,9)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3251, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,27)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3252, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,45)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3253, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,63)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3254, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,81)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3255, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,99)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3256, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,117)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3257, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,135)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3258, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,153)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3259, srs::dpar::parameters<>(proj_lcc)(lat_1,-72.66666666666667)(lat_2,-75.33333333333333)(lat_0,-90)(lon_0,171)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3260, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,-168)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3261, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,-144)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3262, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,-120)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3263, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,-96)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3264, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,-72)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3265, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,-48)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3266, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,-24)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3267, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3268, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,24)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3269, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,48)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3270, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,72)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3271, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,96)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3272, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,120)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3273, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,144)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3274, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-90)(lon_0,168)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3275, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,-165)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3276, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,-135)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3277, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,-105)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3278, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,-75)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3279, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,-45)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3280, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,-15)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3281, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,15)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3282, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,45)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3283, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,75)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3284, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,105)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3285, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,135)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3286, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,165)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3287, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,-150)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3288, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,-90)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3289, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,-30)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3290, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,30)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3291, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,90)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3292, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,150)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3293, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-80.23861111111111)(lon_0,0)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3294, srs::dpar::parameters<>(proj_lcc)(lat_1,-76.66666666666667)(lat_2,-79.33333333333333)(lat_0,-78)(lon_0,162)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            //{3295},
            {3296, srs::dpar::parameters<>(proj_utm)(zone,5)(south)(ellps_grs80)(units_m)(no_defs)},
            {3297, srs::dpar::parameters<>(proj_utm)(zone,6)(south)(ellps_grs80)(units_m)(no_defs)},
            {3298, srs::dpar::parameters<>(proj_utm)(zone,7)(south)(ellps_grs80)(units_m)(no_defs)},
            {3299, srs::dpar::parameters<>(proj_utm)(zone,8)(south)(ellps_grs80)(units_m)(no_defs)},
            {3300, srs::dpar::parameters<>(proj_lcc)(lat_1,59.33333333333334)(lat_2,58)(lat_0,57.51755393055556)(lon_0,24)(x_0,500000)(y_0,6375000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014))(units_m)(no_defs)},
            {3301, srs::dpar::parameters<>(proj_lcc)(lat_1,59.33333333333334)(lat_2,58)(lat_0,57.51755393055556)(lon_0,24)(x_0,500000)(y_0,6375000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3302, srs::dpar::parameters<>(proj_utm)(zone,7)(south)(ellps_intl)(units_m)(no_defs)},
            {3303, srs::dpar::parameters<>(proj_utm)(zone,7)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(347.103,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074))(units_m)(no_defs)},
            {3304, srs::dpar::parameters<>(proj_utm)(zone,6)(south)(ellps_intl)(units_m)(no_defs)},
            {3305, srs::dpar::parameters<>(proj_utm)(zone,6)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773))(units_m)(no_defs)},
            {3306, srs::dpar::parameters<>(proj_utm)(zone,5)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(217.037,86.959,23.956,0,0,0,0))(units_m)(no_defs)},
            {3307, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,-0.15,0.68,0,0,0,0))(units_m)(no_defs)},
            {3308, srs::dpar::parameters<>(proj_lcc)(lat_1,-30.75)(lat_2,-35.75)(lat_0,-33.25)(lon_0,147)(x_0,9300000)(y_0,4500000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3309, srs::dpar::parameters<>(proj_aea)(lat_1,34)(lat_2,40.5)(lat_0,0)(lon_0,-120)(x_0,0)(y_0,-4000000)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {3310, srs::dpar::parameters<>(proj_aea)(lat_1,34)(lat_2,40.5)(lat_0,0)(lon_0,-120)(x_0,0)(y_0,-4000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3311, srs::dpar::parameters<>(proj_aea)(lat_1,34)(lat_2,40.5)(lat_0,0)(lon_0,-120)(x_0,0)(y_0,-4000000)(ellps_grs80)(units_m)(no_defs)},
            {3312, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_intl)(towgs84,srs::detail::towgs84<>(-186,230,110,0,0,0,0))(units_m)(no_defs)},
            {3313, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_grs80)(towgs84,srs::detail::towgs84<>(2,2,-2,0,0,0,0))(units_m)(no_defs)},
            {3314, srs::dpar::parameters<>(proj_lcc)(lat_1,-6.5)(lat_2,-11.5)(lat_0,0)(lon_0,26)(x_0,0)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {3315, srs::dpar::parameters<>(proj_tmerc)(lat_0,-9)(lon_0,26)(k,0.9998)(x_0,0)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {3316, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,22)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {3317, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {3318, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,12)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {3319, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,14)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {3320, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,16)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {3321, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {3322, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,20)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {3323, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,22)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {3324, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {3325, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,26)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {3326, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,28)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {3327, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,30)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {3328, srs::dpar::parameters<>(proj_sterea)(lat_0,52.16666666666666)(lon_0,19.16666666666667)(k,0.999714)(x_0,500000)(y_0,500000)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {3329, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,5500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {3330, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18)(k,1)(x_0,6500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {3331, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,7500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {3332, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,1)(x_0,8500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {3333, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,3500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {3334, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,4500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {3335, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,5500000)(y_0,0)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(units_m)(no_defs)},
            {3336, srs::dpar::parameters<>(proj_utm)(zone,42)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(145,-187,103,0,0,0,0))(units_m)(no_defs)},
            {3337, srs::dpar::parameters<>(proj_lcc)(lat_1,-20.19506944444445)(lat_0,-20.19506944444445)(lon_0,57.52182777777778)(k_0,1)(x_0,1000000)(y_0,1000000)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-770.1,158.4,-498.2,0,0,0,0))(units_m)(no_defs)},
            {3338, srs::dpar::parameters<>(proj_aea)(lat_1,55)(lat_2,65)(lat_0,50)(lon_0,-154)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3339, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,12)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-79.9,-158,-168.9,0,0,0,0))(units_m)(no_defs)},
            {3340, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,14)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-79.9,-158,-168.9,0,0,0,0))(units_m)(no_defs)},
            {3341, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,16)(k,0.9999)(x_0,500000)(y_0,10000000)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-79.9,-158,-168.9,0,0,0,0))(units_m)(no_defs)},
            {3342, srs::dpar::parameters<>(proj_utm)(zone,33)(south)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-79.9,-158,-168.9,0,0,0,0))(units_m)(no_defs)},
            {3343, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3344, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3345, srs::dpar::parameters<>(proj_utm)(zone,30)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3346, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,0.9998)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3347, srs::dpar::parameters<>(proj_lcc)(lat_1,49)(lat_2,77)(lat_0,63.390675)(lon_0,-91.86666666666666)(x_0,6200000)(y_0,3000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3348, srs::dpar::parameters<>(proj_lcc)(lat_1,49)(lat_2,77)(lat_0,63.390675)(lon_0,-91.86666666666666)(x_0,6200000)(y_0,3000000)(ellps_grs80)(units_m)(no_defs)},
            {3349, srs::dpar::parameters<>(proj_merc)(lon_0,-150)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3350, srs::dpar::parameters<>(proj_tmerc)(lat_0,0.1)(lon_0,21.95)(k,1)(x_0,250000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {3351, srs::dpar::parameters<>(proj_tmerc)(lat_0,0.1)(lon_0,24.95)(k,1)(x_0,1250000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {3352, srs::dpar::parameters<>(proj_tmerc)(lat_0,0.1)(lon_0,27.95)(k,1)(x_0,2250000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {3353, srs::dpar::parameters<>(proj_utm)(zone,32)(south)(ellps_intl)(units_m)(no_defs)},
            {3354, srs::dpar::parameters<>(proj_utm)(zone,32)(south)(ellps_intl)(units_m)(no_defs)},
            {3355, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,31)(k,1)(x_0,615000)(y_0,810000)(ellps_helmert)(towgs84,srs::detail::towgs84<>(-146.21,112.63,4.05,0,0,0,0))(units_m)(no_defs)},
            {3356, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(67.8,106.1,138.8,0,0,0,0))(units_m)(no_defs)},
            {3357, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_clrk66)(units_m)(no_defs)},
            {3358, srs::dpar::parameters<>(proj_lcc)(lat_1,36.16666666666666)(lat_2,34.33333333333334)(lat_0,33.75)(lon_0,-79)(x_0,609601.22)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3359, srs::dpar::parameters<>(proj_lcc)(lat_1,36.16666666666666)(lat_2,34.33333333333334)(lat_0,33.75)(lon_0,-79)(x_0,609601.2192024385)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {3360, srs::dpar::parameters<>(proj_lcc)(lat_1,34.83333333333334)(lat_2,32.5)(lat_0,31.83333333333333)(lon_0,-81)(x_0,609600)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3361, srs::dpar::parameters<>(proj_lcc)(lat_1,34.83333333333334)(lat_2,32.5)(lat_0,31.83333333333333)(lon_0,-81)(x_0,609600)(y_0,0)(ellps_grs80)(to_meter,0.3048)(no_defs)},
            {3362, srs::dpar::parameters<>(proj_lcc)(lat_1,41.95)(lat_2,40.88333333333333)(lat_0,40.16666666666666)(lon_0,-77.75)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3363, srs::dpar::parameters<>(proj_lcc)(lat_1,41.95)(lat_2,40.88333333333333)(lat_0,40.16666666666666)(lon_0,-77.75)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3364, srs::dpar::parameters<>(proj_lcc)(lat_1,40.96666666666667)(lat_2,39.93333333333333)(lat_0,39.33333333333334)(lon_0,-77.75)(x_0,600000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3365, srs::dpar::parameters<>(proj_lcc)(lat_1,40.96666666666667)(lat_2,39.93333333333333)(lat_0,39.33333333333334)(lon_0,-77.75)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3366, srs::dpar::parameters<>(proj_cass)(lat_0,22.31213333333334)(lon_0,114.1785555555556)(x_0,40243.57775604237)(y_0,19069.93351512578)(a,6378293.645208759)(b,6356617.987679838)(units_m)(no_defs)},
            {3367, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_clrk80)(units_m)(no_defs)},
            {3368, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_clrk80)(units_m)(no_defs)},
            {3369, srs::dpar::parameters<>(proj_utm)(zone,30)(ellps_clrk80)(units_m)(no_defs)},
            {3370, srs::dpar::parameters<>(proj_utm)(zone,59)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {3371, srs::dpar::parameters<>(proj_utm)(zone,60)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {3372, srs::dpar::parameters<>(proj_utm)(zone,59)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3373, srs::dpar::parameters<>(proj_utm)(zone,60)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3374, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_intl)(units_m)(no_defs)},
            {3375, srs::dpar::parameters<>(proj_omerc)(lat_0,4)(lonc,102.25)(alpha,323.0257964666666)(k,0.99984)(x_0,804671)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3376, srs::dpar::parameters<>(proj_omerc)(lat_0,4)(lonc,115)(alpha,53.31580995)(k,0.99984)(x_0,0)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3377, srs::dpar::parameters<>(proj_cass)(lat_0,2.121679744444445)(lon_0,103.4279362361111)(x_0,-14810.562)(y_0,8758.32)(ellps_grs80)(units_m)(no_defs)},
            {3378, srs::dpar::parameters<>(proj_cass)(lat_0,2.682347636111111)(lon_0,101.9749050416667)(x_0,3673.785)(y_0,-4240.573)(ellps_grs80)(units_m)(no_defs)},
            {3379, srs::dpar::parameters<>(proj_cass)(lat_0,3.769388088888889)(lon_0,102.3682989833333)(x_0,-7368.228)(y_0,6485.858)(ellps_grs80)(units_m)(no_defs)},
            {3380, srs::dpar::parameters<>(proj_cass)(lat_0,3.68464905)(lon_0,101.3891079138889)(x_0,-34836.161)(y_0,56464.049)(ellps_grs80)(units_m)(no_defs)},
            {3381, srs::dpar::parameters<>(proj_cass)(lat_0,4.9762852)(lon_0,103.070275625)(x_0,19594.245)(y_0,3371.895)(ellps_grs80)(units_m)(no_defs)},
            {3382, srs::dpar::parameters<>(proj_cass)(lat_0,5.421517541666667)(lon_0,100.3443769638889)(x_0,-23.414)(y_0,62.283)(ellps_grs80)(units_m)(no_defs)},
            {3383, srs::dpar::parameters<>(proj_cass)(lat_0,5.964672713888889)(lon_0,100.6363711111111)(x_0,0)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3384, srs::dpar::parameters<>(proj_cass)(lat_0,4.859063022222222)(lon_0,100.8154105861111)(x_0,-1.769)(y_0,133454.779)(ellps_grs80)(units_m)(no_defs)},
            {3385, srs::dpar::parameters<>(proj_cass)(lat_0,5.972543658333334)(lon_0,102.2952416694444)(x_0,13227.851)(y_0,8739.894)(ellps_grs80)(units_m)(no_defs)},
            {3386, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18)(k,1)(x_0,500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {3387, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,5500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {3388, srs::dpar::parameters<>(proj_merc)(lon_0,51)(k,1)(x_0,0)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {3389, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,180)(k,1)(x_0,60500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {3390, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,180)(k,1)(x_0,60500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {3391, srs::dpar::parameters<>(proj_utm)(zone,37)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(84.1,-320.1,218.7,0,0,0,0))(units_m)(no_defs)},
            {3392, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(84.1,-320.1,218.7,0,0,0,0))(units_m)(no_defs)},
            {3393, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(84.1,-320.1,218.7,0,0,0,0))(units_m)(no_defs)},
            {3394, srs::dpar::parameters<>(proj_lcc)(lat_1,32.5)(lat_0,32.5)(lon_0,45)(k_0,0.9987864078000001)(x_0,1500000)(y_0,1166200)(ellps_clrk80)(units_m)(no_defs)},
            {3395, srs::dpar::parameters<>(proj_merc)(lon_0,0)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3396, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9)(k,1)(x_0,3500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3397, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,12)(k,1)(x_0,4500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3398, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,12)(k,1)(x_0,4500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3399, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,5500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {3400, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-115)(k,0.9992)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3401, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-115)(k,0.9992)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3402, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-115)(k,0.9992)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3403, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-115)(k,0.9992)(x_0,0)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3404, srs::dpar::parameters<>(proj_lcc)(lat_1,36.16666666666666)(lat_2,34.33333333333334)(lat_0,33.75)(lon_0,-79)(x_0,609601.2192024384)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3405, srs::dpar::parameters<>(proj_utm)(zone,48)(ellps_wgs84)(units_m)(no_defs)},
            {3406, srs::dpar::parameters<>(proj_utm)(zone,49)(ellps_wgs84)(units_m)(no_defs)},
            {3407, srs::dpar::parameters<>(proj_cass)(lat_0,22.31213333333334)(lon_0,114.1785555555556)(x_0,40243.57775604237)(y_0,19069.93351512578)(a,6378293.645208759)(b,6356617.987679838)(to_meter,0.3047972654)(no_defs)},
            {3408, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,0)(x_0,0)(y_0,0)(r,6371228)(units_m)(no_defs)},
            {3409, srs::dpar::parameters<>(proj_laea)(lat_0,-90)(lon_0,0)(x_0,0)(y_0,0)(r,6371228)(units_m)(no_defs)},
            {3410, srs::dpar::parameters<>(proj_cea)(lon_0,0)(lat_ts,30)(x_0,0)(y_0,0)(r,6371228)(units_m)(no_defs)},
            {3411, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lat_ts,70)(lon_0,-45)(k,1)(x_0,0)(y_0,0)(a,6378273)(b,6356889.449)(units_m)(no_defs)},
            {3412, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-70)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,6378273)(b,6356889.449)(units_m)(no_defs)},
            {3413, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lat_ts,70)(lon_0,-45)(k,1)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3414, srs::dpar::parameters<>(proj_tmerc)(lat_0,1.366666666666667)(lon_0,103.8333333333333)(k,1)(x_0,28001.642)(y_0,38744.572)(ellps_wgs84)(units_m)(no_defs)},
            {3415, srs::dpar::parameters<>(proj_lcc)(lat_1,18)(lat_2,24)(lat_0,21)(lon_0,114)(x_0,500000)(y_0,500000)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {3416, srs::dpar::parameters<>(proj_lcc)(lat_1,49)(lat_2,46)(lat_0,47.5)(lon_0,13.33333333333333)(x_0,400000)(y_0,400000)(ellps_grs80)(units_m)(no_defs)},
            {3417, srs::dpar::parameters<>(proj_lcc)(lat_1,43.26666666666667)(lat_2,42.06666666666667)(lat_0,41.5)(lon_0,-93.5)(x_0,1500000)(y_0,999999.9999898402)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3418, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.61666666666667)(lat_0,40)(lon_0,-93.5)(x_0,500000.00001016)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3419, srs::dpar::parameters<>(proj_lcc)(lat_1,39.78333333333333)(lat_2,38.71666666666667)(lat_0,38.33333333333334)(lon_0,-98)(x_0,399999.99998984)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3420, srs::dpar::parameters<>(proj_lcc)(lat_1,38.56666666666667)(lat_2,37.26666666666667)(lat_0,36.66666666666666)(lon_0,-98.5)(x_0,399999.99998984)(y_0,399999.99998984)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3421, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-115.5833333333333)(k,0.9999)(x_0,200000.00001016)(y_0,8000000.000010163)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3422, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-116.6666666666667)(k,0.9999)(x_0,500000.00001016)(y_0,6000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3423, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-118.5833333333333)(k,0.9999)(x_0,800000.0000101599)(y_0,3999999.99998984)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3424, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3425, srs::dpar::parameters<>(proj_lcc)(lat_1,43.26666666666667)(lat_2,42.06666666666667)(lat_0,41.5)(lon_0,-93.5)(x_0,1500000)(y_0,999999.9999898402)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3426, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.61666666666667)(lat_0,40)(lon_0,-93.5)(x_0,500000.00001016)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3427, srs::dpar::parameters<>(proj_lcc)(lat_1,39.78333333333333)(lat_2,38.71666666666667)(lat_0,38.33333333333334)(lon_0,-98)(x_0,399999.99998984)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3428, srs::dpar::parameters<>(proj_lcc)(lat_1,38.56666666666667)(lat_2,37.26666666666667)(lat_0,36.66666666666666)(lon_0,-98.5)(x_0,399999.99998984)(y_0,399999.99998984)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3429, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-115.5833333333333)(k,0.9999)(x_0,200000.00001016)(y_0,8000000.000010163)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3430, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-116.6666666666667)(k,0.9999)(x_0,500000.00001016)(y_0,6000000)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3431, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-118.5833333333333)(k,0.9999)(x_0,800000.0000101599)(y_0,3999999.99998984)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3432, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3433, srs::dpar::parameters<>(proj_lcc)(lat_1,36.23333333333333)(lat_2,34.93333333333333)(lat_0,34.33333333333334)(lon_0,-92)(x_0,399999.99998984)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3434, srs::dpar::parameters<>(proj_lcc)(lat_1,34.76666666666667)(lat_2,33.3)(lat_0,32.66666666666666)(lon_0,-92)(x_0,399999.99998984)(y_0,399999.99998984)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3435, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-88.33333333333333)(k,0.9999749999999999)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3436, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-90.16666666666667)(k,0.999941177)(x_0,699999.9999898402)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3437, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-71.66666666666667)(k,0.999966667)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3438, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.08333333333334)(lon_0,-71.5)(k,0.99999375)(x_0,99999.99998983997)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3439, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_clrk80)(units_m)(no_defs)},
            {3440, srs::dpar::parameters<>(proj_utm)(zone,40)(ellps_clrk80)(units_m)(no_defs)},
            {3441, srs::dpar::parameters<>(proj_lcc)(lat_1,36.23333333333333)(lat_2,34.93333333333333)(lat_0,34.33333333333334)(lon_0,-92)(x_0,399999.99998984)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3442, srs::dpar::parameters<>(proj_lcc)(lat_1,34.76666666666667)(lat_2,33.3)(lat_0,32.66666666666666)(lon_0,-92)(x_0,399999.99998984)(y_0,399999.99998984)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3443, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-88.33333333333333)(k,0.9999749999999999)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3444, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-90.16666666666667)(k,0.999941177)(x_0,699999.9999898402)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3445, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-71.66666666666667)(k,0.999966667)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3446, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.08333333333334)(lon_0,-71.5)(k,0.99999375)(x_0,99999.99998983997)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3447, srs::dpar::parameters<>(proj_lcc)(lat_1,49.83333333333334)(lat_2,51.16666666666666)(lat_0,50.797815)(lon_0,4.359215833333333)(x_0,150328)(y_0,166262)(ellps_grs80)(units_m)(no_defs)},
            {3448, srs::dpar::parameters<>(proj_lcc)(lat_1,18)(lat_0,18)(lon_0,-77)(k_0,1)(x_0,750000)(y_0,650000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3449, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3450, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3451, srs::dpar::parameters<>(proj_lcc)(lat_1,32.66666666666666)(lat_2,31.16666666666667)(lat_0,30.5)(lon_0,-92.5)(x_0,999999.9999898402)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3452, srs::dpar::parameters<>(proj_lcc)(lat_1,30.7)(lat_2,29.3)(lat_0,28.5)(lon_0,-91.33333333333333)(x_0,999999.9999898402)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3453, srs::dpar::parameters<>(proj_lcc)(lat_1,27.83333333333333)(lat_2,26.16666666666667)(lat_0,25.5)(lon_0,-91.33333333333333)(x_0,999999.9999898402)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3454, srs::dpar::parameters<>(proj_lcc)(lat_1,44.4)(lat_2,42.83333333333334)(lat_0,42.33333333333334)(lon_0,-100.3333333333333)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3455, srs::dpar::parameters<>(proj_lcc)(lat_1,44.4)(lat_2,42.83333333333334)(lat_0,42.33333333333334)(lon_0,-100.3333333333333)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3456, srs::dpar::parameters<>(proj_lcc)(lat_1,32.66666666666666)(lat_2,31.16666666666667)(lat_0,30.5)(lon_0,-92.5)(x_0,999999.9999898402)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3457, srs::dpar::parameters<>(proj_lcc)(lat_1,30.7)(lat_2,29.3)(lat_0,28.5)(lon_0,-91.33333333333333)(x_0,999999.9999898402)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3458, srs::dpar::parameters<>(proj_lcc)(lat_1,45.68333333333333)(lat_2,44.41666666666666)(lat_0,43.83333333333334)(lon_0,-100)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3459, srs::dpar::parameters<>(proj_lcc)(lat_1,44.4)(lat_2,42.83333333333334)(lat_0,42.33333333333334)(lon_0,-100.3333333333333)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3460, srs::dpar::parameters<>(proj_tmerc)(lat_0,-17)(lon_0,178.75)(k,0.99985)(x_0,2000000)(y_0,4000000)(ellps_wgs72)(units_m)(no_defs)},
            {3461, srs::dpar::parameters<>(proj_utm)(zone,28)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-83,37,124,0,0,0,0))(units_m)(no_defs)},
            {3462, srs::dpar::parameters<>(proj_utm)(zone,29)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-83,37,124,0,0,0,0))(units_m)(no_defs)},
            {3463, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.5)(lon_0,-69.125)(k,0.99998)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3464, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.5)(lon_0,-69.125)(k,0.99998)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3465, srs::dpar::parameters<>(proj_tmerc)(lat_0,30.5)(lon_0,-85.83333333333333)(k,0.99996)(x_0,200000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3466, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-87.5)(k,0.999933333)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3467, srs::dpar::parameters<>(proj_aea)(lat_1,55)(lat_2,65)(lat_0,50)(lon_0,-154)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3468, srs::dpar::parameters<>(proj_omerc)(lat_0,57)(lonc,-133.6666666666667)(alpha,323.1301023611111)(k,0.9999)(x_0,5000000)(y_0,-5000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3469, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-142)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3470, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-146)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3471, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-150)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3472, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-154)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3473, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-158)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3474, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-162)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3475, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-166)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3476, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-170)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3477, srs::dpar::parameters<>(proj_lcc)(lat_1,53.83333333333334)(lat_2,51.83333333333334)(lat_0,51)(lon_0,-176)(x_0,1000000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3478, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-111.9166666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3479, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-111.9166666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3480, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-110.1666666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3481, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-110.1666666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3482, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-113.75)(k,0.999933333)(x_0,213360)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3483, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-113.75)(k,0.999933333)(x_0,213360)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3484, srs::dpar::parameters<>(proj_lcc)(lat_1,36.23333333333333)(lat_2,34.93333333333333)(lat_0,34.33333333333334)(lon_0,-92)(x_0,400000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3485, srs::dpar::parameters<>(proj_lcc)(lat_1,36.23333333333333)(lat_2,34.93333333333333)(lat_0,34.33333333333334)(lon_0,-92)(x_0,399999.99998984)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3486, srs::dpar::parameters<>(proj_lcc)(lat_1,34.76666666666667)(lat_2,33.3)(lat_0,32.66666666666666)(lon_0,-92)(x_0,400000)(y_0,400000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3487, srs::dpar::parameters<>(proj_lcc)(lat_1,34.76666666666667)(lat_2,33.3)(lat_0,32.66666666666666)(lon_0,-92)(x_0,399999.99998984)(y_0,399999.99998984)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3488, srs::dpar::parameters<>(proj_aea)(lat_1,34)(lat_2,40.5)(lat_0,0)(lon_0,-120)(x_0,0)(y_0,-4000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3489, srs::dpar::parameters<>(proj_lcc)(lat_1,41.66666666666666)(lat_2,40)(lat_0,39.33333333333334)(lon_0,-122)(x_0,2000000)(y_0,500000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3490, srs::dpar::parameters<>(proj_lcc)(lat_1,41.66666666666666)(lat_2,40)(lat_0,39.33333333333334)(lon_0,-122)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3491, srs::dpar::parameters<>(proj_lcc)(lat_1,39.83333333333334)(lat_2,38.33333333333334)(lat_0,37.66666666666666)(lon_0,-122)(x_0,2000000)(y_0,500000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3492, srs::dpar::parameters<>(proj_lcc)(lat_1,39.83333333333334)(lat_2,38.33333333333334)(lat_0,37.66666666666666)(lon_0,-122)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3493, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.06666666666667)(lat_0,36.5)(lon_0,-120.5)(x_0,2000000)(y_0,500000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3494, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.06666666666667)(lat_0,36.5)(lon_0,-120.5)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3495, srs::dpar::parameters<>(proj_lcc)(lat_1,37.25)(lat_2,36)(lat_0,35.33333333333334)(lon_0,-119)(x_0,2000000)(y_0,500000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3496, srs::dpar::parameters<>(proj_lcc)(lat_1,37.25)(lat_2,36)(lat_0,35.33333333333334)(lon_0,-119)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3497, srs::dpar::parameters<>(proj_lcc)(lat_1,35.46666666666667)(lat_2,34.03333333333333)(lat_0,33.5)(lon_0,-118)(x_0,2000000)(y_0,500000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3498, srs::dpar::parameters<>(proj_lcc)(lat_1,35.46666666666667)(lat_2,34.03333333333333)(lat_0,33.5)(lon_0,-118)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3499, srs::dpar::parameters<>(proj_lcc)(lat_1,33.88333333333333)(lat_2,32.78333333333333)(lat_0,32.16666666666666)(lon_0,-116.25)(x_0,2000000)(y_0,500000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3500, srs::dpar::parameters<>(proj_lcc)(lat_1,33.88333333333333)(lat_2,32.78333333333333)(lat_0,32.16666666666666)(lon_0,-116.25)(x_0,2000000.0001016)(y_0,500000.0001016001)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3501, srs::dpar::parameters<>(proj_lcc)(lat_1,39.75)(lat_2,38.45)(lat_0,37.83333333333334)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3502, srs::dpar::parameters<>(proj_lcc)(lat_1,39.75)(lat_2,38.45)(lat_0,37.83333333333334)(lon_0,-105.5)(x_0,914401.8288036576)(y_0,304800.6096012192)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3503, srs::dpar::parameters<>(proj_lcc)(lat_1,40.78333333333333)(lat_2,39.71666666666667)(lat_0,39.33333333333334)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3504, srs::dpar::parameters<>(proj_lcc)(lat_1,40.78333333333333)(lat_2,39.71666666666667)(lat_0,39.33333333333334)(lon_0,-105.5)(x_0,914401.8288036576)(y_0,304800.6096012192)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3505, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.23333333333333)(lat_0,36.66666666666666)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3506, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.23333333333333)(lat_0,36.66666666666666)(lon_0,-105.5)(x_0,914401.8288036576)(y_0,304800.6096012192)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3507, srs::dpar::parameters<>(proj_lcc)(lat_1,41.86666666666667)(lat_2,41.2)(lat_0,40.83333333333334)(lon_0,-72.75)(x_0,304800.6096)(y_0,152400.3048)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3508, srs::dpar::parameters<>(proj_lcc)(lat_1,41.86666666666667)(lat_2,41.2)(lat_0,40.83333333333334)(lon_0,-72.75)(x_0,304800.6096012192)(y_0,152400.3048006096)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3509, srs::dpar::parameters<>(proj_tmerc)(lat_0,38)(lon_0,-75.41666666666667)(k,0.999995)(x_0,200000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3510, srs::dpar::parameters<>(proj_tmerc)(lat_0,38)(lon_0,-75.41666666666667)(k,0.999995)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3511, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-81)(k,0.999941177)(x_0,200000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3512, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-81)(k,0.999941177)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3513, srs::dpar::parameters<>(proj_aea)(lat_1,24)(lat_2,31.5)(lat_0,24)(lon_0,-84)(x_0,400000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3514, srs::dpar::parameters<>(proj_lcc)(lat_1,30.75)(lat_2,29.58333333333333)(lat_0,29)(lon_0,-84.5)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3515, srs::dpar::parameters<>(proj_lcc)(lat_1,30.75)(lat_2,29.58333333333333)(lat_0,29)(lon_0,-84.5)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3516, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-82)(k,0.999941177)(x_0,200000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3517, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-82)(k,0.999941177)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3518, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-82.16666666666667)(k,0.9999)(x_0,200000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3519, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-82.16666666666667)(k,0.9999)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3520, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-84.16666666666667)(k,0.9999)(x_0,700000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3521, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-84.16666666666667)(k,0.9999)(x_0,699999.9998983998)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3522, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-114)(k,0.9999473679999999)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3523, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-114)(k,0.9999473679999999)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3524, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-112.1666666666667)(k,0.9999473679999999)(x_0,200000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3525, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-112.1666666666667)(k,0.9999473679999999)(x_0,200000.0001016002)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3526, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-115.75)(k,0.999933333)(x_0,800000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3527, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-115.75)(k,0.999933333)(x_0,800000.0001016001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3528, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-88.33333333333333)(k,0.9999749999999999)(x_0,300000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3529, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-88.33333333333333)(k,0.9999749999999999)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3530, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-90.16666666666667)(k,0.999941177)(x_0,700000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3531, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-90.16666666666667)(k,0.999941177)(x_0,699999.9999898402)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3532, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-85.66666666666667)(k,0.999966667)(x_0,100000)(y_0,250000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3533, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-85.66666666666667)(k,0.999966667)(x_0,99999.99989839978)(y_0,249999.9998983998)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3534, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-87.08333333333333)(k,0.999966667)(x_0,900000)(y_0,250000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3535, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-87.08333333333333)(k,0.999966667)(x_0,900000)(y_0,249999.9998983998)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3536, srs::dpar::parameters<>(proj_lcc)(lat_1,43.26666666666667)(lat_2,42.06666666666667)(lat_0,41.5)(lon_0,-93.5)(x_0,1500000)(y_0,1000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3537, srs::dpar::parameters<>(proj_lcc)(lat_1,43.26666666666667)(lat_2,42.06666666666667)(lat_0,41.5)(lon_0,-93.5)(x_0,1500000)(y_0,999999.9999898402)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3538, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.61666666666667)(lat_0,40)(lon_0,-93.5)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3539, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.61666666666667)(lat_0,40)(lon_0,-93.5)(x_0,500000.00001016)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3540, srs::dpar::parameters<>(proj_lcc)(lat_1,39.78333333333333)(lat_2,38.71666666666667)(lat_0,38.33333333333334)(lon_0,-98)(x_0,400000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3541, srs::dpar::parameters<>(proj_lcc)(lat_1,39.78333333333333)(lat_2,38.71666666666667)(lat_0,38.33333333333334)(lon_0,-98)(x_0,399999.99998984)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3542, srs::dpar::parameters<>(proj_lcc)(lat_1,38.56666666666667)(lat_2,37.26666666666667)(lat_0,36.66666666666666)(lon_0,-98.5)(x_0,400000)(y_0,400000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3543, srs::dpar::parameters<>(proj_lcc)(lat_1,38.56666666666667)(lat_2,37.26666666666667)(lat_0,36.66666666666666)(lon_0,-98.5)(x_0,399999.99998984)(y_0,399999.99998984)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3544, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,38.96666666666667)(lat_0,37.5)(lon_0,-84.25)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3545, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,38.96666666666667)(lat_0,37.5)(lon_0,-84.25)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3546, srs::dpar::parameters<>(proj_lcc)(lat_1,37.08333333333334)(lat_2,38.66666666666666)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,1500000)(y_0,1000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3547, srs::dpar::parameters<>(proj_lcc)(lat_1,37.08333333333334)(lat_2,38.66666666666666)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,1500000)(y_0,999999.9998983998)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3548, srs::dpar::parameters<>(proj_lcc)(lat_1,37.93333333333333)(lat_2,36.73333333333333)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,500000)(y_0,500000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3549, srs::dpar::parameters<>(proj_lcc)(lat_1,37.93333333333333)(lat_2,36.73333333333333)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,500000.0001016001)(y_0,500000.0001016001)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3550, srs::dpar::parameters<>(proj_lcc)(lat_1,32.66666666666666)(lat_2,31.16666666666667)(lat_0,30.5)(lon_0,-92.5)(x_0,1000000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3551, srs::dpar::parameters<>(proj_lcc)(lat_1,32.66666666666666)(lat_2,31.16666666666667)(lat_0,30.5)(lon_0,-92.5)(x_0,999999.9999898402)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3552, srs::dpar::parameters<>(proj_lcc)(lat_1,30.7)(lat_2,29.3)(lat_0,28.5)(lon_0,-91.33333333333333)(x_0,1000000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3553, srs::dpar::parameters<>(proj_lcc)(lat_1,30.7)(lat_2,29.3)(lat_0,28.5)(lon_0,-91.33333333333333)(x_0,999999.9999898402)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3554, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.5)(lon_0,-69.125)(k,0.99998)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3555, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.83333333333334)(lon_0,-67.875)(k,0.99998)(x_0,700000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3556, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.375)(k,0.99998)(x_0,300000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3557, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.66666666666666)(lon_0,-68.5)(k,0.9999)(x_0,300000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3558, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.16666666666667)(k,0.999966667)(x_0,900000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3559, srs::dpar::parameters<>(proj_lcc)(lat_1,39.45)(lat_2,38.3)(lat_0,37.66666666666666)(lon_0,-77)(x_0,400000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3560, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.71666666666667)(lat_0,40.33333333333334)(lon_0,-111.5)(x_0,500000.00001016)(y_0,999999.9999898402)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3561, srs::dpar::parameters<>(proj_tmerc)(lat_0,18.83333333333333)(lon_0,-155.5)(k,0.999966667)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(to_meter,0.3048006096012192)(no_defs)},
            {3562, srs::dpar::parameters<>(proj_tmerc)(lat_0,20.33333333333333)(lon_0,-156.6666666666667)(k,0.999966667)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(to_meter,0.3048006096012192)(no_defs)},
            {3563, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.16666666666667)(lon_0,-158)(k,0.99999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(to_meter,0.3048006096012192)(no_defs)},
            {3564, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.83333333333333)(lon_0,-159.5)(k,0.99999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(to_meter,0.3048006096012192)(no_defs)},
            {3565, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.66666666666667)(lon_0,-160.1666666666667)(k,1)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(to_meter,0.3048006096012192)(no_defs)},
            {3566, srs::dpar::parameters<>(proj_lcc)(lat_1,40.65)(lat_2,39.01666666666667)(lat_0,38.33333333333334)(lon_0,-111.5)(x_0,500000.00001016)(y_0,2000000.00001016)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3567, srs::dpar::parameters<>(proj_lcc)(lat_1,38.35)(lat_2,37.21666666666667)(lat_0,36.66666666666666)(lon_0,-111.5)(x_0,500000.00001016)(y_0,3000000)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3568, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.71666666666667)(lat_0,40.33333333333334)(lon_0,-111.5)(x_0,500000.00001016)(y_0,999999.9999898402)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3569, srs::dpar::parameters<>(proj_lcc)(lat_1,40.65)(lat_2,39.01666666666667)(lat_0,38.33333333333334)(lon_0,-111.5)(x_0,500000.00001016)(y_0,2000000.00001016)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3570, srs::dpar::parameters<>(proj_lcc)(lat_1,38.35)(lat_2,37.21666666666667)(lat_0,36.66666666666666)(lon_0,-111.5)(x_0,500000.00001016)(y_0,3000000)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3571, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,180)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3572, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,-150)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3573, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,-100)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3574, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,-40)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3575, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,10)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3576, srs::dpar::parameters<>(proj_laea)(lat_0,90)(lon_0,90)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3577, srs::dpar::parameters<>(proj_aea)(lat_1,-18)(lat_2,-36)(lat_0,0)(lon_0,132)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3578, srs::dpar::parameters<>(proj_aea)(lat_1,61.66666666666666)(lat_2,68)(lat_0,59)(lon_0,-132.5)(x_0,500000)(y_0,500000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3579, srs::dpar::parameters<>(proj_aea)(lat_1,61.66666666666666)(lat_2,68)(lat_0,59)(lon_0,-132.5)(x_0,500000)(y_0,500000)(ellps_grs80)(units_m)(no_defs)},
            {3580, srs::dpar::parameters<>(proj_lcc)(lat_1,62)(lat_2,70)(lat_0,0)(lon_0,-112)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3581, srs::dpar::parameters<>(proj_lcc)(lat_1,62)(lat_2,70)(lat_0,0)(lon_0,-112)(x_0,0)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3582, srs::dpar::parameters<>(proj_lcc)(lat_1,39.45)(lat_2,38.3)(lat_0,37.66666666666666)(lon_0,-77)(x_0,399999.9998983998)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3583, srs::dpar::parameters<>(proj_lcc)(lat_1,41.48333333333333)(lat_2,41.28333333333333)(lat_0,41)(lon_0,-70.5)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3584, srs::dpar::parameters<>(proj_lcc)(lat_1,41.48333333333333)(lat_2,41.28333333333333)(lat_0,41)(lon_0,-70.5)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3585, srs::dpar::parameters<>(proj_lcc)(lat_1,42.68333333333333)(lat_2,41.71666666666667)(lat_0,41)(lon_0,-71.5)(x_0,200000)(y_0,750000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3586, srs::dpar::parameters<>(proj_lcc)(lat_1,42.68333333333333)(lat_2,41.71666666666667)(lat_0,41)(lon_0,-71.5)(x_0,200000.0001016002)(y_0,750000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3587, srs::dpar::parameters<>(proj_webmerc)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3588, srs::dpar::parameters<>(proj_lcc)(lat_1,45.7)(lat_2,44.18333333333333)(lat_0,43.31666666666667)(lon_0,-84.36666666666666)(x_0,5999999.999976001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3589, srs::dpar::parameters<>(proj_lcc)(lat_1,47.08333333333334)(lat_2,45.48333333333333)(lat_0,44.78333333333333)(lon_0,-87)(x_0,8000000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3590, srs::dpar::parameters<>(proj_lcc)(lat_1,47.08333333333334)(lat_2,45.48333333333333)(lat_0,44.78333333333333)(lon_0,-87)(x_0,7999999.999968001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3591, srs::dpar::parameters<>(proj_omerc)(lat_0,45.30916666666666)(lonc,-86)(alpha,337.25556)(k,0.9996)(x_0,2546731.496)(y_0,-4354009.816)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3592, srs::dpar::parameters<>(proj_lcc)(lat_1,43.66666666666666)(lat_2,42.1)(lat_0,41.5)(lon_0,-84.36666666666666)(x_0,4000000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3593, srs::dpar::parameters<>(proj_lcc)(lat_1,43.66666666666666)(lat_2,42.1)(lat_0,41.5)(lon_0,-84.36666666666666)(x_0,3999999.999984)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3594, srs::dpar::parameters<>(proj_lcc)(lat_1,47.05)(lat_2,45.61666666666667)(lat_0,45)(lon_0,-94.25)(x_0,800000)(y_0,100000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3595, srs::dpar::parameters<>(proj_lcc)(lat_1,48.63333333333333)(lat_2,47.03333333333333)(lat_0,46.5)(lon_0,-93.09999999999999)(x_0,800000)(y_0,100000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3596, srs::dpar::parameters<>(proj_lcc)(lat_1,45.21666666666667)(lat_2,43.78333333333333)(lat_0,43)(lon_0,-94)(x_0,800000)(y_0,100000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3597, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-88.83333333333333)(k,0.99995)(x_0,300000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3598, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-88.83333333333333)(k,0.99995)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3599, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-90.33333333333333)(k,0.99995)(x_0,700000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3600, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-90.33333333333333)(k,0.99995)(x_0,699999.9998983998)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3601, srs::dpar::parameters<>(proj_tmerc)(lat_0,35.83333333333334)(lon_0,-92.5)(k,0.999933333)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3602, srs::dpar::parameters<>(proj_tmerc)(lat_0,35.83333333333334)(lon_0,-90.5)(k,0.999933333)(x_0,250000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3603, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.16666666666666)(lon_0,-94.5)(k,0.999941177)(x_0,850000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3604, srs::dpar::parameters<>(proj_lcc)(lat_1,49)(lat_2,45)(lat_0,44.25)(lon_0,-109.5)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3605, srs::dpar::parameters<>(proj_lcc)(lat_1,49)(lat_2,45)(lat_0,44.25)(lon_0,-109.5)(x_0,599999.9999976)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3606, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,40)(lat_0,39.83333333333334)(lon_0,-100)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3607, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-116.6666666666667)(k,0.9999)(x_0,500000)(y_0,6000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3608, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-116.6666666666667)(k,0.9999)(x_0,500000.00001016)(y_0,6000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3609, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-115.5833333333333)(k,0.9999)(x_0,200000)(y_0,8000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3610, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-115.5833333333333)(k,0.9999)(x_0,200000.00001016)(y_0,8000000.000010163)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3611, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-118.5833333333333)(k,0.9999)(x_0,800000)(y_0,4000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3612, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-118.5833333333333)(k,0.9999)(x_0,800000.0000101599)(y_0,3999999.99998984)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3613, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-71.66666666666667)(k,0.999966667)(x_0,300000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3614, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-71.66666666666667)(k,0.999966667)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3615, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3616, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3617, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-106.25)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3618, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-106.25)(k,0.9999)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3619, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-104.3333333333333)(k,0.999909091)(x_0,165000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3620, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-104.3333333333333)(k,0.999909091)(x_0,165000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3621, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-107.8333333333333)(k,0.999916667)(x_0,830000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3622, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-107.8333333333333)(k,0.999916667)(x_0,830000.0001016001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3623, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-76.58333333333333)(k,0.9999375)(x_0,250000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3624, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-76.58333333333333)(k,0.9999375)(x_0,249999.9998983998)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3625, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3626, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3627, srs::dpar::parameters<>(proj_lcc)(lat_1,41.03333333333333)(lat_2,40.66666666666666)(lat_0,40.16666666666666)(lon_0,-74)(x_0,300000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3628, srs::dpar::parameters<>(proj_lcc)(lat_1,41.03333333333333)(lat_2,40.66666666666666)(lat_0,40.16666666666666)(lon_0,-74)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3629, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-78.58333333333333)(k,0.9999375)(x_0,350000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3630, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-78.58333333333333)(k,0.9999375)(x_0,350000.0001016001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3631, srs::dpar::parameters<>(proj_lcc)(lat_1,36.16666666666666)(lat_2,34.33333333333334)(lat_0,33.75)(lon_0,-79)(x_0,609601.22)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3632, srs::dpar::parameters<>(proj_lcc)(lat_1,36.16666666666666)(lat_2,34.33333333333334)(lat_0,33.75)(lon_0,-79)(x_0,609601.2192024384)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3633, srs::dpar::parameters<>(proj_lcc)(lat_1,48.73333333333333)(lat_2,47.43333333333333)(lat_0,47)(lon_0,-100.5)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3634, srs::dpar::parameters<>(proj_lcc)(lat_1,48.73333333333333)(lat_2,47.43333333333333)(lat_0,47)(lon_0,-100.5)(x_0,599999.9999976)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3635, srs::dpar::parameters<>(proj_lcc)(lat_1,47.48333333333333)(lat_2,46.18333333333333)(lat_0,45.66666666666666)(lon_0,-100.5)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3636, srs::dpar::parameters<>(proj_lcc)(lat_1,47.48333333333333)(lat_2,46.18333333333333)(lat_0,45.66666666666666)(lon_0,-100.5)(x_0,599999.9999976)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3637, srs::dpar::parameters<>(proj_lcc)(lat_1,41.7)(lat_2,40.43333333333333)(lat_0,39.66666666666666)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3638, srs::dpar::parameters<>(proj_lcc)(lat_1,40.03333333333333)(lat_2,38.73333333333333)(lat_0,38)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3639, srs::dpar::parameters<>(proj_lcc)(lat_1,36.76666666666667)(lat_2,35.56666666666667)(lat_0,35)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3640, srs::dpar::parameters<>(proj_lcc)(lat_1,36.76666666666667)(lat_2,35.56666666666667)(lat_0,35)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3641, srs::dpar::parameters<>(proj_lcc)(lat_1,35.23333333333333)(lat_2,33.93333333333333)(lat_0,33.33333333333334)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3642, srs::dpar::parameters<>(proj_lcc)(lat_1,35.23333333333333)(lat_2,33.93333333333333)(lat_0,33.33333333333334)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3643, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,45.5)(lat_0,41.75)(lon_0,-120.5)(x_0,400000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3644, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,45.5)(lat_0,41.75)(lon_0,-120.5)(x_0,399999.9999984)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3645, srs::dpar::parameters<>(proj_lcc)(lat_1,46)(lat_2,44.33333333333334)(lat_0,43.66666666666666)(lon_0,-120.5)(x_0,2500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3646, srs::dpar::parameters<>(proj_lcc)(lat_1,46)(lat_2,44.33333333333334)(lat_0,43.66666666666666)(lon_0,-120.5)(x_0,2500000.0001424)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3647, srs::dpar::parameters<>(proj_lcc)(lat_1,44)(lat_2,42.33333333333334)(lat_0,41.66666666666666)(lon_0,-120.5)(x_0,1500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3648, srs::dpar::parameters<>(proj_lcc)(lat_1,44)(lat_2,42.33333333333334)(lat_0,41.66666666666666)(lon_0,-120.5)(x_0,1500000.0001464)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3649, srs::dpar::parameters<>(proj_lcc)(lat_1,41.95)(lat_2,40.88333333333333)(lat_0,40.16666666666666)(lon_0,-77.75)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3650, srs::dpar::parameters<>(proj_lcc)(lat_1,41.95)(lat_2,40.88333333333333)(lat_0,40.16666666666666)(lon_0,-77.75)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3651, srs::dpar::parameters<>(proj_lcc)(lat_1,40.96666666666667)(lat_2,39.93333333333333)(lat_0,39.33333333333334)(lon_0,-77.75)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3652, srs::dpar::parameters<>(proj_lcc)(lat_1,40.96666666666667)(lat_2,39.93333333333333)(lat_0,39.33333333333334)(lon_0,-77.75)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3653, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.08333333333334)(lon_0,-71.5)(k,0.99999375)(x_0,100000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3654, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.08333333333334)(lon_0,-71.5)(k,0.99999375)(x_0,99999.99998983997)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3655, srs::dpar::parameters<>(proj_lcc)(lat_1,34.83333333333334)(lat_2,32.5)(lat_0,31.83333333333333)(lon_0,-81)(x_0,609600)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3656, srs::dpar::parameters<>(proj_lcc)(lat_1,34.83333333333334)(lat_2,32.5)(lat_0,31.83333333333333)(lon_0,-81)(x_0,609600)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3657, srs::dpar::parameters<>(proj_lcc)(lat_1,45.68333333333333)(lat_2,44.41666666666666)(lat_0,43.83333333333334)(lon_0,-100)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3658, srs::dpar::parameters<>(proj_lcc)(lat_1,45.68333333333333)(lat_2,44.41666666666666)(lat_0,43.83333333333334)(lon_0,-100)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3659, srs::dpar::parameters<>(proj_lcc)(lat_1,44.4)(lat_2,42.83333333333334)(lat_0,42.33333333333334)(lon_0,-100.3333333333333)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3660, srs::dpar::parameters<>(proj_lcc)(lat_1,44.4)(lat_2,42.83333333333334)(lat_0,42.33333333333334)(lon_0,-100.3333333333333)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3661, srs::dpar::parameters<>(proj_lcc)(lat_1,36.41666666666666)(lat_2,35.25)(lat_0,34.33333333333334)(lon_0,-86)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3662, srs::dpar::parameters<>(proj_lcc)(lat_1,36.41666666666666)(lat_2,35.25)(lat_0,34.33333333333334)(lon_0,-86)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3663, srs::dpar::parameters<>(proj_lcc)(lat_1,31.88333333333333)(lat_2,30.11666666666667)(lat_0,29.66666666666667)(lon_0,-100.3333333333333)(x_0,700000)(y_0,3000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3664, srs::dpar::parameters<>(proj_lcc)(lat_1,31.88333333333333)(lat_2,30.11666666666667)(lat_0,29.66666666666667)(lon_0,-100.3333333333333)(x_0,699999.9998983998)(y_0,3000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3665, srs::dpar::parameters<>(proj_aea)(lat_1,27.5)(lat_2,35)(lat_0,18)(lon_0,-100)(x_0,1500000)(y_0,6000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3666, srs::dpar::parameters<>(proj_lcc)(lat_1,27.5)(lat_2,35)(lat_0,18)(lon_0,-100)(x_0,1500000)(y_0,5000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3667, srs::dpar::parameters<>(proj_lcc)(lat_1,36.18333333333333)(lat_2,34.65)(lat_0,34)(lon_0,-101.5)(x_0,200000)(y_0,1000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3668, srs::dpar::parameters<>(proj_lcc)(lat_1,36.18333333333333)(lat_2,34.65)(lat_0,34)(lon_0,-101.5)(x_0,200000.0001016002)(y_0,999999.9998983998)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3669, srs::dpar::parameters<>(proj_lcc)(lat_1,33.96666666666667)(lat_2,32.13333333333333)(lat_0,31.66666666666667)(lon_0,-98.5)(x_0,600000)(y_0,2000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3670, srs::dpar::parameters<>(proj_lcc)(lat_1,33.96666666666667)(lat_2,32.13333333333333)(lat_0,31.66666666666667)(lon_0,-98.5)(x_0,600000)(y_0,2000000.0001016)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3671, srs::dpar::parameters<>(proj_lcc)(lat_1,27.83333333333333)(lat_2,26.16666666666667)(lat_0,25.66666666666667)(lon_0,-98.5)(x_0,300000)(y_0,5000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3672, srs::dpar::parameters<>(proj_lcc)(lat_1,27.83333333333333)(lat_2,26.16666666666667)(lat_0,25.66666666666667)(lon_0,-98.5)(x_0,300000.0000000001)(y_0,5000000.0001016)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3673, srs::dpar::parameters<>(proj_lcc)(lat_1,30.28333333333333)(lat_2,28.38333333333333)(lat_0,27.83333333333333)(lon_0,-99)(x_0,600000)(y_0,4000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3674, srs::dpar::parameters<>(proj_lcc)(lat_1,30.28333333333333)(lat_2,28.38333333333333)(lat_0,27.83333333333333)(lon_0,-99)(x_0,600000)(y_0,3999999.9998984)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3675, srs::dpar::parameters<>(proj_lcc)(lat_1,40.65)(lat_2,39.01666666666667)(lat_0,38.33333333333334)(lon_0,-111.5)(x_0,500000)(y_0,2000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3676, srs::dpar::parameters<>(proj_lcc)(lat_1,40.65)(lat_2,39.01666666666667)(lat_0,38.33333333333334)(lon_0,-111.5)(x_0,500000.0001504)(y_0,1999999.999992)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3677, srs::dpar::parameters<>(proj_lcc)(lat_1,40.65)(lat_2,39.01666666666667)(lat_0,38.33333333333334)(lon_0,-111.5)(x_0,500000.00001016)(y_0,2000000.00001016)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3678, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.71666666666667)(lat_0,40.33333333333334)(lon_0,-111.5)(x_0,500000)(y_0,1000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3679, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.71666666666667)(lat_0,40.33333333333334)(lon_0,-111.5)(x_0,500000.0001504)(y_0,999999.9999960001)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3680, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.71666666666667)(lat_0,40.33333333333334)(lon_0,-111.5)(x_0,500000.00001016)(y_0,999999.9999898402)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3681, srs::dpar::parameters<>(proj_lcc)(lat_1,38.35)(lat_2,37.21666666666667)(lat_0,36.66666666666666)(lon_0,-111.5)(x_0,500000)(y_0,3000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3682, srs::dpar::parameters<>(proj_lcc)(lat_1,38.35)(lat_2,37.21666666666667)(lat_0,36.66666666666666)(lon_0,-111.5)(x_0,500000.0001504)(y_0,2999999.999988)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048)(no_defs)},
            {3683, srs::dpar::parameters<>(proj_lcc)(lat_1,38.35)(lat_2,37.21666666666667)(lat_0,36.66666666666666)(lon_0,-111.5)(x_0,500000.00001016)(y_0,3000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3684, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-72.5)(k,0.999964286)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3685, srs::dpar::parameters<>(proj_lcc)(lat_1,39.2)(lat_2,38.03333333333333)(lat_0,37.66666666666666)(lon_0,-78.5)(x_0,3500000)(y_0,2000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3686, srs::dpar::parameters<>(proj_lcc)(lat_1,39.2)(lat_2,38.03333333333333)(lat_0,37.66666666666666)(lon_0,-78.5)(x_0,3500000.0001016)(y_0,2000000.0001016)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3687, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,36.76666666666667)(lat_0,36.33333333333334)(lon_0,-78.5)(x_0,3500000)(y_0,1000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3688, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,36.76666666666667)(lat_0,36.33333333333334)(lon_0,-78.5)(x_0,3500000.0001016)(y_0,999999.9998983998)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3689, srs::dpar::parameters<>(proj_lcc)(lat_1,48.73333333333333)(lat_2,47.5)(lat_0,47)(lon_0,-120.8333333333333)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3690, srs::dpar::parameters<>(proj_lcc)(lat_1,48.73333333333333)(lat_2,47.5)(lat_0,47)(lon_0,-120.8333333333333)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3691, srs::dpar::parameters<>(proj_lcc)(lat_1,47.33333333333334)(lat_2,45.83333333333334)(lat_0,45.33333333333334)(lon_0,-120.5)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3692, srs::dpar::parameters<>(proj_lcc)(lat_1,47.33333333333334)(lat_2,45.83333333333334)(lat_0,45.33333333333334)(lon_0,-120.5)(x_0,500000.0001016001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3693, srs::dpar::parameters<>(proj_lcc)(lat_1,40.25)(lat_2,39)(lat_0,38.5)(lon_0,-79.5)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3694, srs::dpar::parameters<>(proj_lcc)(lat_1,38.88333333333333)(lat_2,37.48333333333333)(lat_0,37)(lon_0,-81)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3695, srs::dpar::parameters<>(proj_lcc)(lat_1,45.5)(lat_2,44.25)(lat_0,43.83333333333334)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3696, srs::dpar::parameters<>(proj_lcc)(lat_1,45.5)(lat_2,44.25)(lat_0,43.83333333333334)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3697, srs::dpar::parameters<>(proj_lcc)(lat_1,46.76666666666667)(lat_2,45.56666666666667)(lat_0,45.16666666666666)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3698, srs::dpar::parameters<>(proj_lcc)(lat_1,46.76666666666667)(lat_2,45.56666666666667)(lat_0,45.16666666666666)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3699, srs::dpar::parameters<>(proj_lcc)(lat_1,44.06666666666667)(lat_2,42.73333333333333)(lat_0,42)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3700, srs::dpar::parameters<>(proj_lcc)(lat_1,44.06666666666667)(lat_2,42.73333333333333)(lat_0,42)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3701, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-90)(k,0.9996)(x_0,520000)(y_0,-4480000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3702, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-105.1666666666667)(k,0.9999375)(x_0,200000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3703, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-107.3333333333333)(k,0.9999375)(x_0,400000)(y_0,100000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3704, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-108.75)(k,0.9999375)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3705, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-110.0833333333333)(k,0.9999375)(x_0,800000)(y_0,100000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3706, srs::dpar::parameters<>(proj_utm)(zone,59)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3707, srs::dpar::parameters<>(proj_utm)(zone,60)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3708, srs::dpar::parameters<>(proj_utm)(zone,1)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3709, srs::dpar::parameters<>(proj_utm)(zone,2)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3710, srs::dpar::parameters<>(proj_utm)(zone,3)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3711, srs::dpar::parameters<>(proj_utm)(zone,4)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3712, srs::dpar::parameters<>(proj_utm)(zone,5)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3713, srs::dpar::parameters<>(proj_utm)(zone,6)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3714, srs::dpar::parameters<>(proj_utm)(zone,7)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3715, srs::dpar::parameters<>(proj_utm)(zone,8)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3716, srs::dpar::parameters<>(proj_utm)(zone,9)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3717, srs::dpar::parameters<>(proj_utm)(zone,10)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3718, srs::dpar::parameters<>(proj_utm)(zone,11)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3719, srs::dpar::parameters<>(proj_utm)(zone,12)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3720, srs::dpar::parameters<>(proj_utm)(zone,13)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3721, srs::dpar::parameters<>(proj_utm)(zone,14)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3722, srs::dpar::parameters<>(proj_utm)(zone,15)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3723, srs::dpar::parameters<>(proj_utm)(zone,16)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3724, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3725, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3726, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3727, srs::dpar::parameters<>(proj_tmerc)(lat_0,-21.11666666666667)(lon_0,55.53333333333333)(k,1)(x_0,160000)(y_0,50000)(ellps_intl)(units_m)(no_defs)},
            {3728, srs::dpar::parameters<>(proj_lcc)(lat_1,41.7)(lat_2,40.43333333333333)(lat_0,39.66666666666666)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3729, srs::dpar::parameters<>(proj_lcc)(lat_1,40.03333333333333)(lat_2,38.73333333333333)(lat_0,38)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3730, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-105.1666666666667)(k,0.9999375)(x_0,200000.00001016)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3731, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-107.3333333333333)(k,0.9999375)(x_0,399999.99998984)(y_0,99999.99998983997)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3732, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-108.75)(k,0.9999375)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3733, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-110.0833333333333)(k,0.9999375)(x_0,800000.0000101599)(y_0,99999.99998983997)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3734, srs::dpar::parameters<>(proj_lcc)(lat_1,41.7)(lat_2,40.43333333333333)(lat_0,39.66666666666666)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3735, srs::dpar::parameters<>(proj_lcc)(lat_1,40.03333333333333)(lat_2,38.73333333333333)(lat_0,38)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3736, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-105.1666666666667)(k,0.9999375)(x_0,200000.00001016)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3737, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-107.3333333333333)(k,0.9999375)(x_0,399999.99998984)(y_0,99999.99998983997)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3738, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-108.75)(k,0.9999375)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3739, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-110.0833333333333)(k,0.9999375)(x_0,800000.0000101599)(y_0,99999.99998983997)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3740, srs::dpar::parameters<>(proj_utm)(zone,10)(ellps_grs80)(units_m)(no_defs)},
            {3741, srs::dpar::parameters<>(proj_utm)(zone,11)(ellps_grs80)(units_m)(no_defs)},
            {3742, srs::dpar::parameters<>(proj_utm)(zone,12)(ellps_grs80)(units_m)(no_defs)},
            {3743, srs::dpar::parameters<>(proj_utm)(zone,13)(ellps_grs80)(units_m)(no_defs)},
            {3744, srs::dpar::parameters<>(proj_utm)(zone,14)(ellps_grs80)(units_m)(no_defs)},
            {3745, srs::dpar::parameters<>(proj_utm)(zone,15)(ellps_grs80)(units_m)(no_defs)},
            {3746, srs::dpar::parameters<>(proj_utm)(zone,16)(ellps_grs80)(units_m)(no_defs)},
            {3747, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_grs80)(units_m)(no_defs)},
            {3748, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_grs80)(units_m)(no_defs)},
            {3749, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_grs80)(units_m)(no_defs)},
            {3750, srs::dpar::parameters<>(proj_utm)(zone,4)(ellps_grs80)(units_m)(no_defs)},
            {3751, srs::dpar::parameters<>(proj_utm)(zone,5)(ellps_grs80)(units_m)(no_defs)},
            {3752, srs::dpar::parameters<>(proj_merc)(lon_0,100)(lat_ts,-41)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3753, srs::dpar::parameters<>(proj_lcc)(lat_1,41.7)(lat_2,40.43333333333333)(lat_0,39.66666666666666)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3754, srs::dpar::parameters<>(proj_lcc)(lat_1,40.03333333333333)(lat_2,38.73333333333333)(lat_0,38)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3755, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-105.1666666666667)(k,0.9999375)(x_0,200000.00001016)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3756, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-107.3333333333333)(k,0.9999375)(x_0,399999.99998984)(y_0,99999.99998983997)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3757, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-108.75)(k,0.9999375)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3758, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-110.0833333333333)(k,0.9999375)(x_0,800000.0000101599)(y_0,99999.99998983997)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3759, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.16666666666667)(lon_0,-158)(k,0.99999)(x_0,500000.00001016)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {3760, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.16666666666667)(lon_0,-158)(k,0.99999)(x_0,500000.00001016)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {3761, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_grs80)(units_m)(no_defs)},
            {3762, srs::dpar::parameters<>(proj_lcc)(lat_1,-54)(lat_2,-54.75)(lat_0,-55)(lon_0,-37)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3763, srs::dpar::parameters<>(proj_tmerc)(lat_0,39.66825833333333)(lon_0,-8.133108333333334)(k,1)(x_0,0)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3764, srs::dpar::parameters<>(proj_tmerc)(lat_0,-44)(lon_0,-176.5)(k,1)(x_0,400000)(y_0,800000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3765, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,16.5)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3766, srs::dpar::parameters<>(proj_lcc)(lat_1,45.91666666666666)(lat_2,43.08333333333334)(lat_0,0)(lon_0,16.5)(x_0,0)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3767, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3768, srs::dpar::parameters<>(proj_utm)(zone,34)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3769, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_clrk66)(units_m)(no_defs)},
            {3770, srs::dpar::parameters<>(proj_tmerc)(lat_0,32)(lon_0,-64.75)(k,1)(x_0,550000)(y_0,100000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3771, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-111)(k,0.9999)(x_0,0)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {3772, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-114)(k,0.9999)(x_0,0)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {3773, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-117)(k,0.9999)(x_0,0)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {3774, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-120)(k,0.9999)(x_0,0)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {3775, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-111)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3776, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-114)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3777, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-117)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3778, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-120)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3779, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-111)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3780, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-114)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3781, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-117)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3782, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-120)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3783, srs::dpar::parameters<>(proj_tmerc)(lat_0,-25.06855261111111)(lon_0,-130.1129671111111)(k,1)(x_0,14200)(y_0,15500)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3784, srs::dpar::parameters<>(proj_utm)(zone,9)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(185,165,42,0,0,0,0))(units_m)(no_defs)},
            {3785, srs::dpar::parameters<>(proj_webmerc)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3786, srs::dpar::parameters<>(proj_eqc)(lat_ts,0)(lat_0,0)(lon_0,0)(x_0,0)(y_0,0)(r,6371007)(units_m)(no_defs)},
            {3787, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,0.9999)(x_0,500000)(y_0,-5000000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {3788, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,166)(k,1)(x_0,3500000)(y_0,10000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3789, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,169)(k,1)(x_0,3500000)(y_0,10000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3790, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,179)(k,1)(x_0,3500000)(y_0,10000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3791, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-178)(k,1)(x_0,3500000)(y_0,10000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3793, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-176.5)(k,1)(x_0,3500000)(y_0,10000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3794, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,0.9999)(x_0,500000)(y_0,-5000000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3795, srs::dpar::parameters<>(proj_lcc)(lat_1,23)(lat_2,21.7)(lat_0,22.35)(lon_0,-81)(x_0,500000)(y_0,280296.016)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {3796, srs::dpar::parameters<>(proj_lcc)(lat_1,21.3)(lat_2,20.13333333333333)(lat_0,20.71666666666667)(lon_0,-76.83333333333333)(x_0,500000)(y_0,229126.939)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {3797, srs::dpar::parameters<>(proj_lcc)(lat_1,50)(lat_2,46)(lat_0,44)(lon_0,-70)(x_0,800000)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {3798, srs::dpar::parameters<>(proj_lcc)(lat_1,50)(lat_2,46)(lat_0,44)(lon_0,-70)(x_0,800000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3799, srs::dpar::parameters<>(proj_lcc)(lat_1,50)(lat_2,46)(lat_0,44)(lon_0,-70)(x_0,800000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {3800, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-120)(k,0.9999)(x_0,0)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {3801, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-120)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {3802, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-120)(k,0.9999)(x_0,0)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            //{3812},
            //{3814},
            //{3815},
            //{3816},
            {3819, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(595.48,121.69,515.35,4.115,2.9383,-0.853,-0.7029504596901044))(no_defs)},
            {3821, srs::dpar::parameters<>(proj_longlat)(ellps_aust_sa)(no_defs)},
            //{3822},
            {3823, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {3824, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{3825},
            //{3826},
            //{3827},
            //{3828},
            //{3829},
            //{3832},
            //{3833},
            //{3834},
            //{3835},
            //{3836},
            //{3837},
            //{3838},
            //{3839},
            //{3840},
            //{3841},
            //{3842},
            //{3843},
            //{3844},
            //{3845},
            //{3846},
            //{3847},
            //{3848},
            //{3849},
            //{3850},
            {3857, srs::dpar::parameters<>(proj_webmerc)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {3920, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(11,72,-101,0,0,0,0))(units_m)(no_defs)},
            {3942, srs::dpar::parameters<>(proj_lcc)(lat_1,41.25)(lat_2,42.75)(lat_0,42)(lon_0,3)(x_0,1700000)(y_0,1200000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3943, srs::dpar::parameters<>(proj_lcc)(lat_1,42.25)(lat_2,43.75)(lat_0,43)(lon_0,3)(x_0,1700000)(y_0,2200000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3944, srs::dpar::parameters<>(proj_lcc)(lat_1,43.25)(lat_2,44.75)(lat_0,44)(lon_0,3)(x_0,1700000)(y_0,3200000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3945, srs::dpar::parameters<>(proj_lcc)(lat_1,44.25)(lat_2,45.75)(lat_0,45)(lon_0,3)(x_0,1700000)(y_0,4200000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3946, srs::dpar::parameters<>(proj_lcc)(lat_1,45.25)(lat_2,46.75)(lat_0,46)(lon_0,3)(x_0,1700000)(y_0,5200000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3947, srs::dpar::parameters<>(proj_lcc)(lat_1,46.25)(lat_2,47.75)(lat_0,47)(lon_0,3)(x_0,1700000)(y_0,6200000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3948, srs::dpar::parameters<>(proj_lcc)(lat_1,47.25)(lat_2,48.75)(lat_0,48)(lon_0,3)(x_0,1700000)(y_0,7200000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3949, srs::dpar::parameters<>(proj_lcc)(lat_1,48.25)(lat_2,49.75)(lat_0,49)(lon_0,3)(x_0,1700000)(y_0,8200000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3950, srs::dpar::parameters<>(proj_lcc)(lat_1,49.25)(lat_2,50.75)(lat_0,50)(lon_0,3)(x_0,1700000)(y_0,9200000)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {3991, srs::dpar::parameters<>(proj_lcc)(lat_1,18.43333333333333)(lat_2,18.03333333333333)(lat_0,17.83333333333333)(lon_0,-66.43333333333334)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(11,72,-101,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {3992, srs::dpar::parameters<>(proj_lcc)(lat_1,18.43333333333333)(lat_2,18.03333333333333)(lat_0,17.83333333333333)(lon_0,-66.43333333333334)(x_0,152400.3048006096)(y_0,30480.06096012192)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(11,72,-101,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            //{3993},
            //{3994},
            //{3995},
            //{3996},
            //{3997},
            {4001, srs::dpar::parameters<>(proj_longlat)(ellps_airy)(no_defs)},
            {4002, srs::dpar::parameters<>(proj_longlat)(a,6377340.189)(b,6356034.447938534)(no_defs)},
            {4003, srs::dpar::parameters<>(proj_longlat)(ellps_aust_sa)(no_defs)},
            {4004, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4005, srs::dpar::parameters<>(proj_longlat)(a,6377492.018)(b,6356173.508712696)(no_defs)},
            {4006, srs::dpar::parameters<>(proj_longlat)(ellps_bess_nam)(no_defs)},
            {4007, srs::dpar::parameters<>(proj_longlat)(a,6378293.645208759)(b,6356617.987679838)(no_defs)},
            {4008, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4009, srs::dpar::parameters<>(proj_longlat)(a,6378450.047548896)(b,6356826.621488444)(no_defs)},
            {4010, srs::dpar::parameters<>(proj_longlat)(a,6378300.789)(b,6356566.435)(no_defs)},
            {4011, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4012, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4013, srs::dpar::parameters<>(proj_longlat)(a,6378249.145)(b,6356514.966398753)(no_defs)},
            {4014, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356514.996941779)(no_defs)},
            {4015, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(no_defs)},
            {4016, srs::dpar::parameters<>(proj_longlat)(ellps_evrstss)(no_defs)},
            {4018, srs::dpar::parameters<>(proj_longlat)(a,6377304.063)(b,6356103.038993155)(no_defs)},
            {4019, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            {4020, srs::dpar::parameters<>(proj_longlat)(ellps_helmert)(no_defs)},
            {4021, srs::dpar::parameters<>(proj_longlat)(a,6378160)(b,6356774.50408554)(no_defs)},
            {4022, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4024, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(no_defs)},
            {4025, srs::dpar::parameters<>(proj_longlat)(ellps_wgs66)(no_defs)},
            {4027, srs::dpar::parameters<>(proj_longlat)(a,6376523)(b,6355862.933255573)(no_defs)},
            {4028, srs::dpar::parameters<>(proj_longlat)(a,6378298.3)(b,6356657.142669561)(no_defs)},
            {4029, srs::dpar::parameters<>(proj_longlat)(a,6378300)(b,6356751.689189189)(no_defs)},
            {4030, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(no_defs)},
            {4031, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(no_defs)},
            {4032, srs::dpar::parameters<>(proj_longlat)(a,6378136.2)(b,6356751.516927429)(no_defs)},
            {4033, srs::dpar::parameters<>(proj_longlat)(a,6378136.3)(b,6356751.616592146)(no_defs)},
            {4034, srs::dpar::parameters<>(proj_longlat)(a,6378249.144808011)(b,6356514.966204134)(no_defs)},
            {4035, srs::dpar::parameters<>(proj_longlat)(r,6371000)(no_defs)},
            {4036, srs::dpar::parameters<>(proj_longlat)(ellps_grs67)(no_defs)},
            {4041, srs::dpar::parameters<>(proj_longlat)(a,6378135)(b,6356750.304921594)(no_defs)},
            {4042, srs::dpar::parameters<>(proj_longlat)(a,6377299.36559538)(b,6356098.359005157)(no_defs)},
            {4043, srs::dpar::parameters<>(proj_longlat)(ellps_wgs72)(no_defs)},
            {4044, srs::dpar::parameters<>(proj_longlat)(a,6377301.243)(b,6356100.230165384)(no_defs)},
            {4045, srs::dpar::parameters<>(proj_longlat)(a,6377299.151)(b,6356098.145120132)(no_defs)},
            {4047, srs::dpar::parameters<>(proj_longlat)(r,6371007)(no_defs)},
            {4052, srs::dpar::parameters<>(proj_longlat)(r,6370997)(no_defs)},
            {4053, srs::dpar::parameters<>(proj_longlat)(r,6371228)(no_defs)},
            {4054, srs::dpar::parameters<>(proj_longlat)(a,6378273)(b,6356889.449)(no_defs)},
            {4055, srs::dpar::parameters<>(proj_longlat)(r,6378137)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4120, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4121, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-199.87,74.79,246.62,0,0,0,0))(no_defs)},
            {4122, srs::dpar::parameters<>(proj_longlat)(a,6378135)(b,6356750.304921594)(no_defs)},
            {4123, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4124, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4125, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(-404.78,685.68,45.47,0,0,0,0))(no_defs)},
            {4126, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            {4127, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4128, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4129, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4130, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,-0,-0,-0,0))(no_defs)},
            {4131, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(no_defs)},
            {4132, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4133, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.055,-0.541,-0.185,0.0183,-0.0003,-0.007,-0.014))(no_defs)},
            {4134, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4135, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4136, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4137, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4138, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4139, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(11,72,-101,0,0,0,0))(no_defs)},
            {4140, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4141, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-48,55,52,0,0,0,0))(no_defs)},
            {4142, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-125,53,467,0,0,0,0))(no_defs)},
            {4143, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-124.76,53,466.79,0,0,0,0))(no_defs)},
            {4144, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(no_defs)},
            {4145, srs::dpar::parameters<>(proj_longlat)(a,6377301.243)(b,6356100.230165384)(no_defs)},
            {4146, srs::dpar::parameters<>(proj_longlat)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295,736,257,0,0,0,0))(no_defs)},
            {4147, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(-17.51,-108.32,-62.39,0,0,0,0))(no_defs)},
            {4148, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4149, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(674.374,15.056,405.346,0,0,0,0))(no_defs)},
            {4150, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(674.374,15.056,405.346,0,0,0,0))(no_defs)},
            {4151, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4152, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            {4153, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-133.63,-157.5,-158.62,0,0,0,0))(no_defs)},
            {4154, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4155, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-83,37,124,0,0,0,0))(no_defs)},
            {4156, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4157, srs::dpar::parameters<>(proj_longlat)(a,6378293.645208759)(b,6356617.987679838)(no_defs)},
            {4158, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4159, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4160, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4161, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(27.5,14,186.4,0,0,0,0))(no_defs)},
            {4162, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4163, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4164, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(-76,-138,67,0,0,0,0))(no_defs)},
            {4165, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-173,253,27,0,0,0,0))(no_defs)},
            {4166, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4167, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4168, srs::dpar::parameters<>(proj_longlat)(a,6378300)(b,6356751.689189189)(towgs84,srs::detail::towgs84<>(-199,32,322,0,0,0,0))(no_defs)},
            {4169, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-115,118,426,0,0,0,0))(no_defs)},
            {4170, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4171, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4172, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4173, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4174, srs::dpar::parameters<>(proj_longlat)(a,6378300)(b,6356751.689189189)(no_defs)},
            {4175, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-88,4,101,0,0,0,0))(no_defs)},
            {4176, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4178, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(24,-123,-94,0.02,-0.25,-0.13,1.1))(no_defs)},
            {4179, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.84))(no_defs)},
            {4180, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4181, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-193,13.7,-39.3,-0.41,-2.933,2.688,0.43))(no_defs)},
            {4182, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4183, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-104,167,-38,0,0,0,0))(no_defs)},
            {4184, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-203,141,53,0,0,0,0))(no_defs)},
            {4185, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4188, srs::dpar::parameters<>(proj_longlat)(ellps_airy)(towgs84,srs::detail::towgs84<>(482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15))(no_defs)},
            {4189, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4190, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            {4191, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(no_defs)},
            {4192, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-206.1,-174.7,-87.7,0,0,0,0))(no_defs)},
            {4193, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-70.9,-151.8,-41.4,0,0,0,0))(no_defs)},
            {4194, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4195, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(105,326,-102.5,0,0,0.814,-0.6))(no_defs)},
            {4196, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-45,417,-3.5,0,0,0.814,-0.6))(no_defs)},
            {4197, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4198, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4199, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4200, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(no_defs)},
            {4201, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4202, srs::dpar::parameters<>(proj_longlat)(ellps_aust_sa)(no_defs)},
            {4203, srs::dpar::parameters<>(proj_longlat)(ellps_aust_sa)(no_defs)},
            {4204, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4205, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(-43,-163,45,0,0,0,0))(no_defs)},
            {4206, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4207, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4208, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4209, srs::dpar::parameters<>(proj_longlat)(a,6378249.145)(b,6356514.966398753)(no_defs)},
            {4210, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4211, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4212, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(31.95,300.99,419.19,0,0,0,0))(no_defs)},
            {4213, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-106,-87,188,0,0,0,0))(no_defs)},
            {4214, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(no_defs)},
            {4215, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4216, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4218, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(307,304,-318,0,0,0,0))(no_defs)},
            {4219, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(-384,664,-48,0,0,0,0))(no_defs)},
            {4220, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4221, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4222, srs::dpar::parameters<>(proj_longlat)(a,6378249.145)(b,6356514.966398753)(no_defs)},
            {4223, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4224, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-134,229,-29,0,0,0,0))(no_defs)},
            {4225, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-206,172,-6,0,0,0,0))(no_defs)},
            {4226, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4227, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4228, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4229, srs::dpar::parameters<>(proj_longlat)(ellps_helmert)(no_defs)},
            {4230, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4231, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4232, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4233, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-133,-321,50,0,0,0,0))(no_defs)},
            {4234, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4235, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4236, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-637,-549,-203,0,0,0,0))(no_defs)},
            {4237, srs::dpar::parameters<>(proj_longlat)(ellps_grs67)(no_defs)},
            {4238, srs::dpar::parameters<>(proj_longlat)(a,6378160)(b,6356774.50408554)(no_defs)},
            {4239, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(towgs84,srs::detail::towgs84<>(217,823,299,0,0,0,0))(no_defs)},
            {4240, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(no_defs)},
            {4241, srs::dpar::parameters<>(proj_longlat)(a,6378249.144808011)(b,6356514.966204134)(no_defs)},
            {4242, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4243, srs::dpar::parameters<>(proj_longlat)(a,6377299.36559538)(b,6356098.359005157)(no_defs)},
            {4244, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(towgs84,srs::detail::towgs84<>(-97,787,86,0,0,0,0))(no_defs)},
            {4245, srs::dpar::parameters<>(proj_longlat)(a,6377304.063)(b,6356103.038993155)(towgs84,srs::detail::towgs84<>(-11,851,5,0,0,0,0))(no_defs)},
            {4246, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-294.7,-200.1,525.5,0,0,0,0))(no_defs)},
            {4247, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-273.5,110.6,-357.9,0,0,0,0))(no_defs)},
            {4248, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4249, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4250, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-130,29,364,0,0,0,0))(no_defs)},
            {4251, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-90,40,88,0,0,0,0))(no_defs)},
            {4252, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4253, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4254, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4255, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-333,-222,114,0,0,0,0))(no_defs)},
            {4256, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(41,-220,-134,0,0,0,0))(no_defs)},
            {4257, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(-587.8,519.75,145.76,0,0,0,0))(no_defs)},
            {4258, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            {4259, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4260, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-70.9,-151.8,-41.4,0,0,0,0))(no_defs)},
            {4261, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(31,146,47,0,0,0,0))(no_defs)},
            {4262, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(639,405,60,0,0,0,0))(no_defs)},
            {4263, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4264, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-252.95,-4.11,-96.38,0,0,0,0))(no_defs)},
            {4265, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4266, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4267, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(srs::dpar::datum_nad27)(no_defs)},
            {4268, srs::dpar::parameters<>(proj_longlat)(a,6378450.047548896)(b,6356826.621488444)(no_defs)},
            {4269, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(srs::dpar::datum_nad83)(no_defs)},
            {4270, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4271, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4272, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(srs::dpar::datum_nzgd49)(no_defs)},
            {4273, srs::dpar::parameters<>(proj_longlat)(a,6377492.018)(b,6356173.508712696)(towgs84,srs::detail::towgs84<>(278.3,93,474.5,7.889,0.05,-6.61,6.21))(no_defs)},
            {4274, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4275, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(no_defs)},
            {4276, srs::dpar::parameters<>(proj_longlat)(ellps_wgs66)(no_defs)},
            {4277, srs::dpar::parameters<>(proj_longlat)(ellps_airy)(srs::dpar::datum_osgb36)(no_defs)},
            {4278, srs::dpar::parameters<>(proj_longlat)(ellps_airy)(no_defs)},
            {4279, srs::dpar::parameters<>(proj_longlat)(ellps_airy)(no_defs)},
            {4280, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4281, srs::dpar::parameters<>(proj_longlat)(a,6378300.789)(b,6356566.435)(towgs84,srs::detail::towgs84<>(-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1))(no_defs)},
            {4282, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4283, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4284, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(no_defs)},
            {4285, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4286, srs::dpar::parameters<>(proj_longlat)(ellps_helmert)(no_defs)},
            {4287, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(164,138,-189,0,0,0,0))(no_defs)},
            {4288, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4289, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4291, srs::dpar::parameters<>(proj_longlat)(ellps_grs67)(no_defs)},
            {4292, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-355,21,72,0,0,0,0))(no_defs)},
            {4293, srs::dpar::parameters<>(proj_longlat)(ellps_bess_nam)(no_defs)},
            {4294, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4295, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4296, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4297, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-189,-242,-91,0,0,0,0))(no_defs)},
            {4298, srs::dpar::parameters<>(proj_longlat)(ellps_evrstss)(no_defs)},
            {4299, srs::dpar::parameters<>(proj_longlat)(a,6377340.189)(b,6356034.447938534)(no_defs)},
            {4300, srs::dpar::parameters<>(proj_longlat)(a,6377340.189)(b,6356034.447938534)(no_defs)},
            {4301, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4302, srs::dpar::parameters<>(proj_longlat)(a,6378293.645208759)(b,6356617.987679838)(no_defs)},
            {4303, srs::dpar::parameters<>(proj_longlat)(ellps_helmert)(no_defs)},
            {4304, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-73,-247,227,0,0,0,0))(no_defs)},
            {4306, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4307, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4308, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4309, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-155,171,37,0,0,0,0))(no_defs)},
            {4310, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4311, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-265,120,-358,0,0,0,0))(no_defs)},
            {4312, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(no_defs)},
            {4313, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1))(no_defs)},
            {4314, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(srs::dpar::datum_potsdam)(no_defs)},
            {4315, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-23,259,-9,0,0,0,0))(no_defs)},
            {4316, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4317, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(no_defs)},
            {4318, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(-3.2,-5.7,2.8,0,0,0,0))(no_defs)},
            {4319, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            {4322, srs::dpar::parameters<>(proj_longlat)(ellps_wgs72)(no_defs)},
            {4324, srs::dpar::parameters<>(proj_longlat)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(no_defs)},
            {4326, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(srs::dpar::datum_wgs84)(no_defs)},
            {4327, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(srs::dpar::datum_wgs84)(no_defs)},
            //{4328},
            {4329, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(srs::dpar::datum_wgs84)(no_defs)},
            //{4330},
            //{4331},
            //{4332},
            //{4333},
            //{4334},
            //{4335},
            //{4336},
            //{4337},
            //{4338},
            {4339, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4340},
            {4341, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4342},
            {4343, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4344},
            {4345, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4346},
            {4347, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4348},
            {4349, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4350},
            {4351, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4352},
            {4353, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4354},
            {4355, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4356},
            {4357, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,-0.0,0.0,0.0,0.0))(no_defs)},
            //{4358},
            {4359, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0))(no_defs)},
            //{4360},
            {4361, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0))(no_defs)},
            //{4362},
            {4363, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4364},
            {4365, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4366},
            {4367, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4368},
            {4369, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4370},
            {4371, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(2.0,2.0,-2.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4372},
            {4373, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4374},
            {4375, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4376},
            {4377, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4378},
            {4379, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4380},
            {4381, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4382},
            {4383, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4384},
            //{4385},
            {4386, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4387},
            {4388, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4389},
            {4600, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4601, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4602, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(725,685,536,0,0,0,0))(no_defs)},
            {4603, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(72,213.7,93,0,0,0,0))(no_defs)},
            {4604, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(174,359,365,0,0,0,0))(no_defs)},
            {4605, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4606, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-149,128,296,0,0,0,0))(no_defs)},
            {4607, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(195.671,332.517,274.607,0,0,0,0))(no_defs)},
            {4608, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4609, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4610, srs::dpar::parameters<>(proj_longlat)(a,6378140)(b,6356755.288157528)(no_defs)},
            {4611, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-162.619,-276.959,-161.764,0.067753,-2.24365,-1.15883,-1.09425))(no_defs)},
            {4612, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4613, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4614, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-119.425,-303.659,-11.0006,1.1643,0.174458,1.09626,3.65706))(no_defs)},
            {4615, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-499,-249,314,0,0,0,0))(no_defs)},
            {4616, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4617, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            {4618, srs::dpar::parameters<>(proj_longlat)(ellps_aust_sa)(no_defs)},
            {4619, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4620, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-106,-129,165,0,0,0,0))(no_defs)},
            {4621, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(137,248,-430,0,0,0,0))(no_defs)},
            {4622, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4623, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-186,230,110,0,0,0,0))(no_defs)},
            {4624, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(2,2,-2,0,0,0,0))(no_defs)},
            {4625, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4626, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4627, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4628, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(162,117,154,0,0,0,0))(no_defs)},
            {4629, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4630, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4631, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(145,-187,103,0,0,0,0))(no_defs)},
            {4632, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-382,-59,-262,0,0,0,0))(no_defs)},
            {4633, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4634, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4635, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,4.4798))(no_defs)},
            {4636, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(365,194,166,0,0,0,0))(no_defs)},
            {4637, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(325,154,172,0,0,0,0))(no_defs)},
            {4638, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(30,430,368,0,0,0,0))(no_defs)},
            {4639, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4640, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4641, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4642, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4643, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-111.7))(no_defs)},
            {4644, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4645, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4646, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4657, srs::dpar::parameters<>(proj_longlat)(a,6377019.27)(b,6355762.5391)(towgs84,srs::detail::towgs84<>(-28,199,5,0,0,0,0))(no_defs)},
            {4658, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-73,46,-86,0,0,0,0))(no_defs)},
            {4659, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4660, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(982.609,552.753,-540.873,32.3934,-153.257,-96.2266,16.805))(no_defs)},
            {4661, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4662, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4663, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4664, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4665, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4666, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4667, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4668, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-86,-98,-119,0,0,0,0))(no_defs)},
            {4669, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4670, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4671, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {4672, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(175,-38,113,0,0,0,0))(no_defs)},
            {4673, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(174.05,-25.49,112.57,-0,-0,0.554,0.2263))(no_defs)},
            {4674, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4675, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-100,-248,259,0,0,0,0))(no_defs)},
            {4676, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(no_defs)},
            {4677, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(no_defs)},
            {4678, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(44.585,-131.212,-39.544,0,0,0,0))(no_defs)},
            {4679, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-80.01,253.26,291.19,0,0,0,0))(no_defs)},
            {4680, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(124.5,-63.5,-281,0,0,0,0))(no_defs)},
            {4681, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4682, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(no_defs)},
            {4683, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-127.62,-67.24,-47.04,-3.068,4.903,1.578,-1.06))(no_defs)},
            {4684, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-133,-321,50,0,0,0,0))(no_defs)},
            {4685, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4686, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4687, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            {4688, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(347.103,1078.12,2623.92,-33.8875,70.6773,-9.3943,186.074))(no_defs)},
            {4689, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4690, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4691, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(215.525,149.593,176.229,-3.2624,-1.692,-1.1571,10.4773))(no_defs)},
            {4692, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(217.037,86.959,23.956,0,0,0,0))(no_defs)},
            {4693, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,-0.15,0.68,0,0,0,0))(no_defs)},
            {4694, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4695, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4696, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4697, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4698, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(145,-187,103,0,0,0,0))(no_defs)},
            {4699, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-770.1,158.4,-498.2,0,0,0,0))(no_defs)},
            {4700, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4701, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-79.9,-158,-168.9,0,0,0,0))(no_defs)},
            {4702, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4703, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4704, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4705, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4706, srs::dpar::parameters<>(proj_longlat)(ellps_helmert)(towgs84,srs::detail::towgs84<>(-146.21,112.63,4.05,0,0,0,0))(no_defs)},
            {4707, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(114,-116,-333,0,0,0,0))(no_defs)},
            {4708, srs::dpar::parameters<>(proj_longlat)(ellps_aust_sa)(towgs84,srs::detail::towgs84<>(-491,-22,435,0,0,0,0))(no_defs)},
            {4709, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(145,75,-272,0,0,0,0))(no_defs)},
            {4710, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-320,550,-494,0,0,0,0))(no_defs)},
            {4711, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(124,-234,-25,0,0,0,0))(no_defs)},
            {4712, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-205,107,53,0,0,0,0))(no_defs)},
            {4713, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-79,-129,145,0,0,0,0))(no_defs)},
            {4714, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-127,-769,472,0,0,0,0))(no_defs)},
            {4715, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-104,-129,239,0,0,0,0))(no_defs)},
            {4716, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(298,-304,-375,0,0,0,0))(no_defs)},
            {4717, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-2,151,181,0,0,0,0))(no_defs)},
            {4718, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4719, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(211,147,111,0,0,0,0))(no_defs)},
            {4720, srs::dpar::parameters<>(proj_longlat)(ellps_wgs72)(no_defs)},
            {4721, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(265.025,384.929,-194.046,0,0,0,0))(no_defs)},
            {4722, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-794,119,-298,0,0,0,0))(no_defs)},
            {4723, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(67.8,106.1,138.8,0,0,0,0))(no_defs)},
            {4724, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(208,-435,-229,0,0,0,0))(no_defs)},
            {4725, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(189,-79,-202,0,0,0,0))(no_defs)},
            {4726, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {4727, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4728, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-307,-92,127,0,0,0,0))(no_defs)},
            {4729, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(185,165,42,0,0,0,0))(no_defs)},
            {4730, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(170,42,84,0,0,0,0))(no_defs)},
            {4731, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(51,391,-36,0,0,0,0))(no_defs)},
            {4732, srs::dpar::parameters<>(proj_longlat)(a,6378270)(b,6356794.343434343)(towgs84,srs::detail::towgs84<>(102,52,-38,0,0,0,0))(no_defs)},
            {4733, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(276,-57,149,0,0,0,0))(no_defs)},
            {4734, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-632,438,-609,0,0,0,0))(no_defs)},
            {4735, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(647,1777,-1124,0,0,0,0))(no_defs)},
            {4736, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(260,12,-147,0,0,0,0))(no_defs)},
            {4737, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4738, srs::dpar::parameters<>(proj_longlat)(a,6378293.645208759)(b,6356617.987679838)(no_defs)},
            {4739, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-156,-271,-189,0,0,0,0))(no_defs)},
            {4740, srs::dpar::parameters<>(proj_longlat)(a,6378136)(b,6356751.361745712)(towgs84,srs::detail::towgs84<>(0,0,1.5,-0,-0,0.076,0))(no_defs)},
            {4741, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4742, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            {4743, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(84.1,-320.1,218.7,0,0,0,0))(no_defs)},
            {4744, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {4745, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4746, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {4747, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4748, srs::dpar::parameters<>(proj_longlat)(a,6378306.3696)(b,6356571.996)(towgs84,srs::detail::towgs84<>(51,391,-36,0,0,0,0))(no_defs)},
            {4749, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4750, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(-56.263,16.136,-22.856,0,0,0,0))(no_defs)},
            {4751, srs::dpar::parameters<>(proj_longlat)(a,6377295.664)(b,6356094.667915204)(no_defs)},
            {4752, srs::dpar::parameters<>(proj_longlat)(a,6378306.3696)(b,6356571.996)(towgs84,srs::detail::towgs84<>(51,391,-36,0,0,0,0))(no_defs)},
            {4753, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {4754, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.406,-109.878,-2.5764,0,0,0,0))(no_defs)},
            {4755, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4756, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(no_defs)},
            {4757, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(no_defs)},
            {4758, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4759, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4760, srs::dpar::parameters<>(proj_longlat)(ellps_wgs66)(no_defs)},
            {4761, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4762, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4763, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4764, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4765, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(no_defs)},
            {4801, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_bern)(no_defs)},
            {4802, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(pm_bogota)(no_defs)},
            {4803, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(pm_lisbon)(no_defs)},
            {4804, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(-587.8,519.75,145.76,0,0,0,0))(pm_jakarta)(no_defs)},
            {4805, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_ferro)(no_defs)},
            {4806, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(pm_rome)(no_defs)},
            {4807, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(no_defs)},
            {4808, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_jakarta)(no_defs)},
            {4809, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(pm_brussels)(no_defs)},
            {4810, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-189,-242,-91,0,0,0,0))(pm_paris)(no_defs)},
            {4811, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-73,-247,227,0,0,0,0))(pm_paris)(no_defs)},
            {4813, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_jakarta)(no_defs)},
            {4814, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_stockholm)(no_defs)},
            {4815, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_athens)(no_defs)},
            {4816, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(pm_paris)(no_defs)},
            {4817, srs::dpar::parameters<>(proj_longlat)(a,6377492.018)(b,6356173.508712696)(towgs84,srs::detail::towgs84<>(278.3,93,474.5,7.889,0.05,-6.61,6.21))(pm_oslo)(no_defs)},
            {4818, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_ferro)(no_defs)},
            {4819, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(pm_paris)(no_defs)},
            {4820, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_jakarta)(no_defs)},
            {4821, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(pm_paris)(no_defs)},
            //{4882},
            {4883, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4884},
            {4885, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4886},
            {4887, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4888},
            {4889, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4890},
            {4891, srs::dpar::parameters<>(proj_longlat)(ellps_wgs66)(no_defs)},
            //{4892},
            {4893, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4894},
            {4895, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4896},
            //{4897},
            {4898, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4899},
            {4900, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.4058,-109.8777,-2.5764,0.0,0.0,0.0,0.0))(no_defs)},
            {4901, srs::dpar::parameters<>(proj_longlat)(a,6376523)(b,6355862.933255573)(pm,2.3372291666985)(no_defs)},
            {4902, srs::dpar::parameters<>(proj_longlat)(a,6376523)(b,6355862.933255573)(pm_paris)(no_defs)},
            {4903, srs::dpar::parameters<>(proj_longlat)(a,6378298.3)(b,6356657.142669561)(pm_madrid)(no_defs)},
            {4904, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_lisbon)(no_defs)},
            //{4906},
            {4907, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4908},
            {4909, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4910},
            //{4911},
            //{4912},
            //{4913},
            //{4914},
            //{4915},
            //{4916},
            //{4917},
            //{4918},
            //{4919},
            //{4920},
            {4921, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            //{4922},
            {4923, srs::dpar::parameters<>(proj_longlat)(a,6378136)(b,6356751.361745712)(towgs84,srs::detail::towgs84<>(0.0,0.0,1.5,-0.0,0.0,-0.076,0.0))(no_defs)},
            //{4924},
            {4925, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4926},
            {4927, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4928},
            {4929, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(no_defs)},
            //{4930},
            {4931, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4932},
            {4933, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4934},
            {4935, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4936},
            {4937, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4938},
            {4939, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4940},
            {4941, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4942},
            {4943, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4944},
            {4945, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4946},
            {4947, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4948},
            {4949, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4950},
            {4951, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4952},
            {4953, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,-0.0,0.0,0.0,0.0))(no_defs)},
            //{4954},
            {4955, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0))(no_defs)},
            //{4956},
            {4957, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0))(no_defs)},
            //{4958},
            {4959, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4960},
            {4961, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4962},
            {4963, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4964},
            {4965, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4966},
            {4967, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(2.0,2.0,-2.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4968},
            {4969, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4970},
            {4971, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4972},
            {4973, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4974},
            {4975, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4976},
            {4977, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4978},
            {4979, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(srs::dpar::datum_wgs84)(no_defs)},
            //{4980},
            {4981, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4982},
            {4983, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4984},
            {4985, srs::dpar::parameters<>(proj_longlat)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0.0,0.0,4.5,0.0,0.0,0.554,0.045171992568114105))(no_defs)},
            //{4986},
            {4987, srs::dpar::parameters<>(proj_longlat)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0.0,0.0,1.9,0.0,0.0,0.814,-0.07838062637389662))(no_defs)},
            //{4988},
            {4989, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4990},
            {4991, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(no_defs)},
            //{4992},
            {4993, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(44.585,-131.212,-39.544,0.0,0.0,0.0,0.0))(no_defs)},
            //{4994},
            {4995, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-127.62,-67.24,-47.04,-3.068,-4.903,-1.578,-0.21864069462192215))(no_defs)},
            //{4996},
            {4997, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            //{4998},
            {4999, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.072,-0.507,-0.245,-0.0183,-0.0003,0.007,-0.001918262698097996))(no_defs)},
            //{5600},
            //{5601},
            //{5602},
            //{5603},
            //{5604},
            //{5605},
            //{5606},
            //{5607},
            //{5608},
            //{5609},
            //{5610},
            //{5611},
            //{5612},
            //{5613},
            //{5614},
            //{5615},
            //{5616},
            //{5617},
            //{5618},
            //{5619},
            //{5620},
            //{5701},
            //{5702},
            //{5703},
            //{5704},
            //{5705},
            //{5706},
            //{5709},
            //{5710},
            //{5711},
            //{5712},
            //{5713},
            //{5714},
            //{5715},
            //{5716},
            //{5717},
            //{5718},
            //{5719},
            //{5720},
            //{5721},
            //{5722},
            //{5723},
            //{5724},
            //{5725},
            //{5726},
            //{5727},
            //{5728},
            //{5729},
            //{5730},
            //{5731},
            //{5732},
            //{5733},
            //{5734},
            //{5735},
            //{5736},
            //{5737},
            //{5738},
            //{5739},
            //{5740},
            //{5741},
            //{5742},
            //{5743},
            //{5744},
            //{5745},
            //{5746},
            //{5747},
            //{5748},
            //{5749},
            //{5750},
            //{5751},
            //{5752},
            //{5753},
            //{5754},
            //{5755},
            //{5756},
            //{5757},
            //{5758},
            //{5759},
            //{5760},
            //{5761},
            //{5762},
            //{5763},
            //{5764},
            //{5765},
            //{5766},
            //{5767},
            //{5768},
            //{5769},
            //{5770},
            //{5771},
            //{5772},
            //{5773},
            //{5774},
            //{5775},
            //{5776},
            //{5777},
            //{5778},
            //{5779},
            //{5780},
            //{5781},
            //{5782},
            //{5783},
            //{5784},
            //{5785},
            //{5786},
            //{5787},
            //{5788},
            //{5789},
            //{5790},
            //{5791},
            //{5792},
            //{5793},
            //{5794},
            //{5795},
            //{5796},
            //{5797},
            //{5798},
            //{5799},
            //{5800},
            //{5801},
            //{5802},
            //{5803},
            //{5804},
            //{5805},
            //{5806},
            //{5807},
            //{5808},
            //{5809},
            //{5810},
            //{5811},
            //{5812},
            //{5813},
            //{5814},
            //{5815},
            //{5816},
            //{5817},
            //{5818},
            //{5819},
            //{5820},
            //{5821},
            //{7400},
            //{7401},
            //{7402},
            //{7403},
            //{7404},
            //{7405},
            //{7406},
            //{7407},
            //{7408},
            //{7409},
            //{7410},
            //{7411},
            //{7412},
            //{7413},
            //{7414},
            //{7415},
            //{7416},
            //{7417},
            //{7418},
            //{7419},
            //{7420},
            //{7421},
            //{7422},
            {20004, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,4500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20005, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,5500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20006, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,6500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20007, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,39)(k,1)(x_0,7500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20008, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,8500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20009, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,51)(k,1)(x_0,9500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20010, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,57)(k,1)(x_0,10500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20011, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,63)(k,1)(x_0,11500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20012, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,69)(k,1)(x_0,12500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20013, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,13500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20014, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,14500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20015, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,15500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20016, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,16500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20017, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,17500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20018, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,18500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20019, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,19500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20020, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,20500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20021, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,21500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20022, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,22500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20023, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,23500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20024, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,141)(k,1)(x_0,24500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20025, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,147)(k,1)(x_0,25500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20026, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,153)(k,1)(x_0,26500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20027, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,159)(k,1)(x_0,27500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20028, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,165)(k,1)(x_0,28500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20029, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,171)(k,1)(x_0,29500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20030, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,177)(k,1)(x_0,30500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20031, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-177)(k,1)(x_0,31500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20032, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-171)(k,1)(x_0,32500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20064, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20065, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20066, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20067, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,39)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20068, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20069, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,51)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20070, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,57)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20071, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,63)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20072, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,69)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20073, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20074, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20075, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20076, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20077, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20078, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20079, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20080, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20081, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20082, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20083, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20084, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,141)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20085, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,147)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20086, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,153)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20087, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,159)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20088, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,165)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20089, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,171)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20090, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,177)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20091, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-177)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20092, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-171)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {20135, srs::dpar::parameters<>(proj_utm)(zone,35)(ellps_clrk80)(units_m)(no_defs)},
            {20136, srs::dpar::parameters<>(proj_utm)(zone,36)(ellps_clrk80)(units_m)(no_defs)},
            {20137, srs::dpar::parameters<>(proj_utm)(zone,37)(ellps_clrk80)(units_m)(no_defs)},
            {20138, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_clrk80)(units_m)(no_defs)},
            {20248, srs::dpar::parameters<>(proj_utm)(zone,48)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20249, srs::dpar::parameters<>(proj_utm)(zone,49)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20250, srs::dpar::parameters<>(proj_utm)(zone,50)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20251, srs::dpar::parameters<>(proj_utm)(zone,51)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20252, srs::dpar::parameters<>(proj_utm)(zone,52)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20253, srs::dpar::parameters<>(proj_utm)(zone,53)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20254, srs::dpar::parameters<>(proj_utm)(zone,54)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20255, srs::dpar::parameters<>(proj_utm)(zone,55)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20256, srs::dpar::parameters<>(proj_utm)(zone,56)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20257, srs::dpar::parameters<>(proj_utm)(zone,57)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20258, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20348, srs::dpar::parameters<>(proj_utm)(zone,48)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20349, srs::dpar::parameters<>(proj_utm)(zone,49)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20350, srs::dpar::parameters<>(proj_utm)(zone,50)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20351, srs::dpar::parameters<>(proj_utm)(zone,51)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20352, srs::dpar::parameters<>(proj_utm)(zone,52)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20353, srs::dpar::parameters<>(proj_utm)(zone,53)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20354, srs::dpar::parameters<>(proj_utm)(zone,54)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20355, srs::dpar::parameters<>(proj_utm)(zone,55)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20356, srs::dpar::parameters<>(proj_utm)(zone,56)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20357, srs::dpar::parameters<>(proj_utm)(zone,57)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20358, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {20436, srs::dpar::parameters<>(proj_utm)(zone,36)(ellps_intl)(units_m)(no_defs)},
            {20437, srs::dpar::parameters<>(proj_utm)(zone,37)(ellps_intl)(units_m)(no_defs)},
            {20438, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_intl)(units_m)(no_defs)},
            {20439, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_intl)(units_m)(no_defs)},
            {20440, srs::dpar::parameters<>(proj_utm)(zone,40)(ellps_intl)(units_m)(no_defs)},
            {20499, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_intl)(units_m)(no_defs)},
            {20538, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_krass)(towgs84,srs::detail::towgs84<>(-43,-163,45,0,0,0,0))(units_m)(no_defs)},
            {20539, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_krass)(towgs84,srs::detail::towgs84<>(-43,-163,45,0,0,0,0))(units_m)(no_defs)},
            {20790, srs::dpar::parameters<>(proj_tmerc)(lat_0,39.66666666666666)(lon_0,1)(k,1)(x_0,200000)(y_0,300000)(ellps_intl)(pm_lisbon)(units_m)(no_defs)},
            {20791, srs::dpar::parameters<>(proj_tmerc)(lat_0,39.66666666666666)(lon_0,1)(k,1)(x_0,0)(y_0,0)(ellps_intl)(pm_lisbon)(units_m)(no_defs)},
            {20822, srs::dpar::parameters<>(proj_utm)(zone,22)(south)(ellps_intl)(units_m)(no_defs)},
            {20823, srs::dpar::parameters<>(proj_utm)(zone,23)(south)(ellps_intl)(units_m)(no_defs)},
            {20824, srs::dpar::parameters<>(proj_utm)(zone,24)(south)(ellps_intl)(units_m)(no_defs)},
            {20934, srs::dpar::parameters<>(proj_utm)(zone,34)(south)(a,6378249.145)(b,6356514.966398753)(units_m)(no_defs)},
            {20935, srs::dpar::parameters<>(proj_utm)(zone,35)(south)(a,6378249.145)(b,6356514.966398753)(units_m)(no_defs)},
            {20936, srs::dpar::parameters<>(proj_utm)(zone,36)(south)(a,6378249.145)(b,6356514.966398753)(units_m)(no_defs)},
            {21035, srs::dpar::parameters<>(proj_utm)(zone,35)(south)(ellps_clrk80)(units_m)(no_defs)},
            {21036, srs::dpar::parameters<>(proj_utm)(zone,36)(south)(ellps_clrk80)(units_m)(no_defs)},
            {21037, srs::dpar::parameters<>(proj_utm)(zone,37)(south)(ellps_clrk80)(units_m)(no_defs)},
            {21095, srs::dpar::parameters<>(proj_utm)(zone,35)(ellps_clrk80)(units_m)(no_defs)},
            {21096, srs::dpar::parameters<>(proj_utm)(zone,36)(ellps_clrk80)(units_m)(no_defs)},
            {21097, srs::dpar::parameters<>(proj_utm)(zone,37)(ellps_clrk80)(units_m)(no_defs)},
            {21100, srs::dpar::parameters<>(proj_merc)(lon_0,110)(k,0.997)(x_0,3900000)(y_0,900000)(ellps_bessel)(pm_jakarta)(units_m)(no_defs)},
            {21148, srs::dpar::parameters<>(proj_utm)(zone,48)(south)(ellps_bessel)(units_m)(no_defs)},
            {21149, srs::dpar::parameters<>(proj_utm)(zone,49)(south)(ellps_bessel)(units_m)(no_defs)},
            {21150, srs::dpar::parameters<>(proj_utm)(zone,50)(south)(ellps_bessel)(units_m)(no_defs)},
            {21291, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-62)(k,0.9995000000000001)(x_0,400000)(y_0,0)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(31.95,300.99,419.19,0,0,0,0))(units_m)(no_defs)},
            {21292, srs::dpar::parameters<>(proj_tmerc)(lat_0,13.17638888888889)(lon_0,-59.55972222222222)(k,0.9999986)(x_0,30000)(y_0,75000)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(31.95,300.99,419.19,0,0,0,0))(units_m)(no_defs)},
            {21413, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,13500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21414, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,14500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21415, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,15500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21416, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,16500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21417, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,17500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21418, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,18500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21419, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,19500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21420, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,20500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21421, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,21500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21422, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,22500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21423, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,23500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21453, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21454, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21455, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21456, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21457, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21458, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21459, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21460, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21461, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21462, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21463, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21473, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21474, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21475, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21476, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21477, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21478, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21479, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21480, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21481, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21482, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21483, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {21500, srs::dpar::parameters<>(proj_lcc)(lat_1,49.83333333333334)(lat_2,51.16666666666666)(lat_0,90)(lon_0,0)(x_0,150000)(y_0,5400000)(ellps_intl)(pm_brussels)(units_m)(no_defs)},
            {21780, srs::dpar::parameters<>(proj_somerc)(lat_0,46.95240555555556)(lon_0,0)(k_0,1)(x_0,0)(y_0,0)(ellps_bessel)(pm_bern)(units_m)(no_defs)},
            {21781, srs::dpar::parameters<>(proj_somerc)(lat_0,46.95240555555556)(lon_0,7.439583333333333)(k_0,1)(x_0,600000)(y_0,200000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(674.374,15.056,405.346,0,0,0,0))(units_m)(no_defs)},
            //{21782},
            {21817, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_intl)(towgs84,srs::detail::towgs84<>(307,304,-318,0,0,0,0))(units_m)(no_defs)},
            {21818, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_intl)(towgs84,srs::detail::towgs84<>(307,304,-318,0,0,0,0))(units_m)(no_defs)},
            {21891, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.599047222222222)(lon_0,-77.08091666666667)(k,1)(x_0,1000000)(y_0,1000000)(ellps_intl)(towgs84,srs::detail::towgs84<>(307,304,-318,0,0,0,0))(units_m)(no_defs)},
            {21892, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.599047222222222)(lon_0,-74.08091666666667)(k,1)(x_0,1000000)(y_0,1000000)(ellps_intl)(towgs84,srs::detail::towgs84<>(307,304,-318,0,0,0,0))(units_m)(no_defs)},
            {21893, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.599047222222222)(lon_0,-71.08091666666667)(k,1)(x_0,1000000)(y_0,1000000)(ellps_intl)(towgs84,srs::detail::towgs84<>(307,304,-318,0,0,0,0))(units_m)(no_defs)},
            {21894, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.599047222222222)(lon_0,-68.08091666666667)(k,1)(x_0,1000000)(y_0,1000000)(ellps_intl)(towgs84,srs::detail::towgs84<>(307,304,-318,0,0,0,0))(units_m)(no_defs)},
            {21896, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.599047222222222)(lon_0,-77.08091666666667)(k,1)(x_0,1000000)(y_0,1000000)(ellps_intl)(towgs84,srs::detail::towgs84<>(307,304,-318,0,0,0,0))(units_m)(no_defs)},
            {21897, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.599047222222222)(lon_0,-74.08091666666667)(k,1)(x_0,1000000)(y_0,1000000)(ellps_intl)(towgs84,srs::detail::towgs84<>(307,304,-318,0,0,0,0))(units_m)(no_defs)},
            {21898, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.599047222222222)(lon_0,-71.08091666666667)(k,1)(x_0,1000000)(y_0,1000000)(ellps_intl)(towgs84,srs::detail::towgs84<>(307,304,-318,0,0,0,0))(units_m)(no_defs)},
            {21899, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.599047222222222)(lon_0,-68.08091666666667)(k,1)(x_0,1000000)(y_0,1000000)(ellps_intl)(towgs84,srs::detail::towgs84<>(307,304,-318,0,0,0,0))(units_m)(no_defs)},
            {22032, srs::dpar::parameters<>(proj_utm)(zone,32)(south)(ellps_clrk80)(units_m)(no_defs)},
            {22033, srs::dpar::parameters<>(proj_utm)(zone,33)(south)(ellps_clrk80)(units_m)(no_defs)},
            {22091, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,11.5)(k,0.9996)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {22092, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,12)(k,0.9996)(x_0,500000)(y_0,10000000)(ellps_clrk80)(units_m)(no_defs)},
            {22171, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-72)(k,1)(x_0,1500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {22172, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-69)(k,1)(x_0,2500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {22173, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-66)(k,1)(x_0,3500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {22174, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-63)(k,1)(x_0,4500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {22175, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-60)(k,1)(x_0,5500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {22176, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-57)(k,1)(x_0,6500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {22177, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-54)(k,1)(x_0,7500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {22181, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-72)(k,1)(x_0,1500000)(y_0,0)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {22182, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-69)(k,1)(x_0,2500000)(y_0,0)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {22183, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-66)(k,1)(x_0,3500000)(y_0,0)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {22184, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-63)(k,1)(x_0,4500000)(y_0,0)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {22185, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-60)(k,1)(x_0,5500000)(y_0,0)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {22186, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-57)(k,1)(x_0,6500000)(y_0,0)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {22187, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-54)(k,1)(x_0,7500000)(y_0,0)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {22191, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-72)(k,1)(x_0,1500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {22192, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-69)(k,1)(x_0,2500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {22193, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-66)(k,1)(x_0,3500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {22194, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-63)(k,1)(x_0,4500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {22195, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-60)(k,1)(x_0,5500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {22196, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-57)(k,1)(x_0,6500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {22197, srs::dpar::parameters<>(proj_tmerc)(lat_0,-90)(lon_0,-54)(k,1)(x_0,7500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {22234, srs::dpar::parameters<>(proj_utm)(zone,34)(south)(a,6378249.145)(b,6356514.966398753)(units_m)(no_defs)},
            {22235, srs::dpar::parameters<>(proj_utm)(zone,35)(south)(a,6378249.145)(b,6356514.966398753)(units_m)(no_defs)},
            {22236, srs::dpar::parameters<>(proj_utm)(zone,36)(south)(a,6378249.145)(b,6356514.966398753)(units_m)(no_defs)},
            //{22275},
            //{22277},
            //{22279},
            //{22281},
            //{22283},
            //{22285},
            //{22287},
            //{22289},
            //{22291},
            //{22293},
            //{22300},
            {22332, srs::dpar::parameters<>(proj_utm)(zone,32)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {22391, srs::dpar::parameters<>(proj_lcc)(lat_1,36)(lat_0,36)(lon_0,9.9)(k_0,0.999625544)(x_0,500000)(y_0,300000)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {22392, srs::dpar::parameters<>(proj_lcc)(lat_1,33.3)(lat_0,33.3)(lon_0,9.9)(k_0,0.999625769)(x_0,500000)(y_0,300000)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {22521, srs::dpar::parameters<>(proj_utm)(zone,21)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-206,172,-6,0,0,0,0))(units_m)(no_defs)},
            {22522, srs::dpar::parameters<>(proj_utm)(zone,22)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-206,172,-6,0,0,0,0))(units_m)(no_defs)},
            {22523, srs::dpar::parameters<>(proj_utm)(zone,23)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-206,172,-6,0,0,0,0))(units_m)(no_defs)},
            {22524, srs::dpar::parameters<>(proj_utm)(zone,24)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-206,172,-6,0,0,0,0))(units_m)(no_defs)},
            {22525, srs::dpar::parameters<>(proj_utm)(zone,25)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-206,172,-6,0,0,0,0))(units_m)(no_defs)},
            {22700, srs::dpar::parameters<>(proj_lcc)(lat_1,34.65)(lat_0,34.65)(lon_0,37.35)(k_0,0.9996256)(x_0,300000)(y_0,300000)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {22770, srs::dpar::parameters<>(proj_lcc)(lat_1,34.65)(lat_0,34.65)(lon_0,37.35)(k_0,0.9996256)(x_0,300000)(y_0,300000)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {22780, srs::dpar::parameters<>(proj_sterea)(lat_0,34.2)(lon_0,39.15)(k,0.9995341)(x_0,0)(y_0,0)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {22832, srs::dpar::parameters<>(proj_utm)(zone,32)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {22991, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,35)(k,1)(x_0,300000)(y_0,1100000)(ellps_helmert)(units_m)(no_defs)},
            {22992, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,31)(k,1)(x_0,615000)(y_0,810000)(ellps_helmert)(units_m)(no_defs)},
            {22993, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,27)(k,1)(x_0,700000)(y_0,200000)(ellps_helmert)(units_m)(no_defs)},
            {22994, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,27)(k,1)(x_0,700000)(y_0,1200000)(ellps_helmert)(units_m)(no_defs)},
            {23028, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_intl)(units_m)(no_defs)},
            {23029, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_intl)(units_m)(no_defs)},
            {23030, srs::dpar::parameters<>(proj_utm)(zone,30)(ellps_intl)(units_m)(no_defs)},
            {23031, srs::dpar::parameters<>(proj_utm)(zone,31)(ellps_intl)(units_m)(no_defs)},
            {23032, srs::dpar::parameters<>(proj_utm)(zone,32)(ellps_intl)(units_m)(no_defs)},
            {23033, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_intl)(units_m)(no_defs)},
            {23034, srs::dpar::parameters<>(proj_utm)(zone,34)(ellps_intl)(units_m)(no_defs)},
            {23035, srs::dpar::parameters<>(proj_utm)(zone,35)(ellps_intl)(units_m)(no_defs)},
            {23036, srs::dpar::parameters<>(proj_utm)(zone,36)(ellps_intl)(units_m)(no_defs)},
            {23037, srs::dpar::parameters<>(proj_utm)(zone,37)(ellps_intl)(units_m)(no_defs)},
            {23038, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_intl)(units_m)(no_defs)},
            {23090, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,0)(k,0.9996)(x_0,500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {23095, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,5)(k,0.9996)(x_0,500000)(y_0,0)(ellps_intl)(units_m)(no_defs)},
            {23239, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_clrk80)(units_m)(no_defs)},
            {23240, srs::dpar::parameters<>(proj_utm)(zone,40)(ellps_clrk80)(units_m)(no_defs)},
            {23433, srs::dpar::parameters<>(proj_utm)(zone,33)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {23700, srs::dpar::parameters<>(proj_somerc)(lat_0,47.14439372222222)(lon_0,19.04857177777778)(k_0,0.99993)(x_0,650000)(y_0,200000)(ellps_grs67)(units_m)(no_defs)},
            {23830, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,94.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23831, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,97.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23832, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,100.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23833, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,103.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23834, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,106.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23835, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,109.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23836, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,112.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23837, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,115.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23838, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,118.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23839, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,121.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23840, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,124.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23841, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,127.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23842, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,130.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23843, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,133.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23844, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,136.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23845, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,139.5)(k,0.9999)(x_0,200000)(y_0,1500000)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23846, srs::dpar::parameters<>(proj_utm)(zone,46)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23847, srs::dpar::parameters<>(proj_utm)(zone,47)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23848, srs::dpar::parameters<>(proj_utm)(zone,48)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23849, srs::dpar::parameters<>(proj_utm)(zone,49)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23850, srs::dpar::parameters<>(proj_utm)(zone,50)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23851, srs::dpar::parameters<>(proj_utm)(zone,51)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23852, srs::dpar::parameters<>(proj_utm)(zone,52)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23853, srs::dpar::parameters<>(proj_utm)(zone,53)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23866, srs::dpar::parameters<>(proj_utm)(zone,46)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23867, srs::dpar::parameters<>(proj_utm)(zone,47)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23868, srs::dpar::parameters<>(proj_utm)(zone,48)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23869, srs::dpar::parameters<>(proj_utm)(zone,49)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23870, srs::dpar::parameters<>(proj_utm)(zone,50)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23871, srs::dpar::parameters<>(proj_utm)(zone,51)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23872, srs::dpar::parameters<>(proj_utm)(zone,52)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23877, srs::dpar::parameters<>(proj_utm)(zone,47)(south)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23878, srs::dpar::parameters<>(proj_utm)(zone,48)(south)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23879, srs::dpar::parameters<>(proj_utm)(zone,49)(south)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23880, srs::dpar::parameters<>(proj_utm)(zone,50)(south)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23881, srs::dpar::parameters<>(proj_utm)(zone,51)(south)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23882, srs::dpar::parameters<>(proj_utm)(zone,52)(south)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23883, srs::dpar::parameters<>(proj_utm)(zone,53)(south)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23884, srs::dpar::parameters<>(proj_utm)(zone,54)(south)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {23886, srs::dpar::parameters<>(proj_utm)(zone,46)(south)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23887, srs::dpar::parameters<>(proj_utm)(zone,47)(south)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23888, srs::dpar::parameters<>(proj_utm)(zone,48)(south)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23889, srs::dpar::parameters<>(proj_utm)(zone,49)(south)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23890, srs::dpar::parameters<>(proj_utm)(zone,50)(south)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23891, srs::dpar::parameters<>(proj_utm)(zone,51)(south)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23892, srs::dpar::parameters<>(proj_utm)(zone,52)(south)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23893, srs::dpar::parameters<>(proj_utm)(zone,53)(south)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23894, srs::dpar::parameters<>(proj_utm)(zone,54)(south)(a,6378160)(b,6356774.50408554)(units_m)(no_defs)},
            {23946, srs::dpar::parameters<>(proj_utm)(zone,46)(a,6377276.345)(b,6356075.41314024)(towgs84,srs::detail::towgs84<>(217,823,299,0,0,0,0))(units_m)(no_defs)},
            {23947, srs::dpar::parameters<>(proj_utm)(zone,47)(a,6377276.345)(b,6356075.41314024)(towgs84,srs::detail::towgs84<>(217,823,299,0,0,0,0))(units_m)(no_defs)},
            {23948, srs::dpar::parameters<>(proj_utm)(zone,48)(a,6377276.345)(b,6356075.41314024)(towgs84,srs::detail::towgs84<>(217,823,299,0,0,0,0))(units_m)(no_defs)},
            {24047, srs::dpar::parameters<>(proj_utm)(zone,47)(a,6377276.345)(b,6356075.41314024)(units_m)(no_defs)},
            {24048, srs::dpar::parameters<>(proj_utm)(zone,48)(a,6377276.345)(b,6356075.41314024)(units_m)(no_defs)},
            {24100, srs::dpar::parameters<>(proj_lcc)(lat_1,18)(lat_0,18)(lon_0,-77)(k_0,1)(x_0,167638.49597)(y_0,121918.90616)(a,6378249.144808011)(b,6356514.966204134)(to_meter,0.3047972654)(no_defs)},
            {24200, srs::dpar::parameters<>(proj_lcc)(lat_1,18)(lat_0,18)(lon_0,-77)(k_0,1)(x_0,250000)(y_0,150000)(ellps_clrk66)(units_m)(no_defs)},
            {24305, srs::dpar::parameters<>(proj_utm)(zone,45)(a,6377276.345)(b,6356075.41314024)(units_m)(no_defs)},
            {24306, srs::dpar::parameters<>(proj_utm)(zone,46)(a,6377276.345)(b,6356075.41314024)(units_m)(no_defs)},
            {24311, srs::dpar::parameters<>(proj_utm)(zone,41)(a,6377301.243)(b,6356100.230165384)(units_m)(no_defs)},
            {24312, srs::dpar::parameters<>(proj_utm)(zone,42)(a,6377301.243)(b,6356100.230165384)(units_m)(no_defs)},
            {24313, srs::dpar::parameters<>(proj_utm)(zone,43)(a,6377301.243)(b,6356100.230165384)(units_m)(no_defs)},
            {24342, srs::dpar::parameters<>(proj_utm)(zone,42)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295,736,257,0,0,0,0))(units_m)(no_defs)},
            {24343, srs::dpar::parameters<>(proj_utm)(zone,43)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295,736,257,0,0,0,0))(units_m)(no_defs)},
            {24344, srs::dpar::parameters<>(proj_utm)(zone,44)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295,736,257,0,0,0,0))(units_m)(no_defs)},
            {24345, srs::dpar::parameters<>(proj_utm)(zone,45)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295,736,257,0,0,0,0))(units_m)(no_defs)},
            {24346, srs::dpar::parameters<>(proj_utm)(zone,46)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295,736,257,0,0,0,0))(units_m)(no_defs)},
            {24347, srs::dpar::parameters<>(proj_utm)(zone,47)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295,736,257,0,0,0,0))(units_m)(no_defs)},
            {24370, srs::dpar::parameters<>(proj_lcc)(lat_1,39.5)(lat_0,39.5)(lon_0,68)(k_0,0.99846154)(x_0,2153865.73916853)(y_0,2368292.194628102)(a,6377299.36559538)(b,6356098.359005157)(to_meter,0.9143985307444408)(no_defs)},
            {24371, srs::dpar::parameters<>(proj_lcc)(lat_1,32.5)(lat_0,32.5)(lon_0,68)(k_0,0.99878641)(x_0,2743195.592233322)(y_0,914398.5307444407)(a,6377299.36559538)(b,6356098.359005157)(to_meter,0.9143985307444408)(no_defs)},
            {24372, srs::dpar::parameters<>(proj_lcc)(lat_1,26)(lat_0,26)(lon_0,74)(k_0,0.99878641)(x_0,2743195.592233322)(y_0,914398.5307444407)(a,6377299.36559538)(b,6356098.359005157)(to_meter,0.9143985307444408)(no_defs)},
            {24373, srs::dpar::parameters<>(proj_lcc)(lat_1,19)(lat_0,19)(lon_0,80)(k_0,0.99878641)(x_0,2743195.592233322)(y_0,914398.5307444407)(a,6377299.36559538)(b,6356098.359005157)(to_meter,0.9143985307444408)(no_defs)},
            {24374, srs::dpar::parameters<>(proj_lcc)(lat_1,12)(lat_0,12)(lon_0,80)(k_0,0.99878641)(x_0,2743195.592233322)(y_0,914398.5307444407)(a,6377299.36559538)(b,6356098.359005157)(to_meter,0.9143985307444408)(no_defs)},
            {24375, srs::dpar::parameters<>(proj_lcc)(lat_1,26)(lat_0,26)(lon_0,90)(k_0,0.99878641)(x_0,2743185.69)(y_0,914395.23)(a,6377276.345)(b,6356075.41314024)(units_m)(no_defs)},
            {24376, srs::dpar::parameters<>(proj_lcc)(lat_1,32.5)(lat_0,32.5)(lon_0,68)(k_0,0.99878641)(x_0,2743196.4)(y_0,914398.8)(a,6377301.243)(b,6356100.230165384)(units_m)(no_defs)},
            {24377, srs::dpar::parameters<>(proj_lcc)(lat_1,26)(lat_0,26)(lon_0,74)(k_0,0.99878641)(x_0,2743196.4)(y_0,914398.8)(a,6377301.243)(b,6356100.230165384)(units_m)(no_defs)},
            {24378, srs::dpar::parameters<>(proj_lcc)(lat_1,32.5)(lat_0,32.5)(lon_0,68)(k_0,0.99878641)(x_0,2743195.5)(y_0,914398.5)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295,736,257,0,0,0,0))(units_m)(no_defs)},
            {24379, srs::dpar::parameters<>(proj_lcc)(lat_1,26)(lat_0,26)(lon_0,74)(k_0,0.99878641)(x_0,2743195.5)(y_0,914398.5)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295,736,257,0,0,0,0))(units_m)(no_defs)},
            {24380, srs::dpar::parameters<>(proj_lcc)(lat_1,26)(lat_0,26)(lon_0,90)(k_0,0.99878641)(x_0,2743195.5)(y_0,914398.5)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295,736,257,0,0,0,0))(units_m)(no_defs)},
            {24381, srs::dpar::parameters<>(proj_lcc)(lat_1,19)(lat_0,19)(lon_0,80)(k_0,0.99878641)(x_0,2743195.5)(y_0,914398.5)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295,736,257,0,0,0,0))(units_m)(no_defs)},
            {24382, srs::dpar::parameters<>(proj_lcc)(lat_1,26)(lat_0,26)(lon_0,90)(k_0,0.99878641)(x_0,2743195.592233322)(y_0,914398.5307444407)(a,6377299.36559538)(b,6356098.359005157)(to_meter,0.9143985307444408)(no_defs)},
            {24383, srs::dpar::parameters<>(proj_lcc)(lat_1,12)(lat_0,12)(lon_0,80)(k_0,0.99878641)(x_0,2743195.5)(y_0,914398.5)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295,736,257,0,0,0,0))(units_m)(no_defs)},
            {24500, srs::dpar::parameters<>(proj_cass)(lat_0,1.287646666666667)(lon_0,103.8530022222222)(x_0,30000)(y_0,30000)(a,6377304.063)(b,6356103.038993155)(towgs84,srs::detail::towgs84<>(-11,851,5,0,0,0,0))(units_m)(no_defs)},
            {24547, srs::dpar::parameters<>(proj_utm)(zone,47)(a,6377304.063)(b,6356103.038993155)(towgs84,srs::detail::towgs84<>(-11,851,5,0,0,0,0))(units_m)(no_defs)},
            {24548, srs::dpar::parameters<>(proj_utm)(zone,48)(a,6377304.063)(b,6356103.038993155)(towgs84,srs::detail::towgs84<>(-11,851,5,0,0,0,0))(units_m)(no_defs)},
            {24571, srs::dpar::parameters<>(proj_omerc)(lat_0,4)(lonc,102.25)(alpha,323.0257905)(k,0.99984)(x_0,804671.2997750348)(y_0,0)(a,6377304.063)(b,6356103.038993155)(towgs84,srs::detail::towgs84<>(-11,851,5,0,0,0,0))(to_meter,20.11678249437587)(no_defs)},
            {24600, srs::dpar::parameters<>(proj_lcc)(lat_1,32.5)(lat_0,32.5)(lon_0,45)(k_0,0.9987864078000001)(x_0,1500000)(y_0,1166200)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-294.7,-200.1,525.5,0,0,0,0))(units_m)(no_defs)},
            {24718, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_intl)(towgs84,srs::detail::towgs84<>(-273.5,110.6,-357.9,0,0,0,0))(units_m)(no_defs)},
            {24719, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_intl)(towgs84,srs::detail::towgs84<>(-273.5,110.6,-357.9,0,0,0,0))(units_m)(no_defs)},
            {24720, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_intl)(towgs84,srs::detail::towgs84<>(-273.5,110.6,-357.9,0,0,0,0))(units_m)(no_defs)},
            {24817, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_intl)(units_m)(no_defs)},
            {24818, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_intl)(units_m)(no_defs)},
            {24819, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_intl)(units_m)(no_defs)},
            {24820, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_intl)(units_m)(no_defs)},
            {24821, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_intl)(units_m)(no_defs)},
            {24877, srs::dpar::parameters<>(proj_utm)(zone,17)(south)(ellps_intl)(units_m)(no_defs)},
            {24878, srs::dpar::parameters<>(proj_utm)(zone,18)(south)(ellps_intl)(units_m)(no_defs)},
            {24879, srs::dpar::parameters<>(proj_utm)(zone,19)(south)(ellps_intl)(units_m)(no_defs)},
            {24880, srs::dpar::parameters<>(proj_utm)(zone,20)(south)(ellps_intl)(units_m)(no_defs)},
            {24881, srs::dpar::parameters<>(proj_utm)(zone,21)(south)(ellps_intl)(units_m)(no_defs)},
            {24882, srs::dpar::parameters<>(proj_utm)(zone,22)(south)(ellps_intl)(units_m)(no_defs)},
            {24891, srs::dpar::parameters<>(proj_tmerc)(lat_0,-6)(lon_0,-80.5)(k,0.99983008)(x_0,222000)(y_0,1426834.743)(ellps_intl)(units_m)(no_defs)},
            {24892, srs::dpar::parameters<>(proj_tmerc)(lat_0,-9.5)(lon_0,-76)(k,0.99932994)(x_0,720000)(y_0,1039979.159)(ellps_intl)(units_m)(no_defs)},
            {24893, srs::dpar::parameters<>(proj_tmerc)(lat_0,-9.5)(lon_0,-70.5)(k,0.99952992)(x_0,1324000)(y_0,1040084.558)(ellps_intl)(units_m)(no_defs)},
            {25000, srs::dpar::parameters<>(proj_tmerc)(lat_0,4.666666666666667)(lon_0,-1)(k,0.99975)(x_0,274319.51)(y_0,0)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-130,29,364,0,0,0,0))(units_m)(no_defs)},
            {25231, srs::dpar::parameters<>(proj_utm)(zone,31)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {25391, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,0.99995)(x_0,500000)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {25392, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,119)(k,0.99995)(x_0,500000)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {25393, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,121)(k,0.99995)(x_0,500000)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {25394, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,0.99995)(x_0,500000)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {25395, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,125)(k,0.99995)(x_0,500000)(y_0,0)(ellps_clrk66)(units_m)(no_defs)},
            {25700, srs::dpar::parameters<>(proj_merc)(lon_0,110)(k,0.997)(x_0,3900000)(y_0,900000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(-587.8,519.75,145.76,0,0,0,0))(pm_jakarta)(units_m)(no_defs)},
            {25828, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_grs80)(units_m)(no_defs)},
            {25829, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_grs80)(units_m)(no_defs)},
            {25830, srs::dpar::parameters<>(proj_utm)(zone,30)(ellps_grs80)(units_m)(no_defs)},
            {25831, srs::dpar::parameters<>(proj_utm)(zone,31)(ellps_grs80)(units_m)(no_defs)},
            {25832, srs::dpar::parameters<>(proj_utm)(zone,32)(ellps_grs80)(units_m)(no_defs)},
            {25833, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_grs80)(units_m)(no_defs)},
            {25834, srs::dpar::parameters<>(proj_utm)(zone,34)(ellps_grs80)(units_m)(no_defs)},
            {25835, srs::dpar::parameters<>(proj_utm)(zone,35)(ellps_grs80)(units_m)(no_defs)},
            {25836, srs::dpar::parameters<>(proj_utm)(zone,36)(ellps_grs80)(units_m)(no_defs)},
            {25837, srs::dpar::parameters<>(proj_utm)(zone,37)(ellps_grs80)(units_m)(no_defs)},
            {25838, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_grs80)(units_m)(no_defs)},
            {25884, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,0.9996)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {25932, srs::dpar::parameters<>(proj_utm)(zone,32)(south)(ellps_intl)(units_m)(no_defs)},
            {26191, srs::dpar::parameters<>(proj_lcc)(lat_1,33.3)(lat_0,33.3)(lon_0,-5.4)(k_0,0.999625769)(x_0,500000)(y_0,300000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(31,146,47,0,0,0,0))(units_m)(no_defs)},
            {26192, srs::dpar::parameters<>(proj_lcc)(lat_1,29.7)(lat_0,29.7)(lon_0,-5.4)(k_0,0.9996155960000001)(x_0,500000)(y_0,300000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(31,146,47,0,0,0,0))(units_m)(no_defs)},
            {26193, srs::dpar::parameters<>(proj_lcc)(lat_1,26.1)(lat_0,26.1)(lon_0,-5.4)(k_0,0.9996)(x_0,1200000)(y_0,400000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(31,146,47,0,0,0,0))(units_m)(no_defs)},
            {26194, srs::dpar::parameters<>(proj_lcc)(lat_1,26.1)(lat_0,26.1)(lon_0,-5.4)(k_0,0.999616304)(x_0,1200000)(y_0,400000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(31,146,47,0,0,0,0))(units_m)(no_defs)},
            {26195, srs::dpar::parameters<>(proj_lcc)(lat_1,22.5)(lat_0,22.5)(lon_0,-5.4)(k_0,0.999616437)(x_0,1500000)(y_0,400000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(31,146,47,0,0,0,0))(units_m)(no_defs)},
            {26237, srs::dpar::parameters<>(proj_utm)(zone,37)(ellps_bessel)(towgs84,srs::detail::towgs84<>(639,405,60,0,0,0,0))(units_m)(no_defs)},
            {26331, srs::dpar::parameters<>(proj_utm)(zone,31)(ellps_clrk80)(units_m)(no_defs)},
            {26332, srs::dpar::parameters<>(proj_utm)(zone,32)(ellps_clrk80)(units_m)(no_defs)},
            {26391, srs::dpar::parameters<>(proj_tmerc)(lat_0,4)(lon_0,4.5)(k,0.99975)(x_0,230738.26)(y_0,0)(ellps_clrk80)(units_m)(no_defs)},
            {26392, srs::dpar::parameters<>(proj_tmerc)(lat_0,4)(lon_0,8.5)(k,0.99975)(x_0,670553.98)(y_0,0)(ellps_clrk80)(units_m)(no_defs)},
            {26393, srs::dpar::parameters<>(proj_tmerc)(lat_0,4)(lon_0,12.5)(k,0.99975)(x_0,1110369.7)(y_0,0)(ellps_clrk80)(units_m)(no_defs)},
            {26432, srs::dpar::parameters<>(proj_utm)(zone,32)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-252.95,-4.11,-96.38,0,0,0,0))(units_m)(no_defs)},
            {26591, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-3.45233333333333)(k,0.9996)(x_0,1500000)(y_0,0)(ellps_intl)(pm_rome)(units_m)(no_defs)},
            {26592, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,2.54766666666666)(k,0.9996)(x_0,2520000)(y_0,0)(ellps_intl)(pm_rome)(units_m)(no_defs)},
            {26632, srs::dpar::parameters<>(proj_utm)(zone,32)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {26692, srs::dpar::parameters<>(proj_utm)(zone,32)(south)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {26701, srs::dpar::parameters<>(proj_utm)(zone,1)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26702, srs::dpar::parameters<>(proj_utm)(zone,2)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26703, srs::dpar::parameters<>(proj_utm)(zone,3)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26704, srs::dpar::parameters<>(proj_utm)(zone,4)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26705, srs::dpar::parameters<>(proj_utm)(zone,5)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26706, srs::dpar::parameters<>(proj_utm)(zone,6)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26707, srs::dpar::parameters<>(proj_utm)(zone,7)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26708, srs::dpar::parameters<>(proj_utm)(zone,8)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26709, srs::dpar::parameters<>(proj_utm)(zone,9)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26710, srs::dpar::parameters<>(proj_utm)(zone,10)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26711, srs::dpar::parameters<>(proj_utm)(zone,11)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26712, srs::dpar::parameters<>(proj_utm)(zone,12)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26713, srs::dpar::parameters<>(proj_utm)(zone,13)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26714, srs::dpar::parameters<>(proj_utm)(zone,14)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26715, srs::dpar::parameters<>(proj_utm)(zone,15)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26716, srs::dpar::parameters<>(proj_utm)(zone,16)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26717, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26718, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26719, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26720, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26721, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26722, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {26729, srs::dpar::parameters<>(proj_tmerc)(lat_0,30.5)(lon_0,-85.83333333333333)(k,0.99996)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26730, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-87.5)(k,0.999933333)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26731, srs::dpar::parameters<>(proj_omerc)(lat_0,57)(lonc,-133.6666666666667)(alpha,323.1301023611111)(k,0.9999)(x_0,5000000.001016002)(y_0,-5000000.001016002)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26732, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-142)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26733, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-146)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26734, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-150)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26735, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-154)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26736, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-158)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26737, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-162)(k,0.9999)(x_0,213360.4267208534)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26738, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-166)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26739, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-170)(k,0.9999)(x_0,182880.3657607315)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26740, srs::dpar::parameters<>(proj_lcc)(lat_1,53.83333333333334)(lat_2,51.83333333333334)(lat_0,51)(lon_0,-176)(x_0,914401.8288036576)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26741, srs::dpar::parameters<>(proj_lcc)(lat_1,41.66666666666666)(lat_2,40)(lat_0,39.33333333333334)(lon_0,-122)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26742, srs::dpar::parameters<>(proj_lcc)(lat_1,39.83333333333334)(lat_2,38.33333333333334)(lat_0,37.66666666666666)(lon_0,-122)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26743, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.06666666666667)(lat_0,36.5)(lon_0,-120.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26744, srs::dpar::parameters<>(proj_lcc)(lat_1,37.25)(lat_2,36)(lat_0,35.33333333333334)(lon_0,-119)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26745, srs::dpar::parameters<>(proj_lcc)(lat_1,35.46666666666667)(lat_2,34.03333333333333)(lat_0,33.5)(lon_0,-118)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26746, srs::dpar::parameters<>(proj_lcc)(lat_1,33.88333333333333)(lat_2,32.78333333333333)(lat_0,32.16666666666666)(lon_0,-116.25)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26747, srs::dpar::parameters<>(proj_lcc)(lat_1,34.41666666666666)(lat_2,33.86666666666667)(lat_0,34.13333333333333)(lon_0,-118.3333333333333)(x_0,1276106.450596901)(y_0,127079.524511049)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26748, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-110.1666666666667)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26749, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-111.9166666666667)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26750, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-113.75)(k,0.999933333)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26751, srs::dpar::parameters<>(proj_lcc)(lat_1,36.23333333333333)(lat_2,34.93333333333333)(lat_0,34.33333333333334)(lon_0,-92)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26752, srs::dpar::parameters<>(proj_lcc)(lat_1,34.76666666666667)(lat_2,33.3)(lat_0,32.66666666666666)(lon_0,-92)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26753, srs::dpar::parameters<>(proj_lcc)(lat_1,39.71666666666667)(lat_2,40.78333333333333)(lat_0,39.33333333333334)(lon_0,-105.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26754, srs::dpar::parameters<>(proj_lcc)(lat_1,39.75)(lat_2,38.45)(lat_0,37.83333333333334)(lon_0,-105.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26755, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.23333333333333)(lat_0,36.66666666666666)(lon_0,-105.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26756, srs::dpar::parameters<>(proj_lcc)(lat_1,41.86666666666667)(lat_2,41.2)(lat_0,40.83333333333334)(lon_0,-72.75)(x_0,182880.3657607315)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26757, srs::dpar::parameters<>(proj_tmerc)(lat_0,38)(lon_0,-75.41666666666667)(k,0.999995)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26758, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-81)(k,0.999941177)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26759, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-82)(k,0.999941177)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26760, srs::dpar::parameters<>(proj_lcc)(lat_1,30.75)(lat_2,29.58333333333333)(lat_0,29)(lon_0,-84.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26766, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-82.16666666666667)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26767, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-84.16666666666667)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26768, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-112.1666666666667)(k,0.9999473679999999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26769, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-114)(k,0.9999473679999999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26770, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-115.75)(k,0.999933333)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26771, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-88.33333333333333)(k,0.9999749999999999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26772, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-90.16666666666667)(k,0.999941177)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26773, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-85.66666666666667)(k,0.999966667)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26774, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-87.08333333333333)(k,0.999966667)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26775, srs::dpar::parameters<>(proj_lcc)(lat_1,43.26666666666667)(lat_2,42.06666666666667)(lat_0,41.5)(lon_0,-93.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26776, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.61666666666667)(lat_0,40)(lon_0,-93.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26777, srs::dpar::parameters<>(proj_lcc)(lat_1,39.78333333333333)(lat_2,38.71666666666667)(lat_0,38.33333333333334)(lon_0,-98)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26778, srs::dpar::parameters<>(proj_lcc)(lat_1,38.56666666666667)(lat_2,37.26666666666667)(lat_0,36.66666666666666)(lon_0,-98.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26779, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,38.96666666666667)(lat_0,37.5)(lon_0,-84.25)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26780, srs::dpar::parameters<>(proj_lcc)(lat_1,36.73333333333333)(lat_2,37.93333333333333)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26781, srs::dpar::parameters<>(proj_lcc)(lat_1,31.16666666666667)(lat_2,32.66666666666666)(lat_0,30.66666666666667)(lon_0,-92.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26782, srs::dpar::parameters<>(proj_lcc)(lat_1,29.3)(lat_2,30.7)(lat_0,28.66666666666667)(lon_0,-91.33333333333333)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26783, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.83333333333334)(lon_0,-68.5)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26784, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.16666666666667)(k,0.999966667)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26785, srs::dpar::parameters<>(proj_lcc)(lat_1,38.3)(lat_2,39.45)(lat_0,37.83333333333334)(lon_0,-77)(x_0,243840.4876809754)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26786, srs::dpar::parameters<>(proj_lcc)(lat_1,41.71666666666667)(lat_2,42.68333333333333)(lat_0,41)(lon_0,-71.5)(x_0,182880.3657607315)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26787, srs::dpar::parameters<>(proj_lcc)(lat_1,41.28333333333333)(lat_2,41.48333333333333)(lat_0,41)(lon_0,-70.5)(x_0,60960.12192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26791, srs::dpar::parameters<>(proj_lcc)(lat_1,47.03333333333333)(lat_2,48.63333333333333)(lat_0,46.5)(lon_0,-93.09999999999999)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26792, srs::dpar::parameters<>(proj_lcc)(lat_1,45.61666666666667)(lat_2,47.05)(lat_0,45)(lon_0,-94.25)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26793, srs::dpar::parameters<>(proj_lcc)(lat_1,43.78333333333333)(lat_2,45.21666666666667)(lat_0,43)(lon_0,-94)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26794, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.66666666666667)(lon_0,-88.83333333333333)(k,0.99996)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26795, srs::dpar::parameters<>(proj_tmerc)(lat_0,30.5)(lon_0,-90.33333333333333)(k,0.999941177)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26796, srs::dpar::parameters<>(proj_tmerc)(lat_0,35.83333333333334)(lon_0,-90.5)(k,0.999933333)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26797, srs::dpar::parameters<>(proj_tmerc)(lat_0,35.83333333333334)(lon_0,-92.5)(k,0.999933333)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26798, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.16666666666666)(lon_0,-94.5)(k,0.999941177)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26799, srs::dpar::parameters<>(proj_lcc)(lat_1,34.41666666666666)(lat_2,33.86666666666667)(lat_0,34.13333333333333)(lon_0,-118.3333333333333)(x_0,1276106.450596901)(y_0,1268253.006858014)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {26801, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.5)(lon_0,-83.66666666666667)(k,0.999942857)(x_0,152400.3048006096)(y_0,0)(a,6378450.047548896)(b,6356826.621488444)(to_meter,0.3048006096012192)(no_defs)},
            {26802, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.5)(lon_0,-85.75)(k,0.999909091)(x_0,152400.3048006096)(y_0,0)(a,6378450.047548896)(b,6356826.621488444)(to_meter,0.3048006096012192)(no_defs)},
            {26803, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.5)(lon_0,-88.75)(k,0.999909091)(x_0,152400.3048006096)(y_0,0)(a,6378450.047548896)(b,6356826.621488444)(to_meter,0.3048006096012192)(no_defs)},
            {26811, srs::dpar::parameters<>(proj_lcc)(lat_1,45.48333333333333)(lat_2,47.08333333333334)(lat_0,44.78333333333333)(lon_0,-87)(x_0,609601.2192024384)(y_0,0)(a,6378450.047548896)(b,6356826.621488444)(to_meter,0.3048006096012192)(no_defs)},
            {26812, srs::dpar::parameters<>(proj_lcc)(lat_1,44.18333333333333)(lat_2,45.7)(lat_0,43.31666666666667)(lon_0,-84.33333333333333)(x_0,609601.2192024384)(y_0,0)(a,6378450.047548896)(b,6356826.621488444)(to_meter,0.3048006096012192)(no_defs)},
            {26813, srs::dpar::parameters<>(proj_lcc)(lat_1,42.1)(lat_2,43.66666666666666)(lat_0,41.5)(lon_0,-84.33333333333333)(x_0,609601.2192024384)(y_0,0)(a,6378450.047548896)(b,6356826.621488444)(to_meter,0.3048006096012192)(no_defs)},
            {26814, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.66666666666666)(lon_0,-68.5)(k,0.9999)(x_0,300000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26815, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.16666666666667)(k,0.999966667)(x_0,900000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26819, srs::dpar::parameters<>(proj_lcc)(lat_1,48.63333333333333)(lat_2,47.03333333333333)(lat_0,46.5)(lon_0,-93.09999999999999)(x_0,800000.0000101601)(y_0,99999.99998984)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26820, srs::dpar::parameters<>(proj_lcc)(lat_1,47.05)(lat_2,45.61666666666667)(lat_0,45)(lon_0,-94.25)(x_0,800000.0000101601)(y_0,99999.99998984)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26821, srs::dpar::parameters<>(proj_lcc)(lat_1,45.21666666666667)(lat_2,43.78333333333333)(lat_0,43)(lon_0,-94)(x_0,800000.0000101601)(y_0,99999.99998984)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26822, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,40)(lat_0,39.83333333333334)(lon_0,-100)(x_0,500000.0000101601)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26823, srs::dpar::parameters<>(proj_lcc)(lat_1,40.25)(lat_2,39)(lat_0,38.5)(lon_0,-79.5)(x_0,1968500)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26824, srs::dpar::parameters<>(proj_lcc)(lat_1,38.88333333333333)(lat_2,37.48333333333333)(lat_0,37)(lon_0,-81)(x_0,1968500)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26825, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.66666666666666)(lon_0,-68.5)(k,0.9999)(x_0,300000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26826, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.16666666666667)(k,0.999966667)(x_0,900000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26830, srs::dpar::parameters<>(proj_lcc)(lat_1,48.63333333333333)(lat_2,47.03333333333333)(lat_0,46.5)(lon_0,-93.09999999999999)(x_0,800000.0000101601)(y_0,99999.99998984)(ellps_grs80)(units_m)(no_defs)},
            {26831, srs::dpar::parameters<>(proj_lcc)(lat_1,47.05)(lat_2,45.61666666666667)(lat_0,45)(lon_0,-94.25)(x_0,800000.0000101601)(y_0,99999.99998984)(ellps_grs80)(units_m)(no_defs)},
            {26832, srs::dpar::parameters<>(proj_lcc)(lat_1,45.21666666666667)(lat_2,43.78333333333333)(lat_0,43)(lon_0,-94)(x_0,800000.0000101601)(y_0,99999.99998984)(ellps_grs80)(units_m)(no_defs)},
            {26833, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,40)(lat_0,39.83333333333334)(lon_0,-100)(x_0,500000.0000101601)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26834, srs::dpar::parameters<>(proj_lcc)(lat_1,40.25)(lat_2,39)(lat_0,38.5)(lon_0,-79.5)(x_0,1968500)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26835, srs::dpar::parameters<>(proj_lcc)(lat_1,38.88333333333333)(lat_2,37.48333333333333)(lat_0,37)(lon_0,-81)(x_0,1968500)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26836, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.66666666666666)(lon_0,-68.5)(k,0.9999)(x_0,300000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {26837, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.16666666666667)(k,0.999966667)(x_0,900000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {26841, srs::dpar::parameters<>(proj_lcc)(lat_1,48.63333333333333)(lat_2,47.03333333333333)(lat_0,46.5)(lon_0,-93.09999999999999)(x_0,800000.0000101601)(y_0,99999.99998984)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {26842, srs::dpar::parameters<>(proj_lcc)(lat_1,47.05)(lat_2,45.61666666666667)(lat_0,45)(lon_0,-94.25)(x_0,800000.0000101601)(y_0,99999.99998984)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {26843, srs::dpar::parameters<>(proj_lcc)(lat_1,45.21666666666667)(lat_2,43.78333333333333)(lat_0,43)(lon_0,-94)(x_0,800000.0000101601)(y_0,99999.99998984)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {26844, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,40)(lat_0,39.83333333333334)(lon_0,-100)(x_0,500000.0000101601)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {26845, srs::dpar::parameters<>(proj_lcc)(lat_1,40.25)(lat_2,39)(lat_0,38.5)(lon_0,-79.5)(x_0,1968500)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {26846, srs::dpar::parameters<>(proj_lcc)(lat_1,38.88333333333333)(lat_2,37.48333333333333)(lat_0,37)(lon_0,-81)(x_0,1968500)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {26847, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.66666666666666)(lon_0,-68.5)(k,0.9999)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {26848, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.16666666666667)(k,0.999966667)(x_0,900000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {26849, srs::dpar::parameters<>(proj_lcc)(lat_1,48.63333333333333)(lat_2,47.03333333333333)(lat_0,46.5)(lon_0,-93.09999999999999)(x_0,800000.0000101599)(y_0,99999.99998983997)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {26850, srs::dpar::parameters<>(proj_lcc)(lat_1,47.05)(lat_2,45.61666666666667)(lat_0,45)(lon_0,-94.25)(x_0,800000.0000101599)(y_0,99999.99998983997)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {26851, srs::dpar::parameters<>(proj_lcc)(lat_1,45.21666666666667)(lat_2,43.78333333333333)(lat_0,43)(lon_0,-94)(x_0,800000.0000101599)(y_0,99999.99998983997)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {26852, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,40)(lat_0,39.83333333333334)(lon_0,-100)(x_0,500000.00001016)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {26853, srs::dpar::parameters<>(proj_lcc)(lat_1,40.25)(lat_2,39)(lat_0,38.5)(lon_0,-79.5)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {26854, srs::dpar::parameters<>(proj_lcc)(lat_1,38.88333333333333)(lat_2,37.48333333333333)(lat_0,37)(lon_0,-81)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {26855, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.66666666666666)(lon_0,-68.5)(k,0.9999)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {26856, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.16666666666667)(k,0.999966667)(x_0,900000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {26857, srs::dpar::parameters<>(proj_lcc)(lat_1,48.63333333333333)(lat_2,47.03333333333333)(lat_0,46.5)(lon_0,-93.09999999999999)(x_0,800000.0000101599)(y_0,99999.99998983997)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {26858, srs::dpar::parameters<>(proj_lcc)(lat_1,47.05)(lat_2,45.61666666666667)(lat_0,45)(lon_0,-94.25)(x_0,800000.0000101599)(y_0,99999.99998983997)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {26859, srs::dpar::parameters<>(proj_lcc)(lat_1,45.21666666666667)(lat_2,43.78333333333333)(lat_0,43)(lon_0,-94)(x_0,800000.0000101599)(y_0,99999.99998983997)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {26860, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,40)(lat_0,39.83333333333334)(lon_0,-100)(x_0,500000.00001016)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {26861, srs::dpar::parameters<>(proj_lcc)(lat_1,40.25)(lat_2,39)(lat_0,38.5)(lon_0,-79.5)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {26862, srs::dpar::parameters<>(proj_lcc)(lat_1,38.88333333333333)(lat_2,37.48333333333333)(lat_0,37)(lon_0,-81)(x_0,600000)(y_0,0)(ellps_grs80)(to_meter,0.3048006096012192)(no_defs)},
            {26863, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.66666666666666)(lon_0,-68.5)(k,0.9999)(x_0,300000.0000000001)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {26864, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.16666666666667)(k,0.999966667)(x_0,900000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {26865, srs::dpar::parameters<>(proj_lcc)(lat_1,48.63333333333333)(lat_2,47.03333333333333)(lat_0,46.5)(lon_0,-93.09999999999999)(x_0,800000.0000101599)(y_0,99999.99998983997)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {26866, srs::dpar::parameters<>(proj_lcc)(lat_1,47.05)(lat_2,45.61666666666667)(lat_0,45)(lon_0,-94.25)(x_0,800000.0000101599)(y_0,99999.99998983997)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {26867, srs::dpar::parameters<>(proj_lcc)(lat_1,45.21666666666667)(lat_2,43.78333333333333)(lat_0,43)(lon_0,-94)(x_0,800000.0000101599)(y_0,99999.99998983997)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {26868, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,40)(lat_0,39.83333333333334)(lon_0,-100)(x_0,500000.00001016)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {26869, srs::dpar::parameters<>(proj_lcc)(lat_1,40.25)(lat_2,39)(lat_0,38.5)(lon_0,-79.5)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {26870, srs::dpar::parameters<>(proj_lcc)(lat_1,38.88333333333333)(lat_2,37.48333333333333)(lat_0,37)(lon_0,-81)(x_0,600000)(y_0,0)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(to_meter,0.3048006096012192)(no_defs)},
            {26891, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-82.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26892, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-81)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26893, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-84)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26894, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-87)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26895, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-90)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26896, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-93)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26897, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-96)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26898, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-53)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26899, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-56)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {26901, srs::dpar::parameters<>(proj_utm)(zone,1)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26902, srs::dpar::parameters<>(proj_utm)(zone,2)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26903, srs::dpar::parameters<>(proj_utm)(zone,3)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26904, srs::dpar::parameters<>(proj_utm)(zone,4)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26905, srs::dpar::parameters<>(proj_utm)(zone,5)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26906, srs::dpar::parameters<>(proj_utm)(zone,6)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26907, srs::dpar::parameters<>(proj_utm)(zone,7)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26908, srs::dpar::parameters<>(proj_utm)(zone,8)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26909, srs::dpar::parameters<>(proj_utm)(zone,9)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26910, srs::dpar::parameters<>(proj_utm)(zone,10)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26911, srs::dpar::parameters<>(proj_utm)(zone,11)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26912, srs::dpar::parameters<>(proj_utm)(zone,12)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26913, srs::dpar::parameters<>(proj_utm)(zone,13)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26914, srs::dpar::parameters<>(proj_utm)(zone,14)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26915, srs::dpar::parameters<>(proj_utm)(zone,15)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26916, srs::dpar::parameters<>(proj_utm)(zone,16)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26917, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26918, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26919, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26920, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26921, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26922, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26923, srs::dpar::parameters<>(proj_utm)(zone,23)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26929, srs::dpar::parameters<>(proj_tmerc)(lat_0,30.5)(lon_0,-85.83333333333333)(k,0.99996)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26930, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-87.5)(k,0.999933333)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26931, srs::dpar::parameters<>(proj_omerc)(lat_0,57)(lonc,-133.6666666666667)(alpha,323.1301023611111)(k,0.9999)(x_0,5000000)(y_0,-5000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26932, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-142)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26933, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-146)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26934, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-150)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26935, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-154)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26936, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-158)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26937, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-162)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26938, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-166)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26939, srs::dpar::parameters<>(proj_tmerc)(lat_0,54)(lon_0,-170)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26940, srs::dpar::parameters<>(proj_lcc)(lat_1,53.83333333333334)(lat_2,51.83333333333334)(lat_0,51)(lon_0,-176)(x_0,1000000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26941, srs::dpar::parameters<>(proj_lcc)(lat_1,41.66666666666666)(lat_2,40)(lat_0,39.33333333333334)(lon_0,-122)(x_0,2000000)(y_0,500000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26942, srs::dpar::parameters<>(proj_lcc)(lat_1,39.83333333333334)(lat_2,38.33333333333334)(lat_0,37.66666666666666)(lon_0,-122)(x_0,2000000)(y_0,500000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26943, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.06666666666667)(lat_0,36.5)(lon_0,-120.5)(x_0,2000000)(y_0,500000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26944, srs::dpar::parameters<>(proj_lcc)(lat_1,37.25)(lat_2,36)(lat_0,35.33333333333334)(lon_0,-119)(x_0,2000000)(y_0,500000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26945, srs::dpar::parameters<>(proj_lcc)(lat_1,35.46666666666667)(lat_2,34.03333333333333)(lat_0,33.5)(lon_0,-118)(x_0,2000000)(y_0,500000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26946, srs::dpar::parameters<>(proj_lcc)(lat_1,33.88333333333333)(lat_2,32.78333333333333)(lat_0,32.16666666666666)(lon_0,-116.25)(x_0,2000000)(y_0,500000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26948, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-110.1666666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26949, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-111.9166666666667)(k,0.9999)(x_0,213360)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26950, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-113.75)(k,0.999933333)(x_0,213360)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26951, srs::dpar::parameters<>(proj_lcc)(lat_1,36.23333333333333)(lat_2,34.93333333333333)(lat_0,34.33333333333334)(lon_0,-92)(x_0,400000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26952, srs::dpar::parameters<>(proj_lcc)(lat_1,34.76666666666667)(lat_2,33.3)(lat_0,32.66666666666666)(lon_0,-92)(x_0,400000)(y_0,400000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26953, srs::dpar::parameters<>(proj_lcc)(lat_1,40.78333333333333)(lat_2,39.71666666666667)(lat_0,39.33333333333334)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26954, srs::dpar::parameters<>(proj_lcc)(lat_1,39.75)(lat_2,38.45)(lat_0,37.83333333333334)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26955, srs::dpar::parameters<>(proj_lcc)(lat_1,38.43333333333333)(lat_2,37.23333333333333)(lat_0,36.66666666666666)(lon_0,-105.5)(x_0,914401.8289)(y_0,304800.6096)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26956, srs::dpar::parameters<>(proj_lcc)(lat_1,41.86666666666667)(lat_2,41.2)(lat_0,40.83333333333334)(lon_0,-72.75)(x_0,304800.6096)(y_0,152400.3048)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26957, srs::dpar::parameters<>(proj_tmerc)(lat_0,38)(lon_0,-75.41666666666667)(k,0.999995)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26958, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-81)(k,0.999941177)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26959, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.33333333333333)(lon_0,-82)(k,0.999941177)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26960, srs::dpar::parameters<>(proj_lcc)(lat_1,30.75)(lat_2,29.58333333333333)(lat_0,29)(lon_0,-84.5)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26961, srs::dpar::parameters<>(proj_tmerc)(lat_0,18.83333333333333)(lon_0,-155.5)(k,0.999966667)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26962, srs::dpar::parameters<>(proj_tmerc)(lat_0,20.33333333333333)(lon_0,-156.6666666666667)(k,0.999966667)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26963, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.16666666666667)(lon_0,-158)(k,0.99999)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26964, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.83333333333333)(lon_0,-159.5)(k,0.99999)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26965, srs::dpar::parameters<>(proj_tmerc)(lat_0,21.66666666666667)(lon_0,-160.1666666666667)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26966, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-82.16666666666667)(k,0.9999)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26967, srs::dpar::parameters<>(proj_tmerc)(lat_0,30)(lon_0,-84.16666666666667)(k,0.9999)(x_0,700000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26968, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-112.1666666666667)(k,0.9999473679999999)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26969, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-114)(k,0.9999473679999999)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26970, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.66666666666666)(lon_0,-115.75)(k,0.999933333)(x_0,800000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26971, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-88.33333333333333)(k,0.9999749999999999)(x_0,300000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26972, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.66666666666666)(lon_0,-90.16666666666667)(k,0.999941177)(x_0,700000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26973, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-85.66666666666667)(k,0.999966667)(x_0,100000)(y_0,250000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26974, srs::dpar::parameters<>(proj_tmerc)(lat_0,37.5)(lon_0,-87.08333333333333)(k,0.999966667)(x_0,900000)(y_0,250000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26975, srs::dpar::parameters<>(proj_lcc)(lat_1,43.26666666666667)(lat_2,42.06666666666667)(lat_0,41.5)(lon_0,-93.5)(x_0,1500000)(y_0,1000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26976, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.61666666666667)(lat_0,40)(lon_0,-93.5)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26977, srs::dpar::parameters<>(proj_lcc)(lat_1,39.78333333333333)(lat_2,38.71666666666667)(lat_0,38.33333333333334)(lon_0,-98)(x_0,400000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26978, srs::dpar::parameters<>(proj_lcc)(lat_1,38.56666666666667)(lat_2,37.26666666666667)(lat_0,36.66666666666666)(lon_0,-98.5)(x_0,400000)(y_0,400000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26979, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,37.96666666666667)(lat_0,37.5)(lon_0,-84.25)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26980, srs::dpar::parameters<>(proj_lcc)(lat_1,37.93333333333333)(lat_2,36.73333333333333)(lat_0,36.33333333333334)(lon_0,-85.75)(x_0,500000)(y_0,500000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26981, srs::dpar::parameters<>(proj_lcc)(lat_1,32.66666666666666)(lat_2,31.16666666666667)(lat_0,30.5)(lon_0,-92.5)(x_0,1000000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26982, srs::dpar::parameters<>(proj_lcc)(lat_1,30.7)(lat_2,29.3)(lat_0,28.5)(lon_0,-91.33333333333333)(x_0,1000000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26983, srs::dpar::parameters<>(proj_tmerc)(lat_0,43.66666666666666)(lon_0,-68.5)(k,0.9999)(x_0,300000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26984, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.83333333333334)(lon_0,-70.16666666666667)(k,0.999966667)(x_0,900000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26985, srs::dpar::parameters<>(proj_lcc)(lat_1,39.45)(lat_2,38.3)(lat_0,37.66666666666666)(lon_0,-77)(x_0,400000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26986, srs::dpar::parameters<>(proj_lcc)(lat_1,42.68333333333333)(lat_2,41.71666666666667)(lat_0,41)(lon_0,-71.5)(x_0,200000)(y_0,750000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26987, srs::dpar::parameters<>(proj_lcc)(lat_1,41.48333333333333)(lat_2,41.28333333333333)(lat_0,41)(lon_0,-70.5)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26988, srs::dpar::parameters<>(proj_lcc)(lat_1,47.08333333333334)(lat_2,45.48333333333333)(lat_0,44.78333333333333)(lon_0,-87)(x_0,8000000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26989, srs::dpar::parameters<>(proj_lcc)(lat_1,45.7)(lat_2,44.18333333333333)(lat_0,43.31666666666667)(lon_0,-84.36666666666666)(x_0,6000000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26990, srs::dpar::parameters<>(proj_lcc)(lat_1,43.66666666666666)(lat_2,42.1)(lat_0,41.5)(lon_0,-84.36666666666666)(x_0,4000000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26991, srs::dpar::parameters<>(proj_lcc)(lat_1,48.63333333333333)(lat_2,47.03333333333333)(lat_0,46.5)(lon_0,-93.09999999999999)(x_0,800000)(y_0,100000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26992, srs::dpar::parameters<>(proj_lcc)(lat_1,47.05)(lat_2,45.61666666666667)(lat_0,45)(lon_0,-94.25)(x_0,800000)(y_0,100000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26993, srs::dpar::parameters<>(proj_lcc)(lat_1,45.21666666666667)(lat_2,43.78333333333333)(lat_0,43)(lon_0,-94)(x_0,800000)(y_0,100000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26994, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-88.83333333333333)(k,0.99995)(x_0,300000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26995, srs::dpar::parameters<>(proj_tmerc)(lat_0,29.5)(lon_0,-90.33333333333333)(k,0.99995)(x_0,700000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26996, srs::dpar::parameters<>(proj_tmerc)(lat_0,35.83333333333334)(lon_0,-90.5)(k,0.999933333)(x_0,250000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26997, srs::dpar::parameters<>(proj_tmerc)(lat_0,35.83333333333334)(lon_0,-92.5)(k,0.999933333)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {26998, srs::dpar::parameters<>(proj_tmerc)(lat_0,36.16666666666666)(lon_0,-94.5)(k,0.999941177)(x_0,850000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {27037, srs::dpar::parameters<>(proj_utm)(zone,37)(ellps_clrk80)(units_m)(no_defs)},
            {27038, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_clrk80)(units_m)(no_defs)},
            {27039, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_clrk80)(units_m)(no_defs)},
            {27040, srs::dpar::parameters<>(proj_utm)(zone,40)(ellps_clrk80)(units_m)(no_defs)},
            {27120, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_intl)(units_m)(no_defs)},
            {27200, srs::dpar::parameters<>(proj_nzmg)(lat_0,-41)(lon_0,173)(x_0,2510000)(y_0,6023150)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27205, srs::dpar::parameters<>(proj_tmerc)(lat_0,-36.87986527777778)(lon_0,174.7643393611111)(k,0.9999)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27206, srs::dpar::parameters<>(proj_tmerc)(lat_0,-37.76124980555556)(lon_0,176.46619725)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27207, srs::dpar::parameters<>(proj_tmerc)(lat_0,-38.62470277777778)(lon_0,177.8856362777778)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27208, srs::dpar::parameters<>(proj_tmerc)(lat_0,-39.65092930555556)(lon_0,176.6736805277778)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27209, srs::dpar::parameters<>(proj_tmerc)(lat_0,-39.13575830555556)(lon_0,174.22801175)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27210, srs::dpar::parameters<>(proj_tmerc)(lat_0,-39.51247038888889)(lon_0,175.6400368055556)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27211, srs::dpar::parameters<>(proj_tmerc)(lat_0,-40.24194713888889)(lon_0,175.4880996111111)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27212, srs::dpar::parameters<>(proj_tmerc)(lat_0,-40.92553263888889)(lon_0,175.6473496666667)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27213, srs::dpar::parameters<>(proj_tmerc)(lat_0,-41.30131963888888)(lon_0,174.7766231111111)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27214, srs::dpar::parameters<>(proj_tmerc)(lat_0,-40.71475905555556)(lon_0,172.6720465)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27215, srs::dpar::parameters<>(proj_tmerc)(lat_0,-41.27454472222222)(lon_0,173.2993168055555)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27216, srs::dpar::parameters<>(proj_tmerc)(lat_0,-41.28991152777778)(lon_0,172.1090281944444)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27217, srs::dpar::parameters<>(proj_tmerc)(lat_0,-41.81080286111111)(lon_0,171.5812600555556)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27218, srs::dpar::parameters<>(proj_tmerc)(lat_0,-42.33369427777778)(lon_0,171.5497713055556)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27219, srs::dpar::parameters<>(proj_tmerc)(lat_0,-42.68911658333333)(lon_0,173.0101333888889)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27220, srs::dpar::parameters<>(proj_tmerc)(lat_0,-41.54448666666666)(lon_0,173.8020741111111)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27221, srs::dpar::parameters<>(proj_tmerc)(lat_0,-42.88632236111111)(lon_0,170.9799935)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27222, srs::dpar::parameters<>(proj_tmerc)(lat_0,-43.11012813888889)(lon_0,170.2609258333333)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27223, srs::dpar::parameters<>(proj_tmerc)(lat_0,-43.97780288888889)(lon_0,168.606267)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27224, srs::dpar::parameters<>(proj_tmerc)(lat_0,-43.59063758333333)(lon_0,172.7271935833333)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27225, srs::dpar::parameters<>(proj_tmerc)(lat_0,-43.74871155555556)(lon_0,171.3607484722222)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27226, srs::dpar::parameters<>(proj_tmerc)(lat_0,-44.40222036111111)(lon_0,171.0572508333333)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27227, srs::dpar::parameters<>(proj_tmerc)(lat_0,-44.73526797222222)(lon_0,169.4677550833333)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27228, srs::dpar::parameters<>(proj_tmerc)(lat_0,-45.13290258333333)(lon_0,168.3986411944444)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27229, srs::dpar::parameters<>(proj_tmerc)(lat_0,-45.56372616666666)(lon_0,167.7388617777778)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27230, srs::dpar::parameters<>(proj_tmerc)(lat_0,-45.81619661111111)(lon_0,170.6285951666667)(k,1)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27231, srs::dpar::parameters<>(proj_tmerc)(lat_0,-45.86151336111111)(lon_0,170.2825891111111)(k,0.99996)(x_0,300000)(y_0,700000)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27232, srs::dpar::parameters<>(proj_tmerc)(lat_0,-46.60000961111111)(lon_0,168.342872)(k,1)(x_0,300002.66)(y_0,699999.58)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27258, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27259, srs::dpar::parameters<>(proj_utm)(zone,59)(south)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27260, srs::dpar::parameters<>(proj_utm)(zone,60)(south)(ellps_intl)(srs::dpar::datum_nzgd49)(units_m)(no_defs)},
            {27291, srs::dpar::parameters<>(proj_tmerc)(lat_0,-39)(lon_0,175.5)(k,1)(x_0,274319.5243848086)(y_0,365759.3658464114)(ellps_intl)(srs::dpar::datum_nzgd49)(to_meter,0.9143984146160287)(no_defs)},
            {27292, srs::dpar::parameters<>(proj_tmerc)(lat_0,-44)(lon_0,171.5)(k,1)(x_0,457199.2073080143)(y_0,457199.2073080143)(ellps_intl)(srs::dpar::datum_nzgd49)(to_meter,0.9143984146160287)(no_defs)},
            {27391, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,-4.666666666666667)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(towgs84,srs::detail::towgs84<>(278.3,93,474.5,7.889,0.05,-6.61,6.21))(pm_oslo)(units_m)(no_defs)},
            {27392, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,-2.333333333333333)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(towgs84,srs::detail::towgs84<>(278.3,93,474.5,7.889,0.05,-6.61,6.21))(pm_oslo)(units_m)(no_defs)},
            {27393, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,0)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(towgs84,srs::detail::towgs84<>(278.3,93,474.5,7.889,0.05,-6.61,6.21))(pm_oslo)(units_m)(no_defs)},
            {27394, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,2.5)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(towgs84,srs::detail::towgs84<>(278.3,93,474.5,7.889,0.05,-6.61,6.21))(pm_oslo)(units_m)(no_defs)},
            {27395, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,6.166666666666667)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(towgs84,srs::detail::towgs84<>(278.3,93,474.5,7.889,0.05,-6.61,6.21))(pm_oslo)(units_m)(no_defs)},
            {27396, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,10.16666666666667)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(towgs84,srs::detail::towgs84<>(278.3,93,474.5,7.889,0.05,-6.61,6.21))(pm_oslo)(units_m)(no_defs)},
            {27397, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,14.16666666666667)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(towgs84,srs::detail::towgs84<>(278.3,93,474.5,7.889,0.05,-6.61,6.21))(pm_oslo)(units_m)(no_defs)},
            {27398, srs::dpar::parameters<>(proj_tmerc)(lat_0,58)(lon_0,18.33333333333333)(k,1)(x_0,0)(y_0,0)(a,6377492.018)(b,6356173.508712696)(towgs84,srs::detail::towgs84<>(278.3,93,474.5,7.889,0.05,-6.61,6.21))(pm_oslo)(units_m)(no_defs)},
            {27429, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_intl)(units_m)(no_defs)},
            {27492, srs::dpar::parameters<>(proj_tmerc)(lat_0,39.66666666666666)(lon_0,-8.131906111111112)(k,1)(x_0,180.598)(y_0,-86.98999999999999)(ellps_intl)(units_m)(no_defs)},
            {27493, srs::dpar::parameters<>(proj_tmerc)(lat_0,39.66666666666666)(lon_0,-8.131906111111112)(k,1)(x_0,180.598)(y_0,-86.98999999999999)(ellps_intl)(units_m)(no_defs)},
            {27500, srs::dpar::parameters<>(proj_lcc)(lat_1,49.5)(lat_0,49.5)(lon_0,5.4)(k_0,0.99950908)(x_0,500000)(y_0,300000)(a,6376523)(b,6355862.933255573)(pm,2.3372291666985)(units_m)(no_defs)},
            {27561, srs::dpar::parameters<>(proj_lcc)(lat_1,49.50000000000001)(lat_0,49.50000000000001)(lon_0,0)(k_0,0.999877341)(x_0,600000)(y_0,200000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27562, srs::dpar::parameters<>(proj_lcc)(lat_1,46.8)(lat_0,46.8)(lon_0,0)(k_0,0.99987742)(x_0,600000)(y_0,200000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27563, srs::dpar::parameters<>(proj_lcc)(lat_1,44.10000000000001)(lat_0,44.10000000000001)(lon_0,0)(k_0,0.999877499)(x_0,600000)(y_0,200000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27564, srs::dpar::parameters<>(proj_lcc)(lat_1,42.16500000000001)(lat_0,42.16500000000001)(lon_0,0)(k_0,0.99994471)(x_0,234.358)(y_0,185861.369)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27571, srs::dpar::parameters<>(proj_lcc)(lat_1,49.50000000000001)(lat_0,49.50000000000001)(lon_0,0)(k_0,0.999877341)(x_0,600000)(y_0,1200000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27572, srs::dpar::parameters<>(proj_lcc)(lat_1,46.8)(lat_0,46.8)(lon_0,0)(k_0,0.99987742)(x_0,600000)(y_0,2200000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27573, srs::dpar::parameters<>(proj_lcc)(lat_1,44.10000000000001)(lat_0,44.10000000000001)(lon_0,0)(k_0,0.999877499)(x_0,600000)(y_0,3200000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27574, srs::dpar::parameters<>(proj_lcc)(lat_1,42.16500000000001)(lat_0,42.16500000000001)(lon_0,0)(k_0,0.99994471)(x_0,234.358)(y_0,4185861.369)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27581, srs::dpar::parameters<>(proj_lcc)(lat_1,49.50000000000001)(lat_0,49.50000000000001)(lon_0,0)(k_0,0.999877341)(x_0,600000)(y_0,1200000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27582, srs::dpar::parameters<>(proj_lcc)(lat_1,46.8)(lat_0,46.8)(lon_0,0)(k_0,0.99987742)(x_0,600000)(y_0,2200000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27583, srs::dpar::parameters<>(proj_lcc)(lat_1,44.10000000000001)(lat_0,44.10000000000001)(lon_0,0)(k_0,0.999877499)(x_0,600000)(y_0,3200000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27584, srs::dpar::parameters<>(proj_lcc)(lat_1,42.16500000000001)(lat_0,42.16500000000001)(lon_0,0)(k_0,0.99994471)(x_0,234.358)(y_0,4185861.369)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27591, srs::dpar::parameters<>(proj_lcc)(lat_1,49.50000000000001)(lat_0,49.50000000000001)(lon_0,0)(k_0,0.999877341)(x_0,600000)(y_0,200000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27592, srs::dpar::parameters<>(proj_lcc)(lat_1,46.8)(lat_0,46.8)(lon_0,0)(k_0,0.99987742)(x_0,600000)(y_0,200000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27593, srs::dpar::parameters<>(proj_lcc)(lat_1,44.10000000000001)(lat_0,44.10000000000001)(lon_0,0)(k_0,0.999877499)(x_0,600000)(y_0,200000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27594, srs::dpar::parameters<>(proj_lcc)(lat_1,42.16500000000001)(lat_0,42.16500000000001)(lon_0,0)(k_0,0.99994471)(x_0,234.358)(y_0,185861.369)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168,-60,320,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {27700, srs::dpar::parameters<>(proj_tmerc)(lat_0,49)(lon_0,-2)(k,0.9996012717)(x_0,400000)(y_0,-100000)(ellps_airy)(srs::dpar::datum_osgb36)(units_m)(no_defs)},
            {28191, srs::dpar::parameters<>(proj_cass)(lat_0,31.73409694444445)(lon_0,35.21208055555556)(x_0,170251.555)(y_0,126867.909)(a,6378300.789)(b,6356566.435)(towgs84,srs::detail::towgs84<>(-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1))(units_m)(no_defs)},
            {28192, srs::dpar::parameters<>(proj_tmerc)(lat_0,31.73409694444445)(lon_0,35.21208055555556)(k,1)(x_0,170251.555)(y_0,1126867.909)(a,6378300.789)(b,6356566.435)(towgs84,srs::detail::towgs84<>(-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1))(units_m)(no_defs)},
            {28193, srs::dpar::parameters<>(proj_cass)(lat_0,31.73409694444445)(lon_0,35.21208055555556)(x_0,170251.555)(y_0,1126867.909)(a,6378300.789)(b,6356566.435)(towgs84,srs::detail::towgs84<>(-275.722,94.7824,340.894,-8.001,-4.42,-11.821,1))(units_m)(no_defs)},
            {28232, srs::dpar::parameters<>(proj_utm)(zone,32)(south)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {28348, srs::dpar::parameters<>(proj_utm)(zone,48)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {28349, srs::dpar::parameters<>(proj_utm)(zone,49)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {28350, srs::dpar::parameters<>(proj_utm)(zone,50)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {28351, srs::dpar::parameters<>(proj_utm)(zone,51)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {28352, srs::dpar::parameters<>(proj_utm)(zone,52)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {28353, srs::dpar::parameters<>(proj_utm)(zone,53)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {28354, srs::dpar::parameters<>(proj_utm)(zone,54)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {28355, srs::dpar::parameters<>(proj_utm)(zone,55)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {28356, srs::dpar::parameters<>(proj_utm)(zone,56)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {28357, srs::dpar::parameters<>(proj_utm)(zone,57)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {28358, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {28402, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9)(k,1)(x_0,2500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28403, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,3500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28404, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,4500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28405, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,5500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28406, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,6500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28407, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,39)(k,1)(x_0,7500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28408, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,8500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28409, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,51)(k,1)(x_0,9500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28410, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,57)(k,1)(x_0,10500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28411, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,63)(k,1)(x_0,11500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28412, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,69)(k,1)(x_0,12500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28413, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,13500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28414, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,14500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28415, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,15500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28416, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,16500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28417, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,17500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28418, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,18500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28419, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,19500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28420, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,20500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28421, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,21500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28422, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,22500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28423, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,23500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28424, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,141)(k,1)(x_0,24500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28425, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,147)(k,1)(x_0,25500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28426, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,153)(k,1)(x_0,26500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28427, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,159)(k,1)(x_0,27500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28428, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,165)(k,1)(x_0,28500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28429, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,171)(k,1)(x_0,29500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28430, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,177)(k,1)(x_0,30500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28431, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-177)(k,1)(x_0,31500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28432, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-171)(k,1)(x_0,32500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28462, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28463, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28464, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28465, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,27)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28466, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,33)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28467, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,39)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28468, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,45)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28469, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,51)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28470, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,57)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28471, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,63)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28472, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,69)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28473, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,75)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28474, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,81)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28475, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,87)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28476, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,93)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28477, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,99)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28478, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,105)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28479, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,111)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28480, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,117)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28481, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,123)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28482, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,129)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28483, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,135)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28484, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,141)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28485, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,147)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28486, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,153)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28487, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,159)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28488, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,165)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28489, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,171)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28490, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,177)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28491, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-177)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28492, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-171)(k,1)(x_0,500000)(y_0,0)(ellps_krass)(units_m)(no_defs)},
            {28600, srs::dpar::parameters<>(proj_tmerc)(lat_0,24.45)(lon_0,51.21666666666667)(k,0.99999)(x_0,200000)(y_0,300000)(ellps_intl)(units_m)(no_defs)},
            {28991, srs::dpar::parameters<>(proj_sterea)(lat_0,52.15616055555555)(lon_0,5.38763888888889)(k,0.9999079)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {28992, srs::dpar::parameters<>(proj_sterea)(lat_0,52.15616055555555)(lon_0,5.38763888888889)(k,0.9999079)(x_0,155000)(y_0,463000)(ellps_bessel)(units_m)(no_defs)},
            {29100, srs::dpar::parameters<>(proj_poly)(lat_0,0)(lon_0,-54)(x_0,5000000)(y_0,10000000)(ellps_grs67)(units_m)(no_defs)},
            {29101, srs::dpar::parameters<>(proj_poly)(lat_0,0)(lon_0,-54)(x_0,5000000)(y_0,10000000)(ellps_aust_sa)(units_m)(no_defs)},
            {29118, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_grs67)(units_m)(no_defs)},
            {29119, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_grs67)(units_m)(no_defs)},
            {29120, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_grs67)(units_m)(no_defs)},
            {29121, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_grs67)(units_m)(no_defs)},
            {29122, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_grs67)(units_m)(no_defs)},
            {29168, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_aust_sa)(units_m)(no_defs)},
            {29169, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_aust_sa)(units_m)(no_defs)},
            {29170, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_aust_sa)(units_m)(no_defs)},
            {29171, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_aust_sa)(units_m)(no_defs)},
            {29172, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_aust_sa)(units_m)(no_defs)},
            {29177, srs::dpar::parameters<>(proj_utm)(zone,17)(south)(ellps_grs67)(units_m)(no_defs)},
            {29178, srs::dpar::parameters<>(proj_utm)(zone,18)(south)(ellps_grs67)(units_m)(no_defs)},
            {29179, srs::dpar::parameters<>(proj_utm)(zone,19)(south)(ellps_grs67)(units_m)(no_defs)},
            {29180, srs::dpar::parameters<>(proj_utm)(zone,20)(south)(ellps_grs67)(units_m)(no_defs)},
            {29181, srs::dpar::parameters<>(proj_utm)(zone,21)(south)(ellps_grs67)(units_m)(no_defs)},
            {29182, srs::dpar::parameters<>(proj_utm)(zone,22)(south)(ellps_grs67)(units_m)(no_defs)},
            {29183, srs::dpar::parameters<>(proj_utm)(zone,23)(south)(ellps_grs67)(units_m)(no_defs)},
            {29184, srs::dpar::parameters<>(proj_utm)(zone,24)(south)(ellps_grs67)(units_m)(no_defs)},
            {29185, srs::dpar::parameters<>(proj_utm)(zone,25)(south)(ellps_grs67)(units_m)(no_defs)},
            {29187, srs::dpar::parameters<>(proj_utm)(zone,17)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {29188, srs::dpar::parameters<>(proj_utm)(zone,18)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {29189, srs::dpar::parameters<>(proj_utm)(zone,19)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {29190, srs::dpar::parameters<>(proj_utm)(zone,20)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {29191, srs::dpar::parameters<>(proj_utm)(zone,21)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {29192, srs::dpar::parameters<>(proj_utm)(zone,22)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {29193, srs::dpar::parameters<>(proj_utm)(zone,23)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {29194, srs::dpar::parameters<>(proj_utm)(zone,24)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {29195, srs::dpar::parameters<>(proj_utm)(zone,25)(south)(ellps_aust_sa)(units_m)(no_defs)},
            {29220, srs::dpar::parameters<>(proj_utm)(zone,20)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-355,21,72,0,0,0,0))(units_m)(no_defs)},
            {29221, srs::dpar::parameters<>(proj_utm)(zone,21)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-355,21,72,0,0,0,0))(units_m)(no_defs)},
            {29333, srs::dpar::parameters<>(proj_utm)(zone,33)(south)(ellps_bess_nam)(units_m)(no_defs)},
            //{29371},
            //{29373},
            //{29375},
            //{29377},
            //{29379},
            //{29381},
            //{29383},
            //{29385},
            {29635, srs::dpar::parameters<>(proj_utm)(zone,35)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {29636, srs::dpar::parameters<>(proj_utm)(zone,36)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {29700, srs::dpar::parameters<>(proj_omerc)(lat_0,-18.9)(lonc,44.10000000000001)(alpha,18.9)(k,0.9995000000000001)(x_0,400000)(y_0,800000)(ellps_intl)(towgs84,srs::detail::towgs84<>(-189,-242,-91,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            //{29701},
            {29702, srs::dpar::parameters<>(proj_omerc)(lat_0,-18.9)(lonc,44.10000000000001)(alpha,18.9)(k,0.9995000000000001)(x_0,400000)(y_0,800000)(ellps_intl)(towgs84,srs::detail::towgs84<>(-189,-242,-91,0,0,0,0))(pm_paris)(units_m)(no_defs)},
            {29738, srs::dpar::parameters<>(proj_utm)(zone,38)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-189,-242,-91,0,0,0,0))(units_m)(no_defs)},
            {29739, srs::dpar::parameters<>(proj_utm)(zone,39)(south)(ellps_intl)(towgs84,srs::detail::towgs84<>(-189,-242,-91,0,0,0,0))(units_m)(no_defs)},
            {29849, srs::dpar::parameters<>(proj_utm)(zone,49)(ellps_evrstss)(units_m)(no_defs)},
            {29850, srs::dpar::parameters<>(proj_utm)(zone,50)(ellps_evrstss)(units_m)(no_defs)},
            {29871, srs::dpar::parameters<>(proj_omerc)(lat_0,4)(lonc,115)(alpha,53.31582047222222)(k,0.99984)(x_0,590476.8714630401)(y_0,442857.653094361)(ellps_evrstss)(to_meter,20.11676512155263)(no_defs)},
            {29872, srs::dpar::parameters<>(proj_omerc)(lat_0,4)(lonc,115)(alpha,53.31582047222222)(k,0.99984)(x_0,590476.8727431979)(y_0,442857.6545573985)(ellps_evrstss)(to_meter,0.3047994715386762)(no_defs)},
            {29873, srs::dpar::parameters<>(proj_omerc)(lat_0,4)(lonc,115)(alpha,53.31582047222222)(k,0.99984)(x_0,590476.87)(y_0,442857.65)(ellps_evrstss)(units_m)(no_defs)},
            {29900, srs::dpar::parameters<>(proj_tmerc)(lat_0,53.5)(lon_0,-8)(k,1.000035)(x_0,200000)(y_0,250000)(a,6377340.189)(b,6356034.447938534)(units_m)(no_defs)},
            {29901, srs::dpar::parameters<>(proj_tmerc)(lat_0,53.5)(lon_0,-8)(k,1)(x_0,200000)(y_0,250000)(ellps_airy)(towgs84,srs::detail::towgs84<>(482.5,-130.6,564.6,-1.042,-0.214,-0.631,8.15))(units_m)(no_defs)},
            {29902, srs::dpar::parameters<>(proj_tmerc)(lat_0,53.5)(lon_0,-8)(k,1.000035)(x_0,200000)(y_0,250000)(a,6377340.189)(b,6356034.447938534)(units_m)(no_defs)},
            {29903, srs::dpar::parameters<>(proj_tmerc)(lat_0,53.5)(lon_0,-8)(k,1.000035)(x_0,200000)(y_0,250000)(a,6377340.189)(b,6356034.447938534)(units_m)(no_defs)},
            {30161, srs::dpar::parameters<>(proj_tmerc)(lat_0,33)(lon_0,129.5)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30162, srs::dpar::parameters<>(proj_tmerc)(lat_0,33)(lon_0,131)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30163, srs::dpar::parameters<>(proj_tmerc)(lat_0,36)(lon_0,132.1666666666667)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30164, srs::dpar::parameters<>(proj_tmerc)(lat_0,33)(lon_0,133.5)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30165, srs::dpar::parameters<>(proj_tmerc)(lat_0,36)(lon_0,134.3333333333333)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30166, srs::dpar::parameters<>(proj_tmerc)(lat_0,36)(lon_0,136)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30167, srs::dpar::parameters<>(proj_tmerc)(lat_0,36)(lon_0,137.1666666666667)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30168, srs::dpar::parameters<>(proj_tmerc)(lat_0,36)(lon_0,138.5)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30169, srs::dpar::parameters<>(proj_tmerc)(lat_0,36)(lon_0,139.8333333333333)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30170, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,140.8333333333333)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30171, srs::dpar::parameters<>(proj_tmerc)(lat_0,44)(lon_0,140.25)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30172, srs::dpar::parameters<>(proj_tmerc)(lat_0,44)(lon_0,142.25)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30173, srs::dpar::parameters<>(proj_tmerc)(lat_0,44)(lon_0,144.25)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30174, srs::dpar::parameters<>(proj_tmerc)(lat_0,26)(lon_0,142)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30175, srs::dpar::parameters<>(proj_tmerc)(lat_0,26)(lon_0,127.5)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30176, srs::dpar::parameters<>(proj_tmerc)(lat_0,26)(lon_0,124)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30177, srs::dpar::parameters<>(proj_tmerc)(lat_0,26)(lon_0,131)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30178, srs::dpar::parameters<>(proj_tmerc)(lat_0,20)(lon_0,136)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30179, srs::dpar::parameters<>(proj_tmerc)(lat_0,26)(lon_0,154)(k,0.9999)(x_0,0)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {30200, srs::dpar::parameters<>(proj_cass)(lat_0,10.44166666666667)(lon_0,-61.33333333333334)(x_0,86501.46392051999)(y_0,65379.0134283)(a,6378293.645208759)(b,6356617.987679838)(to_meter,0.201166195164)(no_defs)},
            {30339, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_helmert)(units_m)(no_defs)},
            {30340, srs::dpar::parameters<>(proj_utm)(zone,40)(ellps_helmert)(units_m)(no_defs)},
            {30491, srs::dpar::parameters<>(proj_lcc)(lat_1,36)(lat_0,36)(lon_0,2.7)(k_0,0.999625544)(x_0,500000)(y_0,300000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-73,-247,227,0,0,0,0))(units_m)(no_defs)},
            {30492, srs::dpar::parameters<>(proj_lcc)(lat_1,33.3)(lat_0,33.3)(lon_0,2.7)(k_0,0.999625769)(x_0,500000)(y_0,300000)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-73,-247,227,0,0,0,0))(units_m)(no_defs)},
            {30493, srs::dpar::parameters<>(proj_lcc)(lat_1,36)(lat_0,36)(lon_0,2.7)(k_0,0.999625544)(x_0,500000)(y_0,300000)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {30494, srs::dpar::parameters<>(proj_lcc)(lat_1,33.3)(lat_0,33.3)(lon_0,2.7)(k_0,0.999625769)(x_0,500000)(y_0,300000)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {30729, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_clrk80)(units_m)(no_defs)},
            {30730, srs::dpar::parameters<>(proj_utm)(zone,30)(ellps_clrk80)(units_m)(no_defs)},
            {30731, srs::dpar::parameters<>(proj_utm)(zone,31)(ellps_clrk80)(units_m)(no_defs)},
            {30732, srs::dpar::parameters<>(proj_utm)(zone,32)(ellps_clrk80)(units_m)(no_defs)},
            {30791, srs::dpar::parameters<>(proj_lcc)(lat_1,36)(lat_0,36)(lon_0,2.7)(k_0,0.999625544)(x_0,500135)(y_0,300090)(ellps_clrk80)(units_m)(no_defs)},
            {30792, srs::dpar::parameters<>(proj_lcc)(lat_1,33.3)(lat_0,33.3)(lon_0,2.7)(k_0,0.999625769)(x_0,500135)(y_0,300090)(ellps_clrk80)(units_m)(no_defs)},
            {30800, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15.80827777777778)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(units_m)(no_defs)},
            {31028, srs::dpar::parameters<>(proj_utm)(zone,28)(a,6378249.2)(b,6356515)(units_m)(no_defs)},
            {31121, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_intl)(towgs84,srs::detail::towgs84<>(-265,120,-358,0,0,0,0))(units_m)(no_defs)},
            {31154, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-54)(k,0.9996)(x_0,500000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-265,120,-358,0,0,0,0))(units_m)(no_defs)},
            {31170, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-55.68333333333333)(k,0.9996)(x_0,500000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-265,120,-358,0,0,0,0))(units_m)(no_defs)},
            {31171, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-55.68333333333333)(k,0.9999)(x_0,500000)(y_0,0)(ellps_intl)(towgs84,srs::detail::towgs84<>(-265,120,-358,0,0,0,0))(units_m)(no_defs)},
            {31251, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,28)(k,1)(x_0,0)(y_0,-5000000)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {31252, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,31)(k,1)(x_0,0)(y_0,-5000000)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {31253, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,34)(k,1)(x_0,0)(y_0,-5000000)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {31254, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,10.33333333333333)(k,1)(x_0,0)(y_0,-5000000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31255, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,13.33333333333333)(k,1)(x_0,0)(y_0,-5000000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31256, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,16.33333333333333)(k,1)(x_0,0)(y_0,-5000000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31257, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,10.33333333333333)(k,1)(x_0,150000)(y_0,-5000000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31258, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,13.33333333333333)(k,1)(x_0,450000)(y_0,-5000000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31259, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,16.33333333333333)(k,1)(x_0,750000)(y_0,-5000000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31265, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,5500000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31266, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18)(k,1)(x_0,6500000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31267, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,1)(x_0,7500000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31268, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,1)(x_0,8500000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31275, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,0.9999)(x_0,5500000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31276, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,18)(k,0.9999)(x_0,6500000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31277, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,0.9999)(x_0,7500000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31278, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,21)(k,0.9999)(x_0,7500000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31279, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,24)(k,0.9999)(x_0,8500000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31281, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,28)(k,1)(x_0,0)(y_0,0)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {31282, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,31)(k,1)(x_0,0)(y_0,0)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {31283, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,34)(k,1)(x_0,0)(y_0,0)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {31284, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,10.33333333333333)(k,1)(x_0,150000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31285, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,13.33333333333333)(k,1)(x_0,450000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31286, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,16.33333333333333)(k,1)(x_0,750000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31287, srs::dpar::parameters<>(proj_lcc)(lat_1,49)(lat_2,46)(lat_0,47.5)(lon_0,13.33333333333333)(x_0,400000)(y_0,400000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31288, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,28)(k,1)(x_0,150000)(y_0,0)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {31289, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,31)(k,1)(x_0,450000)(y_0,0)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {31290, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,34)(k,1)(x_0,750000)(y_0,0)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {31291, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,28)(k,1)(x_0,0)(y_0,0)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {31292, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,31)(k,1)(x_0,0)(y_0,0)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {31293, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,34)(k,1)(x_0,0)(y_0,0)(ellps_bessel)(pm_ferro)(units_m)(no_defs)},
            {31294, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,10.33333333333333)(k,1)(x_0,150000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31295, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,13.33333333333333)(k,1)(x_0,450000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31296, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,16.33333333333333)(k,1)(x_0,750000)(y_0,0)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            {31297, srs::dpar::parameters<>(proj_lcc)(lat_1,49)(lat_2,46)(lat_0,47.5)(lon_0,13.33333333333333)(x_0,400000)(y_0,400000)(ellps_bessel)(towgs84,srs::detail::towgs84<>(577.326,90.129,463.919,5.137,1.474,5.297,2.4232))(units_m)(no_defs)},
            //{31300},
            {31370, srs::dpar::parameters<>(proj_lcc)(lat_1,51.16666723333333)(lat_2,49.8333339)(lat_0,90)(lon_0,4.367486666666666)(x_0,150000.013)(y_0,5400088.438)(ellps_intl)(towgs84,srs::detail::towgs84<>(106.869,-52.2978,103.724,-0.33657,0.456955,-1.84218,1))(units_m)(no_defs)},
            {31461, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,3)(k,1)(x_0,1500000)(y_0,0)(ellps_bessel)(srs::dpar::datum_potsdam)(units_m)(no_defs)},
            {31462, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,6)(k,1)(x_0,2500000)(y_0,0)(ellps_bessel)(srs::dpar::datum_potsdam)(units_m)(no_defs)},
            {31463, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9)(k,1)(x_0,3500000)(y_0,0)(ellps_bessel)(srs::dpar::datum_potsdam)(units_m)(no_defs)},
            {31464, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,12)(k,1)(x_0,4500000)(y_0,0)(ellps_bessel)(srs::dpar::datum_potsdam)(units_m)(no_defs)},
            {31465, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,5500000)(y_0,0)(ellps_bessel)(srs::dpar::datum_potsdam)(units_m)(no_defs)},
            {31466, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,6)(k,1)(x_0,2500000)(y_0,0)(ellps_bessel)(srs::dpar::datum_potsdam)(units_m)(no_defs)},
            {31467, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,9)(k,1)(x_0,3500000)(y_0,0)(ellps_bessel)(srs::dpar::datum_potsdam)(units_m)(no_defs)},
            {31468, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,12)(k,1)(x_0,4500000)(y_0,0)(ellps_bessel)(srs::dpar::datum_potsdam)(units_m)(no_defs)},
            {31469, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,15)(k,1)(x_0,5500000)(y_0,0)(ellps_bessel)(srs::dpar::datum_potsdam)(units_m)(no_defs)},
            {31528, srs::dpar::parameters<>(proj_utm)(zone,28)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-23,259,-9,0,0,0,0))(units_m)(no_defs)},
            {31529, srs::dpar::parameters<>(proj_utm)(zone,29)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-23,259,-9,0,0,0,0))(units_m)(no_defs)},
            {31600, srs::dpar::parameters<>(proj_sterea)(lat_0,45.9)(lon_0,25.39246588888889)(k,0.9996667)(x_0,500000)(y_0,500000)(ellps_intl)(units_m)(no_defs)},
            {31700, srs::dpar::parameters<>(proj_sterea)(lat_0,46)(lon_0,25)(k,0.99975)(x_0,500000)(y_0,500000)(ellps_krass)(units_m)(no_defs)},
            {31838, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(-3.2,-5.7,2.8,0,0,0,0))(units_m)(no_defs)},
            {31839, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(-3.2,-5.7,2.8,0,0,0,0))(units_m)(no_defs)},
            {31900, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,48)(k,0.9996)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {31901, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,48)(k,1)(x_0,500000)(y_0,0)(ellps_grs80)(units_m)(no_defs)},
            {31965, srs::dpar::parameters<>(proj_utm)(zone,11)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31966, srs::dpar::parameters<>(proj_utm)(zone,12)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31967, srs::dpar::parameters<>(proj_utm)(zone,13)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31968, srs::dpar::parameters<>(proj_utm)(zone,14)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31969, srs::dpar::parameters<>(proj_utm)(zone,15)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31970, srs::dpar::parameters<>(proj_utm)(zone,16)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31971, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31972, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31973, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31974, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31975, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31976, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31977, srs::dpar::parameters<>(proj_utm)(zone,17)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31978, srs::dpar::parameters<>(proj_utm)(zone,18)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31979, srs::dpar::parameters<>(proj_utm)(zone,19)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31980, srs::dpar::parameters<>(proj_utm)(zone,20)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31981, srs::dpar::parameters<>(proj_utm)(zone,21)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31982, srs::dpar::parameters<>(proj_utm)(zone,22)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31983, srs::dpar::parameters<>(proj_utm)(zone,23)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31984, srs::dpar::parameters<>(proj_utm)(zone,24)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31985, srs::dpar::parameters<>(proj_utm)(zone,25)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31986, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31987, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31988, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31989, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31990, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31991, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31992, srs::dpar::parameters<>(proj_utm)(zone,17)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31993, srs::dpar::parameters<>(proj_utm)(zone,18)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31994, srs::dpar::parameters<>(proj_utm)(zone,19)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31995, srs::dpar::parameters<>(proj_utm)(zone,20)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31996, srs::dpar::parameters<>(proj_utm)(zone,21)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31997, srs::dpar::parameters<>(proj_utm)(zone,22)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31998, srs::dpar::parameters<>(proj_utm)(zone,23)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {31999, srs::dpar::parameters<>(proj_utm)(zone,24)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {32000, srs::dpar::parameters<>(proj_utm)(zone,25)(south)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0,0,0,0,0,0,0))(units_m)(no_defs)},
            {32001, srs::dpar::parameters<>(proj_lcc)(lat_1,48.71666666666667)(lat_2,47.85)(lat_0,47)(lon_0,-109.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32002, srs::dpar::parameters<>(proj_lcc)(lat_1,47.88333333333333)(lat_2,46.45)(lat_0,45.83333333333334)(lon_0,-109.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32003, srs::dpar::parameters<>(proj_lcc)(lat_1,46.4)(lat_2,44.86666666666667)(lat_0,44)(lon_0,-109.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32005, srs::dpar::parameters<>(proj_lcc)(lat_1,41.85)(lat_2,42.81666666666667)(lat_0,41.33333333333334)(lon_0,-100)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32006, srs::dpar::parameters<>(proj_lcc)(lat_1,40.28333333333333)(lat_2,41.71666666666667)(lat_0,39.66666666666666)(lon_0,-99.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32007, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-115.5833333333333)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32008, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-116.6666666666667)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32009, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-118.5833333333333)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32010, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-71.66666666666667)(k,0.999966667)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32011, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.66666666666667)(k,0.9999749999999999)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32012, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-104.3333333333333)(k,0.999909091)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32013, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-106.25)(k,0.9999)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32014, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-107.8333333333333)(k,0.999916667)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32015, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-74.33333333333333)(k,0.999966667)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32016, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-76.58333333333333)(k,0.9999375)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32017, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-78.58333333333333)(k,0.9999375)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32018, srs::dpar::parameters<>(proj_lcc)(lat_1,41.03333333333333)(lat_2,40.66666666666666)(lat_0,40.5)(lon_0,-74)(x_0,304800.6096012192)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32019, srs::dpar::parameters<>(proj_lcc)(lat_1,34.33333333333334)(lat_2,36.16666666666666)(lat_0,33.75)(lon_0,-79)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32020, srs::dpar::parameters<>(proj_lcc)(lat_1,47.43333333333333)(lat_2,48.73333333333333)(lat_0,47)(lon_0,-100.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32021, srs::dpar::parameters<>(proj_lcc)(lat_1,46.18333333333333)(lat_2,47.48333333333333)(lat_0,45.66666666666666)(lon_0,-100.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32022, srs::dpar::parameters<>(proj_lcc)(lat_1,40.43333333333333)(lat_2,41.7)(lat_0,39.66666666666666)(lon_0,-82.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32023, srs::dpar::parameters<>(proj_lcc)(lat_1,38.73333333333333)(lat_2,40.03333333333333)(lat_0,38)(lon_0,-82.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32024, srs::dpar::parameters<>(proj_lcc)(lat_1,35.56666666666667)(lat_2,36.76666666666667)(lat_0,35)(lon_0,-98)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32025, srs::dpar::parameters<>(proj_lcc)(lat_1,33.93333333333333)(lat_2,35.23333333333333)(lat_0,33.33333333333334)(lon_0,-98)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32026, srs::dpar::parameters<>(proj_lcc)(lat_1,44.33333333333334)(lat_2,46)(lat_0,43.66666666666666)(lon_0,-120.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32027, srs::dpar::parameters<>(proj_lcc)(lat_1,42.33333333333334)(lat_2,44)(lat_0,41.66666666666666)(lon_0,-120.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32028, srs::dpar::parameters<>(proj_lcc)(lat_1,40.88333333333333)(lat_2,41.95)(lat_0,40.16666666666666)(lon_0,-77.75)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32029, srs::dpar::parameters<>(proj_lcc)(lat_1,39.93333333333333)(lat_2,40.8)(lat_0,39.33333333333334)(lon_0,-77.75)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32030, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.08333333333334)(lon_0,-71.5)(k,0.9999938)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32031, srs::dpar::parameters<>(proj_lcc)(lat_1,33.76666666666667)(lat_2,34.96666666666667)(lat_0,33)(lon_0,-81)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32033, srs::dpar::parameters<>(proj_lcc)(lat_1,32.33333333333334)(lat_2,33.66666666666666)(lat_0,31.83333333333333)(lon_0,-81)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32034, srs::dpar::parameters<>(proj_lcc)(lat_1,44.41666666666666)(lat_2,45.68333333333333)(lat_0,43.83333333333334)(lon_0,-100)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32035, srs::dpar::parameters<>(proj_lcc)(lat_1,42.83333333333334)(lat_2,44.4)(lat_0,42.33333333333334)(lon_0,-100.3333333333333)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32036, srs::dpar::parameters<>(proj_lcc)(lat_1,35.25)(lat_2,36.41666666666666)(lat_0,34.66666666666666)(lon_0,-86)(x_0,30480.06096012192)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32037, srs::dpar::parameters<>(proj_lcc)(lat_1,34.65)(lat_2,36.18333333333333)(lat_0,34)(lon_0,-101.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32038, srs::dpar::parameters<>(proj_lcc)(lat_1,32.13333333333333)(lat_2,33.96666666666667)(lat_0,31.66666666666667)(lon_0,-97.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32039, srs::dpar::parameters<>(proj_lcc)(lat_1,30.11666666666667)(lat_2,31.88333333333333)(lat_0,29.66666666666667)(lon_0,-100.3333333333333)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32040, srs::dpar::parameters<>(proj_lcc)(lat_1,28.38333333333333)(lat_2,30.28333333333333)(lat_0,27.83333333333333)(lon_0,-99)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32041, srs::dpar::parameters<>(proj_lcc)(lat_1,26.16666666666667)(lat_2,27.83333333333333)(lat_0,25.66666666666667)(lon_0,-98.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32042, srs::dpar::parameters<>(proj_lcc)(lat_1,40.71666666666667)(lat_2,41.78333333333333)(lat_0,40.33333333333334)(lon_0,-111.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32043, srs::dpar::parameters<>(proj_lcc)(lat_1,39.01666666666667)(lat_2,40.65)(lat_0,38.33333333333334)(lon_0,-111.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32044, srs::dpar::parameters<>(proj_lcc)(lat_1,37.21666666666667)(lat_2,38.35)(lat_0,36.66666666666666)(lon_0,-111.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32045, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-72.5)(k,0.999964286)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32046, srs::dpar::parameters<>(proj_lcc)(lat_1,38.03333333333333)(lat_2,39.2)(lat_0,37.66666666666666)(lon_0,-78.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32047, srs::dpar::parameters<>(proj_lcc)(lat_1,36.76666666666667)(lat_2,37.96666666666667)(lat_0,36.33333333333334)(lon_0,-78.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32048, srs::dpar::parameters<>(proj_lcc)(lat_1,47.5)(lat_2,48.73333333333333)(lat_0,47)(lon_0,-120.8333333333333)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32049, srs::dpar::parameters<>(proj_lcc)(lat_1,45.83333333333334)(lat_2,47.33333333333334)(lat_0,45.33333333333334)(lon_0,-120.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32050, srs::dpar::parameters<>(proj_lcc)(lat_1,39)(lat_2,40.25)(lat_0,38.5)(lon_0,-79.5)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32051, srs::dpar::parameters<>(proj_lcc)(lat_1,37.48333333333333)(lat_2,38.88333333333333)(lat_0,37)(lon_0,-81)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32052, srs::dpar::parameters<>(proj_lcc)(lat_1,45.56666666666667)(lat_2,46.76666666666667)(lat_0,45.16666666666666)(lon_0,-90)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32053, srs::dpar::parameters<>(proj_lcc)(lat_1,44.25)(lat_2,45.5)(lat_0,43.83333333333334)(lon_0,-90)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32054, srs::dpar::parameters<>(proj_lcc)(lat_1,42.73333333333333)(lat_2,44.06666666666667)(lat_0,42)(lon_0,-90)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32055, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.66666666666666)(lon_0,-105.1666666666667)(k,0.999941177)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32056, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.66666666666666)(lon_0,-107.3333333333333)(k,0.999941177)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32057, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.66666666666666)(lon_0,-108.75)(k,0.999941177)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32058, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.66666666666666)(lon_0,-110.0833333333333)(k,0.999941177)(x_0,152400.3048006096)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32061, srs::dpar::parameters<>(proj_lcc)(lat_1,16.81666666666667)(lat_0,16.81666666666667)(lon_0,-90.33333333333333)(k_0,0.99992226)(x_0,500000)(y_0,292209.579)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {32062, srs::dpar::parameters<>(proj_lcc)(lat_1,14.9)(lat_0,14.9)(lon_0,-90.33333333333333)(k_0,0.99989906)(x_0,500000)(y_0,325992.681)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {32064, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-99)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32065, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-93)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32066, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-87)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32067, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-81)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32074, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-99)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32075, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-93)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32076, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-87)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32077, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-81)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32081, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-53)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {32082, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-56)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {32083, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-58.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {32084, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-61.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {32085, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-64.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {32086, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-67.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {32098, srs::dpar::parameters<>(proj_lcc)(lat_1,60)(lat_2,46)(lat_0,44)(lon_0,-68.5)(x_0,0)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(units_m)(no_defs)},
            {32099, srs::dpar::parameters<>(proj_lcc)(lat_1,27.83333333333333)(lat_2,26.16666666666667)(lat_0,25.66666666666667)(lon_0,-91.33333333333333)(x_0,609601.2192024384)(y_0,0)(ellps_clrk66)(srs::dpar::datum_nad27)(to_meter,0.3048006096012192)(no_defs)},
            {32100, srs::dpar::parameters<>(proj_lcc)(lat_1,49)(lat_2,45)(lat_0,44.25)(lon_0,-109.5)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32104, srs::dpar::parameters<>(proj_lcc)(lat_1,43)(lat_2,40)(lat_0,39.83333333333334)(lon_0,-100)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32107, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-115.5833333333333)(k,0.9999)(x_0,200000)(y_0,8000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32108, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-116.6666666666667)(k,0.9999)(x_0,500000)(y_0,6000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32109, srs::dpar::parameters<>(proj_tmerc)(lat_0,34.75)(lon_0,-118.5833333333333)(k,0.9999)(x_0,800000)(y_0,4000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32110, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-71.66666666666667)(k,0.999966667)(x_0,300000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32111, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32112, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-104.3333333333333)(k,0.999909091)(x_0,165000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32113, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-106.25)(k,0.9999)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32114, srs::dpar::parameters<>(proj_tmerc)(lat_0,31)(lon_0,-107.8333333333333)(k,0.999916667)(x_0,830000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32115, srs::dpar::parameters<>(proj_tmerc)(lat_0,38.83333333333334)(lon_0,-74.5)(k,0.9999)(x_0,150000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32116, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-76.58333333333333)(k,0.9999375)(x_0,250000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32117, srs::dpar::parameters<>(proj_tmerc)(lat_0,40)(lon_0,-78.58333333333333)(k,0.9999375)(x_0,350000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32118, srs::dpar::parameters<>(proj_lcc)(lat_1,41.03333333333333)(lat_2,40.66666666666666)(lat_0,40.16666666666666)(lon_0,-74)(x_0,300000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32119, srs::dpar::parameters<>(proj_lcc)(lat_1,36.16666666666666)(lat_2,34.33333333333334)(lat_0,33.75)(lon_0,-79)(x_0,609601.22)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32120, srs::dpar::parameters<>(proj_lcc)(lat_1,48.73333333333333)(lat_2,47.43333333333333)(lat_0,47)(lon_0,-100.5)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32121, srs::dpar::parameters<>(proj_lcc)(lat_1,47.48333333333333)(lat_2,46.18333333333333)(lat_0,45.66666666666666)(lon_0,-100.5)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32122, srs::dpar::parameters<>(proj_lcc)(lat_1,41.7)(lat_2,40.43333333333333)(lat_0,39.66666666666666)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32123, srs::dpar::parameters<>(proj_lcc)(lat_1,40.03333333333333)(lat_2,38.73333333333333)(lat_0,38)(lon_0,-82.5)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32124, srs::dpar::parameters<>(proj_lcc)(lat_1,36.76666666666667)(lat_2,35.56666666666667)(lat_0,35)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32125, srs::dpar::parameters<>(proj_lcc)(lat_1,35.23333333333333)(lat_2,33.93333333333333)(lat_0,33.33333333333334)(lon_0,-98)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32126, srs::dpar::parameters<>(proj_lcc)(lat_1,46)(lat_2,44.33333333333334)(lat_0,43.66666666666666)(lon_0,-120.5)(x_0,2500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32127, srs::dpar::parameters<>(proj_lcc)(lat_1,44)(lat_2,42.33333333333334)(lat_0,41.66666666666666)(lon_0,-120.5)(x_0,1500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32128, srs::dpar::parameters<>(proj_lcc)(lat_1,41.95)(lat_2,40.88333333333333)(lat_0,40.16666666666666)(lon_0,-77.75)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32129, srs::dpar::parameters<>(proj_lcc)(lat_1,40.96666666666667)(lat_2,39.93333333333333)(lat_0,39.33333333333334)(lon_0,-77.75)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32130, srs::dpar::parameters<>(proj_tmerc)(lat_0,41.08333333333334)(lon_0,-71.5)(k,0.99999375)(x_0,100000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32133, srs::dpar::parameters<>(proj_lcc)(lat_1,34.83333333333334)(lat_2,32.5)(lat_0,31.83333333333333)(lon_0,-81)(x_0,609600)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32134, srs::dpar::parameters<>(proj_lcc)(lat_1,45.68333333333333)(lat_2,44.41666666666666)(lat_0,43.83333333333334)(lon_0,-100)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32135, srs::dpar::parameters<>(proj_lcc)(lat_1,44.4)(lat_2,42.83333333333334)(lat_0,42.33333333333334)(lon_0,-100.3333333333333)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32136, srs::dpar::parameters<>(proj_lcc)(lat_1,36.41666666666666)(lat_2,35.25)(lat_0,34.33333333333334)(lon_0,-86)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32137, srs::dpar::parameters<>(proj_lcc)(lat_1,36.18333333333333)(lat_2,34.65)(lat_0,34)(lon_0,-101.5)(x_0,200000)(y_0,1000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32138, srs::dpar::parameters<>(proj_lcc)(lat_1,33.96666666666667)(lat_2,32.13333333333333)(lat_0,31.66666666666667)(lon_0,-98.5)(x_0,600000)(y_0,2000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32139, srs::dpar::parameters<>(proj_lcc)(lat_1,31.88333333333333)(lat_2,30.11666666666667)(lat_0,29.66666666666667)(lon_0,-100.3333333333333)(x_0,700000)(y_0,3000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32140, srs::dpar::parameters<>(proj_lcc)(lat_1,30.28333333333333)(lat_2,28.38333333333333)(lat_0,27.83333333333333)(lon_0,-99)(x_0,600000)(y_0,4000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32141, srs::dpar::parameters<>(proj_lcc)(lat_1,27.83333333333333)(lat_2,26.16666666666667)(lat_0,25.66666666666667)(lon_0,-98.5)(x_0,300000)(y_0,5000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32142, srs::dpar::parameters<>(proj_lcc)(lat_1,41.78333333333333)(lat_2,40.71666666666667)(lat_0,40.33333333333334)(lon_0,-111.5)(x_0,500000)(y_0,1000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32143, srs::dpar::parameters<>(proj_lcc)(lat_1,40.65)(lat_2,39.01666666666667)(lat_0,38.33333333333334)(lon_0,-111.5)(x_0,500000)(y_0,2000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32144, srs::dpar::parameters<>(proj_lcc)(lat_1,38.35)(lat_2,37.21666666666667)(lat_0,36.66666666666666)(lon_0,-111.5)(x_0,500000)(y_0,3000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32145, srs::dpar::parameters<>(proj_tmerc)(lat_0,42.5)(lon_0,-72.5)(k,0.999964286)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32146, srs::dpar::parameters<>(proj_lcc)(lat_1,39.2)(lat_2,38.03333333333333)(lat_0,37.66666666666666)(lon_0,-78.5)(x_0,3500000)(y_0,2000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32147, srs::dpar::parameters<>(proj_lcc)(lat_1,37.96666666666667)(lat_2,36.76666666666667)(lat_0,36.33333333333334)(lon_0,-78.5)(x_0,3500000)(y_0,1000000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32148, srs::dpar::parameters<>(proj_lcc)(lat_1,48.73333333333333)(lat_2,47.5)(lat_0,47)(lon_0,-120.8333333333333)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32149, srs::dpar::parameters<>(proj_lcc)(lat_1,47.33333333333334)(lat_2,45.83333333333334)(lat_0,45.33333333333334)(lon_0,-120.5)(x_0,500000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32150, srs::dpar::parameters<>(proj_lcc)(lat_1,40.25)(lat_2,39)(lat_0,38.5)(lon_0,-79.5)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32151, srs::dpar::parameters<>(proj_lcc)(lat_1,38.88333333333333)(lat_2,37.48333333333333)(lat_0,37)(lon_0,-81)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32152, srs::dpar::parameters<>(proj_lcc)(lat_1,46.76666666666667)(lat_2,45.56666666666667)(lat_0,45.16666666666666)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32153, srs::dpar::parameters<>(proj_lcc)(lat_1,45.5)(lat_2,44.25)(lat_0,43.83333333333334)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32154, srs::dpar::parameters<>(proj_lcc)(lat_1,44.06666666666667)(lat_2,42.73333333333333)(lat_0,42)(lon_0,-90)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32155, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-105.1666666666667)(k,0.9999375)(x_0,200000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32156, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-107.3333333333333)(k,0.9999375)(x_0,400000)(y_0,100000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32157, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-108.75)(k,0.9999375)(x_0,600000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32158, srs::dpar::parameters<>(proj_tmerc)(lat_0,40.5)(lon_0,-110.0833333333333)(k,0.9999375)(x_0,800000)(y_0,100000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32161, srs::dpar::parameters<>(proj_lcc)(lat_1,18.43333333333333)(lat_2,18.03333333333333)(lat_0,17.83333333333333)(lon_0,-66.43333333333334)(x_0,200000)(y_0,200000)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32164, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-99)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {32165, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-93)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {32166, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-87)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {32167, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-81)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(to_meter,0.3048006096012192)(no_defs)},
            {32180, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-55.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32181, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-53)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32182, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-56)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32183, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-58.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32184, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-61.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32185, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-64.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32186, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-67.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32187, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-70.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32188, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-73.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32189, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-76.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32190, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-79.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32191, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-82.5)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32192, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-81)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32193, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-84)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32194, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-87)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32195, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-90)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32196, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-93)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32197, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-96)(k,0.9999)(x_0,304800)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32198, srs::dpar::parameters<>(proj_lcc)(lat_1,60)(lat_2,46)(lat_0,44)(lon_0,-68.5)(x_0,0)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32199, srs::dpar::parameters<>(proj_lcc)(lat_1,27.83333333333333)(lat_2,26.16666666666667)(lat_0,25.5)(lon_0,-91.33333333333333)(x_0,1000000)(y_0,0)(ellps_grs80)(srs::dpar::datum_nad83)(units_m)(no_defs)},
            {32201, srs::dpar::parameters<>(proj_utm)(zone,1)(ellps_wgs72)(units_m)(no_defs)},
            {32202, srs::dpar::parameters<>(proj_utm)(zone,2)(ellps_wgs72)(units_m)(no_defs)},
            {32203, srs::dpar::parameters<>(proj_utm)(zone,3)(ellps_wgs72)(units_m)(no_defs)},
            {32204, srs::dpar::parameters<>(proj_utm)(zone,4)(ellps_wgs72)(units_m)(no_defs)},
            {32205, srs::dpar::parameters<>(proj_utm)(zone,5)(ellps_wgs72)(units_m)(no_defs)},
            {32206, srs::dpar::parameters<>(proj_utm)(zone,6)(ellps_wgs72)(units_m)(no_defs)},
            {32207, srs::dpar::parameters<>(proj_utm)(zone,7)(ellps_wgs72)(units_m)(no_defs)},
            {32208, srs::dpar::parameters<>(proj_utm)(zone,8)(ellps_wgs72)(units_m)(no_defs)},
            {32209, srs::dpar::parameters<>(proj_utm)(zone,9)(ellps_wgs72)(units_m)(no_defs)},
            {32210, srs::dpar::parameters<>(proj_utm)(zone,10)(ellps_wgs72)(units_m)(no_defs)},
            {32211, srs::dpar::parameters<>(proj_utm)(zone,11)(ellps_wgs72)(units_m)(no_defs)},
            {32212, srs::dpar::parameters<>(proj_utm)(zone,12)(ellps_wgs72)(units_m)(no_defs)},
            {32213, srs::dpar::parameters<>(proj_utm)(zone,13)(ellps_wgs72)(units_m)(no_defs)},
            {32214, srs::dpar::parameters<>(proj_utm)(zone,14)(ellps_wgs72)(units_m)(no_defs)},
            {32215, srs::dpar::parameters<>(proj_utm)(zone,15)(ellps_wgs72)(units_m)(no_defs)},
            {32216, srs::dpar::parameters<>(proj_utm)(zone,16)(ellps_wgs72)(units_m)(no_defs)},
            {32217, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_wgs72)(units_m)(no_defs)},
            {32218, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_wgs72)(units_m)(no_defs)},
            {32219, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_wgs72)(units_m)(no_defs)},
            {32220, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_wgs72)(units_m)(no_defs)},
            {32221, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_wgs72)(units_m)(no_defs)},
            {32222, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_wgs72)(units_m)(no_defs)},
            {32223, srs::dpar::parameters<>(proj_utm)(zone,23)(ellps_wgs72)(units_m)(no_defs)},
            {32224, srs::dpar::parameters<>(proj_utm)(zone,24)(ellps_wgs72)(units_m)(no_defs)},
            {32225, srs::dpar::parameters<>(proj_utm)(zone,25)(ellps_wgs72)(units_m)(no_defs)},
            {32226, srs::dpar::parameters<>(proj_utm)(zone,26)(ellps_wgs72)(units_m)(no_defs)},
            {32227, srs::dpar::parameters<>(proj_utm)(zone,27)(ellps_wgs72)(units_m)(no_defs)},
            {32228, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_wgs72)(units_m)(no_defs)},
            {32229, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_wgs72)(units_m)(no_defs)},
            {32230, srs::dpar::parameters<>(proj_utm)(zone,30)(ellps_wgs72)(units_m)(no_defs)},
            {32231, srs::dpar::parameters<>(proj_utm)(zone,31)(ellps_wgs72)(units_m)(no_defs)},
            {32232, srs::dpar::parameters<>(proj_utm)(zone,32)(ellps_wgs72)(units_m)(no_defs)},
            {32233, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_wgs72)(units_m)(no_defs)},
            {32234, srs::dpar::parameters<>(proj_utm)(zone,34)(ellps_wgs72)(units_m)(no_defs)},
            {32235, srs::dpar::parameters<>(proj_utm)(zone,35)(ellps_wgs72)(units_m)(no_defs)},
            {32236, srs::dpar::parameters<>(proj_utm)(zone,36)(ellps_wgs72)(units_m)(no_defs)},
            {32237, srs::dpar::parameters<>(proj_utm)(zone,37)(ellps_wgs72)(units_m)(no_defs)},
            {32238, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_wgs72)(units_m)(no_defs)},
            {32239, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_wgs72)(units_m)(no_defs)},
            {32240, srs::dpar::parameters<>(proj_utm)(zone,40)(ellps_wgs72)(units_m)(no_defs)},
            {32241, srs::dpar::parameters<>(proj_utm)(zone,41)(ellps_wgs72)(units_m)(no_defs)},
            {32242, srs::dpar::parameters<>(proj_utm)(zone,42)(ellps_wgs72)(units_m)(no_defs)},
            {32243, srs::dpar::parameters<>(proj_utm)(zone,43)(ellps_wgs72)(units_m)(no_defs)},
            {32244, srs::dpar::parameters<>(proj_utm)(zone,44)(ellps_wgs72)(units_m)(no_defs)},
            {32245, srs::dpar::parameters<>(proj_utm)(zone,45)(ellps_wgs72)(units_m)(no_defs)},
            {32246, srs::dpar::parameters<>(proj_utm)(zone,46)(ellps_wgs72)(units_m)(no_defs)},
            {32247, srs::dpar::parameters<>(proj_utm)(zone,47)(ellps_wgs72)(units_m)(no_defs)},
            {32248, srs::dpar::parameters<>(proj_utm)(zone,48)(ellps_wgs72)(units_m)(no_defs)},
            {32249, srs::dpar::parameters<>(proj_utm)(zone,49)(ellps_wgs72)(units_m)(no_defs)},
            {32250, srs::dpar::parameters<>(proj_utm)(zone,50)(ellps_wgs72)(units_m)(no_defs)},
            {32251, srs::dpar::parameters<>(proj_utm)(zone,51)(ellps_wgs72)(units_m)(no_defs)},
            {32252, srs::dpar::parameters<>(proj_utm)(zone,52)(ellps_wgs72)(units_m)(no_defs)},
            {32253, srs::dpar::parameters<>(proj_utm)(zone,53)(ellps_wgs72)(units_m)(no_defs)},
            {32254, srs::dpar::parameters<>(proj_utm)(zone,54)(ellps_wgs72)(units_m)(no_defs)},
            {32255, srs::dpar::parameters<>(proj_utm)(zone,55)(ellps_wgs72)(units_m)(no_defs)},
            {32256, srs::dpar::parameters<>(proj_utm)(zone,56)(ellps_wgs72)(units_m)(no_defs)},
            {32257, srs::dpar::parameters<>(proj_utm)(zone,57)(ellps_wgs72)(units_m)(no_defs)},
            {32258, srs::dpar::parameters<>(proj_utm)(zone,58)(ellps_wgs72)(units_m)(no_defs)},
            {32259, srs::dpar::parameters<>(proj_utm)(zone,59)(ellps_wgs72)(units_m)(no_defs)},
            {32260, srs::dpar::parameters<>(proj_utm)(zone,60)(ellps_wgs72)(units_m)(no_defs)},
            {32301, srs::dpar::parameters<>(proj_utm)(zone,1)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32302, srs::dpar::parameters<>(proj_utm)(zone,2)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32303, srs::dpar::parameters<>(proj_utm)(zone,3)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32304, srs::dpar::parameters<>(proj_utm)(zone,4)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32305, srs::dpar::parameters<>(proj_utm)(zone,5)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32306, srs::dpar::parameters<>(proj_utm)(zone,6)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32307, srs::dpar::parameters<>(proj_utm)(zone,7)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32308, srs::dpar::parameters<>(proj_utm)(zone,8)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32309, srs::dpar::parameters<>(proj_utm)(zone,9)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32310, srs::dpar::parameters<>(proj_utm)(zone,10)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32311, srs::dpar::parameters<>(proj_utm)(zone,11)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32312, srs::dpar::parameters<>(proj_utm)(zone,12)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32313, srs::dpar::parameters<>(proj_utm)(zone,13)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32314, srs::dpar::parameters<>(proj_utm)(zone,14)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32315, srs::dpar::parameters<>(proj_utm)(zone,15)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32316, srs::dpar::parameters<>(proj_utm)(zone,16)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32317, srs::dpar::parameters<>(proj_utm)(zone,17)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32318, srs::dpar::parameters<>(proj_utm)(zone,18)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32319, srs::dpar::parameters<>(proj_utm)(zone,19)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32320, srs::dpar::parameters<>(proj_utm)(zone,20)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32321, srs::dpar::parameters<>(proj_utm)(zone,21)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32322, srs::dpar::parameters<>(proj_utm)(zone,22)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32323, srs::dpar::parameters<>(proj_utm)(zone,23)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32324, srs::dpar::parameters<>(proj_utm)(zone,24)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32325, srs::dpar::parameters<>(proj_utm)(zone,25)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32326, srs::dpar::parameters<>(proj_utm)(zone,26)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32327, srs::dpar::parameters<>(proj_utm)(zone,27)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32328, srs::dpar::parameters<>(proj_utm)(zone,28)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32329, srs::dpar::parameters<>(proj_utm)(zone,29)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32330, srs::dpar::parameters<>(proj_utm)(zone,30)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32331, srs::dpar::parameters<>(proj_utm)(zone,31)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32332, srs::dpar::parameters<>(proj_utm)(zone,32)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32333, srs::dpar::parameters<>(proj_utm)(zone,33)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32334, srs::dpar::parameters<>(proj_utm)(zone,34)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32335, srs::dpar::parameters<>(proj_utm)(zone,35)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32336, srs::dpar::parameters<>(proj_utm)(zone,36)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32337, srs::dpar::parameters<>(proj_utm)(zone,37)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32338, srs::dpar::parameters<>(proj_utm)(zone,38)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32339, srs::dpar::parameters<>(proj_utm)(zone,39)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32340, srs::dpar::parameters<>(proj_utm)(zone,40)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32341, srs::dpar::parameters<>(proj_utm)(zone,41)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32342, srs::dpar::parameters<>(proj_utm)(zone,42)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32343, srs::dpar::parameters<>(proj_utm)(zone,43)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32344, srs::dpar::parameters<>(proj_utm)(zone,44)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32345, srs::dpar::parameters<>(proj_utm)(zone,45)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32346, srs::dpar::parameters<>(proj_utm)(zone,46)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32347, srs::dpar::parameters<>(proj_utm)(zone,47)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32348, srs::dpar::parameters<>(proj_utm)(zone,48)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32349, srs::dpar::parameters<>(proj_utm)(zone,49)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32350, srs::dpar::parameters<>(proj_utm)(zone,50)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32351, srs::dpar::parameters<>(proj_utm)(zone,51)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32352, srs::dpar::parameters<>(proj_utm)(zone,52)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32353, srs::dpar::parameters<>(proj_utm)(zone,53)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32354, srs::dpar::parameters<>(proj_utm)(zone,54)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32355, srs::dpar::parameters<>(proj_utm)(zone,55)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32356, srs::dpar::parameters<>(proj_utm)(zone,56)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32357, srs::dpar::parameters<>(proj_utm)(zone,57)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32358, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32359, srs::dpar::parameters<>(proj_utm)(zone,59)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32360, srs::dpar::parameters<>(proj_utm)(zone,60)(south)(ellps_wgs72)(units_m)(no_defs)},
            {32401, srs::dpar::parameters<>(proj_utm)(zone,1)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32402, srs::dpar::parameters<>(proj_utm)(zone,2)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32403, srs::dpar::parameters<>(proj_utm)(zone,3)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32404, srs::dpar::parameters<>(proj_utm)(zone,4)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32405, srs::dpar::parameters<>(proj_utm)(zone,5)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32406, srs::dpar::parameters<>(proj_utm)(zone,6)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32407, srs::dpar::parameters<>(proj_utm)(zone,7)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32408, srs::dpar::parameters<>(proj_utm)(zone,8)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32409, srs::dpar::parameters<>(proj_utm)(zone,9)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32410, srs::dpar::parameters<>(proj_utm)(zone,10)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32411, srs::dpar::parameters<>(proj_utm)(zone,11)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32412, srs::dpar::parameters<>(proj_utm)(zone,12)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32413, srs::dpar::parameters<>(proj_utm)(zone,13)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32414, srs::dpar::parameters<>(proj_utm)(zone,14)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32415, srs::dpar::parameters<>(proj_utm)(zone,15)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32416, srs::dpar::parameters<>(proj_utm)(zone,16)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32417, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32418, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32419, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32420, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32421, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32422, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32423, srs::dpar::parameters<>(proj_utm)(zone,23)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32424, srs::dpar::parameters<>(proj_utm)(zone,24)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32425, srs::dpar::parameters<>(proj_utm)(zone,25)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32426, srs::dpar::parameters<>(proj_utm)(zone,26)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32427, srs::dpar::parameters<>(proj_utm)(zone,27)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32428, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32429, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32430, srs::dpar::parameters<>(proj_utm)(zone,30)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32431, srs::dpar::parameters<>(proj_utm)(zone,31)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32432, srs::dpar::parameters<>(proj_utm)(zone,32)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32433, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32434, srs::dpar::parameters<>(proj_utm)(zone,34)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32435, srs::dpar::parameters<>(proj_utm)(zone,35)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32436, srs::dpar::parameters<>(proj_utm)(zone,36)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32437, srs::dpar::parameters<>(proj_utm)(zone,37)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32438, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32439, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32440, srs::dpar::parameters<>(proj_utm)(zone,40)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32441, srs::dpar::parameters<>(proj_utm)(zone,41)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32442, srs::dpar::parameters<>(proj_utm)(zone,42)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32443, srs::dpar::parameters<>(proj_utm)(zone,43)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32444, srs::dpar::parameters<>(proj_utm)(zone,44)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32445, srs::dpar::parameters<>(proj_utm)(zone,45)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32446, srs::dpar::parameters<>(proj_utm)(zone,46)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32447, srs::dpar::parameters<>(proj_utm)(zone,47)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32448, srs::dpar::parameters<>(proj_utm)(zone,48)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32449, srs::dpar::parameters<>(proj_utm)(zone,49)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32450, srs::dpar::parameters<>(proj_utm)(zone,50)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32451, srs::dpar::parameters<>(proj_utm)(zone,51)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32452, srs::dpar::parameters<>(proj_utm)(zone,52)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32453, srs::dpar::parameters<>(proj_utm)(zone,53)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32454, srs::dpar::parameters<>(proj_utm)(zone,54)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32455, srs::dpar::parameters<>(proj_utm)(zone,55)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32456, srs::dpar::parameters<>(proj_utm)(zone,56)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32457, srs::dpar::parameters<>(proj_utm)(zone,57)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32458, srs::dpar::parameters<>(proj_utm)(zone,58)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32459, srs::dpar::parameters<>(proj_utm)(zone,59)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32460, srs::dpar::parameters<>(proj_utm)(zone,60)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32501, srs::dpar::parameters<>(proj_utm)(zone,1)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32502, srs::dpar::parameters<>(proj_utm)(zone,2)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32503, srs::dpar::parameters<>(proj_utm)(zone,3)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32504, srs::dpar::parameters<>(proj_utm)(zone,4)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32505, srs::dpar::parameters<>(proj_utm)(zone,5)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32506, srs::dpar::parameters<>(proj_utm)(zone,6)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32507, srs::dpar::parameters<>(proj_utm)(zone,7)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32508, srs::dpar::parameters<>(proj_utm)(zone,8)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32509, srs::dpar::parameters<>(proj_utm)(zone,9)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32510, srs::dpar::parameters<>(proj_utm)(zone,10)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32511, srs::dpar::parameters<>(proj_utm)(zone,11)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32512, srs::dpar::parameters<>(proj_utm)(zone,12)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32513, srs::dpar::parameters<>(proj_utm)(zone,13)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32514, srs::dpar::parameters<>(proj_utm)(zone,14)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32515, srs::dpar::parameters<>(proj_utm)(zone,15)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32516, srs::dpar::parameters<>(proj_utm)(zone,16)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32517, srs::dpar::parameters<>(proj_utm)(zone,17)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32518, srs::dpar::parameters<>(proj_utm)(zone,18)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32519, srs::dpar::parameters<>(proj_utm)(zone,19)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32520, srs::dpar::parameters<>(proj_utm)(zone,20)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32521, srs::dpar::parameters<>(proj_utm)(zone,21)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32522, srs::dpar::parameters<>(proj_utm)(zone,22)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32523, srs::dpar::parameters<>(proj_utm)(zone,23)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32524, srs::dpar::parameters<>(proj_utm)(zone,24)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32525, srs::dpar::parameters<>(proj_utm)(zone,25)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32526, srs::dpar::parameters<>(proj_utm)(zone,26)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32527, srs::dpar::parameters<>(proj_utm)(zone,27)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32528, srs::dpar::parameters<>(proj_utm)(zone,28)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32529, srs::dpar::parameters<>(proj_utm)(zone,29)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32530, srs::dpar::parameters<>(proj_utm)(zone,30)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32531, srs::dpar::parameters<>(proj_utm)(zone,31)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32532, srs::dpar::parameters<>(proj_utm)(zone,32)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32533, srs::dpar::parameters<>(proj_utm)(zone,33)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32534, srs::dpar::parameters<>(proj_utm)(zone,34)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32535, srs::dpar::parameters<>(proj_utm)(zone,35)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32536, srs::dpar::parameters<>(proj_utm)(zone,36)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32537, srs::dpar::parameters<>(proj_utm)(zone,37)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32538, srs::dpar::parameters<>(proj_utm)(zone,38)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32539, srs::dpar::parameters<>(proj_utm)(zone,39)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32540, srs::dpar::parameters<>(proj_utm)(zone,40)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32541, srs::dpar::parameters<>(proj_utm)(zone,41)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32542, srs::dpar::parameters<>(proj_utm)(zone,42)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32543, srs::dpar::parameters<>(proj_utm)(zone,43)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32544, srs::dpar::parameters<>(proj_utm)(zone,44)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32545, srs::dpar::parameters<>(proj_utm)(zone,45)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32546, srs::dpar::parameters<>(proj_utm)(zone,46)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32547, srs::dpar::parameters<>(proj_utm)(zone,47)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32548, srs::dpar::parameters<>(proj_utm)(zone,48)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32549, srs::dpar::parameters<>(proj_utm)(zone,49)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32550, srs::dpar::parameters<>(proj_utm)(zone,50)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32551, srs::dpar::parameters<>(proj_utm)(zone,51)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32552, srs::dpar::parameters<>(proj_utm)(zone,52)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32553, srs::dpar::parameters<>(proj_utm)(zone,53)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32554, srs::dpar::parameters<>(proj_utm)(zone,54)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32555, srs::dpar::parameters<>(proj_utm)(zone,55)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32556, srs::dpar::parameters<>(proj_utm)(zone,56)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32557, srs::dpar::parameters<>(proj_utm)(zone,57)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32558, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32559, srs::dpar::parameters<>(proj_utm)(zone,59)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            {32560, srs::dpar::parameters<>(proj_utm)(zone,60)(south)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0,0,1.9,0,0,0.814,-0.38))(units_m)(no_defs)},
            //{32600},
            {32601, srs::dpar::parameters<>(proj_utm)(zone,1)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32602, srs::dpar::parameters<>(proj_utm)(zone,2)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32603, srs::dpar::parameters<>(proj_utm)(zone,3)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32604, srs::dpar::parameters<>(proj_utm)(zone,4)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32605, srs::dpar::parameters<>(proj_utm)(zone,5)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32606, srs::dpar::parameters<>(proj_utm)(zone,6)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32607, srs::dpar::parameters<>(proj_utm)(zone,7)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32608, srs::dpar::parameters<>(proj_utm)(zone,8)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32609, srs::dpar::parameters<>(proj_utm)(zone,9)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32610, srs::dpar::parameters<>(proj_utm)(zone,10)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32611, srs::dpar::parameters<>(proj_utm)(zone,11)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32612, srs::dpar::parameters<>(proj_utm)(zone,12)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32613, srs::dpar::parameters<>(proj_utm)(zone,13)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32614, srs::dpar::parameters<>(proj_utm)(zone,14)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32615, srs::dpar::parameters<>(proj_utm)(zone,15)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32616, srs::dpar::parameters<>(proj_utm)(zone,16)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32617, srs::dpar::parameters<>(proj_utm)(zone,17)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32618, srs::dpar::parameters<>(proj_utm)(zone,18)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32619, srs::dpar::parameters<>(proj_utm)(zone,19)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32620, srs::dpar::parameters<>(proj_utm)(zone,20)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32621, srs::dpar::parameters<>(proj_utm)(zone,21)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32622, srs::dpar::parameters<>(proj_utm)(zone,22)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32623, srs::dpar::parameters<>(proj_utm)(zone,23)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32624, srs::dpar::parameters<>(proj_utm)(zone,24)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32625, srs::dpar::parameters<>(proj_utm)(zone,25)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32626, srs::dpar::parameters<>(proj_utm)(zone,26)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32627, srs::dpar::parameters<>(proj_utm)(zone,27)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32628, srs::dpar::parameters<>(proj_utm)(zone,28)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32629, srs::dpar::parameters<>(proj_utm)(zone,29)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32630, srs::dpar::parameters<>(proj_utm)(zone,30)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32631, srs::dpar::parameters<>(proj_utm)(zone,31)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32632, srs::dpar::parameters<>(proj_utm)(zone,32)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32633, srs::dpar::parameters<>(proj_utm)(zone,33)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32634, srs::dpar::parameters<>(proj_utm)(zone,34)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32635, srs::dpar::parameters<>(proj_utm)(zone,35)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32636, srs::dpar::parameters<>(proj_utm)(zone,36)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32637, srs::dpar::parameters<>(proj_utm)(zone,37)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32638, srs::dpar::parameters<>(proj_utm)(zone,38)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32639, srs::dpar::parameters<>(proj_utm)(zone,39)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32640, srs::dpar::parameters<>(proj_utm)(zone,40)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32641, srs::dpar::parameters<>(proj_utm)(zone,41)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32642, srs::dpar::parameters<>(proj_utm)(zone,42)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32643, srs::dpar::parameters<>(proj_utm)(zone,43)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32644, srs::dpar::parameters<>(proj_utm)(zone,44)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32645, srs::dpar::parameters<>(proj_utm)(zone,45)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32646, srs::dpar::parameters<>(proj_utm)(zone,46)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32647, srs::dpar::parameters<>(proj_utm)(zone,47)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32648, srs::dpar::parameters<>(proj_utm)(zone,48)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32649, srs::dpar::parameters<>(proj_utm)(zone,49)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32650, srs::dpar::parameters<>(proj_utm)(zone,50)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32651, srs::dpar::parameters<>(proj_utm)(zone,51)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32652, srs::dpar::parameters<>(proj_utm)(zone,52)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32653, srs::dpar::parameters<>(proj_utm)(zone,53)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32654, srs::dpar::parameters<>(proj_utm)(zone,54)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32655, srs::dpar::parameters<>(proj_utm)(zone,55)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32656, srs::dpar::parameters<>(proj_utm)(zone,56)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32657, srs::dpar::parameters<>(proj_utm)(zone,57)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32658, srs::dpar::parameters<>(proj_utm)(zone,58)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32659, srs::dpar::parameters<>(proj_utm)(zone,59)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32660, srs::dpar::parameters<>(proj_utm)(zone,60)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32661, srs::dpar::parameters<>(proj_stere)(lat_0,90)(lat_ts,90)(lon_0,0)(k,0.994)(x_0,2000000)(y_0,2000000)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32662, srs::dpar::parameters<>(proj_eqc)(lat_ts,0)(lat_0,0)(lon_0,0)(x_0,0)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            //{32663},
            {32664, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-99)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(to_meter,0.3048006096012192)(no_defs)},
            {32665, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-93)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(to_meter,0.3048006096012192)(no_defs)},
            {32666, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-87)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(to_meter,0.3048006096012192)(no_defs)},
            {32667, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,-81)(k,0.9996)(x_0,500000.001016002)(y_0,0)(ellps_wgs84)(srs::dpar::datum_wgs84)(to_meter,0.3048006096012192)(no_defs)},
            //{32700},
            {32701, srs::dpar::parameters<>(proj_utm)(zone,1)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32702, srs::dpar::parameters<>(proj_utm)(zone,2)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32703, srs::dpar::parameters<>(proj_utm)(zone,3)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32704, srs::dpar::parameters<>(proj_utm)(zone,4)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32705, srs::dpar::parameters<>(proj_utm)(zone,5)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32706, srs::dpar::parameters<>(proj_utm)(zone,6)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32707, srs::dpar::parameters<>(proj_utm)(zone,7)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32708, srs::dpar::parameters<>(proj_utm)(zone,8)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32709, srs::dpar::parameters<>(proj_utm)(zone,9)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32710, srs::dpar::parameters<>(proj_utm)(zone,10)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32711, srs::dpar::parameters<>(proj_utm)(zone,11)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32712, srs::dpar::parameters<>(proj_utm)(zone,12)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32713, srs::dpar::parameters<>(proj_utm)(zone,13)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32714, srs::dpar::parameters<>(proj_utm)(zone,14)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32715, srs::dpar::parameters<>(proj_utm)(zone,15)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32716, srs::dpar::parameters<>(proj_utm)(zone,16)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32717, srs::dpar::parameters<>(proj_utm)(zone,17)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32718, srs::dpar::parameters<>(proj_utm)(zone,18)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32719, srs::dpar::parameters<>(proj_utm)(zone,19)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32720, srs::dpar::parameters<>(proj_utm)(zone,20)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32721, srs::dpar::parameters<>(proj_utm)(zone,21)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32722, srs::dpar::parameters<>(proj_utm)(zone,22)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32723, srs::dpar::parameters<>(proj_utm)(zone,23)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32724, srs::dpar::parameters<>(proj_utm)(zone,24)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32725, srs::dpar::parameters<>(proj_utm)(zone,25)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32726, srs::dpar::parameters<>(proj_utm)(zone,26)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32727, srs::dpar::parameters<>(proj_utm)(zone,27)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32728, srs::dpar::parameters<>(proj_utm)(zone,28)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32729, srs::dpar::parameters<>(proj_utm)(zone,29)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32730, srs::dpar::parameters<>(proj_utm)(zone,30)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32731, srs::dpar::parameters<>(proj_utm)(zone,31)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32732, srs::dpar::parameters<>(proj_utm)(zone,32)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32733, srs::dpar::parameters<>(proj_utm)(zone,33)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32734, srs::dpar::parameters<>(proj_utm)(zone,34)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32735, srs::dpar::parameters<>(proj_utm)(zone,35)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32736, srs::dpar::parameters<>(proj_utm)(zone,36)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32737, srs::dpar::parameters<>(proj_utm)(zone,37)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32738, srs::dpar::parameters<>(proj_utm)(zone,38)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32739, srs::dpar::parameters<>(proj_utm)(zone,39)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32740, srs::dpar::parameters<>(proj_utm)(zone,40)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32741, srs::dpar::parameters<>(proj_utm)(zone,41)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32742, srs::dpar::parameters<>(proj_utm)(zone,42)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32743, srs::dpar::parameters<>(proj_utm)(zone,43)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32744, srs::dpar::parameters<>(proj_utm)(zone,44)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32745, srs::dpar::parameters<>(proj_utm)(zone,45)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32746, srs::dpar::parameters<>(proj_utm)(zone,46)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32747, srs::dpar::parameters<>(proj_utm)(zone,47)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32748, srs::dpar::parameters<>(proj_utm)(zone,48)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32749, srs::dpar::parameters<>(proj_utm)(zone,49)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32750, srs::dpar::parameters<>(proj_utm)(zone,50)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32751, srs::dpar::parameters<>(proj_utm)(zone,51)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32752, srs::dpar::parameters<>(proj_utm)(zone,52)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32753, srs::dpar::parameters<>(proj_utm)(zone,53)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32754, srs::dpar::parameters<>(proj_utm)(zone,54)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32755, srs::dpar::parameters<>(proj_utm)(zone,55)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32756, srs::dpar::parameters<>(proj_utm)(zone,56)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32757, srs::dpar::parameters<>(proj_utm)(zone,57)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32758, srs::dpar::parameters<>(proj_utm)(zone,58)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32759, srs::dpar::parameters<>(proj_utm)(zone,59)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32760, srs::dpar::parameters<>(proj_utm)(zone,60)(south)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32761, srs::dpar::parameters<>(proj_stere)(lat_0,-90)(lat_ts,-90)(lon_0,0)(k,0.994)(x_0,2000000)(y_0,2000000)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {32766, srs::dpar::parameters<>(proj_tmerc)(lat_0,0)(lon_0,36)(k,0.9996)(x_0,500000)(y_0,10000000)(ellps_wgs84)(srs::dpar::datum_wgs84)(units_m)(no_defs)},
            {61206405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {61216405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-199.87,74.79,246.62,0.0,0.0,0.0,0.0))(no_defs)},
            {61226405, srs::dpar::parameters<>(proj_longlat)(a,6378135)(b,6356750.304921594)(no_defs)},
            {61236405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-96.062,-82.428,-121.753,4.801,-0.345,1.376,0.30857215014565614))(no_defs)},
            {61246405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(414.1,41.3,603.1,-0.855,-2.141,7.023,0.0))(no_defs)},
            {61266405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61266413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61276405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-82.875,-57.097,-156.768,-2.158,-1.524,0.982,-0.07404906544270759))(no_defs)},
            {61286405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {61296405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {61306405, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,-0.0,0.0,0.0,0.0))(no_defs)},
            {61306413, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,-0.0,0.0,0.0,0.0))(no_defs)},
            {61316405, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(towgs84,srs::detail::towgs84<>(182.0,915.0,344.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61326405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-244.72,-162.773,400.75,0.0,0.0,0.0,0.0))(no_defs)},
            {61336405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.055,-0.541,-0.185,0.0183,0.0003,0.007,-0.002887707287459349))(no_defs)},
            {61346405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-191.808,-250.512,167.861,-0.792,-1.653,8.558,4.270300283733636))(no_defs)},
            {61356405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(58.0,-283.0,-182.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61366405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {61376405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {61386405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {61396405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(11.0,72.0,-101.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61406405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0))(no_defs)},
            {61406413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0))(no_defs)},
            {61416405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-48.0,55.0,52.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61426405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-125.0,53.0,467.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61436405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-124.76,53.0,466.79,0.0,0.0,0.0,0.0))(no_defs)},
            {61446405, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(towgs84,srs::detail::towgs84<>(214.0,804.0,268.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61456405, srs::dpar::parameters<>(proj_longlat)(a,6377301.243)(b,6356100.230165384)(towgs84,srs::detail::towgs84<>(275.57,676.78,229.6,0.0,0.0,0.0,0.0))(no_defs)},
            {61466405, srs::dpar::parameters<>(proj_longlat)(a,6377299.151)(b,6356098.145120132)(towgs84,srs::detail::towgs84<>(295.0,736.0,257.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61476405, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(-17.51,-108.32,-62.39,0.0,0.0,0.0,0.0))(no_defs)},
            {61486405, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61486413, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61496405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(674.4,15.1,405.3,0.0,0.0,0.0,0.0))(no_defs)},
            {61506405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(674.374,15.056,405.346,0.0,0.0,0.0,0.0))(no_defs)},
            {61516405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61516413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61526405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0))(no_defs)},
            {61526413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(-0.991,1.9072,0.5129,0.0257899075194932,-0.009650098960270402,-0.011659943232342112,0.0))(no_defs)},
            {61536405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-133.63,-157.5,-158.62,0.0,0.0,0.0,0.0))(no_defs)},
            {61546405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-123.02,-158.95,-168.47,0.0,0.0,0.0,0.0))(no_defs)},
            {61556405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-83.0,37.0,124.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61566405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(559.0,68.7,451.5,7.92,4.073,4.251,1.1777720436709203))(no_defs)},
            {61576405, srs::dpar::parameters<>(proj_longlat)(a,6378293.645208759)(b,6356617.987679838)(no_defs)},
            {61586405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-0.465,372.095,171.736,0.0,0.0,0.0,0.0))(no_defs)},
            {61596405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-114.7,-98.5,-150.7,0.0,0.0,0.0,0.0))(no_defs)},
            {61606405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {61616405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(27.5,14.0,186.4,0.0,0.0,0.0,0.0))(no_defs)},
            {61626405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {61636405, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61636413, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61646405, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(-76.0,-138.0,67.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61656405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-173.0,253.0,27.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61666405, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61676405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61676413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61686405, srs::dpar::parameters<>(proj_longlat)(a,6378300)(b,6356751.689189189)(towgs84,srs::detail::towgs84<>(-199.0,32.0,322.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61696405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-115.0,118.0,426.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61706405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61706413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61716405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61716413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61736405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61736413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61746405, srs::dpar::parameters<>(proj_longlat)(a,6378300)(b,6356751.689189189)(no_defs)},
            {61756405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-88.0,4.0,101.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61766405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61766413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61786405, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(24.0,-123.0,-94.0,0.02,0.25,0.13,0.226891286871806))(no_defs)},
            {61796405, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(33.4,-146.6,-76.3,-0.359,-0.053,0.844,-0.17326243724756094))(no_defs)},
            {61806405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61806413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61816405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-193.0,13.7,-39.3,-0.41,-2.933,2.688,0.08869386668625144))(no_defs)},
            {61826405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-422.651,-172.995,84.02,0.0,0.0,0.0,0.0))(no_defs)},
            {61836405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-104.0,167.0,-38.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61846405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-203.0,141.0,53.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61886405, srs::dpar::parameters<>(proj_longlat)(ellps_airy)(towgs84,srs::detail::towgs84<>(482.5,-130.6,564.6,-1.042,-0.214,-0.631,1.6810581709138355))(no_defs)},
            {61896405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61896413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61906405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61906413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {61916405, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(no_defs)},
            {61926405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-206.1,-174.7,-87.7,0.0,0.0,0.0,0.0))(no_defs)},
            {61936405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-70.9,-151.8,-41.4,0.0,0.0,0.0,0.0))(no_defs)},
            {61946405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(163.511,127.533,-159.789,0.0,0.0,0.814,-0.12375888374825782))(no_defs)},
            {61956405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(105.0,326.0,-102.5,0.0,0.0,0.814,-0.12375888374825782))(no_defs)},
            {61966405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-45.0,417.0,-3.5,0.0,0.0,0.814,-0.12375888374825782))(no_defs)},
            {61976405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {61986405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {61996405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {62006405, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(no_defs)},
            {62016405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-165.0,-11.0,206.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62026405, srs::dpar::parameters<>(proj_longlat)(ellps_aust_sa)(towgs84,srs::detail::towgs84<>(-124.133,-42.003,137.4,-0.008,-0.557,-0.178,-0.3824149507821167))(no_defs)},
            {62036405, srs::dpar::parameters<>(proj_longlat)(ellps_aust_sa)(towgs84,srs::detail::towgs84<>(-117.763,-51.51,139.061,0.292,-0.443,-0.277,-0.03939657799319541))(no_defs)},
            {62046405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-18.944,-379.364,-24.063,0.04,0.764,-6.431,0.7543103964456315))(no_defs)},
            {62056405, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(-43.0,-163.0,45.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62066405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {62076405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-288.885,-91.744,126.244,-1.691,-0.41,0.211,-0.948405579124149))(no_defs)},
            {62086405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-161.0,310.0,-145.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62096405, srs::dpar::parameters<>(proj_longlat)(a,6378249.145)(b,6356514.966398753)(towgs84,srs::detail::towgs84<>(-138.0,-105.0,-289.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62106405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-157.0,-2.0,-299.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62116405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(-377.7,675.1,-52.2,0.0,0.0,0.0,0.0))(no_defs)},
            {62126405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(31.95,300.99,419.19,0.0,0.0,0.0,0.0))(no_defs)},
            {62136405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-106.0,-87.0,188.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62146405, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(15.8,-154.4,-82.3,0.0,0.0,0.0,0.0))(no_defs)},
            {62156405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {62166405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-73.0,213.0,296.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62186405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(304.5,306.5,-318.1,0.0,0.0,0.0,0.0))(no_defs)},
            {62196405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(-384.0,664.0,-48.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62206405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-50.9,-347.6,-231.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62216405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-154.5,150.7,100.4,0.0,0.0,0.0,0.0))(no_defs)},
            {62226405, srs::dpar::parameters<>(proj_longlat)(a,6378249.145)(b,6356514.966398753)(towgs84,srs::detail::towgs84<>(-136.0,-108.0,-292.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62236405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-260.1,5.5,432.2,0.0,0.0,0.0,0.0))(no_defs)},
            {62246405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-134.0,229.0,-29.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62256405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-206.0,172.0,-6.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62276405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-83.58,-397.54,458.78,-17.595,-2.847,4.256,0.6652040001468859))(no_defs)},
            {62296405, srs::dpar::parameters<>(proj_longlat)(ellps_helmert)(towgs84,srs::detail::towgs84<>(-130.0,110.0,-13.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62306405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-157.89,-17.16,-78.41,2.118,2.697,-1.434,-1.1097046576093785))(no_defs)},
            {62316405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-82.981,-99.719,-110.709,-0.10470001565102613,0.031001600378938583,0.08040202147511816,-0.06482902860346239))(no_defs)},
            {62326405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-346.0,-1.0,224.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62336405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-133.0,-321.0,50.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62366405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-637.0,-549.0,-203.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62376405, srs::dpar::parameters<>(proj_longlat)(ellps_grs67)(towgs84,srs::detail::towgs84<>(57.01,-69.97,-9.29,0.0,0.0,0.0,0.0))(no_defs)},
            {62386405, srs::dpar::parameters<>(proj_longlat)(a,6378160)(b,6356774.50408554)(towgs84,srs::detail::towgs84<>(-1.977,-13.06,-9.993,0.364,-0.254,-0.689,-0.2138966040782389))(no_defs)},
            {62396405, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(towgs84,srs::detail::towgs84<>(217.0,823.0,299.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62406405, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(towgs84,srs::detail::towgs84<>(204.64,834.74,293.8,0.0,0.0,0.0,0.0))(no_defs)},
            {62416405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {62426405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-33.722,153.789,94.959,-8.581,4.478,-4.54,1.8460700159115124))(no_defs)},
            {62436405, srs::dpar::parameters<>(proj_longlat)(a,6377299.36559538)(b,6356098.357204818)(no_defs)},
            {62446405, srs::dpar::parameters<>(proj_longlat)(a,6377276.345)(b,6356075.41314024)(towgs84,srs::detail::towgs84<>(-97.0,787.0,86.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62456405, srs::dpar::parameters<>(proj_longlat)(a,6377304.063)(b,6356103.038993155)(towgs84,srs::detail::towgs84<>(-11.0,851.0,5.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62466405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-294.7,-200.1,525.5,0.0,0.0,0.0,0.0))(no_defs)},
            {62476405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-273.5,110.6,-357.9,0.0,0.0,0.0,0.0))(no_defs)},
            {62486405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-307.7,265.3,-363.5,0.0,0.0,0.0,0.0))(no_defs)},
            {62496405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {62506405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-130.0,29.0,364.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62516405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-90.0,40.0,88.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62526405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {62536405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(-133.0,-77.0,-51.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62546405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(18.38,192.45,96.82,0.056,-0.142,-0.2,-0.0002681442481212253))(no_defs)},
            {62556405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-333.0,-222.0,114.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62566405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(41.0,-220.0,-134.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62576405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(-587.8,519.75,145.76,0.0,0.0,0.0,0.0))(no_defs)},
            {62586405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62586413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62596405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-254.1,-5.36,-100.29,0.0,0.0,0.0,0.0))(no_defs)},
            {62616405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(31.0,146.0,47.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62626405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(639.0,405.0,60.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62636405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-90.2,-87.32,114.17,0.0,0.0,0.0,0.0))(no_defs)},
            {62646405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-252.95,-4.11,-96.38,0.0,0.0,0.0,0.0))(no_defs)},
            {62656405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-50.2,-50.4,84.8,-0.69,-2.012,0.459,-5.791915759418465))(no_defs)},
            {62666405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-80.7,-132.5,41.1,0.0,0.0,0.0,0.0))(no_defs)},
            {62676405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(srs::dpar::datum_nad27)(no_defs)},
            {62686405, srs::dpar::parameters<>(proj_longlat)(a,6378450.047548896)(b,6356826.621488444)(no_defs)},
            {62696405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(srs::dpar::datum_nad83)(no_defs)},
            {62706405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-245.0,-153.9,382.8,0.0,0.0,0.0,0.0))(no_defs)},
            {62716405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-2.0,374.0,172.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62726405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(srs::dpar::datum_nzgd49)(no_defs)},
            {62736405, srs::dpar::parameters<>(proj_longlat)(a,6377492.018)(b,6356173.508712696)(towgs84,srs::detail::towgs84<>(278.3,93.0,474.5,7.889,0.05,-6.61,1.2809044467944684))(no_defs)},
            {62746405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-239.749,88.181,30.488,0.263,-0.082,-1.211,0.4597642531247778))(no_defs)},
            {62756405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-168.0,-60.0,320.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62766405, srs::dpar::parameters<>(proj_longlat)(ellps_wgs66)(no_defs)},
            {62776405, srs::dpar::parameters<>(proj_longlat)(ellps_airy)(srs::dpar::datum_osgb36)(no_defs)},
            {62786405, srs::dpar::parameters<>(proj_longlat)(ellps_airy)(no_defs)},
            {62796405, srs::dpar::parameters<>(proj_longlat)(ellps_airy)(no_defs)},
            {62806405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {62816405, srs::dpar::parameters<>(proj_longlat)(a,6378300.789)(b,6356566.435)(towgs84,srs::detail::towgs84<>(-275.7224,94.7824,340.8944,-8.001,-4.42,-11.821,0.20626480624709637))(no_defs)},
            {62826405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-178.3,-316.7,-131.5,5.278,6.077,10.979,3.953271276531849))(no_defs)},
            {62836405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62836413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62846405, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(-40.595,-18.55,-69.339,2.508,-1.832,2.611,-0.8867324020562674))(no_defs)},
            {62856405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-128.033,-283.697,21.052,0.0,0.0,0.0,0.0))(no_defs)},
            {62866405, srs::dpar::parameters<>(proj_longlat)(ellps_helmert)(no_defs)},
            {62886405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {62896405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(565.04,49.91,465.84,-0.40939438743923684,-0.35970519561431136,1.868491000350572,0.8409828680306614))(no_defs)},
            {62926405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-355.0,21.0,72.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62936405, srs::dpar::parameters<>(proj_longlat)(ellps_bess_nam)(towgs84,srs::detail::towgs84<>(616.0,97.0,-251.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62956405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {62976405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-189.0,-242.0,-91.0,0.0,0.0,0.0,0.0))(no_defs)},
            {62986405, srs::dpar::parameters<>(proj_longlat)(ellps_evrstss)(towgs84,srs::detail::towgs84<>(-533.4,669.2,-52.5,0.0,0.0,4.28,1.9388891787227058))(no_defs)},
            {62996405, srs::dpar::parameters<>(proj_longlat)(a,6377340.189)(b,6356034.447938534)(towgs84,srs::detail::towgs84<>(482.5,-130.6,564.6,-1.042,-0.214,-0.631,1.6810581709138355))(no_defs)},
            {63006405, srs::dpar::parameters<>(proj_longlat)(a,6377340.189)(b,6356034.447938534)(towgs84,srs::detail::towgs84<>(482.5,-130.6,564.6,-1.042,-0.214,-0.631,1.6810581709138355))(no_defs)},
            {63016405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(-147.0,506.0,687.0,0.0,0.0,0.0,0.0))(no_defs)},
            {63026405, srs::dpar::parameters<>(proj_longlat)(a,6378293.645208759)(b,6356617.987679838)(towgs84,srs::detail::towgs84<>(-61.702,284.488,472.052,0.0,0.0,0.0,0.0))(no_defs)},
            {63036405, srs::dpar::parameters<>(proj_longlat)(ellps_helmert)(no_defs)},
            {63046405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-73.0,-247.0,227.0,0.0,0.0,0.0,0.0))(no_defs)},
            {63066405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {63076405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-169.559,-72.34,303.102,0.0,0.0,0.0,0.0))(no_defs)},
            {63086405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(no_defs)},
            {63096405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-155.0,171.0,37.0,0.0,0.0,0.0,0.0))(no_defs)},
            {63106405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(no_defs)},
            {63116405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-265.0,120.0,-358.0,0.0,0.0,0.0,0.0))(no_defs)},
            {63126405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(426.9,142.6,460.1,4.91,4.49,-12.42,3.5271281868253483))(no_defs)},
            {63136405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-106.8686,52.2978,-103.7239,0.3366,0.457,-1.8422,0.26292574852317374))(no_defs)},
            {63146405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(srs::dpar::datum_potsdam)(no_defs)},
            {63156405, srs::dpar::parameters<>(proj_longlat)(a,6378249.2)(b,6356515)(towgs84,srs::detail::towgs84<>(-23.0,259.0,-9.0,0.0,0.0,0.0,0.0))(no_defs)},
            {63166405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(103.25,-100.4,-307.19,0.0,0.0,0.0,0.0))(no_defs)},
            {63176405, srs::dpar::parameters<>(proj_longlat)(ellps_krass)(towgs84,srs::detail::towgs84<>(28.0,-121.0,-77.0,0.0,0.0,0.0,0.0))(no_defs)},
            {63186405, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(-3.2,-5.7,2.8,0.0,0.0,0.0,0.0))(no_defs)},
            {63196405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(226.702,-193.337,-35.371,-2.229,4.391,-9.238,0.20209825716090501))(no_defs)},
            {63226405, srs::dpar::parameters<>(proj_longlat)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0.0,0.0,4.5,0.0,0.0,0.554,0.045171992568114105))(no_defs)},
            {63246405, srs::dpar::parameters<>(proj_longlat)(ellps_wgs72)(towgs84,srs::detail::towgs84<>(0.0,0.0,1.9,0.0,0.0,0.814,-0.07838062637389662))(no_defs)},
            {63266405, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(srs::dpar::datum_wgs84)(no_defs)},
            //{63266406},
            //{63266407},
            //{63266408},
            //{63266409},
            //{63266410},
            {63266411, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(srs::dpar::datum_wgs84)(no_defs)},
            //{63266412},
            {63266413, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(srs::dpar::datum_wgs84)(no_defs)},
            //{63266414},
            //{63266415},
            //{63266416},
            //{63266417},
            //{63266418},
            {63266419, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(srs::dpar::datum_wgs84)(no_defs)},
            //{63266420},
            {66006405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(no_defs)},
            {66016405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-255.0,-15.0,71.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66026405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(725.0,685.0,536.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66036405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(72.0,213.7,93.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66046405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(174.0,359.0,365.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66056405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(9.0,183.0,236.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66066405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-149.0,128.0,296.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66076405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(195.671,332.517,274.607,0.0,0.0,0.0,0.0))(no_defs)},
            {66086405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {66096405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(no_defs)},
            {66106405, srs::dpar::parameters<>(proj_longlat)(a,6378140)(b,6356755.288157528)(no_defs)},
            {66116405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-162.619,-276.959,-161.764,0.067753,-2.243649,-1.158827,-0.22570443917666022))(no_defs)},
            {66126405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66126413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66136405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(-404.78,685.68,45.47,0.0,0.0,0.0,0.0))(no_defs)},
            {66146405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-119.4248,-303.65872,-11.00061,1.164298,0.174458,1.096259,0.7543238036580374))(no_defs)},
            {66156405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-499.0,-249.0,314.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66166405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-289.0,-124.0,60.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66186405, srs::dpar::parameters<>(proj_longlat)(ellps_aust_sa)(towgs84,srs::detail::towgs84<>(-66.87,4.37,-38.52,0.0,0.0,0.0,0.0))(no_defs)},
            {66196405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66196413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66206405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk80)(towgs84,srs::detail::towgs84<>(-106.0,-129.0,165.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66216405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(137.0,248.0,-430.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66226405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-472.29,-5.63,-304.12,0.4362,-0.8374,0.2563,0.39157310817948776))(no_defs)},
            {66236405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-186.0,230.0,110.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66246405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(2.0,2.0,-2.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66246413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(2.0,2.0,-2.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66256405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(126.93,547.94,130.41,-2.7867,5.1612,-0.8584,2.851136537311739))(no_defs)},
            {66266405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(94.0,-948.0,-1262.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66276405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66276413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66286405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(162.0,117.0,154.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66296405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(72.438,345.918,79.486,1.6045,-0.8823,-0.5565,0.2835316026672587))(no_defs)},
            {66306405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(259.551,297.612,197.833,-1.4866,2.1224,0.4612,5.574285762347154))(no_defs)},
            {66316405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(145.0,-187.0,103.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66326405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-382.0,-59.0,-262.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66336405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(335.47,222.58,-230.94,0.0,0.0,0.0,0.0))(no_defs)},
            {66346405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-11.64,-348.6,291.98,0.0,0.0,0.0,0.0))(no_defs)},
            {66356405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-122.383,-188.696,103.344,3.5107,-4.9668,-5.7047,0.9240250790257423))(no_defs)},
            {66366405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(365.0,194.0,166.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66376405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(325.0,154.0,172.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66386405, srs::dpar::parameters<>(proj_longlat)(ellps_clrk66)(towgs84,srs::detail::towgs84<>(30.0,430.0,368.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66396405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(253.0,-132.0,-127.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66406405, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66406413, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66416405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(287.58,177.78,-135.41,0.0,0.0,0.0,0.0))(no_defs)},
            {66426405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-13.0,-348.0,292.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66436405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-480.26,-438.32,-643.429,16.3119,20.1721,-4.0349,-23.039820110761912))(no_defs)},
            {66446405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-10.18,-350.43,291.37,0.0,0.0,0.0,0.0))(no_defs)},
            {66456405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66456413, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66466405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(no_defs)},
            {66576405, srs::dpar::parameters<>(proj_longlat)(a,6377019.27)(b,6355762.5391)(towgs84,srs::detail::towgs84<>(-28.0,199.0,5.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66586405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-73.0,46.0,-86.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66596405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66596413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66606405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(982.6087,552.753,-540.873,6.681626625276941,-31.61149240864225,-19.848161004816845,3.466280068982454))(no_defs)},
            {66616405, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66616413, srs::dpar::parameters<>(proj_longlat)(ellps_grs80)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {66636405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-210.502,-66.902,-48.476,2.094,15.067,5.817,0.10003843102984174))(no_defs)},
            {66646405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-208.719,129.685,52.092,-0.195,0.014,-0.327,0.040840431636925086))(no_defs)},
            {66656405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(towgs84,srs::detail::towgs84<>(-103.088,162.481,-28.276,0.167,-0.082,-0.168,-0.31022226859563296))(no_defs)},
            {66666405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(towgs84,srs::detail::towgs84<>(631.392,-66.551,481.442,1.09,4.445,4.487,-0.9137530916746368))(no_defs)},
            {66676405, srs::dpar::parameters<>(proj_longlat)(ellps_wgs84)(towgs84,srs::detail::towgs84<>(0.0,0.0,0.0,0.0,0.0,0.0,0.0))(no_defs)},
            {68016405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_bern)(no_defs)},
            {68026405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(pm_bogota)(no_defs)},
            {68036405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(pm_lisbon)(no_defs)},
            {68046405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_jakarta)(no_defs)},
            {68056405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_ferro)(no_defs)},
            {68066405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(pm_rome)(no_defs)},
            {68086405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_jakarta)(no_defs)},
            {68096405, srs::dpar::parameters<>(proj_longlat)(ellps_intl)(pm_brussels)(no_defs)},
            {68136405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_jakarta)(no_defs)},
            {68146405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_stockholm)(no_defs)},
            {68156405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_athens)(no_defs)},
            {68186405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_ferro)(no_defs)},
            {68206405, srs::dpar::parameters<>(proj_longlat)(ellps_bessel)(pm_jakarta)(no_defs)},
            {69036405, srs::dpar::parameters<>(proj_longlat)(a,6378298.3)(b,6356657.142669561)(pm_madrid)(no_defs)}
        };

        const code_element * first = arr;
        const code_element * last = arr + sizeof(arr) / sizeof(code_element);
        const code_element * el = binary_find_code_element(first, last, code);

        return el != last ? el->parameters : srs::dpar::parameters<>();
    }

}
#endif // DOXYGEN_NO_DETAIL


}}} // namespace boost::geometry::projections

#endif
