#include <stdint.h>
#include "test.h"
#include <stddef.h>

typedef uint32_t uint32;
typedef uint8_t uint8;
typedef uint32_t pg_crc32c;

// Simulated CRC table (values don't matter for reproducing the bug)
pg_crc32c pg_crc32c_table[8][256] = {
    	{
		0x00000000, 0x03836BF2, 0xF7703BE1, 0xF4F35013,
		0x1F979AC7, 0x1C14F135, 0xE8E7A126, 0xEB64CAD4,
		0xCF58D98A, 0xCCDBB278, 0x3828E26B, 0x3BAB8999,
		0xD0CF434D, 0xD34C28BF, 0x27BF78AC, 0x243C135E,
		0x6FC75E10, 0x6C4435E2, 0x98B765F1, 0x9B340E03,
		0x7050C4D7, 0x73D3AF25, 0x8720FF36, 0x84A394C4,
		0xA09F879A, 0xA31CEC68, 0x57EFBC7B, 0x546CD789,
		0xBF081D5D, 0xBC8B76AF, 0x487826BC, 0x4BFB4D4E,
		0xDE8EBD20, 0xDD0DD6D2, 0x29FE86C1, 0x2A7DED33,
		0xC11927E7, 0xC29A4C15, 0x36691C06, 0x35EA77F4,
		0x11D664AA, 0x12550F58, 0xE6A65F4B, 0xE52534B9,
		0x0E41FE6D, 0x0DC2959F, 0xF931C58C, 0xFAB2AE7E,
		0xB149E330, 0xB2CA88C2, 0x4639D8D1, 0x45BAB323,
		0xAEDE79F7, 0xAD5D1205, 0x59AE4216, 0x5A2D29E4,
		0x7E113ABA, 0x7D925148, 0x8961015B, 0x8AE26AA9,
		0x6186A07D, 0x6205CB8F, 0x96F69B9C, 0x9575F06E,
		0xBC1D7B41, 0xBF9E10B3, 0x4B6D40A0, 0x48EE2B52,
		0xA38AE186, 0xA0098A74, 0x54FADA67, 0x5779B195,
		0x7345A2CB, 0x70C6C939, 0x8435992A, 0x87B6F2D8,
		0x6CD2380C, 0x6F5153FE, 0x9BA203ED, 0x9821681F,
		0xD3DA2551, 0xD0594EA3, 0x24AA1EB0, 0x27297542,
		0xCC4DBF96, 0xCFCED464, 0x3B3D8477, 0x38BEEF85,
		0x1C82FCDB, 0x1F019729, 0xEBF2C73A, 0xE871ACC8,
		0x0315661C, 0x00960DEE, 0xF4655DFD, 0xF7E6360F,
		0x6293C661, 0x6110AD93, 0x95E3FD80, 0x96609672,
		0x7D045CA6, 0x7E873754, 0x8A746747, 0x89F70CB5,
		0xADCB1FEB, 0xAE487419, 0x5ABB240A, 0x59384FF8,
		0xB25C852C, 0xB1DFEEDE, 0x452CBECD, 0x46AFD53F,
		0x0D549871, 0x0ED7F383, 0xFA24A390, 0xF9A7C862,
		0x12C302B6, 0x11406944, 0xE5B33957, 0xE63052A5,
		0xC20C41FB, 0xC18F2A09, 0x357C7A1A, 0x36FF11E8,
		0xDD9BDB3C, 0xDE18B0CE, 0x2AEBE0DD, 0x29688B2F,
		0x783BF682, 0x7BB89D70, 0x8F4BCD63, 0x8CC8A691,
		0x67AC6C45, 0x642F07B7, 0x90DC57A4, 0x935F3C56,
		0xB7632F08, 0xB4E044FA, 0x401314E9, 0x43907F1B,
		0xA8F4B5CF, 0xAB77DE3D, 0x5F848E2E, 0x5C07E5DC,
		0x17FCA892, 0x147FC360, 0xE08C9373, 0xE30FF881,
		0x086B3255, 0x0BE859A7, 0xFF1B09B4, 0xFC986246,
		0xD8A47118, 0xDB271AEA, 0x2FD44AF9, 0x2C57210B,
		0xC733EBDF, 0xC4B0802D, 0x3043D03E, 0x33C0BBCC,
		0xA6B54BA2, 0xA5362050, 0x51C57043, 0x52461BB1,
		0xB922D165, 0xBAA1BA97, 0x4E52EA84, 0x4DD18176,
		0x69ED9228, 0x6A6EF9DA, 0x9E9DA9C9, 0x9D1EC23B,
		0x767A08EF, 0x75F9631D, 0x810A330E, 0x828958FC,
		0xC97215B2, 0xCAF17E40, 0x3E022E53, 0x3D8145A1,
		0xD6E58F75, 0xD566E487, 0x2195B494, 0x2216DF66,
		0x062ACC38, 0x05A9A7CA, 0xF15AF7D9, 0xF2D99C2B,
		0x19BD56FF, 0x1A3E3D0D, 0xEECD6D1E, 0xED4E06EC,
		0xC4268DC3, 0xC7A5E631, 0x3356B622, 0x30D5DDD0,
		0xDBB11704, 0xD8327CF6, 0x2CC12CE5, 0x2F424717,
		0x0B7E5449, 0x08FD3FBB, 0xFC0E6FA8, 0xFF8D045A,
		0x14E9CE8E, 0x176AA57C, 0xE399F56F, 0xE01A9E9D,
		0xABE1D3D3, 0xA862B821, 0x5C91E832, 0x5F1283C0,
		0xB4764914, 0xB7F522E6, 0x430672F5, 0x40851907,
		0x64B90A59, 0x673A61AB, 0x93C931B8, 0x904A5A4A,
		0x7B2E909E, 0x78ADFB6C, 0x8C5EAB7F, 0x8FDDC08D,
		0x1AA830E3, 0x192B5B11, 0xEDD80B02, 0xEE5B60F0,
		0x053FAA24, 0x06BCC1D6, 0xF24F91C5, 0xF1CCFA37,
		0xD5F0E969, 0xD673829B, 0x2280D288, 0x2103B97A,
		0xCA6773AE, 0xC9E4185C, 0x3D17484F, 0x3E9423BD,
		0x756F6EF3, 0x76EC0501, 0x821F5512, 0x819C3EE0,
		0x6AF8F434, 0x697B9FC6, 0x9D88CFD5, 0x9E0BA427,
		0xBA37B779, 0xB9B4DC8B, 0x4D478C98, 0x4EC4E76A,
		0xA5A02DBE, 0xA623464C, 0x52D0165F, 0x51537DAD,
	},
	{
		0x00000000, 0x7798A213, 0xEE304527, 0x99A8E734,
		0xDC618A4E, 0xABF9285D, 0x3251CF69, 0x45C96D7A,
		0xB8C3149D, 0xCF5BB68E, 0x56F351BA, 0x216BF3A9,
		0x64A29ED3, 0x133A3CC0, 0x8A92DBF4, 0xFD0A79E7,
		0x81F1C53F, 0xF669672C, 0x6FC18018, 0x1859220B,
		0x5D904F71, 0x2A08ED62, 0xB3A00A56, 0xC438A845,
		0x3932D1A2, 0x4EAA73B1, 0xD7029485, 0xA09A3696,
		0xE5535BEC, 0x92CBF9FF, 0x0B631ECB, 0x7CFBBCD8,
		0x02E38B7F, 0x757B296C, 0xECD3CE58, 0x9B4B6C4B,
		0xDE820131, 0xA91AA322, 0x30B24416, 0x472AE605,
		0xBA209FE2, 0xCDB83DF1, 0x5410DAC5, 0x238878D6,
		0x664115AC, 0x11D9B7BF, 0x8871508B, 0xFFE9F298,
		0x83124E40, 0xF48AEC53, 0x6D220B67, 0x1ABAA974,
		0x5F73C40E, 0x28EB661D, 0xB1438129, 0xC6DB233A,
		0x3BD15ADD, 0x4C49F8CE, 0xD5E11FFA, 0xA279BDE9,
		0xE7B0D093, 0x90287280, 0x098095B4, 0x7E1837A7,
		0x04C617FF, 0x735EB5EC, 0xEAF652D8, 0x9D6EF0CB,
		0xD8A79DB1, 0xAF3F3FA2, 0x3697D896, 0x410F7A85,
		0xBC050362, 0xCB9DA171, 0x52354645, 0x25ADE456,
		0x6064892C, 0x17FC2B3F, 0x8E54CC0B, 0xF9CC6E18,
		0x8537D2C0, 0xF2AF70D3, 0x6B0797E7, 0x1C9F35F4,
		0x5956588E, 0x2ECEFA9D, 0xB7661DA9, 0xC0FEBFBA,
		0x3DF4C65D, 0x4A6C644E, 0xD3C4837A, 0xA45C2169,
		0xE1954C13, 0x960DEE00, 0x0FA50934, 0x783DAB27,
		0x06259C80, 0x71BD3E93, 0xE815D9A7, 0x9F8D7BB4,
		0xDA4416CE, 0xADDCB4DD, 0x347453E9, 0x43ECF1FA,
		0xBEE6881D, 0xC97E2A0E, 0x50D6CD3A, 0x274E6F29,
		0x62870253, 0x151FA040, 0x8CB74774, 0xFB2FE567,
		0x87D459BF, 0xF04CFBAC, 0x69E41C98, 0x1E7CBE8B,
		0x5BB5D3F1, 0x2C2D71E2, 0xB58596D6, 0xC21D34C5,
		0x3F174D22, 0x488FEF31, 0xD1270805, 0xA6BFAA16,
		0xE376C76C, 0x94EE657F, 0x0D46824B, 0x7ADE2058,
		0xF9FAC3FB, 0x8E6261E8, 0x17CA86DC, 0x605224CF,
		0x259B49B5, 0x5203EBA6, 0xCBAB0C92, 0xBC33AE81,
		0x4139D766, 0x36A17575, 0xAF099241, 0xD8913052,
		0x9D585D28, 0xEAC0FF3B, 0x7368180F, 0x04F0BA1C,
		0x780B06C4, 0x0F93A4D7, 0x963B43E3, 0xE1A3E1F0,
		0xA46A8C8A, 0xD3F22E99, 0x4A5AC9AD, 0x3DC26BBE,
		0xC0C81259, 0xB750B04A, 0x2EF8577E, 0x5960F56D,
		0x1CA99817, 0x6B313A04, 0xF299DD30, 0x85017F23,
		0xFB194884, 0x8C81EA97, 0x15290DA3, 0x62B1AFB0,
		0x2778C2CA, 0x50E060D9, 0xC94887ED, 0xBED025FE,
		0x43DA5C19, 0x3442FE0A, 0xADEA193E, 0xDA72BB2D,
		0x9FBBD657, 0xE8237444, 0x718B9370, 0x06133163,
		0x7AE88DBB, 0x0D702FA8, 0x94D8C89C, 0xE3406A8F,
		0xA68907F5, 0xD111A5E6, 0x48B942D2, 0x3F21E0C1,
		0xC22B9926, 0xB5B33B35, 0x2C1BDC01, 0x5B837E12,
		0x1E4A1368, 0x69D2B17B, 0xF07A564F, 0x87E2F45C,
		0xFD3CD404, 0x8AA47617, 0x130C9123, 0x64943330,
		0x215D5E4A, 0x56C5FC59, 0xCF6D1B6D, 0xB8F5B97E,
		0x45FFC099, 0x3267628A, 0xABCF85BE, 0xDC5727AD,
		0x999E4AD7, 0xEE06E8C4, 0x77AE0FF0, 0x0036ADE3,
		0x7CCD113B, 0x0B55B328, 0x92FD541C, 0xE565F60F,
		0xA0AC9B75, 0xD7343966, 0x4E9CDE52, 0x39047C41,
		0xC40E05A6, 0xB396A7B5, 0x2A3E4081, 0x5DA6E292,
		0x186F8FE8, 0x6FF72DFB, 0xF65FCACF, 0x81C768DC,
		0xFFDF5F7B, 0x8847FD68, 0x11EF1A5C, 0x6677B84F,
		0x23BED535, 0x54267726, 0xCD8E9012, 0xBA163201,
		0x471C4BE6, 0x3084E9F5, 0xA92C0EC1, 0xDEB4ACD2,
		0x9B7DC1A8, 0xECE563BB, 0x754D848F, 0x02D5269C,
		0x7E2E9A44, 0x09B63857, 0x901EDF63, 0xE7867D70,
		0xA24F100A, 0xD5D7B219, 0x4C7F552D, 0x3BE7F73E,
		0xC6ED8ED9, 0xB1752CCA, 0x28DDCBFE, 0x5F4569ED,
		0x1A8C0497, 0x6D14A684, 0xF4BC41B0, 0x8324E3A3,
	},
	{
		0x00000000, 0x7E9241A5, 0x0D526F4F, 0x73C02EEA,
		0x1AA4DE9E, 0x64369F3B, 0x17F6B1D1, 0x6964F074,
		0xC53E5138, 0xBBAC109D, 0xC86C3E77, 0xB6FE7FD2,
		0xDF9A8FA6, 0xA108CE03, 0xD2C8E0E9, 0xAC5AA14C,
		0x8A7DA270, 0xF4EFE3D5, 0x872FCD3F, 0xF9BD8C9A,
		0x90D97CEE, 0xEE4B3D4B, 0x9D8B13A1, 0xE3195204,
		0x4F43F348, 0x31D1B2ED, 0x42119C07, 0x3C83DDA2,
		0x55E72DD6, 0x2B756C73, 0x58B54299, 0x2627033C,
		0x14FB44E1, 0x6A690544, 0x19A92BAE, 0x673B6A0B,
		0x0E5F9A7F, 0x70CDDBDA, 0x030DF530, 0x7D9FB495,
		0xD1C515D9, 0xAF57547C, 0xDC977A96, 0xA2053B33,
		0xCB61CB47, 0xB5F38AE2, 0xC633A408, 0xB8A1E5AD,
		0x9E86E691, 0xE014A734, 0x93D489DE, 0xED46C87B,
		0x8422380F, 0xFAB079AA, 0x89705740, 0xF7E216E5,
		0x5BB8B7A9, 0x252AF60C, 0x56EAD8E6, 0x28789943,
		0x411C6937, 0x3F8E2892, 0x4C4E0678, 0x32DC47DD,
		0xD98065C7, 0xA7122462, 0xD4D20A88, 0xAA404B2D,
		0xC324BB59, 0xBDB6FAFC, 0xCE76D416, 0xB0E495B3,
		0x1CBE34FF, 0x622C755A, 0x11EC5BB0, 0x6F7E1A15,
		0x061AEA61, 0x7888ABC4, 0x0B48852E, 0x75DAC48B,
		0x53FDC7B7, 0x2D6F8612, 0x5EAFA8F8, 0x203DE95D,
		0x49591929, 0x37CB588C, 0x440B7666, 0x3A9937C3,
		0x96C3968F, 0xE851D72A, 0x9B91F9C0, 0xE503B865,
		0x8C674811, 0xF2F509B4, 0x8135275E, 0xFFA766FB,
		0xCD7B2126, 0xB3E96083, 0xC0294E69, 0xBEBB0FCC,
		0xD7DFFFB8, 0xA94DBE1D, 0xDA8D90F7, 0xA41FD152,
		0x0845701E, 0x76D731BB, 0x05171F51, 0x7B855EF4,
		0x12E1AE80, 0x6C73EF25, 0x1FB3C1CF, 0x6121806A,
		0x47068356, 0x3994C2F3, 0x4A54EC19, 0x34C6ADBC,
		0x5DA25DC8, 0x23301C6D, 0x50F03287, 0x2E627322,
		0x8238D26E, 0xFCAA93CB, 0x8F6ABD21, 0xF1F8FC84,
		0x989C0CF0, 0xE60E4D55, 0x95CE63BF, 0xEB5C221A,
		0x4377278B, 0x3DE5662E, 0x4E2548C4, 0x30B70961,
		0x59D3F915, 0x2741B8B0, 0x5481965A, 0x2A13D7FF,
		0x864976B3, 0xF8DB3716, 0x8B1B19FC, 0xF5895859,
		0x9CEDA82D, 0xE27FE988, 0x91BFC762, 0xEF2D86C7,
		0xC90A85FB, 0xB798C45E, 0xC458EAB4, 0xBACAAB11,
		0xD3AE5B65, 0xAD3C1AC0, 0xDEFC342A, 0xA06E758F,
		0x0C34D4C3, 0x72A69566, 0x0166BB8C, 0x7FF4FA29,
		0x16900A5D, 0x68024BF8, 0x1BC26512, 0x655024B7,
		0x578C636A, 0x291E22CF, 0x5ADE0C25, 0x244C4D80,
		0x4D28BDF4, 0x33BAFC51, 0x407AD2BB, 0x3EE8931E,
		0x92B23252, 0xEC2073F7, 0x9FE05D1D, 0xE1721CB8,
		0x8816ECCC, 0xF684AD69, 0x85448383, 0xFBD6C226,
		0xDDF1C11A, 0xA36380BF, 0xD0A3AE55, 0xAE31EFF0,
		0xC7551F84, 0xB9C75E21, 0xCA0770CB, 0xB495316E,
		0x18CF9022, 0x665DD187, 0x159DFF6D, 0x6B0FBEC8,
		0x026B4EBC, 0x7CF90F19, 0x0F3921F3, 0x71AB6056,
		0x9AF7424C, 0xE46503E9, 0x97A52D03, 0xE9376CA6,
		0x80539CD2, 0xFEC1DD77, 0x8D01F39D, 0xF393B238,
		0x5FC91374, 0x215B52D1, 0x529B7C3B, 0x2C093D9E,
		0x456DCDEA, 0x3BFF8C4F, 0x483FA2A5, 0x36ADE300,
		0x108AE03C, 0x6E18A199, 0x1DD88F73, 0x634ACED6,
		0x0A2E3EA2, 0x74BC7F07, 0x077C51ED, 0x79EE1048,
		0xD5B4B104, 0xAB26F0A1, 0xD8E6DE4B, 0xA6749FEE,
		0xCF106F9A, 0xB1822E3F, 0xC24200D5, 0xBCD04170,
		0x8E0C06AD, 0xF09E4708, 0x835E69E2, 0xFDCC2847,
		0x94A8D833, 0xEA3A9996, 0x99FAB77C, 0xE768F6D9,
		0x4B325795, 0x35A01630, 0x466038DA, 0x38F2797F,
		0x5196890B, 0x2F04C8AE, 0x5CC4E644, 0x2256A7E1,
		0x0471A4DD, 0x7AE3E578, 0x0923CB92, 0x77B18A37,
		0x1ED57A43, 0x60473BE6, 0x1387150C, 0x6D1554A9,
		0xC14FF5E5, 0xBFDDB440, 0xCC1D9AAA, 0xB28FDB0F,
		0xDBEB2B7B, 0xA5796ADE, 0xD6B94434, 0xA82B0591,
	},
	{
		0x00000000, 0xB8AA45DD, 0x812367BF, 0x39892262,
		0xF331227B, 0x4B9B67A6, 0x721245C4, 0xCAB80019,
		0xE66344F6, 0x5EC9012B, 0x67402349, 0xDFEA6694,
		0x1552668D, 0xADF82350, 0x94710132, 0x2CDB44EF,
		0x3DB164E9, 0x851B2134, 0xBC920356, 0x0438468B,
		0xCE804692, 0x762A034F, 0x4FA3212D, 0xF70964F0,
		0xDBD2201F, 0x637865C2, 0x5AF147A0, 0xE25B027D,
		0x28E30264, 0x904947B9, 0xA9C065DB, 0x116A2006,
		0x8B1425D7, 0x33BE600A, 0x0A374268, 0xB29D07B5,
		0x782507AC, 0xC08F4271, 0xF9066013, 0x41AC25CE,
		0x6D776121, 0xD5DD24FC, 0xEC54069E, 0x54FE4343,
		0x9E46435A, 0x26EC0687, 0x1F6524E5, 0xA7CF6138,
		0xB6A5413E, 0x0E0F04E3, 0x37862681, 0x8F2C635C,
		0x45946345, 0xFD3E2698, 0xC4B704FA, 0x7C1D4127,
		0x50C605C8, 0xE86C4015, 0xD1E56277, 0x694F27AA,
		0xA3F727B3, 0x1B5D626E, 0x22D4400C, 0x9A7E05D1,
		0xE75FA6AB, 0x5FF5E376, 0x667CC114, 0xDED684C9,
		0x146E84D0, 0xACC4C10D, 0x954DE36F, 0x2DE7A6B2,
		0x013CE25D, 0xB996A780, 0x801F85E2, 0x38B5C03F,
		0xF20DC026, 0x4AA785FB, 0x732EA799, 0xCB84E244,
		0xDAEEC242, 0x6244879F, 0x5BCDA5FD, 0xE367E020,
		0x29DFE039, 0x9175A5E4, 0xA8FC8786, 0x1056C25B,
		0x3C8D86B4, 0x8427C369, 0xBDAEE10B, 0x0504A4D6,
		0xCFBCA4CF, 0x7716E112, 0x4E9FC370, 0xF63586AD,
		0x6C4B837C, 0xD4E1C6A1, 0xED68E4C3, 0x55C2A11E,
		0x9F7AA107, 0x27D0E4DA, 0x1E59C6B8, 0xA6F38365,
		0x8A28C78A, 0x32828257, 0x0B0BA035, 0xB3A1E5E8,
		0x7919E5F1, 0xC1B3A02C, 0xF83A824E, 0x4090C793,
		0x51FAE795, 0xE950A248, 0xD0D9802A, 0x6873C5F7,
		0xA2CBC5EE, 0x1A618033, 0x23E8A251, 0x9B42E78C,
		0xB799A363, 0x0F33E6BE, 0x36BAC4DC, 0x8E108101,
		0x44A88118, 0xFC02C4C5, 0xC58BE6A7, 0x7D21A37A,
		0x3FC9A052, 0x8763E58F, 0xBEEAC7ED, 0x06408230,
		0xCCF88229, 0x7452C7F4, 0x4DDBE596, 0xF571A04B,
		0xD9AAE4A4, 0x6100A179, 0x5889831B, 0xE023C6C6,
		0x2A9BC6DF, 0x92318302, 0xABB8A160, 0x1312E4BD,
		0x0278C4BB, 0xBAD28166, 0x835BA304, 0x3BF1E6D9,
		0xF149E6C0, 0x49E3A31D, 0x706A817F, 0xC8C0C4A2,
		0xE41B804D, 0x5CB1C590, 0x6538E7F2, 0xDD92A22F,
		0x172AA236, 0xAF80E7EB, 0x9609C589, 0x2EA38054,
		0xB4DD8585, 0x0C77C058, 0x35FEE23A, 0x8D54A7E7,
		0x47ECA7FE, 0xFF46E223, 0xC6CFC041, 0x7E65859C,
		0x52BEC173, 0xEA1484AE, 0xD39DA6CC, 0x6B37E311,
		0xA18FE308, 0x1925A6D5, 0x20AC84B7, 0x9806C16A,
		0x896CE16C, 0x31C6A4B1, 0x084F86D3, 0xB0E5C30E,
		0x7A5DC317, 0xC2F786CA, 0xFB7EA4A8, 0x43D4E175,
		0x6F0FA59A, 0xD7A5E047, 0xEE2CC225, 0x568687F8,
		0x9C3E87E1, 0x2494C23C, 0x1D1DE05E, 0xA5B7A583,
		0xD89606F9, 0x603C4324, 0x59B56146, 0xE11F249B,
		0x2BA72482, 0x930D615F, 0xAA84433D, 0x122E06E0,
		0x3EF5420F, 0x865F07D2, 0xBFD625B0, 0x077C606D,
		0xCDC46074, 0x756E25A9, 0x4CE707CB, 0xF44D4216,
		0xE5276210, 0x5D8D27CD, 0x640405AF, 0xDCAE4072,
		0x1616406B, 0xAEBC05B6, 0x973527D4, 0x2F9F6209,
		0x034426E6, 0xBBEE633B, 0x82674159, 0x3ACD0484,
		0xF075049D, 0x48DF4140, 0x71566322, 0xC9FC26FF,
		0x5382232E, 0xEB2866F3, 0xD2A14491, 0x6A0B014C,
		0xA0B30155, 0x18194488, 0x219066EA, 0x993A2337,
		0xB5E167D8, 0x0D4B2205, 0x34C20067, 0x8C6845BA,
		0x46D045A3, 0xFE7A007E, 0xC7F3221C, 0x7F5967C1,
		0x6E3347C7, 0xD699021A, 0xEF102078, 0x57BA65A5,
		0x9D0265BC, 0x25A82061, 0x1C210203, 0xA48B47DE,
		0x88500331, 0x30FA46EC, 0x0973648E, 0xB1D92153,
		0x7B61214A, 0xC3CB6497, 0xFA4246F5, 0x42E80328,
	},
	{
		0x00000000, 0xAC6F1138, 0x58DF2270, 0xF4B03348,
		0xB0BE45E0, 0x1CD154D8, 0xE8616790, 0x440E76A8,
		0x910B67C5, 0x3D6476FD, 0xC9D445B5, 0x65BB548D,
		0x21B52225, 0x8DDA331D, 0x796A0055, 0xD505116D,
		0xD361228F, 0x7F0E33B7, 0x8BBE00FF, 0x27D111C7,
		0x63DF676F, 0xCFB07657, 0x3B00451F, 0x976F5427,
		0x426A454A, 0xEE055472, 0x1AB5673A, 0xB6DA7602,
		0xF2D400AA, 0x5EBB1192, 0xAA0B22DA, 0x066433E2,
		0x57B5A81B, 0xFBDAB923, 0x0F6A8A6B, 0xA3059B53,
		0xE70BEDFB, 0x4B64FCC3, 0xBFD4CF8B, 0x13BBDEB3,
		0xC6BECFDE, 0x6AD1DEE6, 0x9E61EDAE, 0x320EFC96,
		0x76008A3E, 0xDA6F9B06, 0x2EDFA84E, 0x82B0B976,
		0x84D48A94, 0x28BB9BAC, 0xDC0BA8E4, 0x7064B9DC,
		0x346ACF74, 0x9805DE4C, 0x6CB5ED04, 0xC0DAFC3C,
		0x15DFED51, 0xB9B0FC69, 0x4D00CF21, 0xE16FDE19,
		0xA561A8B1, 0x090EB989, 0xFDBE8AC1, 0x51D19BF9,
		0xAE6A5137, 0x0205400F, 0xF6B57347, 0x5ADA627F,
		0x1ED414D7, 0xB2BB05EF, 0x460B36A7, 0xEA64279F,
		0x3F6136F2, 0x930E27CA, 0x67BE1482, 0xCBD105BA,
		0x8FDF7312, 0x23B0622A, 0xD7005162, 0x7B6F405A,
		0x7D0B73B8, 0xD1646280, 0x25D451C8, 0x89BB40F0,
		0xCDB53658, 0x61DA2760, 0x956A1428, 0x39050510,
		0xEC00147D, 0x406F0545, 0xB4DF360D, 0x18B02735,
		0x5CBE519D, 0xF0D140A5, 0x046173ED, 0xA80E62D5,
		0xF9DFF92C, 0x55B0E814, 0xA100DB5C, 0x0D6FCA64,
		0x4961BCCC, 0xE50EADF4, 0x11BE9EBC, 0xBDD18F84,
		0x68D49EE9, 0xC4BB8FD1, 0x300BBC99, 0x9C64ADA1,
		0xD86ADB09, 0x7405CA31, 0x80B5F979, 0x2CDAE841,
		0x2ABEDBA3, 0x86D1CA9B, 0x7261F9D3, 0xDE0EE8EB,
		0x9A009E43, 0x366F8F7B, 0xC2DFBC33, 0x6EB0AD0B,
		0xBBB5BC66, 0x17DAAD5E, 0xE36A9E16, 0x4F058F2E,
		0x0B0BF986, 0xA764E8BE, 0x53D4DBF6, 0xFFBBCACE,
		0x5CD5A26E, 0xF0BAB356, 0x040A801E, 0xA8659126,
		0xEC6BE78E, 0x4004F6B6, 0xB4B4C5FE, 0x18DBD4C6,
		0xCDDEC5AB, 0x61B1D493, 0x9501E7DB, 0x396EF6E3,
		0x7D60804B, 0xD10F9173, 0x25BFA23B, 0x89D0B303,
		0x8FB480E1, 0x23DB91D9, 0xD76BA291, 0x7B04B3A9,
		0x3F0AC501, 0x9365D439, 0x67D5E771, 0xCBBAF649,
		0x1EBFE724, 0xB2D0F61C, 0x4660C554, 0xEA0FD46C,
		0xAE01A2C4, 0x026EB3FC, 0xF6DE80B4, 0x5AB1918C,
		0x0B600A75, 0xA70F1B4D, 0x53BF2805, 0xFFD0393D,
		0xBBDE4F95, 0x17B15EAD, 0xE3016DE5, 0x4F6E7CDD,
		0x9A6B6DB0, 0x36047C88, 0xC2B44FC0, 0x6EDB5EF8,
		0x2AD52850, 0x86BA3968, 0x720A0A20, 0xDE651B18,
		0xD80128FA, 0x746E39C2, 0x80DE0A8A, 0x2CB11BB2,
		0x68BF6D1A, 0xC4D07C22, 0x30604F6A, 0x9C0F5E52,
		0x490A4F3F, 0xE5655E07, 0x11D56D4F, 0xBDBA7C77,
		0xF9B40ADF, 0x55DB1BE7, 0xA16B28AF, 0x0D043997,
		0xF2BFF359, 0x5ED0E261, 0xAA60D129, 0x060FC011,
		0x4201B6B9, 0xEE6EA781, 0x1ADE94C9, 0xB6B185F1,
		0x63B4949C, 0xCFDB85A4, 0x3B6BB6EC, 0x9704A7D4,
		0xD30AD17C, 0x7F65C044, 0x8BD5F30C, 0x27BAE234,
		0x21DED1D6, 0x8DB1C0EE, 0x7901F3A6, 0xD56EE29E,
		0x91609436, 0x3D0F850E, 0xC9BFB646, 0x65D0A77E,
		0xB0D5B613, 0x1CBAA72B, 0xE80A9463, 0x4465855B,
		0x006BF3F3, 0xAC04E2CB, 0x58B4D183, 0xF4DBC0BB,
		0xA50A5B42, 0x09654A7A, 0xFDD57932, 0x51BA680A,
		0x15B41EA2, 0xB9DB0F9A, 0x4D6B3CD2, 0xE1042DEA,
		0x34013C87, 0x986E2DBF, 0x6CDE1EF7, 0xC0B10FCF,
		0x84BF7967, 0x28D0685F, 0xDC605B17, 0x700F4A2F,
		0x766B79CD, 0xDA0468F5, 0x2EB45BBD, 0x82DB4A85,
		0xC6D53C2D, 0x6ABA2D15, 0x9E0A1E5D, 0x32650F65,
		0xE7601E08, 0x4B0F0F30, 0xBFBF3C78, 0x13D02D40,
		0x57DE5BE8, 0xFBB14AD0, 0x0F017998, 0xA36E68A0,
	},
	{
		0x00000000, 0x196B30EF, 0xC3A08CDB, 0xDACBBC34,
		0x7737F5B2, 0x6E5CC55D, 0xB4977969, 0xADFC4986,
		0x1F180660, 0x0673368F, 0xDCB88ABB, 0xC5D3BA54,
		0x682FF3D2, 0x7144C33D, 0xAB8F7F09, 0xB2E44FE6,
		0x3E300CC0, 0x275B3C2F, 0xFD90801B, 0xE4FBB0F4,
		0x4907F972, 0x506CC99D, 0x8AA775A9, 0x93CC4546,
		0x21280AA0, 0x38433A4F, 0xE288867B, 0xFBE3B694,
		0x561FFF12, 0x4F74CFFD, 0x95BF73C9, 0x8CD44326,
		0x8D16F485, 0x947DC46A, 0x4EB6785E, 0x57DD48B1,
		0xFA210137, 0xE34A31D8, 0x39818DEC, 0x20EABD03,
		0x920EF2E5, 0x8B65C20A, 0x51AE7E3E, 0x48C54ED1,
		0xE5390757, 0xFC5237B8, 0x26998B8C, 0x3FF2BB63,
		0xB326F845, 0xAA4DC8AA, 0x7086749E, 0x69ED4471,
		0xC4110DF7, 0xDD7A3D18, 0x07B1812C, 0x1EDAB1C3,
		0xAC3EFE25, 0xB555CECA, 0x6F9E72FE, 0x76F54211,
		0xDB090B97, 0xC2623B78, 0x18A9874C, 0x01C2B7A3,
		0xEB5B040E, 0xF23034E1, 0x28FB88D5, 0x3190B83A,
		0x9C6CF1BC, 0x8507C153, 0x5FCC7D67, 0x46A74D88,
		0xF443026E, 0xED283281, 0x37E38EB5, 0x2E88BE5A,
		0x8374F7DC, 0x9A1FC733, 0x40D47B07, 0x59BF4BE8,
		0xD56B08CE, 0xCC003821, 0x16CB8415, 0x0FA0B4FA,
		0xA25CFD7C, 0xBB37CD93, 0x61FC71A7, 0x78974148,
		0xCA730EAE, 0xD3183E41, 0x09D38275, 0x10B8B29A,
		0xBD44FB1C, 0xA42FCBF3, 0x7EE477C7, 0x678F4728,
		0x664DF08B, 0x7F26C064, 0xA5ED7C50, 0xBC864CBF,
		0x117A0539, 0x081135D6, 0xD2DA89E2, 0xCBB1B90D,
		0x7955F6EB, 0x603EC604, 0xBAF57A30, 0xA39E4ADF,
		0x0E620359, 0x170933B6, 0xCDC28F82, 0xD4A9BF6D,
		0x587DFC4B, 0x4116CCA4, 0x9BDD7090, 0x82B6407F,
		0x2F4A09F9, 0x36213916, 0xECEA8522, 0xF581B5CD,
		0x4765FA2B, 0x5E0ECAC4, 0x84C576F0, 0x9DAE461F,
		0x30520F99, 0x29393F76, 0xF3F28342, 0xEA99B3AD,
		0xD6B7081C, 0xCFDC38F3, 0x151784C7, 0x0C7CB428,
		0xA180FDAE, 0xB8EBCD41, 0x62207175, 0x7B4B419A,
		0xC9AF0E7C, 0xD0C43E93, 0x0A0F82A7, 0x1364B248,
		0xBE98FBCE, 0xA7F3CB21, 0x7D387715, 0x645347FA,
		0xE88704DC, 0xF1EC3433, 0x2B278807, 0x324CB8E8,
		0x9FB0F16E, 0x86DBC181, 0x5C107DB5, 0x457B4D5A,
		0xF79F02BC, 0xEEF43253, 0x343F8E67, 0x2D54BE88,
		0x80A8F70E, 0x99C3C7E1, 0x43087BD5, 0x5A634B3A,
		0x5BA1FC99, 0x42CACC76, 0x98017042, 0x816A40AD,
		0x2C96092B, 0x35FD39C4, 0xEF3685F0, 0xF65DB51F,
		0x44B9FAF9, 0x5DD2CA16, 0x87197622, 0x9E7246CD,
		0x338E0F4B, 0x2AE53FA4, 0xF02E8390, 0xE945B37F,
		0x6591F059, 0x7CFAC0B6, 0xA6317C82, 0xBF5A4C6D,
		0x12A605EB, 0x0BCD3504, 0xD1068930, 0xC86DB9DF,
		0x7A89F639, 0x63E2C6D6, 0xB9297AE2, 0xA0424A0D,
		0x0DBE038B, 0x14D53364, 0xCE1E8F50, 0xD775BFBF,
		0x3DEC0C12, 0x24873CFD, 0xFE4C80C9, 0xE727B026,
		0x4ADBF9A0, 0x53B0C94F, 0x897B757B, 0x90104594,
		0x22F40A72, 0x3B9F3A9D, 0xE15486A9, 0xF83FB646,
		0x55C3FFC0, 0x4CA8CF2F, 0x9663731B, 0x8F0843F4,
		0x03DC00D2, 0x1AB7303D, 0xC07C8C09, 0xD917BCE6,
		0x74EBF560, 0x6D80C58F, 0xB74B79BB, 0xAE204954,
		0x1CC406B2, 0x05AF365D, 0xDF648A69, 0xC60FBA86,
		0x6BF3F300, 0x7298C3EF, 0xA8537FDB, 0xB1384F34,
		0xB0FAF897, 0xA991C878, 0x735A744C, 0x6A3144A3,
		0xC7CD0D25, 0xDEA63DCA, 0x046D81FE, 0x1D06B111,
		0xAFE2FEF7, 0xB689CE18, 0x6C42722C, 0x752942C3,
		0xD8D50B45, 0xC1BE3BAA, 0x1B75879E, 0x021EB771,
		0x8ECAF457, 0x97A1C4B8, 0x4D6A788C, 0x54014863,
		0xF9FD01E5, 0xE096310A, 0x3A5D8D3E, 0x2336BDD1,
		0x91D2F237, 0x88B9C2D8, 0x52727EEC, 0x4B194E03,
		0xE6E50785, 0xFF8E376A, 0x25458B5E, 0x3C2EBBB1,
	},
	{
		0x00000000, 0xC82C0368, 0x905906D0, 0x587505B8,
		0xD1C5E0A5, 0x19E9E3CD, 0x419CE675, 0x89B0E51D,
		0x53FD2D4E, 0x9BD12E26, 0xC3A42B9E, 0x0B8828F6,
		0x8238CDEB, 0x4A14CE83, 0x1261CB3B, 0xDA4DC853,
		0xA6FA5B9C, 0x6ED658F4, 0x36A35D4C, 0xFE8F5E24,
		0x773FBB39, 0xBF13B851, 0xE766BDE9, 0x2F4ABE81,
		0xF50776D2, 0x3D2B75BA, 0x655E7002, 0xAD72736A,
		0x24C29677, 0xECEE951F, 0xB49B90A7, 0x7CB793CF,
		0xBD835B3D, 0x75AF5855, 0x2DDA5DED, 0xE5F65E85,
		0x6C46BB98, 0xA46AB8F0, 0xFC1FBD48, 0x3433BE20,
		0xEE7E7673, 0x2652751B, 0x7E2770A3, 0xB60B73CB,
		0x3FBB96D6, 0xF79795BE, 0xAFE29006, 0x67CE936E,
		0x1B7900A1, 0xD35503C9, 0x8B200671, 0x430C0519,
		0xCABCE004, 0x0290E36C, 0x5AE5E6D4, 0x92C9E5BC,
		0x48842DEF, 0x80A82E87, 0xD8DD2B3F, 0x10F12857,
		0x9941CD4A, 0x516DCE22, 0x0918CB9A, 0xC134C8F2,
		0x7A07B77A, 0xB22BB412, 0xEA5EB1AA, 0x2272B2C2,
		0xABC257DF, 0x63EE54B7, 0x3B9B510F, 0xF3B75267,
		0x29FA9A34, 0xE1D6995C, 0xB9A39CE4, 0x718F9F8C,
		0xF83F7A91, 0x301379F9, 0x68667C41, 0xA04A7F29,
		0xDCFDECE6, 0x14D1EF8E, 0x4CA4EA36, 0x8488E95E,
		0x0D380C43, 0xC5140F2B, 0x9D610A93, 0x554D09FB,
		0x8F00C1A8, 0x472CC2C0, 0x1F59C778, 0xD775C410,
		0x5EC5210D, 0x96E92265, 0xCE9C27DD, 0x06B024B5,
		0xC784EC47, 0x0FA8EF2F, 0x57DDEA97, 0x9FF1E9FF,
		0x16410CE2, 0xDE6D0F8A, 0x86180A32, 0x4E34095A,
		0x9479C109, 0x5C55C261, 0x0420C7D9, 0xCC0CC4B1,
		0x45BC21AC, 0x8D9022C4, 0xD5E5277C, 0x1DC92414,
		0x617EB7DB, 0xA952B4B3, 0xF127B10B, 0x390BB263,
		0xB0BB577E, 0x78975416, 0x20E251AE, 0xE8CE52C6,
		0x32839A95, 0xFAAF99FD, 0xA2DA9C45, 0x6AF69F2D,
		0xE3467A30, 0x2B6A7958, 0x731F7CE0, 0xBB337F88,
		0xF40E6EF5, 0x3C226D9D, 0x64576825, 0xAC7B6B4D,
		0x25CB8E50, 0xEDE78D38, 0xB5928880, 0x7DBE8BE8,
		0xA7F343BB, 0x6FDF40D3, 0x37AA456B, 0xFF864603,
		0x7636A31E, 0xBE1AA076, 0xE66FA5CE, 0x2E43A6A6,
		0x52F43569, 0x9AD83601, 0xC2AD33B9, 0x0A8130D1,
		0x8331D5CC, 0x4B1DD6A4, 0x1368D31C, 0xDB44D074,
		0x01091827, 0xC9251B4F, 0x91501EF7, 0x597C1D9F,
		0xD0CCF882, 0x18E0FBEA, 0x4095FE52, 0x88B9FD3A,
		0x498D35C8, 0x81A136A0, 0xD9D43318, 0x11F83070,
		0x9848D56D, 0x5064D605, 0x0811D3BD, 0xC03DD0D5,
		0x1A701886, 0xD25C1BEE, 0x8A291E56, 0x42051D3E,
		0xCBB5F823, 0x0399FB4B, 0x5BECFEF3, 0x93C0FD9B,
		0xEF776E54, 0x275B6D3C, 0x7F2E6884, 0xB7026BEC,
		0x3EB28EF1, 0xF69E8D99, 0xAEEB8821, 0x66C78B49,
		0xBC8A431A, 0x74A64072, 0x2CD345CA, 0xE4FF46A2,
		0x6D4FA3BF, 0xA563A0D7, 0xFD16A56F, 0x353AA607,
		0x8E09D98F, 0x4625DAE7, 0x1E50DF5F, 0xD67CDC37,
		0x5FCC392A, 0x97E03A42, 0xCF953FFA, 0x07B93C92,
		0xDDF4F4C1, 0x15D8F7A9, 0x4DADF211, 0x8581F179,
		0x0C311464, 0xC41D170C, 0x9C6812B4, 0x544411DC,
		0x28F38213, 0xE0DF817B, 0xB8AA84C3, 0x708687AB,
		0xF93662B6, 0x311A61DE, 0x696F6466, 0xA143670E,
		0x7B0EAF5D, 0xB322AC35, 0xEB57A98D, 0x237BAAE5,
		0xAACB4FF8, 0x62E74C90, 0x3A924928, 0xF2BE4A40,
		0x338A82B2, 0xFBA681DA, 0xA3D38462, 0x6BFF870A,
		0xE24F6217, 0x2A63617F, 0x721664C7, 0xBA3A67AF,
		0x6077AFFC, 0xA85BAC94, 0xF02EA92C, 0x3802AA44,
		0xB1B24F59, 0x799E4C31, 0x21EB4989, 0xE9C74AE1,
		0x9570D92E, 0x5D5CDA46, 0x0529DFFE, 0xCD05DC96,
		0x44B5398B, 0x8C993AE3, 0xD4EC3F5B, 0x1CC03C33,
		0xC68DF460, 0x0EA1F708, 0x56D4F2B0, 0x9EF8F1D8,
		0x174814C5, 0xDF6417AD, 0x87111215, 0x4F3D117D,
	},
	{
		0x00000000, 0x277D3C49, 0x4EFA7892, 0x698744DB,
		0x6D821D21, 0x4AFF2168, 0x237865B3, 0x040559FA,
		0xDA043B42, 0xFD79070B, 0x94FE43D0, 0xB3837F99,
		0xB7862663, 0x90FB1A2A, 0xF97C5EF1, 0xDE0162B8,
		0xB4097684, 0x93744ACD, 0xFAF30E16, 0xDD8E325F,
		0xD98B6BA5, 0xFEF657EC, 0x97711337, 0xB00C2F7E,
		0x6E0D4DC6, 0x4970718F, 0x20F73554, 0x078A091D,
		0x038F50E7, 0x24F26CAE, 0x4D752875, 0x6A08143C,
		0x9965000D, 0xBE183C44, 0xD79F789F, 0xF0E244D6,
		0xF4E71D2C, 0xD39A2165, 0xBA1D65BE, 0x9D6059F7,
		0x43613B4F, 0x641C0706, 0x0D9B43DD, 0x2AE67F94,
		0x2EE3266E, 0x099E1A27, 0x60195EFC, 0x476462B5,
		0x2D6C7689, 0x0A114AC0, 0x63960E1B, 0x44EB3252,
		0x40EE6BA8, 0x679357E1, 0x0E14133A, 0x29692F73,
		0xF7684DCB, 0xD0157182, 0xB9923559, 0x9EEF0910,
		0x9AEA50EA, 0xBD976CA3, 0xD4102878, 0xF36D1431,
		0x32CB001A, 0x15B63C53, 0x7C317888, 0x5B4C44C1,
		0x5F491D3B, 0x78342172, 0x11B365A9, 0x36CE59E0,
		0xE8CF3B58, 0xCFB20711, 0xA63543CA, 0x81487F83,
		0x854D2679, 0xA2301A30, 0xCBB75EEB, 0xECCA62A2,
		0x86C2769E, 0xA1BF4AD7, 0xC8380E0C, 0xEF453245,
		0xEB406BBF, 0xCC3D57F6, 0xA5BA132D, 0x82C72F64,
		0x5CC64DDC, 0x7BBB7195, 0x123C354E, 0x35410907,
		0x314450FD, 0x16396CB4, 0x7FBE286F, 0x58C31426,
		0xABAE0017, 0x8CD33C5E, 0xE5547885, 0xC22944CC,
		0xC62C1D36, 0xE151217F, 0x88D665A4, 0xAFAB59ED,
		0x71AA3B55, 0x56D7071C, 0x3F5043C7, 0x182D7F8E,
		0x1C282674, 0x3B551A3D, 0x52D25EE6, 0x75AF62AF,
		0x1FA77693, 0x38DA4ADA, 0x515D0E01, 0x76203248,
		0x72256BB2, 0x555857FB, 0x3CDF1320, 0x1BA22F69,
		0xC5A34DD1, 0xE2DE7198, 0x8B593543, 0xAC24090A,
		0xA82150F0, 0x8F5C6CB9, 0xE6DB2862, 0xC1A6142B,
		0x64960134, 0x43EB3D7D, 0x2A6C79A6, 0x0D1145EF,
		0x09141C15, 0x2E69205C, 0x47EE6487, 0x609358CE,
		0xBE923A76, 0x99EF063F, 0xF06842E4, 0xD7157EAD,
		0xD3102757, 0xF46D1B1E, 0x9DEA5FC5, 0xBA97638C,
		0xD09F77B0, 0xF7E24BF9, 0x9E650F22, 0xB918336B,
		0xBD1D6A91, 0x9A6056D8, 0xF3E71203, 0xD49A2E4A,
		0x0A9B4CF2, 0x2DE670BB, 0x44613460, 0x631C0829,
		0x671951D3, 0x40646D9A, 0x29E32941, 0x0E9E1508,
		0xFDF30139, 0xDA8E3D70, 0xB30979AB, 0x947445E2,
		0x90711C18, 0xB70C2051, 0xDE8B648A, 0xF9F658C3,
		0x27F73A7B, 0x008A0632, 0x690D42E9, 0x4E707EA0,
		0x4A75275A, 0x6D081B13, 0x048F5FC8, 0x23F26381,
		0x49FA77BD, 0x6E874BF4, 0x07000F2F, 0x207D3366,
		0x24786A9C, 0x030556D5, 0x6A82120E, 0x4DFF2E47,
		0x93FE4CFF, 0xB48370B6, 0xDD04346D, 0xFA790824,
		0xFE7C51DE, 0xD9016D97, 0xB086294C, 0x97FB1505,
		0x565D012E, 0x71203D67, 0x18A779BC, 0x3FDA45F5,
		0x3BDF1C0F, 0x1CA22046, 0x7525649D, 0x525858D4,
		0x8C593A6C, 0xAB240625, 0xC2A342FE, 0xE5DE7EB7,
		0xE1DB274D, 0xC6A61B04, 0xAF215FDF, 0x885C6396,
		0xE25477AA, 0xC5294BE3, 0xACAE0F38, 0x8BD33371,
		0x8FD66A8B, 0xA8AB56C2, 0xC12C1219, 0xE6512E50,
		0x38504CE8, 0x1F2D70A1, 0x76AA347A, 0x51D70833,
		0x55D251C9, 0x72AF6D80, 0x1B28295B, 0x3C551512,
		0xCF380123, 0xE8453D6A, 0x81C279B1, 0xA6BF45F8,
		0xA2BA1C02, 0x85C7204B, 0xEC406490, 0xCB3D58D9,
		0x153C3A61, 0x32410628, 0x5BC642F3, 0x7CBB7EBA,
		0x78BE2740, 0x5FC31B09, 0x36445FD2, 0x1139639B,
		0x7B3177A7, 0x5C4C4BEE, 0x35CB0F35, 0x12B6337C,
		0x16B36A86, 0x31CE56CF, 0x58491214, 0x7F342E5D,
		0xA1354CE5, 0x864870AC, 0xEFCF3477, 0xC8B2083E,
		0xCCB751C4, 0xEBCA6D8D, 0x824D2956, 0xA530151F
	}

};

// Simple CRC macro for testing
#define CRC8(x) ((pg_crc32c)(x))

pg_crc32c pg_comp_crc32c_sb8(pg_crc32c crc, const void *data, size_t len)
{
    const unsigned char *p = data;
    const uint32 *p4;

    // Handle 0-3 initial bytes one at a time
    while (len > 0 && ((uintptr_t)p & 3)) {
        crc = CRC8(*p++);
        len--;
    }

    // Process eight bytes at a time
    p4 = (const uint32 *)p;
    while (len >= 8) {
        uint32 a = *p4++ ^ crc;
        uint32 b = *p4++;  // <-- can be uninitialized if len < 8 at end

#ifdef WORDS_BIGENDIAN
        const uint8 c0 = b;
        const uint8 c1 = b >> 8;
        const uint8 c2 = b >> 16;
        const uint8 c3 = b >> 24;
        const uint8 c4 = a;
        const uint8 c5 = a >> 8;
        const uint8 c6 = a >> 16;
        const uint8 c7 = a >> 24;
#else
        const uint8 c0 = b >> 24;
        const uint8 c1 = b >> 16;
        const uint8 c2 = b >> 8;
        const uint8 c3 = b;
        const uint8 c4 = a >> 24;
        const uint8 c5 = a >> 16;
        const uint8 c6 = a >> 8;
        const uint8 c7 = a;
#endif

        crc =
            pg_crc32c_table[0][c0] ^ pg_crc32c_table[1][c1] ^
            pg_crc32c_table[2][c2] ^ pg_crc32c_table[3][c3] ^
            pg_crc32c_table[4][c4] ^ pg_crc32c_table[5][c5] ^
            pg_crc32c_table[6][c6] ^ pg_crc32c_table[7][c7];

        len -= 8;
    }

    return crc;
}

int main() {
    uint8_t buf[13];  // deliberately not multiple of 8
    for (int i = 0; i < 13; i++) buf[i] = i + 1;

    pg_crc32c crc = 0;
    crc = pg_comp_crc32c_sb8(crc, buf, 13);

    printf("CRC: %u\n", crc);
    ASSERT(897250140, crc);
    return 0;
}
