//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/cosmos/armcosmos/v3"
	"net/http"
	"net/url"
	"regexp"
)

// MongoDBResourcesServer is a fake server for instances of the armcosmos.MongoDBResourcesClient type.
type MongoDBResourcesServer struct {
	// BeginCreateUpdateMongoDBCollection is the fake for method MongoDBResourcesClient.BeginCreateUpdateMongoDBCollection
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateMongoDBCollection func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, createUpdateMongoDBCollectionParameters armcosmos.MongoDBCollectionCreateUpdateParameters, options *armcosmos.MongoDBResourcesClientBeginCreateUpdateMongoDBCollectionOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientCreateUpdateMongoDBCollectionResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateMongoDBDatabase is the fake for method MongoDBResourcesClient.BeginCreateUpdateMongoDBDatabase
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateMongoDBDatabase func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, createUpdateMongoDBDatabaseParameters armcosmos.MongoDBDatabaseCreateUpdateParameters, options *armcosmos.MongoDBResourcesClientBeginCreateUpdateMongoDBDatabaseOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientCreateUpdateMongoDBDatabaseResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateMongoRoleDefinition is the fake for method MongoDBResourcesClient.BeginCreateUpdateMongoRoleDefinition
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateMongoRoleDefinition func(ctx context.Context, mongoRoleDefinitionID string, resourceGroupName string, accountName string, createUpdateMongoRoleDefinitionParameters armcosmos.MongoRoleDefinitionCreateUpdateParameters, options *armcosmos.MongoDBResourcesClientBeginCreateUpdateMongoRoleDefinitionOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientCreateUpdateMongoRoleDefinitionResponse], errResp azfake.ErrorResponder)

	// BeginCreateUpdateMongoUserDefinition is the fake for method MongoDBResourcesClient.BeginCreateUpdateMongoUserDefinition
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreateUpdateMongoUserDefinition func(ctx context.Context, mongoUserDefinitionID string, resourceGroupName string, accountName string, createUpdateMongoUserDefinitionParameters armcosmos.MongoUserDefinitionCreateUpdateParameters, options *armcosmos.MongoDBResourcesClientBeginCreateUpdateMongoUserDefinitionOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientCreateUpdateMongoUserDefinitionResponse], errResp azfake.ErrorResponder)

	// BeginDeleteMongoDBCollection is the fake for method MongoDBResourcesClient.BeginDeleteMongoDBCollection
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteMongoDBCollection func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, options *armcosmos.MongoDBResourcesClientBeginDeleteMongoDBCollectionOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientDeleteMongoDBCollectionResponse], errResp azfake.ErrorResponder)

	// BeginDeleteMongoDBDatabase is the fake for method MongoDBResourcesClient.BeginDeleteMongoDBDatabase
	// HTTP status codes to indicate success: http.StatusAccepted, http.StatusNoContent
	BeginDeleteMongoDBDatabase func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.MongoDBResourcesClientBeginDeleteMongoDBDatabaseOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientDeleteMongoDBDatabaseResponse], errResp azfake.ErrorResponder)

	// BeginDeleteMongoRoleDefinition is the fake for method MongoDBResourcesClient.BeginDeleteMongoRoleDefinition
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteMongoRoleDefinition func(ctx context.Context, mongoRoleDefinitionID string, resourceGroupName string, accountName string, options *armcosmos.MongoDBResourcesClientBeginDeleteMongoRoleDefinitionOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientDeleteMongoRoleDefinitionResponse], errResp azfake.ErrorResponder)

	// BeginDeleteMongoUserDefinition is the fake for method MongoDBResourcesClient.BeginDeleteMongoUserDefinition
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDeleteMongoUserDefinition func(ctx context.Context, mongoUserDefinitionID string, resourceGroupName string, accountName string, options *armcosmos.MongoDBResourcesClientBeginDeleteMongoUserDefinitionOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientDeleteMongoUserDefinitionResponse], errResp azfake.ErrorResponder)

	// GetMongoDBCollection is the fake for method MongoDBResourcesClient.GetMongoDBCollection
	// HTTP status codes to indicate success: http.StatusOK
	GetMongoDBCollection func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, options *armcosmos.MongoDBResourcesClientGetMongoDBCollectionOptions) (resp azfake.Responder[armcosmos.MongoDBResourcesClientGetMongoDBCollectionResponse], errResp azfake.ErrorResponder)

	// GetMongoDBCollectionThroughput is the fake for method MongoDBResourcesClient.GetMongoDBCollectionThroughput
	// HTTP status codes to indicate success: http.StatusOK
	GetMongoDBCollectionThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, options *armcosmos.MongoDBResourcesClientGetMongoDBCollectionThroughputOptions) (resp azfake.Responder[armcosmos.MongoDBResourcesClientGetMongoDBCollectionThroughputResponse], errResp azfake.ErrorResponder)

	// GetMongoDBDatabase is the fake for method MongoDBResourcesClient.GetMongoDBDatabase
	// HTTP status codes to indicate success: http.StatusOK
	GetMongoDBDatabase func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.MongoDBResourcesClientGetMongoDBDatabaseOptions) (resp azfake.Responder[armcosmos.MongoDBResourcesClientGetMongoDBDatabaseResponse], errResp azfake.ErrorResponder)

	// GetMongoDBDatabaseThroughput is the fake for method MongoDBResourcesClient.GetMongoDBDatabaseThroughput
	// HTTP status codes to indicate success: http.StatusOK
	GetMongoDBDatabaseThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.MongoDBResourcesClientGetMongoDBDatabaseThroughputOptions) (resp azfake.Responder[armcosmos.MongoDBResourcesClientGetMongoDBDatabaseThroughputResponse], errResp azfake.ErrorResponder)

	// GetMongoRoleDefinition is the fake for method MongoDBResourcesClient.GetMongoRoleDefinition
	// HTTP status codes to indicate success: http.StatusOK
	GetMongoRoleDefinition func(ctx context.Context, mongoRoleDefinitionID string, resourceGroupName string, accountName string, options *armcosmos.MongoDBResourcesClientGetMongoRoleDefinitionOptions) (resp azfake.Responder[armcosmos.MongoDBResourcesClientGetMongoRoleDefinitionResponse], errResp azfake.ErrorResponder)

	// GetMongoUserDefinition is the fake for method MongoDBResourcesClient.GetMongoUserDefinition
	// HTTP status codes to indicate success: http.StatusOK
	GetMongoUserDefinition func(ctx context.Context, mongoUserDefinitionID string, resourceGroupName string, accountName string, options *armcosmos.MongoDBResourcesClientGetMongoUserDefinitionOptions) (resp azfake.Responder[armcosmos.MongoDBResourcesClientGetMongoUserDefinitionResponse], errResp azfake.ErrorResponder)

	// BeginListMongoDBCollectionPartitionMerge is the fake for method MongoDBResourcesClient.BeginListMongoDBCollectionPartitionMerge
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginListMongoDBCollectionPartitionMerge func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, mergeParameters armcosmos.MergeParameters, options *armcosmos.MongoDBResourcesClientBeginListMongoDBCollectionPartitionMergeOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientListMongoDBCollectionPartitionMergeResponse], errResp azfake.ErrorResponder)

	// NewListMongoDBCollectionsPager is the fake for method MongoDBResourcesClient.NewListMongoDBCollectionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMongoDBCollectionsPager func(resourceGroupName string, accountName string, databaseName string, options *armcosmos.MongoDBResourcesClientListMongoDBCollectionsOptions) (resp azfake.PagerResponder[armcosmos.MongoDBResourcesClientListMongoDBCollectionsResponse])

	// NewListMongoDBDatabasesPager is the fake for method MongoDBResourcesClient.NewListMongoDBDatabasesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMongoDBDatabasesPager func(resourceGroupName string, accountName string, options *armcosmos.MongoDBResourcesClientListMongoDBDatabasesOptions) (resp azfake.PagerResponder[armcosmos.MongoDBResourcesClientListMongoDBDatabasesResponse])

	// NewListMongoRoleDefinitionsPager is the fake for method MongoDBResourcesClient.NewListMongoRoleDefinitionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMongoRoleDefinitionsPager func(resourceGroupName string, accountName string, options *armcosmos.MongoDBResourcesClientListMongoRoleDefinitionsOptions) (resp azfake.PagerResponder[armcosmos.MongoDBResourcesClientListMongoRoleDefinitionsResponse])

	// NewListMongoUserDefinitionsPager is the fake for method MongoDBResourcesClient.NewListMongoUserDefinitionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListMongoUserDefinitionsPager func(resourceGroupName string, accountName string, options *armcosmos.MongoDBResourcesClientListMongoUserDefinitionsOptions) (resp azfake.PagerResponder[armcosmos.MongoDBResourcesClientListMongoUserDefinitionsResponse])

	// BeginMigrateMongoDBCollectionToAutoscale is the fake for method MongoDBResourcesClient.BeginMigrateMongoDBCollectionToAutoscale
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateMongoDBCollectionToAutoscale func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, options *armcosmos.MongoDBResourcesClientBeginMigrateMongoDBCollectionToAutoscaleOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientMigrateMongoDBCollectionToAutoscaleResponse], errResp azfake.ErrorResponder)

	// BeginMigrateMongoDBCollectionToManualThroughput is the fake for method MongoDBResourcesClient.BeginMigrateMongoDBCollectionToManualThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateMongoDBCollectionToManualThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, options *armcosmos.MongoDBResourcesClientBeginMigrateMongoDBCollectionToManualThroughputOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientMigrateMongoDBCollectionToManualThroughputResponse], errResp azfake.ErrorResponder)

	// BeginMigrateMongoDBDatabaseToAutoscale is the fake for method MongoDBResourcesClient.BeginMigrateMongoDBDatabaseToAutoscale
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateMongoDBDatabaseToAutoscale func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.MongoDBResourcesClientBeginMigrateMongoDBDatabaseToAutoscaleOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientMigrateMongoDBDatabaseToAutoscaleResponse], errResp azfake.ErrorResponder)

	// BeginMigrateMongoDBDatabaseToManualThroughput is the fake for method MongoDBResourcesClient.BeginMigrateMongoDBDatabaseToManualThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMigrateMongoDBDatabaseToManualThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, options *armcosmos.MongoDBResourcesClientBeginMigrateMongoDBDatabaseToManualThroughputOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientMigrateMongoDBDatabaseToManualThroughputResponse], errResp azfake.ErrorResponder)

	// BeginMongoDBContainerRedistributeThroughput is the fake for method MongoDBResourcesClient.BeginMongoDBContainerRedistributeThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMongoDBContainerRedistributeThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, redistributeThroughputParameters armcosmos.RedistributeThroughputParameters, options *armcosmos.MongoDBResourcesClientBeginMongoDBContainerRedistributeThroughputOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBContainerRedistributeThroughputResponse], errResp azfake.ErrorResponder)

	// BeginMongoDBContainerRetrieveThroughputDistribution is the fake for method MongoDBResourcesClient.BeginMongoDBContainerRetrieveThroughputDistribution
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMongoDBContainerRetrieveThroughputDistribution func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, retrieveThroughputParameters armcosmos.RetrieveThroughputParameters, options *armcosmos.MongoDBResourcesClientBeginMongoDBContainerRetrieveThroughputDistributionOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBContainerRetrieveThroughputDistributionResponse], errResp azfake.ErrorResponder)

	// BeginMongoDBDatabasePartitionMerge is the fake for method MongoDBResourcesClient.BeginMongoDBDatabasePartitionMerge
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMongoDBDatabasePartitionMerge func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, mergeParameters armcosmos.MergeParameters, options *armcosmos.MongoDBResourcesClientBeginMongoDBDatabasePartitionMergeOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBDatabasePartitionMergeResponse], errResp azfake.ErrorResponder)

	// BeginMongoDBDatabaseRedistributeThroughput is the fake for method MongoDBResourcesClient.BeginMongoDBDatabaseRedistributeThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMongoDBDatabaseRedistributeThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, redistributeThroughputParameters armcosmos.RedistributeThroughputParameters, options *armcosmos.MongoDBResourcesClientBeginMongoDBDatabaseRedistributeThroughputOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBDatabaseRedistributeThroughputResponse], errResp azfake.ErrorResponder)

	// BeginMongoDBDatabaseRetrieveThroughputDistribution is the fake for method MongoDBResourcesClient.BeginMongoDBDatabaseRetrieveThroughputDistribution
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginMongoDBDatabaseRetrieveThroughputDistribution func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, retrieveThroughputParameters armcosmos.RetrieveThroughputParameters, options *armcosmos.MongoDBResourcesClientBeginMongoDBDatabaseRetrieveThroughputDistributionOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBDatabaseRetrieveThroughputDistributionResponse], errResp azfake.ErrorResponder)

	// BeginRetrieveContinuousBackupInformation is the fake for method MongoDBResourcesClient.BeginRetrieveContinuousBackupInformation
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRetrieveContinuousBackupInformation func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, location armcosmos.ContinuousBackupRestoreLocation, options *armcosmos.MongoDBResourcesClientBeginRetrieveContinuousBackupInformationOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientRetrieveContinuousBackupInformationResponse], errResp azfake.ErrorResponder)

	// BeginUpdateMongoDBCollectionThroughput is the fake for method MongoDBResourcesClient.BeginUpdateMongoDBCollectionThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateMongoDBCollectionThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, collectionName string, updateThroughputParameters armcosmos.ThroughputSettingsUpdateParameters, options *armcosmos.MongoDBResourcesClientBeginUpdateMongoDBCollectionThroughputOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientUpdateMongoDBCollectionThroughputResponse], errResp azfake.ErrorResponder)

	// BeginUpdateMongoDBDatabaseThroughput is the fake for method MongoDBResourcesClient.BeginUpdateMongoDBDatabaseThroughput
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdateMongoDBDatabaseThroughput func(ctx context.Context, resourceGroupName string, accountName string, databaseName string, updateThroughputParameters armcosmos.ThroughputSettingsUpdateParameters, options *armcosmos.MongoDBResourcesClientBeginUpdateMongoDBDatabaseThroughputOptions) (resp azfake.PollerResponder[armcosmos.MongoDBResourcesClientUpdateMongoDBDatabaseThroughputResponse], errResp azfake.ErrorResponder)
}

// NewMongoDBResourcesServerTransport creates a new instance of MongoDBResourcesServerTransport with the provided implementation.
// The returned MongoDBResourcesServerTransport instance is connected to an instance of armcosmos.MongoDBResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewMongoDBResourcesServerTransport(srv *MongoDBResourcesServer) *MongoDBResourcesServerTransport {
	return &MongoDBResourcesServerTransport{
		srv:                                                 srv,
		beginCreateUpdateMongoDBCollection:                  newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientCreateUpdateMongoDBCollectionResponse]](),
		beginCreateUpdateMongoDBDatabase:                    newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientCreateUpdateMongoDBDatabaseResponse]](),
		beginCreateUpdateMongoRoleDefinition:                newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientCreateUpdateMongoRoleDefinitionResponse]](),
		beginCreateUpdateMongoUserDefinition:                newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientCreateUpdateMongoUserDefinitionResponse]](),
		beginDeleteMongoDBCollection:                        newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientDeleteMongoDBCollectionResponse]](),
		beginDeleteMongoDBDatabase:                          newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientDeleteMongoDBDatabaseResponse]](),
		beginDeleteMongoRoleDefinition:                      newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientDeleteMongoRoleDefinitionResponse]](),
		beginDeleteMongoUserDefinition:                      newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientDeleteMongoUserDefinitionResponse]](),
		beginListMongoDBCollectionPartitionMerge:            newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientListMongoDBCollectionPartitionMergeResponse]](),
		newListMongoDBCollectionsPager:                      newTracker[azfake.PagerResponder[armcosmos.MongoDBResourcesClientListMongoDBCollectionsResponse]](),
		newListMongoDBDatabasesPager:                        newTracker[azfake.PagerResponder[armcosmos.MongoDBResourcesClientListMongoDBDatabasesResponse]](),
		newListMongoRoleDefinitionsPager:                    newTracker[azfake.PagerResponder[armcosmos.MongoDBResourcesClientListMongoRoleDefinitionsResponse]](),
		newListMongoUserDefinitionsPager:                    newTracker[azfake.PagerResponder[armcosmos.MongoDBResourcesClientListMongoUserDefinitionsResponse]](),
		beginMigrateMongoDBCollectionToAutoscale:            newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMigrateMongoDBCollectionToAutoscaleResponse]](),
		beginMigrateMongoDBCollectionToManualThroughput:     newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMigrateMongoDBCollectionToManualThroughputResponse]](),
		beginMigrateMongoDBDatabaseToAutoscale:              newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMigrateMongoDBDatabaseToAutoscaleResponse]](),
		beginMigrateMongoDBDatabaseToManualThroughput:       newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMigrateMongoDBDatabaseToManualThroughputResponse]](),
		beginMongoDBContainerRedistributeThroughput:         newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBContainerRedistributeThroughputResponse]](),
		beginMongoDBContainerRetrieveThroughputDistribution: newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBContainerRetrieveThroughputDistributionResponse]](),
		beginMongoDBDatabasePartitionMerge:                  newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBDatabasePartitionMergeResponse]](),
		beginMongoDBDatabaseRedistributeThroughput:          newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBDatabaseRedistributeThroughputResponse]](),
		beginMongoDBDatabaseRetrieveThroughputDistribution:  newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBDatabaseRetrieveThroughputDistributionResponse]](),
		beginRetrieveContinuousBackupInformation:            newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientRetrieveContinuousBackupInformationResponse]](),
		beginUpdateMongoDBCollectionThroughput:              newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientUpdateMongoDBCollectionThroughputResponse]](),
		beginUpdateMongoDBDatabaseThroughput:                newTracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientUpdateMongoDBDatabaseThroughputResponse]](),
	}
}

// MongoDBResourcesServerTransport connects instances of armcosmos.MongoDBResourcesClient to instances of MongoDBResourcesServer.
// Don't use this type directly, use NewMongoDBResourcesServerTransport instead.
type MongoDBResourcesServerTransport struct {
	srv                                                 *MongoDBResourcesServer
	beginCreateUpdateMongoDBCollection                  *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientCreateUpdateMongoDBCollectionResponse]]
	beginCreateUpdateMongoDBDatabase                    *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientCreateUpdateMongoDBDatabaseResponse]]
	beginCreateUpdateMongoRoleDefinition                *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientCreateUpdateMongoRoleDefinitionResponse]]
	beginCreateUpdateMongoUserDefinition                *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientCreateUpdateMongoUserDefinitionResponse]]
	beginDeleteMongoDBCollection                        *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientDeleteMongoDBCollectionResponse]]
	beginDeleteMongoDBDatabase                          *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientDeleteMongoDBDatabaseResponse]]
	beginDeleteMongoRoleDefinition                      *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientDeleteMongoRoleDefinitionResponse]]
	beginDeleteMongoUserDefinition                      *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientDeleteMongoUserDefinitionResponse]]
	beginListMongoDBCollectionPartitionMerge            *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientListMongoDBCollectionPartitionMergeResponse]]
	newListMongoDBCollectionsPager                      *tracker[azfake.PagerResponder[armcosmos.MongoDBResourcesClientListMongoDBCollectionsResponse]]
	newListMongoDBDatabasesPager                        *tracker[azfake.PagerResponder[armcosmos.MongoDBResourcesClientListMongoDBDatabasesResponse]]
	newListMongoRoleDefinitionsPager                    *tracker[azfake.PagerResponder[armcosmos.MongoDBResourcesClientListMongoRoleDefinitionsResponse]]
	newListMongoUserDefinitionsPager                    *tracker[azfake.PagerResponder[armcosmos.MongoDBResourcesClientListMongoUserDefinitionsResponse]]
	beginMigrateMongoDBCollectionToAutoscale            *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMigrateMongoDBCollectionToAutoscaleResponse]]
	beginMigrateMongoDBCollectionToManualThroughput     *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMigrateMongoDBCollectionToManualThroughputResponse]]
	beginMigrateMongoDBDatabaseToAutoscale              *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMigrateMongoDBDatabaseToAutoscaleResponse]]
	beginMigrateMongoDBDatabaseToManualThroughput       *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMigrateMongoDBDatabaseToManualThroughputResponse]]
	beginMongoDBContainerRedistributeThroughput         *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBContainerRedistributeThroughputResponse]]
	beginMongoDBContainerRetrieveThroughputDistribution *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBContainerRetrieveThroughputDistributionResponse]]
	beginMongoDBDatabasePartitionMerge                  *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBDatabasePartitionMergeResponse]]
	beginMongoDBDatabaseRedistributeThroughput          *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBDatabaseRedistributeThroughputResponse]]
	beginMongoDBDatabaseRetrieveThroughputDistribution  *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientMongoDBDatabaseRetrieveThroughputDistributionResponse]]
	beginRetrieveContinuousBackupInformation            *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientRetrieveContinuousBackupInformationResponse]]
	beginUpdateMongoDBCollectionThroughput              *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientUpdateMongoDBCollectionThroughputResponse]]
	beginUpdateMongoDBDatabaseThroughput                *tracker[azfake.PollerResponder[armcosmos.MongoDBResourcesClientUpdateMongoDBDatabaseThroughputResponse]]
}

// Do implements the policy.Transporter interface for MongoDBResourcesServerTransport.
func (m *MongoDBResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "MongoDBResourcesClient.BeginCreateUpdateMongoDBCollection":
		resp, err = m.dispatchBeginCreateUpdateMongoDBCollection(req)
	case "MongoDBResourcesClient.BeginCreateUpdateMongoDBDatabase":
		resp, err = m.dispatchBeginCreateUpdateMongoDBDatabase(req)
	case "MongoDBResourcesClient.BeginCreateUpdateMongoRoleDefinition":
		resp, err = m.dispatchBeginCreateUpdateMongoRoleDefinition(req)
	case "MongoDBResourcesClient.BeginCreateUpdateMongoUserDefinition":
		resp, err = m.dispatchBeginCreateUpdateMongoUserDefinition(req)
	case "MongoDBResourcesClient.BeginDeleteMongoDBCollection":
		resp, err = m.dispatchBeginDeleteMongoDBCollection(req)
	case "MongoDBResourcesClient.BeginDeleteMongoDBDatabase":
		resp, err = m.dispatchBeginDeleteMongoDBDatabase(req)
	case "MongoDBResourcesClient.BeginDeleteMongoRoleDefinition":
		resp, err = m.dispatchBeginDeleteMongoRoleDefinition(req)
	case "MongoDBResourcesClient.BeginDeleteMongoUserDefinition":
		resp, err = m.dispatchBeginDeleteMongoUserDefinition(req)
	case "MongoDBResourcesClient.GetMongoDBCollection":
		resp, err = m.dispatchGetMongoDBCollection(req)
	case "MongoDBResourcesClient.GetMongoDBCollectionThroughput":
		resp, err = m.dispatchGetMongoDBCollectionThroughput(req)
	case "MongoDBResourcesClient.GetMongoDBDatabase":
		resp, err = m.dispatchGetMongoDBDatabase(req)
	case "MongoDBResourcesClient.GetMongoDBDatabaseThroughput":
		resp, err = m.dispatchGetMongoDBDatabaseThroughput(req)
	case "MongoDBResourcesClient.GetMongoRoleDefinition":
		resp, err = m.dispatchGetMongoRoleDefinition(req)
	case "MongoDBResourcesClient.GetMongoUserDefinition":
		resp, err = m.dispatchGetMongoUserDefinition(req)
	case "MongoDBResourcesClient.BeginListMongoDBCollectionPartitionMerge":
		resp, err = m.dispatchBeginListMongoDBCollectionPartitionMerge(req)
	case "MongoDBResourcesClient.NewListMongoDBCollectionsPager":
		resp, err = m.dispatchNewListMongoDBCollectionsPager(req)
	case "MongoDBResourcesClient.NewListMongoDBDatabasesPager":
		resp, err = m.dispatchNewListMongoDBDatabasesPager(req)
	case "MongoDBResourcesClient.NewListMongoRoleDefinitionsPager":
		resp, err = m.dispatchNewListMongoRoleDefinitionsPager(req)
	case "MongoDBResourcesClient.NewListMongoUserDefinitionsPager":
		resp, err = m.dispatchNewListMongoUserDefinitionsPager(req)
	case "MongoDBResourcesClient.BeginMigrateMongoDBCollectionToAutoscale":
		resp, err = m.dispatchBeginMigrateMongoDBCollectionToAutoscale(req)
	case "MongoDBResourcesClient.BeginMigrateMongoDBCollectionToManualThroughput":
		resp, err = m.dispatchBeginMigrateMongoDBCollectionToManualThroughput(req)
	case "MongoDBResourcesClient.BeginMigrateMongoDBDatabaseToAutoscale":
		resp, err = m.dispatchBeginMigrateMongoDBDatabaseToAutoscale(req)
	case "MongoDBResourcesClient.BeginMigrateMongoDBDatabaseToManualThroughput":
		resp, err = m.dispatchBeginMigrateMongoDBDatabaseToManualThroughput(req)
	case "MongoDBResourcesClient.BeginMongoDBContainerRedistributeThroughput":
		resp, err = m.dispatchBeginMongoDBContainerRedistributeThroughput(req)
	case "MongoDBResourcesClient.BeginMongoDBContainerRetrieveThroughputDistribution":
		resp, err = m.dispatchBeginMongoDBContainerRetrieveThroughputDistribution(req)
	case "MongoDBResourcesClient.BeginMongoDBDatabasePartitionMerge":
		resp, err = m.dispatchBeginMongoDBDatabasePartitionMerge(req)
	case "MongoDBResourcesClient.BeginMongoDBDatabaseRedistributeThroughput":
		resp, err = m.dispatchBeginMongoDBDatabaseRedistributeThroughput(req)
	case "MongoDBResourcesClient.BeginMongoDBDatabaseRetrieveThroughputDistribution":
		resp, err = m.dispatchBeginMongoDBDatabaseRetrieveThroughputDistribution(req)
	case "MongoDBResourcesClient.BeginRetrieveContinuousBackupInformation":
		resp, err = m.dispatchBeginRetrieveContinuousBackupInformation(req)
	case "MongoDBResourcesClient.BeginUpdateMongoDBCollectionThroughput":
		resp, err = m.dispatchBeginUpdateMongoDBCollectionThroughput(req)
	case "MongoDBResourcesClient.BeginUpdateMongoDBDatabaseThroughput":
		resp, err = m.dispatchBeginUpdateMongoDBDatabaseThroughput(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginCreateUpdateMongoDBCollection(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateUpdateMongoDBCollection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateMongoDBCollection not implemented")}
	}
	beginCreateUpdateMongoDBCollection := m.beginCreateUpdateMongoDBCollection.get(req)
	if beginCreateUpdateMongoDBCollection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.MongoDBCollectionCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		collectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateUpdateMongoDBCollection(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, collectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateMongoDBCollection = &respr
		m.beginCreateUpdateMongoDBCollection.add(req, beginCreateUpdateMongoDBCollection)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateMongoDBCollection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCreateUpdateMongoDBCollection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateMongoDBCollection) {
		m.beginCreateUpdateMongoDBCollection.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginCreateUpdateMongoDBDatabase(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateUpdateMongoDBDatabase == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateMongoDBDatabase not implemented")}
	}
	beginCreateUpdateMongoDBDatabase := m.beginCreateUpdateMongoDBDatabase.get(req)
	if beginCreateUpdateMongoDBDatabase == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.MongoDBDatabaseCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateUpdateMongoDBDatabase(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateMongoDBDatabase = &respr
		m.beginCreateUpdateMongoDBDatabase.add(req, beginCreateUpdateMongoDBDatabase)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateMongoDBDatabase, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCreateUpdateMongoDBDatabase.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateMongoDBDatabase) {
		m.beginCreateUpdateMongoDBDatabase.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginCreateUpdateMongoRoleDefinition(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateUpdateMongoRoleDefinition == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateMongoRoleDefinition not implemented")}
	}
	beginCreateUpdateMongoRoleDefinition := m.beginCreateUpdateMongoRoleDefinition.get(req)
	if beginCreateUpdateMongoRoleDefinition == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbRoleDefinitions/(?P<mongoRoleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.MongoRoleDefinitionCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		mongoRoleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoRoleDefinitionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateUpdateMongoRoleDefinition(req.Context(), mongoRoleDefinitionIDParam, resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateMongoRoleDefinition = &respr
		m.beginCreateUpdateMongoRoleDefinition.add(req, beginCreateUpdateMongoRoleDefinition)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateMongoRoleDefinition, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCreateUpdateMongoRoleDefinition.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateMongoRoleDefinition) {
		m.beginCreateUpdateMongoRoleDefinition.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginCreateUpdateMongoUserDefinition(req *http.Request) (*http.Response, error) {
	if m.srv.BeginCreateUpdateMongoUserDefinition == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateUpdateMongoUserDefinition not implemented")}
	}
	beginCreateUpdateMongoUserDefinition := m.beginCreateUpdateMongoUserDefinition.get(req)
	if beginCreateUpdateMongoUserDefinition == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbUserDefinitions/(?P<mongoUserDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.MongoUserDefinitionCreateUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		mongoUserDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoUserDefinitionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginCreateUpdateMongoUserDefinition(req.Context(), mongoUserDefinitionIDParam, resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateUpdateMongoUserDefinition = &respr
		m.beginCreateUpdateMongoUserDefinition.add(req, beginCreateUpdateMongoUserDefinition)
	}

	resp, err := server.PollerResponderNext(beginCreateUpdateMongoUserDefinition, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginCreateUpdateMongoUserDefinition.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateUpdateMongoUserDefinition) {
		m.beginCreateUpdateMongoUserDefinition.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginDeleteMongoDBCollection(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDeleteMongoDBCollection == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteMongoDBCollection not implemented")}
	}
	beginDeleteMongoDBCollection := m.beginDeleteMongoDBCollection.get(req)
	if beginDeleteMongoDBCollection == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		collectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDeleteMongoDBCollection(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, collectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteMongoDBCollection = &respr
		m.beginDeleteMongoDBCollection.add(req, beginDeleteMongoDBCollection)
	}

	resp, err := server.PollerResponderNext(beginDeleteMongoDBCollection, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDeleteMongoDBCollection.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteMongoDBCollection) {
		m.beginDeleteMongoDBCollection.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginDeleteMongoDBDatabase(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDeleteMongoDBDatabase == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteMongoDBDatabase not implemented")}
	}
	beginDeleteMongoDBDatabase := m.beginDeleteMongoDBDatabase.get(req)
	if beginDeleteMongoDBDatabase == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDeleteMongoDBDatabase(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteMongoDBDatabase = &respr
		m.beginDeleteMongoDBDatabase.add(req, beginDeleteMongoDBDatabase)
	}

	resp, err := server.PollerResponderNext(beginDeleteMongoDBDatabase, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDeleteMongoDBDatabase.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteMongoDBDatabase) {
		m.beginDeleteMongoDBDatabase.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginDeleteMongoRoleDefinition(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDeleteMongoRoleDefinition == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteMongoRoleDefinition not implemented")}
	}
	beginDeleteMongoRoleDefinition := m.beginDeleteMongoRoleDefinition.get(req)
	if beginDeleteMongoRoleDefinition == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbRoleDefinitions/(?P<mongoRoleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		mongoRoleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoRoleDefinitionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDeleteMongoRoleDefinition(req.Context(), mongoRoleDefinitionIDParam, resourceGroupNameParam, accountNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteMongoRoleDefinition = &respr
		m.beginDeleteMongoRoleDefinition.add(req, beginDeleteMongoRoleDefinition)
	}

	resp, err := server.PollerResponderNext(beginDeleteMongoRoleDefinition, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDeleteMongoRoleDefinition.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteMongoRoleDefinition) {
		m.beginDeleteMongoRoleDefinition.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginDeleteMongoUserDefinition(req *http.Request) (*http.Response, error) {
	if m.srv.BeginDeleteMongoUserDefinition == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDeleteMongoUserDefinition not implemented")}
	}
	beginDeleteMongoUserDefinition := m.beginDeleteMongoUserDefinition.get(req)
	if beginDeleteMongoUserDefinition == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbUserDefinitions/(?P<mongoUserDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		mongoUserDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoUserDefinitionId")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginDeleteMongoUserDefinition(req.Context(), mongoUserDefinitionIDParam, resourceGroupNameParam, accountNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDeleteMongoUserDefinition = &respr
		m.beginDeleteMongoUserDefinition.add(req, beginDeleteMongoUserDefinition)
	}

	resp, err := server.PollerResponderNext(beginDeleteMongoUserDefinition, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		m.beginDeleteMongoUserDefinition.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDeleteMongoUserDefinition) {
		m.beginDeleteMongoUserDefinition.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchGetMongoDBCollection(req *http.Request) (*http.Response, error) {
	if m.srv.GetMongoDBCollection == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMongoDBCollection not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	collectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetMongoDBCollection(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, collectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MongoDBCollectionGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchGetMongoDBCollectionThroughput(req *http.Request) (*http.Response, error) {
	if m.srv.GetMongoDBCollectionThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMongoDBCollectionThroughput not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	collectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetMongoDBCollectionThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, collectionNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ThroughputSettingsGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchGetMongoDBDatabase(req *http.Request) (*http.Response, error) {
	if m.srv.GetMongoDBDatabase == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMongoDBDatabase not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetMongoDBDatabase(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MongoDBDatabaseGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchGetMongoDBDatabaseThroughput(req *http.Request) (*http.Response, error) {
	if m.srv.GetMongoDBDatabaseThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMongoDBDatabaseThroughput not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetMongoDBDatabaseThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ThroughputSettingsGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchGetMongoRoleDefinition(req *http.Request) (*http.Response, error) {
	if m.srv.GetMongoRoleDefinition == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMongoRoleDefinition not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbRoleDefinitions/(?P<mongoRoleDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	mongoRoleDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoRoleDefinitionId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetMongoRoleDefinition(req.Context(), mongoRoleDefinitionIDParam, resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MongoRoleDefinitionGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchGetMongoUserDefinition(req *http.Request) (*http.Response, error) {
	if m.srv.GetMongoUserDefinition == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetMongoUserDefinition not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbUserDefinitions/(?P<mongoUserDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	mongoUserDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("mongoUserDefinitionId")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.GetMongoUserDefinition(req.Context(), mongoUserDefinitionIDParam, resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).MongoUserDefinitionGetResults, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginListMongoDBCollectionPartitionMerge(req *http.Request) (*http.Response, error) {
	if m.srv.BeginListMongoDBCollectionPartitionMerge == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginListMongoDBCollectionPartitionMerge not implemented")}
	}
	beginListMongoDBCollectionPartitionMerge := m.beginListMongoDBCollectionPartitionMerge.get(req)
	if beginListMongoDBCollectionPartitionMerge == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/partitionMerge`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.MergeParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		collectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginListMongoDBCollectionPartitionMerge(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, collectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginListMongoDBCollectionPartitionMerge = &respr
		m.beginListMongoDBCollectionPartitionMerge.add(req, beginListMongoDBCollectionPartitionMerge)
	}

	resp, err := server.PollerResponderNext(beginListMongoDBCollectionPartitionMerge, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginListMongoDBCollectionPartitionMerge.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginListMongoDBCollectionPartitionMerge) {
		m.beginListMongoDBCollectionPartitionMerge.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchNewListMongoDBCollectionsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListMongoDBCollectionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMongoDBCollectionsPager not implemented")}
	}
	newListMongoDBCollectionsPager := m.newListMongoDBCollectionsPager.get(req)
	if newListMongoDBCollectionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListMongoDBCollectionsPager(resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		newListMongoDBCollectionsPager = &resp
		m.newListMongoDBCollectionsPager.add(req, newListMongoDBCollectionsPager)
	}
	resp, err := server.PagerResponderNext(newListMongoDBCollectionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListMongoDBCollectionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMongoDBCollectionsPager) {
		m.newListMongoDBCollectionsPager.remove(req)
	}
	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchNewListMongoDBDatabasesPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListMongoDBDatabasesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMongoDBDatabasesPager not implemented")}
	}
	newListMongoDBDatabasesPager := m.newListMongoDBDatabasesPager.get(req)
	if newListMongoDBDatabasesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListMongoDBDatabasesPager(resourceGroupNameParam, accountNameParam, nil)
		newListMongoDBDatabasesPager = &resp
		m.newListMongoDBDatabasesPager.add(req, newListMongoDBDatabasesPager)
	}
	resp, err := server.PagerResponderNext(newListMongoDBDatabasesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListMongoDBDatabasesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMongoDBDatabasesPager) {
		m.newListMongoDBDatabasesPager.remove(req)
	}
	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchNewListMongoRoleDefinitionsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListMongoRoleDefinitionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMongoRoleDefinitionsPager not implemented")}
	}
	newListMongoRoleDefinitionsPager := m.newListMongoRoleDefinitionsPager.get(req)
	if newListMongoRoleDefinitionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbRoleDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListMongoRoleDefinitionsPager(resourceGroupNameParam, accountNameParam, nil)
		newListMongoRoleDefinitionsPager = &resp
		m.newListMongoRoleDefinitionsPager.add(req, newListMongoRoleDefinitionsPager)
	}
	resp, err := server.PagerResponderNext(newListMongoRoleDefinitionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListMongoRoleDefinitionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMongoRoleDefinitionsPager) {
		m.newListMongoRoleDefinitionsPager.remove(req)
	}
	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchNewListMongoUserDefinitionsPager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListMongoUserDefinitionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListMongoUserDefinitionsPager not implemented")}
	}
	newListMongoUserDefinitionsPager := m.newListMongoUserDefinitionsPager.get(req)
	if newListMongoUserDefinitionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbUserDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListMongoUserDefinitionsPager(resourceGroupNameParam, accountNameParam, nil)
		newListMongoUserDefinitionsPager = &resp
		m.newListMongoUserDefinitionsPager.add(req, newListMongoUserDefinitionsPager)
	}
	resp, err := server.PagerResponderNext(newListMongoUserDefinitionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListMongoUserDefinitionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListMongoUserDefinitionsPager) {
		m.newListMongoUserDefinitionsPager.remove(req)
	}
	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginMigrateMongoDBCollectionToAutoscale(req *http.Request) (*http.Response, error) {
	if m.srv.BeginMigrateMongoDBCollectionToAutoscale == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateMongoDBCollectionToAutoscale not implemented")}
	}
	beginMigrateMongoDBCollectionToAutoscale := m.beginMigrateMongoDBCollectionToAutoscale.get(req)
	if beginMigrateMongoDBCollectionToAutoscale == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToAutoscale`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		collectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginMigrateMongoDBCollectionToAutoscale(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, collectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateMongoDBCollectionToAutoscale = &respr
		m.beginMigrateMongoDBCollectionToAutoscale.add(req, beginMigrateMongoDBCollectionToAutoscale)
	}

	resp, err := server.PollerResponderNext(beginMigrateMongoDBCollectionToAutoscale, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginMigrateMongoDBCollectionToAutoscale.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateMongoDBCollectionToAutoscale) {
		m.beginMigrateMongoDBCollectionToAutoscale.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginMigrateMongoDBCollectionToManualThroughput(req *http.Request) (*http.Response, error) {
	if m.srv.BeginMigrateMongoDBCollectionToManualThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateMongoDBCollectionToManualThroughput not implemented")}
	}
	beginMigrateMongoDBCollectionToManualThroughput := m.beginMigrateMongoDBCollectionToManualThroughput.get(req)
	if beginMigrateMongoDBCollectionToManualThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToManualThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		collectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginMigrateMongoDBCollectionToManualThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, collectionNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateMongoDBCollectionToManualThroughput = &respr
		m.beginMigrateMongoDBCollectionToManualThroughput.add(req, beginMigrateMongoDBCollectionToManualThroughput)
	}

	resp, err := server.PollerResponderNext(beginMigrateMongoDBCollectionToManualThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginMigrateMongoDBCollectionToManualThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateMongoDBCollectionToManualThroughput) {
		m.beginMigrateMongoDBCollectionToManualThroughput.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginMigrateMongoDBDatabaseToAutoscale(req *http.Request) (*http.Response, error) {
	if m.srv.BeginMigrateMongoDBDatabaseToAutoscale == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateMongoDBDatabaseToAutoscale not implemented")}
	}
	beginMigrateMongoDBDatabaseToAutoscale := m.beginMigrateMongoDBDatabaseToAutoscale.get(req)
	if beginMigrateMongoDBDatabaseToAutoscale == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToAutoscale`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginMigrateMongoDBDatabaseToAutoscale(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateMongoDBDatabaseToAutoscale = &respr
		m.beginMigrateMongoDBDatabaseToAutoscale.add(req, beginMigrateMongoDBDatabaseToAutoscale)
	}

	resp, err := server.PollerResponderNext(beginMigrateMongoDBDatabaseToAutoscale, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginMigrateMongoDBDatabaseToAutoscale.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateMongoDBDatabaseToAutoscale) {
		m.beginMigrateMongoDBDatabaseToAutoscale.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginMigrateMongoDBDatabaseToManualThroughput(req *http.Request) (*http.Response, error) {
	if m.srv.BeginMigrateMongoDBDatabaseToManualThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMigrateMongoDBDatabaseToManualThroughput not implemented")}
	}
	beginMigrateMongoDBDatabaseToManualThroughput := m.beginMigrateMongoDBDatabaseToManualThroughput.get(req)
	if beginMigrateMongoDBDatabaseToManualThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/migrateToManualThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginMigrateMongoDBDatabaseToManualThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMigrateMongoDBDatabaseToManualThroughput = &respr
		m.beginMigrateMongoDBDatabaseToManualThroughput.add(req, beginMigrateMongoDBDatabaseToManualThroughput)
	}

	resp, err := server.PollerResponderNext(beginMigrateMongoDBDatabaseToManualThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginMigrateMongoDBDatabaseToManualThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMigrateMongoDBDatabaseToManualThroughput) {
		m.beginMigrateMongoDBDatabaseToManualThroughput.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginMongoDBContainerRedistributeThroughput(req *http.Request) (*http.Response, error) {
	if m.srv.BeginMongoDBContainerRedistributeThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMongoDBContainerRedistributeThroughput not implemented")}
	}
	beginMongoDBContainerRedistributeThroughput := m.beginMongoDBContainerRedistributeThroughput.get(req)
	if beginMongoDBContainerRedistributeThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/redistributeThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.RedistributeThroughputParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		collectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginMongoDBContainerRedistributeThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, collectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMongoDBContainerRedistributeThroughput = &respr
		m.beginMongoDBContainerRedistributeThroughput.add(req, beginMongoDBContainerRedistributeThroughput)
	}

	resp, err := server.PollerResponderNext(beginMongoDBContainerRedistributeThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginMongoDBContainerRedistributeThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMongoDBContainerRedistributeThroughput) {
		m.beginMongoDBContainerRedistributeThroughput.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginMongoDBContainerRetrieveThroughputDistribution(req *http.Request) (*http.Response, error) {
	if m.srv.BeginMongoDBContainerRetrieveThroughputDistribution == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMongoDBContainerRetrieveThroughputDistribution not implemented")}
	}
	beginMongoDBContainerRetrieveThroughputDistribution := m.beginMongoDBContainerRetrieveThroughputDistribution.get(req)
	if beginMongoDBContainerRetrieveThroughputDistribution == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/retrieveThroughputDistribution`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.RetrieveThroughputParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		collectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginMongoDBContainerRetrieveThroughputDistribution(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, collectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMongoDBContainerRetrieveThroughputDistribution = &respr
		m.beginMongoDBContainerRetrieveThroughputDistribution.add(req, beginMongoDBContainerRetrieveThroughputDistribution)
	}

	resp, err := server.PollerResponderNext(beginMongoDBContainerRetrieveThroughputDistribution, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginMongoDBContainerRetrieveThroughputDistribution.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMongoDBContainerRetrieveThroughputDistribution) {
		m.beginMongoDBContainerRetrieveThroughputDistribution.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginMongoDBDatabasePartitionMerge(req *http.Request) (*http.Response, error) {
	if m.srv.BeginMongoDBDatabasePartitionMerge == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMongoDBDatabasePartitionMerge not implemented")}
	}
	beginMongoDBDatabasePartitionMerge := m.beginMongoDBDatabasePartitionMerge.get(req)
	if beginMongoDBDatabasePartitionMerge == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/partitionMerge`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.MergeParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginMongoDBDatabasePartitionMerge(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMongoDBDatabasePartitionMerge = &respr
		m.beginMongoDBDatabasePartitionMerge.add(req, beginMongoDBDatabasePartitionMerge)
	}

	resp, err := server.PollerResponderNext(beginMongoDBDatabasePartitionMerge, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginMongoDBDatabasePartitionMerge.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMongoDBDatabasePartitionMerge) {
		m.beginMongoDBDatabasePartitionMerge.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginMongoDBDatabaseRedistributeThroughput(req *http.Request) (*http.Response, error) {
	if m.srv.BeginMongoDBDatabaseRedistributeThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMongoDBDatabaseRedistributeThroughput not implemented")}
	}
	beginMongoDBDatabaseRedistributeThroughput := m.beginMongoDBDatabaseRedistributeThroughput.get(req)
	if beginMongoDBDatabaseRedistributeThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/redistributeThroughput`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.RedistributeThroughputParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginMongoDBDatabaseRedistributeThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMongoDBDatabaseRedistributeThroughput = &respr
		m.beginMongoDBDatabaseRedistributeThroughput.add(req, beginMongoDBDatabaseRedistributeThroughput)
	}

	resp, err := server.PollerResponderNext(beginMongoDBDatabaseRedistributeThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginMongoDBDatabaseRedistributeThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMongoDBDatabaseRedistributeThroughput) {
		m.beginMongoDBDatabaseRedistributeThroughput.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginMongoDBDatabaseRetrieveThroughputDistribution(req *http.Request) (*http.Response, error) {
	if m.srv.BeginMongoDBDatabaseRetrieveThroughputDistribution == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginMongoDBDatabaseRetrieveThroughputDistribution not implemented")}
	}
	beginMongoDBDatabaseRetrieveThroughputDistribution := m.beginMongoDBDatabaseRetrieveThroughputDistribution.get(req)
	if beginMongoDBDatabaseRetrieveThroughputDistribution == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default/retrieveThroughputDistribution`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.RetrieveThroughputParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginMongoDBDatabaseRetrieveThroughputDistribution(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginMongoDBDatabaseRetrieveThroughputDistribution = &respr
		m.beginMongoDBDatabaseRetrieveThroughputDistribution.add(req, beginMongoDBDatabaseRetrieveThroughputDistribution)
	}

	resp, err := server.PollerResponderNext(beginMongoDBDatabaseRetrieveThroughputDistribution, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginMongoDBDatabaseRetrieveThroughputDistribution.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginMongoDBDatabaseRetrieveThroughputDistribution) {
		m.beginMongoDBDatabaseRetrieveThroughputDistribution.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginRetrieveContinuousBackupInformation(req *http.Request) (*http.Response, error) {
	if m.srv.BeginRetrieveContinuousBackupInformation == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRetrieveContinuousBackupInformation not implemented")}
	}
	beginRetrieveContinuousBackupInformation := m.beginRetrieveContinuousBackupInformation.get(req)
	if beginRetrieveContinuousBackupInformation == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/retrieveContinuousBackupInformation`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ContinuousBackupRestoreLocation](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		collectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginRetrieveContinuousBackupInformation(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, collectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRetrieveContinuousBackupInformation = &respr
		m.beginRetrieveContinuousBackupInformation.add(req, beginRetrieveContinuousBackupInformation)
	}

	resp, err := server.PollerResponderNext(beginRetrieveContinuousBackupInformation, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginRetrieveContinuousBackupInformation.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRetrieveContinuousBackupInformation) {
		m.beginRetrieveContinuousBackupInformation.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginUpdateMongoDBCollectionThroughput(req *http.Request) (*http.Response, error) {
	if m.srv.BeginUpdateMongoDBCollectionThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateMongoDBCollectionThroughput not implemented")}
	}
	beginUpdateMongoDBCollectionThroughput := m.beginUpdateMongoDBCollectionThroughput.get(req)
	if beginUpdateMongoDBCollectionThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/collections/(?P<collectionName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ThroughputSettingsUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		collectionNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("collectionName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginUpdateMongoDBCollectionThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, collectionNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateMongoDBCollectionThroughput = &respr
		m.beginUpdateMongoDBCollectionThroughput.add(req, beginUpdateMongoDBCollectionThroughput)
	}

	resp, err := server.PollerResponderNext(beginUpdateMongoDBCollectionThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginUpdateMongoDBCollectionThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateMongoDBCollectionThroughput) {
		m.beginUpdateMongoDBCollectionThroughput.remove(req)
	}

	return resp, nil
}

func (m *MongoDBResourcesServerTransport) dispatchBeginUpdateMongoDBDatabaseThroughput(req *http.Request) (*http.Response, error) {
	if m.srv.BeginUpdateMongoDBDatabaseThroughput == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdateMongoDBDatabaseThroughput not implemented")}
	}
	beginUpdateMongoDBDatabaseThroughput := m.beginUpdateMongoDBDatabaseThroughput.get(req)
	if beginUpdateMongoDBDatabaseThroughput == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DocumentDB/databaseAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/mongodbDatabases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/throughputSettings/default`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armcosmos.ThroughputSettingsUpdateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginUpdateMongoDBDatabaseThroughput(req.Context(), resourceGroupNameParam, accountNameParam, databaseNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdateMongoDBDatabaseThroughput = &respr
		m.beginUpdateMongoDBDatabaseThroughput.add(req, beginUpdateMongoDBDatabaseThroughput)
	}

	resp, err := server.PollerResponderNext(beginUpdateMongoDBDatabaseThroughput, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginUpdateMongoDBDatabaseThroughput.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdateMongoDBDatabaseThroughput) {
		m.beginUpdateMongoDBDatabaseThroughput.remove(req)
	}

	return resp, nil
}
