//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsql_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SyncMemberGet.json
func ExampleSyncMembersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSyncMembersClient().Get(ctx, "syncgroupcrud-65440", "syncgroupcrud-8475", "syncgroupcrud-4328", "syncgroupcrud-3187", "syncmembercrud-4879", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SyncMember = armsql.SyncMember{
	// 	Name: to.Ptr("syncmembercrud-4879"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/syncGroups/syncMembers"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328/syncGroups/syncgroupcrud-3187/syncMembers/syncmembercrud-4879"),
	// 	Properties: &armsql.SyncMemberProperties{
	// 		DatabaseName: to.Ptr("syncgroupcrud-7421"),
	// 		DatabaseType: to.Ptr(armsql.SyncMemberDbTypeAzureSQLDatabase),
	// 		PrivateEndpointName: to.Ptr("PE_67FDBBD6-B2D8-4014-9CC6-C68ABBCFD481_syncmembercrud-4879"),
	// 		ServerName: to.Ptr("syncgroupcrud-3379.database.windows.net"),
	// 		SyncDirection: to.Ptr(armsql.SyncDirectionBidirectional),
	// 		SyncMemberAzureDatabaseResourceID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
	// 		SyncState: to.Ptr(armsql.SyncMemberStateUnProvisioned),
	// 		UsePrivateLinkConnection: to.Ptr(true),
	// 		UserName: to.Ptr("myUser"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SyncMemberCreate.json
func ExampleSyncMembersClient_BeginCreateOrUpdate_createANewSyncMember() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSyncMembersClient().BeginCreateOrUpdate(ctx, "syncgroupcrud-65440", "syncgroupcrud-8475", "syncgroupcrud-4328", "syncgroupcrud-3187", "syncmembercrud-4879", armsql.SyncMember{
		Properties: &armsql.SyncMemberProperties{
			DatabaseName:                      to.Ptr("syncgroupcrud-7421"),
			DatabaseType:                      to.Ptr(armsql.SyncMemberDbTypeAzureSQLDatabase),
			ServerName:                        to.Ptr("syncgroupcrud-3379.database.windows.net"),
			SyncDirection:                     to.Ptr(armsql.SyncDirectionBidirectional),
			SyncMemberAzureDatabaseResourceID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
			UsePrivateLinkConnection:          to.Ptr(true),
			UserName:                          to.Ptr("myUser"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SyncMember = armsql.SyncMember{
	// 	Name: to.Ptr("syncmembercrud-4879"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/syncGroups/syncMembers"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328/syncGroups/syncgroupcrud-3187/syncMembers/syncmembercrud-4879"),
	// 	Properties: &armsql.SyncMemberProperties{
	// 		DatabaseName: to.Ptr("syncgroupcrud-7421"),
	// 		DatabaseType: to.Ptr(armsql.SyncMemberDbTypeAzureSQLDatabase),
	// 		PrivateEndpointName: to.Ptr("PE_67FDBBD6-B2D8-4014-9CC6-C68ABBCFD481_syncmembercrud-4879"),
	// 		ServerName: to.Ptr("syncgroupcrud-3379.database.windows.net"),
	// 		SyncDirection: to.Ptr(armsql.SyncDirectionBidirectional),
	// 		SyncMemberAzureDatabaseResourceID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
	// 		SyncState: to.Ptr(armsql.SyncMemberStateUnProvisioned),
	// 		UsePrivateLinkConnection: to.Ptr(true),
	// 		UserName: to.Ptr("myUser"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SyncMemberUpdate.json
func ExampleSyncMembersClient_BeginCreateOrUpdate_updateASyncMember() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSyncMembersClient().BeginCreateOrUpdate(ctx, "syncgroupcrud-65440", "syncgroupcrud-8475", "syncgroupcrud-4328", "syncgroupcrud-3187", "syncmembercrud-4879", armsql.SyncMember{
		Properties: &armsql.SyncMemberProperties{
			DatabaseName:                      to.Ptr("syncgroupcrud-7421"),
			DatabaseType:                      to.Ptr(armsql.SyncMemberDbTypeAzureSQLDatabase),
			ServerName:                        to.Ptr("syncgroupcrud-3379.database.windows.net"),
			SyncDirection:                     to.Ptr(armsql.SyncDirectionBidirectional),
			SyncMemberAzureDatabaseResourceID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
			UsePrivateLinkConnection:          to.Ptr(true),
			UserName:                          to.Ptr("myUser"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SyncMember = armsql.SyncMember{
	// 	Name: to.Ptr("syncmembercrud-4879"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/syncGroups/syncMembers"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328/syncGroups/syncgroupcrud-3187/syncMembers/syncmembercrud-4879"),
	// 	Properties: &armsql.SyncMemberProperties{
	// 		DatabaseName: to.Ptr("syncgroupcrud-7421"),
	// 		DatabaseType: to.Ptr(armsql.SyncMemberDbTypeAzureSQLDatabase),
	// 		PrivateEndpointName: to.Ptr("PE_67FDBBD6-B2D8-4014-9CC6-C68ABBCFD481_syncmembercrud-4879"),
	// 		ServerName: to.Ptr("syncgroupcrud-3379.database.windows.net"),
	// 		SyncDirection: to.Ptr(armsql.SyncDirectionBidirectional),
	// 		SyncMemberAzureDatabaseResourceID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
	// 		SyncState: to.Ptr(armsql.SyncMemberStateUnProvisioned),
	// 		UsePrivateLinkConnection: to.Ptr(true),
	// 		UserName: to.Ptr("myUser"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SyncMemberDelete.json
func ExampleSyncMembersClient_BeginDelete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSyncMembersClient().BeginDelete(ctx, "syncgroupcrud-65440", "syncgroupcrud-8475", "syncgroupcrud-4328", "syncgroupcrud-3187", "syncgroupcrud-4879", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SyncMemberPatch.json
func ExampleSyncMembersClient_BeginUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSyncMembersClient().BeginUpdate(ctx, "syncgroupcrud-65440", "syncgroupcrud-8475", "syncgroupcrud-4328", "syncgroupcrud-3187", "syncmembercrud-4879", armsql.SyncMember{
		Properties: &armsql.SyncMemberProperties{
			DatabaseName:                      to.Ptr("syncgroupcrud-7421"),
			DatabaseType:                      to.Ptr(armsql.SyncMemberDbTypeAzureSQLDatabase),
			ServerName:                        to.Ptr("syncgroupcrud-3379.database.windows.net"),
			SyncDirection:                     to.Ptr(armsql.SyncDirectionBidirectional),
			SyncMemberAzureDatabaseResourceID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
			UsePrivateLinkConnection:          to.Ptr(true),
			UserName:                          to.Ptr("myUser"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SyncMember = armsql.SyncMember{
	// 	Name: to.Ptr("syncmembercrud-4879"),
	// 	Type: to.Ptr("Microsoft.Sql/servers/databases/syncGroups/syncMembers"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328/syncGroups/syncgroupcrud-3187/syncMembers/syncmembercrud-4879"),
	// 	Properties: &armsql.SyncMemberProperties{
	// 		DatabaseName: to.Ptr("syncgroupcrud-7421"),
	// 		DatabaseType: to.Ptr(armsql.SyncMemberDbTypeAzureSQLDatabase),
	// 		PrivateEndpointName: to.Ptr("PE_67FDBBD6-B2D8-4014-9CC6-C68ABBCFD481_syncmembercrud-4879"),
	// 		ServerName: to.Ptr("syncgroupcrud-3379.database.windows.net"),
	// 		SyncDirection: to.Ptr(armsql.SyncDirectionBidirectional),
	// 		SyncMemberAzureDatabaseResourceID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
	// 		SyncState: to.Ptr(armsql.SyncMemberStateUnProvisioned),
	// 		UsePrivateLinkConnection: to.Ptr(true),
	// 		UserName: to.Ptr("myUser"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SyncMemberListBySyncGroup.json
func ExampleSyncMembersClient_NewListBySyncGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSyncMembersClient().NewListBySyncGroupPager("syncgroupcrud-65440", "syncgroupcrud-8475", "syncgroupcrud-4328", "syncgroupcrud-3187", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SyncMemberListResult = armsql.SyncMemberListResult{
		// 	Value: []*armsql.SyncMember{
		// 		{
		// 			Name: to.Ptr("syncmembercrud-4879"),
		// 			Type: to.Ptr("Microsoft.Sql/servers/databases/syncGroups/syncMembers"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328/syncGroups/syncgroupcrud-3187/syncMembers/syncmembercrud-4879"),
		// 			Properties: &armsql.SyncMemberProperties{
		// 				DatabaseName: to.Ptr("syncgroupcrud-7421"),
		// 				DatabaseType: to.Ptr(armsql.SyncMemberDbTypeAzureSQLDatabase),
		// 				PrivateEndpointName: to.Ptr("PE_67FDBBD6-B2D8-4014-9CC6-C68ABBCFD481_syncmembercrud-4879"),
		// 				ServerName: to.Ptr("syncgroupcrud-3379.database.windows.net"),
		// 				SyncDirection: to.Ptr(armsql.SyncDirectionBidirectional),
		// 				SyncMemberAzureDatabaseResourceID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
		// 				SyncState: to.Ptr(armsql.SyncMemberStateUnProvisioned),
		// 				UsePrivateLinkConnection: to.Ptr(true),
		// 				UserName: to.Ptr("myUser"),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SyncMemberGetSchema.json
func ExampleSyncMembersClient_NewListMemberSchemasPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSyncMembersClient().NewListMemberSchemasPager("syncgroupcrud-65440", "syncgroupcrud-8475", "syncgroupcrud-4328", "syncgroupcrud-3187", "syncgroupcrud-4879", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.SyncFullSchemaPropertiesListResult = armsql.SyncFullSchemaPropertiesListResult{
		// 	Value: []*armsql.SyncFullSchemaProperties{
		// 		{
		// 			LastUpdateTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-05-30T07:16:08.210Z"); return t}()),
		// 			Tables: []*armsql.SyncFullSchemaTable{
		// 				{
		// 					Name: to.Ptr("dbo.myTable"),
		// 					Columns: []*armsql.SyncFullSchemaTableColumn{
		// 						{
		// 							Name: to.Ptr("intField"),
		// 							DataSize: to.Ptr("4"),
		// 							DataType: to.Ptr("int"),
		// 							HasError: to.Ptr(false),
		// 							IsPrimaryKey: to.Ptr(false),
		// 							QuotedName: to.Ptr("[intField]"),
		// 						},
		// 						{
		// 							Name: to.Ptr("charField"),
		// 							DataSize: to.Ptr("100"),
		// 							DataType: to.Ptr("nvarchar"),
		// 							HasError: to.Ptr(false),
		// 							IsPrimaryKey: to.Ptr(false),
		// 							QuotedName: to.Ptr("[charField]"),
		// 					}},
		// 					ErrorID: to.Ptr("Schema_TableHasNoPrimaryKey"),
		// 					HasError: to.Ptr(true),
		// 					QuotedName: to.Ptr("[dbo].[myTable]"),
		// 			}},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/c78b5d8bd3aff2d82a5f034d9164b1a9ac030e09/specification/sql/resource-manager/Microsoft.Sql/preview/2020-11-01-preview/examples/SyncMemberRefreshSchema.json
func ExampleSyncMembersClient_BeginRefreshMemberSchema() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsql.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSyncMembersClient().BeginRefreshMemberSchema(ctx, "syncgroupcrud-65440", "syncgroupcrud-8475", "syncgroupcrud-4328", "syncgroupcrud-3187", "syncgroupcrud-4879", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}
