/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.CurrentJvmToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultJavaToolchainUsageProgressDetails;
import org.gradle.jvm.toolchain.internal.InstallationLocation;
import org.gradle.jvm.toolchain.internal.JavaInstallationRegistry;
import org.gradle.jvm.toolchain.internal.JavaToolchain;
import org.gradle.jvm.toolchain.internal.JavaToolchainComparator;
import org.gradle.jvm.toolchain.internal.JavaToolchainFactory;
import org.gradle.jvm.toolchain.internal.JavaToolchainInput;
import org.gradle.jvm.toolchain.internal.JavaToolchainMatcher;
import org.gradle.jvm.toolchain.internal.JavaToolchainSpecInternal;
import org.gradle.jvm.toolchain.internal.NoToolchainAvailableException;
import org.gradle.jvm.toolchain.internal.SpecificInstallationToolchainSpec;
import org.gradle.jvm.toolchain.internal.install.JavaToolchainProvisioningService;

@ServiceScope(value=Scopes.Project.class)
public class JavaToolchainQueryService {
    private final JavaInstallationRegistry registry;
    private final JavaToolchainFactory toolchainFactory;
    private final JavaToolchainProvisioningService installService;
    private final Provider<Boolean> detectEnabled;
    private final Provider<Boolean> downloadEnabled;
    private final Map<JavaToolchainSpecInternal.Key, Object> matchingToolchains;

    @Inject
    public JavaToolchainQueryService(JavaInstallationRegistry registry, JavaToolchainFactory toolchainFactory, JavaToolchainProvisioningService provisioningService, ProviderFactory factory) {
        this.registry = registry;
        this.toolchainFactory = toolchainFactory;
        this.installService = provisioningService;
        this.detectEnabled = factory.gradleProperty("org.gradle.java.installations.auto-detect").map(Boolean::parseBoolean);
        this.downloadEnabled = factory.gradleProperty("org.gradle.java.installations.auto-download").map(Boolean::parseBoolean);
        this.matchingToolchains = new HashMap<JavaToolchainSpecInternal.Key, Object>();
    }

    <T> Provider<T> toolFor(JavaToolchainSpec spec, Transformer<T, JavaToolchain> toolFunction, DefaultJavaToolchainUsageProgressDetails.JavaTool requestedTool) {
        return this.findMatchingToolchain(spec).withSideEffect((ValueSupplier.SideEffect & Serializable)toolchain -> toolchain.emitUsageEvent(requestedTool)).map(toolFunction);
    }

    @VisibleForTesting
    ProviderInternal<JavaToolchain> findMatchingToolchain(JavaToolchainSpec filter) {
        JavaToolchainSpecInternal filterInternal = (JavaToolchainSpecInternal)Objects.requireNonNull(filter);
        return new DefaultProvider(() -> {
            if (!filterInternal.isValid()) {
                DeprecationLogger.deprecate((String)"Using toolchain specifications without setting a language version").withAdvice("Consider configuring the language version.").willBecomeAnErrorInGradle8().withUpgradeGuideSection(7, "invalid_toolchain_specification_deprecation").nagUser();
            }
            if (!filterInternal.isConfigured()) {
                return null;
            }
            Map<JavaToolchainSpecInternal.Key, Object> map = this.matchingToolchains;
            synchronized (map) {
                if (this.matchingToolchains.containsKey(filterInternal.toKey())) {
                    return this.handleMatchingToolchainCached(filterInternal);
                }
                return this.handleMatchingToolchainUnknown(filterInternal);
            }
        });
    }

    private JavaToolchain handleMatchingToolchainCached(JavaToolchainSpecInternal filterInternal) throws Exception {
        Object previousResult = this.matchingToolchains.get(filterInternal.toKey());
        if (previousResult instanceof Exception) {
            throw (Exception)previousResult;
        }
        return (JavaToolchain)previousResult;
    }

    private JavaToolchain handleMatchingToolchainUnknown(JavaToolchainSpecInternal filterInternal) {
        try {
            JavaToolchain toolchain = this.query(filterInternal);
            this.matchingToolchains.put(filterInternal.toKey(), toolchain);
            return toolchain;
        }
        catch (Exception e) {
            this.matchingToolchains.put(filterInternal.toKey(), e);
            throw e;
        }
    }

    private JavaToolchain query(JavaToolchainSpec spec) {
        if (spec instanceof CurrentJvmToolchainSpec) {
            return this.asToolchain(new InstallationLocation(Jvm.current().getJavaHome(), "current JVM"), spec).get();
        }
        if (spec instanceof SpecificInstallationToolchainSpec) {
            return this.asToolchain(new InstallationLocation(((SpecificInstallationToolchainSpec)spec).getJavaHome(), "specific installation"), spec).get();
        }
        this.warnIfAutoProvisioningOnWithoutRepositoryDefinitions();
        Optional<JavaToolchain> detectedToolchain = this.registry.listInstallations().stream().map(javaHome -> this.asToolchain((InstallationLocation)javaHome, spec)).filter(Optional::isPresent).map(Optional::get).filter(new JavaToolchainMatcher(spec)).min(new JavaToolchainComparator());
        if (detectedToolchain.isPresent()) {
            return detectedToolchain.get();
        }
        InstallationLocation downloadedInstallation = this.downloadToolchain(spec);
        JavaToolchain downloadedToolchain = this.asToolchainOrThrow(downloadedInstallation, spec);
        this.registry.addInstallation(downloadedInstallation);
        return downloadedToolchain;
    }

    private void warnIfAutoProvisioningOnWithoutRepositoryDefinitions() {
        if (this.installService.isAutoDownloadEnabled() && !this.installService.hasConfiguredToolchainRepositories()) {
            ((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)"Java toolchain auto-provisioning enabled, but no java toolchain repositories declared by the build. Will rely on the built-in repository.").withAdvice("In order to declare a repository for java toolchains, you must edit your settings script and add one via the toolchainManagement block.")).willBeRemovedInGradle8().withUserManual("toolchains", "sec:provisioning").nagUser();
        }
    }

    private InstallationLocation downloadToolchain(JavaToolchainSpec spec) {
        Optional<File> installation = this.installService.tryInstall(spec);
        if (!installation.isPresent()) {
            throw new NoToolchainAvailableException(spec, (Boolean)this.detectEnabled.getOrElse((Object)true), (Boolean)this.downloadEnabled.getOrElse((Object)true));
        }
        return new InstallationLocation(installation.get(), "provisioned toolchain");
    }

    private JavaToolchain asToolchainOrThrow(InstallationLocation javaHome, JavaToolchainSpec spec) {
        Optional<JavaToolchain> toolchain = this.asToolchain(javaHome, spec);
        if (!toolchain.isPresent()) {
            throw new GradleException("Toolchain installation '" + javaHome.getLocation() + "' could not be probed.");
        }
        return toolchain.get();
    }

    private Optional<JavaToolchain> asToolchain(InstallationLocation javaHome, JavaToolchainSpec spec) {
        return this.toolchainFactory.newInstance(javaHome, new JavaToolchainInput(spec));
    }
}

