/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import net.sf.freecol.common.FreeColException;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.server.model.ServerBuilding;
import net.sf.freecol.util.test.FreeColTestCase;

public class SettlementTest
extends FreeColTestCase {
    private static final GoodsType horsesType = SettlementTest.spec().getGoodsType("model.goods.horses");
    private static final GoodsType musketsType = SettlementTest.spec().getGoodsType("model.goods.muskets");
    private static final Role dragoonRole = SettlementTest.spec().getRole("model.role.dragoon");
    private static final Role mountedBraveRole = SettlementTest.spec().getRole("model.role.mountedBrave");
    private static final Role nativeDragoonRole = SettlementTest.spec().getRole("model.role.nativeDragoon");
    private static final Role soldierRole = SettlementTest.spec().getRole("model.role.soldier");

    public void testSettlementRadius() throws FreeColException {
        Game game = SettlementTest.getStandardGame();
        Map map = SettlementTest.getTestMap();
        game.changeMap(map);
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        Player arawak = game.getPlayerByNationId("model.nation.arawak");
        builder.player(arawak);
        IndianSettlement is = builder.build();
        SettlementTest.assertEquals((int)1, (int)arawak.getNationType().getSettlementType(false).getClaimableRadius());
        SettlementTest.assertEquals((int)1, (int)is.getType().getClaimableRadius());
        is.dispose();
        builder.capital(true);
        is = builder.build();
        SettlementTest.assertEquals((int)2, (int)arawak.getNationType().getCapitalType().getClaimableRadius());
        SettlementTest.assertEquals((int)2, (int)is.getType().getClaimableRadius());
        is.dispose();
        Player inca = game.getPlayerByNationId("model.nation.inca");
        builder.player(inca);
        builder.capital(false);
        is = builder.build();
        SettlementTest.assertEquals((int)2, (int)inca.getNationType().getSettlementType(false).getClaimableRadius());
        SettlementTest.assertEquals((int)2, (int)is.getType().getClaimableRadius());
        is.dispose();
        builder.capital(true);
        is = builder.build();
        SettlementTest.assertEquals((int)3, (int)inca.getNationType().getCapitalType().getClaimableRadius());
        SettlementTest.assertEquals((int)3, (int)is.getType().getClaimableRadius());
        is.dispose();
    }

    public void testColonyRadius() {
        Game game = SettlementTest.getGame();
        Map map = SettlementTest.getTestMap();
        game.changeMap(map);
        Colony colony = this.getStandardColony();
        SettlementTest.assertEquals((int)1, (int)colony.getOwner().getNationType().getSettlementType(false).getClaimableRadius());
        SettlementTest.assertEquals((int)1, (int)colony.getRadius());
        SettlementTest.assertFalse((boolean)colony.isCapital());
    }

    public void testSettlementDoesNotClaimWater() {
        Game game = SettlementTest.getStandardGame();
        Map map = SettlementTest.getTestMap();
        game.changeMap(map);
        map.getTile(4, 8).setType(SettlementTest.spec().getTileType("model.tile.ocean"));
        SettlementTest.assertFalse((boolean)map.getTile(4, 8).isLand());
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game);
        IndianSettlement is = builder.build();
        for (Tile tile : is.getTile().getSurroundingTiles(1)) {
            SettlementTest.assertEquals((boolean)tile.isLand(), (tile.getOwner() == is.getOwner() ? 1 : 0) != 0);
            SettlementTest.assertEquals((boolean)tile.isLand(), (tile.getOwningSettlement() == is ? 1 : 0) != 0);
        }
    }

    public void testColonyClaimsWater() {
        Game game = SettlementTest.getGame();
        Map map = SettlementTest.getTestMap();
        game.changeMap(map);
        map.getTile(4, 8).setType(SettlementTest.spec().getTileType("model.tile.ocean"));
        SettlementTest.assertFalse((boolean)map.getTile(4, 8).isLand());
        Colony colony = this.getStandardColony();
        for (Tile tile : colony.getTile().getSurroundingTiles(1)) {
            SettlementTest.assertEquals((String)("Tile " + tile.toString() + " should be owned by " + colony.getOwner().getId()), (Object)tile.getOwner(), (Object)colony.getOwner());
            SettlementTest.assertEquals((String)("Tile " + tile.toString() + " should be owned by " + colony.getId()), (Object)tile.getOwningSettlement(), (Object)colony);
        }
    }

    public void testLineOfSight() {
        Game game = SettlementTest.getGame();
        Map map = SettlementTest.getTestMap();
        game.changeMap(map);
        Colony colony = this.getStandardColony();
        SettlementTest.assertEquals((int)2, (int)colony.getLineOfSight());
        BuildingType towerType = new BuildingType("tower", SettlementTest.spec());
        Modifier modifier = new Modifier("model.modifier.lineOfSightBonus", 2.0f, Modifier.ModifierType.ADDITIVE);
        towerType.addModifier(modifier);
        ServerBuilding tower = new ServerBuilding(SettlementTest.getGame(), colony, towerType);
        colony.addBuilding(tower);
        SettlementTest.assertEquals((int)4, (int)colony.getLineOfSight());
    }

    public void testCanImproveUnitMilitaryRole() {
        Game game = SettlementTest.getGame();
        Map map = SettlementTest.getTestMap();
        game.changeMap(map);
        Colony colony = this.getStandardColony(4);
        Unit colonist = colony.getUnitList().get(0);
        SettlementTest.assertNull((Object)colony.canImproveUnitMilitaryRole(colonist));
        colony.addGoods(musketsType, 40);
        SettlementTest.assertNull((Object)colony.canImproveUnitMilitaryRole(colonist));
        colony.addGoods(musketsType, 10);
        SettlementTest.assertTrue((boolean)colony.canProvideGoods(soldierRole.getRequiredGoodsList()));
        SettlementTest.assertEquals((Object)soldierRole, (Object)colony.canImproveUnitMilitaryRole(colonist));
        SettlementTest.assertTrue((boolean)colony.equipForRole(colonist, soldierRole, 1));
        SettlementTest.assertNull((Object)colony.canImproveUnitMilitaryRole(colonist));
        colony.addGoods(musketsType, 100);
        SettlementTest.assertNull((Object)colony.canImproveUnitMilitaryRole(colonist));
        colony.addGoods(horsesType, 100);
        SettlementTest.assertEquals((Object)dragoonRole, (Object)colony.canImproveUnitMilitaryRole(colonist));
        SettlementTest.assertTrue((boolean)colony.equipForRole(colonist, dragoonRole, 1));
        SettlementTest.assertNull((Object)colony.canImproveUnitMilitaryRole(colonist));
        Player arawak = game.getPlayerByNationId("model.nation.arawak");
        FreeColTestCase.IndianSettlementBuilder builder = new FreeColTestCase.IndianSettlementBuilder(game).player(arawak).initialBravesInCamp(4);
        IndianSettlement is = builder.build();
        Unit brave = is.getUnitList().get(0);
        SettlementTest.assertNull((Object)is.canImproveUnitMilitaryRole(brave));
        is.addGoods(horsesType, 20);
        SettlementTest.assertNull((Object)is.canImproveUnitMilitaryRole(brave));
        is.addGoods(horsesType, 10);
        SettlementTest.assertEquals((Object)mountedBraveRole, (Object)is.canImproveUnitMilitaryRole(brave));
        SettlementTest.assertTrue((boolean)is.equipForRole(brave, mountedBraveRole, 1));
        SettlementTest.assertNull((Object)is.canImproveUnitMilitaryRole(brave));
        is.addGoods(horsesType, 100);
        SettlementTest.assertNull((Object)is.canImproveUnitMilitaryRole(brave));
        is.addGoods(musketsType, 100);
        SettlementTest.assertEquals((Object)nativeDragoonRole, (Object)is.canImproveUnitMilitaryRole(brave));
        SettlementTest.assertTrue((boolean)is.equipForRole(brave, nativeDragoonRole, 1));
        SettlementTest.assertNull((Object)is.canImproveUnitMilitaryRole(brave));
    }
}

