
use builtin;
use str;

set edit:completion:arg-completer[hq] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'hq'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'hq'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand -V 'Print version'
            cand --version 'Print version'
            cand server 'Commands for the server'
            cand job 'Commands for jobs'
            cand task 'Commands for tasks'
            cand submit 'Submits a new job'
            cand worker 'Commands for workers'
            cand output-log 'Operations for streaming logs'
            cand alloc 'Automatic allocation management'
            cand journal 'Journal management'
            cand data 'Data object management inside a task'
            cand dashboard 'Starts CLI dashboard'
            cand doc 'Shows documentation'
            cand generate-completion 'Generates shell completion script'
        }
        &'hq;server'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand start 'Start the server'
            cand stop 'Stop the server'
            cand info 'Show info of a running server'
            cand generate-access 'Generate an access file without starting the server'
        }
        &'hq;server;start'= {
            cand --host 'Hostname/IP of the machine under which is visible to others'
            cand --idle-timeout 'Duration after which will an idle worker automatically stop.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --client-port 'The port for client connections'
            cand --worker-port 'The port for worker connections'
            cand --journal 'The path to a journal file'
            cand --journal-flush-period 'Configure how often should be the journal written.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --access-file 'The path to an access file'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --disable-client-authentication-and-encryption 'If set, the client connection will NOT be AUTHENTICATED and ENCRYPTED'
            cand --disable-worker-authentication-and-encryption 'If set, the worker connection will NOT be AUTHENTICATED and ENCRYPTED'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;server;stop'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;server;info'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;server;generate-access'= {
            cand --client-file 'The filename of the generated client''s access file'
            cand --worker-file 'The filename of the generated worker''s access file'
            cand --host 'Override the target host name'
            cand --client-host 'Override target host name for clients'
            cand --worker-host 'Override target host name for workers'
            cand --client-port 'The port for connecting client'
            cand --worker-port 'The port for connecting workers'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'Displays information about jobs'
            cand summary 'Displays a summary with the number of jobs'
            cand info 'Displays detailed information of a job'
            cand cancel 'Cancels a job'
            cand forget 'Forget a job'
            cand cat 'Shows task(s) stdout and stderr'
            cand submit 'Submit a new job'
            cand submit-file 'Submits a job by a job definition file'
            cand wait 'Waits until a job is finished'
            cand progress 'Shows a progressbar with tasks/jobs'
            cand task-ids 'Prints task ids for a job'
            cand open 'Opens a new job (without attaching any tasks yet)'
            cand close 'Closes an open job'
        }
        &'hq;job;list'= {
            cand --filter 'Display only jobs with the given states'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --all 'Display all jobs'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;summary'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;info'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;cancel'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;forget'= {
            cand --filter 'Forget only jobs with the given states'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;cat'= {
            cand --tasks 'Filter task(s) by ID'
            cand --task-status 'Filter task(s) by status. You can use multiple states separated by a comma'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --print-task-header 'Add task headers to the output'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;submit'= {
            cand --name 'The name of the job'
            cand --max-fails 'Maximum number tasks that may fail in the job'
            cand --nodes 'The number of nodes'
            cand --cpus 'The number and placement of CPUs for each job'
            cand --resource 'The request of resources in the form <NAME>=<AMOUNT>'
            cand --time-request 'Minimal lifetime of the worker needed to start the job  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --pin 'Pins the job to the cores specified in `--cpus`'
            cand --cwd 'Working directory for submitted tasks'
            cand --stdout 'Where to store the standard output of tasks'
            cand --stderr 'Where to store the standard error output of tasks'
            cand --env 'Additional environment variable for tasks'
            cand --each-line 'Creates a task for each line of the given file'
            cand --from-json 'Creates a task for each item of JSON array in the given file'
            cand --array 'Creates a task array'
            cand --priority 'Tasks priority'
            cand --time-limit 'Time limit per task. E.g. --time-limit=10min  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --stream 'Stream the output of tasks into the given log file'
            cand --crash-limit 'Sets the crash counter limit'
            cand --job 'Attach a submission to an open job'
            cand --directives 'Select directives parsing mode'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --task-dir 'Create a temporary directory for task(s)'
            cand --wait 'Wait for the job to finish'
            cand --progress 'Shows a progressbar'
            cand --stdin 'Attach the stdin to the task'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;submit-file'= {
            cand --job 'Attach a submission to an open job'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;wait'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --without-close 'Waits until all tasks are completed, even if the job is still open'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;progress'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;task-ids'= {
            cand --filter 'Selects only tasks with the given state(s)'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;open'= {
            cand --name 'The name of the job'
            cand --max-fails 'Maximum number tasks that may fail in the job'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;job;close'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;task'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'Displays task(s) associated with selected job(s)'
            cand info 'Displays detailed task info'
            cand explain 'Explain if task can run on a selected worker'
        }
        &'hq;task;list'= {
            cand --tasks 'Filter task(s) by ID'
            cand --task-status 'Filter task(s) by status. You can use multiple states separated by a comma'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand -v 'Use this flag to enable verbose output'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;task;info'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand -v 'Use this flag to enable verbose output'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;task;explain'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;submit'= {
            cand --name 'The name of the job'
            cand --max-fails 'Maximum number tasks that may fail in the job'
            cand --nodes 'The number of nodes'
            cand --cpus 'The number and placement of CPUs for each job'
            cand --resource 'The request of resources in the form <NAME>=<AMOUNT>'
            cand --time-request 'Minimal lifetime of the worker needed to start the job  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --pin 'Pins the job to the cores specified in `--cpus`'
            cand --cwd 'Working directory for submitted tasks'
            cand --stdout 'Where to store the standard output of tasks'
            cand --stderr 'Where to store the standard error output of tasks'
            cand --env 'Additional environment variable for tasks'
            cand --each-line 'Creates a task for each line of the given file'
            cand --from-json 'Creates a task for each item of JSON array in the given file'
            cand --array 'Creates a task array'
            cand --priority 'Tasks priority'
            cand --time-limit 'Time limit per task. E.g. --time-limit=10min  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --stream 'Stream the output of tasks into the given log file'
            cand --crash-limit 'Sets the crash counter limit'
            cand --job 'Attach a submission to an open job'
            cand --directives 'Select directives parsing mode'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --task-dir 'Create a temporary directory for task(s)'
            cand --wait 'Wait for the job to finish'
            cand --progress 'Shows a progressbar'
            cand --stdin 'Attach the stdin to the task'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand start 'Starts a worker'
            cand stop 'Stops a worker'
            cand list 'Displays information about workers'
            cand hwdetect 'Performs hardware detection'
            cand info 'Displays information about a worker'
            cand address 'Displays worker''s hostname'
            cand wait 'Waits on the connection of worker(s)'
            cand deploy-ssh 'Deploys a set of workers using SSH'
        }
        &'hq;worker;start'= {
            cand --cpus 'The cores assigned to the worker'
            cand --resource 'Resources provided by the worker'
            cand --group 'Sets worker''s group'
            cand --idle-timeout 'Duration after which will an idle worker automatically stop  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --overview-interval 'The period of reporting the overview to the server'
            cand --heartbeat 'How often heartbeats are sent  Heartbeats are used to detect worker''s liveness. If the worker does not send a heartbeat for given time, then the worker is considered as lost.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --time-limit 'Worker time limit  Worker exits after given time.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --manager 'Sets HPC job manager for the worker'
            cand --hostname 'Overwrites worker hostname'
            cand --on-server-lost 'The policy when a connection to a server is lost'
            cand --work-dir 'Sets the working directory for the worker'
            cand --max-parallel-downloads 'The maximal parallel downloads for data objects'
            cand --max-download-tries 'The maximal data object download tries'
            cand --wait-between-download-tries 'The delay between download attempts  Sets how long to wait between failed downloads of data object. This time is multiplied by the number of previous retries. Therefore between 4th and 5th retry it waits 4 * the given duration  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --no-detect-resources 'Disables auto-detection of resources'
            cand --no-hyper-threading 'Ignores hyper-threading while detecting CPU cores'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;stop'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;list'= {
            cand --filter 'Select only workers in the given state'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --all 'Display all workers'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;hwdetect'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --no-hyper-threading 'Detect only physical cores'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;info'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;address'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;wait'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;worker;deploy-ssh'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --show-output 'Show log output of the spawned worker(s)'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;output-log'= {
            cand --server-uid 'Filter files for the given server instance'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand summary 'Prints summary of the log file'
            cand jobs 'Prints job ids in the stream'
            cand show 'Prints the stream content ordered by time'
            cand cat 'Prints the content of a stream''s channel'
            cand export 'Exports stream into JSON'
        }
        &'hq;output-log;summary'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;output-log;jobs'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;output-log;show'= {
            cand --job 'JobId'
            cand --channel 'Show only the specific channel'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;output-log;cat'= {
            cand --task 'Prints only outputs of the selected tasks'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --allow-unfinished 'Allow unfinished channels'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;output-log;export'= {
            cand --task 'Exports only output of the selected tasks'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand list 'Displays allocation queues'
            cand info 'Display allocations of the specified allocation queue'
            cand add 'Add a new allocation queue'
            cand pause 'Pause an existing allocation queue'
            cand resume 'Resume a previously paused allocation queue'
            cand dry-run 'Try to submit an allocation to test allocation parameters'
            cand remove 'Removes an allocation queue with the given ID'
        }
        &'hq;alloc;list'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;info'= {
            cand --filter 'Display only allocations with the given state'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;add'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand pbs 'Create a PBS allocation queue'
            cand slurm 'Create a SLURM allocation queue'
        }
        &'hq;alloc;add;pbs'= {
            cand -b 'The maximal number of jobs that can be waiting in the queue'
            cand --backlog 'The maximal number of jobs that can be waiting in the queue'
            cand -t 'Time limit (walltime) of PBS/Slurm allocations  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --time-limit 'Time limit (walltime) of PBS/Slurm allocations  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand -m 'The maximal number of workers (=nodes) spawned in a single allocation'
            cand --max-workers-per-alloc 'The maximal number of workers (=nodes) spawned in a single allocation'
            cand --max-worker-count 'The maximum number of workers that can be queued/running at any given time in this queue'
            cand -n 'Name of the allocation queue (for debug purposes only)'
            cand --name 'Name of the allocation queue (for debug purposes only)'
            cand --cpus 'The cores assigned to the worker'
            cand --resource 'Resources provided by the worker'
            cand --group 'Sets worker''s group'
            cand --idle-timeout 'Duration after which will an idle worker automatically stop  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --overview-interval 'The period of reporting the overview to the server'
            cand --on-server-lost 'The policy when a connection to a server is lost'
            cand --worker-start-cmd 'A command executed before the start of each worker'
            cand --worker-stop-cmd 'A command executed after the worker terminates'
            cand --worker-time-limit ' Worker''s time limit  Time limit after which workers in the submitted allocations will be stopped. By default, it is set to the time limit of the allocation. However, if you want the workers to be stopped sooner, for example to give `worker_stop_cmd` more time to execute before the allocation is killed, you can lower the worker time limit.  The limit must not be larger than the allocation time limit.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --min-utilization 'Minimal expected utilization required to submit an allocation into this queue'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --no-detect-resources 'Disables auto-detection of resources'
            cand --no-hyper-threading 'Ignores hyper-threading while detecting CPU cores'
            cand --no-dry-run 'Disables verifying the parameter correctness via dry-run'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;add;slurm'= {
            cand -b 'The maximal number of jobs that can be waiting in the queue'
            cand --backlog 'The maximal number of jobs that can be waiting in the queue'
            cand -t 'Time limit (walltime) of PBS/Slurm allocations  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --time-limit 'Time limit (walltime) of PBS/Slurm allocations  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand -m 'The maximal number of workers (=nodes) spawned in a single allocation'
            cand --max-workers-per-alloc 'The maximal number of workers (=nodes) spawned in a single allocation'
            cand --max-worker-count 'The maximum number of workers that can be queued/running at any given time in this queue'
            cand -n 'Name of the allocation queue (for debug purposes only)'
            cand --name 'Name of the allocation queue (for debug purposes only)'
            cand --cpus 'The cores assigned to the worker'
            cand --resource 'Resources provided by the worker'
            cand --group 'Sets worker''s group'
            cand --idle-timeout 'Duration after which will an idle worker automatically stop  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --overview-interval 'The period of reporting the overview to the server'
            cand --on-server-lost 'The policy when a connection to a server is lost'
            cand --worker-start-cmd 'A command executed before the start of each worker'
            cand --worker-stop-cmd 'A command executed after the worker terminates'
            cand --worker-time-limit ' Worker''s time limit  Time limit after which workers in the submitted allocations will be stopped. By default, it is set to the time limit of the allocation. However, if you want the workers to be stopped sooner, for example to give `worker_stop_cmd` more time to execute before the allocation is killed, you can lower the worker time limit.  The limit must not be larger than the allocation time limit.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --min-utilization 'Minimal expected utilization required to submit an allocation into this queue'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --no-detect-resources 'Disables auto-detection of resources'
            cand --no-hyper-threading 'Ignores hyper-threading while detecting CPU cores'
            cand --no-dry-run 'Disables verifying the parameter correctness via dry-run'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;pause'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;resume'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;dry-run'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand pbs 'Try to create a PBS allocation'
            cand slurm 'Try to create a SLURM allocation'
        }
        &'hq;alloc;dry-run;pbs'= {
            cand -b 'The maximal number of jobs that can be waiting in the queue'
            cand --backlog 'The maximal number of jobs that can be waiting in the queue'
            cand -t 'Time limit (walltime) of PBS/Slurm allocations  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --time-limit 'Time limit (walltime) of PBS/Slurm allocations  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand -m 'The maximal number of workers (=nodes) spawned in a single allocation'
            cand --max-workers-per-alloc 'The maximal number of workers (=nodes) spawned in a single allocation'
            cand --max-worker-count 'The maximum number of workers that can be queued/running at any given time in this queue'
            cand -n 'Name of the allocation queue (for debug purposes only)'
            cand --name 'Name of the allocation queue (for debug purposes only)'
            cand --cpus 'The cores assigned to the worker'
            cand --resource 'Resources provided by the worker'
            cand --group 'Sets worker''s group'
            cand --idle-timeout 'Duration after which will an idle worker automatically stop  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --overview-interval 'The period of reporting the overview to the server'
            cand --on-server-lost 'The policy when a connection to a server is lost'
            cand --worker-start-cmd 'A command executed before the start of each worker'
            cand --worker-stop-cmd 'A command executed after the worker terminates'
            cand --worker-time-limit ' Worker''s time limit  Time limit after which workers in the submitted allocations will be stopped. By default, it is set to the time limit of the allocation. However, if you want the workers to be stopped sooner, for example to give `worker_stop_cmd` more time to execute before the allocation is killed, you can lower the worker time limit.  The limit must not be larger than the allocation time limit.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --min-utilization 'Minimal expected utilization required to submit an allocation into this queue'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --no-detect-resources 'Disables auto-detection of resources'
            cand --no-hyper-threading 'Ignores hyper-threading while detecting CPU cores'
            cand --no-dry-run 'Disables verifying the parameter correctness via dry-run'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;dry-run;slurm'= {
            cand -b 'The maximal number of jobs that can be waiting in the queue'
            cand --backlog 'The maximal number of jobs that can be waiting in the queue'
            cand -t 'Time limit (walltime) of PBS/Slurm allocations  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --time-limit 'Time limit (walltime) of PBS/Slurm allocations  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand -m 'The maximal number of workers (=nodes) spawned in a single allocation'
            cand --max-workers-per-alloc 'The maximal number of workers (=nodes) spawned in a single allocation'
            cand --max-worker-count 'The maximum number of workers that can be queued/running at any given time in this queue'
            cand -n 'Name of the allocation queue (for debug purposes only)'
            cand --name 'Name of the allocation queue (for debug purposes only)'
            cand --cpus 'The cores assigned to the worker'
            cand --resource 'Resources provided by the worker'
            cand --group 'Sets worker''s group'
            cand --idle-timeout 'Duration after which will an idle worker automatically stop  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --overview-interval 'The period of reporting the overview to the server'
            cand --on-server-lost 'The policy when a connection to a server is lost'
            cand --worker-start-cmd 'A command executed before the start of each worker'
            cand --worker-stop-cmd 'A command executed after the worker terminates'
            cand --worker-time-limit ' Worker''s time limit  Time limit after which workers in the submitted allocations will be stopped. By default, it is set to the time limit of the allocation. However, if you want the workers to be stopped sooner, for example to give `worker_stop_cmd` more time to execute before the allocation is killed, you can lower the worker time limit.  The limit must not be larger than the allocation time limit.  You can use either the `HH:MM:SS` format or a "humantime" format. For example: - 01:00:00 => 1 hour - 02:05:10 => 2 hours, 5 minutes, 10 seconds - 1h => 1 hour - 2h5m10s => 2 hours, 5 minutes, 10 seconds - 3h 10m 5s => 3 hours, 10 minutes, 5 seconds - 2 hours 5 minutes => 2 hours, 5 minutes'
            cand --min-utilization 'Minimal expected utilization required to submit an allocation into this queue'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --no-detect-resources 'Disables auto-detection of resources'
            cand --no-hyper-threading 'Ignores hyper-threading while detecting CPU cores'
            cand --no-dry-run 'Disables verifying the parameter correctness via dry-run'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;alloc;remove'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --force 'Remove the queue even if there are currently running jobs'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;journal'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand export 'Export events from a journal file'
            cand stream 'Replays all events from the start of the server, then streams new events'
            cand replay 'Replays all events from the start of the server, then terminate'
            cand prune 'Prune a journal of a running server'
            cand flush 'Forces a running server to flush its journal to the disk'
        }
        &'hq;journal;export'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;journal;stream'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;journal;replay'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;journal;prune'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;journal;flush'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;data'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand put 'Inside a task, put a data object into the local datanode'
            cand get 'Inside a task, get an input data object into the local datanode'
        }
        &'hq;data;put'= {
            cand --mime-type 'DataId of task output'
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;data;get'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;dashboard'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand stream 'Streams events from a server'
            cand replay 'Replays events from a journal file'
        }
        &'hq;dashboard;stream'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;dashboard;replay'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
            cand job 'Submitting and examining tasks and jobs'
            cand jobs 'Submitting and examining tasks and jobs'
            cand tasks 'Submitting and examining tasks and jobs'
            cand taskarray 'Jobs containing large amounts of similar tasks'
            cand resources 'CPU and generic resources of tasks'
            cand worker 'Deployment of workers'
            cand workers 'Deployment of workers'
            cand autoalloc 'Automatic allocator subsystem'
            cand pbs 'Automatic allocator subsystem'
            cand slurm 'Automatic allocator subsystem'
            cand python-api 'Python API'
            cand python 'Python API'
            cand cheatsheet 'Cheatsheet with the most common HyperQueue commands'
            cand changelog 'Changelog'
            cand faq 'Frequently asked questions about HyperQueue'
        }
        &'hq;doc;job'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;jobs'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;tasks'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;taskarray'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;resources'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;worker'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;workers'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;autoalloc'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;pbs'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;slurm'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;python-api'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;python'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;cheatsheet'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;changelog'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;doc;faq'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --open 'Open the documentation in the default browser'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
        &'hq;generate-completion'= {
            cand --server-dir 'The path where access files are stored'
            cand --colors 'Sets console color policy'
            cand --output-mode 'Sets output formatting'
            cand --debug 'Enables more detailed log output'
            cand -h 'Print help (see more with ''--help'')'
            cand --help 'Print help (see more with ''--help'')'
        }
    ]
    $completions[$command]
}
