/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.FileDialog;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import sun.awt.AWTAccessor;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XToolkit;

class GtkFileDialogPeer
extends XDialogPeer
implements FileDialogPeer {
    private FileDialog fd;
    private volatile long widget = 0L;

    public GtkFileDialogPeer(FileDialog fd) {
        super(fd);
        this.fd = fd;
    }

    private static native void initIDs();

    private native void run(String var1, int var2, String var3, String var4, FilenameFilter var5, boolean var6, int var7, int var8);

    private native void quit();

    @Override
    public native void toFront();

    @Override
    public native void setBounds(int var1, int var2, int var3, int var4, int var5);

    private void setFileInternal(String directory, String[] filenames) {
        AWTAccessor.FileDialogAccessor accessor = AWTAccessor.getFileDialogAccessor();
        if (filenames == null) {
            accessor.setDirectory(this.fd, null);
            accessor.setFile(this.fd, null);
            accessor.setFiles(this.fd, null);
        } else {
            String with_separator = directory;
            if (directory != null) {
                with_separator = directory.endsWith(File.separator) ? directory : directory + File.separator;
            }
            accessor.setDirectory(this.fd, with_separator);
            accessor.setFile(this.fd, filenames[0]);
            int filesNumber = filenames != null ? filenames.length : 0;
            File[] files = new File[filesNumber];
            for (int i = 0; i < filesNumber; ++i) {
                files[i] = new File(directory, filenames[i]);
            }
            accessor.setFiles(this.fd, files);
        }
    }

    private boolean filenameFilterCallback(String fullname) {
        if (this.fd.getFilenameFilter() == null) {
            return true;
        }
        File filen = new File(fullname);
        return this.fd.getFilenameFilter().accept(new File(filen.getParent()), filen.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean b) {
        XToolkit.awtLock();
        try {
            if (b) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        GtkFileDialogPeer.this.showNativeDialog();
                        GtkFileDialogPeer.this.fd.setVisible(false);
                    }
                };
                t.start();
            } else {
                this.quit();
                this.fd.setVisible(false);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public void dispose() {
        this.quit();
        super.dispose();
    }

    @Override
    public void setDirectory(String dir) {
    }

    @Override
    public void setFile(String file) {
    }

    @Override
    public void setFilenameFilter(FilenameFilter filter) {
    }

    private void showNativeDialog() {
        String dirname = this.fd.getDirectory();
        String filename = this.fd.getFile();
        if (filename != null) {
            File file = new File(filename);
            if (this.fd.getMode() == 0 && dirname != null && file.getParent() == null) {
                filename = dirname + (dirname.endsWith(File.separator) ? "" : File.separator) + filename;
            }
            if (this.fd.getMode() == 1 && file.getParent() != null) {
                filename = file.getName();
                dirname = file.getParent();
            }
        }
        this.run(this.fd.getTitle(), this.fd.getMode(), dirname, filename, this.fd.getFilenameFilter(), this.fd.isMultipleMode(), this.fd.getX(), this.fd.getY());
    }

    static {
        GtkFileDialogPeer.initIDs();
    }
}

