/*
  *
  * This file is a part of Libcsys.
  * Library for getting system resource information in real time.
  * Copyright 2019 CuboCore Group
  *
  *
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU General Public License as published by
  * the Free Software Foundation; either version 3 of the License, or
  * (at your option) any later version.
  *
  *
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  * GNU General Public License for more details.
  *
  *
  *
  * You should have received a copy of the GNU General Public License
  * along with this program; if not, vsit http://www.gnu.org/licenses/.
  *
  */


#pragma once

#include "libcsys_global.h"

const QString PROC_MEMINFO = "/proc/meminfo";

class LIBCSYSSHARED_EXPORT MemoryInfo {
public:
	explicit MemoryInfo();

	void updateMemoryInfo();

	quint64 getMemTotal() const;
	quint64 getMemFree() const;
	quint64 getMemUsed() const;

	quint64 getSwapTotal() const;
	quint64 getSwapFree() const;
	quint64 getSwapUsed() const;

private:
	// memory
	quint64 memTotal;
	quint64 memFree;
	quint64 memUsed;
	quint64 buffers;
	quint64 cached;
	quint64 sreclaimable;
	quint64 shmem;

	// swap
	quint64 swapTotal;
	quint64 swapFree;
	quint64 swapUsed;
};
