/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.xsom.impl.parser;

import com.sun.xml.xsom.impl.SchemaImpl;
import com.sun.xml.xsom.parser.SchemaDocument;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class SchemaDocumentImpl
implements SchemaDocument {
    private final SchemaImpl schema;
    private final String schemaDocumentURI;
    final Set<SchemaDocumentImpl> references = new HashSet<SchemaDocumentImpl>();
    final Set<SchemaDocumentImpl> referers = new HashSet<SchemaDocumentImpl>();

    protected SchemaDocumentImpl(SchemaImpl schema, String _schemaDocumentURI) {
        this.schema = schema;
        this.schemaDocumentURI = _schemaDocumentURI;
    }

    @Override
    public String getSystemId() {
        return this.schemaDocumentURI;
    }

    @Override
    public String getTargetNamespace() {
        return this.schema.getTargetNamespace();
    }

    @Override
    public SchemaImpl getSchema() {
        return this.schema;
    }

    @Override
    public Set<SchemaDocument> getReferencedDocuments() {
        return Collections.unmodifiableSet(this.references);
    }

    @Override
    public Set<SchemaDocument> getIncludedDocuments() {
        return this.getImportedDocuments(this.getTargetNamespace());
    }

    @Override
    public Set<SchemaDocument> getImportedDocuments(String targetNamespace) {
        if (targetNamespace == null) {
            throw new IllegalArgumentException();
        }
        HashSet<SchemaDocumentImpl> r = new HashSet<SchemaDocumentImpl>();
        for (SchemaDocumentImpl doc : this.references) {
            if (!doc.getTargetNamespace().equals(targetNamespace)) continue;
            r.add(doc);
        }
        return Collections.unmodifiableSet(r);
    }

    @Override
    public boolean includes(SchemaDocument doc) {
        if (!this.references.contains(doc)) {
            return false;
        }
        return doc.getSchema() == this.schema;
    }

    @Override
    public boolean imports(SchemaDocument doc) {
        if (!this.references.contains(doc)) {
            return false;
        }
        return doc.getSchema() != this.schema;
    }

    @Override
    public Set<SchemaDocument> getReferers() {
        return Collections.unmodifiableSet(this.referers);
    }

    public boolean equals(Object o) {
        SchemaDocumentImpl rhs = (SchemaDocumentImpl)o;
        if (this.schemaDocumentURI == null || rhs.schemaDocumentURI == null) {
            return this == rhs;
        }
        if (!this.schemaDocumentURI.equals(rhs.schemaDocumentURI)) {
            return false;
        }
        return this.schema == rhs.schema;
    }

    public int hashCode() {
        if (this.schemaDocumentURI == null) {
            return super.hashCode();
        }
        if (this.schema == null) {
            return this.schemaDocumentURI.hashCode();
        }
        return this.schemaDocumentURI.hashCode() ^ this.schema.hashCode();
    }
}

