/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport;

import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.Version;
import org.opensearch.common.lease.Releasable;
import org.opensearch.core.transport.TransportResponse;
import org.opensearch.search.query.QuerySearchResult;
import org.opensearch.transport.BaseTcpTransportChannel;
import org.opensearch.transport.ProtocolOutboundHandler;
import org.opensearch.transport.TcpChannel;

public final class TcpTransportChannel
extends BaseTcpTransportChannel {
    private final AtomicBoolean released = new AtomicBoolean();
    private final ProtocolOutboundHandler outboundHandler;
    private final String action;
    private final long requestId;
    private final Version version;
    private final Set<String> features;
    private final boolean compressResponse;
    private final boolean isHandshake;
    private final Releasable breakerRelease;
    private Exception releaseBy;

    TcpTransportChannel(ProtocolOutboundHandler outboundHandler, TcpChannel channel, String action, long requestId, Version version, Set<String> features, boolean compressResponse, boolean isHandshake, Releasable breakerRelease) {
        super(channel);
        this.version = version;
        this.features = features;
        this.outboundHandler = outboundHandler;
        this.action = action;
        this.requestId = requestId;
        this.compressResponse = compressResponse;
        this.isHandshake = isHandshake;
        this.breakerRelease = breakerRelease;
    }

    @Override
    public String getProfileName() {
        return this.getChannel().getProfile();
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        try {
            if (response instanceof QuerySearchResult && ((QuerySearchResult)response).getShardSearchRequest() != null) {
                ((QuerySearchResult)response).getShardSearchRequest().setOutboundNetworkTime(System.currentTimeMillis());
            }
            this.outboundHandler.sendResponse(this.version, this.features, this.getChannel(), this.requestId, this.action, response, this.compressResponse, this.isHandshake);
        }
        finally {
            this.release(false);
        }
    }

    @Override
    public void sendResponse(Exception exception) throws IOException {
        try {
            this.outboundHandler.sendErrorResponse(this.version, this.features, this.getChannel(), this.requestId, this.action, exception);
        }
        finally {
            this.release(true);
        }
    }

    private void release(boolean isExceptionResponse) {
        if (this.released.compareAndSet(false, true)) {
            assert ((this.releaseBy = new Exception()) != null);
            this.breakerRelease.close();
        } else if (!isExceptionResponse) {
            throw new IllegalStateException("reserved bytes are already released", this.releaseBy);
        }
    }

    @Override
    public String getChannelType() {
        return "transport";
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public <T> Optional<T> get(String name, Class<T> clazz) {
        return this.getChannel().get(name, clazz);
    }
}

