/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyCapacityReservationFleetRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyCapacityReservationFleetRequest> {
    private static final SdkField<String> CAPACITY_RESERVATION_FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CapacityReservationFleetId").getter(ModifyCapacityReservationFleetRequest.getter(ModifyCapacityReservationFleetRequest::capacityReservationFleetId)).setter(ModifyCapacityReservationFleetRequest.setter(Builder::capacityReservationFleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationFleetId").unmarshallLocationName("CapacityReservationFleetId").build()}).build();
    private static final SdkField<Integer> TOTAL_TARGET_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalTargetCapacity").getter(ModifyCapacityReservationFleetRequest.getter(ModifyCapacityReservationFleetRequest::totalTargetCapacity)).setter(ModifyCapacityReservationFleetRequest.setter(Builder::totalTargetCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalTargetCapacity").unmarshallLocationName("TotalTargetCapacity").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndDate").getter(ModifyCapacityReservationFleetRequest.getter(ModifyCapacityReservationFleetRequest::endDate)).setter(ModifyCapacityReservationFleetRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").unmarshallLocationName("EndDate").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(ModifyCapacityReservationFleetRequest.getter(ModifyCapacityReservationFleetRequest::dryRun)).setter(ModifyCapacityReservationFleetRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<Boolean> REMOVE_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RemoveEndDate").getter(ModifyCapacityReservationFleetRequest.getter(ModifyCapacityReservationFleetRequest::removeEndDate)).setter(ModifyCapacityReservationFleetRequest.setter(Builder::removeEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveEndDate").unmarshallLocationName("RemoveEndDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_FLEET_ID_FIELD, TOTAL_TARGET_CAPACITY_FIELD, END_DATE_FIELD, DRY_RUN_FIELD, REMOVE_END_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyCapacityReservationFleetRequest.memberNameToFieldInitializer();
    private final String capacityReservationFleetId;
    private final Integer totalTargetCapacity;
    private final Instant endDate;
    private final Boolean dryRun;
    private final Boolean removeEndDate;

    private ModifyCapacityReservationFleetRequest(BuilderImpl builder) {
        super(builder);
        this.capacityReservationFleetId = builder.capacityReservationFleetId;
        this.totalTargetCapacity = builder.totalTargetCapacity;
        this.endDate = builder.endDate;
        this.dryRun = builder.dryRun;
        this.removeEndDate = builder.removeEndDate;
    }

    public final String capacityReservationFleetId() {
        return this.capacityReservationFleetId;
    }

    public final Integer totalTargetCapacity() {
        return this.totalTargetCapacity;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final Boolean removeEndDate() {
        return this.removeEndDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityReservationFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalTargetCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeEndDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyCapacityReservationFleetRequest)) {
            return false;
        }
        ModifyCapacityReservationFleetRequest other = (ModifyCapacityReservationFleetRequest)((Object)obj);
        return Objects.equals(this.capacityReservationFleetId(), other.capacityReservationFleetId()) && Objects.equals(this.totalTargetCapacity(), other.totalTargetCapacity()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.removeEndDate(), other.removeEndDate());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyCapacityReservationFleetRequest").add("CapacityReservationFleetId", (Object)this.capacityReservationFleetId()).add("TotalTargetCapacity", (Object)this.totalTargetCapacity()).add("EndDate", (Object)this.endDate()).add("DryRun", (Object)this.dryRun()).add("RemoveEndDate", (Object)this.removeEndDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityReservationFleetId": {
                return Optional.ofNullable(clazz.cast(this.capacityReservationFleetId()));
            }
            case "TotalTargetCapacity": {
                return Optional.ofNullable(clazz.cast(this.totalTargetCapacity()));
            }
            case "EndDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "RemoveEndDate": {
                return Optional.ofNullable(clazz.cast(this.removeEndDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityReservationFleetId", CAPACITY_RESERVATION_FLEET_ID_FIELD);
        map.put("TotalTargetCapacity", TOTAL_TARGET_CAPACITY_FIELD);
        map.put("EndDate", END_DATE_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("RemoveEndDate", REMOVE_END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyCapacityReservationFleetRequest, T> g) {
        return obj -> g.apply((ModifyCapacityReservationFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String capacityReservationFleetId;
        private Integer totalTargetCapacity;
        private Instant endDate;
        private Boolean dryRun;
        private Boolean removeEndDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyCapacityReservationFleetRequest model) {
            super(model);
            this.capacityReservationFleetId(model.capacityReservationFleetId);
            this.totalTargetCapacity(model.totalTargetCapacity);
            this.endDate(model.endDate);
            this.dryRun(model.dryRun);
            this.removeEndDate(model.removeEndDate);
        }

        public final String getCapacityReservationFleetId() {
            return this.capacityReservationFleetId;
        }

        public final void setCapacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
        }

        @Override
        public final Builder capacityReservationFleetId(String capacityReservationFleetId) {
            this.capacityReservationFleetId = capacityReservationFleetId;
            return this;
        }

        public final Integer getTotalTargetCapacity() {
            return this.totalTargetCapacity;
        }

        public final void setTotalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
        }

        @Override
        public final Builder totalTargetCapacity(Integer totalTargetCapacity) {
            this.totalTargetCapacity = totalTargetCapacity;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final Boolean getRemoveEndDate() {
            return this.removeEndDate;
        }

        public final void setRemoveEndDate(Boolean removeEndDate) {
            this.removeEndDate = removeEndDate;
        }

        @Override
        public final Builder removeEndDate(Boolean removeEndDate) {
            this.removeEndDate = removeEndDate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyCapacityReservationFleetRequest build() {
            return new ModifyCapacityReservationFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyCapacityReservationFleetRequest> {
        public Builder capacityReservationFleetId(String var1);

        public Builder totalTargetCapacity(Integer var1);

        public Builder endDate(Instant var1);

        public Builder dryRun(Boolean var1);

        public Builder removeEndDate(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

