/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.profile;

import java.io.IOException;
import java.util.List;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.action.profile.MLProfileNodeResponse;

public class MLProfileResponse
extends BaseNodesResponse<MLProfileNodeResponse>
implements ToXContentObject {
    public MLProfileResponse(StreamInput in) throws IOException {
        super(new ClusterName(in), in.readList(MLProfileNodeResponse::readProfile), in.readList(FailedNodeException::new));
    }

    public MLProfileResponse(ClusterName clusterName, List<MLProfileNodeResponse> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
    }

    public void writeNodesTo(StreamOutput out, List<MLProfileNodeResponse> nodes) throws IOException {
        out.writeList(nodes);
    }

    public List<MLProfileNodeResponse> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(MLProfileNodeResponse::readProfile);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (MLProfileNodeResponse nodeResponse : this.getNodes()) {
            DiscoveryNode node = nodeResponse.getNode();
            String nodeId = node.getId();
            builder.startObject(nodeId);
            nodeResponse.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }
}

