/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.notifications.model.EventSource;
import org.opensearch.commons.notifications.model.EventStatus;
import org.opensearch.commons.notifications.model.NotificationEvent;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.XContentHelpersKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentHelper;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J#\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lorg/opensearch/commons/notifications/model/NotificationEvent;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "eventSource", "Lorg/opensearch/commons/notifications/model/EventSource;", "statusList", "", "Lorg/opensearch/commons/notifications/model/EventStatus;", "(Lorg/opensearch/commons/notifications/model/EventSource;Ljava/util/List;)V", "getEventSource", "()Lorg/opensearch/commons/notifications/model/EventSource;", "getStatusList", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nNotificationEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationEvent.kt\norg/opensearch/commons/notifications/model/NotificationEvent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class NotificationEvent
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventSource eventSource;
    @NotNull
    private final List<EventStatus> statusList;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(NotificationEvent.class);
    @NotNull
    private static final Writeable.Reader<NotificationEvent> reader = NotificationEvent::reader$lambda$1;

    public NotificationEvent(@NotNull EventSource eventSource, @NotNull List<EventStatus> statusList) {
        Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
        Intrinsics.checkNotNullParameter(statusList, (String)"statusList");
        this.eventSource = eventSource;
        this.statusList = statusList;
        if (!(!((Collection)this.statusList).isEmpty())) {
            boolean bl = false;
            String string = "statusList is null or empty";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ NotificationEvent(EventSource eventSource, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(eventSource, list);
    }

    @NotNull
    public final EventSource getEventSource() {
        return this.eventSource;
    }

    @NotNull
    public final List<EventStatus> getStatusList() {
        return this.statusList;
    }

    public NotificationEvent(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Object object = EventSource.Companion.getReader().read(input);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"EventSource.reader.read(input)");
        EventSource eventSource = (EventSource)object;
        List list = input.readList(EventStatus.Companion.getReader());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"input.readList(EventStatus.reader)");
        this(eventSource, list);
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.eventSource.writeTo(output);
        output.writeList(this.statusList);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("event_source", (ToXContent)this.eventSource).field("status_list", (Iterable)this.statusList).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder;
    }

    @NotNull
    public String toString() {
        Object object;
        try {
            String string = XContentHelper.toXContent((ToXContent)((ToXContent)this), (MediaType)((MediaType)XContentType.JSON), (ToXContent.Params)ToXContent.EMPTY_PARAMS, (boolean)true).utf8ToString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"{\n            XContentHe\u2026.utf8ToString()\n        }");
            object = string;
        }
        catch (IOException e) {
            NotificationEvent.Companion.getLog().debug("Failed to convert NotificationEvent to string", (Throwable)e);
            object = super.toString() + " threw " + e;
        }
        return object;
    }

    @NotNull
    public final EventSource component1() {
        return this.eventSource;
    }

    @NotNull
    public final List<EventStatus> component2() {
        return this.statusList;
    }

    @NotNull
    public final NotificationEvent copy(@NotNull EventSource eventSource, @NotNull List<EventStatus> statusList) {
        Intrinsics.checkNotNullParameter((Object)eventSource, (String)"eventSource");
        Intrinsics.checkNotNullParameter(statusList, (String)"statusList");
        return new NotificationEvent(eventSource, statusList);
    }

    public static /* synthetic */ NotificationEvent copy$default(NotificationEvent notificationEvent, EventSource eventSource, List list, int n, Object object) {
        if ((n & 1) != 0) {
            eventSource = notificationEvent.eventSource;
        }
        if ((n & 2) != 0) {
            list = notificationEvent.statusList;
        }
        return notificationEvent.copy(eventSource, list);
    }

    public int hashCode() {
        int result = this.eventSource.hashCode();
        result = result * 31 + ((Object)this.statusList).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotificationEvent)) {
            return false;
        }
        NotificationEvent notificationEvent = (NotificationEvent)other;
        if (!Intrinsics.areEqual((Object)this.eventSource, (Object)notificationEvent.eventSource)) {
            return false;
        }
        return Intrinsics.areEqual(this.statusList, notificationEvent.statusList);
    }

    private static final NotificationEvent reader$lambda$1(StreamInput it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return new NotificationEvent(it);
    }

    @JvmStatic
    @NotNull
    public static final NotificationEvent parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001f\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/commons/notifications/model/NotificationEvent$Companion;", "", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/NotificationEvent;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<NotificationEvent> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final NotificationEvent parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            EventSource eventSource = null;
            List statusList = CollectionsKt.emptyList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = parser.currentName();
                parser.nextToken();
                String string = fieldName;
                if (Intrinsics.areEqual((Object)string, (Object)"event_source")) {
                    eventSource = EventSource.Companion.parse(parser);
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"status_list")) {
                    statusList = XContentHelpersKt.objectList(parser, parse.1.INSTANCE);
                    continue;
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing notification event");
            }
            if (eventSource == null) {
                throw new IllegalArgumentException("event_source field absent");
            }
            if (statusList.isEmpty()) {
                throw new IllegalArgumentException("status_list field absent or empty");
            }
            return new NotificationEvent(eventSource, statusList);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

