/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.auditlog.sink;

import java.io.IOException;
import java.nio.file.Path;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.opensearch.client.Client;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.auditlog.impl.AuditMessage;
import org.opensearch.security.auditlog.sink.AbstractInternalOpenSearchSink;
import org.opensearch.security.auditlog.sink.AuditLogSink;
import org.opensearch.threadpool.ThreadPool;

public final class InternalOpenSearchSink
extends AbstractInternalOpenSearchSink {
    final String index;
    final String type;
    private DateTimeFormatter indexPattern;

    public InternalOpenSearchSink(String name, Settings settings, String settingsPrefix, Path configPath, Client clientProvider, ThreadPool threadPool, AuditLogSink fallbackSink) {
        super(name, settings, settingsPrefix, clientProvider, threadPool, fallbackSink, null);
        Settings sinkSettings = this.getSinkSettings(settingsPrefix);
        this.index = sinkSettings.get("index", "'security-auditlog-'YYYY.MM.dd");
        this.type = sinkSettings.get("type", null);
        try {
            this.indexPattern = DateTimeFormat.forPattern((String)this.index);
        }
        catch (IllegalArgumentException e) {
            this.log.debug("Unable to parse index pattern due to {}. If you have no date pattern configured you can safely ignore this message", (Object)e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public boolean doStore(AuditMessage msg) {
        return super.doStore(msg, this.getExpandedIndexName(this.indexPattern, this.index));
    }
}

