/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mindmap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.mindmap.IdeaShape;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.MergeStrategy;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

class Idea {
    private final Display label;
    private final int level;
    private final Idea parent;
    private final List<Idea> children = new ArrayList<Idea>();
    private final IdeaShape shape;
    private final HColor backColor;
    private final StyleBuilder styleBuilder;
    private final Stereotype stereotype;
    private static final int STEP_BY_PARENT = 10001000;

    private StyleSignatureBasic getDefaultStyleDefinitionNode(int level) {
        String depth = SName.depth(level);
        if (level == 0) {
            if (this.shape == IdeaShape.NONE) {
                return StyleSignatureBasic.of(SName.root, SName.element, SName.mindmapDiagram, SName.node, SName.rootNode, SName.boxless).addS(this.stereotype).add(depth);
            }
            return StyleSignatureBasic.of(SName.root, SName.element, SName.mindmapDiagram, SName.node, SName.rootNode).addS(this.stereotype).add(depth);
        }
        if (this.shape == IdeaShape.NONE && this.children.size() == 0) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.mindmapDiagram, SName.node, SName.leafNode, SName.boxless).addS(this.stereotype).add(depth);
        }
        if (this.shape == IdeaShape.NONE) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.mindmapDiagram, SName.node, SName.boxless).addS(this.stereotype).add(depth);
        }
        if (this.children.size() == 0) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.mindmapDiagram, SName.node, SName.leafNode).addS(this.stereotype).add(depth);
        }
        return StyleSignatureBasic.of(SName.root, SName.element, SName.mindmapDiagram, SName.node).addS(this.stereotype).add(depth);
    }

    public Style getStyle() {
        int deltaPriority = 1411065408;
        Style result = this.styleBuilder.getMergedStyleSpecial(this.getDefaultStyleDefinitionNode(this.level), deltaPriority);
        Idea up = this.parent;
        while (up != null) {
            StyleSignatureBasic ss = up.getDefaultStyleDefinitionNode(this.level).addStar();
            Style styleParent = this.styleBuilder.getMergedStyleSpecial(ss, deltaPriority -= 10001000);
            result = result.mergeWith(styleParent, MergeStrategy.OVERWRITE_EXISTING_VALUE);
            up = up.parent;
        }
        return result;
    }

    public Style getStyleArrow() {
        String depth = SName.depth(this.level);
        StyleSignatureBasic defaultStyleDefinitionArrow = StyleSignatureBasic.of(SName.root, SName.element, SName.mindmapDiagram, SName.arrow).addS(this.stereotype).add(depth);
        return defaultStyleDefinitionArrow.getMergedStyle(this.styleBuilder);
    }

    public static Idea createIdeaSimple(StyleBuilder styleBuilder, HColor backColor, Display label, IdeaShape shape, Stereotype stereotype) {
        return new Idea(styleBuilder, backColor, 0, null, label, shape, stereotype);
    }

    public Idea createIdea(StyleBuilder styleBuilder, HColor backColor, int newLevel, Display newDisplay, IdeaShape newShape, Stereotype stereotype) {
        Idea result = new Idea(styleBuilder, backColor, newLevel, this, newDisplay, newShape, stereotype);
        this.children.add(result);
        return result;
    }

    private Idea(StyleBuilder styleBuilder, HColor backColor, int level, Idea parent, Display label, IdeaShape shape, Stereotype stereotype) {
        this.backColor = backColor;
        this.styleBuilder = styleBuilder;
        this.label = label;
        this.level = level;
        this.parent = parent;
        this.shape = shape;
        this.stereotype = stereotype;
    }

    public String toString() {
        return this.label.toString();
    }

    public final int getLevel() {
        return this.level;
    }

    public final Display getLabel() {
        return this.label;
    }

    public Collection<Idea> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public Idea getParent() {
        return this.parent;
    }

    public final IdeaShape getShape() {
        return this.shape;
    }

    public final HColor getBackColor() {
        return this.backColor;
    }

    public final StyleBuilder getStyleBuilder() {
        return this.styleBuilder;
    }

    public final Stereotype getStereotype1() {
        return this.stereotype;
    }
}

