/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import java.util.List;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UPixel;
import net.sourceforge.plantuml.salt.element.AbstractElement;

public class ElementImage
extends AbstractElement {
    private final List<String> img;

    public ElementImage(List<String> img) {
        this.img = img;
    }

    @Override
    public XDimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        return new XDimension2D(this.img.get(0).length(), this.img.size());
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, XDimension2D dimToUse) {
        if (zIndex != 0) {
            return;
        }
        ug = ug.apply(this.getBlack());
        int w = this.img.get(0).length();
        int h2 = this.img.size();
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h2; ++j) {
                char c = this.img.get(j).charAt(i);
                if (c != 'X') continue;
                ug.apply(new UTranslate(i, j)).draw(new UPixel());
            }
        }
    }
}

