/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.util;

import java.awt.Window;
import java.util.stream.Stream;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.protege.editor.owl.model.util.LowMemoryNotificationView;

public class LowMemoryNotificationViewImpl
implements LowMemoryNotificationView {
    private static final String TITLE = "Low Memory";
    private static final String MSG = "<html><body><b>The memory available to Prot\u00e9g\u00e9 is running low<br><br>Free memory: %d MB</b>&nbsp;&nbsp;&nbsp;&nbsp;(Memory limit: %d MB)<br><br>This may cause Prot\u00e9g\u00e9 to freeze and become unresponsive</body></html>";

    public static void main(String[] args) {
        LowMemoryNotificationViewImpl i = new LowMemoryNotificationViewImpl();
        i.displayLowMemoryNotification();
    }

    @Override
    public void displayLowMemoryNotification() {
        Window parent = Stream.of(Window.getOwnerlessWindows()).filter(w -> w instanceof JFrame).findFirst().orElse(null);
        Runtime runtime = Runtime.getRuntime();
        long availableMemory = runtime.maxMemory() - runtime.totalMemory();
        long availableMemoryInMb = availableMemory / 1024L / 1024L;
        long maxMemory = runtime.maxMemory();
        long maxMemoryInMb = maxMemory / 1024L / 1024L;
        String formattedMsg = String.format(MSG, availableMemoryInMb, maxMemoryInMb);
        JOptionPane.showMessageDialog(parent, formattedMsg, TITLE, 2);
    }
}

