/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.WhitePoint;
import com.github.ajalt.colormath.internal.InternalMathKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSLuv;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LABKt;
import com.github.ajalt.colormath.model.LCHabColorSpace;
import com.github.ajalt.colormath.model.LCHabColorSpaces;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 (2\u00020\u0001:\u0001(B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0000H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\t\u0010$\u001a\u00020%H\u00d6\u0001J\b\u0010&\u001a\u00020'H\u0016R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/github/ajalt/colormath/model/LCHab;", "Lcom/github/ajalt/colormath/HueColor;", "l", "", "c", "h", "alpha", "space", "Lcom/github/ajalt/colormath/model/LCHabColorSpace;", "(FFFFLcom/github/ajalt/colormath/model/LCHabColorSpace;)V", "getAlpha", "()F", "getC", "getH", "getL", "getSpace", "()Lcom/github/ajalt/colormath/model/LCHabColorSpace;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "", "hashCode", "", "toArray", "", "toLAB", "Lcom/github/ajalt/colormath/model/LAB;", "toLCHab", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toString", "", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "Companion", "colormath"})
public final class LCHab
implements HueColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float l;
    private final float c;
    private final float h;
    private final float alpha;
    @NotNull
    private final LCHabColorSpace space;

    public LCHab(float l, float c, float h, float alpha, @NotNull LCHabColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        this.l = l;
        this.c = c;
        this.h = h;
        this.alpha = alpha;
        this.space = space;
    }

    public final float getL() {
        return this.l;
    }

    public final float getC() {
        return this.c;
    }

    @Override
    public float getH() {
        return this.h;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    @NotNull
    public LCHabColorSpace getSpace() {
        return this.space;
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        return this.toLAB().toSRGB();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return this.toLAB().toXYZ();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public LAB toLAB() {
        void b;
        void b$iv;
        void c$iv;
        float f = this.c;
        float h$iv = this.getH();
        boolean $i$f$fromPolarModel = false;
        float hDegrees$iv = Float.isNaN(h$iv) ? 0.0f : InternalMathKt.degToRad(h$iv);
        void a$iv = c$iv * (float)Math.cos(hDegrees$iv);
        void var7_7 = b$iv = c$iv * (float)Math.sin(hDegrees$iv);
        void a = a$iv;
        boolean bl = false;
        return LABKt.LABColorSpace(this.getSpace().getWhitePoint()).invoke(this.l, (float)a, (float)b, this.getAlpha());
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.l, this.c, this.getH(), this.getAlpha()};
        return fArray;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return HueColor.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return HueColor.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return HueColor.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return HueColor.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return HueColor.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return HueColor.DefaultImpls.toLUV(this);
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        return HueColor.DefaultImpls.toLCHuv(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return HueColor.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return HueColor.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return HueColor.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return HueColor.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return HueColor.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return HueColor.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return HueColor.DefaultImpls.toHSLuv(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return HueColor.DefaultImpls.toHPLuv(this);
    }

    public final float component1() {
        return this.l;
    }

    public final float component2() {
        return this.c;
    }

    public final float component3() {
        return this.getH();
    }

    public final float component4() {
        return this.getAlpha();
    }

    @NotNull
    public final LCHabColorSpace component5() {
        return this.getSpace();
    }

    @NotNull
    public final LCHab copy(float l, float c, float h, float alpha, @NotNull LCHabColorSpace space) {
        Intrinsics.checkNotNullParameter(space, "space");
        return new LCHab(l, c, h, alpha, space);
    }

    public static /* synthetic */ LCHab copy$default(LCHab lCHab, float f, float f2, float f3, float f4, LCHabColorSpace lCHabColorSpace, int n, Object object) {
        if ((n & 1) != 0) {
            f = lCHab.l;
        }
        if ((n & 2) != 0) {
            f2 = lCHab.c;
        }
        if ((n & 4) != 0) {
            f3 = lCHab.getH();
        }
        if ((n & 8) != 0) {
            f4 = lCHab.getAlpha();
        }
        if ((n & 0x10) != 0) {
            lCHabColorSpace = lCHab.getSpace();
        }
        return lCHab.copy(f, f2, f3, f4, lCHabColorSpace);
    }

    @NotNull
    public String toString() {
        return "LCHab(l=" + this.l + ", c=" + this.c + ", h=" + this.getH() + ", alpha=" + this.getAlpha() + ", space=" + this.getSpace() + ')';
    }

    public int hashCode() {
        int result = Float.hashCode(this.l);
        result = result * 31 + Float.hashCode(this.c);
        result = result * 31 + Float.hashCode(this.getH());
        result = result * 31 + Float.hashCode(this.getAlpha());
        result = result * 31 + this.getSpace().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LCHab)) {
            return false;
        }
        LCHab lCHab = (LCHab)other;
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.l), (Object)Float.valueOf(lCHab.l))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.c), (Object)Float.valueOf(lCHab.c))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.getH()), (Object)Float.valueOf(lCHab.getH()))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.getAlpha()), (Object)Float.valueOf(lCHab.getAlpha()))) {
            return false;
        }
        return Intrinsics.areEqual(this.getSpace(), lCHab.getSpace());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0001J\u0011\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0015H\u0096\u0001J+\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u0018H\u0096\u0003J+\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u001c2\b\b\u0002\u0010\u001b\u001a\u00020\u001cH\u0096\u0003R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/github/ajalt/colormath/model/LCHab$Companion;", "Lcom/github/ajalt/colormath/model/LCHabColorSpace;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "whitePoint", "Lcom/github/ajalt/colormath/WhitePoint;", "getWhitePoint", "()Lcom/github/ajalt/colormath/WhitePoint;", "convert", "Lcom/github/ajalt/colormath/model/LCHab;", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "invoke", "l", "", "c", "h", "alpha", "", "colormath"})
    public static final class Companion
    implements LCHabColorSpace {
        private final /* synthetic */ LCHabColorSpace $$delegate_0;

        private Companion() {
            this.$$delegate_0 = LCHabColorSpaces.INSTANCE.getLCHab65();
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return this.$$delegate_0.getComponents();
        }

        @Override
        @NotNull
        public String getName() {
            return this.$$delegate_0.getName();
        }

        @Override
        @NotNull
        public WhitePoint getWhitePoint() {
            return this.$$delegate_0.getWhitePoint();
        }

        @Override
        @NotNull
        public LCHab convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return (LCHab)this.$$delegate_0.convert(color);
        }

        @Override
        @NotNull
        public LCHab create(@NotNull float[] components) {
            Intrinsics.checkNotNullParameter(components, "components");
            return (LCHab)this.$$delegate_0.create(components);
        }

        @Override
        @NotNull
        public LCHab invoke(float l, float c, float h, float alpha) {
            return this.$$delegate_0.invoke(l, c, h, alpha);
        }

        @Override
        @NotNull
        public LCHab invoke(@NotNull Number l, @NotNull Number c, @NotNull Number h, @NotNull Number alpha) {
            Intrinsics.checkNotNullParameter(l, "l");
            Intrinsics.checkNotNullParameter(c, "c");
            Intrinsics.checkNotNullParameter(h, "h");
            Intrinsics.checkNotNullParameter(alpha, "alpha");
            return this.$$delegate_0.invoke(l, c, h, alpha);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

