/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.EventListener;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import org.openide.util.WeakListenerImpl;

public final class WeakListeners {
    private WeakListeners() {
    }

    public static <T extends EventListener> T create(Class<T> clazz, T t, Object object) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Not interface: " + clazz);
        }
        return WeakListenerImpl.create(clazz, clazz, t, object);
    }

    public static <T extends EventListener> T create(Class<T> clazz, Class<? super T> clazz2, T t, Object object) {
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException("Not interface: " + clazz);
        }
        if (!clazz2.isInterface()) {
            throw new IllegalArgumentException("Not interface: " + clazz2);
        }
        if (!clazz2.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz2 + " has to be assignableFrom " + clazz);
        }
        return WeakListenerImpl.create(clazz, clazz2, t, object);
    }

    public static PropertyChangeListener propertyChange(PropertyChangeListener propertyChangeListener, Object object) {
        WeakListenerImpl.PropertyChange propertyChange = new WeakListenerImpl.PropertyChange(propertyChangeListener);
        propertyChange.setSource(object);
        return propertyChange;
    }

    public static PropertyChangeListener propertyChange(PropertyChangeListener propertyChangeListener, String string, Object object) {
        WeakListenerImpl.PropertyChange propertyChange = new WeakListenerImpl.PropertyChange(propertyChangeListener, string);
        propertyChange.setSource(object);
        return propertyChange;
    }

    public static VetoableChangeListener vetoableChange(VetoableChangeListener vetoableChangeListener, Object object) {
        WeakListenerImpl.VetoableChange vetoableChange = new WeakListenerImpl.VetoableChange(vetoableChangeListener);
        vetoableChange.setSource(object);
        return vetoableChange;
    }

    public static VetoableChangeListener vetoableChange(VetoableChangeListener vetoableChangeListener, String string, Object object) {
        WeakListenerImpl.VetoableChange vetoableChange = new WeakListenerImpl.VetoableChange(vetoableChangeListener, string);
        vetoableChange.setSource(object);
        return vetoableChange;
    }

    public static DocumentListener document(DocumentListener documentListener, Object object) {
        WeakListenerImpl.Document document = new WeakListenerImpl.Document(documentListener);
        document.setSource(object);
        return document;
    }

    public static ChangeListener change(ChangeListener changeListener, Object object) {
        WeakListenerImpl.Change change = new WeakListenerImpl.Change(changeListener);
        change.setSource(object);
        return change;
    }
}

