# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._data_box_edge_management_client_enums import *


class ARMBaseModel(msrest.serialization.Model):
    """Represents the base class for all object models.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ARMBaseModel, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Addon(ARMBaseModel):
    """Role Addon.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ArcAddon, IoTAddon.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Addon type.Constant filled by server.  Possible values include:
     "IotEdge", "ArcForKubernetes".
    :type kind: str or ~azure.mgmt.databoxedge.v2020_09_01.models.AddonType
    :ivar system_data: Addon type.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    _subtype_map = {
        'kind': {'ArcForKubernetes': 'ArcAddon', 'IotEdge': 'IoTAddon'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Addon, self).__init__(**kwargs)
        self.kind = 'Addon'  # type: str
        self.system_data = None


class AddonList(msrest.serialization.Model):
    """Collection of all the Role addon on the Azure Stack Edge device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The Value.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.Addon]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Addon]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AddonList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Address(msrest.serialization.Model):
    """The shipping address of the customer.

    All required parameters must be populated in order to send to Azure.

    :param address_line1: The address line1.
    :type address_line1: str
    :param address_line2: The address line2.
    :type address_line2: str
    :param address_line3: The address line3.
    :type address_line3: str
    :param postal_code: The postal code.
    :type postal_code: str
    :param city: The city name.
    :type city: str
    :param state: The state name.
    :type state: str
    :param country: Required. The country name.
    :type country: str
    """

    _validation = {
        'country': {'required': True},
    }

    _attribute_map = {
        'address_line1': {'key': 'addressLine1', 'type': 'str'},
        'address_line2': {'key': 'addressLine2', 'type': 'str'},
        'address_line3': {'key': 'addressLine3', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        country: str,
        address_line1: Optional[str] = None,
        address_line2: Optional[str] = None,
        address_line3: Optional[str] = None,
        postal_code: Optional[str] = None,
        city: Optional[str] = None,
        state: Optional[str] = None,
        **kwargs
    ):
        super(Address, self).__init__(**kwargs)
        self.address_line1 = address_line1
        self.address_line2 = address_line2
        self.address_line3 = address_line3
        self.postal_code = postal_code
        self.city = city
        self.state = state
        self.country = country


class Alert(ARMBaseModel):
    """Alert on the data box edge/gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Alert generated in the resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :ivar title: Alert title.
    :vartype title: str
    :ivar alert_type: Alert type.
    :vartype alert_type: str
    :ivar appeared_at_date_time: UTC time when the alert appeared.
    :vartype appeared_at_date_time: ~datetime.datetime
    :ivar recommendation: Alert recommendation.
    :vartype recommendation: str
    :ivar severity: Severity of the alert. Possible values include: "Informational", "Warning",
     "Critical".
    :vartype severity: str or ~azure.mgmt.databoxedge.v2020_09_01.models.AlertSeverity
    :ivar error_details: Error details of the alert.
    :vartype error_details: ~azure.mgmt.databoxedge.v2020_09_01.models.AlertErrorDetails
    :ivar detailed_information: Alert details.
    :vartype detailed_information: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'title': {'readonly': True},
        'alert_type': {'readonly': True},
        'appeared_at_date_time': {'readonly': True},
        'recommendation': {'readonly': True},
        'severity': {'readonly': True},
        'error_details': {'readonly': True},
        'detailed_information': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'title': {'key': 'properties.title', 'type': 'str'},
        'alert_type': {'key': 'properties.alertType', 'type': 'str'},
        'appeared_at_date_time': {'key': 'properties.appearedAtDateTime', 'type': 'iso-8601'},
        'recommendation': {'key': 'properties.recommendation', 'type': 'str'},
        'severity': {'key': 'properties.severity', 'type': 'str'},
        'error_details': {'key': 'properties.errorDetails', 'type': 'AlertErrorDetails'},
        'detailed_information': {'key': 'properties.detailedInformation', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Alert, self).__init__(**kwargs)
        self.system_data = None
        self.title = None
        self.alert_type = None
        self.appeared_at_date_time = None
        self.recommendation = None
        self.severity = None
        self.error_details = None
        self.detailed_information = None


class AlertErrorDetails(msrest.serialization.Model):
    """Error details for the alert.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: Error code.
    :vartype error_code: str
    :ivar error_message: Error Message.
    :vartype error_message: str
    :ivar occurrences: Number of occurrences.
    :vartype occurrences: int
    """

    _validation = {
        'error_code': {'readonly': True},
        'error_message': {'readonly': True},
        'occurrences': {'readonly': True},
    }

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'str'},
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'occurrences': {'key': 'occurrences', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertErrorDetails, self).__init__(**kwargs)
        self.error_code = None
        self.error_message = None
        self.occurrences = None


class AlertList(msrest.serialization.Model):
    """Collection of alerts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The value.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.Alert]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Alert]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ArcAddon(Addon):
    """Arc Addon.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Addon type.Constant filled by server.  Possible values include:
     "IotEdge", "ArcForKubernetes".
    :type kind: str or ~azure.mgmt.databoxedge.v2020_09_01.models.AddonType
    :ivar system_data: Addon type.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param subscription_id: Required. Arc resource subscription Id.
    :type subscription_id: str
    :param resource_group_name: Required. Arc resource group name.
    :type resource_group_name: str
    :param resource_name: Required. Arc resource Name.
    :type resource_name: str
    :param resource_location: Required. Arc resource location.
    :type resource_location: str
    :ivar version: Arc resource version.
    :vartype version: str
    :ivar host_platform: Host OS supported by the Arc addon. Possible values include: "Windows",
     "Linux".
    :vartype host_platform: str or ~azure.mgmt.databoxedge.v2020_09_01.models.PlatformType
    :ivar host_platform_type: Platform where the runtime is hosted. Possible values include:
     "KubernetesCluster", "LinuxVM".
    :vartype host_platform_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.HostPlatformType
    :ivar provisioning_state: Addon Provisioning State. Possible values include: "Invalid",
     "Creating", "Created", "Updating", "Reconfiguring", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.databoxedge.v2020_09_01.models.AddonState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
        'subscription_id': {'required': True},
        'resource_group_name': {'required': True},
        'resource_name': {'required': True},
        'resource_location': {'required': True},
        'version': {'readonly': True},
        'host_platform': {'readonly': True},
        'host_platform_type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'subscription_id': {'key': 'properties.subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'properties.resourceGroupName', 'type': 'str'},
        'resource_name': {'key': 'properties.resourceName', 'type': 'str'},
        'resource_location': {'key': 'properties.resourceLocation', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'host_platform': {'key': 'properties.hostPlatform', 'type': 'str'},
        'host_platform_type': {'key': 'properties.hostPlatformType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        subscription_id: str,
        resource_group_name: str,
        resource_name: str,
        resource_location: str,
        **kwargs
    ):
        super(ArcAddon, self).__init__(**kwargs)
        self.kind = 'ArcForKubernetes'  # type: str
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.resource_name = resource_name
        self.resource_location = resource_location
        self.version = None
        self.host_platform = None
        self.host_platform_type = None
        self.provisioning_state = None


class AsymmetricEncryptedSecret(msrest.serialization.Model):
    """Represent the secrets intended for encryption with asymmetric key pair.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The value of the secret.
    :type value: str
    :param encryption_cert_thumbprint: Thumbprint certificate used to encrypt \"Value\". If the
     value is unencrypted, it will be null.
    :type encryption_cert_thumbprint: str
    :param encryption_algorithm: Required. The algorithm used to encrypt "Value". Possible values
     include: "None", "AES256", "RSAES_PKCS1_v_1_5".
    :type encryption_algorithm: str or
     ~azure.mgmt.databoxedge.v2020_09_01.models.EncryptionAlgorithm
    """

    _validation = {
        'value': {'required': True},
        'encryption_algorithm': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'encryption_cert_thumbprint': {'key': 'encryptionCertThumbprint', 'type': 'str'},
        'encryption_algorithm': {'key': 'encryptionAlgorithm', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: str,
        encryption_algorithm: Union[str, "EncryptionAlgorithm"],
        encryption_cert_thumbprint: Optional[str] = None,
        **kwargs
    ):
        super(AsymmetricEncryptedSecret, self).__init__(**kwargs)
        self.value = value
        self.encryption_cert_thumbprint = encryption_cert_thumbprint
        self.encryption_algorithm = encryption_algorithm


class Authentication(msrest.serialization.Model):
    """Authentication mechanism for IoT devices.

    :param symmetric_key: Symmetric key for authentication.
    :type symmetric_key: ~azure.mgmt.databoxedge.v2020_09_01.models.SymmetricKey
    """

    _attribute_map = {
        'symmetric_key': {'key': 'symmetricKey', 'type': 'SymmetricKey'},
    }

    def __init__(
        self,
        *,
        symmetric_key: Optional["SymmetricKey"] = None,
        **kwargs
    ):
        super(Authentication, self).__init__(**kwargs)
        self.symmetric_key = symmetric_key


class AzureContainerInfo(msrest.serialization.Model):
    """Azure container mapping of the endpoint.

    All required parameters must be populated in order to send to Azure.

    :param storage_account_credential_id: Required. ID of the storage account credential used to
     access storage.
    :type storage_account_credential_id: str
    :param container_name: Required. Container name (Based on the data format specified, this
     represents the name of Azure Files/Page blob/Block blob).
    :type container_name: str
    :param data_format: Required. Storage format used for the file represented by the share.
     Possible values include: "BlockBlob", "PageBlob", "AzureFile".
    :type data_format: str or ~azure.mgmt.databoxedge.v2020_09_01.models.AzureContainerDataFormat
    """

    _validation = {
        'storage_account_credential_id': {'required': True},
        'container_name': {'required': True},
        'data_format': {'required': True},
    }

    _attribute_map = {
        'storage_account_credential_id': {'key': 'storageAccountCredentialId', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'data_format': {'key': 'dataFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_account_credential_id: str,
        container_name: str,
        data_format: Union[str, "AzureContainerDataFormat"],
        **kwargs
    ):
        super(AzureContainerInfo, self).__init__(**kwargs)
        self.storage_account_credential_id = storage_account_credential_id
        self.container_name = container_name
        self.data_format = data_format


class BandwidthSchedule(ARMBaseModel):
    """The bandwidth schedule details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Bandwidth object related to ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param start: Required. The start time of the schedule in UTC.
    :type start: str
    :param stop: Required. The stop time of the schedule in UTC.
    :type stop: str
    :param rate_in_mbps: Required. The bandwidth rate in Mbps.
    :type rate_in_mbps: int
    :param days: Required. The days of the week when this schedule is applicable.
    :type days: list[str or ~azure.mgmt.databoxedge.v2020_09_01.models.DayOfWeek]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'start': {'required': True},
        'stop': {'required': True},
        'rate_in_mbps': {'required': True},
        'days': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'start': {'key': 'properties.start', 'type': 'str'},
        'stop': {'key': 'properties.stop', 'type': 'str'},
        'rate_in_mbps': {'key': 'properties.rateInMbps', 'type': 'int'},
        'days': {'key': 'properties.days', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        start: str,
        stop: str,
        rate_in_mbps: int,
        days: List[Union[str, "DayOfWeek"]],
        **kwargs
    ):
        super(BandwidthSchedule, self).__init__(**kwargs)
        self.system_data = None
        self.start = start
        self.stop = stop
        self.rate_in_mbps = rate_in_mbps
        self.days = days


class BandwidthSchedulesList(msrest.serialization.Model):
    """The collection of bandwidth schedules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of bandwidth schedules.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.BandwidthSchedule]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BandwidthSchedule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BandwidthSchedulesList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ClientAccessRight(msrest.serialization.Model):
    """The mapping between a particular client IP and the type of access client has on the NFS share.

    All required parameters must be populated in order to send to Azure.

    :param client: Required. IP of the client.
    :type client: str
    :param access_permission: Required. Type of access to be allowed for the client. Possible
     values include: "NoAccess", "ReadOnly", "ReadWrite".
    :type access_permission: str or ~azure.mgmt.databoxedge.v2020_09_01.models.ClientPermissionType
    """

    _validation = {
        'client': {'required': True},
        'access_permission': {'required': True},
    }

    _attribute_map = {
        'client': {'key': 'client', 'type': 'str'},
        'access_permission': {'key': 'accessPermission', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client: str,
        access_permission: Union[str, "ClientPermissionType"],
        **kwargs
    ):
        super(ClientAccessRight, self).__init__(**kwargs)
        self.client = client
        self.access_permission = access_permission


class Role(ARMBaseModel):
    """Compute role.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CloudEdgeManagementRole, IoTRole, KubernetesRole, MECRole.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Role type.Constant filled by server.  Possible values include: "IOT",
     "ASA", "Functions", "Cognitive", "MEC", "CloudEdgeManagement", "Kubernetes".
    :type kind: str or ~azure.mgmt.databoxedge.v2020_09_01.models.RoleTypes
    :ivar system_data: Role configured on ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    _subtype_map = {
        'kind': {'CloudEdgeManagement': 'CloudEdgeManagementRole', 'IOT': 'IoTRole', 'Kubernetes': 'KubernetesRole', 'MEC': 'MECRole'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Role, self).__init__(**kwargs)
        self.kind = 'Role'  # type: str
        self.system_data = None


class CloudEdgeManagementRole(Role):
    """CloudEdgeManagementRole role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Role type.Constant filled by server.  Possible values include: "IOT",
     "ASA", "Functions", "Cognitive", "MEC", "CloudEdgeManagement", "Kubernetes".
    :type kind: str or ~azure.mgmt.databoxedge.v2020_09_01.models.RoleTypes
    :ivar system_data: Role configured on ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :ivar local_management_status: Local Edge Management Status. Possible values include:
     "Enabled", "Disabled".
    :vartype local_management_status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.RoleStatus
    :ivar edge_profile: Edge Profile of the resource.
    :vartype edge_profile: ~azure.mgmt.databoxedge.v2020_09_01.models.EdgeProfile
    :param role_status: Role status. Possible values include: "Enabled", "Disabled".
    :type role_status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.RoleStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
        'local_management_status': {'readonly': True},
        'edge_profile': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'local_management_status': {'key': 'properties.localManagementStatus', 'type': 'str'},
        'edge_profile': {'key': 'properties.edgeProfile', 'type': 'EdgeProfile'},
        'role_status': {'key': 'properties.roleStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        role_status: Optional[Union[str, "RoleStatus"]] = None,
        **kwargs
    ):
        super(CloudEdgeManagementRole, self).__init__(**kwargs)
        self.kind = 'CloudEdgeManagement'  # type: str
        self.local_management_status = None
        self.edge_profile = None
        self.role_status = role_status


class CloudErrorBody(msrest.serialization.Model):
    """An error response from the service.

    :param code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable for display in a user
     interface.
    :type message: str
    :param details: A list of additional details about the error.
    :type details: list[~azure.mgmt.databoxedge.v2020_09_01.models.CloudErrorBody]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[CloudErrorBody]'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["CloudErrorBody"]] = None,
        **kwargs
    ):
        super(CloudErrorBody, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class CniConfig(msrest.serialization.Model):
    """Cni configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Cni type.
    :vartype type: str
    :ivar version: Cni version.
    :vartype version: str
    :ivar pod_subnet: Pod Subnet.
    :vartype pod_subnet: str
    :ivar service_subnet: Service subnet.
    :vartype service_subnet: str
    """

    _validation = {
        'type': {'readonly': True},
        'version': {'readonly': True},
        'pod_subnet': {'readonly': True},
        'service_subnet': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'pod_subnet': {'key': 'podSubnet', 'type': 'str'},
        'service_subnet': {'key': 'serviceSubnet', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CniConfig, self).__init__(**kwargs)
        self.type = None
        self.version = None
        self.pod_subnet = None
        self.service_subnet = None


class ComputeResource(msrest.serialization.Model):
    """Compute infrastructure Resource.

    All required parameters must be populated in order to send to Azure.

    :param processor_count: Required. Processor count.
    :type processor_count: int
    :param memory_in_gb: Required. Memory in GB.
    :type memory_in_gb: long
    """

    _validation = {
        'processor_count': {'required': True},
        'memory_in_gb': {'required': True},
    }

    _attribute_map = {
        'processor_count': {'key': 'processorCount', 'type': 'int'},
        'memory_in_gb': {'key': 'memoryInGB', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        processor_count: int,
        memory_in_gb: int,
        **kwargs
    ):
        super(ComputeResource, self).__init__(**kwargs)
        self.processor_count = processor_count
        self.memory_in_gb = memory_in_gb


class ContactDetails(msrest.serialization.Model):
    """Contains all the contact details of the customer.

    All required parameters must be populated in order to send to Azure.

    :param contact_person: Required. The contact person name.
    :type contact_person: str
    :param company_name: Required. The name of the company.
    :type company_name: str
    :param phone: Required. The phone number.
    :type phone: str
    :param email_list: Required. The email list.
    :type email_list: list[str]
    """

    _validation = {
        'contact_person': {'required': True},
        'company_name': {'required': True},
        'phone': {'required': True},
        'email_list': {'required': True},
    }

    _attribute_map = {
        'contact_person': {'key': 'contactPerson', 'type': 'str'},
        'company_name': {'key': 'companyName', 'type': 'str'},
        'phone': {'key': 'phone', 'type': 'str'},
        'email_list': {'key': 'emailList', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        contact_person: str,
        company_name: str,
        phone: str,
        email_list: List[str],
        **kwargs
    ):
        super(ContactDetails, self).__init__(**kwargs)
        self.contact_person = contact_person
        self.company_name = company_name
        self.phone = phone
        self.email_list = email_list


class Container(ARMBaseModel):
    """Represents a container on the  Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Container in DataBoxEdge Resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :ivar container_status: Current status of the container. Possible values include: "OK",
     "Offline", "Unknown", "Updating", "NeedsAttention".
    :vartype container_status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.ContainerStatus
    :param data_format: Required. DataFormat for Container. Possible values include: "BlockBlob",
     "PageBlob", "AzureFile".
    :type data_format: str or ~azure.mgmt.databoxedge.v2020_09_01.models.AzureContainerDataFormat
    :ivar refresh_details: Details of the refresh job on this container.
    :vartype refresh_details: ~azure.mgmt.databoxedge.v2020_09_01.models.RefreshDetails
    :ivar created_date_time: The UTC time when container got created.
    :vartype created_date_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'container_status': {'readonly': True},
        'data_format': {'required': True},
        'refresh_details': {'readonly': True},
        'created_date_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'container_status': {'key': 'properties.containerStatus', 'type': 'str'},
        'data_format': {'key': 'properties.dataFormat', 'type': 'str'},
        'refresh_details': {'key': 'properties.refreshDetails', 'type': 'RefreshDetails'},
        'created_date_time': {'key': 'properties.createdDateTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        data_format: Union[str, "AzureContainerDataFormat"],
        **kwargs
    ):
        super(Container, self).__init__(**kwargs)
        self.system_data = None
        self.container_status = None
        self.data_format = data_format
        self.refresh_details = None
        self.created_date_time = None


class ContainerList(msrest.serialization.Model):
    """Collection of all the containers on the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of containers.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.Container]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Container]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ContainerList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DataBoxEdgeDevice(ARMBaseModel):
    """The Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param location: Required. The location of the device. This is a supported and registered Azure
     geographical region (for example, West US, East US, or Southeast Asia). The geographical region
     of a device cannot be changed once it is created, but if an identical geographical region is
     specified on update, the request will succeed.
    :type location: str
    :param tags: A set of tags. The list of tags that describe the device. These tags can be used
     to view and group this device (across resource groups).
    :type tags: dict[str, str]
    :param sku: The SKU type.
    :type sku: ~azure.mgmt.databoxedge.v2020_09_01.models.Sku
    :param etag: The etag for the devices.
    :type etag: str
    :param identity: Msi identity of the resource.
    :type identity: ~azure.mgmt.databoxedge.v2020_09_01.models.ResourceIdentity
    :ivar kind: The etag for the devices. Possible values include: "AzureDataBoxGateway",
     "AzureStackEdge", "AzureStackHub", "AzureModularDataCentre".
    :vartype kind: str or ~azure.mgmt.databoxedge.v2020_09_01.models.DataBoxEdgeDeviceKind
    :ivar system_data: DataBoxEdge Resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param data_box_edge_device_status: The status of the Data Box Edge/Gateway device. Possible
     values include: "ReadyToSetup", "Online", "Offline", "NeedsAttention", "Disconnected",
     "PartiallyDisconnected", "Maintenance".
    :type data_box_edge_device_status: str or
     ~azure.mgmt.databoxedge.v2020_09_01.models.DataBoxEdgeDeviceStatus
    :ivar serial_number: The Serial Number of Data Box Edge/Gateway device.
    :vartype serial_number: str
    :ivar description: The Description of the Data Box Edge/Gateway device.
    :vartype description: str
    :ivar model_description: The description of the Data Box Edge/Gateway device model.
    :vartype model_description: str
    :ivar device_type: The type of the Data Box Edge/Gateway device. Possible values include:
     "DataBoxEdgeDevice".
    :vartype device_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.DeviceType
    :ivar friendly_name: The Data Box Edge/Gateway device name.
    :vartype friendly_name: str
    :ivar culture: The Data Box Edge/Gateway device culture.
    :vartype culture: str
    :ivar device_model: The Data Box Edge/Gateway device model.
    :vartype device_model: str
    :ivar device_software_version: The Data Box Edge/Gateway device software version.
    :vartype device_software_version: str
    :ivar device_local_capacity: The Data Box Edge/Gateway device local capacity in MB.
    :vartype device_local_capacity: long
    :ivar time_zone: The Data Box Edge/Gateway device timezone.
    :vartype time_zone: str
    :ivar device_hcs_version: The device software version number of the device (eg: 1.2.18105.6).
    :vartype device_hcs_version: str
    :ivar configured_role_types: Type of compute roles configured.
    :vartype configured_role_types: list[str or
     ~azure.mgmt.databoxedge.v2020_09_01.models.RoleTypes]
    :ivar node_count: The number of nodes in the cluster.
    :vartype node_count: int
    :ivar resource_move_details: The details of the move operation on this resource.
    :vartype resource_move_details: ~azure.mgmt.databoxedge.v2020_09_01.models.ResourceMoveDetails
    :ivar edge_profile: The details of Edge Profile for this resource.
    :vartype edge_profile: ~azure.mgmt.databoxedge.v2020_09_01.models.EdgeProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'kind': {'readonly': True},
        'system_data': {'readonly': True},
        'serial_number': {'readonly': True},
        'description': {'readonly': True},
        'model_description': {'readonly': True},
        'device_type': {'readonly': True},
        'friendly_name': {'readonly': True},
        'culture': {'readonly': True},
        'device_model': {'readonly': True},
        'device_software_version': {'readonly': True},
        'device_local_capacity': {'readonly': True},
        'time_zone': {'readonly': True},
        'device_hcs_version': {'readonly': True},
        'configured_role_types': {'readonly': True},
        'node_count': {'readonly': True},
        'resource_move_details': {'readonly': True},
        'edge_profile': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'etag': {'key': 'etag', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'data_box_edge_device_status': {'key': 'properties.dataBoxEdgeDeviceStatus', 'type': 'str'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'model_description': {'key': 'properties.modelDescription', 'type': 'str'},
        'device_type': {'key': 'properties.deviceType', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'culture': {'key': 'properties.culture', 'type': 'str'},
        'device_model': {'key': 'properties.deviceModel', 'type': 'str'},
        'device_software_version': {'key': 'properties.deviceSoftwareVersion', 'type': 'str'},
        'device_local_capacity': {'key': 'properties.deviceLocalCapacity', 'type': 'long'},
        'time_zone': {'key': 'properties.timeZone', 'type': 'str'},
        'device_hcs_version': {'key': 'properties.deviceHcsVersion', 'type': 'str'},
        'configured_role_types': {'key': 'properties.configuredRoleTypes', 'type': '[str]'},
        'node_count': {'key': 'properties.nodeCount', 'type': 'int'},
        'resource_move_details': {'key': 'properties.resourceMoveDetails', 'type': 'ResourceMoveDetails'},
        'edge_profile': {'key': 'properties.edgeProfile', 'type': 'EdgeProfile'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        etag: Optional[str] = None,
        identity: Optional["ResourceIdentity"] = None,
        data_box_edge_device_status: Optional[Union[str, "DataBoxEdgeDeviceStatus"]] = None,
        **kwargs
    ):
        super(DataBoxEdgeDevice, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.sku = sku
        self.etag = etag
        self.identity = identity
        self.kind = None
        self.system_data = None
        self.data_box_edge_device_status = data_box_edge_device_status
        self.serial_number = None
        self.description = None
        self.model_description = None
        self.device_type = None
        self.friendly_name = None
        self.culture = None
        self.device_model = None
        self.device_software_version = None
        self.device_local_capacity = None
        self.time_zone = None
        self.device_hcs_version = None
        self.configured_role_types = None
        self.node_count = None
        self.resource_move_details = None
        self.edge_profile = None


class DataBoxEdgeDeviceExtendedInfo(ARMBaseModel):
    """The extended Info of the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param encryption_key_thumbprint: The digital signature of encrypted certificate.
    :type encryption_key_thumbprint: str
    :param encryption_key: The public part of the encryption certificate. Client uses this to
     encrypt any secret.
    :type encryption_key: str
    :ivar resource_key: The Resource ID of the Resource.
    :vartype resource_key: str
    :param client_secret_store_id: The Key Vault ARM Id for client secrets.
    :type client_secret_store_id: str
    :param client_secret_store_url: The url to access the Client Key Vault.
    :type client_secret_store_url: str
    :param channel_integrity_key_name: The name of Channel Integrity Key stored in the Client Key
     Vault.
    :type channel_integrity_key_name: str
    :param channel_integrity_key_version: The version of Channel Integrity Key stored in the Client
     Key Vault.
    :type channel_integrity_key_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_key': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'encryption_key_thumbprint': {'key': 'properties.encryptionKeyThumbprint', 'type': 'str'},
        'encryption_key': {'key': 'properties.encryptionKey', 'type': 'str'},
        'resource_key': {'key': 'properties.resourceKey', 'type': 'str'},
        'client_secret_store_id': {'key': 'properties.clientSecretStoreId', 'type': 'str'},
        'client_secret_store_url': {'key': 'properties.clientSecretStoreUrl', 'type': 'str'},
        'channel_integrity_key_name': {'key': 'properties.channelIntegrityKeyName', 'type': 'str'},
        'channel_integrity_key_version': {'key': 'properties.channelIntegrityKeyVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        encryption_key_thumbprint: Optional[str] = None,
        encryption_key: Optional[str] = None,
        client_secret_store_id: Optional[str] = None,
        client_secret_store_url: Optional[str] = None,
        channel_integrity_key_name: Optional[str] = None,
        channel_integrity_key_version: Optional[str] = None,
        **kwargs
    ):
        super(DataBoxEdgeDeviceExtendedInfo, self).__init__(**kwargs)
        self.encryption_key_thumbprint = encryption_key_thumbprint
        self.encryption_key = encryption_key
        self.resource_key = None
        self.client_secret_store_id = client_secret_store_id
        self.client_secret_store_url = client_secret_store_url
        self.channel_integrity_key_name = channel_integrity_key_name
        self.channel_integrity_key_version = channel_integrity_key_version


class DataBoxEdgeDeviceExtendedInfoPatch(msrest.serialization.Model):
    """The Data Box Edge/Gateway device extended info patch.

    :param client_secret_store_id: The Key Vault ARM Id for client secrets.
    :type client_secret_store_id: str
    :param client_secret_store_url: The url to access the Client Key Vault.
    :type client_secret_store_url: str
    :param channel_integrity_key_name: The name for Channel Integrity Key stored in the Client Key
     Vault.
    :type channel_integrity_key_name: str
    :param channel_integrity_key_version: The version of Channel Integrity Key stored in the Client
     Key Vault.
    :type channel_integrity_key_version: str
    """

    _attribute_map = {
        'client_secret_store_id': {'key': 'clientSecretStoreId', 'type': 'str'},
        'client_secret_store_url': {'key': 'clientSecretStoreUrl', 'type': 'str'},
        'channel_integrity_key_name': {'key': 'channelIntegrityKeyName', 'type': 'str'},
        'channel_integrity_key_version': {'key': 'channelIntegrityKeyVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        client_secret_store_id: Optional[str] = None,
        client_secret_store_url: Optional[str] = None,
        channel_integrity_key_name: Optional[str] = None,
        channel_integrity_key_version: Optional[str] = None,
        **kwargs
    ):
        super(DataBoxEdgeDeviceExtendedInfoPatch, self).__init__(**kwargs)
        self.client_secret_store_id = client_secret_store_id
        self.client_secret_store_url = client_secret_store_url
        self.channel_integrity_key_name = channel_integrity_key_name
        self.channel_integrity_key_version = channel_integrity_key_version


class DataBoxEdgeDeviceList(msrest.serialization.Model):
    """The collection of Data Box Edge/Gateway devices.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Data Box Edge/Gateway devices.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.DataBoxEdgeDevice]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataBoxEdgeDevice]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxEdgeDeviceList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DataBoxEdgeDevicePatch(msrest.serialization.Model):
    """The Data Box Edge/Gateway device patch.

    :param tags: A set of tags. The tags attached to the Data Box Edge/Gateway resource.
    :type tags: dict[str, str]
    :param identity: Msi identity of the resource.
    :type identity: ~azure.mgmt.databoxedge.v2020_09_01.models.ResourceIdentity
    :param edge_profile: Edge Profile property of the Data Box Edge/Gateway device.
    :type edge_profile: ~azure.mgmt.databoxedge.v2020_09_01.models.EdgeProfilePatch
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'identity': {'key': 'identity', 'type': 'ResourceIdentity'},
        'edge_profile': {'key': 'properties.edgeProfile', 'type': 'EdgeProfilePatch'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["ResourceIdentity"] = None,
        edge_profile: Optional["EdgeProfilePatch"] = None,
        **kwargs
    ):
        super(DataBoxEdgeDevicePatch, self).__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.edge_profile = edge_profile


class DataBoxEdgeMoveRequest(msrest.serialization.Model):
    """Resource Move details.

    All required parameters must be populated in order to send to Azure.

    :param target_resource_group: Required. Target resource group ARMId.
    :type target_resource_group: str
    :param resources: Required. List of resources to be moved.
    :type resources: list[str]
    """

    _validation = {
        'target_resource_group': {'required': True},
        'resources': {'required': True},
    }

    _attribute_map = {
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'resources': {'key': 'resources', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        target_resource_group: str,
        resources: List[str],
        **kwargs
    ):
        super(DataBoxEdgeMoveRequest, self).__init__(**kwargs)
        self.target_resource_group = target_resource_group
        self.resources = resources


class DataBoxEdgeSku(msrest.serialization.Model):
    """The Sku information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :ivar name: The Sku name. Possible values include: "Gateway", "Edge", "TEA_1Node",
     "TEA_1Node_UPS", "TEA_1Node_Heater", "TEA_1Node_UPS_Heater", "TEA_4Node_Heater",
     "TEA_4Node_UPS_Heater", "TMA", "TDC", "TCA_Small", "GPU", "TCA_Large", "EdgeP_Base",
     "EdgeP_High", "EdgePR_Base", "EdgePR_Base_UPS", "EdgeMR_Mini", "RCA_Small", "RCA_Large", "RDC".
    :vartype name: str or ~azure.mgmt.databoxedge.v2020_09_01.models.SkuName
    :ivar kind: The Sku kind.
    :vartype kind: str
    :ivar tier: The Sku tier. Possible values include: "Standard".
    :vartype tier: str or ~azure.mgmt.databoxedge.v2020_09_01.models.SkuTier
    :ivar size: The Sku kind.
    :vartype size: str
    :ivar family: The Sku family.
    :vartype family: str
    :ivar locations: Availability of the Sku for the region.
    :vartype locations: list[str]
    :ivar api_versions: The API versions in which Sku is available.
    :vartype api_versions: list[str]
    :ivar location_info: Availability of the Sku for the location/zone/site.
    :vartype location_info: list[~azure.mgmt.databoxedge.v2020_09_01.models.SkuLocationInfo]
    :ivar costs: The pricing info of the Sku.
    :vartype costs: list[~azure.mgmt.databoxedge.v2020_09_01.models.SkuCost]
    :ivar signup_option: Sku can be signed up by customer or not. Possible values include: "None",
     "Available".
    :vartype signup_option: str or ~azure.mgmt.databoxedge.v2020_09_01.models.SkuSignupOption
    :ivar version: Availability of the Sku as preview/stable. Possible values include: "Stable",
     "Preview".
    :vartype version: str or ~azure.mgmt.databoxedge.v2020_09_01.models.SkuVersion
    :ivar availability: Links to the next set of results. Possible values include: "Available",
     "Unavailable".
    :vartype availability: str or ~azure.mgmt.databoxedge.v2020_09_01.models.SkuAvailability
    :ivar shipment_types: List of Shipment Types supported by this SKU.
    :vartype shipment_types: list[str or ~azure.mgmt.databoxedge.v2020_09_01.models.ShipmentType]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'name': {'readonly': True},
        'kind': {'readonly': True},
        'tier': {'readonly': True},
        'size': {'readonly': True},
        'family': {'readonly': True},
        'locations': {'readonly': True},
        'api_versions': {'readonly': True},
        'location_info': {'readonly': True},
        'costs': {'readonly': True},
        'signup_option': {'readonly': True},
        'version': {'readonly': True},
        'availability': {'readonly': True},
        'shipment_types': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'api_versions': {'key': 'apiVersions', 'type': '[str]'},
        'location_info': {'key': 'locationInfo', 'type': '[SkuLocationInfo]'},
        'costs': {'key': 'costs', 'type': '[SkuCost]'},
        'signup_option': {'key': 'signupOption', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'availability': {'key': 'availability', 'type': 'str'},
        'shipment_types': {'key': 'shipmentTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxEdgeSku, self).__init__(**kwargs)
        self.resource_type = None
        self.name = None
        self.kind = None
        self.tier = None
        self.size = None
        self.family = None
        self.locations = None
        self.api_versions = None
        self.location_info = None
        self.costs = None
        self.signup_option = None
        self.version = None
        self.availability = None
        self.shipment_types = None


class DataBoxEdgeSkuList(msrest.serialization.Model):
    """List of SKU Information objects.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of ResourceType Sku.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.DataBoxEdgeSku]
    :ivar next_link: Links to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataBoxEdgeSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataBoxEdgeSkuList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class DCAccessCode(msrest.serialization.Model):
    """DC Access code in the case of Self Managed Shipping.

    :param auth_code: DCAccess Code for the Self Managed shipment.
    :type auth_code: str
    """

    _attribute_map = {
        'auth_code': {'key': 'properties.authCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auth_code: Optional[str] = None,
        **kwargs
    ):
        super(DCAccessCode, self).__init__(**kwargs)
        self.auth_code = auth_code


class EdgeProfile(msrest.serialization.Model):
    """Details about Edge Profile for the resource.

    :param subscription: Edge Profile Subscription.
    :type subscription: ~azure.mgmt.databoxedge.v2020_09_01.models.EdgeProfileSubscription
    """

    _attribute_map = {
        'subscription': {'key': 'subscription', 'type': 'EdgeProfileSubscription'},
    }

    def __init__(
        self,
        *,
        subscription: Optional["EdgeProfileSubscription"] = None,
        **kwargs
    ):
        super(EdgeProfile, self).__init__(**kwargs)
        self.subscription = subscription


class EdgeProfilePatch(msrest.serialization.Model):
    """The Data Box Edge/Gateway Edge Profile patch.

    :param subscription: The Data Box Edge/Gateway Edge Profile Subscription patch.
    :type subscription: ~azure.mgmt.databoxedge.v2020_09_01.models.EdgeProfileSubscriptionPatch
    """

    _attribute_map = {
        'subscription': {'key': 'subscription', 'type': 'EdgeProfileSubscriptionPatch'},
    }

    def __init__(
        self,
        *,
        subscription: Optional["EdgeProfileSubscriptionPatch"] = None,
        **kwargs
    ):
        super(EdgeProfilePatch, self).__init__(**kwargs)
        self.subscription = subscription


class EdgeProfileSubscription(msrest.serialization.Model):
    """Subscription details for the Edge Profile.

    :param registration_id: Edge Subscription Registration ID.
    :type registration_id: str
    :param id: ARM ID of the subscription.
    :type id: str
    :param state:  Possible values include: "Registered", "Warned", "Suspended", "Deleted",
     "Unregistered".
    :type state: str or ~azure.mgmt.databoxedge.v2020_09_01.models.SubscriptionState
    :param registration_date:
    :type registration_date: str
    :param subscription_id:
    :type subscription_id: str
    :param tenant_id:
    :type tenant_id: str
    :param location_placement_id:
    :type location_placement_id: str
    :param quota_id:
    :type quota_id: str
    :param serialized_details:
    :type serialized_details: str
    :param registered_features:
    :type registered_features:
     list[~azure.mgmt.databoxedge.v2020_09_01.models.SubscriptionRegisteredFeatures]
    """

    _attribute_map = {
        'registration_id': {'key': 'registrationId', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'registration_date': {'key': 'registrationDate', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'tenant_id': {'key': 'properties.tenantId', 'type': 'str'},
        'location_placement_id': {'key': 'properties.locationPlacementId', 'type': 'str'},
        'quota_id': {'key': 'properties.quotaId', 'type': 'str'},
        'serialized_details': {'key': 'properties.serializedDetails', 'type': 'str'},
        'registered_features': {'key': 'properties.registeredFeatures', 'type': '[SubscriptionRegisteredFeatures]'},
    }

    def __init__(
        self,
        *,
        registration_id: Optional[str] = None,
        id: Optional[str] = None,
        state: Optional[Union[str, "SubscriptionState"]] = None,
        registration_date: Optional[str] = None,
        subscription_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        location_placement_id: Optional[str] = None,
        quota_id: Optional[str] = None,
        serialized_details: Optional[str] = None,
        registered_features: Optional[List["SubscriptionRegisteredFeatures"]] = None,
        **kwargs
    ):
        super(EdgeProfileSubscription, self).__init__(**kwargs)
        self.registration_id = registration_id
        self.id = id
        self.state = state
        self.registration_date = registration_date
        self.subscription_id = subscription_id
        self.tenant_id = tenant_id
        self.location_placement_id = location_placement_id
        self.quota_id = quota_id
        self.serialized_details = serialized_details
        self.registered_features = registered_features


class EdgeProfileSubscriptionPatch(msrest.serialization.Model):
    """The Data Box Edge/Gateway Edge Profile Subscription patch.

    :param id: The path ID that uniquely identifies the subscription of the edge profile.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(EdgeProfileSubscriptionPatch, self).__init__(**kwargs)
        self.id = id


class EtcdInfo(msrest.serialization.Model):
    """Etcd configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Etcd type.
    :vartype type: str
    :ivar version: Etcd version.
    :vartype version: str
    """

    _validation = {
        'type': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EtcdInfo, self).__init__(**kwargs)
        self.type = None
        self.version = None


class Trigger(ARMBaseModel):
    """Trigger details.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FileEventTrigger, PeriodicTimerEventTrigger.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Trigger in DataBoxEdge Resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param kind: Required. Trigger Kind.Constant filled by server.  Possible values include:
     "FileEvent", "PeriodicTimerEvent".
    :type kind: str or ~azure.mgmt.databoxedge.v2020_09_01.models.TriggerEventType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
    }

    _subtype_map = {
        'kind': {'FileEvent': 'FileEventTrigger', 'PeriodicTimerEvent': 'PeriodicTimerEventTrigger'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Trigger, self).__init__(**kwargs)
        self.system_data = None
        self.kind = 'Trigger'  # type: str


class FileEventTrigger(Trigger):
    """Trigger details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Trigger in DataBoxEdge Resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param kind: Required. Trigger Kind.Constant filled by server.  Possible values include:
     "FileEvent", "PeriodicTimerEvent".
    :type kind: str or ~azure.mgmt.databoxedge.v2020_09_01.models.TriggerEventType
    :param source_info: Required. File event source details.
    :type source_info: ~azure.mgmt.databoxedge.v2020_09_01.models.FileSourceInfo
    :param sink_info: Required. Role sink info.
    :type sink_info: ~azure.mgmt.databoxedge.v2020_09_01.models.RoleSinkInfo
    :param custom_context_tag: A custom context tag typically used to correlate the trigger against
     its usage. For example, if a periodic timer trigger is intended for certain specific IoT
     modules in the device, the tag can be the name or the image URL of the module.
    :type custom_context_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'source_info': {'required': True},
        'sink_info': {'required': True},
        'custom_context_tag': {'max_length': 192, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'source_info': {'key': 'properties.sourceInfo', 'type': 'FileSourceInfo'},
        'sink_info': {'key': 'properties.sinkInfo', 'type': 'RoleSinkInfo'},
        'custom_context_tag': {'key': 'properties.customContextTag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_info: "FileSourceInfo",
        sink_info: "RoleSinkInfo",
        custom_context_tag: Optional[str] = None,
        **kwargs
    ):
        super(FileEventTrigger, self).__init__(**kwargs)
        self.kind = 'FileEvent'  # type: str
        self.source_info = source_info
        self.sink_info = sink_info
        self.custom_context_tag = custom_context_tag


class FileSourceInfo(msrest.serialization.Model):
    """File source details.

    All required parameters must be populated in order to send to Azure.

    :param share_id: Required. File share ID.
    :type share_id: str
    """

    _validation = {
        'share_id': {'required': True},
    }

    _attribute_map = {
        'share_id': {'key': 'shareId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        share_id: str,
        **kwargs
    ):
        super(FileSourceInfo, self).__init__(**kwargs)
        self.share_id = share_id


class GenerateCertResponse(msrest.serialization.Model):
    """Used in activation key generation flow.

    :param public_key: Gets or sets base64 encoded certificate raw data,
     this is the public part needed to be uploaded to cert vault.
    :type public_key: str
    :param private_key: Gets or sets base64 encoded private part of the certificate,
     needed to form the activation key.
    :type private_key: str
    :param expiry_time_in_utc: Gets or sets expiry time in UTC.
    :type expiry_time_in_utc: str
    """

    _attribute_map = {
        'public_key': {'key': 'publicKey', 'type': 'str'},
        'private_key': {'key': 'privateKey', 'type': 'str'},
        'expiry_time_in_utc': {'key': 'expiryTimeInUTC', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        public_key: Optional[str] = None,
        private_key: Optional[str] = None,
        expiry_time_in_utc: Optional[str] = None,
        **kwargs
    ):
        super(GenerateCertResponse, self).__init__(**kwargs)
        self.public_key = public_key
        self.private_key = private_key
        self.expiry_time_in_utc = expiry_time_in_utc


class ImageRepositoryCredential(msrest.serialization.Model):
    """Image repository credential.

    All required parameters must be populated in order to send to Azure.

    :param image_repository_url: Required. Image repository url (e.g.: mcr.microsoft.com).
    :type image_repository_url: str
    :param user_name: Required. Repository user name.
    :type user_name: str
    :param password: Repository user password.
    :type password: ~azure.mgmt.databoxedge.v2020_09_01.models.AsymmetricEncryptedSecret
    """

    _validation = {
        'image_repository_url': {'required': True},
        'user_name': {'required': True},
    }

    _attribute_map = {
        'image_repository_url': {'key': 'imageRepositoryUrl', 'type': 'str'},
        'user_name': {'key': 'userName', 'type': 'str'},
        'password': {'key': 'password', 'type': 'AsymmetricEncryptedSecret'},
    }

    def __init__(
        self,
        *,
        image_repository_url: str,
        user_name: str,
        password: Optional["AsymmetricEncryptedSecret"] = None,
        **kwargs
    ):
        super(ImageRepositoryCredential, self).__init__(**kwargs)
        self.image_repository_url = image_repository_url
        self.user_name = user_name
        self.password = password


class IoTAddon(Addon):
    """IoT Addon.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Addon type.Constant filled by server.  Possible values include:
     "IotEdge", "ArcForKubernetes".
    :type kind: str or ~azure.mgmt.databoxedge.v2020_09_01.models.AddonType
    :ivar system_data: Addon type.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param io_t_device_details: Required. IoT device metadata to which appliance needs to be
     connected.
    :type io_t_device_details: ~azure.mgmt.databoxedge.v2020_09_01.models.IoTDeviceInfo
    :param io_t_edge_device_details: Required. IoT edge device to which the IoT Addon needs to be
     configured.
    :type io_t_edge_device_details: ~azure.mgmt.databoxedge.v2020_09_01.models.IoTDeviceInfo
    :ivar version: Version of IoT running on the appliance.
    :vartype version: str
    :ivar host_platform: Host OS supported by the IoT addon. Possible values include: "Windows",
     "Linux".
    :vartype host_platform: str or ~azure.mgmt.databoxedge.v2020_09_01.models.PlatformType
    :ivar host_platform_type: Platform where the runtime is hosted. Possible values include:
     "KubernetesCluster", "LinuxVM".
    :vartype host_platform_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.HostPlatformType
    :ivar provisioning_state: Addon Provisioning State. Possible values include: "Invalid",
     "Creating", "Created", "Updating", "Reconfiguring", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.databoxedge.v2020_09_01.models.AddonState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
        'io_t_device_details': {'required': True},
        'io_t_edge_device_details': {'required': True},
        'version': {'readonly': True},
        'host_platform': {'readonly': True},
        'host_platform_type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'io_t_device_details': {'key': 'properties.ioTDeviceDetails', 'type': 'IoTDeviceInfo'},
        'io_t_edge_device_details': {'key': 'properties.ioTEdgeDeviceDetails', 'type': 'IoTDeviceInfo'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'host_platform': {'key': 'properties.hostPlatform', 'type': 'str'},
        'host_platform_type': {'key': 'properties.hostPlatformType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        io_t_device_details: "IoTDeviceInfo",
        io_t_edge_device_details: "IoTDeviceInfo",
        **kwargs
    ):
        super(IoTAddon, self).__init__(**kwargs)
        self.kind = 'IotEdge'  # type: str
        self.io_t_device_details = io_t_device_details
        self.io_t_edge_device_details = io_t_edge_device_details
        self.version = None
        self.host_platform = None
        self.host_platform_type = None
        self.provisioning_state = None


class IoTDeviceInfo(msrest.serialization.Model):
    """Metadata of IoT device/IoT Edge device to be configured.

    All required parameters must be populated in order to send to Azure.

    :param device_id: Required. ID of the IoT device/edge device.
    :type device_id: str
    :param io_t_host_hub: Required. Host name for the IoT hub associated to the device.
    :type io_t_host_hub: str
    :param io_t_host_hub_id: Id for the IoT hub associated to the device.
    :type io_t_host_hub_id: str
    :param authentication: Encrypted IoT device/IoT edge device connection string.
    :type authentication: ~azure.mgmt.databoxedge.v2020_09_01.models.Authentication
    """

    _validation = {
        'device_id': {'required': True},
        'io_t_host_hub': {'required': True},
    }

    _attribute_map = {
        'device_id': {'key': 'deviceId', 'type': 'str'},
        'io_t_host_hub': {'key': 'ioTHostHub', 'type': 'str'},
        'io_t_host_hub_id': {'key': 'ioTHostHubId', 'type': 'str'},
        'authentication': {'key': 'authentication', 'type': 'Authentication'},
    }

    def __init__(
        self,
        *,
        device_id: str,
        io_t_host_hub: str,
        io_t_host_hub_id: Optional[str] = None,
        authentication: Optional["Authentication"] = None,
        **kwargs
    ):
        super(IoTDeviceInfo, self).__init__(**kwargs)
        self.device_id = device_id
        self.io_t_host_hub = io_t_host_hub
        self.io_t_host_hub_id = io_t_host_hub_id
        self.authentication = authentication


class IoTEdgeAgentInfo(msrest.serialization.Model):
    """IoT edge agent details is optional, this will be used for download system Agent module while bootstrapping IoT Role if specified.

    All required parameters must be populated in order to send to Azure.

    :param image_name: Required. Name of the IoT edge agent image.
    :type image_name: str
    :param tag: Required. Image Tag.
    :type tag: str
    :param image_repository: Image repository details.
    :type image_repository: ~azure.mgmt.databoxedge.v2020_09_01.models.ImageRepositoryCredential
    """

    _validation = {
        'image_name': {'required': True},
        'tag': {'required': True},
    }

    _attribute_map = {
        'image_name': {'key': 'imageName', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'image_repository': {'key': 'imageRepository', 'type': 'ImageRepositoryCredential'},
    }

    def __init__(
        self,
        *,
        image_name: str,
        tag: str,
        image_repository: Optional["ImageRepositoryCredential"] = None,
        **kwargs
    ):
        super(IoTEdgeAgentInfo, self).__init__(**kwargs)
        self.image_name = image_name
        self.tag = tag
        self.image_repository = image_repository


class IoTRole(Role):
    """Compute role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Role type.Constant filled by server.  Possible values include: "IOT",
     "ASA", "Functions", "Cognitive", "MEC", "CloudEdgeManagement", "Kubernetes".
    :type kind: str or ~azure.mgmt.databoxedge.v2020_09_01.models.RoleTypes
    :ivar system_data: Role configured on ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param host_platform: Host OS supported by the IoT role. Possible values include: "Windows",
     "Linux".
    :type host_platform: str or ~azure.mgmt.databoxedge.v2020_09_01.models.PlatformType
    :param io_t_device_details: IoT device metadata to which data box edge device needs to be
     connected.
    :type io_t_device_details: ~azure.mgmt.databoxedge.v2020_09_01.models.IoTDeviceInfo
    :param io_t_edge_device_details: IoT edge device to which the IoT role needs to be configured.
    :type io_t_edge_device_details: ~azure.mgmt.databoxedge.v2020_09_01.models.IoTDeviceInfo
    :param share_mappings: Mount points of shares in role(s).
    :type share_mappings: list[~azure.mgmt.databoxedge.v2020_09_01.models.MountPointMap]
    :param io_t_edge_agent_info: Iot edge agent details to download the agent and bootstrap iot
     runtime.
    :type io_t_edge_agent_info: ~azure.mgmt.databoxedge.v2020_09_01.models.IoTEdgeAgentInfo
    :ivar host_platform_type: Platform where the Iot runtime is hosted. Possible values include:
     "KubernetesCluster", "LinuxVM".
    :vartype host_platform_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.HostPlatformType
    :param compute_resource: Resource allocation.
    :type compute_resource: ~azure.mgmt.databoxedge.v2020_09_01.models.ComputeResource
    :param role_status: Role status. Possible values include: "Enabled", "Disabled".
    :type role_status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.RoleStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
        'host_platform_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'host_platform': {'key': 'properties.hostPlatform', 'type': 'str'},
        'io_t_device_details': {'key': 'properties.ioTDeviceDetails', 'type': 'IoTDeviceInfo'},
        'io_t_edge_device_details': {'key': 'properties.ioTEdgeDeviceDetails', 'type': 'IoTDeviceInfo'},
        'share_mappings': {'key': 'properties.shareMappings', 'type': '[MountPointMap]'},
        'io_t_edge_agent_info': {'key': 'properties.ioTEdgeAgentInfo', 'type': 'IoTEdgeAgentInfo'},
        'host_platform_type': {'key': 'properties.hostPlatformType', 'type': 'str'},
        'compute_resource': {'key': 'properties.computeResource', 'type': 'ComputeResource'},
        'role_status': {'key': 'properties.roleStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_platform: Optional[Union[str, "PlatformType"]] = None,
        io_t_device_details: Optional["IoTDeviceInfo"] = None,
        io_t_edge_device_details: Optional["IoTDeviceInfo"] = None,
        share_mappings: Optional[List["MountPointMap"]] = None,
        io_t_edge_agent_info: Optional["IoTEdgeAgentInfo"] = None,
        compute_resource: Optional["ComputeResource"] = None,
        role_status: Optional[Union[str, "RoleStatus"]] = None,
        **kwargs
    ):
        super(IoTRole, self).__init__(**kwargs)
        self.kind = 'IOT'  # type: str
        self.host_platform = host_platform
        self.io_t_device_details = io_t_device_details
        self.io_t_edge_device_details = io_t_edge_device_details
        self.share_mappings = share_mappings
        self.io_t_edge_agent_info = io_t_edge_agent_info
        self.host_platform_type = None
        self.compute_resource = compute_resource
        self.role_status = role_status


class Ipv4Config(msrest.serialization.Model):
    """Details related to the IPv4 address configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ip_address: The IPv4 address of the network adapter.
    :vartype ip_address: str
    :ivar subnet: The IPv4 subnet of the network adapter.
    :vartype subnet: str
    :ivar gateway: The IPv4 gateway of the network adapter.
    :vartype gateway: str
    """

    _validation = {
        'ip_address': {'readonly': True},
        'subnet': {'readonly': True},
        'gateway': {'readonly': True},
    }

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'str'},
        'gateway': {'key': 'gateway', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Ipv4Config, self).__init__(**kwargs)
        self.ip_address = None
        self.subnet = None
        self.gateway = None


class Ipv6Config(msrest.serialization.Model):
    """Details related to the IPv6 address configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ip_address: The IPv6 address of the network adapter.
    :vartype ip_address: str
    :ivar prefix_length: The IPv6 prefix of the network adapter.
    :vartype prefix_length: int
    :ivar gateway: The IPv6 gateway of the network adapter.
    :vartype gateway: str
    """

    _validation = {
        'ip_address': {'readonly': True},
        'prefix_length': {'readonly': True},
        'gateway': {'readonly': True},
    }

    _attribute_map = {
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'prefix_length': {'key': 'prefixLength', 'type': 'int'},
        'gateway': {'key': 'gateway', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Ipv6Config, self).__init__(**kwargs)
        self.ip_address = None
        self.prefix_length = None
        self.gateway = None


class Job(msrest.serialization.Model):
    """A device job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The name of the object.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar status: The current status of the job. Possible values include: "Invalid", "Running",
     "Succeeded", "Failed", "Canceled", "Paused", "Scheduled".
    :vartype status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.JobStatus
    :ivar start_time: The UTC date and time at which the job started.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The UTC date and time at which the job completed.
    :vartype end_time: ~datetime.datetime
    :ivar percent_complete: The percentage of the job that is complete.
    :vartype percent_complete: int
    :ivar error: The error details.
    :vartype error: ~azure.mgmt.databoxedge.v2020_09_01.models.JobErrorDetails
    :ivar job_type: The type of the job. Possible values include: "Invalid", "ScanForUpdates",
     "DownloadUpdates", "InstallUpdates", "RefreshShare", "RefreshContainer", "Backup", "Restore",
     "TriggerSupportPackage".
    :vartype job_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.JobType
    :ivar current_stage: Current stage of the update operation. Possible values include: "Unknown",
     "Initial", "ScanStarted", "ScanComplete", "ScanFailed", "DownloadStarted", "DownloadComplete",
     "DownloadFailed", "InstallStarted", "InstallComplete", "InstallFailed", "RebootInitiated",
     "Success", "Failure", "RescanStarted", "RescanComplete", "RescanFailed".
    :vartype current_stage: str or ~azure.mgmt.databoxedge.v2020_09_01.models.UpdateOperationStage
    :ivar download_progress: The download progress.
    :vartype download_progress: ~azure.mgmt.databoxedge.v2020_09_01.models.UpdateDownloadProgress
    :ivar install_progress: The install progress.
    :vartype install_progress: ~azure.mgmt.databoxedge.v2020_09_01.models.UpdateInstallProgress
    :ivar total_refresh_errors: Total number of errors encountered during the refresh process.
    :vartype total_refresh_errors: int
    :ivar error_manifest_file: Local share/remote container relative path to the error manifest
     file of the refresh.
    :vartype error_manifest_file: str
    :ivar refreshed_entity_id: ARM ID of the entity that was refreshed.
    :vartype refreshed_entity_id: str
    :param folder: If only subfolders need to be refreshed, then the subfolder path inside the
     share or container. (The path is empty if there are no subfolders.).
    :type folder: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'percent_complete': {'readonly': True},
        'error': {'readonly': True},
        'job_type': {'readonly': True},
        'current_stage': {'readonly': True},
        'download_progress': {'readonly': True},
        'install_progress': {'readonly': True},
        'total_refresh_errors': {'readonly': True},
        'error_manifest_file': {'readonly': True},
        'refreshed_entity_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'percent_complete': {'key': 'percentComplete', 'type': 'int'},
        'error': {'key': 'error', 'type': 'JobErrorDetails'},
        'job_type': {'key': 'properties.jobType', 'type': 'str'},
        'current_stage': {'key': 'properties.currentStage', 'type': 'str'},
        'download_progress': {'key': 'properties.downloadProgress', 'type': 'UpdateDownloadProgress'},
        'install_progress': {'key': 'properties.installProgress', 'type': 'UpdateInstallProgress'},
        'total_refresh_errors': {'key': 'properties.totalRefreshErrors', 'type': 'int'},
        'error_manifest_file': {'key': 'properties.errorManifestFile', 'type': 'str'},
        'refreshed_entity_id': {'key': 'properties.refreshedEntityId', 'type': 'str'},
        'folder': {'key': 'properties.folder', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        folder: Optional[str] = None,
        **kwargs
    ):
        super(Job, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.percent_complete = None
        self.error = None
        self.job_type = None
        self.current_stage = None
        self.download_progress = None
        self.install_progress = None
        self.total_refresh_errors = None
        self.error_manifest_file = None
        self.refreshed_entity_id = None
        self.folder = folder


class JobErrorDetails(msrest.serialization.Model):
    """The job error information containing the list of job errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_details: The error details.
    :vartype error_details: list[~azure.mgmt.databoxedge.v2020_09_01.models.JobErrorItem]
    :ivar code: The code intended for programmatic access.
    :vartype code: str
    :ivar message: The message that describes the error in detail.
    :vartype message: str
    """

    _validation = {
        'error_details': {'readonly': True},
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'error_details': {'key': 'errorDetails', 'type': '[JobErrorItem]'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobErrorDetails, self).__init__(**kwargs)
        self.error_details = None
        self.code = None
        self.message = None


class JobErrorItem(msrest.serialization.Model):
    """The job error items.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar recommendations: The recommended actions.
    :vartype recommendations: list[str]
    :ivar code: The code intended for programmatic access.
    :vartype code: str
    :ivar message: The message that describes the error in detail.
    :vartype message: str
    """

    _validation = {
        'recommendations': {'readonly': True},
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'recommendations': {'key': 'recommendations', 'type': '[str]'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobErrorItem, self).__init__(**kwargs)
        self.recommendations = None
        self.code = None
        self.message = None


class KubernetesClusterInfo(msrest.serialization.Model):
    """Kubernetes cluster configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar etcd_info: Etcd configuration.
    :vartype etcd_info: ~azure.mgmt.databoxedge.v2020_09_01.models.EtcdInfo
    :ivar nodes: Kubernetes cluster nodes.
    :vartype nodes: list[~azure.mgmt.databoxedge.v2020_09_01.models.NodeInfo]
    :param version: Required. Kubernetes cluster version.
    :type version: str
    """

    _validation = {
        'etcd_info': {'readonly': True},
        'nodes': {'readonly': True},
        'version': {'required': True},
    }

    _attribute_map = {
        'etcd_info': {'key': 'etcdInfo', 'type': 'EtcdInfo'},
        'nodes': {'key': 'nodes', 'type': '[NodeInfo]'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        version: str,
        **kwargs
    ):
        super(KubernetesClusterInfo, self).__init__(**kwargs)
        self.etcd_info = None
        self.nodes = None
        self.version = version


class KubernetesIPConfiguration(msrest.serialization.Model):
    """Kubernetes node IP configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar port: Port of the Kubernetes node.
    :vartype port: str
    :param ip_address: IP address of the Kubernetes node.
    :type ip_address: str
    """

    _validation = {
        'port': {'readonly': True},
    }

    _attribute_map = {
        'port': {'key': 'port', 'type': 'str'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_address: Optional[str] = None,
        **kwargs
    ):
        super(KubernetesIPConfiguration, self).__init__(**kwargs)
        self.port = None
        self.ip_address = ip_address


class KubernetesRole(Role):
    """Kubernetes role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Role type.Constant filled by server.  Possible values include: "IOT",
     "ASA", "Functions", "Cognitive", "MEC", "CloudEdgeManagement", "Kubernetes".
    :type kind: str or ~azure.mgmt.databoxedge.v2020_09_01.models.RoleTypes
    :ivar system_data: Role configured on ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param host_platform: Host OS supported by the Kubernetes role. Possible values include:
     "Windows", "Linux".
    :type host_platform: str or ~azure.mgmt.databoxedge.v2020_09_01.models.PlatformType
    :ivar provisioning_state: State of Kubernetes deployment. Possible values include: "Invalid",
     "Creating", "Created", "Updating", "Reconfiguring", "Failed", "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.databoxedge.v2020_09_01.models.KubernetesState
    :ivar host_platform_type: Platform where the runtime is hosted. Possible values include:
     "KubernetesCluster", "LinuxVM".
    :vartype host_platform_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.HostPlatformType
    :param kubernetes_cluster_info: Kubernetes cluster configuration.
    :type kubernetes_cluster_info: ~azure.mgmt.databoxedge.v2020_09_01.models.KubernetesClusterInfo
    :param kubernetes_role_resources: Kubernetes role resources.
    :type kubernetes_role_resources:
     ~azure.mgmt.databoxedge.v2020_09_01.models.KubernetesRoleResources
    :param role_status: Role status. Possible values include: "Enabled", "Disabled".
    :type role_status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.RoleStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'host_platform_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'host_platform': {'key': 'properties.hostPlatform', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'host_platform_type': {'key': 'properties.hostPlatformType', 'type': 'str'},
        'kubernetes_cluster_info': {'key': 'properties.kubernetesClusterInfo', 'type': 'KubernetesClusterInfo'},
        'kubernetes_role_resources': {'key': 'properties.kubernetesRoleResources', 'type': 'KubernetesRoleResources'},
        'role_status': {'key': 'properties.roleStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        host_platform: Optional[Union[str, "PlatformType"]] = None,
        kubernetes_cluster_info: Optional["KubernetesClusterInfo"] = None,
        kubernetes_role_resources: Optional["KubernetesRoleResources"] = None,
        role_status: Optional[Union[str, "RoleStatus"]] = None,
        **kwargs
    ):
        super(KubernetesRole, self).__init__(**kwargs)
        self.kind = 'Kubernetes'  # type: str
        self.host_platform = host_platform
        self.provisioning_state = None
        self.host_platform_type = None
        self.kubernetes_cluster_info = kubernetes_cluster_info
        self.kubernetes_role_resources = kubernetes_role_resources
        self.role_status = role_status


class KubernetesRoleCompute(msrest.serialization.Model):
    """Kubernetes role compute resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param vm_profile: Required. VM profile.
    :type vm_profile: str
    :ivar memory_in_bytes: Memory in bytes.
    :vartype memory_in_bytes: long
    :ivar processor_count: Processor count.
    :vartype processor_count: int
    """

    _validation = {
        'vm_profile': {'required': True},
        'memory_in_bytes': {'readonly': True},
        'processor_count': {'readonly': True},
    }

    _attribute_map = {
        'vm_profile': {'key': 'vmProfile', 'type': 'str'},
        'memory_in_bytes': {'key': 'memoryInBytes', 'type': 'long'},
        'processor_count': {'key': 'processorCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        vm_profile: str,
        **kwargs
    ):
        super(KubernetesRoleCompute, self).__init__(**kwargs)
        self.vm_profile = vm_profile
        self.memory_in_bytes = None
        self.processor_count = None


class KubernetesRoleNetwork(msrest.serialization.Model):
    """Kubernetes role network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cni_config: Cni configuration.
    :vartype cni_config: ~azure.mgmt.databoxedge.v2020_09_01.models.CniConfig
    :ivar load_balancer_config: Load balancer configuration.
    :vartype load_balancer_config: ~azure.mgmt.databoxedge.v2020_09_01.models.LoadBalancerConfig
    """

    _validation = {
        'cni_config': {'readonly': True},
        'load_balancer_config': {'readonly': True},
    }

    _attribute_map = {
        'cni_config': {'key': 'cniConfig', 'type': 'CniConfig'},
        'load_balancer_config': {'key': 'loadBalancerConfig', 'type': 'LoadBalancerConfig'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KubernetesRoleNetwork, self).__init__(**kwargs)
        self.cni_config = None
        self.load_balancer_config = None


class KubernetesRoleResources(msrest.serialization.Model):
    """Kubernetes role resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param storage: Kubernetes role storage resource.
    :type storage: ~azure.mgmt.databoxedge.v2020_09_01.models.KubernetesRoleStorage
    :param compute: Required. Kubernetes role compute resource.
    :type compute: ~azure.mgmt.databoxedge.v2020_09_01.models.KubernetesRoleCompute
    :ivar network: Kubernetes role network resource.
    :vartype network: ~azure.mgmt.databoxedge.v2020_09_01.models.KubernetesRoleNetwork
    """

    _validation = {
        'compute': {'required': True},
        'network': {'readonly': True},
    }

    _attribute_map = {
        'storage': {'key': 'storage', 'type': 'KubernetesRoleStorage'},
        'compute': {'key': 'compute', 'type': 'KubernetesRoleCompute'},
        'network': {'key': 'network', 'type': 'KubernetesRoleNetwork'},
    }

    def __init__(
        self,
        *,
        compute: "KubernetesRoleCompute",
        storage: Optional["KubernetesRoleStorage"] = None,
        **kwargs
    ):
        super(KubernetesRoleResources, self).__init__(**kwargs)
        self.storage = storage
        self.compute = compute
        self.network = None


class KubernetesRoleStorage(msrest.serialization.Model):
    """Kubernetes role storage resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_classes: Kubernetes storage class info.
    :vartype storage_classes:
     list[~azure.mgmt.databoxedge.v2020_09_01.models.KubernetesRoleStorageClassInfo]
    :param endpoints: Mount points of shares in role(s).
    :type endpoints: list[~azure.mgmt.databoxedge.v2020_09_01.models.MountPointMap]
    """

    _validation = {
        'storage_classes': {'readonly': True},
    }

    _attribute_map = {
        'storage_classes': {'key': 'storageClasses', 'type': '[KubernetesRoleStorageClassInfo]'},
        'endpoints': {'key': 'endpoints', 'type': '[MountPointMap]'},
    }

    def __init__(
        self,
        *,
        endpoints: Optional[List["MountPointMap"]] = None,
        **kwargs
    ):
        super(KubernetesRoleStorage, self).__init__(**kwargs)
        self.storage_classes = None
        self.endpoints = endpoints


class KubernetesRoleStorageClassInfo(msrest.serialization.Model):
    """Kubernetes storage class info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Storage class name.
    :vartype name: str
    :ivar type: Storage class type.
    :vartype type: str
    :ivar posix_compliant: If provisioned storage is posix compliant. Possible values include:
     "Invalid", "Enabled", "Disabled".
    :vartype posix_compliant: str or
     ~azure.mgmt.databoxedge.v2020_09_01.models.PosixComplianceStatus
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'posix_compliant': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'posix_compliant': {'key': 'posixCompliant', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KubernetesRoleStorageClassInfo, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.posix_compliant = None


class LoadBalancerConfig(msrest.serialization.Model):
    """Load balancer configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Load balancer type.
    :vartype type: str
    :ivar version: Load balancer version.
    :vartype version: str
    """

    _validation = {
        'type': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LoadBalancerConfig, self).__init__(**kwargs)
        self.type = None
        self.version = None


class MECRole(Role):
    """MEC role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param kind: Required. Role type.Constant filled by server.  Possible values include: "IOT",
     "ASA", "Functions", "Cognitive", "MEC", "CloudEdgeManagement", "Kubernetes".
    :type kind: str or ~azure.mgmt.databoxedge.v2020_09_01.models.RoleTypes
    :ivar system_data: Role configured on ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param connection_string: Activation key of the MEC.
    :type connection_string: ~azure.mgmt.databoxedge.v2020_09_01.models.AsymmetricEncryptedSecret
    :param role_status: Role status. Possible values include: "Enabled", "Disabled".
    :type role_status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.RoleStatus
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'kind': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'AsymmetricEncryptedSecret'},
        'role_status': {'key': 'properties.roleStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection_string: Optional["AsymmetricEncryptedSecret"] = None,
        role_status: Optional[Union[str, "RoleStatus"]] = None,
        **kwargs
    ):
        super(MECRole, self).__init__(**kwargs)
        self.kind = 'MEC'  # type: str
        self.connection_string = connection_string
        self.role_status = role_status


class MetricConfiguration(msrest.serialization.Model):
    """Metric configuration.

    All required parameters must be populated in order to send to Azure.

    :param resource_id: Required. The Resource ID on which the metrics should be pushed.
    :type resource_id: str
    :param mdm_account: The MDM account to which the counters should be pushed.
    :type mdm_account: str
    :param metric_name_space: The MDM namespace to which the counters should be pushed. This is
     required if MDMAccount is specified.
    :type metric_name_space: str
    :param counter_sets: Required. Host name for the IoT hub associated to the device.
    :type counter_sets: list[~azure.mgmt.databoxedge.v2020_09_01.models.MetricCounterSet]
    """

    _validation = {
        'resource_id': {'required': True},
        'counter_sets': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'mdm_account': {'key': 'mdmAccount', 'type': 'str'},
        'metric_name_space': {'key': 'metricNameSpace', 'type': 'str'},
        'counter_sets': {'key': 'counterSets', 'type': '[MetricCounterSet]'},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        counter_sets: List["MetricCounterSet"],
        mdm_account: Optional[str] = None,
        metric_name_space: Optional[str] = None,
        **kwargs
    ):
        super(MetricConfiguration, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.mdm_account = mdm_account
        self.metric_name_space = metric_name_space
        self.counter_sets = counter_sets


class MetricCounter(msrest.serialization.Model):
    """The metric counter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The counter name.
    :type name: str
    :param instance: The instance from which counter should be collected.
    :type instance: str
    :param dimension_filter: The dimension filter.
    :type dimension_filter: list[~azure.mgmt.databoxedge.v2020_09_01.models.MetricDimension]
    :param additional_dimensions: The additional dimensions to be added to metric.
    :type additional_dimensions: list[~azure.mgmt.databoxedge.v2020_09_01.models.MetricDimension]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'instance': {'key': 'instance', 'type': 'str'},
        'dimension_filter': {'key': 'dimensionFilter', 'type': '[MetricDimension]'},
        'additional_dimensions': {'key': 'additionalDimensions', 'type': '[MetricDimension]'},
    }

    def __init__(
        self,
        *,
        name: str,
        instance: Optional[str] = None,
        dimension_filter: Optional[List["MetricDimension"]] = None,
        additional_dimensions: Optional[List["MetricDimension"]] = None,
        **kwargs
    ):
        super(MetricCounter, self).__init__(**kwargs)
        self.name = name
        self.instance = instance
        self.dimension_filter = dimension_filter
        self.additional_dimensions = additional_dimensions


class MetricCounterSet(msrest.serialization.Model):
    """The metric counter set.

    All required parameters must be populated in order to send to Azure.

    :param counters: Required. The counters that should be collected in this set.
    :type counters: list[~azure.mgmt.databoxedge.v2020_09_01.models.MetricCounter]
    """

    _validation = {
        'counters': {'required': True},
    }

    _attribute_map = {
        'counters': {'key': 'counters', 'type': '[MetricCounter]'},
    }

    def __init__(
        self,
        *,
        counters: List["MetricCounter"],
        **kwargs
    ):
        super(MetricCounterSet, self).__init__(**kwargs)
        self.counters = counters


class MetricDimension(msrest.serialization.Model):
    """The metric dimension.

    All required parameters must be populated in order to send to Azure.

    :param source_type: Required. The dimension type.
    :type source_type: str
    :param source_name: Required. The dimension value.
    :type source_name: str
    """

    _validation = {
        'source_type': {'required': True},
        'source_name': {'required': True},
    }

    _attribute_map = {
        'source_type': {'key': 'sourceType', 'type': 'str'},
        'source_name': {'key': 'sourceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_type: str,
        source_name: str,
        **kwargs
    ):
        super(MetricDimension, self).__init__(**kwargs)
        self.source_type = source_type
        self.source_name = source_name


class MetricDimensionV1(msrest.serialization.Model):
    """Metric Dimension v1.

    :param name: Name of the metrics dimension.
    :type name: str
    :param display_name: Display name of the metrics dimension.
    :type display_name: str
    :param to_be_exported_for_shoebox: To be exported to shoe box.
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs
    ):
        super(MetricDimensionV1, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class MetricSpecificationV1(msrest.serialization.Model):
    """Metric specification version 1.

    :param name: Name of the metric.
    :type name: str
    :param display_name: Display name of the metric.
    :type display_name: str
    :param display_description: Description of the metric to be displayed.
    :type display_description: str
    :param unit: Metric units. Possible values include: "NotSpecified", "Percent", "Count",
     "Seconds", "Milliseconds", "Bytes", "BytesPerSecond", "CountPerSecond".
    :type unit: str or ~azure.mgmt.databoxedge.v2020_09_01.models.MetricUnit
    :param aggregation_type: Metric aggregation type. Possible values include: "NotSpecified",
     "None", "Average", "Minimum", "Maximum", "Total", "Count".
    :type aggregation_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.MetricAggregationType
    :param dimensions: Metric dimensions, other than default dimension which is resource.
    :type dimensions: list[~azure.mgmt.databoxedge.v2020_09_01.models.MetricDimensionV1]
    :param fill_gap_with_zero: Set true to fill the gaps with zero.
    :type fill_gap_with_zero: bool
    :param category: Metric category. Possible values include: "Capacity", "Transaction".
    :type category: str or ~azure.mgmt.databoxedge.v2020_09_01.models.MetricCategory
    :param resource_id_dimension_name_override: Resource name override.
    :type resource_id_dimension_name_override: str
    :param supported_time_grain_types: Support granularity of metrics.
    :type supported_time_grain_types: list[str or
     ~azure.mgmt.databoxedge.v2020_09_01.models.TimeGrain]
    :param supported_aggregation_types: Support metric aggregation type.
    :type supported_aggregation_types: list[str or
     ~azure.mgmt.databoxedge.v2020_09_01.models.MetricAggregationType]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimensionV1]'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'category': {'key': 'category', 'type': 'str'},
        'resource_id_dimension_name_override': {'key': 'resourceIdDimensionNameOverride', 'type': 'str'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[Union[str, "MetricUnit"]] = None,
        aggregation_type: Optional[Union[str, "MetricAggregationType"]] = None,
        dimensions: Optional[List["MetricDimensionV1"]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        category: Optional[Union[str, "MetricCategory"]] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        supported_time_grain_types: Optional[List[Union[str, "TimeGrain"]]] = None,
        supported_aggregation_types: Optional[List[Union[str, "MetricAggregationType"]]] = None,
        **kwargs
    ):
        super(MetricSpecificationV1, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.dimensions = dimensions
        self.fill_gap_with_zero = fill_gap_with_zero
        self.category = category
        self.resource_id_dimension_name_override = resource_id_dimension_name_override
        self.supported_time_grain_types = supported_time_grain_types
        self.supported_aggregation_types = supported_aggregation_types


class MonitoringMetricConfiguration(ARMBaseModel):
    """The metric setting details for the role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param metric_configurations: Required. The metrics configuration details.
    :type metric_configurations:
     list[~azure.mgmt.databoxedge.v2020_09_01.models.MetricConfiguration]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'metric_configurations': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'metric_configurations': {'key': 'properties.metricConfigurations', 'type': '[MetricConfiguration]'},
    }

    def __init__(
        self,
        *,
        metric_configurations: List["MetricConfiguration"],
        **kwargs
    ):
        super(MonitoringMetricConfiguration, self).__init__(**kwargs)
        self.metric_configurations = metric_configurations


class MonitoringMetricConfigurationList(msrest.serialization.Model):
    """Collection of metric configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of metric configurations.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.MonitoringMetricConfiguration]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MonitoringMetricConfiguration]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MonitoringMetricConfigurationList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class MountPointMap(msrest.serialization.Model):
    """The share mount point.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param share_id: Required. ID of the share mounted to the role VM.
    :type share_id: str
    :ivar role_id: ID of the role to which share is mounted.
    :vartype role_id: str
    :ivar mount_point: Mount point for the share.
    :vartype mount_point: str
    :ivar mount_type: Mounting type. Possible values include: "Volume", "HostPath".
    :vartype mount_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.MountType
    :ivar role_type: Role type. Possible values include: "IOT", "ASA", "Functions", "Cognitive",
     "MEC", "CloudEdgeManagement", "Kubernetes".
    :vartype role_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.RoleTypes
    """

    _validation = {
        'share_id': {'required': True},
        'role_id': {'readonly': True},
        'mount_point': {'readonly': True},
        'mount_type': {'readonly': True},
        'role_type': {'readonly': True},
    }

    _attribute_map = {
        'share_id': {'key': 'shareId', 'type': 'str'},
        'role_id': {'key': 'roleId', 'type': 'str'},
        'mount_point': {'key': 'mountPoint', 'type': 'str'},
        'mount_type': {'key': 'mountType', 'type': 'str'},
        'role_type': {'key': 'roleType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        share_id: str,
        **kwargs
    ):
        super(MountPointMap, self).__init__(**kwargs)
        self.share_id = share_id
        self.role_id = None
        self.mount_point = None
        self.mount_type = None
        self.role_type = None


class NetworkAdapter(msrest.serialization.Model):
    """Represents the networkAdapter on a device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar adapter_id: Instance ID of network adapter.
    :vartype adapter_id: str
    :ivar adapter_position: Hardware position of network adapter.
    :vartype adapter_position: ~azure.mgmt.databoxedge.v2020_09_01.models.NetworkAdapterPosition
    :ivar index: Logical index of the adapter.
    :vartype index: int
    :ivar node_id: Node ID of the network adapter.
    :vartype node_id: str
    :ivar network_adapter_name: Network adapter name.
    :vartype network_adapter_name: str
    :ivar label: Hardware label for the adapter.
    :vartype label: str
    :ivar mac_address: MAC address.
    :vartype mac_address: str
    :ivar link_speed: Link speed.
    :vartype link_speed: long
    :ivar status: Value indicating whether this adapter is valid. Possible values include:
     "Inactive", "Active".
    :vartype status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.NetworkAdapterStatus
    :param rdma_status: Value indicating whether this adapter is RDMA capable. Possible values
     include: "Incapable", "Capable".
    :type rdma_status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.NetworkAdapterRDMAStatus
    :param dhcp_status: Value indicating whether this adapter has DHCP enabled. Possible values
     include: "Disabled", "Enabled".
    :type dhcp_status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.NetworkAdapterDHCPStatus
    :ivar ipv4_configuration: The IPv4 configuration of the network adapter.
    :vartype ipv4_configuration: ~azure.mgmt.databoxedge.v2020_09_01.models.Ipv4Config
    :ivar ipv6_configuration: The IPv6 configuration of the network adapter.
    :vartype ipv6_configuration: ~azure.mgmt.databoxedge.v2020_09_01.models.Ipv6Config
    :ivar ipv6_link_local_address: The IPv6 local address.
    :vartype ipv6_link_local_address: str
    :ivar dns_servers: The list of DNS Servers of the device.
    :vartype dns_servers: list[str]
    """

    _validation = {
        'adapter_id': {'readonly': True},
        'adapter_position': {'readonly': True},
        'index': {'readonly': True},
        'node_id': {'readonly': True},
        'network_adapter_name': {'readonly': True},
        'label': {'readonly': True},
        'mac_address': {'readonly': True},
        'link_speed': {'readonly': True},
        'status': {'readonly': True},
        'ipv4_configuration': {'readonly': True},
        'ipv6_configuration': {'readonly': True},
        'ipv6_link_local_address': {'readonly': True},
        'dns_servers': {'readonly': True},
    }

    _attribute_map = {
        'adapter_id': {'key': 'adapterId', 'type': 'str'},
        'adapter_position': {'key': 'adapterPosition', 'type': 'NetworkAdapterPosition'},
        'index': {'key': 'index', 'type': 'int'},
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'network_adapter_name': {'key': 'networkAdapterName', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'mac_address': {'key': 'macAddress', 'type': 'str'},
        'link_speed': {'key': 'linkSpeed', 'type': 'long'},
        'status': {'key': 'status', 'type': 'str'},
        'rdma_status': {'key': 'rdmaStatus', 'type': 'str'},
        'dhcp_status': {'key': 'dhcpStatus', 'type': 'str'},
        'ipv4_configuration': {'key': 'ipv4Configuration', 'type': 'Ipv4Config'},
        'ipv6_configuration': {'key': 'ipv6Configuration', 'type': 'Ipv6Config'},
        'ipv6_link_local_address': {'key': 'ipv6LinkLocalAddress', 'type': 'str'},
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        rdma_status: Optional[Union[str, "NetworkAdapterRDMAStatus"]] = None,
        dhcp_status: Optional[Union[str, "NetworkAdapterDHCPStatus"]] = None,
        **kwargs
    ):
        super(NetworkAdapter, self).__init__(**kwargs)
        self.adapter_id = None
        self.adapter_position = None
        self.index = None
        self.node_id = None
        self.network_adapter_name = None
        self.label = None
        self.mac_address = None
        self.link_speed = None
        self.status = None
        self.rdma_status = rdma_status
        self.dhcp_status = dhcp_status
        self.ipv4_configuration = None
        self.ipv6_configuration = None
        self.ipv6_link_local_address = None
        self.dns_servers = None


class NetworkAdapterPosition(msrest.serialization.Model):
    """The network adapter position.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar network_group: The network group. Possible values include: "None", "NonRDMA", "RDMA".
    :vartype network_group: str or ~azure.mgmt.databoxedge.v2020_09_01.models.NetworkGroup
    :ivar port: The port.
    :vartype port: int
    """

    _validation = {
        'network_group': {'readonly': True},
        'port': {'readonly': True},
    }

    _attribute_map = {
        'network_group': {'key': 'networkGroup', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkAdapterPosition, self).__init__(**kwargs)
        self.network_group = None
        self.port = None


class NetworkSettings(ARMBaseModel):
    """The network settings of a device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar network_adapters: The network adapter list on the device.
    :vartype network_adapters: list[~azure.mgmt.databoxedge.v2020_09_01.models.NetworkAdapter]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'network_adapters': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'network_adapters': {'key': 'properties.networkAdapters', 'type': '[NetworkAdapter]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NetworkSettings, self).__init__(**kwargs)
        self.network_adapters = None


class Node(ARMBaseModel):
    """Represents a single node in a Data box Edge/Gateway device
Gateway devices, standalone Edge devices and a single node cluster Edge device will all have 1 node
Multi-node Edge devices will have more than 1 nodes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar node_status: The current status of the individual node. Possible values include:
     "Unknown", "Up", "Down", "Rebooting", "ShuttingDown".
    :vartype node_status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.NodeStatus
    :ivar node_chassis_serial_number: Serial number of the Chassis.
    :vartype node_chassis_serial_number: str
    :ivar node_serial_number: Serial number of the individual node.
    :vartype node_serial_number: str
    :ivar node_display_name: Display Name of the individual node.
    :vartype node_display_name: str
    :ivar node_friendly_software_version: Friendly software version name that is currently
     installed on the node.
    :vartype node_friendly_software_version: str
    :ivar node_hcs_version: HCS version that is currently installed on the node.
    :vartype node_hcs_version: str
    :ivar node_instance_id: Guid instance id of the node.
    :vartype node_instance_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'node_status': {'readonly': True},
        'node_chassis_serial_number': {'readonly': True},
        'node_serial_number': {'readonly': True},
        'node_display_name': {'readonly': True},
        'node_friendly_software_version': {'readonly': True},
        'node_hcs_version': {'readonly': True},
        'node_instance_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'node_status': {'key': 'properties.nodeStatus', 'type': 'str'},
        'node_chassis_serial_number': {'key': 'properties.nodeChassisSerialNumber', 'type': 'str'},
        'node_serial_number': {'key': 'properties.nodeSerialNumber', 'type': 'str'},
        'node_display_name': {'key': 'properties.nodeDisplayName', 'type': 'str'},
        'node_friendly_software_version': {'key': 'properties.nodeFriendlySoftwareVersion', 'type': 'str'},
        'node_hcs_version': {'key': 'properties.nodeHcsVersion', 'type': 'str'},
        'node_instance_id': {'key': 'properties.nodeInstanceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Node, self).__init__(**kwargs)
        self.node_status = None
        self.node_chassis_serial_number = None
        self.node_serial_number = None
        self.node_display_name = None
        self.node_friendly_software_version = None
        self.node_hcs_version = None
        self.node_instance_id = None


class NodeInfo(msrest.serialization.Model):
    """Kubernetes node info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Node name.
    :vartype name: str
    :ivar type: Node type - Master/Worker. Possible values include: "Invalid", "Master", "Worker".
    :vartype type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.KubernetesNodeType
    :param ip_configuration: IP Configuration of the Kubernetes node.
    :type ip_configuration:
     list[~azure.mgmt.databoxedge.v2020_09_01.models.KubernetesIPConfiguration]
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'ip_configuration': {'key': 'ipConfiguration', 'type': '[KubernetesIPConfiguration]'},
    }

    def __init__(
        self,
        *,
        ip_configuration: Optional[List["KubernetesIPConfiguration"]] = None,
        **kwargs
    ):
        super(NodeInfo, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.ip_configuration = ip_configuration


class NodeList(msrest.serialization.Model):
    """Collection of Nodes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Nodes.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.Node]
    :param next_link: Link to the next set of results.
    :type next_link: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Node]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(NodeList, self).__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class Operation(msrest.serialization.Model):
    """Operations.

    :param name: Name of the operation.
    :type name: str
    :param display: Properties displayed for the operation.
    :type display: ~azure.mgmt.databoxedge.v2020_09_01.models.OperationDisplay
    :param origin: Origin of the operation.
    :type origin: str
    :param is_data_action: Indicates whether the operation is a data action.
    :type is_data_action: bool
    :param service_specification: Service specification.
    :type service_specification: ~azure.mgmt.databoxedge.v2020_09_01.models.ServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplay"] = None,
        origin: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        service_specification: Optional["ServiceSpecification"] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.is_data_action = is_data_action
        self.service_specification = service_specification


class OperationDisplay(msrest.serialization.Model):
    """Operation display properties.

    :param provider: Provider name.
    :type provider: str
    :param resource: The type of resource in which the operation is performed.
    :type resource: str
    :param operation: Operation to be performed on the resource.
    :type operation: str
    :param description: Description of the operation to be performed.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsList(msrest.serialization.Model):
    """The list of operations used for the discovery of available provider operations.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The value.
    :type value: list[~azure.mgmt.databoxedge.v2020_09_01.models.Operation]
    :param next_link: Link to the next set of results.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Operation"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OperationsList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Order(ARMBaseModel):
    """The order details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param contact_information: The contact details.
    :type contact_information: ~azure.mgmt.databoxedge.v2020_09_01.models.ContactDetails
    :param shipping_address: The shipping address.
    :type shipping_address: ~azure.mgmt.databoxedge.v2020_09_01.models.Address
    :ivar current_status: Current status of the order.
    :vartype current_status: ~azure.mgmt.databoxedge.v2020_09_01.models.OrderStatus
    :ivar order_history: List of status changes in the order.
    :vartype order_history: list[~azure.mgmt.databoxedge.v2020_09_01.models.OrderStatus]
    :ivar serial_number: Serial number of the device.
    :vartype serial_number: str
    :ivar delivery_tracking_info: Tracking information for the package delivered to the customer
     whether it has an original or a replacement device.
    :vartype delivery_tracking_info: list[~azure.mgmt.databoxedge.v2020_09_01.models.TrackingInfo]
    :ivar return_tracking_info: Tracking information for the package returned from the customer
     whether it has an original or a replacement device.
    :vartype return_tracking_info: list[~azure.mgmt.databoxedge.v2020_09_01.models.TrackingInfo]
    :param shipment_type: ShipmentType of the order. Possible values include: "NotApplicable",
     "ShippedToCustomer", "SelfPickup".
    :type shipment_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.ShipmentType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'current_status': {'readonly': True},
        'order_history': {'readonly': True},
        'serial_number': {'readonly': True},
        'delivery_tracking_info': {'readonly': True},
        'return_tracking_info': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'contact_information': {'key': 'properties.contactInformation', 'type': 'ContactDetails'},
        'shipping_address': {'key': 'properties.shippingAddress', 'type': 'Address'},
        'current_status': {'key': 'properties.currentStatus', 'type': 'OrderStatus'},
        'order_history': {'key': 'properties.orderHistory', 'type': '[OrderStatus]'},
        'serial_number': {'key': 'properties.serialNumber', 'type': 'str'},
        'delivery_tracking_info': {'key': 'properties.deliveryTrackingInfo', 'type': '[TrackingInfo]'},
        'return_tracking_info': {'key': 'properties.returnTrackingInfo', 'type': '[TrackingInfo]'},
        'shipment_type': {'key': 'properties.shipmentType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        contact_information: Optional["ContactDetails"] = None,
        shipping_address: Optional["Address"] = None,
        shipment_type: Optional[Union[str, "ShipmentType"]] = None,
        **kwargs
    ):
        super(Order, self).__init__(**kwargs)
        self.contact_information = contact_information
        self.shipping_address = shipping_address
        self.current_status = None
        self.order_history = None
        self.serial_number = None
        self.delivery_tracking_info = None
        self.return_tracking_info = None
        self.shipment_type = shipment_type


class OrderList(msrest.serialization.Model):
    """List of order entities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of orders.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.Order]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Order]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OrderList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class OrderStatus(msrest.serialization.Model):
    """Represents a single status change.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Status of the order as per the allowed status types. Possible values
     include: "Untracked", "AwaitingFulfilment", "AwaitingPreparation", "AwaitingShipment",
     "Shipped", "Arriving", "Delivered", "ReplacementRequested", "LostDevice", "Declined",
     "ReturnInitiated", "AwaitingReturnShipment", "ShippedBack", "CollectedAtMicrosoft",
     "AwaitingPickup", "PickupCompleted", "AwaitingDrop".
    :type status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.OrderState
    :ivar update_date_time: Time of status update.
    :vartype update_date_time: ~datetime.datetime
    :param comments: Comments related to this status change.
    :type comments: str
    :ivar tracking_information: Tracking information related to the state in the ordering flow.
    :vartype tracking_information: ~azure.mgmt.databoxedge.v2020_09_01.models.TrackingInfo
    :ivar additional_order_details: Dictionary to hold generic information which is not stored
     by the already existing properties.
    :vartype additional_order_details: dict[str, str]
    """

    _validation = {
        'status': {'required': True},
        'update_date_time': {'readonly': True},
        'tracking_information': {'readonly': True},
        'additional_order_details': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'update_date_time': {'key': 'updateDateTime', 'type': 'iso-8601'},
        'comments': {'key': 'comments', 'type': 'str'},
        'tracking_information': {'key': 'trackingInformation', 'type': 'TrackingInfo'},
        'additional_order_details': {'key': 'additionalOrderDetails', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        status: Union[str, "OrderState"],
        comments: Optional[str] = None,
        **kwargs
    ):
        super(OrderStatus, self).__init__(**kwargs)
        self.status = status
        self.update_date_time = None
        self.comments = comments
        self.tracking_information = None
        self.additional_order_details = None


class PeriodicTimerEventTrigger(Trigger):
    """Trigger details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Trigger in DataBoxEdge Resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param kind: Required. Trigger Kind.Constant filled by server.  Possible values include:
     "FileEvent", "PeriodicTimerEvent".
    :type kind: str or ~azure.mgmt.databoxedge.v2020_09_01.models.TriggerEventType
    :param source_info: Required. Periodic timer details.
    :type source_info: ~azure.mgmt.databoxedge.v2020_09_01.models.PeriodicTimerSourceInfo
    :param sink_info: Required. Role Sink information.
    :type sink_info: ~azure.mgmt.databoxedge.v2020_09_01.models.RoleSinkInfo
    :param custom_context_tag: A custom context tag typically used to correlate the trigger against
     its usage. For example, if a periodic timer trigger is intended for certain specific IoT
     modules in the device, the tag can be the name or the image URL of the module.
    :type custom_context_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'kind': {'required': True},
        'source_info': {'required': True},
        'sink_info': {'required': True},
        'custom_context_tag': {'max_length': 192, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'kind': {'key': 'kind', 'type': 'str'},
        'source_info': {'key': 'properties.sourceInfo', 'type': 'PeriodicTimerSourceInfo'},
        'sink_info': {'key': 'properties.sinkInfo', 'type': 'RoleSinkInfo'},
        'custom_context_tag': {'key': 'properties.customContextTag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_info: "PeriodicTimerSourceInfo",
        sink_info: "RoleSinkInfo",
        custom_context_tag: Optional[str] = None,
        **kwargs
    ):
        super(PeriodicTimerEventTrigger, self).__init__(**kwargs)
        self.kind = 'PeriodicTimerEvent'  # type: str
        self.source_info = source_info
        self.sink_info = sink_info
        self.custom_context_tag = custom_context_tag


class PeriodicTimerSourceInfo(msrest.serialization.Model):
    """Periodic timer event source.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. The time of the day that results in a valid trigger. Schedule is
     computed with reference to the time specified upto seconds. If timezone is not specified the
     time will considered to be in device timezone. The value will always be returned as UTC time.
    :type start_time: ~datetime.datetime
    :param schedule: Required. Periodic frequency at which timer event needs to be raised. Supports
     daily, hourly, minutes, and seconds.
    :type schedule: str
    :param topic: Topic where periodic events are published to IoT device.
    :type topic: str
    """

    _validation = {
        'start_time': {'required': True},
        'schedule': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'schedule': {'key': 'schedule', 'type': 'str'},
        'topic': {'key': 'topic', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_time: datetime.datetime,
        schedule: str,
        topic: Optional[str] = None,
        **kwargs
    ):
        super(PeriodicTimerSourceInfo, self).__init__(**kwargs)
        self.start_time = start_time
        self.schedule = schedule
        self.topic = topic


class RefreshDetails(msrest.serialization.Model):
    """Fields for tracking refresh job on the share or container.

    :param in_progress_refresh_job_id: If a refresh job is currently in progress on this share or
     container, this field indicates the ARM resource ID of that job. The field is empty if no job
     is in progress.
    :type in_progress_refresh_job_id: str
    :param last_completed_refresh_job_time_in_utc: Indicates the completed time for the last
     refresh job on this particular share or container, if any.This could be a failed job or a
     successful job.
    :type last_completed_refresh_job_time_in_utc: ~datetime.datetime
    :param error_manifest_file: Indicates the relative path of the error xml for the last refresh
     job on this particular share or container, if any. This could be a failed job or a successful
     job.
    :type error_manifest_file: str
    :param last_job: Indicates the id of the last refresh job on this particular share or
     container,if any. This could be a failed job or a successful job.
    :type last_job: str
    """

    _attribute_map = {
        'in_progress_refresh_job_id': {'key': 'inProgressRefreshJobId', 'type': 'str'},
        'last_completed_refresh_job_time_in_utc': {'key': 'lastCompletedRefreshJobTimeInUTC', 'type': 'iso-8601'},
        'error_manifest_file': {'key': 'errorManifestFile', 'type': 'str'},
        'last_job': {'key': 'lastJob', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        in_progress_refresh_job_id: Optional[str] = None,
        last_completed_refresh_job_time_in_utc: Optional[datetime.datetime] = None,
        error_manifest_file: Optional[str] = None,
        last_job: Optional[str] = None,
        **kwargs
    ):
        super(RefreshDetails, self).__init__(**kwargs)
        self.in_progress_refresh_job_id = in_progress_refresh_job_id
        self.last_completed_refresh_job_time_in_utc = last_completed_refresh_job_time_in_utc
        self.error_manifest_file = error_manifest_file
        self.last_job = last_job


class ResourceIdentity(msrest.serialization.Model):
    """Msi identity details of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type: Identity type. Possible values include: "None", "SystemAssigned", "UserAssigned".
    :type type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.MsiIdentityType
    :ivar principal_id: Service Principal Id backing the Msi.
    :vartype principal_id: str
    :ivar tenant_id: Home Tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "MsiIdentityType"]] = None,
        **kwargs
    ):
        super(ResourceIdentity, self).__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None


class ResourceMoveDetails(msrest.serialization.Model):
    """Fields for tracking resource move.

    :param operation_in_progress: Denotes whether move operation is in progress. Possible values
     include: "None", "ResourceMoveInProgress", "ResourceMoveFailed".
    :type operation_in_progress: str or
     ~azure.mgmt.databoxedge.v2020_09_01.models.ResourceMoveStatus
    :param operation_in_progress_lock_timeout_in_utc: Denotes the timeout of the operation to
     finish.
    :type operation_in_progress_lock_timeout_in_utc: ~datetime.datetime
    """

    _attribute_map = {
        'operation_in_progress': {'key': 'operationInProgress', 'type': 'str'},
        'operation_in_progress_lock_timeout_in_utc': {'key': 'operationInProgressLockTimeoutInUTC', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        operation_in_progress: Optional[Union[str, "ResourceMoveStatus"]] = None,
        operation_in_progress_lock_timeout_in_utc: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(ResourceMoveDetails, self).__init__(**kwargs)
        self.operation_in_progress = operation_in_progress
        self.operation_in_progress_lock_timeout_in_utc = operation_in_progress_lock_timeout_in_utc


class ResourceTypeSku(msrest.serialization.Model):
    """Resource type Sku object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The resource type.
    :vartype resource_type: str
    :ivar skus: The skus.
    :vartype skus: list[~azure.mgmt.databoxedge.v2020_09_01.models.SkuInformation]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'skus': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'skus': {'key': 'skus', 'type': '[SkuInformation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceTypeSku, self).__init__(**kwargs)
        self.resource_type = None
        self.skus = None


class RoleList(msrest.serialization.Model):
    """Collection of all the roles on the Data Box Edge device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The Value.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.Role]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Role]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class RoleSinkInfo(msrest.serialization.Model):
    """Compute role against which events will be raised.

    All required parameters must be populated in order to send to Azure.

    :param role_id: Required. Compute role ID.
    :type role_id: str
    """

    _validation = {
        'role_id': {'required': True},
    }

    _attribute_map = {
        'role_id': {'key': 'roleId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        role_id: str,
        **kwargs
    ):
        super(RoleSinkInfo, self).__init__(**kwargs)
        self.role_id = role_id


class SecuritySettings(ARMBaseModel):
    """The security settings of a device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param device_admin_password: Required. Device administrator password as an encrypted string
     (encrypted using RSA PKCS #1) is used to sign into the  local web UI of the device. The Actual
     password should have at least 8 characters that are a combination of  uppercase, lowercase,
     numeric, and special characters.
    :type device_admin_password:
     ~azure.mgmt.databoxedge.v2020_09_01.models.AsymmetricEncryptedSecret
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'device_admin_password': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'device_admin_password': {'key': 'properties.deviceAdminPassword', 'type': 'AsymmetricEncryptedSecret'},
    }

    def __init__(
        self,
        *,
        device_admin_password: "AsymmetricEncryptedSecret",
        **kwargs
    ):
        super(SecuritySettings, self).__init__(**kwargs)
        self.device_admin_password = device_admin_password


class ServiceSpecification(msrest.serialization.Model):
    """Service specification.

    :param metric_specifications: Metric specification as defined by shoebox.
    :type metric_specifications:
     list[~azure.mgmt.databoxedge.v2020_09_01.models.MetricSpecificationV1]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecificationV1]'},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["MetricSpecificationV1"]] = None,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class Share(ARMBaseModel):
    """Represents a share on the  Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Share on ASE device.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param description: Description for the share.
    :type description: str
    :param share_status: Required. Current status of the share. Possible values include: "Offline",
     "Unknown", "OK", "Updating", "NeedsAttention".
    :type share_status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.ShareStatus
    :param monitoring_status: Required. Current monitoring status of the share. Possible values
     include: "Enabled", "Disabled".
    :type monitoring_status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.MonitoringStatus
    :param azure_container_info: Azure container mapping for the share.
    :type azure_container_info: ~azure.mgmt.databoxedge.v2020_09_01.models.AzureContainerInfo
    :param access_protocol: Required. Access protocol to be used by the share. Possible values
     include: "SMB", "NFS".
    :type access_protocol: str or ~azure.mgmt.databoxedge.v2020_09_01.models.ShareAccessProtocol
    :param user_access_rights: Mapping of users and corresponding access rights on the share
     (required for SMB protocol).
    :type user_access_rights: list[~azure.mgmt.databoxedge.v2020_09_01.models.UserAccessRight]
    :param client_access_rights: List of IP addresses and corresponding access rights on the
     share(required for NFS protocol).
    :type client_access_rights: list[~azure.mgmt.databoxedge.v2020_09_01.models.ClientAccessRight]
    :param refresh_details: Details of the refresh job on this share.
    :type refresh_details: ~azure.mgmt.databoxedge.v2020_09_01.models.RefreshDetails
    :ivar share_mappings: Share mount point to the role.
    :vartype share_mappings: list[~azure.mgmt.databoxedge.v2020_09_01.models.MountPointMap]
    :param data_policy: Data policy of the share. Possible values include: "Cloud", "Local".
    :type data_policy: str or ~azure.mgmt.databoxedge.v2020_09_01.models.DataPolicy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'share_status': {'required': True},
        'monitoring_status': {'required': True},
        'access_protocol': {'required': True},
        'share_mappings': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'share_status': {'key': 'properties.shareStatus', 'type': 'str'},
        'monitoring_status': {'key': 'properties.monitoringStatus', 'type': 'str'},
        'azure_container_info': {'key': 'properties.azureContainerInfo', 'type': 'AzureContainerInfo'},
        'access_protocol': {'key': 'properties.accessProtocol', 'type': 'str'},
        'user_access_rights': {'key': 'properties.userAccessRights', 'type': '[UserAccessRight]'},
        'client_access_rights': {'key': 'properties.clientAccessRights', 'type': '[ClientAccessRight]'},
        'refresh_details': {'key': 'properties.refreshDetails', 'type': 'RefreshDetails'},
        'share_mappings': {'key': 'properties.shareMappings', 'type': '[MountPointMap]'},
        'data_policy': {'key': 'properties.dataPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        share_status: Union[str, "ShareStatus"],
        monitoring_status: Union[str, "MonitoringStatus"],
        access_protocol: Union[str, "ShareAccessProtocol"],
        description: Optional[str] = None,
        azure_container_info: Optional["AzureContainerInfo"] = None,
        user_access_rights: Optional[List["UserAccessRight"]] = None,
        client_access_rights: Optional[List["ClientAccessRight"]] = None,
        refresh_details: Optional["RefreshDetails"] = None,
        data_policy: Optional[Union[str, "DataPolicy"]] = None,
        **kwargs
    ):
        super(Share, self).__init__(**kwargs)
        self.system_data = None
        self.description = description
        self.share_status = share_status
        self.monitoring_status = monitoring_status
        self.azure_container_info = azure_container_info
        self.access_protocol = access_protocol
        self.user_access_rights = user_access_rights
        self.client_access_rights = client_access_rights
        self.refresh_details = refresh_details
        self.share_mappings = None
        self.data_policy = data_policy


class ShareAccessRight(msrest.serialization.Model):
    """Specifies the mapping between this particular user and the type of access he has on shares on this device.

    All required parameters must be populated in order to send to Azure.

    :param share_id: Required. The share ID.
    :type share_id: str
    :param access_type: Required. Type of access to be allowed on the share for this user. Possible
     values include: "Change", "Read", "Custom".
    :type access_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.ShareAccessType
    """

    _validation = {
        'share_id': {'required': True},
        'access_type': {'required': True},
    }

    _attribute_map = {
        'share_id': {'key': 'shareId', 'type': 'str'},
        'access_type': {'key': 'accessType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        share_id: str,
        access_type: Union[str, "ShareAccessType"],
        **kwargs
    ):
        super(ShareAccessRight, self).__init__(**kwargs)
        self.share_id = share_id
        self.access_type = access_type


class ShareList(msrest.serialization.Model):
    """Collection of all the shares on the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of shares.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.Share]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Share]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ShareList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Sku(msrest.serialization.Model):
    """The SKU type.

    :param name: SKU name. Possible values include: "Gateway", "Edge", "TEA_1Node",
     "TEA_1Node_UPS", "TEA_1Node_Heater", "TEA_1Node_UPS_Heater", "TEA_4Node_Heater",
     "TEA_4Node_UPS_Heater", "TMA", "TDC", "TCA_Small", "GPU", "TCA_Large", "EdgeP_Base",
     "EdgeP_High", "EdgePR_Base", "EdgePR_Base_UPS", "EdgeMR_Mini", "RCA_Small", "RCA_Large", "RDC".
    :type name: str or ~azure.mgmt.databoxedge.v2020_09_01.models.SkuName
    :param tier: The SKU tier. This is based on the SKU name. Possible values include: "Standard".
    :type tier: str or ~azure.mgmt.databoxedge.v2020_09_01.models.SkuTier
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "SkuName"]] = None,
        tier: Optional[Union[str, "SkuTier"]] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier


class SkuCost(msrest.serialization.Model):
    """The metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_id: Used for querying price from commerce.
    :vartype meter_id: str
    :ivar quantity: The cost quantity.
    :vartype quantity: long
    :ivar extended_unit: The extended unit.
    :vartype extended_unit: str
    """

    _validation = {
        'meter_id': {'readonly': True},
        'quantity': {'readonly': True},
        'extended_unit': {'readonly': True},
    }

    _attribute_map = {
        'meter_id': {'key': 'meterId', 'type': 'str'},
        'quantity': {'key': 'quantity', 'type': 'long'},
        'extended_unit': {'key': 'extendedUnit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuCost, self).__init__(**kwargs)
        self.meter_id = None
        self.quantity = None
        self.extended_unit = None


class SkuInformation(msrest.serialization.Model):
    """Sku information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: The sku tier.
    :vartype tier: str
    :ivar kind: The sku kind.
    :vartype kind: str
    :ivar family: The Sku family.
    :vartype family: str
    :ivar costs: The pricing info of the Sku.
    :vartype costs: list[~azure.mgmt.databoxedge.v2020_09_01.models.SkuCost]
    :ivar locations: The locations where Sku is available.
    :vartype locations: list[str]
    :ivar location_info: The locations where Sku is available with zones and sites info.
    :vartype location_info: list[~azure.mgmt.databoxedge.v2020_09_01.models.SkuLocationInfo]
    :ivar required_quota_ids: The required quotaIds for the sku to be available.
    :vartype required_quota_ids: list[str]
    :ivar required_features: The required features for the sku to be available.
    :vartype required_features: list[str]
    """

    _validation = {
        'name': {'readonly': True},
        'tier': {'readonly': True},
        'kind': {'readonly': True},
        'family': {'readonly': True},
        'costs': {'readonly': True},
        'locations': {'readonly': True},
        'location_info': {'readonly': True},
        'required_quota_ids': {'readonly': True},
        'required_features': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'costs': {'key': 'costs', 'type': '[SkuCost]'},
        'locations': {'key': 'locations', 'type': '[str]'},
        'location_info': {'key': 'locationInfo', 'type': '[SkuLocationInfo]'},
        'required_quota_ids': {'key': 'requiredQuotaIds', 'type': '[str]'},
        'required_features': {'key': 'requiredFeatures', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuInformation, self).__init__(**kwargs)
        self.name = None
        self.tier = None
        self.kind = None
        self.family = None
        self.costs = None
        self.locations = None
        self.location_info = None
        self.required_quota_ids = None
        self.required_features = None


class SkuInformationList(msrest.serialization.Model):
    """List of SKU Information objects.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of ResourceTypeSku objects.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.ResourceTypeSku]
    :ivar next_link: Links to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceTypeSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuInformationList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SkuLocationInfo(msrest.serialization.Model):
    """The location info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: The location.
    :vartype location: str
    :ivar zones: The zones.
    :vartype zones: list[str]
    :ivar sites: The sites.
    :vartype sites: list[str]
    """

    _validation = {
        'location': {'readonly': True},
        'zones': {'readonly': True},
        'sites': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'sites': {'key': 'sites', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuLocationInfo, self).__init__(**kwargs)
        self.location = None
        self.zones = None
        self.sites = None


class StorageAccount(ARMBaseModel):
    """Represents a Storage Account on the  Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: StorageAccount object on ASE device.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param description: Description for the storage Account.
    :type description: str
    :param storage_account_status: Current status of the storage account. Possible values include:
     "OK", "Offline", "Unknown", "Updating", "NeedsAttention".
    :type storage_account_status: str or
     ~azure.mgmt.databoxedge.v2020_09_01.models.StorageAccountStatus
    :param data_policy: Required. Data policy of the storage Account. Possible values include:
     "Cloud", "Local".
    :type data_policy: str or ~azure.mgmt.databoxedge.v2020_09_01.models.DataPolicy
    :param storage_account_credential_id: Storage Account Credential Id.
    :type storage_account_credential_id: str
    :ivar blob_endpoint: BlobEndpoint of Storage Account.
    :vartype blob_endpoint: str
    :ivar container_count: The Container Count. Present only for Storage Accounts with DataPolicy
     set to Cloud.
    :vartype container_count: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'data_policy': {'required': True},
        'blob_endpoint': {'readonly': True},
        'container_count': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'storage_account_status': {'key': 'properties.storageAccountStatus', 'type': 'str'},
        'data_policy': {'key': 'properties.dataPolicy', 'type': 'str'},
        'storage_account_credential_id': {'key': 'properties.storageAccountCredentialId', 'type': 'str'},
        'blob_endpoint': {'key': 'properties.blobEndpoint', 'type': 'str'},
        'container_count': {'key': 'properties.containerCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        data_policy: Union[str, "DataPolicy"],
        description: Optional[str] = None,
        storage_account_status: Optional[Union[str, "StorageAccountStatus"]] = None,
        storage_account_credential_id: Optional[str] = None,
        **kwargs
    ):
        super(StorageAccount, self).__init__(**kwargs)
        self.system_data = None
        self.description = description
        self.storage_account_status = storage_account_status
        self.data_policy = data_policy
        self.storage_account_credential_id = storage_account_credential_id
        self.blob_endpoint = None
        self.container_count = None


class StorageAccountCredential(ARMBaseModel):
    """The storage account credential.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: StorageAccountCredential object.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param alias: Required. Alias for the storage account.
    :type alias: str
    :param user_name: Username for the storage account.
    :type user_name: str
    :param account_key: Encrypted storage key.
    :type account_key: ~azure.mgmt.databoxedge.v2020_09_01.models.AsymmetricEncryptedSecret
    :param connection_string: Connection string for the storage account. Use this string if
     username and account key are not specified.
    :type connection_string: str
    :param ssl_status: Required. Signifies whether SSL needs to be enabled or not. Possible values
     include: "Enabled", "Disabled".
    :type ssl_status: str or ~azure.mgmt.databoxedge.v2020_09_01.models.SSLStatus
    :param blob_domain_name: Blob end point for private clouds.
    :type blob_domain_name: str
    :param account_type: Required. Type of storage accessed on the storage account. Possible values
     include: "GeneralPurposeStorage", "BlobStorage".
    :type account_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.AccountType
    :param storage_account_id: Id of the storage account.
    :type storage_account_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'alias': {'required': True},
        'ssl_status': {'required': True},
        'account_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'alias': {'key': 'properties.alias', 'type': 'str'},
        'user_name': {'key': 'properties.userName', 'type': 'str'},
        'account_key': {'key': 'properties.accountKey', 'type': 'AsymmetricEncryptedSecret'},
        'connection_string': {'key': 'properties.connectionString', 'type': 'str'},
        'ssl_status': {'key': 'properties.sslStatus', 'type': 'str'},
        'blob_domain_name': {'key': 'properties.blobDomainName', 'type': 'str'},
        'account_type': {'key': 'properties.accountType', 'type': 'str'},
        'storage_account_id': {'key': 'properties.storageAccountId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        alias: str,
        ssl_status: Union[str, "SSLStatus"],
        account_type: Union[str, "AccountType"],
        user_name: Optional[str] = None,
        account_key: Optional["AsymmetricEncryptedSecret"] = None,
        connection_string: Optional[str] = None,
        blob_domain_name: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        **kwargs
    ):
        super(StorageAccountCredential, self).__init__(**kwargs)
        self.system_data = None
        self.alias = alias
        self.user_name = user_name
        self.account_key = account_key
        self.connection_string = connection_string
        self.ssl_status = ssl_status
        self.blob_domain_name = blob_domain_name
        self.account_type = account_type
        self.storage_account_id = storage_account_id


class StorageAccountCredentialList(msrest.serialization.Model):
    """The collection of storage account credentials.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The value.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.StorageAccountCredential]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StorageAccountCredential]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountCredentialList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class StorageAccountList(msrest.serialization.Model):
    """Collection of all the Storage Accounts on the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of storageAccounts.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.StorageAccount]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StorageAccount]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageAccountList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class SubscriptionRegisteredFeatures(msrest.serialization.Model):
    """SubscriptionRegisteredFeatures.

    :param name:
    :type name: str
    :param state:
    :type state: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        state: Optional[str] = None,
        **kwargs
    ):
        super(SubscriptionRegisteredFeatures, self).__init__(**kwargs)
        self.name = name
        self.state = state


class SymmetricKey(msrest.serialization.Model):
    """Symmetric key for authentication.

    :param connection_string: Connection string based on the symmetric key.
    :type connection_string: ~azure.mgmt.databoxedge.v2020_09_01.models.AsymmetricEncryptedSecret
    """

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'AsymmetricEncryptedSecret'},
    }

    def __init__(
        self,
        *,
        connection_string: Optional["AsymmetricEncryptedSecret"] = None,
        **kwargs
    ):
        super(SymmetricKey, self).__init__(**kwargs)
        self.connection_string = connection_string


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.CreatedByType
    :param last_modified_at: The type of identity that last modified the resource.
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TrackingInfo(msrest.serialization.Model):
    """Tracking courier information.

    :param serial_number: Serial number of the device being tracked.
    :type serial_number: str
    :param carrier_name: Name of the carrier used in the delivery.
    :type carrier_name: str
    :param tracking_id: Tracking ID of the shipment.
    :type tracking_id: str
    :param tracking_url: Tracking URL of the shipment.
    :type tracking_url: str
    """

    _attribute_map = {
        'serial_number': {'key': 'serialNumber', 'type': 'str'},
        'carrier_name': {'key': 'carrierName', 'type': 'str'},
        'tracking_id': {'key': 'trackingId', 'type': 'str'},
        'tracking_url': {'key': 'trackingUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        serial_number: Optional[str] = None,
        carrier_name: Optional[str] = None,
        tracking_id: Optional[str] = None,
        tracking_url: Optional[str] = None,
        **kwargs
    ):
        super(TrackingInfo, self).__init__(**kwargs)
        self.serial_number = serial_number
        self.carrier_name = carrier_name
        self.tracking_id = tracking_id
        self.tracking_url = tracking_url


class TriggerList(msrest.serialization.Model):
    """Collection of all trigger on the data box edge device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of triggers.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.Trigger]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Trigger]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggerList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class UpdateDownloadProgress(msrest.serialization.Model):
    """Details about the download progress of update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar download_phase: The download phase. Possible values include: "Unknown", "Initializing",
     "Downloading", "Verifying".
    :vartype download_phase: str or ~azure.mgmt.databoxedge.v2020_09_01.models.DownloadPhase
    :ivar percent_complete: Percentage of completion.
    :vartype percent_complete: int
    :ivar total_bytes_to_download: Total bytes to download.
    :vartype total_bytes_to_download: float
    :ivar total_bytes_downloaded: Total bytes downloaded.
    :vartype total_bytes_downloaded: float
    :ivar number_of_updates_to_download: Number of updates to download.
    :vartype number_of_updates_to_download: int
    :ivar number_of_updates_downloaded: Number of updates downloaded.
    :vartype number_of_updates_downloaded: int
    """

    _validation = {
        'download_phase': {'readonly': True},
        'percent_complete': {'readonly': True},
        'total_bytes_to_download': {'readonly': True},
        'total_bytes_downloaded': {'readonly': True},
        'number_of_updates_to_download': {'readonly': True},
        'number_of_updates_downloaded': {'readonly': True},
    }

    _attribute_map = {
        'download_phase': {'key': 'downloadPhase', 'type': 'str'},
        'percent_complete': {'key': 'percentComplete', 'type': 'int'},
        'total_bytes_to_download': {'key': 'totalBytesToDownload', 'type': 'float'},
        'total_bytes_downloaded': {'key': 'totalBytesDownloaded', 'type': 'float'},
        'number_of_updates_to_download': {'key': 'numberOfUpdatesToDownload', 'type': 'int'},
        'number_of_updates_downloaded': {'key': 'numberOfUpdatesDownloaded', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateDownloadProgress, self).__init__(**kwargs)
        self.download_phase = None
        self.percent_complete = None
        self.total_bytes_to_download = None
        self.total_bytes_downloaded = None
        self.number_of_updates_to_download = None
        self.number_of_updates_downloaded = None


class UpdateInstallProgress(msrest.serialization.Model):
    """Progress details during installation of updates.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar percent_complete: Percentage completed.
    :vartype percent_complete: int
    :ivar number_of_updates_to_install: Number of updates to install.
    :vartype number_of_updates_to_install: int
    :ivar number_of_updates_installed: Number of updates installed.
    :vartype number_of_updates_installed: int
    """

    _validation = {
        'percent_complete': {'readonly': True},
        'number_of_updates_to_install': {'readonly': True},
        'number_of_updates_installed': {'readonly': True},
    }

    _attribute_map = {
        'percent_complete': {'key': 'percentComplete', 'type': 'int'},
        'number_of_updates_to_install': {'key': 'numberOfUpdatesToInstall', 'type': 'int'},
        'number_of_updates_installed': {'key': 'numberOfUpdatesInstalled', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateInstallProgress, self).__init__(**kwargs)
        self.percent_complete = None
        self.number_of_updates_to_install = None
        self.number_of_updates_installed = None


class UpdateSummary(ARMBaseModel):
    """Details about ongoing updates and availability of updates on the device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :param device_version_number: The current version of the device in format: 1.2.17312.13.",.
    :type device_version_number: str
    :param friendly_device_version_name: The current version of the device in text format.
    :type friendly_device_version_name: str
    :param device_last_scanned_date_time: The last time when a scan was done on the device.
    :type device_last_scanned_date_time: ~datetime.datetime
    :param last_completed_scan_job_date_time: The time when the last scan job was completed
     (success/cancelled/failed) on the appliance.
    :type last_completed_scan_job_date_time: ~datetime.datetime
    :ivar last_completed_download_job_date_time: The time when the last Download job was completed
     (success/cancelled/failed) on the appliance.
    :vartype last_completed_download_job_date_time: ~datetime.datetime
    :ivar last_completed_install_job_date_time: The time when the last Install job was completed
     (success/cancelled/failed) on the appliance.
    :vartype last_completed_install_job_date_time: ~datetime.datetime
    :ivar total_number_of_updates_available: The number of updates available for the current device
     version as per the last device scan.
    :vartype total_number_of_updates_available: int
    :ivar total_number_of_updates_pending_download: The total number of items pending download.
    :vartype total_number_of_updates_pending_download: int
    :ivar total_number_of_updates_pending_install: The total number of items pending install.
    :vartype total_number_of_updates_pending_install: int
    :ivar reboot_behavior: Indicates if updates are available and at least one of the updates needs
     a reboot. Possible values include: "NeverReboots", "RequiresReboot", "RequestReboot".
    :vartype reboot_behavior: str or
     ~azure.mgmt.databoxedge.v2020_09_01.models.InstallRebootBehavior
    :ivar ongoing_update_operation: The current update operation. Possible values include: "None",
     "Scan", "Download", "Install".
    :vartype ongoing_update_operation: str or
     ~azure.mgmt.databoxedge.v2020_09_01.models.UpdateOperation
    :ivar in_progress_download_job_id: The job ID of the download job in progress.
    :vartype in_progress_download_job_id: str
    :ivar in_progress_install_job_id: The job ID of the install job in progress.
    :vartype in_progress_install_job_id: str
    :ivar in_progress_download_job_started_date_time: The time when the currently running download
     (if any) started.
    :vartype in_progress_download_job_started_date_time: ~datetime.datetime
    :ivar in_progress_install_job_started_date_time: The time when the currently running install
     (if any) started.
    :vartype in_progress_install_job_started_date_time: ~datetime.datetime
    :ivar update_titles: The list of updates available for install.
    :vartype update_titles: list[str]
    :ivar total_update_size_in_bytes: The total size of updates available for download in bytes.
    :vartype total_update_size_in_bytes: float
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_completed_download_job_date_time': {'readonly': True},
        'last_completed_install_job_date_time': {'readonly': True},
        'total_number_of_updates_available': {'readonly': True},
        'total_number_of_updates_pending_download': {'readonly': True},
        'total_number_of_updates_pending_install': {'readonly': True},
        'reboot_behavior': {'readonly': True},
        'ongoing_update_operation': {'readonly': True},
        'in_progress_download_job_id': {'readonly': True},
        'in_progress_install_job_id': {'readonly': True},
        'in_progress_download_job_started_date_time': {'readonly': True},
        'in_progress_install_job_started_date_time': {'readonly': True},
        'update_titles': {'readonly': True},
        'total_update_size_in_bytes': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'device_version_number': {'key': 'properties.deviceVersionNumber', 'type': 'str'},
        'friendly_device_version_name': {'key': 'properties.friendlyDeviceVersionName', 'type': 'str'},
        'device_last_scanned_date_time': {'key': 'properties.deviceLastScannedDateTime', 'type': 'iso-8601'},
        'last_completed_scan_job_date_time': {'key': 'properties.lastCompletedScanJobDateTime', 'type': 'iso-8601'},
        'last_completed_download_job_date_time': {'key': 'properties.lastCompletedDownloadJobDateTime', 'type': 'iso-8601'},
        'last_completed_install_job_date_time': {'key': 'properties.lastCompletedInstallJobDateTime', 'type': 'iso-8601'},
        'total_number_of_updates_available': {'key': 'properties.totalNumberOfUpdatesAvailable', 'type': 'int'},
        'total_number_of_updates_pending_download': {'key': 'properties.totalNumberOfUpdatesPendingDownload', 'type': 'int'},
        'total_number_of_updates_pending_install': {'key': 'properties.totalNumberOfUpdatesPendingInstall', 'type': 'int'},
        'reboot_behavior': {'key': 'properties.rebootBehavior', 'type': 'str'},
        'ongoing_update_operation': {'key': 'properties.ongoingUpdateOperation', 'type': 'str'},
        'in_progress_download_job_id': {'key': 'properties.inProgressDownloadJobId', 'type': 'str'},
        'in_progress_install_job_id': {'key': 'properties.inProgressInstallJobId', 'type': 'str'},
        'in_progress_download_job_started_date_time': {'key': 'properties.inProgressDownloadJobStartedDateTime', 'type': 'iso-8601'},
        'in_progress_install_job_started_date_time': {'key': 'properties.inProgressInstallJobStartedDateTime', 'type': 'iso-8601'},
        'update_titles': {'key': 'properties.updateTitles', 'type': '[str]'},
        'total_update_size_in_bytes': {'key': 'properties.totalUpdateSizeInBytes', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        device_version_number: Optional[str] = None,
        friendly_device_version_name: Optional[str] = None,
        device_last_scanned_date_time: Optional[datetime.datetime] = None,
        last_completed_scan_job_date_time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(UpdateSummary, self).__init__(**kwargs)
        self.device_version_number = device_version_number
        self.friendly_device_version_name = friendly_device_version_name
        self.device_last_scanned_date_time = device_last_scanned_date_time
        self.last_completed_scan_job_date_time = last_completed_scan_job_date_time
        self.last_completed_download_job_date_time = None
        self.last_completed_install_job_date_time = None
        self.total_number_of_updates_available = None
        self.total_number_of_updates_pending_download = None
        self.total_number_of_updates_pending_install = None
        self.reboot_behavior = None
        self.ongoing_update_operation = None
        self.in_progress_download_job_id = None
        self.in_progress_install_job_id = None
        self.in_progress_download_job_started_date_time = None
        self.in_progress_install_job_started_date_time = None
        self.update_titles = None
        self.total_update_size_in_bytes = None


class UploadCertificateRequest(msrest.serialization.Model):
    """The upload certificate request.

    All required parameters must be populated in order to send to Azure.

    :param authentication_type: The authentication type. Possible values include: "Invalid",
     "AzureActiveDirectory".
    :type authentication_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.AuthenticationType
    :param certificate: Required. The base64 encoded certificate raw data.
    :type certificate: str
    """

    _validation = {
        'certificate': {'required': True},
    }

    _attribute_map = {
        'authentication_type': {'key': 'properties.authenticationType', 'type': 'str'},
        'certificate': {'key': 'properties.certificate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate: str,
        authentication_type: Optional[Union[str, "AuthenticationType"]] = None,
        **kwargs
    ):
        super(UploadCertificateRequest, self).__init__(**kwargs)
        self.authentication_type = authentication_type
        self.certificate = certificate


class UploadCertificateResponse(msrest.serialization.Model):
    """The upload registration certificate response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param auth_type: Specifies authentication type. Possible values include: "Invalid",
     "AzureActiveDirectory".
    :type auth_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.AuthenticationType
    :ivar resource_id: The resource ID of the Data Box Edge/Gateway device.
    :vartype resource_id: str
    :ivar aad_authority: Azure Active Directory tenant authority.
    :vartype aad_authority: str
    :ivar aad_tenant_id: Azure Active Directory tenant ID.
    :vartype aad_tenant_id: str
    :ivar service_principal_client_id: Azure Active Directory service principal client ID.
    :vartype service_principal_client_id: str
    :ivar service_principal_object_id: Azure Active Directory service principal object ID.
    :vartype service_principal_object_id: str
    :ivar azure_management_endpoint_audience: The azure management endpoint audience.
    :vartype azure_management_endpoint_audience: str
    :ivar aad_audience: Identifier of the target resource that is the recipient of the requested
     token.
    :vartype aad_audience: str
    """

    _validation = {
        'resource_id': {'readonly': True},
        'aad_authority': {'readonly': True},
        'aad_tenant_id': {'readonly': True},
        'service_principal_client_id': {'readonly': True},
        'service_principal_object_id': {'readonly': True},
        'azure_management_endpoint_audience': {'readonly': True},
        'aad_audience': {'readonly': True},
    }

    _attribute_map = {
        'auth_type': {'key': 'authType', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'aad_authority': {'key': 'aadAuthority', 'type': 'str'},
        'aad_tenant_id': {'key': 'aadTenantId', 'type': 'str'},
        'service_principal_client_id': {'key': 'servicePrincipalClientId', 'type': 'str'},
        'service_principal_object_id': {'key': 'servicePrincipalObjectId', 'type': 'str'},
        'azure_management_endpoint_audience': {'key': 'azureManagementEndpointAudience', 'type': 'str'},
        'aad_audience': {'key': 'aadAudience', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        auth_type: Optional[Union[str, "AuthenticationType"]] = None,
        **kwargs
    ):
        super(UploadCertificateResponse, self).__init__(**kwargs)
        self.auth_type = auth_type
        self.resource_id = None
        self.aad_authority = None
        self.aad_tenant_id = None
        self.service_principal_client_id = None
        self.service_principal_object_id = None
        self.azure_management_endpoint_audience = None
        self.aad_audience = None


class User(ARMBaseModel):
    """Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: User in DataBoxEdge Resource.
    :vartype system_data: ~azure.mgmt.databoxedge.v2020_09_01.models.SystemData
    :param encrypted_password: The password details.
    :type encrypted_password: ~azure.mgmt.databoxedge.v2020_09_01.models.AsymmetricEncryptedSecret
    :ivar share_access_rights: List of shares that the user has rights on. This field should not be
     specified during user creation.
    :vartype share_access_rights: list[~azure.mgmt.databoxedge.v2020_09_01.models.ShareAccessRight]
    :param user_type: Type of the user. Possible values include: "Share", "LocalManagement", "ARM".
    :type user_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.UserType
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'share_access_rights': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'encrypted_password': {'key': 'properties.encryptedPassword', 'type': 'AsymmetricEncryptedSecret'},
        'share_access_rights': {'key': 'properties.shareAccessRights', 'type': '[ShareAccessRight]'},
        'user_type': {'key': 'properties.userType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        encrypted_password: Optional["AsymmetricEncryptedSecret"] = None,
        user_type: Optional[Union[str, "UserType"]] = None,
        **kwargs
    ):
        super(User, self).__init__(**kwargs)
        self.system_data = None
        self.encrypted_password = encrypted_password
        self.share_access_rights = None
        self.user_type = user_type


class UserAccessRight(msrest.serialization.Model):
    """The mapping between a particular user and the access type on the SMB share.

    All required parameters must be populated in order to send to Azure.

    :param user_id: Required. User ID (already existing in the device).
    :type user_id: str
    :param access_type: Required. Type of access to be allowed for the user. Possible values
     include: "Change", "Read", "Custom".
    :type access_type: str or ~azure.mgmt.databoxedge.v2020_09_01.models.ShareAccessType
    """

    _validation = {
        'user_id': {'required': True},
        'access_type': {'required': True},
    }

    _attribute_map = {
        'user_id': {'key': 'userId', 'type': 'str'},
        'access_type': {'key': 'accessType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_id: str,
        access_type: Union[str, "ShareAccessType"],
        **kwargs
    ):
        super(UserAccessRight, self).__init__(**kwargs)
        self.user_id = user_id
        self.access_type = access_type


class UserList(msrest.serialization.Model):
    """Collection of users.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of users.
    :vartype value: list[~azure.mgmt.databoxedge.v2020_09_01.models.User]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[User]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserList, self).__init__(**kwargs)
        self.value = None
        self.next_link = None
