/*
 * Decompiled with CFR 0.152.
 */
package com.ceph.fs;

import com.ceph.crush.Bucket;
import com.ceph.fs.CephFileExtent;
import com.ceph.fs.CephMount;
import com.ceph.fs.CephNotDirectoryException;
import com.ceph.fs.CephPoolException;
import com.ceph.fs.CephStat;
import com.ceph.fs.CephStatVFS;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.UUID;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CephMountTest {
    private static CephMount mount;
    private static String basedir;

    @BeforeClass
    public static void setup() throws Exception {
        mount = new CephMount("admin");
        String string = System.getProperty("CEPH_CONF_FILE");
        if (string != null) {
            mount.conf_read_file(string);
        }
        mount.conf_set("client_permissions", "0");
        mount.mount(null);
        basedir = "/libcephfs_junit_" + UUID.randomUUID();
        mount.mkdir(basedir, 511);
    }

    @AfterClass
    public static void destroy() throws Exception {
        String[] stringArray;
        for (String string : stringArray = mount.listdir(basedir)) {
            System.out.println(string);
        }
        mount.rmdir(basedir);
        mount.unmount();
    }

    public String makePath() {
        String string = basedir + "/" + UUID.randomUUID();
        return string;
    }

    public String getRootPoolName() throws Exception {
        int n = mount.open("/", 128, 384);
        String string = mount.get_file_pool_name(n);
        mount.close(n);
        return string;
    }

    public int createFile(String string, int n) throws Exception {
        int n2 = mount.open(string, 10, 384);
        byte[] byArray = new byte[4096];
        int n3 = n;
        while (n3 > 0) {
            n = Math.min(byArray.length, n3);
            long l = mount.write(n2, byArray, (long)n, -1L);
            n3 = (int)((long)n3 - l);
        }
        return n2;
    }

    public int createFile(int n) throws Exception {
        return this.createFile(this.makePath(), n);
    }

    @Test(expected=FileNotFoundException.class)
    public void test_mount_dne() throws Exception {
        CephMount cephMount = new CephMount("admin");
        String string = System.getProperty("CEPH_CONF_FILE");
        if (string != null) {
            cephMount.conf_read_file(string);
        }
        cephMount.mount("/wlfkjwlekfjwlejfwe");
        cephMount.unmount();
    }

    @Test
    public void test_conf_read_file_dne() throws Exception {
    }

    @Test
    public void test_conf_read_file_invalid() throws Exception {
    }

    @Test(expected=NullPointerException.class)
    public void test_conf_read_file_null() throws Exception {
        mount.conf_read_file(null);
    }

    @Test(expected=NullPointerException.class)
    public void test_conf_set_null_opt() throws Exception {
        mount.conf_set(null, "value");
    }

    @Test(expected=NullPointerException.class)
    public void test_conf_set_null_val() throws Exception {
        mount.conf_set("option", null);
    }

    @Test(expected=NullPointerException.class)
    public void test_conf_get_null_opt() throws Exception {
        mount.conf_get(null);
    }

    @Test
    public void test_conf() throws Exception {
        String string = "log to stderr";
        String string2 = mount.conf_get(string);
        String string3 = string2.compareTo("true") == 0 ? "false" : "true";
        mount.conf_set(string, string3);
        String string4 = mount.conf_get(string);
        Assert.assertTrue((string4.compareTo(string3) == 0 ? 1 : 0) != 0);
        mount.conf_set(string, string2);
        string4 = mount.conf_get(string);
        Assert.assertTrue((string4.compareTo(string2) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_statfs() throws Exception {
        CephStatVFS cephStatVFS = new CephStatVFS();
        mount.statfs("/", cephStatVFS);
        Assert.assertTrue((cephStatVFS.bsize > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cephStatVFS.frsize > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cephStatVFS.blocks > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cephStatVFS.bavail > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cephStatVFS.namemax > 0L ? 1 : 0) != 0);
    }

    @Test
    public void test_getcwd() throws Exception {
        mount.chdir(basedir);
        String string = mount.getcwd();
        Assert.assertTrue((string.compareTo(basedir) == 0 ? 1 : 0) != 0);
        mount.chdir("/");
        string = mount.getcwd();
        Assert.assertTrue((string.compareTo("/") == 0 ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void test_chdir_null() throws Exception {
        mount.chdir(null);
    }

    @Test(expected=FileNotFoundException.class)
    public void test_chdir_dne() throws Exception {
        mount.chdir("/this/path/does/not/exist/");
    }

    @Test
    public void test_chdir_not_dir() throws Exception {
        String string = this.makePath();
        int n = this.createFile(string, 1);
        mount.close(n);
        mount.unlink(string);
        mount.chdir("/");
    }

    @Test(expected=NullPointerException.class)
    public void test_listdir_null() throws Exception {
        mount.listdir(null);
    }

    @Test(expected=FileNotFoundException.class)
    public void test_listdir_dne() throws Exception {
        mount.listdir("/this/path/does/not/exist/");
    }

    @Test(expected=IOException.class)
    public void test_listdir_not_dir() throws Exception {
        String string = this.makePath();
        int n = this.createFile(string, 1);
        mount.close(n);
        try {
            mount.listdir(string);
        }
        finally {
            mount.unlink(string);
        }
    }

    @Test
    public void test_listdir() throws Exception {
        int n;
        String string = this.makePath();
        mount.mkdir(string, 511);
        String[] stringArray = mount.listdir(string);
        Assert.assertTrue((stringArray.length == 0 ? 1 : 0) != 0);
        for (n = 0; n < 3; ++n) {
            mount.mkdir(string + "/" + n, 777);
        }
        stringArray = mount.listdir(string);
        Assert.assertTrue((stringArray.length == 3 ? 1 : 0) != 0);
        for (n = 0; n < 30; ++n) {
            mount.mkdir(string + "/x" + n, 777);
        }
        stringArray = mount.listdir(string);
        Assert.assertTrue((stringArray.length == 33 ? 1 : 0) != 0);
        for (n = 0; n < 30; ++n) {
            mount.rmdir(string + "/x" + n);
        }
        for (n = 0; n < 3; ++n) {
            mount.rmdir(string + "/" + n);
        }
        mount.rmdir(string);
    }

    @Test(expected=NullPointerException.class)
    public void test_rename_null_from() throws Exception {
        mount.rename(null, "to");
    }

    @Test(expected=NullPointerException.class)
    public void test_rename_null_to() throws Exception {
        mount.rename("from", null);
    }

    @Test(expected=FileNotFoundException.class)
    public void test_rename_dne() throws Exception {
        mount.rename("/this/doesnt/exist", "/this/neither");
    }

    @Test
    public void test_rename() throws Exception {
        String string = this.makePath();
        int n = this.createFile(string, 1);
        mount.close(n);
        String string2 = this.makePath();
        mount.rename(string, string2);
        CephStat cephStat = new CephStat();
        mount.lstat(string2, cephStat);
        Assert.assertTrue((cephStat.size == 1L ? 1 : 0) != 0);
        mount.unlink(string2);
    }

    @Test(expected=IOException.class)
    public void test_mkdir_exists() throws Exception {
        String string = this.makePath();
        mount.mkdir(string, 511);
        try {
            mount.mkdir(string, 511);
        }
        finally {
            mount.rmdir(string);
        }
    }

    @Test(expected=IOException.class)
    public void test_mkdirs_exists() throws Exception {
        String string = this.makePath();
        mount.mkdirs(string, 511);
        try {
            mount.mkdirs(string, 511);
        }
        finally {
            mount.rmdir(string);
        }
    }

    @Test
    public void test_mkdir() throws Exception {
        String string = this.makePath();
        mount.mkdir(string, 511);
        CephStat cephStat = new CephStat();
        mount.lstat(string, cephStat);
        Assert.assertTrue((boolean)cephStat.isDir());
        mount.rmdir(string);
    }

    @Test
    public void test_mkdirs() throws Exception {
        String string = this.makePath();
        mount.mkdirs(string + "/x/y", 511);
        CephStat cephStat = new CephStat();
        mount.lstat(string, cephStat);
        Assert.assertTrue((boolean)cephStat.isDir());
        mount.lstat(string + "/x", cephStat);
        Assert.assertTrue((boolean)cephStat.isDir());
        mount.lstat(string + "/x/y", cephStat);
        Assert.assertTrue((boolean)cephStat.isDir());
        mount.rmdir(string + "/x/y");
        mount.rmdir(string + "/x");
        mount.rmdir(string);
    }

    @Test(expected=FileNotFoundException.class)
    public void test_rmdir() throws Exception {
        String string = this.makePath();
        mount.mkdir(string, 511);
        CephStat cephStat = new CephStat();
        mount.lstat(string, cephStat);
        Assert.assertTrue((boolean)cephStat.isDir());
        mount.rmdir(string);
        mount.lstat(string, cephStat);
    }

    @Test
    public void test_symlink() throws Exception {
        String string = this.makePath();
        String string2 = this.makePath();
        mount.symlink(string, string2);
        CephStat cephStat = new CephStat();
        mount.lstat(string2, cephStat);
        Assert.assertTrue((boolean)cephStat.isSymlink());
        String string3 = mount.readlink(string2);
        Assert.assertTrue((string3.compareTo(string) == 0 ? 1 : 0) != 0);
        mount.unlink(string2);
    }

    @Test(expected=NullPointerException.class)
    public void test_lstat_null_path() throws Exception {
        mount.lstat(null, new CephStat());
    }

    @Test(expected=NullPointerException.class)
    public void test_lstat_null_stat() throws Exception {
        mount.lstat("/path", null);
    }

    @Test(expected=FileNotFoundException.class)
    public void test_lstat_null_dne() throws Exception {
        mount.lstat("/path/does/not/exist", new CephStat());
    }

    @Test
    public void test_stat() throws Exception {
        String string = this.makePath();
        int n = 12345;
        int n2 = this.createFile(string, n);
        mount.close(n2);
        CephStat cephStat = new CephStat();
        mount.lstat(string, cephStat);
        Assert.assertTrue((cephStat.size == (long)n ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.blksize > 0L ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.blocks > 0L ? 1 : 0) != 0);
        CephStat cephStat2 = new CephStat();
        mount.stat(string, cephStat2);
        CephStat cephStat3 = new CephStat();
        n2 = mount.open(string, 2, 0);
        mount.fstat(n2, cephStat3);
        mount.close(n2);
        mount.unlink(string);
        Assert.assertTrue((cephStat.mode == cephStat3.mode ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.uid == cephStat3.uid ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.gid == cephStat3.gid ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.size == cephStat3.size ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.blksize == cephStat3.blksize ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.blocks == cephStat3.blocks ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.mode == cephStat2.mode ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.uid == cephStat2.uid ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.gid == cephStat2.gid ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.size == cephStat2.size ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.blksize == cephStat2.blksize ? 1 : 0) != 0);
        Assert.assertTrue((cephStat.blocks == cephStat2.blocks ? 1 : 0) != 0);
    }

    @Test(expected=NullPointerException.class)
    public void test_stat_null_path() throws Exception {
        mount.stat(null, new CephStat());
    }

    @Test(expected=NullPointerException.class)
    public void test_stat_null_stat() throws Exception {
        mount.stat("/path", null);
    }

    @Test(expected=FileNotFoundException.class)
    public void test_stat_null_dne() throws Exception {
        mount.stat("/path/does/not/exist", new CephStat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=CephNotDirectoryException.class)
    public void test_enotdir() throws Exception {
        String string = this.makePath();
        int n = this.createFile(string, 1);
        mount.close(n);
        try {
            CephStat cephStat = new CephStat();
            mount.lstat(string + "/blah", cephStat);
        }
        finally {
            mount.unlink(string);
        }
    }

    @Test(expected=NullPointerException.class)
    public void test_setattr_null_path() throws Exception {
        mount.setattr(null, new CephStat(), 0);
    }

    @Test(expected=NullPointerException.class)
    public void test_setattr_null_stat() throws Exception {
        mount.setattr("/path", null, 0);
    }

    @Test(expected=FileNotFoundException.class)
    public void test_setattr_dne() throws Exception {
        mount.setattr("/path/does/not/exist", new CephStat(), 0);
    }

    @Test
    public void test_setattr() throws Exception {
        String string = this.makePath();
        int n = this.createFile(string, 1);
        mount.close(n);
        CephStat cephStat = new CephStat();
        mount.lstat(string, cephStat);
        ++cephStat.uid;
        ++cephStat.gid;
        mount.setattr(string, cephStat, 2 | 4);
        CephStat cephStat2 = new CephStat();
        mount.lstat(string, cephStat2);
        Assert.assertTrue((cephStat2.uid == cephStat.uid ? 1 : 0) != 0);
        Assert.assertTrue((cephStat2.gid == cephStat.gid ? 1 : 0) != 0);
        mount.unlink(string);
    }

    @Test(expected=NullPointerException.class)
    public void test_chmod_null_path() throws Exception {
        mount.chmod(null, 0);
    }

    @Test(expected=FileNotFoundException.class)
    public void test_chmod_dne() throws Exception {
        mount.chmod("/path/does/not/exist", 0);
    }

    @Test
    public void test_chmod() throws Exception {
        String string = this.makePath();
        int n = this.createFile(string, 1);
        mount.close(n);
        CephStat cephStat = new CephStat();
        mount.lstat(string, cephStat);
        int n2 = cephStat.mode;
        n2 = (n2 & 1) != 0 ? --n2 : ++n2;
        mount.chmod(string, n2);
        CephStat cephStat2 = new CephStat();
        mount.lstat(string, cephStat2);
        Assert.assertTrue((cephStat2.mode == n2 ? 1 : 0) != 0);
        mount.unlink(string);
    }

    @Test
    public void test_fchmod() throws Exception {
        String string = this.makePath();
        int n = this.createFile(string, 1);
        CephStat cephStat = new CephStat();
        mount.lstat(string, cephStat);
        int n2 = cephStat.mode;
        n2 = (n2 & 1) != 0 ? --n2 : ++n2;
        mount.fchmod(n, n2);
        mount.close(n);
        CephStat cephStat2 = new CephStat();
        mount.lstat(string, cephStat2);
        Assert.assertTrue((cephStat2.mode == n2 ? 1 : 0) != 0);
        mount.unlink(string);
    }

    @Test(expected=FileNotFoundException.class)
    public void test_truncate_dne() throws Exception {
        mount.truncate("/path/does/not/exist", 0L);
    }

    @Test(expected=NullPointerException.class)
    public void test_truncate_null_path() throws Exception {
        mount.truncate(null, 0L);
    }

    @Test
    public void test_truncate() throws Exception {
        String string = this.makePath();
        int n = 1398331;
        int n2 = this.createFile(string, n);
        mount.close(n2);
        CephStat cephStat = new CephStat();
        mount.lstat(string, cephStat);
        Assert.assertTrue((cephStat.size == (long)n ? 1 : 0) != 0);
        int n3 = 333333;
        mount.truncate(string, (long)n3);
        mount.lstat(string, cephStat);
        Assert.assertTrue((cephStat.size == (long)n3 ? 1 : 0) != 0);
        n2 = mount.open(string, 2, 0);
        mount.fstat(n2, cephStat);
        Assert.assertTrue((cephStat.size == (long)n3 ? 1 : 0) != 0);
        mount.close(n2);
        mount.unlink(string);
    }

    @Test
    public void test_open_layout() throws Exception {
        String string = this.makePath();
        int n = mount.open(string, 72, 0, 0x100000, 1, 0x100000, null);
        mount.close(n);
        mount.unlink(string);
    }

    @Test(expected=FileNotFoundException.class)
    public void test_open_dne() throws Exception {
        mount.open("/path/doesnt/exist", 0, 0);
    }

    @Test
    public void test_lseek() throws Exception {
        String string = this.makePath();
        int n = 12345;
        int n2 = this.createFile(string, n);
        mount.close(n2);
        n2 = mount.open(string, 2, 0);
        long l = mount.lseek(n2, 0L, 3);
        mount.close(n2);
        mount.unlink(string);
        Assert.assertTrue((n == (int)l ? 1 : 0) != 0);
    }

    @Test
    public void test_read() throws Exception {
        byte[] byArray;
        String string = this.makePath();
        int n = this.createFile(string, 1500);
        long l = mount.read(n, byArray = new byte[1500], 1500L, 0L);
        Assert.assertTrue((l == 1500L ? 1 : 0) != 0);
        mount.unlink(string);
    }

    @Test
    public void test_ftruncate() throws Exception {
        String string = this.makePath();
        int n = 1398331;
        int n2 = this.createFile(string, n);
        CephStat cephStat = new CephStat();
        mount.fstat(n2, cephStat);
        Assert.assertTrue((cephStat.size == (long)n ? 1 : 0) != 0);
        int n3 = 333333;
        mount.ftruncate(n2, (long)n3);
        mount.fstat(n2, cephStat);
        if (cephStat.size != (long)n3) {
            System.err.println("ftruncate error: st.size=" + cephStat.size + " crop_size=" + n3);
            Assert.assertTrue((boolean)false);
        }
        Assert.assertTrue((cephStat.size == (long)n3 ? 1 : 0) != 0);
        mount.close(n2);
        n2 = mount.open(string, 2, 0);
        mount.fstat(n2, cephStat);
        Assert.assertTrue((cephStat.size == (long)n3 ? 1 : 0) != 0);
        mount.close(n2);
        mount.unlink(string);
    }

    @Test
    public void test_fsync() throws Exception {
        String string = this.makePath();
        int n = this.createFile(string, 123);
        mount.fsync(n, false);
        mount.fsync(n, true);
        mount.close(n);
        mount.unlink(string);
    }

    @Test
    public void test_flock() throws Exception {
        String string = this.makePath();
        int n = this.createFile(string, 123);
        mount.flock(n, 5, 42L);
        mount.flock(n, 5, 43L);
        mount.flock(n, 8, 42L);
        mount.flock(n, 8, 43L);
        mount.flock(n, 6, 42L);
        try {
            mount.flock(n, 5, 43L);
            Assert.assertTrue((boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            mount.flock(n, 6, 43L);
            Assert.assertTrue((boolean)false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        mount.flock(n, 1, 42L);
        mount.flock(n, 1, 43L);
        mount.flock(n, 8, 42L);
        mount.flock(n, 8, 43L);
        mount.close(n);
        mount.unlink(string);
    }

    @Test
    public void test_sync_fs() throws Exception {
        mount.sync_fs();
    }

    @Test
    public void test_xattr() throws Exception {
        String string5;
        String string2 = this.makePath();
        int n = this.createFile(string2, 123);
        mount.close(n);
        String string3 = "This is a new xattr";
        String string4 = "This is a different xattr";
        byte[] byArray = string3.getBytes();
        byte[] byArray2 = string4.getBytes();
        mount.setxattr(string2, "user.attr1", byArray, (long)byArray.length, 1);
        mount.setxattr(string2, "user.attr2", byArray2, (long)byArray2.length, 1);
        String[] stringArray = mount.listxattr(string2);
        Assert.assertTrue((stringArray.length == 2 ? 1 : 0) != 0);
        int n2 = 0;
        for (String string5 : stringArray) {
            if (string5.compareTo("user.attr1") == 0) {
                ++n2;
                continue;
            }
            if (string5.compareTo("user.attr2") == 0) {
                ++n2;
                continue;
            }
            System.out.println("found unwanted xattr: " + string5);
        }
        Assert.assertTrue((n2 == 2 ? 1 : 0) != 0);
        long l = mount.getxattr(string2, "user.attr1", null);
        byte[] byArray3 = new byte[(int)l];
        mount.getxattr(string2, "user.attr1", byArray3);
        string5 = new String(byArray3);
        Assert.assertTrue((string5.compareTo(string3) == 0 ? 1 : 0) != 0);
        byArray3 = new byte[byArray2.length];
        mount.getxattr(string2, "user.attr2", byArray3);
        string5 = new String(byArray3);
        Assert.assertTrue((string5.compareTo(string4) == 0 ? 1 : 0) != 0);
        mount.unlink(string2);
    }

    @Test
    public void test_get_stripe_unit() throws Exception {
        String string = this.makePath();
        int n = this.createFile(string, 1);
        Assert.assertTrue((mount.get_file_stripe_unit(n) > 0 ? 1 : 0) != 0);
        mount.close(n);
        mount.unlink(string);
    }

    @Test
    public void test_get_repl() throws Exception {
        String string = this.makePath();
        int n = this.createFile(string, 1);
        Assert.assertTrue((mount.get_file_replication(n) > 0 ? 1 : 0) != 0);
        mount.close(n);
        mount.unlink(string);
    }

    @Test
    public void test_get_stripe_unit_gran() throws Exception {
        Assert.assertTrue((mount.get_stripe_unit_granularity() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_get_pool_id() throws Exception {
        String string = this.getRootPoolName();
        Assert.assertTrue((mount.get_pool_id(string) >= 0 ? 1 : 0) != 0);
        try {
            mount.get_pool_id("asdlfkjlsejflkjef");
            Assert.assertTrue((boolean)false);
        }
        catch (CephPoolException cephPoolException) {
            // empty catch block
        }
    }

    @Test
    public void test_get_pool_replication() throws Exception {
        try {
            mount.get_pool_replication(-1);
            Assert.assertTrue((boolean)false);
        }
        catch (CephPoolException cephPoolException) {
            // empty catch block
        }
        String string = this.getRootPoolName();
        int n = mount.get_pool_id(string);
        Assert.assertTrue((n >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((mount.get_pool_replication(n) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void test_get_file_pool_name() throws Exception {
        String string = this.getRootPoolName();
        String string2 = this.makePath();
        int n = this.createFile(string2, 1);
        String string3 = mount.get_file_pool_name(n);
        mount.close(n);
        Assert.assertTrue((string3 != null ? 1 : 0) != 0);
        Assert.assertTrue((string3.compareTo(string) == 0 ? 1 : 0) != 0);
        mount.unlink(string2);
    }

    @Test(expected=IOException.class)
    public void test_get_file_pool_name_ebadf() throws Exception {
        String string = mount.get_file_pool_name(-40);
    }

    @Test
    public void test_get_file_extent() throws Exception {
        int n = 262144;
        String string = this.makePath();
        int n2 = mount.open(string, 72, 0, n, 2, n * 2, null);
        CephFileExtent cephFileExtent = mount.get_file_extent(n2, 0L);
        Assert.assertTrue((cephFileExtent.getOSDs().length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((cephFileExtent.getOffset() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((cephFileExtent.getLength() == (long)n ? 1 : 0) != 0);
        cephFileExtent = mount.get_file_extent(n2, (long)(n / 2));
        Assert.assertTrue((cephFileExtent.getOffset() == (long)(n / 2) ? 1 : 0) != 0);
        Assert.assertTrue((cephFileExtent.getLength() == (long)(n / 2) ? 1 : 0) != 0);
        cephFileExtent = mount.get_file_extent(n2, (long)(3 * n / 2 - 1));
        Assert.assertTrue((cephFileExtent.getOffset() == (long)(3 * n / 2 - 1) ? 1 : 0) != 0);
        Assert.assertTrue((cephFileExtent.getLength() == (long)(n / 2 + 1) ? 1 : 0) != 0);
        cephFileExtent = mount.get_file_extent(n2, (long)(3 * n / 2 + 1));
        Assert.assertTrue((cephFileExtent.getLength() == (long)(n / 2 - 1) ? 1 : 0) != 0);
        mount.close(n2);
        mount.unlink(string);
    }

    @Test
    public void test_get_osd_crush_location() throws Exception {
        Bucket[] bucketArray = mount.get_osd_crush_location(0);
        Assert.assertTrue((bucketArray.length > 0 ? 1 : 0) != 0);
        for (Bucket bucket : bucketArray) {
            Assert.assertTrue((bucket.getType().length() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((bucket.getName().length() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void test_get_osd_address() throws Exception {
        InetAddress inetAddress = mount.get_osd_address(0);
        Assert.assertTrue((inetAddress.getHostAddress().length() > 0 ? 1 : 0) != 0);
    }

    static {
        basedir = null;
    }
}

