/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class DeclareIndependenceMessage
extends AttributeMessage {
    public static final String TAG = "declareIndependence";
    private static final String COUNTRY_NAME_TAG = "countryName";
    private static final String NATION_NAME_TAG = "nationName";

    public DeclareIndependenceMessage(String nationName, String countryName) {
        super(TAG, NATION_NAME_TAG, nationName, COUNTRY_NAME_TAG, countryName);
    }

    public DeclareIndependenceMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, NATION_NAME_TAG, COUNTRY_NAME_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        String nationName = this.getStringAttribute(NATION_NAME_TAG);
        String countryName = this.getStringAttribute(COUNTRY_NAME_TAG);
        if (nationName == null || nationName.isEmpty()) {
            return serverPlayer.clientError("Empty nation name.");
        }
        if (countryName == null || countryName.isEmpty()) {
            return serverPlayer.clientError("Empty country name.");
        }
        StringTemplate problem = serverPlayer.checkDeclareIndependence();
        if (problem != null) {
            return serverPlayer.clientError("Declaration blocked");
        }
        return this.igc(freeColServer).declareIndependence(serverPlayer, nationName, countryName);
    }
}

