/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Ber;
import com.sun.jndi.ldap.BerDecoder;
import com.sun.jndi.ldap.BerEncoder;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapRequest;
import com.sun.jndi.ldap.Obj;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import javax.naming.CommunicationException;
import javax.naming.InterruptedNamingException;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;

public final class Connection
implements Runnable {
    private static final boolean debug = false;
    private static final int dump = 0;
    private final Thread worker;
    private boolean v3 = true;
    public final String host;
    public final int port;
    private boolean bound = false;
    private OutputStream traceFile = null;
    private String traceTagIn = null;
    private String traceTagOut = null;
    public InputStream inStream;
    public OutputStream outStream;
    public Socket sock;
    private final LdapClient parent;
    private int outMsgId = 0;
    private LdapRequest pendingRequests = null;
    volatile IOException closureReason = null;
    volatile boolean useable = true;
    int readTimeout;
    int connectTimeout;
    private volatile boolean isUpgradedToStartTls;
    final Object startTlsLock = new Object();
    private static final boolean IS_HOSTNAME_VERIFICATION_DISABLED = Connection.hostnameVerificationDisabledValue();
    private final Object pauseLock = new Object();
    private boolean paused = false;

    private static boolean hostnameVerificationDisabledValue() {
        PrivilegedAction<String> privilegedAction = () -> System.getProperty("com.sun.jndi.ldap.object.disableEndpointIdentification");
        String string = AccessController.doPrivileged(privilegedAction);
        if (string == null) {
            return false;
        }
        return string.isEmpty() ? true : Boolean.parseBoolean(string);
    }

    void setV3(boolean bl) {
        this.v3 = bl;
    }

    void setBound() {
        this.bound = true;
    }

    Connection(LdapClient ldapClient, String string, int n, String string2, int n2, int n3, OutputStream outputStream) throws NamingException {
        this.host = string;
        this.port = n;
        this.parent = ldapClient;
        this.readTimeout = n3;
        this.connectTimeout = n2;
        if (outputStream != null) {
            this.traceFile = outputStream;
            this.traceTagIn = "<- " + string + ":" + n + "\n\n";
            this.traceTagOut = "-> " + string + ":" + n + "\n\n";
        }
        try {
            this.sock = this.createSocket(string, n, string2, n2);
            this.inStream = new BufferedInputStream(this.sock.getInputStream());
            this.outStream = new BufferedOutputStream(this.sock.getOutputStream());
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            CommunicationException communicationException = new CommunicationException(string + ":" + n);
            communicationException.setRootCause(throwable);
            throw communicationException;
        }
        catch (Exception exception) {
            CommunicationException communicationException = new CommunicationException(string + ":" + n);
            communicationException.setRootCause(exception);
            throw communicationException;
        }
        this.worker = Obj.helper.createThread(this);
        this.worker.setDaemon(true);
        this.worker.start();
    }

    private Object createInetSocketAddress(String string, int n) throws NoSuchMethodException {
        try {
            Class<?> clazz = Class.forName("java.net.InetSocketAddress");
            Constructor<?> constructor = clazz.getConstructor(String.class, Integer.TYPE);
            return constructor.newInstance(string, new Integer(n));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
            throw new NoSuchMethodException();
        }
    }

    private Socket createSocket(String string, int n, String string2, int n2) throws Exception {
        Object object;
        Object object2;
        Socket socket = null;
        if (string2 != null) {
            object2 = Obj.helper.loadClass(string2);
            object = ((Class)object2).getMethod("getDefault", new Class[0]);
            Object object3 = ((Method)object).invoke(null, new Object[0]);
            Method method = null;
            if (n2 > 0) {
                try {
                    method = ((Class)object2).getMethod("createSocket", new Class[0]);
                    Method method2 = Socket.class.getMethod("connect", Class.forName("java.net.SocketAddress"), Integer.TYPE);
                    Object object4 = this.createInetSocketAddress(string, n);
                    socket = (Socket)method.invoke(object3, new Object[0]);
                    method2.invoke(socket, object4, new Integer(n2));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (socket == null) {
                method = ((Class)object2).getMethod("createSocket", String.class, Integer.TYPE);
                socket = (Socket)method.invoke(object3, string, new Integer(n));
            }
        } else {
            if (n2 > 0) {
                try {
                    object2 = Socket.class.getConstructor(new Class[0]);
                    object = Socket.class.getMethod("connect", Class.forName("java.net.SocketAddress"), Integer.TYPE);
                    Object object5 = this.createInetSocketAddress(string, n);
                    socket = (Socket)((Constructor)object2).newInstance(new Object[0]);
                    ((Method)object).invoke(socket, object5, new Integer(n2));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (socket == null) {
                socket = new Socket(string, n);
            }
        }
        if (socket instanceof SSLSocket) {
            object2 = (SSLSocket)socket;
            if (!IS_HOSTNAME_VERIFICATION_DISABLED) {
                object = ((SSLSocket)object2).getSSLParameters();
                ((SSLParameters)object).setEndpointIdentificationAlgorithm("LDAPS");
                ((SSLSocket)object2).setSSLParameters((SSLParameters)object);
            }
            if (n2 > 0) {
                int n3 = ((Socket)object2).getSoTimeout();
                ((Socket)object2).setSoTimeout(n2);
                ((SSLSocket)object2).startHandshake();
                ((Socket)object2).setSoTimeout(n3);
            }
        }
        return socket;
    }

    synchronized int getMsgId() {
        return ++this.outMsgId;
    }

    LdapRequest writeRequest(BerEncoder berEncoder, int n) throws IOException {
        return this.writeRequest(berEncoder, n, false, -1);
    }

    LdapRequest writeRequest(BerEncoder berEncoder, int n, boolean bl) throws IOException {
        return this.writeRequest(berEncoder, n, bl, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LdapRequest writeRequest(BerEncoder berEncoder, int n, boolean bl, int n2) throws IOException {
        LdapRequest ldapRequest = new LdapRequest(n, bl, n2);
        this.addRequest(ldapRequest);
        if (this.traceFile != null) {
            Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
        }
        this.unpauseReader();
        try {
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            this.cleanup(null, true);
            this.closureReason = iOException;
            throw this.closureReason;
        }
        return ldapRequest;
    }

    BerDecoder readReply(LdapRequest ldapRequest) throws IOException, NamingException {
        BerDecoder berDecoder;
        NamingException namingException = null;
        try {
            berDecoder = ldapRequest.getReplyBer(this.readTimeout);
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedNamingException("Interrupted during LDAP operation");
        }
        catch (CommunicationException communicationException) {
            throw communicationException;
        }
        catch (NamingException namingException2) {
            namingException = namingException2;
            berDecoder = null;
        }
        if (berDecoder == null) {
            this.abandonRequest(ldapRequest, null);
        }
        if (namingException != null) {
            throw namingException;
        }
        return berDecoder;
    }

    private synchronized void addRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        if (ldapRequest2 == null) {
            this.pendingRequests = ldapRequest;
            ldapRequest.next = null;
        } else {
            ldapRequest.next = this.pendingRequests;
            this.pendingRequests = ldapRequest;
        }
    }

    synchronized LdapRequest findRequest(int n) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            if (ldapRequest.msgId == n) {
                return ldapRequest;
            }
            ldapRequest = ldapRequest.next;
        }
        return null;
    }

    synchronized void removeRequest(LdapRequest ldapRequest) {
        LdapRequest ldapRequest2 = this.pendingRequests;
        LdapRequest ldapRequest3 = null;
        while (ldapRequest2 != null) {
            if (ldapRequest2 == ldapRequest) {
                ldapRequest2.cancel();
                if (ldapRequest3 != null) {
                    ldapRequest3.next = ldapRequest2.next;
                } else {
                    this.pendingRequests = ldapRequest2.next;
                }
                ldapRequest2.next = null;
            }
            ldapRequest3 = ldapRequest2;
            ldapRequest2 = ldapRequest2.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abandonRequest(LdapRequest ldapRequest, Control[] controlArray) {
        this.removeRequest(ldapRequest);
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeInt(ldapRequest.msgId, 80);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void abandonOutstandingReqs(Control[] controlArray) {
        LdapRequest ldapRequest = this.pendingRequests;
        while (ldapRequest != null) {
            this.abandonRequest(ldapRequest, controlArray);
            this.pendingRequests = ldapRequest = ldapRequest.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ldapUnbind(Control[] controlArray) {
        BerEncoder berEncoder = new BerEncoder(256);
        int n = this.getMsgId();
        try {
            berEncoder.beginSeq(48);
            berEncoder.encodeInt(n);
            berEncoder.encodeByte(66);
            berEncoder.encodeByte(0);
            if (this.v3) {
                LdapClient.encodeControls(berEncoder, controlArray);
            }
            berEncoder.endSeq();
            if (this.traceFile != null) {
                Ber.dumpBER(this.traceFile, this.traceTagOut, berEncoder.getBuf(), 0, berEncoder.getDataLen());
            }
            Connection connection = this;
            synchronized (connection) {
                this.outStream.write(berEncoder.getBuf(), 0, berEncoder.getDataLen());
                this.outStream.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void cleanup(Control[] controlArray, boolean bl) {
        boolean bl2 = false;
        Connection connection = this;
        synchronized (connection) {
            LdapRequest ldapRequest;
            block18: {
                block19: {
                    block17: {
                        this.useable = false;
                        if (this.sock == null) break block18;
                        if (!bl) {
                            this.abandonOutstandingReqs(controlArray);
                        }
                        if (!this.bound) break block17;
                        this.ldapUnbind(controlArray);
                    }
                    try {
                        this.outStream.flush();
                        this.sock.close();
                        this.unpauseReader();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!bl) {
                        ldapRequest = this.pendingRequests;
                        while (ldapRequest != null) {
                            ldapRequest.cancel();
                            ldapRequest = ldapRequest.next;
                        }
                    }
                    break block19;
                    catch (Throwable throwable) {
                        try {
                            this.outStream.flush();
                            this.sock.close();
                            this.unpauseReader();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (!bl) {
                            LdapRequest ldapRequest2 = this.pendingRequests;
                            while (ldapRequest2 != null) {
                                ldapRequest2.cancel();
                                ldapRequest2 = ldapRequest2.next;
                            }
                        }
                        this.sock = null;
                        throw throwable;
                    }
                }
                this.sock = null;
                bl2 = bl;
            }
            if (bl2) {
                ldapRequest = this.pendingRequests;
                while (ldapRequest != null) {
                    ldapRequest.close();
                    ldapRequest = ldapRequest.next;
                }
            }
        }
        if (bl2) {
            this.parent.processConnectionClosure();
        }
    }

    public synchronized void replaceStreams(InputStream inputStream, OutputStream outputStream) {
        this.inStream = inputStream;
        try {
            this.outStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.outStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void replaceStreams(InputStream inputStream, OutputStream outputStream, boolean bl) {
        Object object = this.startTlsLock;
        synchronized (object) {
            this.replaceStreams(inputStream, outputStream);
            this.isUpgradedToStartTls = bl;
        }
    }

    public boolean isUpgradedToStartTls() {
        return this.isUpgradedToStartTls;
    }

    private synchronized InputStream getInputStream() {
        return this.inStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpauseReader() throws IOException {
        Object object = this.pauseLock;
        synchronized (object) {
            if (this.paused) {
                this.paused = false;
                this.pauseLock.notify();
            }
        }
    }

    private void pauseReader() throws IOException {
        this.paused = true;
        try {
            while (this.paused) {
                this.pauseLock.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("Pause/unpause reader has problems.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block28: {
            InputStream inputStream = null;
            block12: while (true) {
                try {
                    while (true) {
                        try {
                            while (true) {
                                byte[] byArray = new byte[129];
                                int n = 0;
                                int n2 = 0;
                                int n3 = 0;
                                inputStream = this.getInputStream();
                                int n4 = inputStream.read(byArray, n, 1);
                                if (n4 < 0) {
                                    if (inputStream != this.getInputStream()) {
                                        continue;
                                    }
                                    break block28;
                                }
                                if (byArray[n++] != 48) continue;
                                n4 = inputStream.read(byArray, n, 1);
                                if (n4 < 0) {
                                    break block28;
                                }
                                if (((n2 = byArray[n++]) & 0x80) == 128) {
                                    int n5;
                                    n3 = n2 & 0x7F;
                                    if (n3 > 4) {
                                        throw new IOException("Length coded with too many bytes: " + n3);
                                    }
                                    boolean bl = false;
                                    for (n4 = 0; n4 < n3; n4 += n5) {
                                        n5 = inputStream.read(byArray, n + n4, n3 - n4);
                                        if (n5 >= 0) continue;
                                        bl = true;
                                        break;
                                    }
                                    if (bl) {
                                        break block28;
                                    }
                                    n2 = 0;
                                    for (int i = 0; i < n3; ++i) {
                                        n2 = (n2 << 8) + (byArray[n + i] & 0xFF);
                                    }
                                    n += n4;
                                }
                                if (n3 > n4) {
                                    throw new IOException("Unexpected EOF while reading length");
                                }
                                if (n2 < 0) {
                                    throw new IOException("Length too big: " + ((long)n2 & 0xFFFFFFFFL));
                                }
                                byte[] byArray2 = Connection.readFully(inputStream, n2);
                                byArray = Arrays.copyOf(byArray, n + byArray2.length);
                                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
                                n += byArray2.length;
                                try {
                                    BerDecoder berDecoder = new BerDecoder(byArray, 0, n);
                                    if (this.traceFile != null) {
                                        Ber.dumpBER(this.traceFile, this.traceTagIn, byArray, 0, n);
                                    }
                                    berDecoder.parseSeq(null);
                                    int n6 = berDecoder.parseInt();
                                    berDecoder.reset();
                                    boolean bl = false;
                                    if (n6 == 0) {
                                        this.parent.processUnsolicited(berDecoder);
                                        continue block12;
                                    }
                                    LdapRequest ldapRequest = this.findRequest(n6);
                                    if (ldapRequest == null) continue block12;
                                    Object object = this.pauseLock;
                                    synchronized (object) {
                                        bl = ldapRequest.addReplyBer(berDecoder);
                                        if (bl) {
                                            this.pauseReader();
                                        }
                                        continue block12;
                                    }
                                }
                                catch (Ber.DecodeException decodeException) {
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (IOException iOException) {
                            if (inputStream != this.getInputStream()) continue;
                            throw iOException;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    this.closureReason = iOException;
                    break block28;
                }
            }
            finally {
                this.cleanup(null, true);
            }
        }
    }

    private static byte[] readFully(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[Math.min(n, 8192)];
        for (int i = 0; i < n; i += n2) {
            int n3;
            if (i >= byArray.length) {
                n3 = Math.min(n - i, byArray.length + 8192);
                if (byArray.length < i + n3) {
                    byArray = Arrays.copyOf(byArray, i + n3);
                }
            } else {
                n3 = byArray.length - i;
            }
            if ((n2 = inputStream.read(byArray, i, n3)) >= 0) continue;
            if (byArray.length == i) break;
            byArray = Arrays.copyOf(byArray, i);
            break;
        }
        return byArray;
    }
}

