/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.ui;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.ui.Size2D;
import org.jfree.chart.util.Args;

public enum RectangleAnchor {
    CENTER("RectangleAnchor.CENTER"),
    TOP("RectangleAnchor.TOP"),
    TOP_LEFT("RectangleAnchor.TOP_LEFT"),
    TOP_RIGHT("RectangleAnchor.TOP_RIGHT"),
    BOTTOM("RectangleAnchor.BOTTOM"),
    BOTTOM_LEFT("RectangleAnchor.BOTTOM_LEFT"),
    BOTTOM_RIGHT("RectangleAnchor.BOTTOM_RIGHT"),
    LEFT("RectangleAnchor.LEFT"),
    RIGHT("RectangleAnchor.RIGHT");

    private final String name;

    private RectangleAnchor(String name) {
        this.name = name;
    }

    public Point2D getAnchorPoint(Rectangle2D rectangle) {
        Args.nullNotPermitted(rectangle, "rectangle");
        Point2D.Double result = new Point2D.Double();
        if (this == CENTER) {
            ((Point2D)result).setLocation(rectangle.getCenterX(), rectangle.getCenterY());
        } else if (this == TOP) {
            ((Point2D)result).setLocation(rectangle.getCenterX(), rectangle.getMinY());
        } else if (this == BOTTOM) {
            ((Point2D)result).setLocation(rectangle.getCenterX(), rectangle.getMaxY());
        } else if (this == LEFT) {
            ((Point2D)result).setLocation(rectangle.getMinX(), rectangle.getCenterY());
        } else if (this == RIGHT) {
            ((Point2D)result).setLocation(rectangle.getMaxX(), rectangle.getCenterY());
        } else if (this == TOP_LEFT) {
            ((Point2D)result).setLocation(rectangle.getMinX(), rectangle.getMinY());
        } else if (this == TOP_RIGHT) {
            ((Point2D)result).setLocation(rectangle.getMaxX(), rectangle.getMinY());
        } else if (this == BOTTOM_LEFT) {
            ((Point2D)result).setLocation(rectangle.getMinX(), rectangle.getMaxY());
        } else if (this == BOTTOM_RIGHT) {
            ((Point2D)result).setLocation(rectangle.getMaxX(), rectangle.getMaxY());
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    public static Rectangle2D createRectangle(Size2D dimensions, double anchorX, double anchorY, RectangleAnchor anchor) {
        Rectangle2D.Double result = null;
        double w = dimensions.getWidth();
        double h2 = dimensions.getHeight();
        if (anchor == CENTER) {
            result = new Rectangle2D.Double(anchorX - w / 2.0, anchorY - h2 / 2.0, w, h2);
        } else if (anchor == TOP) {
            result = new Rectangle2D.Double(anchorX - w / 2.0, anchorY, w, h2);
        } else if (anchor == BOTTOM) {
            result = new Rectangle2D.Double(anchorX - w / 2.0, anchorY - h2, w, h2);
        } else if (anchor == LEFT) {
            result = new Rectangle2D.Double(anchorX, anchorY - h2 / 2.0, w, h2);
        } else if (anchor == RIGHT) {
            result = new Rectangle2D.Double(anchorX - w, anchorY - h2 / 2.0, w, h2);
        } else if (anchor == TOP_LEFT) {
            result = new Rectangle2D.Double(anchorX, anchorY, w, h2);
        } else if (anchor == TOP_RIGHT) {
            result = new Rectangle2D.Double(anchorX - w, anchorY, w, h2);
        } else if (anchor == BOTTOM_LEFT) {
            result = new Rectangle2D.Double(anchorX, anchorY - h2, w, h2);
        } else if (anchor == BOTTOM_RIGHT) {
            result = new Rectangle2D.Double(anchorX - w, anchorY - h2, w, h2);
        }
        return result;
    }
}

