/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetInstanceUefiDataResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, GetInstanceUefiDataResponse> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(GetInstanceUefiDataResponse.getter(GetInstanceUefiDataResponse::instanceId)).setter(GetInstanceUefiDataResponse.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> UEFI_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UefiData").getter(GetInstanceUefiDataResponse.getter(GetInstanceUefiDataResponse::uefiData)).setter(GetInstanceUefiDataResponse.setter(Builder::uefiData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UefiData").unmarshallLocationName("uefiData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, UEFI_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetInstanceUefiDataResponse.memberNameToFieldInitializer();
    private final String instanceId;
    private final String uefiData;

    private GetInstanceUefiDataResponse(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.uefiData = builder.uefiData;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String uefiData() {
        return this.uefiData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.uefiData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstanceUefiDataResponse)) {
            return false;
        }
        GetInstanceUefiDataResponse other = (GetInstanceUefiDataResponse)((Object)obj);
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.uefiData(), other.uefiData());
    }

    public final String toString() {
        return ToString.builder((String)"GetInstanceUefiDataResponse").add("InstanceId", (Object)this.instanceId()).add("UefiData", (Object)this.uefiData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "UefiData": {
                return Optional.ofNullable(clazz.cast(this.uefiData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("UefiData", UEFI_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetInstanceUefiDataResponse, T> g) {
        return obj -> g.apply((GetInstanceUefiDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String instanceId;
        private String uefiData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstanceUefiDataResponse model) {
            super(model);
            this.instanceId(model.instanceId);
            this.uefiData(model.uefiData);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getUefiData() {
            return this.uefiData;
        }

        public final void setUefiData(String uefiData) {
            this.uefiData = uefiData;
        }

        @Override
        public final Builder uefiData(String uefiData) {
            this.uefiData = uefiData;
            return this;
        }

        @Override
        public GetInstanceUefiDataResponse build() {
            return new GetInstanceUefiDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetInstanceUefiDataResponse> {
        public Builder instanceId(String var1);

        public Builder uefiData(String var1);
    }
}

